﻿#include	"AjcInternal.h"


#define	INST_ID			0x2BF69CE6
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	コールバック（バイト文字，２分木用文字列キー比較，英大小文字を区別する）									//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlCompXStrA(UX key1, UX key2, UX cbp)
{
	return mbscmp((C_BCP)key1, (C_BCP)key2);
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（バイト文字，２分木用文字列キー比較，英大小文字を区別しない）									//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlCompIStrA(UX key1, UX key2, UX cbp)
{
	return mbsicmp((C_BCP)key1, (C_BCP)key2);
}

//--------------------------------------------------------------------------------------------------------------//
//	コールバック（バイト文字，２分木用文字列キー比較，等しい場合のみ英大小文字を区別する）						//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlCompMStrA(UX key1, UX key2, UX cbp)
{
	int		rc;

	if ((rc = mbsicmp((C_BCP)key1, (C_BCP)key2)) == 0) {
		rc = mbscmp((C_BCP)key1, (C_BCP)key2);
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ワイド文字，２分木用文字列キー比較，英大小文字を区別する）									//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlCompXStrW(UX key1, UX key2, UX cbp)
{
	return wcscmp((WCP)key1, (WCP)key2);
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ワイド文字，２分木用文字列キー比較，英大小文字を区別しない）									//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlCompIStrW(UX key1, UX key2, UX cbp)
{
	return wcsicmp((WCP)key1, (WCP)key2);
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（ワイド文字，２分木用文字列キー比較，等しい場合のみ英大小文字を区別する）						//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlCompMStrW(UX key1, UX key2, UX cbp)
{
	int		rc;

	if ((rc = wcsicmp((WCP)key1, (WCP)key2)) == 0) {
		rc = wcscmp((WCP)key1, (WCP)key2);
	}
	return rc;
}


//==============================================================================================================//
//	文字列プール生成																							//
//																												//
//	引　数	：	AJCSPL_CMPMODE CmpMode	-	文字列の比較モード													//
//											・AJCCMP_IGNORE_WIDTH(=0)	英大小文字を区別しない					//
//											・AJCCMP_EXACT_WIDTH (=1)		〃		区別する					//
//											・AJCCMP_MIX		 (=2)	同一の場合のみ英大小文字を区別する		//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（文字列プールハンドル）															//
//				＝ NULL：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSPL		WINAPI	AjcSplCreateA(EAJCCMPMODE CmpMode)
{
	HAJCSPL	pW = NULL;

	if (pW = (HAJCSPL)AJCMEM(sizeof(AJCSPL))) {
		memset(pW, 0, sizeof(AJCSPL));
		pW->InstID = INST_ID;
		if (!AjcSplSetCompModeA(pW, CmpMode)) {
			free(pW);
			pW = NULL;
		}
	}
	return pW;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSPL		WINAPI	AjcSplCreateW(EAJCCMPMODE CmpMode)
{
	HAJCSPL	pW = NULL;

	if (pW = (HAJCSPL)AJCMEM(sizeof(AJCSPL))) {
		memset(pW, 0, sizeof(AJCSPL));
		pW->InstID = INST_ID;
		if (!AjcSplSetCompModeW(pW, CmpMode)) {
			free(pW);
			pW = NULL;
		}
	}
	return pW;
}

//==============================================================================================================//
//	文字列プール消去																							//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSplDelete(HAJCSPL pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pW->hAvlStr != NULL) rc = AjcAvlDelete(pW->hAvlStr);
		free(pW);
	}
	return rc;
}
//==============================================================================================================//
//	比較モード設定																								//
//																												//
//	引　数	：	pW		-	文字列プールハンドル																//
//				CmpMode	-	文字列の比較モード																	//
//								・AJCCMP_IGNORE_WIDTH	(=0)	英大小文字を区別しない							//
//								・AJCCMP_EXACT_WIDTH  	(=1)		〃		区別する							//
//								・AJCCMP_MIX		 	(=2)	同一の場合のみ英大小文字を区別する				//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSplSetCompModeA(HAJCSPL pW, EAJCCMPMODE CmpMode)
{
	BOOL		rc	 = FALSE;
	HAJCAVL		hAvl = NULL;

	if (IS_MY_INST(pW)) {
		if (CmpMode != AJCCMP_IGNORE_WIDTH && CmpMode != AJCCMP_EXACT_WIDTH && CmpMode != AJCCMP_MIX) {
			CmpMode = AJCSPL_CMP_MIX;
		}
		if (pW->hAvlStr != NULL && pW->CmpMode == CmpMode) {
			rc = TRUE;
		}
		else {
			switch (CmpMode) {
				case AJCCMP_IGNORE_WIDTH:  hAvl = AjcAvlCreate(0, cbAvlCompIStrA, NULL); break;
				case AJCCMP_EXACT_WIDTH:   hAvl = AjcAvlCreate(0, cbAvlCompXStrA, NULL); break;
				case AJCCMP_MIX:		   hAvl = AjcAvlCreate(0, cbAvlCompMStrA, NULL); break;
			}
			if (hAvl != NULL) {
				if (pW->hAvlStr != NULL) {
					AjcAvlDelete(pW->hAvlStr);
				}
				pW->CmpMode 	 = CmpMode;
				pW->fDistinguish = (CmpMode != AJCCMP_IGNORE_WIDTH);
				pW->hAvlStr 	 = hAvl;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSplSetCompModeW(HAJCSPL pW, EAJCCMPMODE CmpMode)
{
	BOOL		rc	 = FALSE;
	HAJCAVL		hAvl = NULL;

	if (IS_MY_INST(pW)) {
		if (CmpMode != AJCCMP_IGNORE_WIDTH && CmpMode != AJCCMP_EXACT_WIDTH && CmpMode != AJCCMP_MIX) {
			CmpMode = AJCSPL_CMP_MIX;
		}
		if (pW->hAvlStr != NULL && pW->CmpMode == CmpMode) {
			rc = TRUE;
		}
		else {
			switch (CmpMode) {
				case AJCCMP_IGNORE_WIDTH:  hAvl = AjcAvlCreate(0, cbAvlCompIStrW, NULL); break;
				case AJCCMP_EXACT_WIDTH:   hAvl = AjcAvlCreate(0, cbAvlCompXStrW, NULL); break;
				case AJCCMP_MIX:		   hAvl = AjcAvlCreate(0, cbAvlCompMStrW, NULL); break;
			}
			if (hAvl != NULL) {
				if (pW->hAvlStr != NULL) {
					AjcAvlDelete(pW->hAvlStr);
				}
				pW->CmpMode 	 = CmpMode;
				pW->fDistinguish = (CmpMode != AJCCMP_IGNORE_WIDTH);
				pW->hAvlStr 	 = hAvl;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	比較モード取得																								//
//																												//
//	引　数	：	pW		-	文字列プールハンドル																//
//																												//
//	戻り値	：	≠-1 : 比較モード																				//
//				＝-1 : エラー																					//
//==============================================================================================================//
AJCEXPORT	EAJCCMPMODE	WINAPI	AjcSplGetCompMode(HAJCSPL pW)
{
	EAJCCMPMODE	rc = (EAJCCMPMODE)-1;

	if (IS_MY_INST(pW)) {
		rc = pW->CmpMode;
	}
	return rc;
}

//==============================================================================================================//
//	文字列登録																									//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//				pStr			-	登録する文字列																//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（登録した文字列のアドレス）														//
//				＝ NULL：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP		WINAPI	AjcSplRegistA(HAJCSPL pW, C_BCP pStr)
{
	C_BCP	rc = NULL;
	UX		data;

	if (IS_MY_INST(pW) && pStr != NULL) {
		if (rc = (C_BCP)AjcAvlInsOrGetStrNodeA(pW->hAvlStr, pStr)) {
			//	参照カウンタ更新
			AjcAvlGetStrNodeDataA(pW->hAvlStr, pStr, &data);
			AjcAvlSetStrNodeDataA(pW->hAvlStr, pStr, data + 1);
		}
	}
	return	rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_WCP		WINAPI	AjcSplRegistW(HAJCSPL pW, C_WCP pStr)
{
	C_WCP	rc = NULL;
	UX		data;

	if (IS_MY_INST(pW) && pStr != NULL) {
		if (rc = (C_WCP)AjcAvlInsOrGetStrNodeW(pW->hAvlStr, pStr)) {
			//	参照カウンタ更新
			AjcAvlGetStrNodeDataW(pW->hAvlStr, pStr, &data);
			AjcAvlSetStrNodeDataW(pW->hAvlStr, pStr, data + 1);
		}
	}
	return	rc;
}
//==============================================================================================================//
//	文字列検索																									//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//				pStr			-	検索する文字列																//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（見つかった文字列のアドレス）														//
//				＝ NULL：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP		WINAPI	AjcSplFindA  (HAJCSPL pW, C_BCP pStr)
{
	C_BCP	rc = NULL;

	if (IS_MY_INST(pW) && pStr != NULL) {
		rc = (C_BCP)AjcAvlGetNodePtr(pW->hAvlStr, (UX)pStr, NULL);
	}
	return	rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_WCP		WINAPI	AjcSplFindW  (HAJCSPL pW, C_WCP pStr)
{
	C_WCP	rc = NULL;

	if (IS_MY_INST(pW) && pStr != NULL) {
		rc = (C_WCP)AjcAvlGetNodePtr(pW->hAvlStr, (UX)pStr, NULL);
	}
	return	rc;
}
//==============================================================================================================//
//	文字列プールから部分文字列を含むノードを検索																//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//				pPartStr		-	検索する部分文字列															//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（見つかったノード（文字列）のアドレス）											//
//				＝ NULL：部分文字列を含むノードが見つからない／エラー											//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	BOOL			fDistinguish;
	AJCSPL_INSTROPT	opt;
	C_BCP			pNode;
	C_BCP			pPartStr;
} CBP_PARTSTR_IN_POOLA, *PCBP_PARTSTR_IN_POOLA;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK cbSplPartStrInPoolA(C_BCP pStr, UX cbp)
{
	BOOL					rc	= TRUE;
	PCBP_PARTSTR_IN_POOLA	p	= (PCBP_PARTSTR_IN_POOLA)cbp;
	int						rsu = FALSE;

	//	先頭部分一致チェック
	if (p->opt == AJCSPL_ISP_MATCHFIRST) {
		int lPart = (int)strlen(p->pPartStr);
		int	lStr  = (int)strlen(pStr);
		if (lStr >= lPart) {
			if (p->fDistinguish) rsu = (strncmp (pStr, p->pPartStr, lPart) == 0);
			else				 rsu = (strnicmp(pStr, p->pPartStr, lPart) == 0);
		}
	}
	//	部分文字列含有チェック
		if (p->fDistinguish) rsu = (mbsstr (pStr, p->pPartStr) != NULL);
		else				 rsu = (mbsistr(pStr, p->pPartStr) != NULL);
	//	部分文字列一致ならば、戻り値設定し検索終了
	if (rsu) {
		p->pNode = pStr;
		rc = FALSE;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP		WINAPI	AjcSplPartStrInPoolA(HAJCSPL pW, C_BCP pPartStr, AJCSPL_INSTROPT opt)
{
	C_BCP			rc = NULL;
	CBP_PARTSTR_IN_POOLA cbp;

	if (IS_MY_INST(pW) && pPartStr != NULL) {
		cbp.fDistinguish = pW->fDistinguish;
		cbp.opt 		 = opt;
		cbp.pNode		 = NULL;
		cbp.pPartStr	 = pPartStr;
		AjcSplEnumStrA(pW, (UX)&cbp, cbSplPartStrInPoolA, FALSE);
		rc = cbp.pNode;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	BOOL			fDistinguish;
	AJCSPL_INSTROPT	opt;
	C_WCP			pNode;
	C_WCP			pPartStr;
} CBP_PARTSTR_IN_POOLW, *PCBP_PARTSTR_IN_POOLW;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK cbSplPartStrInPoolW(C_WCP pStr, UX cbp)
{
	BOOL					rc	= TRUE;
	PCBP_PARTSTR_IN_POOLW	p	= (PCBP_PARTSTR_IN_POOLW)cbp;
	int						rsu = FALSE;

	//	先頭部分一致チェック
	if (p->opt == AJCSPL_ISP_MATCHFIRST) {
		int lPart = (int)wcslen(p->pPartStr);
		int	lStr  = (int)wcslen(pStr);
		if (lStr >= lPart) {
			if (p->fDistinguish) rsu = (wcsncmp (pStr, p->pPartStr, lPart) == 0);
			else				 rsu = (wcsnicmp(pStr, p->pPartStr, lPart) == 0);
		}
	}
	//	部分文字列含有チェック
	else {
		if (p->fDistinguish) rsu = (wcsstr (pStr, p->pPartStr) != NULL);
		else				 rsu = (wcsistr(pStr, p->pPartStr) != NULL);
	}
	//	部分文字列一致ならば、戻り値設定し検索終了
	if (rsu) {
		p->pNode = (C_WCP)pStr;
		rc = FALSE;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	C_WCP		WINAPI	AjcSplPartStrInPoolW(HAJCSPL pW, C_WCP pPartStr, AJCSPL_INSTROPT opt)
{
	C_WCP			rc = NULL;
	CBP_PARTSTR_IN_POOLW cbp;

	if (IS_MY_INST(pW)) {
		cbp.fDistinguish = pW->fDistinguish;
		cbp.opt 		 = opt;
		cbp.pNode		 = NULL;
		cbp.pPartStr	 = pPartStr;
		AjcSplEnumStrW(pW, (UX)&cbp, cbSplPartStrInPoolW, FALSE);
		rc = cbp.pNode;
	}
	return rc;
}
//==============================================================================================================//
//	文字列プール中の部分文字列一致検索																			//
//																												//
//	引　数	：	pW		-	文字列プールハンドル																//
//				pStr	-	文字列																				//
//				opt		-	検索オプション																		//
//								AJCSPL_ISP_MATCHFIRST : 指定文字列の先頭部分が文字列プール中のいずれかと一致	//
//								AJCSPL_ISP_INCLUDING  : 指定文字列が文字列プール中のいずれかの文字列を含む		//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（見つかったノード（部分文字列）のアドレス）										//
//				＝ NULL：文字列はいずれの部分文字列も含んでいない／エラー										//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	BOOL			fDistinguish;
	AJCSPL_INSTROPT	opt;
	C_BCP			pNode;
	C_BCP			pStr;
} CBP_POOLSTR_IN_STRA, *PCBP_POOLSTR_IN_STRA;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK cbPoolStrInStrA(C_BCP pPartStr, UX cbp)
{
	BOOL					rc	= TRUE;
	PCBP_POOLSTR_IN_STRA	p	= (PCBP_POOLSTR_IN_STRA)cbp;
	int						rsu = FALSE;

	//	先頭部分一致チェック
	if (p->opt == AJCSPL_ISP_MATCHFIRST) {
		int lPart = (int)strlen(pPartStr);
		int	lStr  = (int)strlen(p->pStr);
		if (lStr >= lPart) {
			if (p->fDistinguish) rsu = (strncmp (p->pStr, pPartStr, lPart) == 0);
			else				 rsu = (strnicmp(p->pStr, pPartStr, lPart) == 0);
		}
	}
	//	部分文字列含有チェック
	else {
		if (p->fDistinguish) rsu = (mbsstr (p->pStr, pPartStr) != NULL);
		else				 rsu = (mbsistr(p->pStr, pPartStr) != NULL);
	}
	//	部分文字列一致ならば、戻り値設定し検索終了
	if (rsu) {
		p->pNode = (C_BCP)pPartStr;
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP		WINAPI	AjcSplPoolStrInStrA(HAJCSPL pW, C_BCP pStr, AJCSPL_INSTROPT opt)
{
	C_BCP			rc = NULL;
	CBP_POOLSTR_IN_STRA cbp;

	if (IS_MY_INST(pW)) {
		cbp.fDistinguish = pW->fDistinguish;
		cbp.opt 		 = opt;
		cbp.pNode		 = NULL;
		cbp.pStr		 = pStr;
		AjcSplEnumStrA(pW, (UX)&cbp, cbPoolStrInStrA, FALSE);
		rc = cbp.pNode;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	BOOL			fDistinguish;
	AJCSPL_INSTROPT	opt;
	C_WCP			pNode;
	C_WCP			pStr;
} CBP_POOLSTR_IN_STRW, *PCBP_POOLSTR_IN_STRW;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK cbPoolStrInStrW(C_WCP pPartStr, UX cbp)
{
	BOOL					rc	= TRUE;
	PCBP_POOLSTR_IN_STRW	p	= (PCBP_POOLSTR_IN_STRW)cbp;
	int						rsu = FALSE;

	//	先頭部分一致チェック
	if (p->opt == AJCSPL_ISP_MATCHFIRST) {
		int lPart = (int)wcslen(pPartStr);
		int	lStr  = (int)wcslen(p->pStr);
		if (lStr >= lPart) {
			if (p->fDistinguish) rsu = (wcsncmp (p->pStr, pPartStr, lPart) == 0);
			else				 rsu = (wcsnicmp(p->pStr, pPartStr, lPart) == 0);
		}
	}
	//	部分文字列含有チェック
	else {
		if (p->fDistinguish) rsu = (wcsstr (p->pStr, pPartStr) != NULL);
		else				 rsu = (wcsistr(p->pStr, pPartStr) != NULL);
	}
	//	部分文字列一致ならば、戻り値設定し検索終了
	if (rsu) {
		p->pNode = pPartStr;
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	C_WCP		WINAPI	AjcSplPoolStrInStrW(HAJCSPL pW, C_WCP pStr, AJCSPL_INSTROPT opt)
{
	C_WCP			rc = NULL;
	CBP_POOLSTR_IN_STRW cbp;

	if (IS_MY_INST(pW)) {
		cbp.fDistinguish = pW->fDistinguish;
		cbp.opt 		 = opt;
		cbp.pNode		 = NULL;
		cbp.pStr		 = pStr;
		AjcSplEnumStrW(pW, (UX)&cbp, cbPoolStrInStrW, FALSE);
		rc = cbp.pNode;
	}
	return rc;
}
//==============================================================================================================//
//	文字列削除																									//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//				pStr			-	検索する文字列																//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（見つかった文字列のアドレス）														//
//				＝ NULL：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSplRemoveA  (HAJCSPL pW, C_BCP pStr)
{
	BOOL	rc = FALSE;
	SX		data;

	if (IS_MY_INST(pW) && pStr != NULL) {
		//	参照カウンタ取得
		if (rc = AjcAvlGetStrNodeDataA(pW->hAvlStr, pStr, (UXP)&data)) {
			//	参照カウンタが２以上ならば参照カウンタ減算
			if (data >= 2) {
				AjcAvlSetStrNodeDataA(pW->hAvlStr, pStr, data - 1);
			}
			//	参照カウンタが１（以下）ならばノード削除
			else {
				rc = AjcAvlDelNode(pW->hAvlStr, (UX)pStr);
			}
		}
	}
	return	rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSplRemoveW  (HAJCSPL pW, C_WCP pStr)
{
	BOOL	rc = FALSE;
	SX		data;

	if (IS_MY_INST(pW) && pStr != NULL) {
		//	参照カウンタ取得
		if (rc = AjcAvlGetStrNodeDataW(pW->hAvlStr, pStr, (UXP)&data)) {
			//	参照カウンタが２以上ならば参照カウンタ減算
			if (data >= 2) {
				AjcAvlSetStrNodeDataW(pW->hAvlStr, pStr, data - 1);
			}
			//	参照カウンタが１（以下）ならばノード削除
			else {
				rc = AjcAvlDelNode(pW->hAvlStr, (UX)pStr);
			}
		}
	}
	return	rc;
}
//==============================================================================================================//
//	登録済文字列の個数取得																						//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//																												//
//	戻り値	：	登録済文字列の個数																				//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcSplGetCount (HAJCSPL pW)
{
	UI	rc = 0;

	if (IS_MY_INST(pW)) {
		rc = AjcAvlGetCount(pW->hAvlStr);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcSplNumber (HAJCSPL pW)
{
	return AjcSplGetCount(pW);
}

//==============================================================================================================//
//	リセット（文字列プールの全ノード破棄）																		//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSplReset (HAJCSPL pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AjcAvlDelAllNodes(pW->hAvlStr);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	登録済み全文字列取得																						//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//				cbp				-	コールバックパラメタ														//
//				cbNtcStr		-	文字列通知用コールバック関数（不要時はＮＵＬＬ）							//
//				fDownSeq		-	文字列読み出し順の指定（FALSE:昇順，TRUE：降順）							//
//																												//
//	戻り値	：	総文字列数（エラー時は０を返す）																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UX		cbp;
	BOOL (CALLBACK *cb)(C_BCP pStr, UX cbp);
} CBP_SPLENUMSTRA, *PCBP_SPLENUMSTRA;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK cbSplEnumStrA(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	BOOL				rc = TRUE;
	PCBP_SPLENUMSTRA	p  = (PCBP_SPLENUMSTRA)cbp;
	if (p->cb != NULL) {
		rc = p->cb((C_BCP)pNodeData, p->cbp);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcSplEnumStrA(HAJCSPL pW, UX cbp, BOOL (CALLBACK *cbNtcStr)(C_BCP pStr, UX cbp), BOOL fDownSeq)
{
	UI				rc = 0;
	CBP_SPLENUMSTRA	prm;

	if (IS_MY_INST(pW)) {
		prm.cbp = cbp;
		prm.cb	= cbNtcStr;
		rc = AjcAvlEnumNodesEx(pW->hAvlStr, (UX)&prm, cbSplEnumStrA, fDownSeq);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UX		cbp;
	BOOL (CALLBACK *cb)(C_WCP pStr, UX cbp);
} CBP_SPLENUMSTRW, *PCBP_SPLENUMSTRW;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK cbSplEnumStrW(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	BOOL				rc = TRUE;
	PCBP_SPLENUMSTRW	p  = (PCBP_SPLENUMSTRW)cbp;
	if (p->cb != NULL) {
		rc = p->cb((C_WCP)pNodeData, p->cbp);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcSplEnumStrW(HAJCSPL pW, UX cbp, BOOL (CALLBACK *cbNtcStr)(C_WCP pStr, UX cbp), BOOL fDownSeq)
{
	UI				rc = 0;
	CBP_SPLENUMSTRW	prm;

	if (IS_MY_INST(pW)) {
		prm.cbp = cbp;
		prm.cb	= cbNtcStr;
		rc = AjcAvlEnumNodesEx(pW->hAvlStr, (UX)&prm, cbSplEnumStrW, fDownSeq);
	}
	return rc;
}
//==============================================================================================================//
//	ＡＶＬ２分木のハンドル取得																					//
//																												//
//	引　数	：	pW				-	文字列プールハンドル														//
//																												//
//	戻り値	：	≠ NULL：ＯＫ（ＡＶＬ２分木のハンドル）															//
//				＝ NULL：エラー																					//
//==============================================================================================================//
AJCEXPORT	HAJCAVL		WINAPI	AjcSplGetAvlHandle(HAJCSPL pW)
{
	HAJCAVL		rc = NULL;

	if (IS_MY_INST(pW)) {
		rc = pW->hAvlStr;
	}
	return rc;
}


