﻿#include	"AjcInternal.h"

static	LARGE_INTEGER	nFreq = {0};

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcTimeMeasureInit(VO)
{
	BOOL	rc = FALSE;

	QueryPerformanceFrequency(&nFreq);

	return TRUE;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcTimeMeasureEnd (VO)
{
	//	NOP
}



//==============================================================================================================//
//	時間計測開始																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
static	ULL				msSrtTime;
static	LARGE_INTEGER	nBefore, nAfter;
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	ULL		WINAPI	AjcTimeMeasureStart(VO)
{
	if (nFreq.QuadPart != 0) {
		QueryPerformanceCounter(&nBefore);
	}
	else {
		msSrtTime = timeGetTime();
	}
	return nFreq.QuadPart;
}
//==============================================================================================================//
//	周期時間計測																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	計測時間 [us] （AjcMesTimeStart()/AjcMesTimeInterval()を実行後の経過時間）						//
//==============================================================================================================//
AJCEXPORT	ULL	WINAPI	AjcTimeMeasureInterval(VO)
{
	ULL		ct, rc = 0;

	if (nFreq.QuadPart != 0) {
		QueryPerformanceCounter(&nAfter);
		rc = (nAfter.QuadPart - nBefore.QuadPart) * (ULL)1000000 / nFreq.QuadPart;
		nBefore.QuadPart = nAfter.QuadPart;
	}
	else {
		ct = timeGetTime();
		rc = (ULL)(ct - msSrtTime) * (ULL)1000;
		msSrtTime = ct;
	}
	return rc;
}
//==============================================================================================================//
//	経過時間計測																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	計測時間 [us] （AjcMesTimeStart()/AjcMesTimeInterval()を実行後の経過時間）						//
//==============================================================================================================//
AJCEXPORT	ULL	WINAPI	AjcTimeMeasureElapse(VO)
{
	ULL		rc = 0;

	if (nFreq.QuadPart != 0) {
		QueryPerformanceCounter(&nAfter);
		rc = (nAfter.QuadPart - nBefore.QuadPart) * (ULL)1000000 / nFreq.QuadPart;
	}
	else {
		rc = (ULL)(timeGetTime() - msSrtTime) * (ULL)1000;
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - // 
AJCEXPORT	ULL	WINAPI	AjcTimeMeasureStop(VO)
{
	return AjcTimeMeasureElapse();
}
//==============================================================================================================//
//	マルチインスタンス用・時間計測オブジェクト生成																//
//																												//
//	引　数	：	pFreq - 計測周波数を格納するバッファのアドレス(不要時はNULL)									//
//																												//
//	戻り値	：	≠NULL:インスタンスハンドル																		//
//				＝NULL:エラー（時間計測不可）																	//
//==============================================================================================================//
AJCEXPORT	HAJCMESTIME	WINAPI	AjcMesTimeCreate(ULLP pFreq)
{
	HAJCMESTIME		pW = NULL;

	if (pW = (HAJCMESTIME)AJCMEM(sizeof(AJCMESTIME))) {
		memset(pW, 0, sizeof(AJCMESTIME));
		if (nFreq.QuadPart != 0) {
			QueryPerformanceCounter(&pW->Before);
		}
		else {
			pW->msSTime = timeGetTime();
		}
		if (pFreq != NULL) {
			*pFreq = nFreq.QuadPart;
		}
	}
	return pW;
}
//==============================================================================================================//
//	マルチインスタンス用・時間計測オブジェクト消去																//
//																												//
//	引　数	：	pW - インスタンスハンドル																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcMesTimeDelete(HAJCMESTIME pW)
{
	if (pW != NULL) {
		free(pW);
	}
}
//==============================================================================================================//
//	マルチインスタンス用・周期時間計測																			//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	計測時間 [us] （AjcMesTimeCreate/AjcMesTimeInterval()を実行後の経過時間）						//
//==============================================================================================================//
AJCEXPORT	ULL	WINAPI	AjcMesTimeInterval(HAJCMESTIME pW)
{
	ULL		ct, rc = 0;

	if (pW != NULL) {
		if (nFreq.QuadPart != 0) {
			QueryPerformanceCounter(&pW->After);
			rc = (pW->After.QuadPart - pW->Before.QuadPart) * (ULL)1000000 / nFreq.QuadPart;
			pW->Before.QuadPart = pW->After.QuadPart;
		}
		else {
			ct = timeGetTime();
			rc = (ULL)(ct - pW->msSTime) * (ULL)1000;
			pW->msSTime = ct;
		}
	}
	return rc;
}
//==============================================================================================================//
//	マルチインスタンス用・経過時間計測																			//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	計測時間 [us] （AjcMesTimeCreate/AjcMesTimeInterval()を実行後の経過時間）						//
//==============================================================================================================//
AJCEXPORT	ULL	WINAPI	AjcMesTimeElapse(HAJCMESTIME pW)
{
	ULL		ct, rc = 0;

	if (pW != NULL) {
		if (nFreq.QuadPart != 0) {
			QueryPerformanceCounter(&pW->After);
			rc = (pW->After.QuadPart - pW->Before.QuadPart) * (ULL)1000000 / nFreq.QuadPart;
		}
		else {
			ct = timeGetTime();
			rc = (ULL)(ct - pW->msSTime) * (ULL)1000;
		}
	}
	return rc;
}
