﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	計測時間情報の表示（子ダイアログ）																			//
//																												//
//**************************************************************************************************************//
#define	INST_ID			0x27835A1F
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	SubMoveWindow(HAJCMSTVIEW pW);

//==============================================================================================================//
//	Function	:	計測情報ダイアログの表示																	//
//																												//
//	Argument	:	hParent		- 親ウインドのハンドル															//
//					cbp			- コールバックパラメタ															//
//					cbGetInfo	- 計測情報取得コールバックハンドル												//
//					cbNtcClosed	- ダイアログクローズ通知用コールバック											//
//																												//
//	Return		:	≠ NULL	- 成功（ダイアログハンドル）														//
//					＝ NULL	- 失敗																				//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI	AjcViewMesTimeCreate (HWND hParent, UX cbp, VO (CALLBACK *cbGetInfo  )(PAJCMSTINFO pBuf, UX cbp),
																		VO (CALLBACK *cbNtcClosed)( 			     UX cbp))
{
	HWND		rc = NULL;
	HAJCMSTVIEW	pW;

	if ((pW = (HAJCMSTVIEW)AJCMEM(sizeof(AJCMSTVIEW))) != NULL) {
		memset(pW, 0, sizeof *pW);
		pW->InstID		= INST_ID;
		pW->hParent		= hParent;
		pW->cbp			= cbp;
		pW->cbGetInfo	= cbGetInfo;
		pW->cbNtcClosed	= cbNtcClosed;
		if (pW->hMyDlg = CreateDialogParam(hDllInst, MAKEINTRESOURCE(IDD_MSTVIEW), hParent, AJC_DLGPROC_NAME(Main), (LPARAM)pW)) {
			SubMoveWindow(pW);
			rc = pW->hMyDlg;
		}
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	計測情報ダイアログの破棄																	//
//																												//
//	Argument	:	pW		- インスタンスハンドル																//
//																												//
//	Return		:	TRUE	- 成功																				//
//					FALSE	- 失敗																				//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcViewMesTimeDelete(HWND hDlg)
{
	BOOL		rc = FALSE;

	if (IsWindow(hDlg)) {
		HAJCMSTVIEW	pW = (HAJCMSTVIEW)GetProp(hDlg, L"AjcMstView");
		if (IS_MY_INST(pW)) {
			DestroyWindow(pW->hMyDlg);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	計測情報ダイアログの配置																	//
//																												//
//	Argument	:	pW		- インスタンスハンドル																//
//																												//
//	Return		:	TRUE	- 成功																				//
//					FALSE	- 失敗																				//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcViewMesTimeMove(HWND hDlg)
{
	BOOL		rc = FALSE;

	if (IsWindow(hDlg)) {
		HAJCMSTVIEW	pW = (HAJCMSTVIEW)GetProp(hDlg, L"AjcMstView");
		if (IS_MY_INST(pW)) {
			SubMoveWindow(pW);
			rc = TRUE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	計測情報表示ダイアログを親ウインドの右下に配置																//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubMoveWindow(HAJCMSTVIEW pW)
{
	RECT	pr, dr;
	int		pw, ph;
	int		dw, dh;

	GetClientRect(pW->hParent, &pr);
	pw = pr.right - pr.left;
	ph = pr.bottom - pr.top;
	GetWindowRect(pW->hMyDlg , &dr);
	dw = dr.right - dr.left;
	dh = dr.bottom - dr.top;
	MoveWindow(pW->hMyDlg, pw - dw - 4, ph - dh - 4, dw, dh, TRUE);
	InvalidateRect(pW->hMyDlg, NULL, TRUE);
	ShowWindow(pW->hMyDlg, SW_SHOW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	描画速度情報表示ダイアログ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG	)
{
	HAJCMSTVIEW	pW = (HAJCMSTVIEW)lParam;

	//	インスタンスを関連付ける
	SetProp(hDlg, L"AjcMstView", pW);

	//	日英テキスト
	AjcSetDlgItemStr(hDlg, IDC_LBL_AVE , LNGSEL(L"平均"	 , L"Ave." ));
	AjcSetDlgItemStr(hDlg, IDC_LBL_MAX , LNGSEL(L"最大"	 , L"Max." ));
	AjcSetDlgItemStr(hDlg, IDC_LBL_MIN , LNGSEL(L"最小"	 , L"Min." ));
	AjcSetDlgItemStr(hDlg, IDC_LBL_CNT , LNGSEL(L"回数"	 , L"Count"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_FREQ, LNGSEL(L"周波数", L"Freq."));

	//	ツールチップ・コントロール生成
		pW->hToolTip = CreateWindowEx(WS_EX_TOPMOST,
								TOOLTIPS_CLASS,
								NULL,
								TTS_ALWAYSTIP,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								pW->hParent,
								NULL,
								hDllInst, NULL);
	//	ツールチップ追加
	{	TOOLINFO	ti;
		memset(&ti, 0, sizeof ti);
		ti.cbSize	= sizeof(TOOLINFO);
		ti.hwnd		= pW->hParent;
		ti.hinst	= hDllInst;
		ti.uFlags	= TTF_IDISHWND | TTF_SUBCLASS;

		ti.lpszText = LNGSEL(L"描画時間情報", L"Drawing time informations");
		ti.uId = (UX)hDlg;		SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL(L"平均描画時間[us]"			, L"Average drawing time[us]");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_AVE);		SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL(L"最大描画時間[us]"			, L"Maximum drawing time [us]");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_MAX);		SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL(L"最小描画時間[us]"			, L"Minimum drawing time [us]");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_MIN);		SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL(L"描画回数"					, L"Number of draws");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_CNT);		SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL(L"計測周波数[Hz]"			, L"Measurement frequency [Hz]");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_FREQ);	SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL(L"描画時間情報を閉じます"	, L"Close drawing time information");
		ti.uId = (UX)GetDlgItem(hDlg, IDCANCEL);		SendMessage(pW->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

	}
	//	計測情報監視タイマ起動
	SetTimer(hDlg, 1, 1000, NULL);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	HAJCMSTVIEW	pW = (HAJCMSTVIEW)GetProp(hDlg, L"AjcMstView");
	TOOLINFO	ti;

	//	クローズ通知
	if (pW->cbNtcClosed != NULL) {
		pW->cbNtcClosed(pW->cbp);
	}

	if (pW->hToolTip != NULL) {
		//	ツールチップ削除
		memset(&ti, 0, sizeof ti);
		ti.cbSize	= sizeof(TOOLINFO);
		ti.hwnd		= pW->hParent;
		ti.hinst	= hDllInst;
		ti.uFlags	= TTF_IDISHWND | TTF_SUBCLASS;
		ti.lpszText = L"";

		ti.uId = (UX)hDlg;								SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_AVE);		SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_MAX);		SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_MIN);		SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_CNT);		SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_FREQ);	SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);
		ti.uId = (UX)GetDlgItem(hDlg, IDCANCEL);		SendMessage(pW->hToolTip, TTM_DELTOOL, 0, (LPARAM)&ti);

		//	ツールチップコントロール破棄
		DestroyWindow(pW->hToolTip);
	}
	//	インスタンス解放
	free(pW);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER		)
{
	HAJCMSTVIEW	pW	= (HAJCMSTVIEW)GetProp(hDlg, L"AjcMstView");
	AJCMSTINFO	mti = {0};

	if (pW->cbGetInfo != NULL) {
		pW->cbGetInfo(&mti, pW->cbp);
		//	描画速度情報表示
		AjcSepDlgItemUI64(hDlg, IDC_TXT_FREQ, mti.Freq);
		AjcSepDlgItemUI64(hDlg, IDC_TXT_CNT , mti.Cnt );
		AjcSepDlgItemUI64(hDlg, IDC_TXT_AVE , mti.Ave );
		AjcSepDlgItemUI64(hDlg, IDC_TXT_MAX , mti.Max );
		AjcSepDlgItemUI64(hDlg, IDC_TXT_MIN , mti.Min );
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	HAJCMSTVIEW	pW = (HAJCMSTVIEW)GetProp(hDlg, L"AjcMstView");

	//	ダイアログ破棄
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY			)
	AJC_DLGMAP_MSG(Main, WM_TIMER			)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
AJC_DLGMAP_END

