﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	変数管理																									//
//																												//
//**************************************************************************************************************//

#define	INST_ID			0x9245FC7A
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	２分木コールバック（変数名文字列比較）																		//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static int CALLBACK cbCompA(UX key1, UX key2, UX cbp)
{
	return mbscmp((C_BCP)key1, (C_BCP)key2);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static int CALLBACK cbCompW(UX key1, UX key2, UX cbp)
{
	return wcscmp((WCP)key1, (WCP)key2);
}
//--------------------------------------------------------------------------------------------------------------//
//	２分木コールバック（ノード削除）																			//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static VO CALLBACK cbDelNodeA(UX key, C_VOP pNodeData, UI len, UI nest, UX cbp)
{
	PCAJCVMGNODEA	pNode = (PCAJCVMGNODEA)pNodeData;

	if (pNode->pName != NULL) {
		AjcTFree((VOP)pNode->pName);
	}
	if (pNode->arr.vp != NULL) {
		if (pNode->type == AJCVMGT_STR) {
			UI i;
			for (i = 0; i < pNode->num; i++) {
				if (pNode->arr.pStr[i] != NULL) {
					AjcTFree(pNode->arr.pStr[i]);
				}
			}
		}
		AjcTFree(pNode->arr.vp);
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static VO CALLBACK cbDelNodeW(UX key, C_VOP pNodeData, UI len, UI nest, UX cbp)
{
	PCAJCVMGNODEW	pNode = (PCAJCVMGNODEW)pNodeData;

	if (pNode->pName != NULL) {
		AjcTFree((VOP)pNode->pName);
	}
	if (pNode->arr.vp != NULL) {
		if (pNode->type == AJCVMGT_STR) {
			UI i;
			for (i = 0; i < pNode->num; i++) {
				if (pNode->arr.pStr[i] != NULL) {
					AjcTFree(pNode->arr.pStr[i]);
				}
			}
		}
		AjcTFree(pNode->arr.vp);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	２分木コールバック（全ノード読み出し）																		//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static BOOL CALLBACK WINAPI cbNtcNodeA(UX key, C_VOP pNodeData, UI len, UI nest, UX cbp)
{
	BOOL		rc = TRUE;
	HAJCVMGA	pW = (HAJCVMGA)cbp;

	rc = pW->cbNtcVar((PCAJCVMGNODEA)pNodeData, pW->cbp);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static BOOL CALLBACK WINAPI cbNtcNodeW(UX key, C_VOP pNodeData, UI len, UI nest, UX cbp)
{
	BOOL		rc = TRUE;
	HAJCVMGW	pW = (HAJCVMGW)cbp;

	rc = pW->cbNtcVar((PCAJCVMGNODEW)pNodeData, pW->cbp);

	return rc;
}
//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL - 成功（インスタンスハンドル）															//
//				＝NULL - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HAJCVMGA		WINAPI AjcVmgCreateA(VO)
{
	HAJCVMGA	hVmg = NULL;

	if (hVmg = (HAJCVMGA)AJCMEM(sizeof(AJCVMGA))) {
		memset(hVmg, 0, sizeof(AJCVMGA));
		hVmg->InstID = INST_ID;
		if (!(hVmg->hAvlVar = AjcAvlCreate((UX)hVmg, cbCompA, cbDelNodeA))) {
			free(hVmg);
			hVmg = NULL;
		}
	}
	return hVmg;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HAJCVMGW		WINAPI AjcVmgCreateW(VO)
{
	HAJCVMGW	hVmg = NULL;

	if (hVmg = (HAJCVMGW)AJCMEM(sizeof(AJCVMGW))) {
		memset(hVmg, 0, sizeof(AJCVMGW));
		hVmg->InstID = INST_ID;
		if (!(hVmg->hAvlVar = AjcAvlCreate((UX)hVmg, cbCompW, cbDelNodeW))) {
			free(hVmg);
			hVmg = NULL;
		}
	}
	return hVmg;
}

//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO			WINAPI AjcVmgDeleteA(HAJCVMGA pW)
{
	if (IS_MY_INST(pW)) {
		if (pW->hAvlVar != NULL) {
			AjcAvlDelete(pW->hAvlVar);
		}
		free(pW);
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO			WINAPI AjcVmgDeleteW(HAJCVMGW pW)
{
	if (IS_MY_INST(pW)) {
		if (pW->hAvlVar != NULL) {
			AjcAvlDelete(pW->hAvlVar);
		}
		free(pW);
	}
}

//==============================================================================================================//
//	全変数情報を破棄																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO			WINAPI AjcVmgPurgeA(HAJCVMGA pW)
{
	if (IS_MY_INST(pW)) {
		if (pW->hAvlVar != NULL) {
			AjcAvlDelAllNodes(pW->hAvlVar);
		}
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO			WINAPI AjcVmgPurgeW(HAJCVMGW pW)
{
	if (IS_MY_INST(pW)) {
		if (pW->hAvlVar != NULL) {
			AjcAvlDelAllNodes(pW->hAvlVar);
		}
	}
}

//==============================================================================================================//
//	変数の作成																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				type		- 変数のタイプ																		//
//				num			- 配列の要素数																		//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgGenVarA(HAJCVMGA pW, C_BCP pVarName, AJCVMGTYPE type, UI num)
{
	BOOL	rc = FALSE;
	AJCVMGNODEA	Node;

	if (IS_MY_INST(pW) && pVarName != NULL) {

		//	ノードクリアー
		memset(&Node, 0, sizeof Node);
		//	要素数補正
		if (num == 0) num = 1;

		//	変数値領域確保
		Node.num = num;
		switch (type) {
			//	数値の場合は全要素ゼロクリアー
			case AJCVMGT_INT:	if (Node.arr.pSI = (SIP)AJCMEM(sizeof(SI) * num)) {
									memset(Node.arr.pSI, 0, sizeof(SI) * num);
								}
								break;
			case AJCVMGT_LONG:	if (Node.arr.pSLL = (SLLP)AJCMEM(sizeof(SLL) * num)) {
									memset(Node.arr.pSLL, 0, sizeof(SLL) * num);
								}
							 	break;
			case AJCVMGT_REAL:	if (Node.arr.pDBL = (double*)AJCMEM(sizeof(double) * num)) {
									memset(Node.arr.pDBL, 0, sizeof(double) * num);
								}
								break;
			//	文字列の場合は全要素に空文字列設定
			case AJCVMGT_STR:	if (Node.arr.pStr = (BCP *)AJCMEM(sizeof(BCP) * num)) {
									UI	i;
									for (i = 0; i < num; i++) {
										if (Node.arr.pStr[i] = AjcTAllocA(1)) {
											*Node.arr.pStr[i] = 0;
										}
										else {
											UI	j;
											for (j = 0; j < i; j++) {
												AjcTFree(Node.arr.pStr[j]);
											}
											Node.arr.pStr = NULL;
											break;
										}
									}
								}
								break;
		}
		//	変数名，タイプ設定
		if (Node.arr.vp != NULL) {
			if (Node.pName = AjcTAllocA((UI)strlen(pVarName) + 1)) {
				strcpy(Node.pName, pVarName);
				Node.type  = type;
				rc = AjcAvlInsNode(pW->hAvlVar, (UX)Node.pName, &Node, sizeof Node);
			}
		}
		//	失敗時はリソース解放
		if (rc == FALSE) {
			if (Node.pName  != NULL) AjcTFree(Node.pName);
			if (Node.arr.vp != NULL) free(Node.arr.vp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgGenVarW(HAJCVMGW pW, C_WCP pVarName, AJCVMGTYPE type, UI num)
{
	BOOL	rc = FALSE;
	AJCVMGNODEW	Node;

	if (IS_MY_INST(pW) && pVarName != NULL) {

		//	ノードクリアー
		memset(&Node, 0, sizeof Node);
		//	要素数補正
		if (num == 0) num = 1;

		//	変数値領域確保
		Node.num = num;
		switch (type) {
			//	数値の場合は全要素ゼロクリアー
			case AJCVMGT_INT:	if (Node.arr.pSI = (SIP)AJCMEM(sizeof(SI) * num)) {
									memset(Node.arr.pSI, 0, sizeof(SI) * num);
								}
								break;
			case AJCVMGT_LONG:	if (Node.arr.pSLL = (SLLP)AJCMEM(sizeof(SLL) * num)) {
									memset(Node.arr.pSLL, 0, sizeof(SLL) * num);
								}
							 	break;
			case AJCVMGT_REAL:	if (Node.arr.pDBL = (double*)AJCMEM(sizeof(double) * num)) {
									memset(Node.arr.pDBL, 0, sizeof(double) * num);
								}
								break;
			//	文字列の場合は全要素に空文字列設定
			case AJCVMGT_STR:	if (Node.arr.pStr = (WCP *)AJCMEM(sizeof(WCP) * num)) {
									UI	i;
									for (i = 0; i < num; i++) {
										if (Node.arr.pStr[i] = AjcTAllocW(1)) {
											*Node.arr.pStr[i] = 0;
										}
										else {
											UI	j;
											for (j = 0; j < i; j++) {
												AjcTFree(Node.arr.pStr[j]);
											}
											Node.arr.pStr = NULL;
											break;
										}
									}
								}
								break;
		}
		//	変数名，タイプ設定
		if (Node.arr.vp != NULL) {
			if (Node.pName = AjcTAllocW((UI)wcslen(pVarName) + 1)) {
				wcscpy(Node.pName, pVarName);
				Node.type  = type;
				rc = AjcAvlInsNode(pW->hAvlVar, (UX)Node.pName, &Node, sizeof Node);
			}
		}
		//	失敗時はリソース解放
		if (rc == FALSE) {
			if (Node.pName  != NULL) AjcTFree(Node.pName);
			if (Node.arr.vp != NULL) free(Node.arr.vp);
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数の属性設定																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				att			- 変数の属性(AJCVMGA_XXXXX)															//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetAttA(HAJCVMGA pW, C_BCP pVarName, UI att)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			pNode->att = att;
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetAttW(HAJCVMGA pW, C_WCP pVarName, UI att)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			pNode->att = att;
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	変数の属性取得																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	≠-1 - 成功（変数の属性値）																		//
//				＝-1 - 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI			WINAPI AjcVmgGetAttA(HAJCVMGA pW, C_BCP pVarName)
{
	UI				rc = -1;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			rc = pNode->att;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI			WINAPI AjcVmgGetAttW(HAJCVMGA pW, C_WCP pVarName)
{
	UI				rc = -1;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			rc = pNode->att;
		}
	}
	return rc;
}

//==============================================================================================================//
//	変数の削除																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgDelVarA(HAJCVMGA pW, C_BCP pVarName)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		rc = AjcAvlDelNode(pW->hAvlVar, (UX)pVarName);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgDelVarW(HAJCVMGW pW, C_WCP pVarName)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		rc = AjcAvlDelNode(pW->hAvlVar, (UX)pVarName);
	}
	return rc;
}

//==============================================================================================================//
//	変数値設定（整数）																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				value		- 変数値																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetIntegerA(HAJCVMGA pW, C_BCP pVarName, UI ix, SLL value)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (!(pNode->att & AJCVMGA_RDONLY)) {
				if (pNode->num > ix) {
					switch (pNode->type) {
						case AJCVMGT_INT:	pNode->arr.pSI [ix] = (SI    )value; rc = TRUE; break;
						case AJCVMGT_LONG:	pNode->arr.pSLL[ix] = (SLL   )value; rc = TRUE; break;
						case AJCVMGT_REAL:	pNode->arr.pDBL[ix] = (double)value; rc = TRUE; break;
					}
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetIntegerW(HAJCVMGW pW, C_WCP pVarName, UI ix, SLL value)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (!(pNode->att & AJCVMGA_RDONLY)) {
				if (pNode->num > ix) {
					switch (pNode->type) {
						case AJCVMGT_INT:	pNode->arr.pSI [ix] = (SI    )value; rc = TRUE; break;
						case AJCVMGT_LONG:	pNode->arr.pSLL[ix] = (SLL   )value; rc = TRUE; break;
						case AJCVMGT_REAL:	pNode->arr.pDBL[ix] = (double)value; rc = TRUE; break;
					}
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数値設定（実数）																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				value		- 変数値																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetRealA	(HAJCVMGA pW, C_BCP pVarName, UI ix, double value)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (!(pNode->att & AJCVMGA_RDONLY)) {
				if (pNode->num > ix) {
					switch (pNode->type) {
						case AJCVMGT_INT:	pNode->arr.pSI [ix] = (SI    )value; rc = TRUE; break;
						case AJCVMGT_LONG:	pNode->arr.pSLL[ix] = (SLL   )value; rc = TRUE; break;
						case AJCVMGT_REAL:	pNode->arr.pDBL[ix] = (double)value; rc = TRUE; break;
					}
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetRealW	(HAJCVMGW pW, C_WCP pVarName, UI ix, double value)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (!(pNode->att & AJCVMGA_RDONLY)) {
				if (pNode->num > ix) {
					switch (pNode->type) {
						case AJCVMGT_INT:	pNode->arr.pSI [ix] = (SI    )value; rc = TRUE; break;
						case AJCVMGT_LONG:	pNode->arr.pSLL[ix] = (SLL   )value; rc = TRUE; break;
						case AJCVMGT_REAL:	pNode->arr.pDBL[ix] = (double)value; rc = TRUE; break;
					}
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数値設定（文字列）																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pStr		- 文字列へのポインタ																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetStringA	(HAJCVMGA pW, C_BCP pVarName, UI ix, C_BCP pStr)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEA	pNode;
	BCP				pNewStr = NULL;

	if (IS_MY_INST(pW) && pVarName != NULL && pStr != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (!(pNode->att & AJCVMGA_RDONLY)) {
				if (pNode->num > ix && pNode->type == AJCVMGT_STR) {
					if (pNewStr = AjcTAllocA((UI)strlen(pStr) + 1)) {
						if (pNode->arr.pStr[ix] != NULL) {
							AjcTFree(pNode->arr.pStr[ix]);
						}
						pNode->arr.pStr[ix] = pNewStr;
						strcpy(pNode->arr.pStr[ix], pStr);
						rc = TRUE;
					}
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgSetStringW	(HAJCVMGW pW, C_WCP pVarName, UI ix, C_WCP pStr)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEW	pNode;
	WCP				pNewStr = NULL;

	if (IS_MY_INST(pW) && pVarName != NULL && pStr != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (!(pNode->att & AJCVMGA_RDONLY)) {
				if (pNode->num > ix && pNode->type == AJCVMGT_STR) {
					if (pNewStr = AjcTAllocW((UI)wcslen(pStr) + 1)) {
						if (pNode->arr.pStr[ix] != NULL) {
							AjcTFree(pNode->arr.pStr[ix]);
						}
						pNode->arr.pStr[ix] = pNewStr;
						wcscpy(pNode->arr.pStr[ix], pStr);
						rc = TRUE;
					}
				}
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	変数値取得（３２ビット整数）																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pValue		- 変数値を格納するバッファのアドレス												//
//																												//
//	戻り値	：	≠０ - 成功（変数のタイプ）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt32A(HAJCVMGA pW, C_BCP pVarName, UI ix, SIP pValue)
{
	AJCVMGTYPE		rc = AJCVMGT_UNDEF;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				switch (pNode->type) {
					case AJCVMGT_INT:	if (pValue != NULL) {*pValue = (SI)pNode->arr.pSI [ix];} rc = pNode->type; break;
					case AJCVMGT_LONG:	if (pValue != NULL) {*pValue = (SI)pNode->arr.pSLL[ix];} rc = pNode->type; break;
					case AJCVMGT_REAL:	if (pValue != NULL) {*pValue = (SI)pNode->arr.pDBL[ix];} rc = pNode->type; break;
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt32W(HAJCVMGW pW, C_WCP pVarName, UI ix, SIP pValue)
{
	AJCVMGTYPE		rc = AJCVMGT_UNDEF;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				switch (pNode->type) {
					case AJCVMGT_INT:	if (pValue != NULL) {*pValue = (SI)pNode->arr.pSI [ix];} rc = pNode->type; break;
					case AJCVMGT_LONG:	if (pValue != NULL) {*pValue = (SI)pNode->arr.pSLL[ix];} rc = pNode->type; break;
					case AJCVMGT_REAL:	if (pValue != NULL) {*pValue = (SI)pNode->arr.pDBL[ix];} rc = pNode->type; break;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数値取得（６４ビット整数）																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pValue		- 変数値を格納するバッファのアドレス												//
//																												//
//	戻り値	：	≠０ - 成功（変数のタイプ）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt64A(HAJCVMGA pW, C_BCP pVarName, UI ix, SLLP pValue)
{
	AJCVMGTYPE		rc = AJCVMGT_UNDEF;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				switch (pNode->type) {
					case AJCVMGT_INT:	if (pValue != NULL) {*pValue = (SLL)pNode->arr.pSI [ix];} rc = pNode->type; break;
					case AJCVMGT_LONG:	if (pValue != NULL) {*pValue = (SLL)pNode->arr.pSLL[ix];} rc = pNode->type; break;
					case AJCVMGT_REAL:	if (pValue != NULL) {*pValue = (SLL)pNode->arr.pDBL[ix];} rc = pNode->type; break;
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetInt64W(HAJCVMGW pW, C_WCP pVarName, UI ix, SLLP pValue)
{
	AJCVMGTYPE		rc = AJCVMGT_UNDEF;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				switch (pNode->type) {
					case AJCVMGT_INT:	if (pValue != NULL) {*pValue = (SLL)pNode->arr.pSI [ix];} rc = pNode->type; break;
					case AJCVMGT_LONG:	if (pValue != NULL) {*pValue = (SLL)pNode->arr.pSLL[ix];} rc = pNode->type; break;
					case AJCVMGT_REAL:	if (pValue != NULL) {*pValue = (SLL)pNode->arr.pDBL[ix];} rc = pNode->type; break;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数値取得（実数）																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pValue		- 変数値を格納するバッファのアドレス												//
//																												//
//	戻り値	：	≠０ - 成功（変数のタイプ）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetRealA	(HAJCVMGA pW, C_BCP pVarName, UI ix, double *pValue)
{
	AJCVMGTYPE		rc = AJCVMGT_UNDEF;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				switch (pNode->type) {
					case AJCVMGT_INT:	if (pValue != NULL) {*pValue = (double)pNode->arr.pSI [ix];} rc = pNode->type; break;
					case AJCVMGT_LONG:	if (pValue != NULL) {*pValue = (double)pNode->arr.pSLL[ix];} rc = pNode->type; break;
					case AJCVMGT_REAL:	if (pValue != NULL) {*pValue = (double)pNode->arr.pDBL[ix];} rc = pNode->type; break;
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT AJCVMGTYPE	WINAPI AjcVmgGetRealW	(HAJCVMGW pW, C_WCP pVarName, UI ix, double *pValue)
{
	AJCVMGTYPE		rc = AJCVMGT_UNDEF;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				switch (pNode->type) {
					case AJCVMGT_INT:	if (pValue != NULL) {*pValue = (double)pNode->arr.pSI [ix];} rc = pNode->type; break;
					case AJCVMGT_LONG:	if (pValue != NULL) {*pValue = (double)pNode->arr.pSLL[ix];} rc = pNode->type; break;
					case AJCVMGT_REAL:	if (pValue != NULL) {*pValue = (double)pNode->arr.pDBL[ix];} rc = pNode->type; break;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数値取得（文字列）																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//																												//
//	戻り値	：	≠NULL - 成功																					//
//				＝NULL - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT C_BCP	WINAPI AjcVmgGetStringA	(HAJCVMGA pW, C_BCP pVarName, UI ix)
{
	C_BCP			rc = NULL;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				if (pNode->type == AJCVMGT_STR) {
					rc = pNode->arr.pStr[ix];
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT C_WCP	WINAPI AjcVmgGetStringW	(HAJCVMGW pW, C_WCP pVarName, UI ix)
{
	C_WCP			rc = NULL;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			if (pNode->num > ix) {
				if (pNode->type == AJCVMGT_STR) {
					rc = pNode->arr.pStr[ix];
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	変数値の交換																								//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				pVarName1, ix1	- 値を交換する変数名へのポインタ，配列要素インデクス							//
//				pVarName2, ix2	- 	〃																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcVmgSwapA(HAJCVMGA pW, C_BCP pVarName1, UI ix1, C_BCP pVarName2, UI ix2)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEA	pNode1, pNode2;

	if (IS_MY_INST(pW) && pVarName1 != NULL && pVarName2 != NULL) {
		pNode1 = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName1, NULL);
		pNode2 = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName2, NULL);
		if (pNode1 != NULL && pNode2 != NULL && !(pNode1->att & AJCVMGA_RDONLY) && !(pNode2->att & AJCVMGA_RDONLY) && pNode1->num > ix1 && pNode2->num > ix2) {
			switch (pNode1->type) {
				case AJCVMGT_INT:
					switch (pNode2->type) {
						case AJCVMGT_INT:	{SI     sv = pNode1->arr.pSI [ix1]; pNode1->arr.pSI [ix1] = (SI    )pNode2->arr.pSI [ix2]; pNode2->arr.pSI [ix2] = (SI    )sv; rc = TRUE; break;}
						case AJCVMGT_LONG:	{SI     sv = pNode1->arr.pSI [ix1]; pNode1->arr.pSI [ix1] = (SI    )pNode2->arr.pSLL[ix2]; pNode2->arr.pSLL[ix2] = (SLL   )sv; rc = TRUE; break;}
						case AJCVMGT_REAL:	{SI     sv = pNode1->arr.pSI [ix1]; pNode1->arr.pSI [ix1] = (SI    )pNode2->arr.pDBL[ix2]; pNode2->arr.pDBL[ix2] = (double)sv; rc = TRUE; break;}
					}
					break;
				case AJCVMGT_LONG:
					switch (pNode2->type) {
						case AJCVMGT_INT:	{SLL    sv = pNode1->arr.pSLL[ix1]; pNode1->arr.pSLL[ix1] = (SLL   )pNode2->arr.pSI [ix2]; pNode2->arr.pSI [ix2] = (SI    )sv; rc = TRUE; break;}
						case AJCVMGT_LONG:	{SLL    sv = pNode1->arr.pSLL[ix1]; pNode1->arr.pSLL[ix1] = (SLL   )pNode2->arr.pSLL[ix2]; pNode2->arr.pSLL[ix2] = (SLL   )sv; rc = TRUE; break;}
						case AJCVMGT_REAL:	{SLL    sv = pNode1->arr.pSLL[ix1]; pNode1->arr.pSLL[ix1] = (SLL   )pNode2->arr.pDBL[ix2]; pNode2->arr.pDBL[ix2] = (double)sv; rc = TRUE; break;}
					}
					break;
				case AJCVMGT_REAL:
					switch (pNode2->type) {
						case AJCVMGT_INT:	{double sv = pNode1->arr.pDBL[ix1]; pNode1->arr.pDBL[ix1] = (double)pNode2->arr.pSI [ix2]; pNode2->arr.pSI [ix2] = (SI    )sv; rc = TRUE; break;}
						case AJCVMGT_LONG:	{double sv = pNode1->arr.pDBL[ix1]; pNode1->arr.pDBL[ix1] = (double)pNode2->arr.pSLL[ix2]; pNode2->arr.pSLL[ix2] = (SLL   )sv; rc = TRUE; break;}
						case AJCVMGT_REAL:	{double sv = pNode1->arr.pDBL[ix1]; pNode1->arr.pDBL[ix1] = (double)pNode2->arr.pDBL[ix2]; pNode2->arr.pDBL[ix2] = (double)sv; rc = TRUE; break;}
					}
					break;
				case AJCVMGT_STR:
					if (pNode2->type == AJCVMGT_STR) {
						BCP		pSv = pNode1->arr.pStr[ix1];
						pNode1->arr.pStr[ix1] = pNode2->arr.pStr[ix2];
						pNode2->arr.pStr[ix2] = pSv;
						rc = TRUE;
					}
					break;
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcVmgSwapW(HAJCVMGW pW, C_WCP pVarName1, UI ix1, C_WCP pVarName2, UI ix2)
{
	BOOL			rc = FALSE;
	PAJCVMGNODEW	pNode1, pNode2;

	if (IS_MY_INST(pW) && pVarName1 != NULL && pVarName2 != NULL) {
		pNode1 = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName1, NULL);
		pNode2 = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName2, NULL);
		if (pNode1 != NULL && pNode2 != NULL && !(pNode1->att & AJCVMGA_RDONLY) && !(pNode2->att & AJCVMGA_RDONLY) && pNode1->num > ix1 && pNode2->num > ix2) {
			switch (pNode1->type) {
				case AJCVMGT_INT:
					switch (pNode2->type) {
						case AJCVMGT_INT:	{SI     sv = pNode1->arr.pSI [ix1]; pNode1->arr.pSI [ix1] = (SI    )pNode2->arr.pSI [ix2]; pNode2->arr.pSI [ix2] = (SI    )sv; rc = TRUE; break;}
						case AJCVMGT_LONG:	{SI     sv = pNode1->arr.pSI [ix1]; pNode1->arr.pSI [ix1] = (SI    )pNode2->arr.pSLL[ix2]; pNode2->arr.pSLL[ix2] = (SLL   )sv; rc = TRUE; break;}
						case AJCVMGT_REAL:	{SI     sv = pNode1->arr.pSI [ix1]; pNode1->arr.pSI [ix1] = (SI    )pNode2->arr.pDBL[ix2]; pNode2->arr.pDBL[ix2] = (double)sv; rc = TRUE; break;}
					}
					break;
				case AJCVMGT_LONG:
					switch (pNode2->type) {
						case AJCVMGT_INT:	{SLL    sv = pNode1->arr.pSLL[ix1]; pNode1->arr.pSLL[ix1] = (SLL   )pNode2->arr.pSI [ix2]; pNode2->arr.pSI [ix2] = (SI    )sv; rc = TRUE; break;}
						case AJCVMGT_LONG:	{SLL    sv = pNode1->arr.pSLL[ix1]; pNode1->arr.pSLL[ix1] = (SLL   )pNode2->arr.pSLL[ix2]; pNode2->arr.pSLL[ix2] = (SLL   )sv; rc = TRUE; break;}
						case AJCVMGT_REAL:	{SLL    sv = pNode1->arr.pSLL[ix1]; pNode1->arr.pSLL[ix1] = (SLL   )pNode2->arr.pDBL[ix2]; pNode2->arr.pDBL[ix2] = (double)sv; rc = TRUE; break;}
					}
					break;
				case AJCVMGT_REAL:
					switch (pNode2->type) {
						case AJCVMGT_INT:	{double sv = pNode1->arr.pDBL[ix1]; pNode1->arr.pDBL[ix1] = (double)pNode2->arr.pSI [ix2]; pNode2->arr.pSI [ix2] = (SI    )sv; rc = TRUE; break;}
						case AJCVMGT_LONG:	{double sv = pNode1->arr.pDBL[ix1]; pNode1->arr.pDBL[ix1] = (double)pNode2->arr.pSLL[ix2]; pNode2->arr.pSLL[ix2] = (SLL   )sv; rc = TRUE; break;}
						case AJCVMGT_REAL:	{double sv = pNode1->arr.pDBL[ix1]; pNode1->arr.pDBL[ix1] = (double)pNode2->arr.pDBL[ix2]; pNode2->arr.pDBL[ix2] = (double)sv; rc = TRUE; break;}
					}
					break;
				case AJCVMGT_STR:
					if (pNode2->type == AJCVMGT_STR) {
						WCP		pSv = pNode1->arr.pStr[ix1];
						pNode1->arr.pStr[ix1] = pNode2->arr.pStr[ix2];
						pNode2->arr.pStr[ix2] = pSv;
						rc = TRUE;
					}
					break;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	配列要素数の取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	≠０ - 成功（配列の要素数）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI			WINAPI AjcVmgGetArrNumA(HAJCVMGA pW, C_BCP pVarName)
{
	UI				rc = 0;
	PAJCVMGNODEA	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			rc = pNode->num;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI			WINAPI AjcVmgGetArrNumW(HAJCVMGW pW, C_WCP pVarName)
{
	UI				rc = 0;
	PAJCVMGNODEW	pNode;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		if (pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL)) {
			rc = pNode->num;
		}
	}
	return rc;
}

//==============================================================================================================//
//	変数情報ノード取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	≠NULL - 成功（変数情報ノードのアドレス）														//
//				＝NULL - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT PCAJCVMGNODEA	WINAPI AjcVmgGetNodeA(HAJCVMGA pW, C_BCP pVarName)
{
	PAJCVMGNODEA	pNode = NULL;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		pNode = (PAJCVMGNODEA)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL);
	}
	return pNode;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT PCAJCVMGNODEW	WINAPI AjcVmgGetNodeW(HAJCVMGW pW, C_WCP pVarName)
{
	PAJCVMGNODEW	pNode = NULL;

	if (IS_MY_INST(pW) && pVarName != NULL) {
		pNode = (PAJCVMGNODEW)AjcAvlGetNodePtr(pW->hAvlVar, (UX)pVarName, NULL);
	}
	return pNode;
}
//==============================================================================================================//
//	登録済変数の列挙																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				cbp			- コールバックパラメタ																//
//				cbNtcVar	- コールバック関数																	//
//																												//
//	戻り値	：	登録済変数の個数																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI 			WINAPI AjcVmgEnumVarA(HAJCVMGA pW, UX cbp, BOOL (CALLBACK *cbNtcVar)(PCAJCVMGNODEA pVarInfo, UX cbp))
{
	UI	rc = 0;

	if (IS_MY_INST(pW) && cbNtcVar != NULL) {
		pW->cbp		 = cbp;
		pW->cbNtcVar = cbNtcVar;
		rc = AjcAvlEnumNodes(pW->hAvlVar, cbNtcNodeA, FALSE);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI 			WINAPI AjcVmgEnumVarW(HAJCVMGW pW, UX cbp, BOOL (CALLBACK *cbNtcVar)(PCAJCVMGNODEW pVarInfo, UX cbp))
{
	UI	rc = 0;

	if (IS_MY_INST(pW) && cbNtcVar != NULL) {
		pW->cbp		 = cbp;
		pW->cbNtcVar = cbNtcVar;
		rc = AjcAvlEnumNodes(pW->hAvlVar, cbNtcNodeW, FALSE);
	}
	return rc;
}
//==============================================================================================================//
//	変数／配列のコピー																							//
//																												//
//	引　数	：	pWD			- コピー先インスタンスハンドル														//
//				pNameD		- コピー先変数名																	//
//				pWS			- コピー元インスタンスハンドル														//
//				pNameD		- コピー元変数名																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgCopyA(HAJCVMGA pWD, C_BCP pNameD, HAJCVMGA pWS, C_BCP pNameS)
{
	BOOL			rc     = TRUE;
	PCAJCVMGNODEA	pNodeS = NULL;
	PCAJCVMGNODEA	pNodeD = NULL;
	UI				ix     = 0;

	if (IS_MY_INST(pWD) && pNameD != NULL && IS_MY_INST(pWS) && pNameS != NULL) {
		do {
			//	コピー元ノード取得
			if ((pNodeS = AjcVmgGetNodeA(pWS, pNameS)) == NULL) {rc = FALSE; break;}
			//	コピー先ノード取得
			pNodeD = AjcVmgGetNodeA(pWD, pNameD);

			if (pNodeD == NULL || !(pNodeD->att & AJCVMGA_RDONLY)) { // コピー先変数無し／書き込み可？
				//	コピー先変数削除
				AjcVmgDelVarA(pWD, pNameD);
				//	コピー先変数を作成しノード取得
				if (AjcVmgGenVarA(pWD, pNameD, pNodeS->type, pNodeS->num)) {
					if ((pNodeD = AjcVmgGetNodeA(pWD, pNameD)) == NULL) {rc = FALSE; break;}
				}
				else {rc = FALSE; break;}
				//	変数の内容コピー
				for (ix = 0; ix < pNodeD->num; ix++) {
					switch (pNodeD->type) {
						case AJCVMGT_INT:	pNodeD->arr.pSI [ix] = pNodeS->arr.pSI [ix]; break;
						case AJCVMGT_LONG:	pNodeD->arr.pSLL[ix] = pNodeS->arr.pSLL[ix]; break;
						case AJCVMGT_REAL:	pNodeD->arr.pDBL[ix] = pNodeS->arr.pDBL[ix]; break;
						case AJCVMGT_STR:
						{	BCP	pTmp;
							UI	stl = (UI)strlen(pNodeS->arr.pStr[ix]) + 1;
							if (pTmp = AjcTAllocA(stl)) {
								strcpy(pTmp, pNodeS->arr.pStr[ix]);
								if (pNodeD->arr.pStr[ix] != NULL) {
									AjcTFree(pNodeD->arr.pStr[ix]);
								}
								pNodeD->arr.pStr[ix] = pTmp;
							}
							else rc = FALSE;
							break;
						}
					}
				}
				//	エラーならば、コピー先変数削除
				if (rc == FALSE) {
					AjcVmgDelVarA(pWD, pNameD);
				}
			}
		} while (0);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI AjcVmgCopyW(HAJCVMGW pWD, C_WCP pNameD, HAJCVMGW pWS, C_WCP pNameS)
{
	BOOL			rc     = TRUE;
	PCAJCVMGNODEW	pNodeS = NULL;
	PCAJCVMGNODEW	pNodeD = NULL;
	UI				ix     = 0;

	if (IS_MY_INST(pWD) && pNameD != NULL && IS_MY_INST(pWS) && pNameS != NULL) {
		do {
			//	コピー元ノード取得
			if ((pNodeS = AjcVmgGetNodeW(pWS, pNameS)) == NULL) {rc = FALSE; break;}
			//	コピー先ノード取得
			pNodeD = AjcVmgGetNodeW(pWD, pNameD);

			if (pNodeD == NULL || !(pNodeD->att & AJCVMGA_RDONLY)) { // コピー先変数無し／書き込み可？
				//	コピー先変数削除
				AjcVmgDelVarW(pWD, pNameD);
				//	コピー先変数を作成しノード取得
				if (AjcVmgGenVarW(pWD, pNameD, pNodeS->type, pNodeS->num)) {
					if ((pNodeD = AjcVmgGetNodeW(pWD, pNameS)) == NULL) {rc = FALSE; break;}
				}
				else {rc = FALSE; break;}
				//	変数の内容コピー
				for (ix = 0; ix < pNodeD->num; ix++) {
					switch (pNodeD->type) {
						case AJCVMGT_INT:	pNodeD->arr.pSI [ix] = pNodeS->arr.pSI [ix]; break;
						case AJCVMGT_LONG:	pNodeD->arr.pSLL[ix] = pNodeS->arr.pSLL[ix]; break;
						case AJCVMGT_REAL:	pNodeD->arr.pDBL[ix] = pNodeS->arr.pDBL[ix]; break;
						case AJCVMGT_STR:
						{	WCP	pTmp;
							UI	stl = (UI)wcslen(pNodeS->arr.pStr[ix]) + 1;
							if (pTmp = AjcTAllocW(stl)) {
								wcscpy(pTmp, pNodeS->arr.pStr[ix]);
								if (pNodeD->arr.pStr[ix] != NULL) {
									AjcTFree(pNodeD->arr.pStr[ix]);
								}
								pNodeD->arr.pStr[ix] = pTmp;
							}
							else rc = FALSE;
							break;
						}
					}
				}
				//	エラーならば、コピー先変数削除
				if (rc == FALSE) {
					AjcVmgDelVarW(pWD, pNameD);
				}
			}
		} while (0);
	}
	return rc;
}
