﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	ボリュームラベル操作																						//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	指定したドライブのボリュームラベル名を取得します。															//
//																												//
//	引　数　：　Drive	- ドライブレター（'a' - 'z'）															//
//				pBuf	- ボリューム名を格納するバッファのアドレス												//
//				bfl		- ボリューム名を格納するバッファのバイト数／文字数										//
//																												//
//	戻り値　：　TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcGetVolumeLabelA(UI drive, BCP pBuf, UI lBuf)
{
	BOOL	rc = FALSE;
	UI		drvs = GetLogicalDrives();
	UI		drv  = tolower(drive);
	UI		msk;
	BC		path[MAX_PATH];

	if (pBuf != NULL && lBuf != 0 && drv >= 'a' && drv <= 'z') {
		msk = 0x01 << (drv - 'a');
		if (drvs & msk) {
			AjcSnPrintFA(path, MAX_PATH, "%c:\\", drv);
			if (GetVolumeInformationA(path, pBuf, lBuf, NULL, NULL, NULL, NULL, 0)) {
				rc = TRUE;
			}
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcGetVolumeLabelW(UI drive, WCP pBuf, UI lBuf)
{
	BOOL	rc = FALSE;
	UI		drvs = GetLogicalDrives();
	UI		drv  = tolower(drive);
	UI		msk;
	WC		path[MAX_PATH];

	if (pBuf != NULL && lBuf != 0 && drv >= 'a' && drv <= 'z') {
		msk = 0x01 << (drv	- 'a');
		if (drvs & msk) {
			AjcSnPrintFW(path, MAX_PATH, L"%c:\\", drv);
			if (GetVolumeInformationW(path, pBuf, lBuf, NULL, NULL, NULL, NULL, 0)) {
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ボリュームラベル名からドライブ種別取得																		//
//																												//
//	引　数　：　pVol	- ボリューム名へのポインタ																//
//																												//
//	戻り値　：　'a' ～ 'z' - OK	（ドライブ）																	//
//				0		   - Error																				//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcGetDriveByVolumeLabelA(C_BCP pVol)
{
	UI		rc	 = 0;
	UI		drvs = GetLogicalDrives();
	UI		drv  = 'a';
	UI		msk  = 0x01;
	BC		vol[MAX_PATH];

	for (drv = 'a'; drv <= 'z'; drv++) {
		if (drvs & msk) {
			if (AjcGetVolumeLabelA(drv, vol, MAX_PATH)) {
				if (strcmp(vol, pVol) == 0) {
					rc = drv;
					break;
				}
			}
		}
		msk <<= 1;
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcGetDriveByVolumeLabelW(C_WCP pVol)
{
	UI		rc	 = 0;
	UI		drvs = GetLogicalDrives();
	UI		drv  = 'a';
	UI		msk  = 0x01;
	WC		vol[MAX_PATH];

	for (drv = 'a'; drv <= 'z'; drv++) {
		if (drvs & msk) {
			if (AjcGetVolumeLabelW(drv, vol, MAX_PATH)) {
				if (wcscmp(vol, pVol) == 0) {
					rc = drv;
					break;
				}
			}
		}
		msk <<= 1;
	}
	return rc;
}
//==============================================================================================================//
//	ボリューム表現のパス名チェック																				//
//																												//
//	引　数　：　pPath	- パス名へのポインタ																	//
//																												//
//	戻り値　：　TRUE  - ボリューム表現のパス名である															//
//				FALSE - ボリューム表現のパス名以外																//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcIsVolExpPathA(C_BCP pPath)
{
	BOOL	rc = FALSE;

	if (pPath != NULL && *pPath == '<' && mbsstr(pPath + 1, ">:")) {
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcIsVolExpPathW(C_WCP pPath)
{
	BOOL	rc = FALSE;

	if (pPath != NULL && *pPath == L'<' && wcsstr(pPath + 1, L">:")) {
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ボリューム表現のパス名を通常のパス名に変更																	//
//																												//
//	引　数　：　pVolExp	- ボリューム表現のパス名へのポインタ													//
//				pPath	- 通常のパス名を格納するバッファへのポインタ											//
//																												//
//	戻り値　：　TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVolExpPathToNormalPathA(C_BCP pVolExp, BC path[MAX_PATH])
{
	BOOL	rc	= FALSE;
	UI		drv = 0;
	BCP		pNxt = NULL;
	BC		volp[MAX_PATH];

	if (pVolExp != NULL && path != NULL) {
		AjcSnPrintFA(volp, MAX_PATH, "%s", pVolExp);
		//	ボリューム表現のパス名ならば、通常のパス名に変更
		if (AjcIsVolExpPathA(volp)) {
			pNxt = AjcStrStripEncloseA(volp);
			//	ボリューム名に対応するドライブ取得し、通常のパス名生成
			if (drv = AjcGetDriveByVolumeLabelA(volp)) {
				AjcSnPrintFA(path, MAX_PATH, "%c%s", drv, pNxt);
				rc = TRUE;
			}
			//	ボリュームラベルが見つからない場合、通常のパス名にコピー
			else {
				AjcSnPrintFA(path, MAX_PATH, "%s%s", volp, pNxt);
				rc = FALSE;	//	エラー（ボリュームラベルが見つからない）
			}
		}
		//	//	ボリューム表現のパス名以外ならば、通常のパス名にコピー
		else {
			AjcSnPrintFA(path, MAX_PATH, "%s", volp);
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVolExpPathToNormalPathW(C_WCP pVolExp, WC path[MAX_PATH])
{
	BOOL	rc	= FALSE;
	UI		drv = 0;
	WCP		pNxt = NULL;
	WC		volp[MAX_PATH];

	if (pVolExp != NULL && path != NULL) {
		AjcSnPrintFW(volp, MAX_PATH, L"%s", pVolExp);
		//	ボリューム表現のパス名ならば、通常のパス名に変更
		if (AjcIsVolExpPathW(volp)) {
			pNxt = AjcStrStripEncloseW(volp);
			//	ボリューム名に対応するドライブ取得し、通常のパス名生成
			if (drv = AjcGetDriveByVolumeLabelW(volp)) {
				AjcSnPrintFW(path, MAX_PATH, L"%c%s", drv, pNxt);
				rc = TRUE;
			}
			//	ボリュームラベルが見つからない場合、通常のパス名にコピー
			else {
				AjcSnPrintFW(path, MAX_PATH, L"%s%s", volp, pNxt);
				rc = FALSE;	//	エラー（ボリュームラベルが見つからない）
			}
		}
		//	ボリューム表現のパス名以外ならば、通常のパス名にコピー
		else {
			AjcSnPrintFW(path, MAX_PATH, L"%s", volp);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	通常のパス名をボリューム表現のパス名に変更																	//
//																												//
//	引　数　：　pPath	- 通常のパス名をへのポインタ															//
//				pVolExp	- ボリューム表現のパス名を格納するバッファへのポインタ									//
//																												//
//	戻り値　：　TRUE  - 成功																					//
//				FALSE - 失敗（ドライブ無し）																	//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcNormalPathToVolExpPathA(C_BCP pPath, BC VolExp[MAX_PATH])
{
	BOOL	rc	= FALSE;
	UI		drv = 0;
	BC		path[MAX_PATH];
	BC		vol [MAX_PATH];

	if (pPath != NULL && VolExp != NULL) {
		AjcSnPrintFA(path, MAX_PATH, "%s", pPath);
		//	絶対パス名ならば、ボリューム表現のパス名に変更
		if (MAjcIsAlphaA(path[0]) && path[1] == ':') {
			//	ドライブのボリューム名取得成功ならば、ボリューム表現のパス名生成
			if (AjcGetVolumeLabelA(path[0], vol, MAX_PATH)) {
				AjcSnPrintFA(VolExp, MAX_PATH, "<%s>%s", vol, &path[1]);
				rc = TRUE;
			}
			//	ドライブのボリューム名取得失敗ならば、ボリューム表現のパス名へコピー
			else {
				AjcSnPrintFA(VolExp, MAX_PATH, "%s", path);
				rc = FALSE;		//	エラー（ドライブなし）
			}
		}
		//	絶対パス名以外ならば、ボリューム表現のパス名へコピー
		else {
			AjcSnPrintFA(VolExp, MAX_PATH, "%s", path);
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcNormalPathToVolExpPathW(C_WCP pPath, WC VolExp[MAX_PATH])
{
	BOOL	rc	= FALSE;
	UI		drv = 0;
	WC		path[MAX_PATH];
	WC		vol [MAX_PATH];

	if (pPath != NULL && VolExp != NULL) {
		AjcSnPrintFW(path, MAX_PATH, L"%s", pPath);
		//	絶対パス名ならば、ボリューム表現のパス名に変更
		if (MAjcIsAlphaW(path[0]) && path[1] == L':') {
			//	ドライブのボリューム名取得成功ならば、ボリューム表現のパス名生成
			if (AjcGetVolumeLabelW(path[0], vol, MAX_PATH)) {
				AjcSnPrintFW(VolExp, MAX_PATH, L"<%s>%s", vol, &path[1]);
				rc = TRUE;
			}
			//	ドライブのボリューム名取得失敗ならば、ボリューム表現のパス名へコピー
			else {
				AjcSnPrintFW(VolExp, MAX_PATH, L"%s", path);
				rc = FALSE;		//	エラー（ドライブなし）
			}
		}
		//	絶対パス名以外ならば、ボリューム表現のパス名へコピー
		else {
			AjcSnPrintFW(VolExp, MAX_PATH, L"%s", path);
			rc = TRUE;
		}
	}
	return rc;
}


