﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	ウインド項目																								//
//																												//
//**************************************************************************************************************//

#define	CBOLISTA		 "_AJCLISTDATA_"
#define	CBOLISTW		L"_AJCLISTDATA_"

/****************************************************************************************************************/
/*																												*/
/*	コントロールの設定／取得																					*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	数値取得																									//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//																												//
//	戻り値：	読み出した値（失敗時は０）																		//
//==============================================================================================================//
#define	M_GETWNDITEMN(_T1_, _T2_, _BS_, _CV_)						\
AJCEXPORT _T1_	WINAPI AjcGetCtrl##_T2_(HWND hwnd)					\
{	_T1_	rc = 0;													\
	BOOL	fHex;													\
	BCP		p;														\
	BC		buf[_BS_];												\
	if (IsWindow(hwnd)) {											\
		if (GetPropA(hwnd, SBCRADIOBTNS_GROUP_PROPNAMEA) == NULL) {	\
			if (GetWindowTextA(hwnd, buf, _BS_) != 0) {				\
				for (p=buf; MAjcIsSpaceA(*p); p++);					\
				fHex = (strnicmp(p, "0x", 2) == 0);					\
				if (fHex) p += 2;									\
				else	  AjcStrRmvSepCharA(p);						\
				rc = (_T1_)(_CV_);									\
			}														\
		}															\
		else {														\
			rc = (_T1_)AjcSbcGetRbt(hwnd);							\
		}															\
	}																\
	return rc;														\
}
M_GETWNDITEMN(UI	, UInt,	 32, fHex ? AjcHexToUIA(p) : AjcDecToUIA(p))
M_GETWNDITEMN(SI	, SInt,	 32, fHex ? AjcHexToUIA(p) : atoi(p))
M_GETWNDITEMN(UI	, Hex ,	 32, fHex ? AjcHexToUIA(p) : AjcDecToUIA(p))
M_GETWNDITEMN(double, Real, 512, atof(p))
M_GETWNDITEMN(ULL	, UI64,	 64, fHex ? AjcHexToULLA(p) : AjcDecToULLA(p))
M_GETWNDITEMN(SLL	, SI64,	 64, fHex ? AjcHexToULLA(p) : _atoi64(p))
M_GETWNDITEMN(ULL	, H64 ,	 64, fHex ? AjcHexToULLA(p) : AjcDecToULLA(p))

//==============================================================================================================//
//	数値設定（整数）																							//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				value	- 設定値																				//
//				opt		- 書式オプション																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
#define	M_SETWNDITEMN(_T1_, _T2_, _BS_, _CV_)											\
AJCEXPORT BOOL	WINAPI AjcSetOptCtrl##_T2_(HWND hwnd, _T1_ value, int opt)				\
{	BOOL	rc = FALSE;																	\
	BC		buf[_BS_];																	\
	if (IsWindow(hwnd)) {																\
		if (GetProp(hwnd, SBCRADIOBTNS_GROUP_PROPNAME) == NULL) {						\
			_CV_;																		\
			rc = SetWindowTextA(hwnd, buf);												\
		}																				\
		else {																			\
			rc = AjcSbcSetRbt(hwnd, (UI)value);											\
		}																				\
	}																					\
	return rc;																			\
}
M_SETWNDITEMN(UI	, UInt,	 32, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%u", value)					:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%u", value))

M_SETWNDITEMN(SI	, SInt,	 32, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%d", value)					:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%d", value))

M_SETWNDITEMN(UI	, Hex ,	 32, (opt & AJCSEP) ? AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%0*X", (opt & 255), value):
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%X"				, value))

M_SETWNDITEMN(UB	, UI8 ,	  8, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%u", value)					:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%u", value))

M_SETWNDITEMN(SB	, SI8 ,	  8, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%d", value)					:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%d", value))

M_SETWNDITEMN(UB	, H8  ,	  8, (opt & AJCSEP) ? AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%0*X", (opt & 255), value):
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%X"				 , value))

M_SETWNDITEMN(UW	, UI16,	 16, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%u", value)					:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%u", value))

M_SETWNDITEMN(SW	, SI16,	 16, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%d", value)					:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%d", value))

M_SETWNDITEMN(UW	, H16 ,	 16, (opt & AJCSEP) ? AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%0*X", (opt & 255), value):
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%X"				 , value))

M_SETWNDITEMN(ULL	, UI64,	 64, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%I64u", value)				:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%I64u", value))

M_SETWNDITEMN(SLL	, SI64,	 64, (opt & AJCSEP) ? AjcSnPrtSepA(buf, AJCTSIZE(buf), "%I64d", value)				:
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "%I64d", value))

M_SETWNDITEMN(ULL	, H64 ,	 64, (opt & AJCSEP) ? AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%0*I64X", (opt & 255), value):
												  AjcSnPrintFA(buf, AJCTSIZE(buf), "0x%I64X"				, value))

//==============================================================================================================//
//	数値設定（実数）																							//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				value	- 設定値																				//
//				opt		- 書式オプション																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcSetOptCtrlReal(HWND hwnd, double value, int opt)
{
	BOOL	rc = FALSE;
	BC		buf[512];

	if (IsWindow(hwnd)) {
		if (opt & 0x80) {
			if (opt & AJCSEP) AjcSnPrtSepA(buf, AJCTSIZE(buf), "%.*G", ((~opt + 1) & 0x7F), value);
			else			  AjcSnPrintFA(buf, AJCTSIZE(buf), "%.*G", ((~opt + 1) & 0x7F), value);
		}
		else {
			if (opt & AJCSEP) AjcSnPrtSepA(buf, AJCTSIZE(buf), "%.*f", (opt & 0x7F), value);
			else			  AjcSnPrintFA(buf, AJCTSIZE(buf), "%.*f", (opt & 0x7F), value);
		}
		rc = SetWindowTextA(hwnd, buf);
	}
	return rc;
}

//----- 10進の区切りをつけない／16進を桁揃えしない -------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcSetCtrlUInt(HWND hwnd, UI		value)			 {return AjcSetOptCtrlUInt(hwnd, value, 0);}
AJCEXPORT BOOL	WINAPI AjcSetCtrlSInt(HWND hwnd, SI		value)			 {return AjcSetOptCtrlSInt(hwnd, value, 0);}
AJCEXPORT BOOL	WINAPI AjcSetCtrlHex (HWND hwnd, UI		value)			 {return AjcSetOptCtrlHex (hwnd, value, 0);}
AJCEXPORT BOOL	WINAPI AjcSetCtrlReal(HWND hwnd, double value, int prec) {return AjcSetOptCtrlReal(hwnd, value, (prec & 255));}
AJCEXPORT BOOL	WINAPI AjcSetCtrlUI64(HWND hwnd, ULL	value)			 {return AjcSetOptCtrlUI64(hwnd, value, 0);}
AJCEXPORT BOOL	WINAPI AjcSetCtrlSI64(HWND hwnd, SLL	value)			 {return AjcSetOptCtrlSI64(hwnd, value, 0);}
AJCEXPORT BOOL	WINAPI AjcSetCtrlH64 (HWND hwnd, ULL	value)			 {return AjcSetOptCtrlH64 (hwnd, value, 0);}

//----- 10進の区切りをつける／16進を桁揃えする -----------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcSepCtrlUInt(HWND hwnd, UI		value)			 {return AjcSetOptCtrlUInt(hwnd, value, AJCSEP);}
AJCEXPORT BOOL	WINAPI AjcSepCtrlSInt(HWND hwnd, SI		value)			 {return AjcSetOptCtrlSInt(hwnd, value, AJCSEP);}
AJCEXPORT BOOL	WINAPI AjcSepCtrlHex (HWND hwnd, UI		value, int col ) {return AjcSetOptCtrlHex (hwnd, value, AJCSEP | (col  & 255));}
AJCEXPORT BOOL	WINAPI AjcSepCtrlReal(HWND hwnd, double value, int prec) {return AjcSetOptCtrlReal(hwnd, value, AJCSEP | (prec & 255));}
AJCEXPORT BOOL	WINAPI AjcSepCtrlUI64(HWND hwnd, ULL	value)			 {return AjcSetOptCtrlUI64(hwnd, value, AJCSEP);}
AJCEXPORT BOOL	WINAPI AjcSepCtrlSI64(HWND hwnd, SLL	value)			 {return AjcSetOptCtrlSI64(hwnd, value, AJCSEP);}
AJCEXPORT BOOL	WINAPI AjcSepCtrlH64 (HWND hwnd, ULL	value, int col ) {return AjcSetOptCtrlH64 (hwnd, value, AJCSEP | (col  & 255));}

//==============================================================================================================//
//	文字列取得																									//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//																												//
//	戻り値：	≠０：取得した文字長																			//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetCtrlStrA (HWND hwnd, BCP pBuf, UI lBuf)
{
	UI	rc = 0;

	if (IsWindow(hwnd) && pBuf != NULL && lBuf != 0) {
		rc = GetWindowTextA(hwnd, pBuf, lBuf);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetCtrlStrW (HWND hwnd, WCP pBuf, UI lBuf)
{
	UI	rc = 0;

	if (IsWindow(hwnd) && pBuf != NULL && lBuf != 0) {
		rc = GetWindowTextW(hwnd, pBuf, lBuf);
	}
	return rc;
}
//==============================================================================================================//
//	文字列の長さ取得																							//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//																												//
//	戻り値：	≠０：文字長																					//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetCtrlStrLenA(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		rc = GetWindowTextLengthA(hwnd);
	}

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetCtrlStrLenW(HWND hwnd)
{
	UI		rc	  = 0;

	if (IsWindow(hwnd)) {
		rc = GetWindowTextLengthW(hwnd);
	}

	return rc;
}
//==============================================================================================================//
//	文字列設定																									//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				pStr	- 設定する文字列のアドレス																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlStrA (HWND hwnd, C_BCP pStr)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && pStr != NULL) {
		rc = (SetWindowTextA(hwnd, pStr) != 0);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlStrW (HWND hwnd, C_WCP pStr)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && pStr != NULL) {
		rc = (SetWindowTextW(hwnd, pStr) != 0);
	}
	return rc;
}
//==============================================================================================================//
//	書式文字列設定																								//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				pFmt	- 書式文字列のアドレス																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlFStrA (HWND hwnd, C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC	txt[1024];

	if (IsWindow(hwnd) && pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf(txt, 1024, pFmt, vls);
		va_end	(vls);
		txt[1023] = 0;
		rc = (SetWindowTextA(hwnd, txt) != 0);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlFStrW (HWND hwnd, C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	WC	txt[1024];

	if (IsWindow(hwnd) && pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf(txt, 1024, pFmt, vls);
		va_end	(vls);
		txt[1023] = 0;
		rc = (SetWindowTextW(hwnd, txt) != 0);
	}
	return rc;
}

//==============================================================================================================//
//	チェックボックス状態取得																					//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//																												//
//	戻り値：	チェック状態																					//
//==============================================================================================================//
AJCEXPORT UI	 WINAPI AjcGetCtrlChk (HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		rc = (UI)SendMessage(hwnd, BM_GETCHECK, 0, 0);
	}
	return rc;
}

//==============================================================================================================//
//	チェックボックス状態設定																					//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				state	- 設定する状態																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlChk (HWND hwnd, UI state)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = (UI)SendMessage(hwnd, BM_SETCHECK, state, 0);
	}
	return rc;
}

//==============================================================================================================//
//	エディットコントロールの入力可能文字数設定																	//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				state	- 設定する状態																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlEdtLimitA(HWND hwnd, UI limit)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessageA(hwnd, EM_SETLIMITTEXT, limit, 0);
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlEdtLimitW(HWND hwnd, UI limit)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessageW(hwnd, EM_SETLIMITTEXT, limit, 0);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス／コンボボックス選択項目のインデクス取得														//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	選択されている項目のインデクス／CB_ERR															//
//==============================================================================================================//
//	リストボックス／コンボボックス コマンド選択
#define	SELCMD(LST_CMD, CBO_CMD)	((fLst) ? (LST_CMD) : (CBO_CMD))

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstIx(HWND hwnd)
{
	UI		rc = -1;
	UI		sty;
	int		i, n;

	sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
	if (sty & LBS_MULTIPLESEL) {
		n = (int)SendMessage(hwnd, LB_GETCOUNT, 0, 0);
		for (i = 0; i < n; i++) {
			if ((int)SendMessage(hwnd, LB_GETSEL, i, 0) > 0) {
				rc = i;
				break;
			}
		}
	}
	else {
		rc = (UI)SendMessage(hwnd, LB_GETCURSEL, 0, 0);
	}
	return rc;
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboIx(HWND hwnd)
{
	return (UI)SendMessage(hwnd, CB_GETCURSEL, 0, 0);
}
//==============================================================================================================//
//	リストボックス／コンボボックスの項目数取得																	//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	コンボボックスの項目数																			//
//==============================================================================================================//
static	UI	 SubGetCtrlLstCboCount(HWND hwnd, BOOL fLst)
{
	UI	rc = CB_ERR;

	if (IsWindow(hwnd)) {
		rc = (UI)SendMessage(hwnd, SELCMD(LB_GETCOUNT, CB_GETCOUNT), 0, 0);
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstCount(HWND hwnd)
{
	return SubGetCtrlLstCboCount(hwnd, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboCount(HWND hwnd)
{
	return SubGetCtrlLstCboCount(hwnd, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックス項目のテキスト長取得															//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 項目インデクス（－１の場合は現在の選択項目）										//
//																												//
//	戻り値：	コンボボックス項目の文字列長																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboLenA (HWND hwnd, UI ix, BOOL fLst)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		if (ix == -1) {
			if (fLst) ix = AjcGetCtrlLstIx(hwnd);
			else	  ix = AjcGetCtrlCboIx(hwnd);
		}
		rc = (UI)SendMessageA(hwnd, SELCMD(LB_GETTEXTLEN, CB_GETLBTEXTLEN), (int)ix, 0);
		if (rc == CB_ERR) rc = 0;
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstLenA (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboLenA(hwnd, ix, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboLenA (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboLenA(hwnd, ix, FALSE);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboLenW (HWND hwnd, UI ix, BOOL fLst)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		if (ix == -1) {
			ix = (UI)SendMessageW(hwnd, SELCMD(LB_GETCURSEL, CB_GETCURSEL), 0, 0);
		}
		rc = (UI)SendMessageW(hwnd, SELCMD(LB_GETTEXTLEN, CB_GETLBTEXTLEN), (int)ix, 0);
		if (rc == CB_ERR) rc = 0;
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstLenW (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboLenW(hwnd, ix, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboLenW (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboLenW(hwnd, ix, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックス項目のテキスト取得															//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 項目インデクス（－１の場合は現在の選択項目）										//
//				pBuf	  - 取得したテキストを格納するバッファのアドレス										//
//				lBuf	  - 取得したテキストを格納するバッファの文字数											//
//																												//
//	戻り値：	コンボボックス項目のテキスト長（エラー時は０）													//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboItemA(HWND hwnd, UI ix, BCP pBuf, UI lBuf, BOOL fLst)
{
	UI		rc = 0;
	UI		len;
	BCP		pTmp;

	if (IsWindow(hwnd) && pBuf != NULL && lBuf != 0) {
		do {
			if (ix == -1) {
				ix = (UI)SendMessageA(hwnd, SELCMD(LB_GETCURSEL, CB_GETCURSEL), 0, 0);
			}
			if (ix	== CB_ERR) break;
			len = (UI)SendMessageA(hwnd, SELCMD(LB_GETTEXTLEN, CB_GETLBTEXTLEN), (int)ix, 0);
			if (len == CB_ERR) break;
			if (lBuf > len) {
				rc = (UI)SendMessageA(hwnd, SELCMD(LB_GETTEXT, CB_GETLBTEXT), (int)ix, (LPARAM)pBuf);
				if (rc == CB_ERR) rc = 0;
			}
			else {
				if (pTmp = AjcTAllocA(len + 1)) {
					rc = (UI)SendMessageA(hwnd, SELCMD(LB_GETTEXT, CB_GETLBTEXT), (int)ix, (LPARAM)pTmp);
					if (rc != CB_ERR) {
						strncpy(pBuf, pTmp, lBuf);
						pBuf[lBuf - 1] = 0;
					}
					else rc = 0;
					AjcTFree(pTmp);
				}
			}
		} while(0);
	}
	if (rc == 0 && pBuf != NULL && lBuf != 0) {
		*pBuf = 0;
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstItemA(HWND hwnd, UI ix, BCP pBuf, UI lBuf)
{
	return SubGetCtrlLstCboItemA(hwnd, ix, pBuf, lBuf, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboItemA(HWND hwnd, UI ix, BCP pBuf, UI lBuf)
{
	return SubGetCtrlLstCboItemA(hwnd, ix, pBuf, lBuf, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboItemW(HWND hwnd, UI ix, WCP pBuf, UI lBuf, BOOL fLst)
{
	UI		rc = 0;
	UI		len;
	WCP		pTmp;

	if (IsWindow(hwnd) && pBuf != NULL && lBuf != 0) {
		do {
			if (ix == -1) {
				ix = (UI)SendMessageW(hwnd, SELCMD(LB_GETCURSEL, CB_GETCURSEL), 0, 0);
			}
			if (ix	== CB_ERR) break;
			len = (UI)SendMessageW(hwnd, SELCMD(LB_GETTEXTLEN, CB_GETLBTEXTLEN), (int)ix, 0);
			if (len == CB_ERR) break;
			if (lBuf > len) {
				rc = (UI)SendMessageW(hwnd, SELCMD(LB_GETTEXT, CB_GETLBTEXT), (int)ix, (LPARAM)pBuf);
				if (rc == CB_ERR) rc = 0;
			}
			else {
				if (pTmp = AjcTAllocW(len + 1)) {
					rc = (UI)SendMessageW(hwnd, SELCMD(LB_GETTEXT, CB_GETLBTEXT), (int)ix, (LPARAM)pTmp);
					if (rc != CB_ERR) {
						wcsncpy(pBuf, pTmp, lBuf);
						pBuf[lBuf - 1] = 0;
					}
					else rc = 0;
					AjcTFree(pTmp);
				}
			}
		} while(0);
	}
	if (rc == 0 && pBuf != NULL && lBuf != 0) {
		*pBuf = 0;
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstItemW(HWND hwnd, UI ix, WCP pBuf, UI lBuf)
{
	return SubGetCtrlLstCboItemW(hwnd, ix, pBuf, lBuf, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboItemW(HWND hwnd, UI ix, WCP pBuf, UI lBuf)
{
	return SubGetCtrlLstCboItemW(hwnd, ix, pBuf, lBuf, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックス項目に関連付けられた数値取得													//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	コンボボックス項目に関連付けられた数値															//
//==============================================================================================================//
static	SX	 SubGetCtrlLstCboData (HWND hwnd, UI ix, BOOL fLst)
{
	SX	rc = 0;

	if (IsWindow(hwnd)) {
		if (ix == -1) {
			ix = (UI)SendMessage(hwnd, SELCMD(LB_GETCURSEL, CB_GETCURSEL), 0, 0);
		}
		rc = (SX)SendMessage(hwnd, SELCMD(LB_GETITEMDATA, CB_GETITEMDATA), (int)ix, 0);
	}
	return rc;
}
//	リストボックス
AJCEXPORT SX	 WINAPI AjcGetCtrlLstData (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboData (hwnd, ix, TRUE);
}
//	コンボボックス
AJCEXPORT SX	 WINAPI AjcGetCtrlCboData (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboData (hwnd, ix, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックス項目の文字列検索																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 検索開始項目インデクス（指定された次の項目から開始，－１の場合は先頭から開始する）	//
//				pStr	  - 検索する文字列のアドレス															//
//				flag	  - 検索方法（AJCCBF_EXACT_STR, AJCCBF_EXACT_WIDTH, AJCCBF_SELECT)						//
//																												//
//	戻り値：	≠－１：見つかった項目のインデクス																//
//				＝－１：文字列は見つからない／エラー															//
//==============================================================================================================//
static	UI	 SubGetCtrlLstCboMaxLenA (HWND hwnd, BOOL fLst);
static	UI	 SubGetCtrlLstCboMaxLenW (HWND hwnd, BOOL fLst);

static	UI	SubGetCtrlLstCboFindW (HWND hwnd, UI ix, C_WCP pStr, UI flag, BOOL fLst);
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboFindA (HWND hwnd, UI ix, C_BCP pStr, UI flag, BOOL fLst)
{
	UI		rc	  = -1;
	UI		lStrW = 0;
	WCP		pStrW = NULL;

	if (IsWindow(hwnd) && pStr != NULL) {
		lStrW = MultiByteToWideChar(CP_ACP, 0, pStr, -1, NULL, 0);
		if (pStrW = AjcTAllocW(lStrW)) {
			MultiByteToWideChar(CP_ACP, 0, pStr, -1, pStrW, lStrW);
			rc = SubGetCtrlLstCboFindW(hwnd, ix, pStrW, flag, fLst);
			AjcTFree(pStrW);
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstFindA (HWND hwnd, UI ix, C_BCP pStr, UI flag)
{
	return SubGetCtrlLstCboFindA(hwnd, ix, pStr, flag, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboFindA (HWND hwnd, UI ix, C_BCP pStr, UI flag)
{
	return SubGetCtrlLstCboFindA(hwnd, ix, pStr, flag, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	UI	SubGetCtrlLstCboFindW (HWND hwnd, UI ix, C_WCP pStr, UI flag, BOOL fLst)
{
	UI		rc = -1;
	SI		n, i, lmax, rsu;
	WCP		pLB = NULL;

	if (IsWindow(hwnd) && pStr != NULL) {
		if (flag & AJCCBF_EXACT_WIDTH) {	//	英大小区別あり？
			if ((lmax = SubGetCtrlLstCboMaxLenW(hwnd, fLst)) != -1) {		//	最大文字列長取得成功？
				if (pLB = AjcTAllocW(lmax + 1)) {							//	バッファ確保成功
					if ((n = (SI)SendMessageW(hwnd, SELCMD(LB_GETCOUNT, CB_GETCOUNT), 0, 0)) > 0) {
						for (i = 0, ix = ((ix + 1) % n); i < n; i++, ix = ((ix + 1) % n)) {
							//	項目の文字列長取得
							if ((SendMessageW(hwnd, SELCMD(LB_GETTEXT, CB_GETLBTEXT), ix, (LPARAM)pLB)) < 0) break;	//	文字列取得失敗
							//	文字列全体比較
							if (flag & AJCCBF_EXACT) {
								rsu = wcscmp(pLB, pStr);
							}
							//	文字列先頭部分比較
							else {
								rsu = wcsncmp(pLB, pStr, wcslen(pStr));
							}
							//	比較一致チェック
							if (rsu == 0) {
								//	選択状態設定
								if (flag & AJCCBF_SELECT) {
									if (fLst) AjcSetCtrlLstIx(hwnd, ix);
									else	  AjcSetCtrlCboIx(hwnd, ix);
								}
								//	戻り値＝見つかった項目のインデクス
								rc = ix;
								break;
							}
						}
					}
					//	バッファ解放
					AjcTFree(pLB); pLB = NULL;
				}
			}
		}
		else {								//	英大小区別なし？
			if (flag & AJCCBF_EXACT) rsu = (SI)SendMessageW(hwnd, SELCMD(LB_FINDSTRINGEXACT, CB_FINDSTRINGEXACT), (int)ix, (LPARAM)pStr);
			else					 rsu = (SI)SendMessageW(hwnd, SELCMD(LB_FINDSTRING	   , CB_FINDSTRING	   ), (int)ix, (LPARAM)pStr);

			if (rsu >= 0) {
				if (flag & AJCCBF_SELECT) {
					if (fLst) AjcSetCtrlLstIx(hwnd, rsu);
					else	  AjcSetCtrlCboIx(hwnd, rsu);
				}
				rc = (UI)rsu;
			}
			else rc = -1;
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstFindW (HWND hwnd, UI ix, C_WCP pStr, UI flag)
{
	return SubGetCtrlLstCboFindW(hwnd, ix, pStr, flag, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboFindW (HWND hwnd, UI ix, C_WCP pStr, UI flag)
{
	return SubGetCtrlLstCboFindW(hwnd, ix, pStr, flag, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックスの最大文字列長取得															//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	≠－１：最大文字列長（終端(0x00)は含まない，項目が1つも無い場合は０を返す）						//
//				＝－１：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboMaxLenA (HWND hwnd, BOOL fLst)
{
	UI		rc = -1;
	SI		i, n, stl, len;

	if (IsWindow(hwnd)) {
		if ((n = (SI)SendMessageA(hwnd, SELCMD(LB_GETCOUNT, CB_GETCOUNT), 0, 0)) >= 0) {	//	項目数取得成功？
			len = 0;
			for (i = 0; i < n; i++) {
				if ((stl = (SI)SendMessageA(hwnd, SELCMD(LB_GETTEXTLEN, CB_GETLBTEXTLEN), i, 0)) >= 0) {	//	文字列長取得成功？
					len = __max(len, stl);
				}
			}
			rc = (UI)len;
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstMaxLenA (HWND hwnd)
{
	return SubGetCtrlLstCboMaxLenA(hwnd, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboMaxLenA (HWND hwnd)
{
	return SubGetCtrlLstCboMaxLenA(hwnd, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubGetCtrlLstCboMaxLenW (HWND hwnd, BOOL fLst)
{
	UI		rc = -1;
	SI		i, n, stl, len;

	if (IsWindow(hwnd)) {
		if ((n = (SI)SendMessageW(hwnd, SELCMD(LB_GETCOUNT, CB_GETCOUNT), 0, 0)) >= 0) {					//	項目数取得成功？
			len = 0;
			for (i = 0; i < n; i++) {
				if ((stl = (SI)SendMessageW(hwnd, SELCMD(LB_GETTEXTLEN, CB_GETLBTEXTLEN), i, 0)) >= 0) {	//	文字列長取得成功？
					len = __max(len, stl);
				}
			}
			rc = (UI)len;
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstMaxLenW (HWND hwnd)
{
	return SubGetCtrlLstCboMaxLenW (hwnd, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboMaxLenW (HWND hwnd)
{
	return SubGetCtrlLstCboMaxLenW (hwnd, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックスの項目の高さ取得																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 項目のインデクス(XXX_OWNERDRAWFIXED時は0固定)										//
//																												//
//	戻り値：	≠－１：項目の高さ																				//
//				＝－１：エラー																					//
//==============================================================================================================//
static	UI	 SubGetCtrlLstCboHeight(HWND hwnd, UI ix, BOOL fLst)
{
	UI		rc = -1;

	if (IsWindow(hwnd)) {
		rc = (UI)SendMessage(hwnd, SELCMD(LB_GETITEMHEIGHT, CB_GETITEMHEIGHT), (int)ix, 0);
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlLstHeight (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboHeight (hwnd, ix, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetCtrlCboHeight (HWND hwnd, UI ix)
{
	return SubGetCtrlLstCboHeight (hwnd, ix, FALSE);
}
//==============================================================================================================//
//	コンボボックス下のエディットコントロールのハンドルを取得する												//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//																												//
//	戻り値：	≠NULL - OK（エディットコントロールのハンドル）													//
//				＝NULL - エディットコントロールなし／エラー														//
//==============================================================================================================//
static	BOOL	CALLBACK	SubEnumGetEditCtrlInComboBox(HWND hwnd, LPARAM lParam)
{
	BOOL	rc = TRUE;
	WC		cls[32];

	if (GetClassName(hwnd, cls, AJCTSIZE(cls)) != 0) {
		if (wcsicmp(cls, L"EDIT") == 0) {
			*((HWND*)lParam) = hwnd;
			rc = FALSE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT HWND	 WINAPI	AjcGetCtrlCboEditHandle(HWND hwnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		EnumChildWindows(hwnd, SubEnumGetEditCtrlInComboBox, (LPARAM)&rc);
	}
	return rc;
}

//==============================================================================================================//
//	リストボックス／コンボボックス選択項目のインデクス設定														//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 設定するインデクス																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstIx(HWND hwnd, UI ix)
{
	UI		rc = -1;
	UI		sty;

	sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
	if (sty & LBS_MULTIPLESEL) {
		rc = (UI)SendMessage(hwnd, LB_SETSEL, TRUE, ix);
	}
	else {
		rc = (UI)SendMessage(hwnd, LB_SETCURSEL, ix, 0);
	}
	return rc;
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboIx(HWND hwnd, UI ix)
{
	return ((int)SendMessage(hwnd, CB_SETCURSEL, (int)ix, 0) >= 0);
}
//==============================================================================================================//
//	リストボックス／コンボボックスへ項目追加																	//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 設定するインデクス（－１の場合は最後尾）											//
//				pItem	  - 追加する項目文字列のアドレス														//
//				flag	  - 追加方法（AJCCBF_EXACT_WIDTH, AJCCBF_EXCLUSION, AJCCBF_SAME_IX, AJCCBF_SELECT)		//
//																												//
//	戻り値：	≠-1 - 追加した位置／既存位置（０～）															//
//				＝-1 - エラー																					//
//==============================================================================================================//
static	UI	 SubSetCtrlLstCboAddW (HWND hwnd, UI ix, C_WCP pItem, UI flag, BOOL fLst);
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubSetCtrlLstCboAddA (HWND hwnd, UI ix, C_BCP pItem, UI flag, BOOL fLst)
{
	UI		rc	  = -1;
	UI		len   = 0;
	WCP		wcp   = NULL;

	if (IsWindow(hwnd) && pItem != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pItem, -1, NULL, 0);
		if (wcp = AjcTAllocW(len)) {
			MultiByteToWideChar(CP_ACP, 0, pItem, -1, wcp, len);
			rc = SubSetCtrlLstCboAddW(hwnd, ix, wcp, flag, fLst);
			AjcTFree(wcp);
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlLstAddA (HWND hwnd, UI ix, C_BCP pItem, UI flag)
{
	return SubSetCtrlLstCboAddA (hwnd, ix, pItem, flag, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlCboAddA (HWND hwnd, UI ix, C_BCP pItem, UI flag)
{
	return SubSetCtrlLstCboAddA (hwnd, ix, pItem, flag, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubSetCtrlLstCboAddW (HWND hwnd, UI ix, C_WCP pItem, UI flag, BOOL fLst)
{
	UI		rc		= -1;
	UI		flgFind = flag;
	SI		ixFind, ixAdd = -1;
	WCP		pTmp, pDat;
	SX		data;

	if (IsWindow(hwnd) && pItem != NULL) {
		do {
			//	検索フラグ設定
			flgFind |=	AJCCBF_EXACT;		//	Find()で文字列全体を比較
			flgFind &= ~AJCCBF_SELECT;		//	Find()で選択状態にしない
			//	同一項目存在チェック（同一項目は追加しない ＆ 同一項目あり？）
			if ((flag & AJCCBF_EXCLUSION) && (ixFind = SubGetCtrlLstCboFindW(hwnd, -1, pItem, flgFind, fLst)) != -1) {
				//	既に存在する項目を選択状態にする
				if (flag & AJCCBF_SELECT ) {
					if (fLst) AjcSetCtrlLstIx(hwnd, ixFind);
					else	  AjcSetCtrlCboIx(hwnd, ixFind);
				}
				//	同一項目存在時は、エラーとする
				if (flag & AJCCBF_SAME_ERR) {
					rc = -1;
				}
				//	同一項目のインデクス返す
				else {
					rc = (UI)ixFind;
				}
				//	→終了
				break;
			}
			//	項目設定
			if (wcschr(pItem, '\t') == NULL && !(flag & AJCCBF_EXACT_WIDTH)) {	//	TABなし ＆ 英大小文字を区別しない？
				if (flag & AJCCBF_SORT) ixAdd = (UI)SendMessageW(hwnd, SELCMD(LB_ADDSTRING	 , CB_ADDSTRING)   , 0		, (LPARAM)pItem);
				else					ixAdd = (UI)SendMessageW(hwnd, SELCMD(LB_INSERTSTRING, CB_INSERTSTRING), (int)ix, (LPARAM)pItem);
			}
			//	項目，データ設定
			else {																//	TABあり ／ 英大小文字を区別する？
				UI stl = (UI)wcslen(pItem);
				if (pTmp = AjcTAllocW(stl + 1)) {
					//	データ値設定
					wcscpy	  (pTmp, pItem);
					AjcStrTokW(pTmp, L"\t");
					pDat = pTmp + (wcslen(pTmp) + 1);
					while(iswspace(*pDat)) pDat++;
					if (*pDat == L'0' && *(pDat + 1) == L'x') data = (SX)AjcHexToULLW (pDat);
					else									  data = (SX)_wtoi64(pDat);
					//	項目追加
					if (flag & AJCCBF_SORT) {
						UI	sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
						if (sty & SELCMD(LBS_SORT, CBS_SORT)) ixAdd = AjcSetCtrlLstInsW(hwnd, AJCCBI_ASCENDING, pItem, flag);
						else								  ixAdd = AjcSetCtrlLstInsW(hwnd, AJCCBI_APPEND   , pItem, flag);
					}
					else ixAdd = (UI)SendMessageW(hwnd, SELCMD(LB_INSERTSTRING, CB_INSERTSTRING), (int)ix, (LPARAM)pTmp);
					//	項目追加成功ならば、データ設定
					if (ixAdd >= 0) {
						//	データ値設定
						SendMessageW(hwnd, SELCMD(LB_SETITEMDATA, CB_SETITEMDATA), ixAdd, (LPARAM)data);
					}
					//	文字列バッファ解放
					AjcTFree(pTmp);
				}
			}
			//	項目追加成功ならば、選択状態と戻り値設定
			if (ixAdd >= 0) {
				//	追加項目を選択状態にする
				if (flag & AJCCBF_SELECT ) {
					if (fLst) AjcSetCtrlLstIx(hwnd, ixAdd);
					else	  AjcSetCtrlCboIx(hwnd, ixAdd);
				}
				//	戻り値＝追加位置インデクス
				rc = (UI)ixAdd;
			}
		} while(0);
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlLstAddW (HWND hwnd, UI ix, C_WCP pItem, UI flag)
{
	return SubSetCtrlLstCboAddW (hwnd, ix, pItem, flag, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlCboAddW (HWND hwnd, UI ix, C_WCP pItem, UI flag)
{
	return SubSetCtrlLstCboAddW (hwnd, ix, pItem, flag, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックスへ項目挿入																	//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 設定するインデクス／挿入位置指定（AJCCBI_XXXXXXX）									//
//				pItem	  - 追加する項目文字列のアドレス														//
//				flag	  - 追加方法（AJCCBF_EXACT_WIDTH, AJCCBF_EXCLUSION, AJCCBF_SAME_IX, AJCCBF_SELECT)		//
//																												//
//	戻り値：	≠-1 - 挿入位置（０～）																			//
//				＝-1 - Error																					//
//==============================================================================================================//
static	UI	 SubSetCtrlLstCboInsW  (HWND hwnd, UI ix, C_WCP pItem, UI flag, BOOL fLst);
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubSetCtrlLstCboInsA  (HWND hwnd, UI ix, C_BCP pItem, UI flag, BOOL fLst)
{
	UI		rc	  = -1;
	UI		len   = 0;
	WCP		wcp   = NULL;

	if (IsWindow(hwnd) && pItem != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pItem, -1, NULL, 0);
		if (wcp = AjcTAllocW(len)) {
			MultiByteToWideChar(CP_ACP, 0, pItem, -1, wcp, len);
			rc = SubSetCtrlLstCboInsW(hwnd, ix, wcp, flag, fLst);
			AjcTFree(wcp);
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlLstInsA  (HWND hwnd, UI ix, C_BCP pItem, UI flag)
{
	return SubSetCtrlLstCboInsA  (hwnd, ix, pItem, flag, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlCboInsA  (HWND hwnd, UI ix, C_BCP pItem, UI flag)
{
	return SubSetCtrlLstCboInsA  (hwnd, ix, pItem, flag, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	UI	 SubSetCtrlLstCboInsW  (HWND hwnd, UI ix, C_WCP pItem, UI flag, BOOL fLst)
{
	UI		rc		= -1;
	UI		flgFind = flag;
	SI		i, n, ixFind, ixIns, lmax;
	WCP		pLB = NULL;

	if (IsWindow(hwnd) && pItem != NULL) {
		do {
			//	検索フラグ設定
			flgFind |=	AJCCBF_EXACT;		//	Find()で文字列全体を比較
			flgFind &= ~AJCCBF_SELECT;		//	Find()で選択状態にしない
			//	同一項目存在チェック（同一項目は追加しない ＆ 同一項目あり？）
			if ((flag & AJCCBF_EXCLUSION) && (ixFind = SubGetCtrlLstCboFindW(hwnd, -1, pItem, flgFind, fLst)) != -1) {
				//	既に存在する項目を選択状態にする
				if (flag & AJCCBF_SELECT ) {
					if (fLst) AjcSetCtrlLstIx(hwnd, ixFind);
					else	  AjcSetCtrlCboIx(hwnd, ixFind);
				}
				//	同一項目存在時は、エラーとする
				if (flag & AJCCBF_SAME_ERR) {
					rc = -1;
				}
				//	同一項目のインデクス返す
				else {
					rc = (UI)ixFind;
				}
				//	→終了
				break;
			}
			//	昇順／降順指定時、挿入位置検索
			if ((lmax = SubGetCtrlLstCboMaxLenW(hwnd, fLst)) != -1) {		//	最大文字列長取得成功？
				if (pLB = AjcTAllocW(lmax + 1)) {							//	バッファ確保成功
					ixIns = -1;
					if (ix == AJCCBI_ASCENDING || ix == AJCCBI_DESCENDING ) {
						if ((n = (SI)SendMessageW(hwnd, SELCMD(LB_GETCOUNT, CB_GETCOUNT), 0, 0)) >= 1) {
							for (i = 0; i < n; i++) {
								if ((SendMessageW(hwnd, SELCMD(LB_GETTEXT, CB_GETLBTEXT), i, (LPARAM)pLB)) >= 0) {
									int icmp = wcsicmp(pLB, pItem);
									if		(ix == AJCCBI_ASCENDING) {		//	昇順となる項目位置に挿入
										if (flag & AJCCBF_EXACT_WIDTH) {	//		英大小文字区別あり
											if (icmp > 0 || (icmp == 0 && wcscmp(pLB, pItem) > 0)) {
												ixIns = i; AjcTFree(pLB); pLB = NULL; break;
											}
										}
										else {								//		英大小文字区別なし
											if (icmp > 0) {
												ixIns = i; AjcTFree(pLB); pLB = NULL; break;
											}
										}
									}
									else if (ix == AJCCBI_DESCENDING) {		//	降順となる項目位置に挿入（英大小文字区別あり）
										if (flag & AJCCBF_EXACT_WIDTH) {	//		英大小文字区別あり
											if (icmp < 0 || (icmp == 0 && wcscmp(pLB, pItem) < 0)) {
												ixIns = i; AjcTFree(pLB); pLB = NULL; break;
											}
										}
										else {								//		英大小文字区別なし
											if (icmp < 0) {
												ixIns = i; AjcTFree(pLB); pLB = NULL; break;
											}
										}
									}
								}
							}
						}
						//	挿入位置設定
						ix = ixIns;
					}
					//	バッファ解放
					AjcTFree(pLB); pLB = NULL;
				}
			}
			//	項目挿入
			ixIns = (SI)SendMessageW(hwnd, SELCMD(LB_INSERTSTRING, CB_INSERTSTRING), ix, (LPARAM)pItem);
			//	項目挿入成功ならば、選択状態と戻り値設定
			if (ixIns >= 0) {
				//	挿入項目を選択状態にする
				if (flag & AJCCBF_SELECT ) {
					if (fLst) AjcSetCtrlLstIx(hwnd, ixIns);
					else	  AjcSetCtrlCboIx(hwnd, ixIns);
				}
				//	戻り値＝挿入位置インデクス
				rc = (UI)ixIns;
			}
		} while(0);
	}
	return rc;
}
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlLstInsW  (HWND hwnd, UI ix, C_WCP pItem, UI flag)
{
	return SubSetCtrlLstCboInsW  (hwnd, ix, pItem, flag, TRUE);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetCtrlCboInsW  (HWND hwnd, UI ix, C_WCP pItem, UI flag)
{
	return SubSetCtrlLstCboInsW  (hwnd, ix, pItem, flag, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックスから項目削除																	//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 設定するインデクス（－１の場合は最後尾）											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL	 SubSetCtrlLstCboDel (HWND hwnd, UI ix, BOOL fLst)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = (SendMessage(hwnd, SELCMD(LB_DELETESTRING, CB_DELETESTRING), ix, 0) != CB_ERR);
	}
	return rc;
}
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstDel (HWND hwnd, UI ix)
{
	return SubSetCtrlLstCboDel (hwnd, ix, TRUE);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboDel (HWND hwnd, UI ix)
{
	return SubSetCtrlLstCboDel (hwnd, ix, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックス項目に関連付ける数値を設定													//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 項目インデクス（－１の場合は現在の選択項目）										//
//				data	  - 関連付ける数値																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL	 SubSetCtrlLstCboData  (HWND hwnd, UI ix, SX data, BOOL fLst)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (ix == -1) {
			ix = (UI)SendMessage(hwnd, SELCMD(LB_GETCURSEL, CB_GETCURSEL), 0, 0);
		}
		rc = (SendMessage(hwnd, SELCMD(LB_SETITEMDATA, CB_SETITEMDATA), (int)ix, (LPARAM)data) != CB_ERR);
	}
	return rc;
}
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstData  (HWND hwnd, UI ix, SX data)
{
	return SubSetCtrlLstCboData  (hwnd, ix, data, TRUE);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboData  (HWND hwnd, UI ix, SX data)
{
	return SubSetCtrlLstCboData  (hwnd, ix, data, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックスの項目群を一括設定															//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pList	  - 設定する文字列群（多重文字列）のアドレス											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	BOOL	 SubSetCtrlLstCboListA(HWND hwnd, C_BCP pList, BOOL fLst)
{
	BOOL	rc = TRUE;

	if (IsWindow(hwnd) && pList != NULL) {
		SendMessageA(hwnd, SELCMD(LB_RESETCONTENT, CB_RESETCONTENT), 0, 0);
		rc = FALSE;
		while (pList != NULL  &&  *pList != 0) {
			if (SubSetCtrlLstCboAddA(hwnd, -1, pList, FALSE, fLst) == -1) {
				rc &= FALSE;
			}
			pList += (strlen(pList) + 1);
		}
	}
	else rc = FALSE;

	return rc;
}
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstListA(HWND hwnd, C_BCP pList)
{
	return SubSetCtrlLstCboListA(hwnd, pList, TRUE);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboListA(HWND hwnd, C_BCP pList)
{
	return SubSetCtrlLstCboListA(hwnd, pList, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	BOOL	 SubSetCtrlLstCboListW(HWND hwnd, C_WCP pList, BOOL fLst)
{
	BOOL	rc = TRUE;

	if (IsWindow(hwnd) && pList != NULL) {
		SendMessageW(hwnd, SELCMD(LB_RESETCONTENT, CB_RESETCONTENT), 0, 0);
		while (pList != NULL  &&  *pList != 0) {
			if (SubSetCtrlLstCboAddW(hwnd, -1, pList, FALSE, fLst) == -1) {
				rc &= FALSE;
			}
			pList += (wcslen(pList) + 1);
		}
	}
	else rc = FALSE;

	return rc;
}
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstListW(HWND hwnd, C_WCP pList)
{
	return SubSetCtrlLstCboListW(hwnd, pList, TRUE);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboListW(HWND hwnd, C_WCP pList)
{
	return SubSetCtrlLstCboListW(hwnd, pList, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックスの全項目をリセット															//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL	 SubSetCtrlLstCboReset (HWND hwnd, BOOL fLst)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessage(hwnd, SELCMD(LB_RESETCONTENT, CB_RESETCONTENT), 0, 0);
		rc = TRUE;
	}
	return rc;
}
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstReset (HWND hwnd)
{
	return SubSetCtrlLstCboReset (hwnd, TRUE);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboReset (HWND hwnd)
{
	return SubSetCtrlLstCboReset (hwnd, FALSE);
}
//==============================================================================================================//
//	リストボックス／コンボボックス項目の高さ設定																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				ix		  - 設定するインデクス																	//
//				height	  - 高さ																				//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL	 SubSetCtrlLstCboHeight(HWND hwnd, UI ix, UI height, BOOL fLst)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (height != 0) {
			rc = (SendMessage(hwnd, SELCMD(LB_SETITEMHEIGHT, CB_SETITEMHEIGHT), ix, (int)height) != CB_ERR);
		}
		else {
			HFONT	hF;
			LOGFONT	lf;
			hF = (HFONT)SendMessage(hwnd, WM_GETFONT, 0, 0);
			GetObject(hF, sizeof(LOGFONT), &lf);
			rc = (SendMessage(hwnd, SELCMD(LB_SETITEMHEIGHT, CB_SETITEMHEIGHT), ix, abs(lf.lfHeight) + 2) != CB_ERR);
		}
	}
	return rc;
}
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstHeight(HWND hwnd, UI ix, UI height)
{
	return SubSetCtrlLstCboHeight(hwnd, ix, height, TRUE);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboHeight(HWND hwnd, UI ix, UI height)
{
	return SubSetCtrlLstCboHeight(hwnd, ix, height, FALSE);
}
//==============================================================================================================//
//	コンボボックスの入力可能文字数設定																			//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				limit	  - 入力可能な文字長																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboLimitA(HWND hwnd, UI limit)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessageA(hwnd, CB_LIMITTEXT, limit, 0);
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboLimitW(HWND hwnd, UI limit)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessageW(hwnd, CB_LIMITTEXT, limit, 0);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	プログレスバーのレンジ設定																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				low, high - 設定するレンジ																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPgsRange(HWND hwnd, int low, int high)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = (SendMessage(hwnd, PBM_SETRANGE, 0, (high << 16) | (low & 0x0000FFFF)) != 0);
	}
	return rc;
}
//==============================================================================================================//
//	プログレスバー位置設定																						//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				pos		- 設定する位置																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPgsPos(HWND hwnd, int pos)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessage(hwnd, PBM_SETPOS, pos, 0);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	スライダのレンジとページサイズ設定																			//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				low, high - 設定するレンジ																		//
//				page	  - ページサイズ																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSldRange(HWND hwnd, int low, int high, int page)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessage(hwnd, TBM_SETRANGEMIN, FALSE, low );
		SendMessage(hwnd, TBM_SETRANGEMAX, TRUE , high);
		SendMessage(hwnd, TBM_SETPAGESIZE, 0	, page);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	スライダの位置設定																							//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//				pos		- 設定する位置																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error（設置位置が範囲外）																//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSldPos(HWND hwnd, int pos)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		 rc = (BOOL)SendMessage(hwnd, TBM_SETPOS, TRUE, pos);
	}
	return rc;
}
//==============================================================================================================//
//	スライダの位置取得																							//
//																												//
//	引　数：	hwnd	- コントロールハンドル																	//
//																												//
//	戻り値：	スライダの位置																					//
//==============================================================================================================//
AJCEXPORT int	 WINAPI AjcGetCtrlSldPos (HWND hwnd)
{
	int		rc = 0;

	if (IsWindow(hwnd)) {
		rc = (int)SendMessage(hwnd, TBM_GETPOS, 0, 0);
	}
	return rc;
}

//==============================================================================================================//
//	スピンボタンのレンジとバディーウインド設定																	//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				low, high - 設定するレンジ																		//
//				hwBuddy	  - バディーウインドのハンドル															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSpnInfo (HWND hwnd, int low, int high, HWND hwBuddy)
{
	BOOL	rc = TRUE;

	rc &= AjcSetCtrlSpnRange(hwnd, low, high);
	rc &= AjcSetCtrlSpnBuddy(hwnd, hwBuddy);

	return rc;
}
//==============================================================================================================//
//	スピンボタンのレンジ設定																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				low, high - 設定するレンジ																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSpnRange(HWND hwnd, int low, int high)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SendMessage(hwnd, UDM_SETRANGE, 0, (low << 16) | (high & 0x0000FFFF));
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	スピンボタンのバディーウインド設定																			//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				hwBuddy	  - バディーウインドのハンドル															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSpnBuddy(HWND hwnd, HWND hwBuddy)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && hwBuddy != NULL) {
		SendMessage(hwnd, UDM_SETBUDDY, (WPARAM)hwBuddy, 0);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	コントロールを兄弟ウインド中で最前面に設定する																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	≠ NULL - 直前の最前面ウインド																	//
//				＝ NULL	- Error																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI AjcSetCtrlTopMostInSiblings(HWND hwnd)
{
	HWND	rc		 = NULL;
	HWND	hTopMost = NULL;

	if (IsWindow(hwnd)) {
		hTopMost = GetWindow(hwnd, GW_HWNDFIRST);
		if (hTopMost != NULL) {
			SetWindowPos(hTopMost, hwnd, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		}
		rc = hTopMost;
	}
	return rc;
}
//==============================================================================================================//
//	コントロールを兄弟ウインド中で最背面に設定する																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	≠ NULL - 直前の最背面ウインド																	//
//				＝ NULL	- Error																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI AjcSetCtrlBackMostInSiblings(HWND hwnd)
{
	HWND	rc		  = FALSE;
	HWND	hBackMost = NULL;

	if (IsWindow(hwnd)) {
		hBackMost = GetWindow(hwnd, GW_HWNDLAST);
		if (hBackMost != NULL) {
			SetWindowPos(hwnd, hBackMost, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		}
		rc = hBackMost;
	}
	return rc;
}
//==============================================================================================================//
//	コントロールにフォルダ／ファイルをドロップ可能にする														//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				hGrp	  - グループボックスのウインドハンドル													//
//				opt		  - ドロップ種別（AJCDROP_{DIR/FILE/CONNECT}）											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJC_WNDPROC_DEF(SubEnableDrop);
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcEnableCtrlToDrop(HWND hwnd, UI optDrop)
{
	return AjcEnableCtrlToDropEx(hwnd, NULL, optDrop);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcEnableCtrlToDropEx(HWND hwnd, HWND hGrp, UI optDrop)
{
	BOOL	rc = FALSE;
	UI		sty;
	WC		cls[256] = {0};

	if (IsWindow(hwnd) && GetParent(hwnd) && (optDrop & (AJCDROP_DIR | AJCDROP_FILE))) {
		do {
			//	EDITクラスかチェック
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (AjcStrIStrW(cls, L"Edit") == NULL) break;
			//	既に設定済かチェック
			if (GetProp(hwnd, L"AjcEnableCtrlToDrop") != NULL) break;
			//	WS_EX_ACCEPTFILESスタイル追加
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_EXSTYLE);
			MAjcSetWindowLong(hwnd, GWL_EXSTYLE, sty | WS_EX_ACCEPTFILES);
			//	ウインドへオプションを関連付ける
			SetProp(hwnd, L"AjcEnableCtrlToDrop", (HANDLE)((UX)optDrop));
			//	サブクラス化
			if (rc = (MAjcMmpSetSubclass(SubEnableDrop, hwnd)) == NULL) break;
			//	ウインドをグループボックスより前面に設定
			if (hGrp != NULL) {
				rc = SetWindowPos(hGrp, hwnd, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
			}
		} while(0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	サブクラス化したコントロールのウインドプロシージャ															//
//--------------------------------------------------------------------------------------------------------------//
static UI	SubGetDragedPath(HWND hwnd, HDROP hDrop, UI i, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	BC		pathA[MAX_PATH];

	if (IsWindowUnicode(hwnd)) {
		rc = DragQueryFileW(hDrop, i, pBuf, lBuf);
	}
	else {
		if (DragQueryFileA(hDrop, i, pathA, AJCTSIZE(pathA)) != 0) {
			rc = MultiByteToWideChar(CP_ACP, 0, pathA, -1, pBuf, lBuf);
		}
	}
	return rc;
}
//----- ドロップメッセージ -------------------------------------------------------------------------------------//
static	VO		SubDropMsg(HWND hwnd, UI optDrop)
{
	RECT	r;
	POINT	pt;
	HFONT	hF = (HFONT)SendMessage(hwnd, WM_GETFONT, 0, 0);

	if (!(optDrop & AJCDROP_NOERRTIP)) {
		GetWindowRect(hwnd, &r);
		GetCursorPos(&pt);
		pt.x += 20;
		pt.y  = r.top  + (r.bottom - r.top) / 2;

		if (optDrop & AJCDROP_DIR) {
			AjcTipTextShowExW(pt.x, pt.y, 0, 0, LNGSEL(L"ディレクトリをドロップしてください",  L"Please drop the directory."),
								3000, hF, RGB_RED, -1, RGB_RED);
		}
		else {
			AjcTipTextShowExW(pt.x, pt.y, 0, 0, LNGSEL(L"ファイルをドロップしてください",  L"Please drop the file."),
								3000, hF, RGB_RED, -1, RGB_RED);
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJC_WNDPROC(SubEnableDrop, WM_DROPFILES	)
{
	HDROP		hDrop;
	UI			optDrop;
	UI			i, n, stl, cnt;
	WCP			pTmp = NULL;
	WC			OldPath[MAX_PATH];
	WC			path   [MAX_PATH];

	//----- オプション取得 ---------------------//
	optDrop = (UI)((UX)GetProp(hwnd, L"AjcEnableCtrlToDrop"));
	//----- ドロップしたディレクトリ名設定 -----//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	if (IsWindowUnicode(hwnd)) n = DragQueryFileW(hDrop, 0xFFFFFFFF, NULL, 0);	//	ドロップファイル数取得
	else					   n = DragQueryFileA(hDrop, 0xFFFFFFFF, NULL, 0);
	//----- 複数テキスト設定 -------------------//
	if (optDrop & AJCDROP_CONNECT) {
		//	総テキスト長設定
		stl = 0;
		for (i = 0; i < n; i++) {
			SubGetDragedPath(hwnd, hDrop, i, path, MAX_PATH);
			path[MAX_PATH - 1] = 0;
			if (((optDrop & AJCDROP_DIR ) && AjcPathIsDirectory(path)) ||
				((optDrop & AJCDROP_FILE) && AjcPathIsFile	   (path))) {
				if (optDrop & AJCDROP_VOLEXP) {
					AjcNormalPathToVolExpPathW(path, path);
				}
				stl += (UI)(wcslen(path) + 2);	//	';' と '\' の分を加算
			}
		}
		//	全テキストをセミコロンで区切って設定
		if (pTmp = AjcTAllocW(stl + 1)) {
			*pTmp = 0;
			cnt = 0;
			for (i = 0; i < n; i++) {
				SubGetDragedPath(hwnd, hDrop, i, path, MAX_PATH);
				path[MAX_PATH - 1] = 0;
				if (((optDrop & AJCDROP_DIR ) && AjcPathIsDirectory(path)) ||
					((optDrop & AJCDROP_FILE) && AjcPathIsFile	   (path))) {
					//	２つ目以降ならば ';' で分離
					if (cnt != 0) {
						wcscat(pTmp, L";");
					}
					//	ディレクトリ末尾（￥）追加
					if (AjcPathIsDirectory(path) && (optDrop & AJCDROP_DIRTAIL)) {
						AjcPathCat(path, L"", MAX_PATH);
					}
					//	ボリューム表現のパス名へ変換
					if (optDrop & AJCDROP_VOLEXP) {
						GetWindowText(hwnd, OldPath, MAX_PATH);
						if (AjcIsVolExpPath(OldPath) && MAjcIsAlphaW(path[0]) && path[1] == L':') {
							UI	type;
							WC	rt[8] = L"?:\\";
							rt[0] = path[0];
							type = GetDriveTypeW(rt);
							if (!(optDrop & AJCDROP_RMVONLY) || type == DRIVE_REMOVABLE) {
								AjcNormalPathToVolExpPathW(path, path);
							}
						}
					}
					//	パス追加
					wcscat(pTmp, path);
					cnt++;
				}
			}
			if (cnt != 0) {
				SetWindowText(hwnd, pTmp);
			}
			else {
				SubDropMsg(hwnd, optDrop);
			}
			free(pTmp);
		}
	}
	//----- 単一テキスト設定 -------------------//
	else {
		cnt = 0;
		for (i = 0; i < n; i++) {
			SubGetDragedPath(hwnd, hDrop, i, path, MAX_PATH);
			path[MAX_PATH - 1] = 0;
			if (((optDrop & AJCDROP_DIR ) && AjcPathIsDirectory(path)) ||
				((optDrop & AJCDROP_FILE) && AjcPathIsFile	   (path))) {
				//	ディレクトリ末尾（￥）追加
				if (AjcPathIsDirectory(path) && (optDrop & AJCDROP_DIRTAIL)) {
					AjcPathCat(path, L"", MAX_PATH);
				}
				//	ボリューム表現のパス名へ変換
				if (optDrop & AJCDROP_VOLEXP) {
					GetWindowText(hwnd, OldPath, MAX_PATH);
					if (AjcIsVolExpPath(OldPath) && MAjcIsAlphaW(path[0]) && path[1] == L':') {
						UI	type;
						WC	rt[8] = L"?:\\";
						rt[0] = path[0];
						type = GetDriveTypeW(rt);
						if (!(optDrop & AJCDROP_RMVONLY) || type == DRIVE_REMOVABLE) {
							AjcNormalPathToVolExpPathW(path, path);
						}
					}
				}
				//	パス表示
				SetWindowText(hwnd, path);
				cnt++;
				break;
			}
		}
		if (cnt == 0) {
			SubDropMsg(hwnd, optDrop);
		}
	}
	DragFinish(hDrop);								//	ドロップ終了
	return 0;										//	インターセプト
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubEnableDrop, WM_DESTROY	)
{
	//	関連付けられたオプションを解放
	RemoveProp(hwnd, L"AjcEnableCtrlToDrop");
	return MAjcMmpCallOrgWndProc(SubEnableDrop);	//	オリジナルプロシージャへリンク
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SubEnableDrop)
	AJC_WNDMAP_MSG(SubEnableDrop, WM_DROPFILES	   )
	AJC_WNDMAP_MSG(SubEnableDrop, WM_DESTROY	   )
AJC_WNDMAP_END

/****************************************************************************************************************/
/*																												*/
/*	コントロールの位置や矩形 取得／設定																			*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	コントロールの位置取得																						//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pPoint	  - コントロールの位置を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcGetCtrlPos	  (HWND hwnd, LPPOINT pPoint)
{
	BOOL	rc = FALSE;
	RECT	r;

	if (pPoint != NULL) {
		if (GetWindowRect(hwnd, &r)) {
			MapWindowPoints(NULL, GetParent(hwnd), (LPPOINT)&r, 2);
			pPoint->x = r.left;
			pPoint->y = r.top;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロールのサイズ取得																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pSize	  - コントロールのサイズを格納するバッファのアドレス									//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcGetCtrlSize	  (HWND hwnd, LPSIZE pSize)
{
	BOOL	rc = FALSE;
	RECT	r;

	if (pSize != NULL) {
		if (GetWindowRect(hwnd, &r)) {
			pSize->cx = r.right  - r.left;
			pSize->cy = r.bottom - r.top;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロールの矩形取得																						//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pRect	  - コントロールの矩形を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcGetCtrlRect	  (HWND hwnd, LPRECT pRect)
{
	BOOL	rc = FALSE;

	if (pRect != NULL) {
		if (GetWindowRect(hwnd, pRect)) {
			MapWindowPoints(NULL, GetParent(hwnd), (LPPOINT)pRect, 2);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロールの位置設定																						//
//																												//
//	引　数：	hwnd		  - コントロールハンドル															//
//				x, y, pPos	  - コントロールの位置																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcSetCtrlPos	  (HWND hwnd, int x, int y)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SetWindowPos(hwnd, NULL, x, y, 0, 0, SWP_NOSIZE);
		rc = TRUE;
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	WINAPI AjcSetCtrlPosV	  (HWND hwnd, const POINT *pPos)
{
	BOOL	rc = FALSE;

	if (pPos != NULL) {
		rc = AjcSetCtrlPos(hwnd, pPos->x, pPos->y);
	}
	return rc;
}

//==============================================================================================================//
//	コントロールのサイズ設定																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pPoint	  - コントロールの位置を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcSetCtrlSize	  (HWND hwnd, int cx, int cy)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SetWindowPos(hwnd, NULL, 0, 0, cx, cy, SWP_NOMOVE);
		rc = TRUE;
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	WINAPI AjcSetCtrlSizeV	  (HWND hwnd, const SIZE *pSize)
{
	BOOL	rc = FALSE;

	if (pSize != NULL) {
		rc = AjcSetCtrlPos(hwnd, pSize->cx, pSize->cy);
	}
	return rc;
}

//==============================================================================================================//
//	コントロールの矩形設定																						//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pPoint	  - コントロールの位置を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcSetCtrlRect	  (HWND hwnd, int x, int y, int cx, int cy)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SetWindowPos(hwnd, NULL, x, y, cx, cy, SWP_NOZORDER);
		rc = TRUE;
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	WINAPI AjcSetCtrlRectV	  (HWND hwnd, const RECT *pRect)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		SetWindowPos(hwnd, NULL, pRect->left, pRect->top, pRect->right - pRect->left, pRect->bottom - pRect->top, SWP_NOZORDER);
		rc = TRUE;
	}
	return rc;
}

/****************************************************************************************************************/
/*																												*/
/*	コントロールのグレィ設定																					*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	コントロールの許可／禁止																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				fEnable	  - TRUE  : コントロール許可（グレィ解除）												//
//							FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcEnableCtrl(HWND hwnd, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		EnableWindow(hwnd, fEnable);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	コントロールの表示／非表示																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				fShow	  - TRUE  : コントロール表示															//
//							FALSE : コントロール非表示															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcShowCtrl(HWND hwnd, BOOL fShow)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (fShow) ShowWindow(hwnd, SW_SHOW);
		else	   ShowWindow(hwnd, SW_HIDE);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	コントロールの表示／非表示 と 許可／禁止																	//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				fShow	  - TRUE  : コントロール表示															//
//							FALSE : コントロール非表示															//
//				fEnable	  - TRUE  : コントロール許可（グレィ解除）												//
//							FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcShowAndEnableCtrl(HWND hwnd, BOOL fShow, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {

		if (fShow) ShowWindow(hwnd, SW_SHOW);
		else	   ShowWindow(hwnd, SW_HIDE);

		EnableWindow(hwnd, fEnable);

		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	グループボックス内の全コントロール許可／禁止																//
//																												//
//	引　数：	hwnd	   - グループボックスのコントロールハンドル												//
//				fEnaGrpBox - グループボックスのグレィ設定														//
//							 TRUE  : グループボックス許可（グレィ解除）											//
//							 FALSE : グループボックス禁止（グレィ化）											//
//				fEnaCtrls  - グループボックス内の全コントロールのグレィ設定										//
//							 TRUE  : コントロール許可（グレィ解除）												//
//							 FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
typedef struct {
	HWND	hw;
	RECT	r;
	BOOL	f;
} AEGPARAM, *PAEGPARAM;

//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbAegEnum(HWND hwnd, LPARAM lParam)
{
	PAEGPARAM	p = (PAEGPARAM)lParam;
	RECT		rct;

	GetWindowRect(hwnd, &rct);
	if (hwnd != p->hw && rct.left >= p->r.left && rct.top >= p->r.top && rct.right <= p->r.right && rct.bottom <= p->r.bottom) {
		EnableWindow(hwnd, p->f);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcEnableGroup(HWND hwnd, BOOL fEnaGrpBox, BOOL fEnaCtrls)
{
	BOOL		rc = FALSE;
	AEGPARAM	prm;
	HWND		hParent;

	if (IsWindow(hwnd)	&&	(hParent = GetParent(hwnd)) != NULL) {
		EnableWindow(hwnd, fEnaGrpBox);
		prm.hw = hwnd;
		GetWindowRect(hwnd, &prm.r);
		prm.f = fEnaCtrls;
		rc = EnumChildWindows(hParent, cbAegEnum, (LPARAM)&prm);
	}
	return rc;
}
//==============================================================================================================//
//	ウインド内の全コントロール許可／禁止																		//
//																												//
//	引　数：	hwnd	   - ウインドハンドル																	//
//				fEnaCtrls  - ウインド内の全コントロールのグレィ設定												//
//							 TRUE  : コントロール許可（グレィ解除）												//
//							 FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcEnableCtrlsInWnd(HWND hwnd, BOOL fEnaCtrls)
{
	BOOL		rc = FALSE;
	AEGPARAM	prm;

	if (IsWindow(hwnd)) {
		prm.hw = hwnd;
		GetWindowRect(hwnd, &prm.r);
		prm.f = fEnaCtrls;
		rc = EnumChildWindows(hwnd, cbAegEnum, (LPARAM)&prm);
	}
	return rc;
}
//==============================================================================================================//
//	グループボックスとグループボックス内の全コントロール表示／非表示（１）										//
//																												//
//	引　数：	hwnd	   - グループボックスのコントロールハンドル												//
//				fShow	   - 表示(TRUE)／非表示(FALSE)フラグ													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
typedef struct {
	RECT	r;
	BOOL	s;
} ASGPARAM, *PASGPARAM;

//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbAsgEnum(HWND hwnd, LPARAM lParam)
{
	PASGPARAM	p = (PASGPARAM)lParam;
	RECT		rct;

	GetWindowRect(hwnd, &rct);
	if (rct.left >= p->r.left && rct.top >= p->r.top && rct.right <= p->r.right && rct.bottom <= p->r.bottom) {
		if (p->s) ShowWindow(hwnd, SW_SHOW);
		else	  ShowWindow(hwnd, SW_HIDE);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcShowGroup(HWND hwnd, BOOL fShow)
{
	BOOL		rc = FALSE;
	ASGPARAM	prm;
	HWND		hParent;

	if (IsWindow(hwnd)	&&	(hParent = GetParent(hwnd)) != NULL) {
		if (fShow) ShowWindow(hwnd, SW_SHOW);
		else	   ShowWindow(hwnd, SW_HIDE);
		GetWindowRect(hwnd, &prm.r);
		prm.s = fShow;
		rc = EnumChildWindows(hParent, cbAsgEnum, (LPARAM)&prm);
	}
	return rc;
}
//==============================================================================================================//
//	グループボックスとグループボックス内の全コントロール表示／非表示（２）										//
//																												//
//	引　数：	hwnd		- グループボックスのコントロールハンドル											//
//				fShowGrpBox	- グループボックスの表示フラグ														//
//				fShowCtrls	- グループボックス内の全コントロールの表示フラグ									//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL CALLBACK cbAsgExEnum(HWND hwnd, LPARAM lParam)
{
	PASGPARAM	p = (PASGPARAM)lParam;
	RECT		rct;

	GetWindowRect(hwnd, &rct);
	if (rct.left >= p->r.left && rct.top >= p->r.top && rct.right <= p->r.right && rct.bottom <= p->r.bottom) {
		if (p->s) ShowWindow(hwnd, SW_SHOW);
		else	  ShowWindow(hwnd, SW_HIDE);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcShowGroupEx(HWND hwnd, BOOL fShowGrpBox, BOOL fShowCtrls)
{
	BOOL		rc = FALSE;
	ASGPARAM	prm;
	HWND		hParent;

	if (IsWindow(hwnd)	&&	(hParent = GetParent(hwnd)) != NULL) {
		GetWindowRect(hwnd, &prm.r);
		prm.s = fShowCtrls;
		if (rc = EnumChildWindows(hParent, cbAsgExEnum, (LPARAM)&prm)) {
			if (fShowGrpBox) ShowWindow(hwnd, SW_SHOW);
			else			 ShowWindow(hwnd, SW_HIDE);
		}
	}
	return rc;
}
//==============================================================================================================//
//	グループボックスの移動																						//
//																												//
//	引　数：	hwnd	- グループボックスのコントロールハンドル												//
//				x, y	- 移動先の位置																			//
//				hctl	- 移動先コントロールのハンドル															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
typedef struct {
	HWND	hParent;
	RECT	r;					//	グループボックスの位置
	int		mx, my;				//	移動量
} MVGPARAM, *PMVGPARAM;

//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbMvGrpEnum(HWND hwnd, LPARAM lParam)
{
	PMVGPARAM	p = (PMVGPARAM)lParam;
	RECT		rct;

	GetWindowRect(hwnd, &rct);
	if (rct.left > p->r.left && rct.top > p->r.top && rct.right < p->r.right && rct.bottom < p->r.bottom) {
		MapWindowPoints(NULL, p->hParent, (LPPOINT)&rct, 2);
		SetWindowPos(hwnd, NULL, rct.left + p->mx, rct.top + p->my, 0, 0, SWP_NOSIZE);
	}
	return TRUE;
}
//----- 指定ロケーション位置へ移動 -----------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcMoveGroupToLoc(HWND hwnd, int x, int y)
{
	BOOL		rc = FALSE;
	MVGPARAM	prm;
	POINT		pt;
	RECT		rct;

	if (IsWindow(hwnd)	&&	(prm.hParent = GetParent(hwnd)) != NULL) {
		//--- グループボックスのスクリーン位置設定 --------------------//
		GetWindowRect(hwnd, &prm.r);
		//--- グループボックスのクライアント位置設定 ------------------//
		pt.x = prm.r.left;
		pt.y = prm.r.top;
		MapWindowPoints(NULL, prm.hParent, (LPPOINT)&pt, 1);
		//--- グループボックスの自クライアント位置登録 ----------------//
		if (GetPropA(hwnd, "AJCGRPORG") == NULL) {
			SetPropA(hwnd, "AJCGRPORG", (HANDLE)((UX)MAKELONG(pt.x, pt.y)));
		}
		if (pt.x != x  ||  pt.y != y) {
			//--- 移動量設定 ------------------------------------------//
			prm.mx = x - pt.x;
			prm.my = y - pt.y;
			//--- グループボックス移動 --------------------------------//
			GetWindowRect(hwnd, &rct);
			MapWindowPoints(NULL, prm.hParent, (LPPOINT)&rct, 2);
			SetWindowPos(hwnd, NULL, rct.left + prm.mx, rct.top + prm.my, 0, 0, SWP_NOSIZE);
			//--- コントロール移動 ------------------------------------//
			rc = EnumChildWindows(prm.hParent, cbMvGrpEnum, (LPARAM)&prm);
		}
		else rc = TRUE;
	}
	return rc;
}
//----- 指定コントロール位置へ移動 -----------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcMoveGroupToCtl(HWND hwnd, HWND hctl)
{
	BOOL		rc = FALSE;
	MVGPARAM	prm;
	RECT		rcCtl;
	POINT		ptCtl, ptGrp;
	RECT		rct;

	if (IsWindow(hwnd)	&&	(prm.hParent = GetParent(hwnd)) != NULL) {
		//--- 移動先コントロールのクライアント位置設定 ----------------//
		GetWindowRect(hctl, &rcCtl);
		ptCtl.x = rcCtl.left;
		ptCtl.y = rcCtl.top;
		MapWindowPoints(NULL, prm.hParent, (LPPOINT)&ptCtl, 1);
		//--- グループボックスのスクリーン位置設定 --------------------//
		GetWindowRect(hwnd, &prm.r);
		//--- グループボックスのクライアント位置設定 ------------------//
		ptGrp.x = prm.r.left;
		ptGrp.y = prm.r.top;
		MapWindowPoints(NULL, prm.hParent, (LPPOINT)&ptGrp, 1);
		//--- グループボックスの自クライアント位置登録 ----------------//
		if (GetPropA(hwnd, "AJCGRPORG") == NULL) {
			SetPropA(hwnd, "AJCGRPORG", (HANDLE)((UX)MAKELONG(ptGrp.x, ptGrp.y)));
		}
		if (ptGrp.x != ptCtl.x	||	ptGrp.y != ptCtl.y) {
			//--- 移動量設定 ------------------------------------------//
			prm.mx = ptCtl.x - ptGrp.x;
			prm.my = ptCtl.y - ptGrp.y;
			//--- グループボックス移動 --------------------------------//
			GetWindowRect(hwnd, &rct);
			MapWindowPoints(NULL, prm.hParent, (LPPOINT)&rct, 2);
			SetWindowPos(hwnd, NULL, rct.left + prm.mx, rct.top + prm.my, 0, 0, SWP_NOSIZE);
			//--- コントロール移動 ------------------------------------//
			rc = EnumChildWindows(prm.hParent, cbMvGrpEnum, (LPARAM)&prm);
		}
		else rc = TRUE;
	}
	return rc;
}
//----- 元の位置へ移動 -----------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcMoveGroupToOrg(HWND hwnd)
{
	BOOL		rc = FALSE;
	MVGPARAM	prm;
	POINT		pt;
	HANDLE		h;
	int			x, y;
	RECT		rct;

	if (IsWindow(hwnd)	&&	(prm.hParent = GetParent(hwnd)) != NULL) {
		if (h = GetPropA(hwnd, "AJCGRPORG")) {
			//--- 移動先クライアント位置設定 ------------------------------//
			x = (SW)LOWORD((UL)((UX)h));
			y = (SW)HIWORD((UL)((UX)h));
			//--- グループボックスのスクリーン位置設定 --------------------//
			GetWindowRect(hwnd, &prm.r);
			//--- グループボックスのクライアント位置設定 ------------------//
			pt.x = prm.r.left;
			pt.y = prm.r.top;
			MapWindowPoints(NULL, prm.hParent, (LPPOINT)&pt, 1);
			if (pt.x != x || pt.y != y) {
				//--- 移動量設定 ------------------------------------------//
				prm.mx = x - pt.x;
				prm.my = y - pt.y;
				//--- グループボックス移動 --------------------------------//
				GetWindowRect(hwnd, &rct);
				MapWindowPoints(NULL, prm.hParent, (LPPOINT)&rct, 2);
				SetWindowPos(hwnd, NULL, rct.left + prm.mx, rct.top + prm.my, 0, 0, SWP_NOSIZE);
				//--- コントロール移動 ------------------------------------//
				rc = EnumChildWindows(prm.hParent, cbMvGrpEnum, (LPARAM)&prm);
			}
			else rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	グループボックス内コントロールの列挙																		//
//																												//
//	引　数：	hwnd	- グループボックスのコントロールハンドル												//
//				cbp		- コールバックパラメタ																	//
//				cbEnum	- コントロール通知用コールバック関数													//
//																												//
//	戻り値：	通知したコントロールの個数																		//
//==============================================================================================================//
typedef struct {
	RECT	r;
	BOOL	n;
	UX		cbp;
	BOOL (CALLBACK *cb)(HWND hwnd, UX cbp);
} ACEGPARAM, *PACEGPARAM;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbAcegEnum(HWND hwnd, LPARAM lParam)
{
	BOOL		rc = TRUE;
	PACEGPARAM	p = (PACEGPARAM)lParam;
	RECT		rct;

	GetWindowRect(hwnd, &rct);
	if (rct.left >= p->r.left && rct.top >= p->r.top && rct.right <= p->r.right && rct.bottom <= p->r.bottom) {
		p->n++;
		if (p->cb != NULL) {
			rc = p->cb(hwnd, p->cbp);
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcCtrlEnumInGroup(HWND hwnd, UX cbp, BOOL (CALLBACK *cbEnum)(HWND hCtrl, UX cbp))
{
	ACEGPARAM	prm = {0};
	HWND		hParent;

	if (IsWindow(hwnd)	&&	(hParent = GetParent(hwnd)) != NULL) {
		GetWindowRect(hwnd, &prm.r);
		prm.n	= 0;
		prm.cbp = cbp;
		prm.cb	= cbEnum;
		EnumChildWindows(hParent, cbAcegEnum, (LPARAM)&prm);
	}
	return prm.n;
}
