﻿#include	"AjcInternal.h"
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
/*																												*/
/*	プロファイル／変数のエクスチェンジ																			*/
/*																												*/
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//--------------------------------------------------------------------------------------------------------------//
//	コントロール項目のプロパティ情報																			//
//--------------------------------------------------------------------------------------------------------------//
#define	CTRLPROPA	 "AjcCtrlProp"
#define	CTRLPROPW	L"AjcCtrlProp"
typedef enum {
	ITYP_UInt,			//	符号なし１０進整数
	ITYP_SInt,			//	符号つき１０進整数
	ITYP_Hex,			//	１６進整数
	ITYP_Real,			//	実数
	ITYP_UI64,			//	符号なし１０進整数（６４ビット）
	ITYP_SI64,			//	符号つき１０進整数（６４ビット）
	ITYP_H64,			//	１６進整数　　　　（６４ビット）
	ITYP_CHK,			//	チェックボックス
	ITYP_STR,			//	テキスト
	ITYP_CBO,			//	コンボボックス
	ITYP_UI8,			//	符号なし１０進整数（８ビット）
	ITYP_SI8,			//	符号つき１０進整数（８ビット）
	ITYP_H8,			//	１６進整数　　　　（８ビット）
	ITYP_UI16,			//	符号なし１０進整数（16ビット）
	ITYP_SI16,			//	符号つき１０進整数（16ビット）
	ITYP_H16,			//	１６進整数　　　　（16ビット）
} CTRLITEMTYPE;

//----- コントロール項目情報ヘッダ -------------------------------------------------------------------------------//
typedef struct {
	CTRLITEMTYPE	type;																//	コントロール項目のタイプ
	union {UB m_UB; SB m_SB; UW m_UW; SW m_SW; UI  m_UI; SI	 m_SI; ULL	m_ULL; SLL	m_SLL; double  m_double; VOP vp;} def;
	union {UB *p_UB; SB *p_SB; UW *p_UW; SW *p_SW; UI *p_UI; SI *p_SI; ULL *p_ULL; SLL *p_SLL; double *p_double; VOP vp;} var;
	int			opt;																	//	コントロール表示時の書式オプション
} CTRLPROPINFO, *PCTRLPROPINFO;

//----- コントロール項目情報（バイト文字）------------------------------------------------------------------------//
typedef struct {
	CTRLPROPINFO	hd;				//	コントロール項目情報ヘッダ
	BC			key[1];				//	プロファイルキー（文字列）
} CTRLPROPINFOA, *PCTRLPROPINFOA;

//----- コントロール項目情報（ワイド文字）------------------------------------------------------------------------//
typedef struct {
	CTRLPROPINFO	hd;				//	コントロール項目情報ヘッダ
	WC			key[1];				//	プロファイルキー（文字列）
} CTRLPROPINFOW, *PCTRLPROPINFOW;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AldpEnumChildA(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AldpEnumChildW(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AsdpEnumChildA(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AsdpEnumChildW(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK ArdvEnumChildA(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK ArdvEnumChildW(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AgdvEnumChildA(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AgdvEnumChildW(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AsdvEnumChildA(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK AsdvEnumChildW(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK ArdpEnumChildA(HWND hwnd, LPARAM lParam);
static BOOL CALLBACK ArdpEnumChildW(HWND hwnd, LPARAM lParam);

static	BOOL	SetWndData (HWND hwnd, HWND hGrp, UI data, C_WCP pSect);
static	C_WCP	GetWndData (HWND hwnd, HWND hGrp, UIP pDat);

static BOOL	SubLoadCtrlComboBoxA(HWND hwnd, C_BCP pSect, C_BCP pPrefix);
static BOOL	SubLoadCtrlComboBoxW(HWND hwnd, C_WCP pSect, C_WCP pPrefix);

static BOOL	SubSaveCtrlComboBoxA(HWND hwnd, C_BCP pSect, C_BCP pPrefix, BOOL fWithData);
static BOOL	SubSaveCtrlComboBoxW(HWND hwnd, C_WCP pSect, C_WCP pPrefix, BOOL fWithData);

//==============================================================================================================//
//	コントロール群エクスチェンジ設定（１０進整数項目）															//
//																												//
//	引　数：	hCtrl	  - コントロールハンドル																//
//				pKey	  - プロファイル・キー名																//
//				defValue  - デフォルト値																		//
//				fComma	  - 整数部の分離フラグ（３桁枚のカンマ等）												//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
#define	M_CTRLEXPROPNA(_T1_, _T2_)																				\
AJCEXPORT BOOL	WINAPI AjcSetCtrlProp##_T2_##A(HWND hCtrl, C_BCP pKey, _T1_ defValue, BOOL fComma, _T1_ *pVar)	\
{	BOOL			rc = FALSE;																					\
	PCTRLPROPINFOA	p;																							\
	if (IsWindow(hCtrl) && pKey != NULL) {																		\
		if (p = (PCTRLPROPINFOA)AJCMEM(sizeof(CTRLPROPINFOA) + strlen(pKey) + 1)) {								\
			if (SetPropA(hCtrl, CTRLPROPA, (HANDLE)p)) {														\
				p->hd.type		   = ITYP_##_T2_;																\
				p->hd.def.m_##_T1_ = defValue;																	\
				p->hd.opt		   = (fComma ? AJCSEP : 0);														\
				p->hd.var.p_##_T1_ = pVar;																		\
				strcpy(p->key, pKey);																			\
				rc = TRUE;																						\
			}																									\
			else free(p);																						\
		}																										\
	}																											\
	return rc;																									\
}
M_CTRLEXPROPNA(UI	 , UInt)
M_CTRLEXPROPNA(SI	 , SInt)
M_CTRLEXPROPNA(UB	 , UI8 )
M_CTRLEXPROPNA(SB	 , SI8 )
M_CTRLEXPROPNA(UW	 , UI16)
M_CTRLEXPROPNA(SW	 , SI16)
M_CTRLEXPROPNA(ULL	 , UI64)
M_CTRLEXPROPNA(SLL	 , SI64)

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
#define	M_CTRLEXPROPNW(_T1_, _T2_)																				\
AJCEXPORT BOOL	WINAPI AjcSetCtrlProp##_T2_##W(HWND hCtrl, C_WCP pKey, _T1_ defValue, BOOL fComma, _T1_ *pVar)	\
{	BOOL			rc = FALSE;																					\
	PCTRLPROPINFOW	p;																							\
	if (IsWindow(hCtrl) && pKey != NULL) {																		\
		if (p = (PCTRLPROPINFOW)AJCMEM(sizeof(CTRLPROPINFOW) + (wcslen(pKey) + 1) * 2)) {						\
			if (SetPropW(hCtrl, CTRLPROPW, (HANDLE)p)) {														\
				p->hd.type		   = ITYP_##_T2_;																\
				p->hd.def.m_##_T1_ = defValue;																	\
				p->hd.opt		   = (fComma ? AJCSEP : 0);														\
				p->hd.var.p_##_T1_ = pVar;																		\
				wcscpy(p->key, pKey);																			\
				rc = TRUE;																						\
			}																									\
			else free(p);																						\
		}																										\
	}																											\
	return rc;																									\
}
M_CTRLEXPROPNW(UI	 , UInt)
M_CTRLEXPROPNW(SI	 , SInt)
M_CTRLEXPROPNW(UB	 , UI8 )
M_CTRLEXPROPNW(SB	 , SI8 )
M_CTRLEXPROPNW(UW	 , UI16)
M_CTRLEXPROPNW(SW	 , SI16)
M_CTRLEXPROPNW(ULL	 , UI64)
M_CTRLEXPROPNW(SLL	 , SI64)

//==============================================================================================================//
//	コントロール群エクスチェンジ設定（１６進整数項目）															//
//																												//
//	引　数：	hCtrl	  - コントロールハンドル																//
//				pKey	  - プロファイル・キー名																//
//				defValue  - デフォルト値																		//
//				digits	  - 表示桁数（０の場合は桁揃えしない）													//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
#define	M_CTRLEXPROPHA(_T1_, _T2_)																				\
AJCEXPORT BOOL	WINAPI AjcSetCtrlProp##_T2_##A(HWND hCtrl, C_BCP pKey, _T1_ defValue, int digits, _T1_ *pVar)	\
{	BOOL			rc = FALSE;																					\
	PCTRLPROPINFOA	p;																							\
	if (IsWindow(hCtrl) && pKey != NULL) {																		\
		if (p = (PCTRLPROPINFOA)AJCMEM(sizeof(CTRLPROPINFOA) + strlen(pKey) + 1)) {								\
			if (SetPropA(hCtrl, CTRLPROPA, (HANDLE)p)) {														\
				p->hd.type		   = ITYP_##_T2_;																\
				p->hd.def.m_##_T1_ = defValue;																	\
				p->hd.opt		   = (digits ? (AJCSEP | digits) : 0);											\
				p->hd.var.p_##_T1_ = pVar;																		\
				strcpy(p->key, pKey);																			\
				rc = TRUE;																						\
			}																									\
			else free(p);																						\
		}																										\
	}																											\
	return rc;																									\
}
M_CTRLEXPROPHA(UI	 , Hex )
M_CTRLEXPROPHA(UB	 , H8  )
M_CTRLEXPROPHA(UW	 , H16 )
M_CTRLEXPROPHA(ULL	 , H64 )

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
#define	M_CTRLEXPROPHW(_T1_, _T2_)																				\
AJCEXPORT BOOL	WINAPI AjcSetCtrlProp##_T2_##W(HWND hCtrl, C_WCP pKey, _T1_ defValue, int digits, _T1_ *pVar)	\
{	BOOL			rc = FALSE;																					\
	PCTRLPROPINFOW	p;																							\
	if (IsWindow(hCtrl) && pKey != NULL) {																		\
		if (p = (PCTRLPROPINFOW)AJCMEM(sizeof(CTRLPROPINFOW) + (wcslen(pKey) + 1) * 2)) {						\
			if (SetPropW(hCtrl, CTRLPROPW, (HANDLE)p)) {														\
				p->hd.type		   = ITYP_##_T2_;																\
				p->hd.def.m_##_T1_ = defValue;																	\
				p->hd.opt		   = (digits ? (AJCSEP | digits) : 0);											\
				p->hd.var.p_##_T1_ = pVar;																		\
				wcscpy(p->key, pKey);																			\
				rc = TRUE;																						\
			}																									\
			else free(p);																						\
		}																										\
	}																											\
	return rc;																									\
}
M_CTRLEXPROPHW(UI	 , Hex )
M_CTRLEXPROPHW(UB	 , H8  )
M_CTRLEXPROPHW(UW	 , H16 )
M_CTRLEXPROPHW(ULL	 , H64 )

//==============================================================================================================//
//	コントロール群エクスチェンジ設定（実数）																	//
//																												//
//	引　数：	hCtrl	  - コントロールハンドル																//
//				pKey	  - プロファイル・キー名																//
//				defValue  - デフォルト値																		//
//				fComma	  - 整数部の分離フラグ（３桁枚のカンマ等）												//
//				prec	  - 小数部の桁数																		//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcSetCtrlPropRealA(HWND hCtrl, C_BCP pKey, double defValue, BOOL fComma, int prec, double *pVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOA	p;
	if (IsWindow(hCtrl) && pKey != NULL) {
		if (p = (PCTRLPROPINFOA)AJCMEM(sizeof(CTRLPROPINFOA) + strlen(pKey) + 1)) {
			if (SetPropA(hCtrl, CTRLPROPA, (HANDLE)p)) {
				p->hd.type		   = ITYP_Real;
				p->hd.def.m_double = defValue;
				p->hd.opt		   = ((fComma ? AJCSEP : 0) | prec);
				p->hd.var.p_double = pVar;
				strcpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcSetCtrlPropRealW(HWND hCtrl, C_WCP pKey, double defValue, BOOL fComma, int prec, double *pVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOW	p;
	if (IsWindow(hCtrl) && pKey != NULL) {
		if (p = (PCTRLPROPINFOW)AJCMEM(sizeof(CTRLPROPINFOW) + (wcslen(pKey) + 1) * 2)) {
			if (SetPropW(hCtrl, CTRLPROPW, (HANDLE)p)) {
				p->hd.type		   = ITYP_Real;
				p->hd.def.m_double = defValue;
				p->hd.opt		   = ((fComma ? AJCSEP : 0) | prec);
				p->hd.var.p_double = pVar;
				wcscpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}

//==============================================================================================================//
//	コントロール群エクスチェンジ設定（チェックボックス）														//
//																												//
//	引　数：	hCtrl	  - コントロールハンドル																//
//				pKey	  - プロファイル・キー名																//
//				defState  - デフォルト状態																		//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropChkA (HWND hCtrl, C_BCP pKey, UI defState, UI *pVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOA	p;
	if (IsWindow(hCtrl) && pKey != NULL) {
		if (p = (PCTRLPROPINFOA)AJCMEM(sizeof(CTRLPROPINFOA) + strlen(pKey) + 1)) {
			if (SetPropA(hCtrl, CTRLPROPA, (HANDLE)p)) {
				p->hd.type		 = ITYP_CHK;
				p->hd.def.m_UI	 = defState;
				p->hd.opt		 = 0;
				p->hd.var.p_UI	 = pVar;
				strcpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropChkW (HWND hCtrl, C_WCP pKey, UI defState, UI *pVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOW	p;
	if (IsWindow(hCtrl) && pKey != NULL) {
		if (p = (PCTRLPROPINFOW)AJCMEM(sizeof(CTRLPROPINFOW) + (wcslen(pKey) + 1) * 2)) {
			if (SetPropW(hCtrl, CTRLPROPW, (HANDLE)p)) {
				p->hd.type		 = ITYP_CHK;
				p->hd.def.m_UI	 = defState;
				p->hd.opt		 = 0;
				p->hd.var.p_UI	 = pVar;
				wcscpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロール群エクスチェンジ設定（テキスト）																//
//																												//
//	引　数：	hCtrl	  - コントロールハンドル																//
//				pKey	  - プロファイル・キー名																//
//				pDefStr	  - デフォルト文字列のアドレス															//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//				lVar	  - 変数の文字数																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropStrA (HWND hCtrl, C_BCP pKey, C_BCP pDefStr, BCP pVar, int lVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOA	p;
	if (IsWindow(hCtrl) && pKey != NULL) {
		if (p = (PCTRLPROPINFOA)AJCMEM(sizeof(CTRLPROPINFOA) + strlen(pKey) + 1)) {
			if (SetPropA(hCtrl, CTRLPROPA, (HANDLE)p)) {
				p->hd.type		 = ITYP_STR;
				p->hd.def.vp	 = (VOP)pDefStr;
				p->hd.opt		 = lVar;
				p->hd.var.vp	 = pVar;
				strcpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropStrW (HWND hCtrl, C_WCP pKey, C_WCP pDefStr, WCP pVar, int lVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOW	p;
	if (IsWindow(hCtrl) && pKey != NULL) {
		if (p = (PCTRLPROPINFOW)AJCMEM(sizeof(CTRLPROPINFOW) + (wcslen(pKey) + 1) * 2)) {
			if (SetPropW(hCtrl, CTRLPROPW, (HANDLE)p)) {
				p->hd.type		 = ITYP_STR;
				p->hd.def.vp	 = (VOP)pDefStr;
				p->hd.opt		 = lVar;
				p->hd.var.vp	 = pVar;
				wcscpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロール群エクスチェンジ設定（コンボボックス）															//
//																												//
//	引　数：	hCtrl	  - コントロールハンドル																//
//				pKey	  - プロファイル・キー名																//
//				pDefLst	  - デフォルトリスト項目群のアドレス（多重文字列へのポインタ）							//
//				DefIx	  - デフォルトの選択項目インデクス														//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropCboA (HWND hCtrl, C_BCP pKey, C_BCP pDefLst, UI DefIx, UIP pVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOA	p;
	if (IsWindow(hCtrl)) {
		if (p = (PCTRLPROPINFOA)AJCMEM(sizeof(CTRLPROPINFOA) + strlen(pKey) + 1)) {
			if (SetPropA(hCtrl, CTRLPROPA, (HANDLE)p)) {
				p->hd.type		 = ITYP_CBO;
				p->hd.def.vp	 = (VOP)pDefLst;
				p->hd.opt		 = DefIx;
				p->hd.var.vp	 = pVar;
				strcpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropCboW (HWND hCtrl, C_WCP pKey, C_WCP pDefLst, UI DefIx, UIP pVar)
{	BOOL			rc = FALSE;
	PCTRLPROPINFOW	p;
	if (IsWindow(hCtrl)) {
		if (p = (PCTRLPROPINFOW)AJCMEM(sizeof(CTRLPROPINFOW) + (wcslen(pKey) + 1) * 2)) {
			if (SetPropW(hCtrl, CTRLPROPW, (HANDLE)p)) {
				p->hd.type		 = ITYP_CBO;
				p->hd.def.vp	 = (VOP)pDefLst;
				p->hd.opt		 = DefIx;
				p->hd.var.vp	 = pVar;
				wcscpy(p->key, pKey);
				rc = TRUE;
			}
			else free(p);
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロール群エクスチェンジ（プロファイルからコントロールの読み出し）										//
//																												//
//	引　数：	hwnd	  - ウインドハンドル																	//
//				pSec	  - プロファイルセクション名															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
typedef struct {
	C_VOP	pSec;
	BOOL	rc;
} ALDP_PARAM, *PALDP_PARAM;
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLoadCtrlProfilesA  (HWND hwnd, C_BCP pSec)
{
	BOOL		rc = FALSE;
	ALDP_PARAM	prm;

	if (IsWindow(hwnd) && pSec != NULL) {
		prm.pSec = pSec;
		prm.rc	 = TRUE;
		prm.rc &= EnumChildWindows(hwnd, AldpEnumChildA, (LPARAM)&prm);
		rc = prm.rc;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AldpEnumChildA(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOA	p;
	PALDP_PARAM		pPrm = (PALDP_PARAM)lParam;

	if (p = (PCTRLPROPINFOA)GetPropA(hwnd, CTRLPROPA)) {
		switch (p->hd.type) {
			case ITYP_UInt:	pPrm->rc &= AjcSetOptCtrlUInt(hwnd,		AjcGetProfileUIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UI	 ), p->hd.opt); break;
			case ITYP_SInt:	pPrm->rc &= AjcSetOptCtrlSInt(hwnd,		AjcGetProfileSIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_SI	 ), p->hd.opt); break;
			case ITYP_Hex:	pPrm->rc &= AjcSetOptCtrlHex (hwnd,		AjcGetProfileHexA ((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UI	 ), p->hd.opt); break;
			case ITYP_Real:	pPrm->rc &= AjcSetOptCtrlReal(hwnd,		AjcGetProfileRealA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_double ), p->hd.opt); break;
			case ITYP_UI8 :	pPrm->rc &= AjcSetOptCtrlUI8 (hwnd, (UB)AjcGetProfileUIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UB	 ), p->hd.opt); break;
			case ITYP_SI8 :	pPrm->rc &= AjcSetOptCtrlSI8 (hwnd, (SB)AjcGetProfileSIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_SB	 ), p->hd.opt); break;
			case ITYP_H8 :	pPrm->rc &= AjcSetOptCtrlH8	 (hwnd, (UB)AjcGetProfileHexA ((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UB	 ), p->hd.opt); break;
			case ITYP_UI16:	pPrm->rc &= AjcSetOptCtrlUI16(hwnd, (UW)AjcGetProfileUIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UW	 ), p->hd.opt); break;
			case ITYP_SI16:	pPrm->rc &= AjcSetOptCtrlSI16(hwnd, (SW)AjcGetProfileSIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_SW	 ), p->hd.opt); break;
			case ITYP_H16:	pPrm->rc &= AjcSetOptCtrlH16 (hwnd, (UW)AjcGetProfileHexA ((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UW	 ), p->hd.opt); break;
			case ITYP_UI64:	pPrm->rc &= AjcSetOptCtrlUI64(hwnd,		AjcGetProfileUI64A((C_BCP)pPrm->pSec, p->key, p->hd.def.m_ULL	 ), p->hd.opt); break;
			case ITYP_SI64:	pPrm->rc &= AjcSetOptCtrlSI64(hwnd,		AjcGetProfileSI64A((C_BCP)pPrm->pSec, p->key, p->hd.def.m_SLL	 ), p->hd.opt); break;
			case ITYP_H64:	pPrm->rc &= AjcSetOptCtrlH64 (hwnd,		AjcGetProfileH64A ((C_BCP)pPrm->pSec, p->key, p->hd.def.m_ULL	 ), p->hd.opt); break;
			case ITYP_CHK:	pPrm->rc &= AjcSetCtrlChk	 (hwnd,		AjcGetProfileUIntA((C_BCP)pPrm->pSec, p->key, p->hd.def.m_UI	 )			 ); break;

			//	文字列
			case ITYP_STR:	{	BCP	pKey = NULL;
								BCP	pTxt = NULL;
								UI	lKey = (UI)strlen(p->key) + 8;
								UI	lTxt = 512;
								//	文字列長読み出し
								if (pKey = AjcTAllocA(lKey)) {
									AjcSnPrintFA(pKey, lKey, "%s_Stl", p->key);
									lTxt = AjcGetProfileUIntA((C_BCP)pPrm->pSec, pKey, 512);
									AjcTFree(pKey);
								}
								//	文字列読み出し
								if (pTxt = AjcTAllocA(lTxt)) {
									if (p->hd.def.vp != NULL) AjcGetProfileStrA((C_BCP)pPrm->pSec, p->key, (C_BCP)p->hd.def.vp, pTxt, lTxt);
									else					  AjcGetProfileStrA((C_BCP)pPrm->pSec, p->key, ""				  , pTxt, lTxt);
									pPrm->rc &= AjcSetCtrlStrA(hwnd, pTxt);
									AjcTFree(pTxt);
								}
								else pPrm->rc = FALSE;
							}
							break;

			//	コンボボックス
			case ITYP_CBO:	{	BCP		pKey = NULL;
								UI		lKey = (UI)strlen(p->key) + 16;
								if ((pKey = AjcTAllocA(lKey)) != NULL) {
									AjcSnPrintFA(pKey, lKey, "Cbo%s_Sel", p->key);
									//	セーブ済プロファイルがあれば、当該プロファイル読み出し
									if (AjcGetProfileSIntA((C_BCP)pPrm->pSec, pKey, -10) != -10) {
										pPrm->rc &= SubLoadCtrlComboBoxA(hwnd, (C_BCP)pPrm->pSec, p->key);
									}
									//	セーブ済プロファイルがなければ、デフォルトリスト設定
									else {
										if (p->hd.def.vp != NULL) pPrm->rc &= AjcSetCtrlCboListA(hwnd, p->hd.def.vp);
										else					  pPrm->rc &= AjcSetCtrlCboListA(hwnd, "\0" 	   );
										SendMessageA(hwnd, CB_SETCURSEL, p->hd.opt, 0);
									}
									AjcTFree(pKey);
								}
								else pPrm->rc = FALSE;
							}
							break;
		}
	}
	return TRUE;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLoadCtrlProfilesW  (HWND hwnd, C_WCP pSec)
{
	BOOL		rc = FALSE;
	ALDP_PARAM	prm;

	if (IsWindow(hwnd) && pSec != NULL) {
		prm.pSec = pSec;
		prm.rc	 = TRUE;
		prm.rc &= EnumChildWindows(hwnd, AldpEnumChildW, (LPARAM)&prm);
		rc = prm.rc;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AldpEnumChildW(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOW	p;
	PALDP_PARAM		pPrm = (PALDP_PARAM)lParam;

	if (p = (PCTRLPROPINFOW)GetPropW(hwnd, CTRLPROPW)) {
		switch (p->hd.type) {
			case ITYP_UInt:	pPrm->rc &= AjcSetOptCtrlUInt(hwnd,		AjcGetProfileUIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UI	 ), p->hd.opt); break;
			case ITYP_SInt:	pPrm->rc &= AjcSetOptCtrlSInt(hwnd,		AjcGetProfileSIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_SI	 ), p->hd.opt); break;
			case ITYP_Hex:	pPrm->rc &= AjcSetOptCtrlHex (hwnd,		AjcGetProfileHexW ((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UI	 ), p->hd.opt); break;
			case ITYP_Real:	pPrm->rc &= AjcSetOptCtrlReal(hwnd,		AjcGetProfileRealW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_double ), p->hd.opt); break;
			case ITYP_UI8 :	pPrm->rc &= AjcSetOptCtrlUI8 (hwnd, (UB)AjcGetProfileUIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UB	 ), p->hd.opt); break;
			case ITYP_SI8 :	pPrm->rc &= AjcSetOptCtrlSI8 (hwnd, (SB)AjcGetProfileSIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_SB	 ), p->hd.opt); break;
			case ITYP_H8  :	pPrm->rc &= AjcSetOptCtrlH8	 (hwnd, (UB)AjcGetProfileHexW ((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UB	 ), p->hd.opt); break;
			case ITYP_UI16:	pPrm->rc &= AjcSetOptCtrlUI16(hwnd, (UW)AjcGetProfileUIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UW	 ), p->hd.opt); break;
			case ITYP_SI16:	pPrm->rc &= AjcSetOptCtrlSI16(hwnd, (SW)AjcGetProfileSIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_SW	 ), p->hd.opt); break;
			case ITYP_H16 :	pPrm->rc &= AjcSetOptCtrlH16 (hwnd, (UW)AjcGetProfileHexW ((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UW	 ), p->hd.opt); break;
			case ITYP_UI64:	pPrm->rc &= AjcSetOptCtrlUI64(hwnd,		AjcGetProfileUI64W((C_WCP)pPrm->pSec, p->key, p->hd.def.m_ULL	 ), p->hd.opt); break;
			case ITYP_SI64:	pPrm->rc &= AjcSetOptCtrlSI64(hwnd,		AjcGetProfileSI64W((C_WCP)pPrm->pSec, p->key, p->hd.def.m_SLL	 ), p->hd.opt); break;
			case ITYP_H64:	pPrm->rc &= AjcSetOptCtrlH64 (hwnd,		AjcGetProfileH64W ((C_WCP)pPrm->pSec, p->key, p->hd.def.m_ULL	 ), p->hd.opt); break;
			case ITYP_CHK:	pPrm->rc &= AjcSetCtrlChk	 (hwnd,		AjcGetProfileUIntW((C_WCP)pPrm->pSec, p->key, p->hd.def.m_UI	 )			 ); break;

			//	文字列
			case ITYP_STR:	{	WCP	pKey = NULL;
								WCP	pTxt = NULL;
								UI	lKey = (UI)wcslen(p->key) + 8;
								UI	lTxt = 512;
								//	文字列長読み出し
								if (pKey = AjcTAllocW(lKey)) {
									AjcSnPrintFW(pKey, lKey, L"%s_Stl", p->key);
									lTxt = AjcGetProfileUIntW((C_WCP)pPrm->pSec, pKey, 512);
									AjcTFree(pKey);
								}
								//	文字列読み出し
								if (pTxt = AjcTAllocW(lTxt)) {
									if (p->hd.def.vp != NULL) AjcGetProfileStrW((C_WCP)pPrm->pSec, p->key, (C_WCP)p->hd.def.vp, pTxt, lTxt);
									else					  AjcGetProfileStrW((C_WCP)pPrm->pSec, p->key, L""				  , pTxt, lTxt);
									pPrm->rc &= AjcSetCtrlStrW(hwnd, pTxt);
									AjcTFree(pTxt);
								}
								else pPrm->rc = FALSE;
							}
							break;

			//	コンボボックス
			case ITYP_CBO:	{	WCP		pKey = NULL;
								UI		lKey = (UI)wcslen(p->key) + 16;
								if ((pKey = AjcTAllocW(lKey)) != NULL) {
									AjcSnPrintFW(pKey, lKey, L"Cbo%s_Sel", p->key);
									//	セーブ済プロファイルがあれば、当該プロファイル読み出し
									if (AjcGetProfileSIntW((C_WCP)pPrm->pSec, pKey, -12) != -12) {
										pPrm->rc &= SubLoadCtrlComboBoxW(hwnd, (C_WCP)pPrm->pSec, p->key);
									}
									//	セーブ済プロファイルがなければ、デフォルトリスト設定
									else {
										if (p->hd.def.vp != NULL) pPrm->rc &= AjcSetCtrlCboListW(hwnd, (C_WCP)p->hd.def.vp);
										else					  pPrm->rc &= AjcSetCtrlCboListW(hwnd, L"\0"			  );
										SendMessageW(hwnd, CB_SETCURSEL, p->hd.opt, 0);
									}
									AjcTFree(pKey);
								}
								else pPrm->rc = FALSE;
							}
							break;
		}
	}
	return TRUE;
}
//==============================================================================================================//
//	コントロール群エクスチェンジ（プロファイルへコントロールの書き込み）										//
//																												//
//	引　数：	hwnd	  - ウインドハンドル																	//
//				pSec	  - プロファイルセクション名															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
typedef struct {
	C_VOP	pSec;
	BOOL	rc;
} ASDP_PARAM, *PASDP_PARAM;
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSaveCtrlProfilesA  (HWND hwnd, C_BCP pSec)
{
	BOOL		rc = FALSE;
	ASDP_PARAM	prm;

	if (IsWindow(hwnd) && pSec != NULL) {
		prm.pSec = pSec;
		prm.rc	 = TRUE;
		prm.rc &= EnumChildWindows(hwnd, AsdpEnumChildA, (LPARAM)&prm);
		rc = prm.rc;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AsdpEnumChildA(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOA	p;
	PASDP_PARAM		pPrm = (PASDP_PARAM)lParam;

	if (p = (PCTRLPROPINFOA)GetPropA(hwnd, CTRLPROPA)) {
		switch (p->hd.type) {
			case ITYP_UInt:	pPrm->rc &= AjcPutProfileUIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlUInt(hwnd)); break;
			case ITYP_SInt:	pPrm->rc &= AjcPutProfileSIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlSInt(hwnd)); break;
			case ITYP_Hex:	pPrm->rc &= AjcPutProfileHexA ((BCP)pPrm->pSec, p->key, AjcGetCtrlHex (hwnd)); break;
			case ITYP_Real:	pPrm->rc &= AjcPutProfileRealA((BCP)pPrm->pSec, p->key, AjcGetCtrlReal(hwnd)); break;
			case ITYP_UI8 :	pPrm->rc &= AjcPutProfileUIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlUInt(hwnd)); break;
			case ITYP_SI8 :	pPrm->rc &= AjcPutProfileSIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlSInt(hwnd)); break;
			case ITYP_H8  :	pPrm->rc &= AjcPutProfileHexA ((BCP)pPrm->pSec, p->key, AjcGetCtrlHex (hwnd)); break;
			case ITYP_UI16:	pPrm->rc &= AjcPutProfileUIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlUInt(hwnd)); break;
			case ITYP_SI16:	pPrm->rc &= AjcPutProfileSIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlSInt(hwnd)); break;
			case ITYP_H16 :	pPrm->rc &= AjcPutProfileHexA ((BCP)pPrm->pSec, p->key, AjcGetCtrlHex (hwnd)); break;
			case ITYP_UI64:	pPrm->rc &= AjcPutProfileUI64A((BCP)pPrm->pSec, p->key, AjcGetCtrlUI64(hwnd)); break;
			case ITYP_SI64:	pPrm->rc &= AjcPutProfileSI64A((BCP)pPrm->pSec, p->key, AjcGetCtrlSI64(hwnd)); break;
			case ITYP_H64:	pPrm->rc &= AjcPutProfileH64A ((BCP)pPrm->pSec, p->key, AjcGetCtrlH64 (hwnd)); break;
			case ITYP_CHK:	pPrm->rc &= AjcPutProfileUIntA((BCP)pPrm->pSec, p->key, AjcGetCtrlChk (hwnd)); break;
			//	文字列
			case ITYP_STR:	{	BCP	pKey = NULL;
								BCP	pTxt = NULL;
								UI	lKey = (UI)strlen(p->key) + 8;
								UI	lTxt = AjcGetCtrlStrLenA(hwnd) + 1;
								if (pTxt = AjcTAllocA(lTxt)) {
									//	文字列記録
									AjcGetCtrlStrA(hwnd, pTxt, lTxt);
									pPrm->rc &= AjcPutProfileStrA((C_BCP)pPrm->pSec, p->key, pTxt);
									//	文字列長記録
									if (pKey = AjcTAllocA(lKey)) {
										AjcSnPrintFA(pKey, lKey, "%s_Stl", p->key);
										AjcPutProfileUIntA((C_BCP)pPrm->pSec, pKey, lTxt);
										AjcTFree(pKey);
									}
									AjcTFree(pTxt);
								}
								else pPrm->rc = FALSE;
							}
							break;
			//	コンボボックス
			case ITYP_CBO:	pPrm->rc &= SubSaveCtrlComboBoxA(hwnd, (C_BCP)pPrm->pSec, p->key, TRUE);
							break;
		}
	}
	return TRUE;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSaveCtrlProfilesW  (HWND hwnd, C_WCP pSec)
{
	BOOL		rc = FALSE;
	ASDP_PARAM	prm;

	if (IsWindow(hwnd) && pSec != NULL) {
		prm.pSec = pSec;
		prm.rc	 = TRUE;
		prm.rc &= EnumChildWindows(hwnd, AsdpEnumChildW, (LPARAM)&prm);
		rc = prm.rc;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AsdpEnumChildW(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOW	p;
	PASDP_PARAM		pPrm = (PASDP_PARAM)lParam;

	if (p = (PCTRLPROPINFOW)GetPropW(hwnd, CTRLPROPW)) {
		switch (p->hd.type) {
			case ITYP_UInt:	pPrm->rc &= AjcPutProfileUIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlUInt(hwnd)); break;
			case ITYP_SInt:	pPrm->rc &= AjcPutProfileSIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlSInt(hwnd)); break;
			case ITYP_Hex:	pPrm->rc &= AjcPutProfileHexW ((WCP)pPrm->pSec, p->key, AjcGetCtrlHex (hwnd)); break;
			case ITYP_Real:	pPrm->rc &= AjcPutProfileRealW((WCP)pPrm->pSec, p->key, AjcGetCtrlReal(hwnd)); break;
			case ITYP_UI8 :	pPrm->rc &= AjcPutProfileUIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlUInt(hwnd)); break;
			case ITYP_SI8 :	pPrm->rc &= AjcPutProfileSIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlSInt(hwnd)); break;
			case ITYP_H8  :	pPrm->rc &= AjcPutProfileHexW ((WCP)pPrm->pSec, p->key, AjcGetCtrlHex (hwnd)); break;
			case ITYP_UI16:	pPrm->rc &= AjcPutProfileUIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlUInt(hwnd)); break;
			case ITYP_SI16:	pPrm->rc &= AjcPutProfileSIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlSInt(hwnd)); break;
			case ITYP_H16 :	pPrm->rc &= AjcPutProfileHexW ((WCP)pPrm->pSec, p->key, AjcGetCtrlHex (hwnd)); break;
			case ITYP_UI64:	pPrm->rc &= AjcPutProfileUI64W((WCP)pPrm->pSec, p->key, AjcGetCtrlUI64(hwnd)); break;
			case ITYP_SI64:	pPrm->rc &= AjcPutProfileSI64W((WCP)pPrm->pSec, p->key, AjcGetCtrlSI64(hwnd)); break;
			case ITYP_H64:	pPrm->rc &= AjcPutProfileH64W ((WCP)pPrm->pSec, p->key, AjcGetCtrlH64 (hwnd)); break;
			case ITYP_CHK:	pPrm->rc &= AjcPutProfileUIntW((WCP)pPrm->pSec, p->key, AjcGetCtrlChk (hwnd)); break;

			//	文字列
			case ITYP_STR:	{	WCP	pKey = NULL;
								WCP	pTxt = NULL;
								UI	lKey = (UI)wcslen(p->key) + 8;
								UI	lTxt = AjcGetCtrlStrLenW(hwnd) + 1;
								if (pTxt = AjcTAllocW(lTxt)) {
									//	文字列記録
									AjcGetCtrlStrW(hwnd, pTxt, lTxt);
									pPrm->rc &= AjcPutProfileStrW((C_WCP)pPrm->pSec, p->key, pTxt);
									//	文字列長記録
									if (pKey = AjcTAllocW(lKey)) {
										AjcSnPrintFW(pKey, lKey, L"%s_Stl", p->key);
										AjcPutProfileUIntW((C_WCP)pPrm->pSec, pKey, lTxt);
										AjcTFree(pKey);
									}
									AjcTFree(pTxt);
								}
								else pPrm->rc = FALSE;
							}
							break;

			//	コンボボックス
			case ITYP_CBO:	pPrm->rc &= SubSaveCtrlComboBoxW(hwnd, (C_WCP)pPrm->pSec, p->key, TRUE);
							break;
		}
	}
	return TRUE;
}
//==============================================================================================================//
//	コントロール群エクスチェンジ（数値項目の表示リフレッシュ）													//
//																												//
//	引　数：	hwnd	  - ウインドハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRefreshCtrlValuesA(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, ArdvEnumChildA, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK ArdvEnumChildA(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOA	p;

	if (p = (PCTRLPROPINFOA)GetPropA(hwnd, CTRLPROPA)) {
		switch (p->hd.type) {
			case ITYP_UInt:	AjcSetOptCtrlUInt(hwnd,		AjcGetCtrlUInt(hwnd), p->hd.opt); break;
			case ITYP_SInt:	AjcSetOptCtrlSInt(hwnd,		AjcGetCtrlSInt(hwnd), p->hd.opt); break;
			case ITYP_Hex:	AjcSetOptCtrlHex (hwnd,		AjcGetCtrlHex (hwnd), p->hd.opt); break;
			case ITYP_Real:	AjcSetOptCtrlReal(hwnd,		AjcGetCtrlReal(hwnd), p->hd.opt); break;
			case ITYP_UI8 :	AjcSetOptCtrlUI8 (hwnd, (UB)AjcGetCtrlUInt(hwnd), p->hd.opt); break;
			case ITYP_SI8 :	AjcSetOptCtrlSI8 (hwnd, (SB)AjcGetCtrlSInt(hwnd), p->hd.opt); break;
			case ITYP_H8  :	AjcSetOptCtrlH8	 (hwnd, (UB)AjcGetCtrlHex (hwnd), p->hd.opt); break;
			case ITYP_UI16:	AjcSetOptCtrlUI16(hwnd, (UW)AjcGetCtrlUInt(hwnd), p->hd.opt); break;
			case ITYP_SI16:	AjcSetOptCtrlSI16(hwnd, (SW)AjcGetCtrlSInt(hwnd), p->hd.opt); break;
			case ITYP_H16 :	AjcSetOptCtrlH16 (hwnd, (UW)AjcGetCtrlHex (hwnd), p->hd.opt); break;
			case ITYP_UI64:	AjcSetOptCtrlUI64(hwnd,		AjcGetCtrlUI64(hwnd), p->hd.opt); break;
			case ITYP_SI64:	AjcSetOptCtrlSI64(hwnd,		AjcGetCtrlSI64(hwnd), p->hd.opt); break;
			case ITYP_H64:	AjcSetOptCtrlH64 (hwnd,		AjcGetCtrlH64 (hwnd), p->hd.opt); break;
		}
	}
	return TRUE;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRefreshCtrlValuesW(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, ArdvEnumChildW, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK ArdvEnumChildW(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOW	p;

	if (p = (PCTRLPROPINFOW)GetPropW(hwnd, CTRLPROPW)) {
		switch (p->hd.type) {
			case ITYP_UInt:	AjcSetOptCtrlUInt(hwnd,		AjcGetCtrlUInt(hwnd), p->hd.opt); break;
			case ITYP_SInt:	AjcSetOptCtrlSInt(hwnd,		AjcGetCtrlSInt(hwnd), p->hd.opt); break;
			case ITYP_Hex:	AjcSetOptCtrlHex (hwnd,		AjcGetCtrlHex (hwnd), p->hd.opt); break;
			case ITYP_Real:	AjcSetOptCtrlReal(hwnd,		AjcGetCtrlReal(hwnd), p->hd.opt); break;
			case ITYP_UI8 :	AjcSetOptCtrlUI8 (hwnd, (UB)AjcGetCtrlUInt(hwnd), p->hd.opt); break;
			case ITYP_SI8 :	AjcSetOptCtrlSI8 (hwnd, (SB)AjcGetCtrlSInt(hwnd), p->hd.opt); break;
			case ITYP_H8  :	AjcSetOptCtrlH8	 (hwnd, (UB)AjcGetCtrlHex (hwnd), p->hd.opt); break;
			case ITYP_UI16:	AjcSetOptCtrlUI16(hwnd, (UW)AjcGetCtrlUInt(hwnd), p->hd.opt); break;
			case ITYP_SI16:	AjcSetOptCtrlSI16(hwnd, (SW)AjcGetCtrlSInt(hwnd), p->hd.opt); break;
			case ITYP_H16 :	AjcSetOptCtrlH16 (hwnd, (UW)AjcGetCtrlHex (hwnd), p->hd.opt); break;
			case ITYP_UI64:	AjcSetOptCtrlUI64(hwnd,		AjcGetCtrlUI64(hwnd), p->hd.opt); break;
			case ITYP_SI64:	AjcSetOptCtrlSI64(hwnd,		AjcGetCtrlSI64(hwnd), p->hd.opt); break;
			case ITYP_H64:	AjcSetOptCtrlH64 (hwnd,		AjcGetCtrlH64 (hwnd), p->hd.opt); break;
		}
	}
	return TRUE;
}

//==============================================================================================================//
//	コントロール群エクスチェンジ（ダイアログの内容を変数に設定）												//
//																												//
//	引　数：	hwnd	  - ウインドハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcGetCtrlValuesA(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, AgdvEnumChildA, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AgdvEnumChildA(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOA	p;

	if (p = (PCTRLPROPINFOA)GetPropA(hwnd, CTRLPROPA)) {
		if (p->hd.var.vp != NULL) {
			switch (p->hd.type) {
				case ITYP_UInt:	*p->hd.var.p_UI		=	  AjcGetCtrlUInt(hwnd); break;
				case ITYP_SInt:	*p->hd.var.p_SI		=	  AjcGetCtrlSInt(hwnd); break;
				case ITYP_Hex:	*p->hd.var.p_UI		=	  AjcGetCtrlHex (hwnd); break;
				case ITYP_Real:	*p->hd.var.p_double =	  AjcGetCtrlReal(hwnd); break;
				case ITYP_UI8 :	*p->hd.var.p_UB		= (UB)AjcGetCtrlUInt(hwnd); break;
				case ITYP_SI8 :	*p->hd.var.p_SB		= (SB)AjcGetCtrlSInt(hwnd); break;
				case ITYP_H8  :	*p->hd.var.p_UB		= (UB)AjcGetCtrlHex (hwnd); break;
				case ITYP_UI16:	*p->hd.var.p_UW		= (UW)AjcGetCtrlUInt(hwnd); break;
				case ITYP_SI16:	*p->hd.var.p_SW		= (SW)AjcGetCtrlSInt(hwnd); break;
				case ITYP_H16 :	*p->hd.var.p_UW		= (UW)AjcGetCtrlHex (hwnd); break;
				case ITYP_UI64:	*p->hd.var.p_ULL	=	  AjcGetCtrlUI64(hwnd); break;
				case ITYP_SI64:	*p->hd.var.p_SLL	=	  AjcGetCtrlSI64(hwnd); break;
				case ITYP_H64:	*p->hd.var.p_ULL	=	  AjcGetCtrlH64 (hwnd); break;
				case ITYP_CHK:	*p->hd.var.p_UI		=	  AjcGetCtrlChk (hwnd); break;
				case ITYP_STR:	if (p->hd.opt != 0) {
									AjcGetCtrlStrA(hwnd, p->hd.var.vp, p->hd.opt);
								}
								break;
				case ITYP_CBO:	*p->hd.var.p_SI = (SI)SendMessageA(hwnd, CB_GETCURSEL, 0, 0); break;
			}
		}
	}
	return TRUE;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcGetCtrlValuesW(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, AgdvEnumChildW, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AgdvEnumChildW(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOW	p;

	if (p = (PCTRLPROPINFOW)GetPropW(hwnd, CTRLPROPW)) {
		if (p->hd.var.vp != NULL) {
			switch (p->hd.type) {
				case ITYP_UInt:	*p->hd.var.p_UI		=	  AjcGetCtrlUInt(hwnd); break;
				case ITYP_SInt:	*p->hd.var.p_SI		=	  AjcGetCtrlSInt(hwnd); break;
				case ITYP_Hex:	*p->hd.var.p_UI		=	  AjcGetCtrlHex (hwnd); break;
				case ITYP_Real:	*p->hd.var.p_double =	  AjcGetCtrlReal(hwnd); break;
				case ITYP_UI8 :	*p->hd.var.p_UB		= (UB)AjcGetCtrlUInt(hwnd); break;
				case ITYP_SI8 :	*p->hd.var.p_SB		= (SB)AjcGetCtrlSInt(hwnd); break;
				case ITYP_H8  :	*p->hd.var.p_UB		= (UB)AjcGetCtrlHex (hwnd); break;
				case ITYP_UI16:	*p->hd.var.p_UW		= (UW)AjcGetCtrlUInt(hwnd); break;
				case ITYP_SI16:	*p->hd.var.p_SW		= (SW)AjcGetCtrlSInt(hwnd); break;
				case ITYP_H16 :	*p->hd.var.p_UW		= (UW)AjcGetCtrlHex (hwnd); break;
				case ITYP_UI64:	*p->hd.var.p_ULL	=	  AjcGetCtrlUI64(hwnd); break;
				case ITYP_SI64:	*p->hd.var.p_SLL	=	  AjcGetCtrlSI64(hwnd); break;
				case ITYP_H64:	*p->hd.var.p_ULL	=	  AjcGetCtrlH64 (hwnd); break;
				case ITYP_CHK:	*p->hd.var.p_UI		=	  AjcGetCtrlChk (hwnd); break;
				case ITYP_STR:	if (p->hd.opt != 0) {
									AjcGetCtrlStrW(hwnd, p->hd.var.vp, p->hd.opt);
								}
								break;
				case ITYP_CBO:	*p->hd.var.p_SI = (SI)SendMessageW(hwnd, CB_GETCURSEL, 0, 0); break;
			}
		}
	}
	return TRUE;
}

//==============================================================================================================//
//	コントロール群エクスチェンジ（変数の内容をダイアログに設定）												//
//																												//
//	引　数：	hwnd	  - ウインドハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlValuesA(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, AsdvEnumChildA, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AsdvEnumChildA(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOA	p;

	if (p = (PCTRLPROPINFOA)GetPropA(hwnd, CTRLPROPA)) {
		if (p->hd.var.vp != NULL) {
			switch (p->hd.type) {
				case ITYP_UInt:	AjcSetOptCtrlUInt(hwnd, *p->hd.var.p_UI	   , p->hd.opt); break;
				case ITYP_SInt:	AjcSetOptCtrlSInt(hwnd, *p->hd.var.p_SI	   , p->hd.opt); break;
				case ITYP_Hex:	AjcSetOptCtrlHex (hwnd, *p->hd.var.p_UI	   , p->hd.opt); break;
				case ITYP_Real:	AjcSetOptCtrlReal(hwnd, *p->hd.var.p_double, p->hd.opt); break;
				case ITYP_UI8 :	AjcSetOptCtrlUI8 (hwnd, *p->hd.var.p_UB	   , p->hd.opt); break;
				case ITYP_SI8 :	AjcSetOptCtrlSI8 (hwnd, *p->hd.var.p_SB	   , p->hd.opt); break;
				case ITYP_H8  :	AjcSetOptCtrlH8	 (hwnd, *p->hd.var.p_UB	   , p->hd.opt); break;
				case ITYP_UI16:	AjcSetOptCtrlUI16(hwnd, *p->hd.var.p_UW	   , p->hd.opt); break;
				case ITYP_SI16:	AjcSetOptCtrlSI16(hwnd, *p->hd.var.p_SW	   , p->hd.opt); break;
				case ITYP_H16 :	AjcSetOptCtrlH16 (hwnd, *p->hd.var.p_UW	   , p->hd.opt); break;
				case ITYP_UI64:	AjcSetOptCtrlUI64(hwnd, *p->hd.var.p_ULL   , p->hd.opt); break;
				case ITYP_SI64:	AjcSetOptCtrlSI64(hwnd, *p->hd.var.p_SLL   , p->hd.opt); break;
				case ITYP_H64:	AjcSetOptCtrlH64 (hwnd, *p->hd.var.p_ULL   , p->hd.opt); break;
				case ITYP_CHK:	AjcSetCtrlChk	 (hwnd, *p->hd.var.p_UI				  ); break;
				case ITYP_STR:	AjcSetCtrlStrA	 (hwnd,	 p->hd.var.vp				  ); break;
				case ITYP_CBO:	SendMessageA(hwnd, CB_SETCURSEL, *p->hd.var.p_SI, 0);	 break;
			}
		}
	}
	return TRUE;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlValuesW(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, AsdvEnumChildW, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK AsdvEnumChildW(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOW	p;

	if (p = (PCTRLPROPINFOW)GetPropW(hwnd, CTRLPROPW)) {
		if (p->hd.var.vp != NULL) {
			switch (p->hd.type) {
				case ITYP_UInt:	AjcSetOptCtrlUInt(hwnd, *p->hd.var.p_UI	   , p->hd.opt); break;
				case ITYP_SInt:	AjcSetOptCtrlSInt(hwnd, *p->hd.var.p_SI	   , p->hd.opt); break;
				case ITYP_Hex:	AjcSetOptCtrlHex (hwnd, *p->hd.var.p_UI	   , p->hd.opt); break;
				case ITYP_Real:	AjcSetOptCtrlReal(hwnd, *p->hd.var.p_double, p->hd.opt); break;
				case ITYP_UI8 :	AjcSetOptCtrlUI8 (hwnd, *p->hd.var.p_UB	   , p->hd.opt); break;
				case ITYP_SI8 :	AjcSetOptCtrlSI8 (hwnd, *p->hd.var.p_SB	   , p->hd.opt); break;
				case ITYP_H8  :	AjcSetOptCtrlH8	 (hwnd, *p->hd.var.p_UB	   , p->hd.opt); break;
				case ITYP_UI16:	AjcSetOptCtrlUI16(hwnd, *p->hd.var.p_UW	   , p->hd.opt); break;
				case ITYP_SI16:	AjcSetOptCtrlSI16(hwnd, *p->hd.var.p_SW	   , p->hd.opt); break;
				case ITYP_H16 :	AjcSetOptCtrlH16 (hwnd, *p->hd.var.p_UW	   , p->hd.opt); break;
				case ITYP_UI64:	AjcSetOptCtrlUI64(hwnd, *p->hd.var.p_ULL   , p->hd.opt); break;
				case ITYP_SI64:	AjcSetOptCtrlSI64(hwnd, *p->hd.var.p_SLL   , p->hd.opt); break;
				case ITYP_H64:	AjcSetOptCtrlH64 (hwnd, *p->hd.var.p_ULL   , p->hd.opt); break;
				case ITYP_CHK:	AjcSetCtrlChk	 (hwnd, *p->hd.var.p_UI				  ); break;
				case ITYP_STR:	AjcSetCtrlStrW	 (hwnd,	 p->hd.var.vp				  ); break;
				case ITYP_CBO:	SendMessageW(hwnd, CB_SETCURSEL, *p->hd.var.p_SI, 0);	 break;
			}
		}
	}
	return TRUE;
}

//==============================================================================================================//
//	コントロール群エクスチェンジ（設定解除）																	//
//																												//
//	引　数：	hwnd	  - ウインドハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcReleaseCtrlPropsA(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, ArdpEnumChildA, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK ArdpEnumChildA(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOA	p;

	if (p = (PCTRLPROPINFOA)GetPropA(hwnd, CTRLPROPA)) {
		RemovePropA(hwnd, CTRLPROPA);
		free(p);
	}
	return TRUE;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcReleaseCtrlPropsW(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = EnumChildWindows(hwnd, ArdpEnumChildW, 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK ArdpEnumChildW(HWND hwnd, LPARAM lParam)
{
	PCTRLPROPINFOW	p;

	if (p = (PCTRLPROPINFOW)GetPropW(hwnd, CTRLPROPW)) {
		RemovePropW(hwnd, CTRLPROPW);
		free(p);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスの内容をプロファイルから読み出す																//
//																												//
//	引　数：	hwnd	  - コンボボックスのコントロールハンドル												//
//				pSect	  - プロファイルセクション名															//
//				pPrefix	  - プロファイルキーの先頭部分															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static BOOL	SubLoadCtrlComboBoxA(HWND hwnd, C_BCP pSect, C_BCP pPrefix)
{
	BOOL	rc		 = FALSE;
	WCP		pSectW	 = NULL;
	WCP		pPrefixW = NULL;

	do {
		BCF_ALLOC(pSect);
		BCF_ALLOC(pPrefix);
		rc = SubLoadCtrlComboBoxW(hwnd, pSectW, pPrefixW);
	} while(0);

	if (pSectW	 != NULL) AjcTFree(pSectW);
	if (pPrefixW != NULL) AjcTFree(pPrefixW);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static BOOL	SubLoadCtrlComboBoxW(HWND hwnd, C_WCP pSect, C_WCP pPrefix)
{
	BOOL	rc = FALSE;
	int		i = 0;
	UI		lLB  = 0;
	WCP		pLB  = NULL;
	UI		lKey = 0;
	WCP		pKey = NULL;
	SX		dat;

	if (IsWindow(hwnd) && pSect != NULL && pPrefix != NULL) {
		lKey = (UI)wcslen(pPrefix) + 256;
		do {
			if ((pKey = AjcTAlloc(lKey))				   == NULL) break;		//	キーバッファ確保
			AjcSnPrintF(pKey, lKey, L"Cbo%s_LMax", pPrefix);
			if ((lLB = AjcGetProfileUInt(pSect, pKey, -1)) == -1  )	break;		//	バッファ長読み出し
			if ((pLB  = AjcTAlloc(lLB))					   == NULL) break;		//	文字列バッファ確保
			//	コンボボックスリセット
			SendMessageW(hwnd, CB_RESETCONTENT, 0, 0);
			//	先頭の文字列データ読み出し
			AjcSnPrintF(pKey, lKey, L"Cbo%s_S_%09d",  pPrefix, i);
			AjcGetProfileStr(pSect, pKey, L"@@NONE@@", pLB, lLB);
			while (wcscmp(pLB, L"@@NONE@@") != 0) {
				//	文字列設定
				SendMessageW(hwnd, CB_INSERTSTRING, -1, (LPARAM)pLB);
				//	データ設定
				AjcSnPrintF(pKey, lKey, L"Cbo%s_D_%09d",  pPrefix, i);
				AjcGetProfileStr(pSect, pKey, L"@@NODATA@@", pLB, lLB);
				if (wcscmp(pLB, L"@@NODATA@@") != 0) {
					dat = (SX)AjcAscToLInt(pLB);
					SendMessageW(hwnd, CB_SETITEMDATA, i, (LPARAM)dat);
				}
				//	次の文字列データ読み出し
				i++;
				AjcSnPrintF(pKey, lKey, L"Cbo%s_S_%09d",  pPrefix, i);
				AjcGetProfileStr(pSect, pKey, L"@@NONE@@", pLB, lLB);
			}
			//	選択項目インデクス読み出し
			AjcSnPrintF(pKey, lKey, L"Cbo%s_Sel", pPrefix);
			SendMessageW(hwnd, CB_SETCURSEL, (SI)AjcGetProfileSInt(pSect, pKey, -1), 0);
			//	戻り値＝正常
			rc = TRUE;
		} while(0);
		//	バッファ解放
		if (pKey != NULL) free(pKey);
		if (pLB  != NULL) free(pLB);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスの内容をプロファイルへ書き込む																//
//																												//
//	引　数：	hwnd	  - コンボボックスのコントロールハンドル												//
//				pSect	  - プロファイルセクション名															//
//				pPrefix	  - プロファイルキーの先頭部分															//
//				fWithData - TRUE:データ値もセーブする，FALSE:データ値はセーブしない								//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static BOOL	SubSaveCtrlComboBoxA(HWND hwnd, C_BCP pSect, C_BCP pPrefix, BOOL fWithData)
{
	BOOL	rc		 = FALSE;
	WCP		pSectW	 = NULL;
	WCP		pPrefixW = NULL;

	do {
		BCF_ALLOC(pSect);
		BCF_ALLOC(pPrefix);
		rc = SubSaveCtrlComboBoxW(hwnd, pSectW, pPrefixW, fWithData);
	} while(0);
	if (pSectW   != NULL) AjcTFree(pSectW);
	if (pPrefixW != NULL) AjcTFree(pPrefixW);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static BOOL	SubSaveCtrlComboBoxW(HWND hwnd, C_WCP pSect, C_WCP pPrefix, BOOL fWithData)
{
	BOOL	rc = FALSE;
	int		n, i, lmax;
	UI		lLB  = 0;
	WCP		pLB  = NULL;
	UI		lKey = 0;
	WCP		pKey = NULL;
	SX		dat;

	if (IsWindow(hwnd) && pSect != NULL && pPrefix != NULL) {
		do {
			if ((n = (int)SendMessage(hwnd, CB_GETCOUNT, 0, 0)) < 0 ) break;		//	項目数取得
			if ((lmax = AjcGetCtrlCboMaxLen(hwnd))		== -1		) break;		//	最大文字列長取得
			lLB  = (UI)lmax + 1;
			lLB  = __max(lLB, 32);
			lKey = (UI)wcslen(pPrefix) + 256;
			if ((pKey = AjcTAlloc(lKey))				== NULL 	) break;		//	キーバッファ確保
			if ((pLB  = AjcTAlloc(lLB))					== NULL 	) break;		//	文字列バッファ確保
			//	最大バッファ長書き込み
			AjcSnPrintF(pKey, lKey, L"Cbo%s_LMax", pPrefix);
			AjcPutProfileUInt(pSect, pKey, lLB);
			//	選択項目インデクス書き込み
			AjcSnPrintF(pKey, lKey, L"Cbo%s_Sel", pPrefix);
			AjcPutProfileSInt(pSect, pKey, (SI)SendMessageA(hwnd, CB_GETCURSEL, 0, 0));
			//	項目データセーブ
			for (i = 0; i < n; i++) {
				//	文字列，データセーブ
				if (SendMessage(hwnd, CB_GETLBTEXT, i, (LPARAM)pLB) >= 0) {
					AjcSnPrintF(pKey, lKey, L"Cbo%s_S_%09d", pPrefix, i);
					AjcPutProfileStr(pSect, pKey, pLB);
					if (fWithData) {
						dat = (SX)SendMessage(hwnd, CB_GETITEMDATA, i, 0);
						AjcSnPrintF(pKey, lKey, L"Cbo%s_D_%09d", pPrefix, i);
						AjcSnPrintF(pLB, lLB, L"%I64d", (SLL)dat);
						AjcPutProfileStr(pSect, pKey, pLB);
					}
				}
			}
			//	後続データ消去
			AjcSnPrintF(pKey, lKey, L"Cbo%s_S_%09d", pPrefix, i);
			AjcGetProfileStr(pSect, pKey, L"$$AJCCBO_NONE$$", pLB, lLB);
			while (wcscmp(pLB, L"$$AJCCBO_NONE$$") != 0) {
				AjcDelProfileKey(pSect, pKey);
				AjcSnPrintF(pKey, lKey, L"Cbo%s_D_%09d", pPrefix, i);
				AjcDelProfileKey(pSect, pKey);
				i++;
				AjcSnPrintF(pKey, lKey, L"Cbo%s_S_%09d", pPrefix, i);
				AjcGetProfileStr(pSect, pKey, L"$$AJCCBO_NONE$$", pLB, lLB);
			}
			//	戻り値＝正常
			rc = TRUE;
		} while(0);
		//	バッファ解放
		if (pKey != NULL) free(pKey);
		if (pLB  != NULL) free(pLB);
	}
	return rc;
}
