﻿#include	"AjcInternal.h"
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールの永続化																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

#define	PATT_PROP_NAME	L"_AJC_CONTROL_PERMATT"

#define	NO_TXT_STR		L"?AjcNoText?"

//--------------------------------------------------------------------------------------------------------------//
//	ウインドとデータの関連付け情報																				//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI		dat;					//	関連付けるデータ
	WC		str[256];				//	関連付ける文字列
} WNDDATA, *PWNDDATA;

MAJCAVLPTR(WDNODE, PWNDDATA);

//	ウインドデータ関連付け用ＡＶＬ
static		HAJCAVL		hAvlWndData = NULL;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetWndData(HWND hwnd, HWND hGrp, UI data, C_WCP pSect);
static	C_WCP	GetWndData(HWND hwnd, HWND hGrp, UIP pDat);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcWndItemPermInit(VO)
{
	BOOL	rc = FALSE;

	//	ウインドデータ関連付け用ＡＶＬ生成
	if (hAvlWndData = AjcAvlCreate (0, NULL, NULL)) {
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcWndItemPermEnd (VO)
{
	//	ウインドデータ関連付け用ＡＶＬ破棄
	if (hAvlWndData != NULL) {
		AjcAvlDelete(hAvlWndData);
		hAvlWndData = NULL;
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールの永続化																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	コントロールの永続化設定／解除																				//
//																												//
//	引　数：	hwnd	  - コントロールのウインドハンドル														//
//				att		  - 永続化属性（０：属性解除）															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSetPermAtt	(HWND hctrl,	   UI att)
{
	BOOL	rc = FALSE;

	if (IsWindow(hctrl)) {
		if (att & AJCCTL_PSEL_DELETE) {
			rc = (RemoveProp(hctrl, PATT_PROP_NAME) != NULL);
		}
		else {
			rc = SetProp(hctrl, PATT_PROP_NAME, (HANDLE)((UX)att));
		}
	}
	return rc;
}
//==============================================================================================================//
//	グループボックス内全コントロールの永続化設定／解除															//
//																												//
//	引　数：	hwnd	  - コントロールのウインドハンドル														//
//				att		  - 永続化属性（０：属性解除）															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
typedef struct {
	HWND	hw;
	RECT	r;
	UI		att;
	BOOL	rc;
} CSPAPARAM, *PCSPAPARAM;

//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbCspaEnum(HWND hwnd, LPARAM lParam)
{
	PCSPAPARAM	p = (PCSPAPARAM)lParam;
	RECT		rct;

	GetWindowRect(hwnd, &rct);
	if (hwnd != p->hw && rct.left >= p->r.left && rct.top >= p->r.top && rct.right <= p->r.right && rct.bottom <= p->r.bottom) {
		if (!AjcCtrlSetPermAtt(hwnd, p->att)) {
			p->rc = FALSE;
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSetPermAttGrp(HWND hwnd, UI att)
{
	BOOL		rc = FALSE;
	CSPAPARAM	prm;
	HWND		hParent;

	if (IsWindow(hwnd)	&&	(hParent = GetParent(hwnd)) != NULL) {
		prm.hw = hwnd;
		GetWindowRect(hwnd, &prm.r);
		prm.att = att;
		prm.rc	= TRUE;
		EnumChildWindows(hParent, cbCspaEnum, (LPARAM)&prm);
		rc = prm.rc;
	}
	return rc;
}

//==============================================================================================================//
//	全コントロールの永続化解除																					//
//																												//
//	引　数：	hwnd	  - コントロールの親ウインドハンドル													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcDelAllCtrlPermAtt(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		hwnd = GetWindow(hwnd, GW_CHILD);
		while (hwnd) {
			if (GetProp(hwnd, PATT_PROP_NAME) != NULL) {
				RemoveProp(hwnd, PATT_PROP_NAME);
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ウインド内全コントロールの永続化情報読み出し																//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				act		- コントロールの選択動作指定															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcLoadAllControlSettingsA(HWND hwnd, C_BCP pSect, UI act)
{
	return AjcLoadGrpControlSettingsA(hwnd, NULL, pSect, act);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcLoadAllControlSettingsW(HWND hwnd, C_WCP pSect, UI act)
{
	return AjcLoadGrpControlSettingsW(hwnd, NULL, pSect, act);
}
//==============================================================================================================//
//	グループボックス内全コントロールの永続化情報読み出し														//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//				hGrp	- グループボックスのウインドハンドル													//
//				pSect	- プロファイルセクション名のアドレス													//
//				act		- コントロールの選択動作指定															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcLoadGrpControlSettingsA(HWND hwnd, HWND hGrp, C_BCP pSect, UI act)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	do {
		if (pSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
			if (len != 0 && (pTmp = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			}
			else break;
			rc = AjcLoadGrpControlSettingsW(hwnd, hGrp, pTmp, act);
		}
	} while(0);

	if (pTmp != NULL) AjcTFree(pTmp);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcLoadGrpControlSettingsW(HWND hwnd, HWND hGrp, C_WCP pSect, UI act)
{
	BOOL	rc = TRUE;
	BOOL	rsu;
	UI		att = 0;
	HWND	hParent = hwnd;
	WC		cls[MAX_PATH];
	WC		key[256];
	RECT	r, rG;

	if (IsWindow(hwnd) && pSect != NULL && SetWndData(hwnd, hGrp, act, pSect)) {
		//----- グループボックスの矩形設定 ---------------------------------------------------------------------//
		if (IsWindow(hGrp)) {
			GetWindowRect(hGrp, &rG);
		}
		else hGrp = NULL;
		//----- ウインド内の全子ウインドループ（AjrCtlXXXXX（数値入力，VT100，タイムチャート）読み出し）--------//
		hwnd = GetWindow(hParent, GW_CHILD);
		while (hwnd) {
			//	ウインドの矩形取得し、グループ内かチェック
			if (hGrp) {
				GetWindowRect(hwnd, &r);
			}
			if (hGrp == NULL || (r.left >= rG.left && r.top >= rG.top && r.right <= rG.right && r.bottom <= rG.bottom)) {
				//	ウインドの永続化属性取得
				att = (UI)((UX)GetProp(hwnd, PATT_PROP_NAME));
				do {
					//	永続化項目から除外するコントロール以外を永続化する and 「除外コントロール」がマークされていればスキップ
					if ((act & AJCCTL_SELACT_CHKEXCLUDE) && (att & AJCCTL_PSEL_EXCLUDE)) break;
					//	永続化項目に含めるコントロールのみを対象とする and 「永続化項目に含める」がマークされていなければスキップ
					if ((act & AJCCTL_SELACT_CHKINCLUDE) && !(att & AJCCTL_PSEL_INCLUDE)) break;
					//	クラス名設定
					wcscpy(cls, L"?CUnKnown?");
					GetClassName(hwnd, cls, AJCTSIZE(cls));
					//	AjcCtrlListBox
					if		(wcsicmp(cls, L"AjcCtrlListBox"	) == 0) {
						AjcSnPrintF(key, AJCTSIZE(key), L"Lbx_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
						if (!(rsu = AjcLbxLoadPermInfo(hwnd, pSect, key))) {
							rc = FALSE;
						}
					}
					//	AjcCtrlInpValue
					else if (wcsicmp(cls, L"AjcCtrlInpVal"	) == 0) {
						AjcSnPrintF(key, AJCTSIZE(key), L"Inp_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
						if (!(rsu = AjcIvLoadPermInfo(hwnd, pSect, key, (att & AJCCTL_PSEL_NONTC) == 0 && 
																		((act & AJCCTL_SELACT_NTCINP) || (att & AJCCTL_PSEL_NTC))))) {
							rc = FALSE;
						}
					}
					//	AjcCtrlVT100
					else if (wcsicmp(cls, L"AjcCtrlVT100"	) == 0) {
						AjcSnPrintF(key, AJCTSIZE(key), L"Vth_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
						if (!(rsu = AjcVthLoadPermInfoEx(hwnd, pSect, key, AJCVTH_PERM_FONT))) {
							rc = FALSE;
						}
					}
					//	AjcCtrlTimeChart
					else if (wcsicmp(cls, L"AjcCtrlTmChart"	) == 0) {
						AjcSnPrintF(key, AJCTSIZE(key), L"Tch_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
						if (!(rsu = AjcTchLoadPermInfoEx(hwnd, pSect, key, AJCTCH_PERM_FILTER))) {
							rc = FALSE;
						}
					}
				} while(0);
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}

		//----- ウインド内の全子ウインドループ（コンボボックス(ComboBox)，リストボックス(ListBox) 読み出し）----//
		hwnd = GetWindow(hParent, GW_CHILD);
		while (hwnd) {
			//	ウインドの矩形取得し、グループ内かチェック
			if (hGrp) {
				GetWindowRect(hwnd, &r);
			}
			if (hGrp == NULL || (r.left >= rG.left && r.top >= rG.top && r.right <= rG.right && r.bottom <= rG.bottom)) {
				//	ウインドの永続化属性取得
				att = (UI)((UX)GetProp(hwnd, PATT_PROP_NAME));
				do {
					//	永続化項目から除外するコントロール以外を永続化する and 「除外コントロール」がマークされていればスキップ
					if ((act & AJCCTL_SELACT_CHKEXCLUDE) && (att & AJCCTL_PSEL_EXCLUDE)) break;
					//	永続化項目に含めるコントロールのみを対象とする	   and 「永続化項目に含める」がマークされていなければスキップ
					if ((act & AJCCTL_SELACT_CHKINCLUDE) && !(att & AJCCTL_PSEL_INCLUDE)) break;
					//	クラス名設定
					wcscpy(cls, L"?CUnKnown?");
					GetClassName(hwnd, cls, AJCTSIZE(cls));
					//	コンボボックス
					if		(wcsicmp(cls, L"ComboBox") == 0) {
						UI	sel;
						sel = (att & AJCCTL_PSEL_MASK);
						if (rsu = AjcCtrlLoadComboBox(hwnd, pSect, sel, (att & AJCCTL_PSEL_NONTC) == 0 &&
																		((act & AJCCTL_SELACT_NTCCBO) || (att & AJCCTL_PSEL_NTC)))) {
							//	NOP
						}
						else rc = FALSE;
					}
					//	リストボックス
					else if (wcsicmp(cls, L"ListBox") == 0) {
						UI	sel = att & AJCCTL_PSEL_MASK;
						if (rsu = AjcCtrlLoadListBox(hwnd, pSect, sel)) {
							//	NOP
						}
						else rc = FALSE;
					}
				} while(0);
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}
		//----- ウインド内の全子ウインドループ（テキストボックス，チェックボックス，ラジオボタン 読み出し）-----//
		hwnd = GetWindow(hParent, GW_CHILD);
		while (hwnd) {
			//	ウインドの矩形取得し、グループ内かチェック
			if (hGrp) {
				GetWindowRect(hwnd, &r);
			}
			if (hGrp == NULL || (r.left >= rG.left && r.top >= rG.top && r.right <= rG.right && r.bottom <= rG.bottom)) {
				att = (UI)((UX)GetProp(hwnd, PATT_PROP_NAME));
				do {
					//	永続化項目から除外するコントロール以外を永続化する and 「除外コントロール」がマークされていればスキップ
					if ((act & AJCCTL_SELACT_CHKEXCLUDE) && (att & AJCCTL_PSEL_EXCLUDE)) break;
					//	永続化項目に含めるコントロールのみを対象とする	   and 「永続化項目に含める」がマークされていなければスキップ
					if ((act & AJCCTL_SELACT_CHKINCLUDE) && !(att & AJCCTL_PSEL_INCLUDE)) break;
					//	クラス名設定
					wcscpy(cls, L"?CUnKnown?");
					GetClassName(hwnd, cls, AJCTSIZE(cls));
					//	エディットコントロール
					if		(wcsicmp(cls, L"Edit"			) == 0) {
						//	テキストデータロード
						if (att & AJCCTL_PSEL_INCRDONLY) rsu = AjcCtrlLoadTextBoxEx(hwnd, pSect, FALSE);
						else							 rsu = AjcCtrlLoadTextBoxEx(hwnd, pSect, TRUE );
						//	エラーならば戻り値設定
						if (!rsu) rc = FALSE;
					}
					//	ボタンコントロール
					else if (wcsicmp(cls, L"Button"			) == 0) {
						UI	sty, typ;
						sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
						typ = (sty & BS_TYPEMASK);
						//	ラジオボタンのチェック状態ロード
						if		((typ == BS_RADIOBUTTON || typ == BS_AUTORADIOBUTTON)) {
							rc = AjcCtrlLoadChkBox(hwnd, pSect, (att & AJCCTL_PSEL_NONTC) == 0 && 
																((act & AJCCTL_SELACT_NTCRBT) || (att & AJCCTL_PSEL_NTC)));
						}
						//	チェックボックスのチェック状態ロード
						else if (typ == BS_CHECKBOX || typ == BS_AUTOCHECKBOX || typ == BS_3STATE || typ == BS_AUTO3STATE) {
							rc = AjcCtrlLoadChkBox(hwnd, pSect, (att & AJCCTL_PSEL_NONTC) == 0 && 
																((act & AJCCTL_SELACT_NTCCHK) || (att & AJCCTL_PSEL_NTC)));
						}
					}
				} while(0);
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	ウインド内全コントロールの永続化情報書き込み																//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcSaveAllControlSettings(HWND hwnd)
{
	return AjcSaveGrpControlSettings(hwnd, NULL);
}
//==============================================================================================================//
//	ウインド内全コントロールの永続化情報書き込み（拡張）														//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcSaveAllControlSettingsExA(HWND hwnd, C_BCP pSect, UI act)
{
	return AjcSaveGrpControlSettingsExA(hwnd, NULL, pSect, act);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcSaveAllControlSettingsExW(HWND hwnd, C_WCP pSect, UI act)
{
	return AjcSaveGrpControlSettingsExW(hwnd, NULL, pSect, act);
}
//==============================================================================================================//
//	グループボックス内全コントロールの永続化情報書き込み														//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//				hGrp	- グループボックスのウインドハンドル													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcSaveGrpControlSettings(HWND hwnd, HWND hGrp)
{
	return AjcSaveGrpControlSettingsExW(hwnd, hGrp, NULL, AJCCTL_SELACT_BYLOAD);
}
//==============================================================================================================//
//	グループボックス内全コントロールの永続化情報書き込み（拡張）												//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//				hGrp	- グループボックスのウインドハンドル													//
//				pSect	- プロファイルセクション名のアドレス													//
//				act		- コントロールの選択動作指定															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcSaveGrpControlSettingsExA(HWND hwnd, HWND hGrp, C_BCP pSect, UI act)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	do {
		if (pSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
			if (len != 0 && (pTmp = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			}
			else break;
			rc = AjcSaveGrpControlSettingsExW(hwnd, hGrp, pTmp, act);
		}
	} while(0);

	if (pTmp != NULL) AjcTFree(pTmp);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcSaveGrpControlSettingsExW(HWND hwnd, HWND hGrp, C_WCP pSect, UI act)
{
	BOOL	rc = TRUE;
	BOOL	rsu;
	UI		att = 0;
	HWND	hParent = hwnd;
	WC		cls[MAX_PATH];
	WC		key[256];
	RECT	r, rG;

	if (IsWindow(hwnd)) {
		//----- セクション名＆アクションパラメタ設定 -----------------------------------------------------------//
		C_WCP	s;
		UI		a;
		s = GetWndData(hwnd, hGrp, &a);
		if (pSect == NULL			  ) pSect = s;
		if (act & AJCCTL_SELACT_BYLOAD) act   = a;
		//----- 永続化情報書き込み -----------------------------------------------------------------------------//
		if (pSect != NULL) {
			//----- グループボックスの矩形設定 ---------------------------------------------------------------------//
			if (IsWindow(hGrp)) {
				GetWindowRect(hGrp, &rG);
			}
			else hGrp = NULL;
			//----- ウインド内の全子ウインドループ -----------------------------------------------------------------//
			hwnd = GetWindow(hwnd, GW_CHILD);
			while (hwnd) {
				//	ウインドの矩形取得し、グループ内かチェック
				if (hGrp) {
					GetWindowRect(hwnd, &r);
				}
				if (hGrp == NULL || (r.left >= rG.left && r.top >= rG.top && r.right <= rG.right && r.bottom <= rG.bottom)) {
					//	ウインドの永続化属性取得
					att = (UI)((UX)GetProp(hwnd, PATT_PROP_NAME));
					do {
						//	永続化項目から除外するコントロール以外を永続化する and 「除外コントロール」がマークされていればスキップ
						if ((act & AJCCTL_SELACT_CHKEXCLUDE) && (att & AJCCTL_PSEL_EXCLUDE)) break;
						//	永続化項目に含めるコントロールのみを対象とする	   and 「永続化項目に含める」がマークされていなければスキップ
						if ((act & AJCCTL_SELACT_CHKINCLUDE) && !(att & AJCCTL_PSEL_INCLUDE)) break;
						//	クラス名設定
						wcscpy(cls, L"?CUnKnown?");
						GetClassName(hwnd, cls, AJCTSIZE(cls));
						//	エディットコントロール
						if		(wcsicmp(cls, L"Edit"			) == 0) {
							if (att & AJCCTL_PSEL_INCRDONLY) rsu = AjcCtrlSaveTextBoxEx(hwnd, pSect, FALSE);
							else							 rsu = AjcCtrlSaveTextBoxEx(hwnd, pSect, TRUE );
							if (!rsu) rc = FALSE;
						}
						//	ボタンコントロール
						else if (wcsicmp(cls, L"Button"			) == 0) {
							if (!(rsu = AjcCtrlSaveChkBox(hwnd, pSect))) {
								rc = FALSE;
							}
						}
						//	コンボボックス
						else if (wcsicmp(cls, L"ComboBox"		) == 0) {
							UI	sel;
							sel = (att & AJCCTL_PSEL_MASK);	
							if (!(rsu = AjcCtrlSaveComboBox(hwnd, pSect, sel))) {
								rc = FALSE;
							}
						}
						//	リストボックス
						else if (wcsicmp(cls, L"ListBox"			) == 0) {
							if (!(rsu = AjcCtrlSaveListBox(hwnd, pSect, att))) {
								rc = FALSE;
							}
						}
						//	AjcCtrlListBox
						else if (wcsicmp(cls, L"AjcCtrlListBox"	) == 0) {
							AjcSnPrintF(key, AJCTSIZE(key), L"Lbx_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
							if (!(rsu = AjcLbxSavePermInfoEx(hwnd, pSect, key))) {
								rc = FALSE;
							}
						}
						//	AjcCtrlInpValue
						else if (wcsicmp(cls, L"AjcCtrlInpVal"	) == 0) {
							AjcSnPrintF(key, AJCTSIZE(key), L"Inp_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
							if (!(rsu = AjcIvSavePermInfoEx(hwnd, pSect, key))) {
								rc = FALSE;
							}
						}
						//	AjcCtrlVT100
						else if (wcsicmp(cls, L"AjcCtrlVT100"	) == 0) {
							AjcSnPrintF(key, AJCTSIZE(key), L"Vth_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
							if (!(rsu = AjcVthSavePermInfoEx(hwnd, pSect, key, AJCVTH_PERM_FONT))) {
								rc = FALSE;
							}
						}
						//	AjcCtrlTimeChart
						else if (wcsicmp(cls, L"AjcCtrlTmChart"	) == 0) {
							AjcSnPrintF(key, AJCTSIZE(key), L"Tch_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
							if (!(rsu = AjcTchSavePermInfoEx(hwnd, pSect, key, AJCTCH_PERM_FILTER))) {
								rc = FALSE;
							}
						}
					} while(0);
				}
				hwnd = GetWindow(hwnd, GW_HWNDNEXT);
			}
		}
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	テキストボックスロード																						//
//																												//
//	引　数：	hwnd		- リストボックスのウインドハンドル													//
//				pSect		- プロファイルセクション名のアドレス												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxA(HWND hwnd, C_BCP pSect)
{
	BOOL	rc = FALSE;
	AjcCtrlLoadTextBoxExA(hwnd, pSect, TRUE);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxW(HWND hwnd, C_WCP pSect)
{
	BOOL	rc = FALSE;
	AjcCtrlLoadTextBoxExW(hwnd, pSect, TRUE);
	return rc;
}
//==============================================================================================================//
//	テキストボックスロード（拡張）																				//
//																												//
//	引　数：	hwnd		- リストボックスのウインドハンドル													//
//				pSect		- プロファイルセクション名のアドレス												//
//				fExcRdOnly	- TRUE:読み出し専用を除外															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxExA(HWND hwnd, C_BCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
	if (len != 0 && (pTmp = AjcTAlloc(len))) {
		MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
		rc = AjcCtrlLoadTextBoxExW(hwnd, pTmp, fExcRdOnly);
		free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxExW(HWND hwnd, C_WCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc	 = TRUE;
	UI		sty  = 0;
	WC		cls[256];
	WC		sec[256];
	WC		key[256];
	WC		txt[4096];

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Edit") != 0) {rc = FALSE; break;}
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	読み出し専用除外チェック
			if (fExcRdOnly && (sty & ES_READONLY)) break;
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//	プロファイルキー設定
			AjcSnPrintF(key, AJCTSIZE(key), L"Edt_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
			//	テキスト読み出し＆コントロールへ設定
			AjcGetCtrlStr(hwnd, txt, AJCTSIZE(txt));
			AjcGetProfileStr(sec, key, txt, txt, AJCTSIZE(txt));
			AjcSetCtrlStr(hwnd, txt);
		} while(0);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	テキストボックスセーブ																						//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxA(HWND hwnd, C_BCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveTextBoxExA(hwnd, pSect, TRUE);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxW(HWND hwnd, C_WCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveTextBoxExW(hwnd, pSect, TRUE);
	return rc;
}
//==============================================================================================================//
//	テキストボックスセーブ（拡張）																				//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				fExcRdOnly	- TRUE:読み出し専用を除外															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxExA(HWND hwnd, C_BCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlSaveTextBoxExW(hwnd, pTmp, fExcRdOnly);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxExW(HWND hwnd, C_WCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc	 = TRUE;
	UI		sty  = 0;
	UI		len  = 0;
	WCP		pTxt = NULL;
	WC		cls[256];
	WC		sec[256];
	WC		key[256];

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Edit") != 0) {rc = FALSE; break;}
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//	プロファイルキー設定
			AjcSnPrintF(key, AJCTSIZE(key), L"Edt_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
			//	読み出し専用チェック
			if (fExcRdOnly && (sty & ES_READONLY)) {
				//	キー削除
				AjcDelProfileKey(sec, key);
			}
			else {
				//	テキスト書き込み
				len = AjcGetCtrlStrLen(hwnd);
				if (pTxt = AjcTAlloc(len + 1)) {
					AjcGetCtrlStr(hwnd, pTxt, len + 1);
					pTxt[len] = 0;
					AjcPutProfileStr(sec, key, pTxt);
					free(pTxt);
				}
				else rc = FALSE;
			}
		} while(0);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	チェックボックス／ラジオボタンロード																		//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				fNtc	- イベント通知フラグ																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadChkBoxA(HWND hwnd, C_BCP pSect, BOOL fNtc)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlLoadChkBoxW(hwnd, pTmp, fNtc);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadChkBoxW(HWND hwnd, C_WCP pSect, BOOL fNtc)
{
	BOOL	rc	 = TRUE;
	UI		sty  = 0;
	UI		typ  = 0;
	UI		len  = 0;
	UI		val;
	WCP		pTxt = NULL;
	WC		cls[256];
	WC		sec[256];
	WC		key[256];

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Button") != 0) {rc = FALSE; break;}
			//	スタイル（チェックボックス／ラジオボタンチェック）チェック
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			typ = (sty & BS_TYPEMASK);
			if (typ != BS_CHECKBOX			&&
				typ != BS_AUTOCHECKBOX		&&
				typ != BS_RADIOBUTTON		&&
				typ != BS_3STATE			&&
				typ != BS_AUTO3STATE		&&
				typ != BS_AUTORADIOBUTTON) {
				rc = FALSE;
				break;
			}
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//	プロファイルキー設定
			if (typ == BS_RADIOBUTTON || typ == BS_AUTORADIOBUTTON) {
				AjcSnPrintF(key, AJCTSIZE(key), L"Rbt_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
			}
			else {
				AjcSnPrintF(key, AJCTSIZE(key), L"Chk_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
			}
			//	設定値読み出し＆コントロールへ設定
			val = AjcGetProfileUInt(sec, key, AjcGetCtrlChk(hwnd));
			AjcSetCtrlChk(hwnd, val);
			//	イベント生成
			if (fNtc) {
				HWND	hParent = GetParent(hwnd);
				UI		id		= (UI)MAjcGetWindowLong(hwnd, GWL_ID);
				//	ラジオボタンの通知
				if		((typ == BS_RADIOBUTTON || typ == BS_AUTORADIOBUTTON)) {
					if (val) {
						SendMessage(hParent, WM_COMMAND, MAKELONG(id, BN_CLICKED), (LPARAM)hwnd);
					}
				}
				//	チェックボックスの通知
				else if (typ == BS_CHECKBOX || typ == BS_AUTOCHECKBOX || typ == BS_3STATE || typ == BS_AUTO3STATE) {
					SendMessage(hParent, WM_COMMAND, MAKELONG(id, BN_CLICKED), (LPARAM)hwnd);
				}
				//	ラジオボタン，チェックボックス以外
				else {
					rc = FALSE;
				}
			}
		} while(0);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	チェックボックス／ラジオボタンセーブ																		//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveChkBoxA(HWND hwnd, C_BCP pSect)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlSaveChkBoxW(hwnd, pTmp);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveChkBoxW(HWND hwnd, C_WCP pSect)
{
	BOOL	rc	 = TRUE;
	UI		sty  = 0;
	UI		typ  = 0;
	UI		len  = 0;
	WCP		pTxt = NULL;
	WC		cls[256];
	WC		sec[256];
	WC		key[256];

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Button") != 0) {rc = FALSE; break;}
			//	スタイル（チェックボックス／ラジオボタンチェック）チェック
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			typ = (sty & BS_TYPEMASK);
			if (typ != BS_CHECKBOX			&&
				typ != BS_AUTOCHECKBOX		&&
				typ != BS_RADIOBUTTON		&&
				typ != BS_3STATE			&&
				typ != BS_AUTO3STATE		&&
				typ != BS_AUTORADIOBUTTON) {
				rc = FALSE;
				break;
			}
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//	プロファイルキー設定
			if (typ == BS_RADIOBUTTON || typ == BS_AUTORADIOBUTTON) {
				AjcSnPrintF(key, AJCTSIZE(key), L"Rbt_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
			}
			else {
				AjcSnPrintF(key, AJCTSIZE(key), L"Chk_%06u", (UI)MAjcGetWindowLong(hwnd, GWL_ID));
			}
			//	設定値書き込み
			AjcPutProfileUInt(sec, key, AjcGetCtrlChk(hwnd));
		} while(0);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	コンボボックスロード																						//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_INC{DATA/TEXT} | EXC{SEL/TEXT/EDIT}）					//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Comboboxコントロール以外																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadComboBoxA(HWND hwnd, C_BCP pSect, UI sel, BOOL fNtc)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlLoadComboBoxW(hwnd, pTmp, sel, fNtc);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadComboBoxW(HWND hwnd, C_WCP pSect, UI sel, BOOL fNtc)
{
	BOOL	rc	  = TRUE;		//	戻り値
	HWND	hEdit = NULL;		//	エディットコントロールハンドル
	int		nList = 0;			//	リスト項目数
	UI		id	  = 0;			//	自コントロールＩＤ;
	int		ix	  = 0;			//	リストインデクス
	UI		sty   = 0;			//	自コントロールスタイル
	UI		lmd   = 0;			//	リストボックスタイプ（DROPDOWNLIST / DROPDOWN / SIMPLE）
	UI		len   = 0;				//	リスト項目テキスト長;
	WCP		pTxt = NULL;		//	テキストバッファポインタ
	UI		lTxt; 				//	テキストバッファ長
	UI		lNoTxtStr = (UI)wcslen(NO_TXT_STR);
	UI		MaxLen = 0;			//	最大テキスト長（文字列終端は含まない）
	WC		cls[256];			//	クラス名
	WC		sec[256];			//	セクション名
	WC		key[256];			//	キー名

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Combobox") != 0) {rc = FALSE; break;}
			//	自コントロールＩＤ
			id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//----- 最大テキスト長読み出し＆バッファ割り当て -------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_MaxLen", id);
			MaxLen = AjcGetProfileUInt(sec, key, 0);
			lTxt   = __max(MaxLen, lNoTxtStr) + 1;
			if ((pTxt = AjcTAlloc(lTxt)) == NULL) {rc = FALSE; break;}
			//----- リスト読み出し ---------------------------------------//
			lmd = (sty & CBS_DROPDOWNLIST);
			if (((lmd == CBS_DROPDOWN || lmd == CBS_SIMPLE) && !(sel & AJCCTL_PSEL_EXCLIST)) ||		//	ドロップダウン／シンプル and リスト項目群を除外しない or
				((lmd == CBS_DROPDOWNLIST				  ) &&	(sel & AJCCTL_PSEL_INCLIST))) {		//	ドロップダウンリスト	 and リスト項目群を含める	  or
				//	項目数読み出し
				AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Cnt", id);
				nList = AjcGetProfileUInt(sec, key, -1);
				if (nList != -1) {
					//	リストクリアー
					SendMessage(hwnd, CB_RESETCONTENT, 0, 0);
					//	リストテキスト読み出し
					*pTxt = 0;
					for (ix = 0; ix < nList; ix++) {
						//	プロファイルキー設定
						AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_%06u", id, ix);
						//	プロファイルからリストテキスト読み出し
						AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
						if (wcscmp(pTxt, NO_TXT_STR) != 0) {
							UI	ins;
							WCP	pD = NULL;
							WCP	pT = NULL;
							if (pD = AjcStrTokW(pTxt, L"," )) {
								pT = AjcStrTokW(NULL, L"\0");
							}
							if (pD != NULL && pT != NULL) {
								if ((ins = (UI)SendMessage(hwnd, CB_INSERTSTRING, -1, (LPARAM)pT)) != CB_ERR) {
									if (sel & AJCCTL_PSEL_INCDATA) {
										SendMessage(hwnd, CB_SETITEMDATA, ins, (UX)AjcHexToULL(pD));
									}
								}
							}
						}
					}
				}
			}
			//----- 選択状態読み出し -------------------------------------//
			if (!(sel & AJCCTL_PSEL_EXCSEL)) {
				//	プロファイルキー設定
				AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Idx", id);
				//	プロファイルからインデクス値を読み出してコントロールに設定
				SendMessage(hwnd, CB_SETCURSEL, AjcGetProfileSInt(sec, key, -1), 0);
			}
			else {
				//	未選択状態設定
				SendMessage(hwnd, CB_SETCURSEL, -1, 0);
			}
			//----- テキストボックス読み出し -----------------------------//
			//	テキストボックスあり && テキストボックス除外しない？
			if ((hEdit = AjcSbcGetEditCtrlInComboBox(hwnd)) && !(sel & AJCCTL_PSEL_EXCEDIT)) {
				//	プロファイルキー設定
				AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Txt", id);
				//	プロファイルからテキスト読み出し
				AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
				if (wcscmp(pTxt, NO_TXT_STR) != 0) {
					AjcSetCtrlStr(hEdit, pTxt);
				}
			}
			//----- イベント通知 -----------------------------------------//
			if (fNtc) {
				ix = (UI)SendMessage(hwnd, CB_GETCURSEL, 0, 0);
				if (ix >= 0) {
					HWND	hParent = GetParent(hwnd);
					UI		id	= (UI)MAjcGetWindowLong(hwnd, GWL_ID);
					SendMessage(hParent, WM_COMMAND, MAKELONG(id, CBN_SELENDOK), (LPARAM)hwnd);
				}
			}
		} while(0);
	}
	else rc = FALSE;

	//	テキストバッファ解放
	if (pTxt != NULL) free(pTxt);

	return rc;
}
//==============================================================================================================//
//	コンボボックスセーブ																						//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_・・・）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Comboboxコントロール以外																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveComboBoxA(HWND hwnd, C_BCP pSect, UI sel)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlSaveComboBoxW(hwnd, pTmp, sel);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveComboBoxW(HWND hwnd, C_WCP pSect, UI sel)
{
	BOOL	rc	   = TRUE;		//	戻り値
	HWND	hEdit  = NULL;		//	エディットコントロールハンドル
	UI		nList  = 0;			//	リスト項目数
	UI		id	   = 0;			//	自コントロールＩＤ
	UI		ix	   = 0;			//	リストインデクス
	UI		sty    = 0;			//	自コントロールスタイル
	UI		lmd    = 0;			//	リストボックスタイプ（DROPDOWNLIST / DROPDOWN / SIMPLE）
	UI		len    = 0;			//	リスト項目テキスト長
	WCP		pTxt   = NULL;		//	テキストバッファポインタ
	UI		lTxt;				//	テキストバッファ長
	UI		lNoTxtStr = (UI)wcslen(NO_TXT_STR);
	UI		MaxLen = 0;			//	最大テキスト長（文字列終端は含まない）
	UI		OldMax = 0;			//		〃		  （前回の値）
	WC		cls[256];			//	クラス名
	WC		sec[256];			//	セクション名
	WC		key[256];			//	キー名

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Combobox") != 0) {rc = FALSE; break;}
			//	自コントロールＩＤ
			id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//----- 前回の最大テキスト長読み出し -------------------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_MaxLen", id);
			OldMax = AjcGetProfileUInt(sec, key, 0);
			//----- リスト項目数設定 -------------------------------------//
			nList = (UI)SendMessage(hwnd, CB_GETCOUNT, 0, 0);
			if (nList == CB_ERR) {rc = FALSE; break;}
			//----- リスト書き込み ---------------------------------------//
			lmd = (sty & CBS_DROPDOWNLIST);
			if (((lmd == CBS_DROPDOWN || lmd == CBS_SIMPLE) && !(sel & AJCCTL_PSEL_EXCLIST)) ||		//	ドロップダウン／シンプル and リスト項目群を除外しない or
				((lmd == CBS_DROPDOWNLIST				  ) &&	(sel & AJCCTL_PSEL_INCLIST))) {		//	ドロップダウンリスト	 and リスト項目群を含める	  or
				//	リスト書き込み
				for (ix = 0; ix < nList; ix++) {
					//	プロファイルキー設定
					AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_%06u", id, ix);
					//	プロファイルへリストテキスト書き込み
					if ((len = (UI)SendMessage(hwnd, CB_GETLBTEXTLEN, ix, 0)) != CB_ERR) {
						lTxt = len + 19 + 1;			//	19 : DATAとカンマ(,)分加算(データは 0x + 16桁の16進数)
						if (pTxt = AjcTAlloc(lTxt)) {
							UI	stl = 0;
							MaxLen	= __max(MaxLen, len + 19);
							if (sel & AJCCTL_PSEL_INCDATA) AjcSnPrintF(pTxt, lTxt, L"0x%016llX,", (ULL)SendMessage(hwnd, CB_GETITEMDATA, ix, 0));
							else						   AjcSnPrintF(pTxt, lTxt, L"0x%016llX,", (ULL)0);
							stl = (UI)wcslen(pTxt);
							SendMessage(hwnd, CB_GETLBTEXT, ix, (LPARAM)(pTxt + stl));
							AjcPutProfileStr(sec, key, pTxt);
							free(pTxt);
						}
						else rc = FALSE;
					}
				}
				//	リスト項目数書き込み
				AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Cnt", id);
				AjcPutProfileUInt(sec, key, nList);
			}
			else {
				//	リスト項目数キー削除
				AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Cnt", id);
				AjcDelProfileKey(sec, key);
			}
			//----- 後続の残留リスト項目削除 -----------------------------//
			lTxt = __max(OldMax, lNoTxtStr) + 1;
			if (pTxt = AjcTAlloc(lTxt)) {
				//	次のリスト項目読み出し
				AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_%06u", id, ix);
				AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
				while (wcscmp(pTxt, NO_TXT_STR) != 0) {
					//	キー項目削除
					AjcDelProfileKey(sec, key);
					//	次のリスト項目読み出し
					ix++;
					AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_%06u", id, ix);
					AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
				}
				free(pTxt);
			}
			//----- 選択状態書き込み -------------------------------------//
			//	プロファイルキー設定
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Idx", id);
			if (!(sel & AJCCTL_PSEL_EXCSEL)) {
				//	インデクス値を読み出してプロファイルへ書き込み
				AjcPutProfileSInt(sec, key, (SI)SendMessage(hwnd, CB_GETCURSEL, 0, 0));
			}
			else {
				//	キー項目削除
				AjcDelProfileKey(sec, key);
			}
			//----- テキストボックス書き込み -----------------------------//
			//	プロファイルキー設定
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_Txt", id);
			//	テキストボックスあり && テキストボックス除外しない？
			if ((hEdit = AjcSbcGetEditCtrlInComboBox(hwnd)) && !(sel & AJCCTL_PSEL_EXCEDIT)) {
				//	テキスト読み出してプロファイルに書き込み
				len = AjcGetCtrlStrLen(hEdit);
				lTxt = len + 1;
				if (pTxt = AjcTAlloc(lTxt)) {
					MaxLen = __max(MaxLen, len);
					//	エディットテキスト書き込み
					AjcGetCtrlStr(hwnd, pTxt, lTxt);
					AjcPutProfileStr(sec, key, pTxt);
					free(pTxt);
				}
				else rc = FALSE;
			}
			//	テキストボックスなし || テキストボックス除外？
			else {
				//	キー項目削除
				AjcDelProfileKey(sec, key);
			}
			//----- 最大テキスト長書き込み -------------------------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_MaxLen", id);
			AjcPutProfileUInt(sec, key, MaxLen);
			
		} while(0);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	セーブ済みコンボボックスデータがあるかチェック																//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - セーブ済みコンボボックスデータ有り														//
//				FALSE - セーブ済みコンボボックスデータなし														//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlIsComboBoxSavedA(HWND hwnd, C_BCP pSect)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlIsComboBoxSavedW(hwnd, pTmp);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlIsComboBoxSavedW(HWND hwnd, C_WCP pSect)
{
	BOOL	rc	   = FALSE;		//	戻り値
	UI		id	   = 0;			//	自コントロールＩＤ
	WC		cls[256];			//	クラス名
	WC		sec[256];			//	セクション名
	WC		key[256];			//	キー名

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Combobox") != 0) {rc = FALSE; break;}
			//	自コントロールＩＤ
			id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//	最大テキスト長読み出し
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_MaxLen", id);
			if (AjcGetProfileUInt(sec, key, -1) != -1) {
				rc = TRUE;
			}
		} while(0);
	}
	return rc;
}
//==============================================================================================================//
//	リストボックスロード																						//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_・・・）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Listboxコントロール以外																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadListBoxA(HWND hwnd, C_BCP pSect, UI sel)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlLoadListBoxW(hwnd, pTmp, sel);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadListBoxW(HWND hwnd, C_WCP pSect, UI sel)
{
	BOOL	rc	   = TRUE;		//	戻り値
	HWND	hEdit  = NULL;		//	エディットコントロールハンドル
	UI		nList  = 0;			//	リスト項目数
	UI		id	   = 0;			//	自コントロールＩＤ
	UI		ix	   = 0;			//	リストインデクス
	UI		sty    = 0;			//	自コントロールスタイル
	UI		len    = 0;			//	リスト項目テキスト長
	WCP		pTxt   = NULL;		//	テキストバッファポインタ
	UI		lTxt;
	UI		lNoTxtStr = (UI)wcslen(NO_TXT_STR);
	UI		MaxLen = 0;			//	最大テキスト長（文字列終端は含まない）
	WC		cls[256];			//	クラス名
	WC		sec[256];			//	セクション名
	WC		key[256];			//	キー名

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Listbox") != 0) {rc = FALSE; break;}
			//	自コントロールＩＤ
			id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//----- 最大テキスト長読み出し＆バッファ割り当て -------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_MaxLen", id);
			MaxLen = AjcGetProfileUInt(sec, key, 0);
			lTxt   = __max(MaxLen, lNoTxtStr) + 1;
			if ((pTxt = AjcTAlloc(lTxt)) == NULL) {rc = FALSE; break;}
			//----- 項目数読み出し ---------------------------------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_Cnt", id);
			nList = AjcGetProfileUInt(sec, key, -1);
			if (nList == -1) break;
			//----- リストクリアー ---------------------------------------//
			SendMessage(hwnd, LB_RESETCONTENT, 0, 0);
			//----- リストテキスト読み出し -------------------------------//
			*pTxt = 0;
			for (ix = 0; ix < nList; ix++) {
				//	プロファイルキー設定
				AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_%06u", id, ix);
				//	プロファイルからリストテキスト読み出し
				AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
				if (wcscmp(pTxt, NO_TXT_STR) != 0) {
					WCP		pS = NULL;
					WCP		pD = NULL;
					WCP		pT = NULL;
					if (pS = AjcStrTokW(pTxt , L",")) {
						if (pD = AjcStrTokW(NULL, L",")) {
							pT = AjcStrTokW(NULL, L"\0");
						}
					}
					if (pS != NULL && pD != NULL && pT != NULL) {
						UI	ins;
						ins = (UI)SendMessage(hwnd, LB_INSERTSTRING, -1, (LPARAM)pT);
						if (*pS == '1' && !(sel & AJCCTL_PSEL_EXCSEL)) {
							if (sty & LBS_MULTIPLESEL) SendMessage(hwnd, LB_SETSEL	 , TRUE, ins);
							else					   SendMessage(hwnd, LB_SETCURSEL, ins , 0	);
						}
						if (sel & AJCCTL_PSEL_INCDATA) {
							SendMessage(hwnd, LB_SETITEMDATA, ins, (UX)AjcHexToULL(pD));
						}
					}
				}
			}
		} while(0);
	}
	else rc = FALSE;

	//	テキストバッファ解放
	if (pTxt != NULL) free(pTxt);

	return rc;
}
//==============================================================================================================//
//	リストボックスセーブ																						//
//																												//
//	引　数：	hwnd	- リストボックスのウインドハンドル														//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_・・・）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Listboxコントロール以外																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveListBoxA(HWND hwnd, C_BCP pSect, UI sel)
{
	BOOL	rc	 = FALSE;
	UI		len  = 0;
	WCP		pTmp = NULL;

	if (pSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
			rc = AjcCtrlSaveListBoxW(hwnd, pTmp, sel);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveListBoxW(HWND hwnd, C_WCP pSect, UI sel)
{
	BOOL	rc	   = TRUE;		//	戻り値
	HWND	hEdit  = NULL;		//	エディットコントロールハンドル
	UI		nList  = 0;			//	リスト項目数
	UI		id	   = 0;			//	自コントロールＩＤ
	UI		ix	   = 0;			//	リストインデクス
	UI		sty    = 0;			//	自コントロールスタイル
	UI		len    = 0;			//	リスト項目テキスト長
	WCP		pTxt   = NULL;		//	テキストバッファポインタ
	UI		lTxt;				//	テキストバッファ長
	UI		lNoTxtStr = (UI)wcslen(NO_TXT_STR);
	UI		MaxLen = 0;			//	最大テキスト長（文字列終端は含まない）
	UI		OldMax = 0;			//		〃		  （前回の値）
	WC		cls[256];			//	クラス名
	WC		sec[256];			//	セクション名
	WC		key[256];			//	キー名

	if (IsWindow(hwnd) && pSect != NULL) {
		do {
			//	クラス名チェック
			wcscpy(cls, L"?CUnKnown?");
			GetClassName(hwnd, cls, AJCTSIZE(cls));
			if (wcsicmp(cls, L"Listbox") != 0) {rc = FALSE; break;}
			//	Comboboxコントロールならば戻り値=TRUE
			rc = TRUE;
			//	自コントロールＩＤ
			id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	プロファイルセクション設定
			AjcSnPrintFW(sec, AJCTSIZE(sec), L"%s", pSect);
			//----- 前回の最大テキスト長読み出し -------------------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Cbo_%06u_MaxLen", id);
			OldMax = AjcGetProfileUInt(sec, key, 0);
			//----- リスト項目数書き込み ---------------------------------//
			nList = (UI)SendMessage(hwnd, LB_GETCOUNT, 0, 0);
			if (nList == LB_ERR) {rc = FALSE; break;}
			AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_Cnt", id);
			AjcPutProfileUInt(sec, key, nList);
			//----- リスト書き込み ---------------------------------------//
			for (ix = 0; ix < nList; ix++) {
				//	プロファイルキー設定
				AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_%06u", id, ix);
				//	プロファイルへ選択状態とリストテキスト書き込み
				if ((len = (UI)SendMessage(hwnd, LB_GETTEXTLEN, ix, 0)) != LB_ERR) {
					lTxt = len + 21 + 1;			//	21 : DATAと付加テキスト(選択状態(S,)、データ(18)とカンマ(,)分加算(データは 0x+16桁の16進数)
					if (pTxt = AjcTAlloc(lTxt)) {
						UI	stl;
						//	最大テキスト長更新
						MaxLen = __max(MaxLen, (len + 21));
						//	選択状態設定
						if (!(sel & AJCCTL_PSEL_EXCSEL)) {
							if (SendMessage(hwnd, LB_GETSEL, ix, 0) != 0) wcscpy(pTxt, L"1,");
							else										  wcscpy(pTxt, L"0,");
						}
						else wcscpy(pTxt, L"0,");
						//	データ値設定
						if (sel & AJCCTL_PSEL_INCDATA) AjcSnPrintF(pTxt + 2, lTxt - 2, L"0x%016llX,", (ULL)SendMessage(hwnd, LB_GETITEMDATA, ix, 0));
						else						   AjcSnPrintF(pTxt + 2, lTxt - 2, L"0x%016llX,", (ULL)0);
						//	テキスト読み出し
						stl = (UI)wcslen(pTxt);
						SendMessage(hwnd, LB_GETTEXT, ix, (LPARAM)(pTxt + stl));
						//	プロファイル書き込み
						AjcPutProfileStr(sec, key, pTxt);
						free(pTxt);
					}
					else rc = FALSE;
				}
			}
			//----- 後続の残留リスト項目削除 -----------------------------//
			lTxt = __max(OldMax, lNoTxtStr) + 1;
			if (pTxt = AjcTAlloc(lTxt)) {
				//	次のリスト項目読み出し
				AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_%06u", id, ix);
				AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
				while (wcscmp(pTxt, NO_TXT_STR) != 0) {
					//	キー項目削除
					AjcDelProfileKey(sec, key);
					//	次のリスト項目読み出し
					ix++;
					AjcSnPrintF(key, AJCTSIZE(key) , L"Lst_%06u_%06u", id, ix);
					AjcGetProfileStr(sec, key, NO_TXT_STR, pTxt, lTxt);
				}
				free(pTxt);
			}
			//----- 最大テキスト長書き込み -------------------------------//
			AjcSnPrintF(key, AJCTSIZE(key), L"Lst_%06u_MaxLen", id);
			AjcPutProfileUInt(sec, key, MaxLen);
		} while(0);
	}
	else rc = FALSE;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ウインドデータの関連付けデータ設定（整数データとセクション名の関連付け）									//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				hGrp	- グループボックスハンドル																//
//				data	- ウインドに関連付ける整数データ														//
//				pSect	- ウインドに関連付ける文字列データ														//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetWndData(HWND hwnd, HWND hGrp, UI data, C_WCP pSect)
{
	BOOL		rc = FALSE;
	WNDDATA		wd;
	PCWDNODE	pArr = NULL;
	PCWDNODE	p	 = NULL;
	HWND		hTrg;

	//	時々、無効なウインドのノードを破棄
	if ((AjcAvlGetCount(hAvlWndData) & 31) == 31) {
		if (pArr = (PCWDNODE)AjcAvlCreatePtrArr(hAvlWndData, NULL, FALSE)) {
			for (p = pArr; p != NULL; p++) {
				if (!IsWindow((HWND)p->key)) {
					AjcAvlDelNode(hAvlWndData, p->key);
				}
			}
			AjcAvlReleasePtrArr (hAvlWndData, (PCAJCAVLPTR)pArr);
		}
	}
	//	関連付けするウインドハンドル設定
	if (IsWindow(hGrp)) hTrg = hGrp;
	else				hTrg = hwnd;
	//	関連付けデータ設定
	if (IsWindow(hTrg) && pSect != NULL) {
		wd.dat = data;
		AjcSnPrintF(wd.str, AJCTSIZE(wd.str), L"%s", pSect);
		rc = AjcAvlInsOrRepNode(hAvlWndData, (UX)hTrg, (C_VOP)&wd, (sizeof wd.dat) + (UI)wcslen(wd.str) * 2 + 2);
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	ウインドデータの関連付けデータ取得（整数データとセクション名の関連付け）									//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				hGrp	- グループボックスハンドル																//
//				pDat	- ウインドに関連付けた整数データを格納するバッファのアドレス							//
//																												//
//	戻り値：	≠ NULL - OK(ウインドデータに関連付けられた文字列のアドレス)									//
//				＝ NULL - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	C_WCP	GetWndData(HWND hwnd, HWND hGrp, UIP pDat)
{
	C_WCP		pSect = NULL;
	PWNDDATA	pWd = NULL;
	HWND		hTrg;

	//	関連付けするウインドハンドル設定
	if (IsWindow(hGrp)) hTrg = hGrp;
	else				hTrg = hwnd;
	//	関連付けデータ取得
	if (IsWindow(hTrg)) {
		if (pWd = (PWNDDATA)AjcAvlGetNodePtr(hAvlWndData, (UX)hTrg, NULL)) {
			if (pDat != NULL) *pDat = pWd->dat;
			pSect = pWd->str;
		}
	}
	else {
		AjcAvlDelNode(hAvlWndData, (UX)hTrg);
	}
	return pSect;
}
