﻿#ifndef		AJCXYMODEML_H_
#define		AJCXYMODEML_H_
/****************************************************************************************************************/

/*--------------------------------------------------------------------------------------------------------------*/
/*	内部マクロ																									*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		ISXYP_OK(_P_)	(_P_ == AJCXYP_XMODEM_SUM || _P_ == AJCXYP_XMODEM_CRC || _P_ == AJCXYP_XMODEM_1K ||	\
							 _P_ == AJCXYP_YMODEM_STD || _P_ == AJCXYP_YMODEM_G)

#define		IS_XMODEM		(pW->knd & AJCXYP_XMODEM)
#define		IS_YMODEM		(pW->knd & AJCXYP_YMODEM)

/*--------------------------------------------------------------------------------------------------------------*/
/*	状態コード																									*/
/*--------------------------------------------------------------------------------------------------------------*/
enum {
	AJCSTC_STS_IDLE				,		/*	 0：アイドル状態													*/

	AJCSTC_STS_TX_RCVREQ		,		/*	 1：受信要求（NAK / C / G）受信待ち									*/
	AJCSTC_STS_TX_ACKATT		,		/*	 2：属性レコードに対するＡＣＫ受信待ち（ＹＭＯＤＥＭ）				*/
	AJCSTC_STS_TX_RCVDRQ		,		/*	 3：属性ﾚｺｰﾄﾞ送信後の、受信要求（NAK / C / G）受信待ち				*/
	AJCSTC_STS_TX_ACKDAT		,		/*	 4：データレコードに対するＡＣＫ受信待ち							*/
	AJCSTC_STS_TX_ACKEOT		,		/*	 5：ＥＯＴに対するＡＣＫ受信まち									*/
	AJCSTC_STS_TX_ACKNUL		,		/*	 6：空属性レコードに対するＡＣＫ受信待ち（ＹＭＯＤＥＭ）			*/
	AJCSTC_STS_TX_SNDYMG		,		/*	 7：全ファイルデータ送信完了待ち（ＹＭＯＤＥＭ－Ｇ）				*/

	AJCSTC_STS_RX_SNDREQ		,		/*	 8：受信要求（NAK / C / G）送出中									*/
	AJCSTC_STS_RX_SNDDRQ		,		/*	 9：属性ﾚｺｰﾄﾞ受信後の、受信要求（NAK / C / G）送出中				*/
	AJCSTC_STS_RX_RCVDAT		,		/*	10：データレコード受信待ち											*/

	XYS_NUM								/*	状態数																*/
};

#define	ISXYM_TX	(AjcStcGetCurrentState(pW->hStc) >= AJCSTC_STS_TX_RCVREQ  &&  AjcStcGetCurrentState(pW->hStc) <= AJCSTC_STS_TX_ACKNUL)
#define	ISYMG_TX	(AjcStcGetCurrentState(pW->hStc) == AJCSTC_STS_TX_SNDYMG                                                             )
#define	ISXYM_RX	(AjcStcGetCurrentState(pW->hStc) >= AJCSTC_STS_RX_SNDREQ  &&  AjcStcGetCurrentState(pW->hStc) <= AJCSTC_STS_RX_RCVDAT)

/*--------------------------------------------------------------------------------------------------------------*/
/*	イベントコード																								*/
/*--------------------------------------------------------------------------------------------------------------*/
enum {
	XYE_REQ_TXSRT				,		/*	 0 : ファイル送信開始要求											*/
	XYE_REQ_RXSRT				,		/*	 1 : ファイル受信開始要求											*/
	XYE_REQ_STOP				,		/*	 2 : 転送中止要求													*/
	XYE_RXREQ					,		/*	 3 : 受信要求（ＮＡＫ／Ｃ）受信										*/
	XYE_RXREQ_YG				,		/*	 4 : 受信要求（Ｇ）受信												*/
	XYE_RXNAK					,		/*	 5 : ＮＡＫ受信														*/
	XYE_RXACK_XM				,		/*	 6 : ＡＣＫ受信（ＸＭＯＤＥＭ）										*/
	XYE_RXACK_YM				,		/*	 7 : ＡＣＫ受信（ＹＭＯＤＥＭ）										*/
	XYE_RXEOT_XM				,		/*	 8 : ＥＯＴ受信（ＸＭＯＤＥＭ）										*/
	XYE_RXEOT_YM				,		/*	 9 : ＥＯＴ受信（ＹＭＯＤＥＭ）										*/
	XYE_RXCAN					,		/*	10 : ＣＡＮ受信														*/
	XYE_RXREC_OK_XM				,		/*	11 : データレコード受信（ＯＫ，ＸＭＯＤＥＭ）						*/
	XYE_RXREC_OK_YM				,		/*	12 : データレコード受信（ＯＫ，ＹＭＯＤＥＭ）						*/
	XYE_RXREC_NUL				,		/*	13 : ヌルヘッダ受信（ＯＫ，ＹＭＯＤＥＭ／ＹＭＯＤＥＭ－Ｇ）			*/
	XYE_RXREC_BF				,		/*	14 : データレコード受信（ＢＦ，ＹＭＯＤＥＭ－Ｇ以外・・１つ前のRNO）*/
	XYE_RXREC_NG				,		/*	15 : データレコード受信（ＮＧ，ＹＭＯＤＥＭ－Ｇ以外）				*/
	XYE_RXREC_NG_YG				,		/*	16 : データレコード受信（ＮＧ，ＹＭＯＤＥＭ－Ｇ）					*/
	XYE_TXEND					,		/*	17 : 送信完了（ＹＭＯＤＥＭ－Ｇ）									*/
	XYE_FI_VALID_XM				,		/*	18 : 有効なファイル情報取得（ＸＭＯＤＥＭ）							*/
	XYE_FI_VALID_YM				,		/*	19 : 有効なファイル情報取得（ＹＭＯＤＥＭ）							*/
	XYE_FI_VALID_YG				,		/*	20 : 有効なファイル情報取得（ＹＭＯＤＥＭ－Ｇ）						*/
	XYE_FI_NULL_XM				,		/*	21 : 空のファイル情報取得（ＸＭＯＤＥＭ）							*/
	XYE_FI_NULL_YM				,		/*	22 : 空のファイル情報取得（ＹＭＯＤＥＭ）							*/
	XYE_FI_NULL_YG				,		/*	23 : 空のファイル情報取得（ＹＭＯＤＥＭ－Ｇ）						*/
	XYE_FDATA					,		/*	24 : 有効なファイルデータ取得										*/
	XYE_EOF						,		/*	25 : ファイル終端検出												*/
	XYE_TIMOUT_0				,		/*	26 : タイムアウト  （０）											*/
	XYE_TIMOUT_0_YG				,		/*	27 : タイムアウト  （０，ＹＭＯＤＥＭ＿Ｇ）							*/
	XYE_RTYOUT_0				,		/*	28 : リトライアウト（０）											*/
	XYE_TIMOUT_1				,		/*	29 : タイムアウト  （１）											*/
	XYE_TIMOUT_1_YG				,		/*	30 : タイムアウト  （１，ＹＭＯＤＥＭ＿Ｇ）							*/
	XYE_RTYOUT_1				,		/*	31 : リトライアウト（１）											*/

	XYE_NUM								/*	イベント数															*/
};

/*--------------------------------------------------------------------------------------------------------------*/
/*	タイマＩＤ																									*/
/*--------------------------------------------------------------------------------------------------------------*/
enum {									/*	送信動作タイマ														*/
	XYTIM_WAIREQ				,		/*	 0 : 受信要求（NAK / C / G）受信待ちタイマ							*/
	XYTIM_WAIACK				,		/*	 1 : ＡＣＫ受信待ちタイマ											*/
	XYTIM_TX2					,		/*	 2 : －																*/
	XYTIM_TX3							/*	 3 : －																*/
};

enum {									/*	 受信動作タイマ														*/
	XYTIM_REQCYC				,		/*	 0 : 受信要求（NAK / C / G）送出周期タイマ							*/
	XYTIM_WAIREC				,		/*	 1 : レコード受信待ちタイマ											*/
	XYTIM_RX2					,		/*	 2 : －																*/
	XYTIM_RX3							/*	 3 : －																*/
};

#define	XYTIM_NUM	4

/*--------------------------------------------------------------------------------------------------------------*/
/*	プリセットファンクション																					*/
/*--------------------------------------------------------------------------------------------------------------*/
enum {
	AJCSTC_PF_TX_REQ		,		/*	 0: 受信要求（NAK/C/G）送信												*/
	AJCSTC_PF_TX_ACK		,		/*	 1: ＡＣＫ送信（無条件送出）											*/
	AJCSTC_PF_TX_ACKNYG		,		/*	 2: ＡＣＫ送信（ＹＭＯＤＥＭ－Ｇ以外の場合のみ）						*/
	AJCSTC_PF_TX_NAK		,		/*	 3: ＮＡＫ送信															*/
	AJCSTC_PF_TX_EOT		,		/*	 4: ＥＯＴ送信															*/
	AJCSTC_PF_TX_CAN		,		/*	 5: ＣＡＮ送信															*/
	AJCSTC_PF_TX_ATT		,		/*	 6: 属性レコード送信													*/
	AJCSTC_PF_TX_REC		,		/*	 7: データレコード送信													*/
	AJCSTC_PF_TX_FILE		,		/*	 8: 全ファイルデータ送信（ＹＭＯＤＥＭ－Ｇ）							*/
	AJCSTC_PF_TX_RTY		,		/*	 9: レコード再送														*/

	AJCSTC_PF_GET_FILE		,		/*	10: ファイル情報取得													*/
	AJCSTC_PF_GET_DATA		,		/*	11: ファイルデータ取得													*/

	AJCSTC_PF_INI_RNO		,		/*	12: レコード番号初期化													*/
	AJCSTC_PF_UPD_RNO		,		/*	13: レコード番号更新													*/

	AJCSTC_PF_N_FINFO		,		/*	14: ファイル情報通知													*/
	AJCSTC_PF_N_TXREC		,		/*	15: １レコード送信完了通知												*/
	AJCSTC_PF_N_RXREC		,		/*	16: １レコード受信通知													*/
	AJCSTC_PF_N_RETRY		,		/*	17: ＮＡＫによる再送発生通知											*/
	AJCSTC_PF_N_EOF			,		/*	18: ＥＯＦ通知															*/

	AJCSTC_PF_N_END			,		/*	19: ファイル転送完了通知												*/
	AJCSTC_PF_N_RX_CAN		,		/*	20: ファイル転送中止通知（ＣＡＮ受信）									*/
	AJCSTC_PF_N_USRSTP		,		/*	21: ファイル転送中止通知（ユーザからの中止要求）						*/
	AJCSTC_PF_N_TIMOUT		,		/*	22: ファイル転送中止通知（タイムアウト）								*/
	AJCSTC_PF_N_ABORT				/*	23: ファイル転送中止通知（その他）										*/
};

/*--------------------------------------------------------------------------------------------------------------*/
/*	状態遷移テーブル																							*/
/*--------------------------------------------------------------------------------------------------------------*/
extern	const AJCSTC_STSACT	XymStsTbl [ XYS_NUM ];
extern	const AJCSTC_EVT_NF	XymEvtTbl [ XYE_NUM ] [ XYS_NUM ];

/****************************************************************************************************************/
#endif
