﻿#include	"AjcInternal.h"
#include	"AjcXYModemL.h"


#define		TM		AJCTM
#define		SM		AJCSM
#define		PF		AJCPF

/*==========================================================================================================================*/
/*																															*/
/*		状態遷移時アクションテーブル																						*/
/*																															*/
/*==========================================================================================================================*/
const AJCSTC_STSACT	XymStsTbl [ XYS_NUM ] = {
/*  Status-            TimerControl      PresetFunctions                                                   	*/
/*                      0  1  2  3                                                                          */
/*  0:IDLE      */ {TM( R, R, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ	*/ {TM( S, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT	*/ {TM( _, S, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ */ {TM( S, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT */ {TM( _, S, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT */ {TM( _, S, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL	*/ {TM( _, S, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG	*/ {TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ	*/ {TM( S, _, _, _ ),PF( INI_RNO  , TX_REQ   , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ */ {TM( S, _, _, _ ),PF( __       , TX_REQ   , __       , __       , __       , __       )},
/* 10:RX_RCVDAT	*/ {TM( _, S, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
};

/*==========================================================================================================================*/
/*																															*/
/*	イベントアクションテーブル																								*/
/*																															*/
/*==========================================================================================================================*/
const AJCSTC_EVT_NF	XymEvtTbl [ XYE_NUM ] [ XYS_NUM ] = {
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 0] : ファイル送信開始要求																								*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( TX_RCVREQ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 1] : ファイル受信開始要求																								*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( RX_SNDREQ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 2] : 転送中止要求																										*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_USRSTP , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_USRSTP , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_USRSTP , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 3] : 受信要求（ＮＡＫ／Ｃ）受信																						*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( INI_RNO  , GET_FILE , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , GET_DATA , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 4] : 受信要求（Ｇ）受信																								*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( INI_RNO  , GET_FILE , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( TX_SNDYMG),TM( _, _, _, _ ),PF( __       , TX_FILE  , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 5] : ＮＡＫ受信																										*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_EOT   , N_RETRY  , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 6] : ＡＣＫ受信（ＸＭＯＤＥＭ）																						*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( N_TXREC  , UPD_RNO  , GET_DATA , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_END    , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 7] : ＡＣＫ受信（ＹＭＯＤＥＭ）																						*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( TX_RCVDRQ),TM( _, _, _, _ ),PF( __       , UPD_RNO  , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( N_TXREC  , UPD_RNO  , GET_DATA , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( TX_RCVREQ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_END    , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 8] : ＥＯＴ受信（ＸＭＯＤＥＭ）																						*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_ACK   , N_EOF    , N_END    , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_ACK   , N_EOF    , N_END    , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[ 9] : ＥＯＴ受信（ＹＭＯＤＥＭ）																						*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( RX_SNDREQ),TM( _, _, _, _ ),PF( TX_ACK   , N_EOF    , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( RX_SNDREQ),TM( _, _, _, _ ),PF( TX_ACK   , N_EOF    , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[10] : ＣＡＮ受信																										*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( __       , N_RX_CAN , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( __       , N_RX_CAN , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( N_EOF    , N_RX_CAN , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[11] : データレコード受信（ＯＫ，ＸＭＯＤＥＭ）																			*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( RX_RCVDAT),TM( R, _, _, _ ),PF( TX_ACKNYG, N_FINFO  , N_RXREC  , UPD_RNO  , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( RX_RCVDAT),TM( _, _, _, _ ),PF( TX_ACKNYG, __       , N_RXREC  , UPD_RNO  , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[12] : データレコード受信（ＯＫ，ＹＭＯＤＥＭ）																			*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( RX_SNDDRQ),TM( R, _, _, _ ),PF( TX_ACKNYG, N_FINFO  , UPD_RNO  , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( RX_RCVDAT),TM( R, _, _, _ ),PF( TX_ACKNYG, N_RXREC  , UPD_RNO  , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( RX_RCVDAT),TM( _, _, _, _ ),PF( TX_ACKNYG, N_RXREC  , UPD_RNO  , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[13] : ヌルヘッダ受信（ＯＫ，ＹＭＯＤＥＭ／ＹＭＯＤＥＭ－Ｇ）															*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_ACKNYG, N_END    , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( RX_RCVDAT),TM( R, _, _, _ ),PF( TX_ACKNYG, N_RXREC  , UPD_RNO  , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( RX_RCVDAT),TM( _, _, _, _ ),PF( TX_ACKNYG, N_RXREC  , UPD_RNO  , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[14] : データレコード受信（ＢＦ，ＹＭＯＤＥＭ－Ｇ以外・・１つ前のRNO）													*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( RX_RCVDAT),TM( _, _, _, _ ),PF( TX_ACKNYG, __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[15] : データレコード受信（ＮＧ，ＹＭＯＤＥＭ－Ｇ以外）																	*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( RX_RCVDAT),TM( _, _, _, _ ),PF( TX_NAK   , N_RETRY  , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[16] : データレコード受信（ＮＧ，ＹＭＯＤＥＭ－Ｇ）																		*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_ABORT  , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_ABORT  , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_ABORT  , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[17] : 送信完了（ＹＭＯＤＥＭ－Ｇ）																						*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( TX_ACKEOT),TM( _, _, _, _ ),PF( TX_EOT   , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[18] : 有効なファイル情報取得（ＸＭＯＤＥＭ）																			*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( GET_DATA , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[19] : 有効なファイル情報取得（ＹＭＯＤＥＭ）																			*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( TX_ACKATT),TM( _, _, _, _ ),PF( TX_ATT   , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[20] : 有効なファイル情報取得（ＹＭＯＤＥＭ－Ｇ）																		*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( TX_RCVDRQ),TM( _, _, _, _ ),PF( TX_ATT   , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[21] : 空のファイル情報取得（ＸＭＯＤＥＭ）																				*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( TX_ACKEOT),TM( _, _, _, _ ),PF( TX_EOT   , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[22] : 空のファイル情報取得（ＹＭＯＤＥＭ）																				*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( TX_ACKNUL),TM( _, _, _, _ ),PF( TX_ATT   , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[23] : 空のファイル情報取得（ＹＭＯＤＥＭ－Ｇ）																			*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_ATT   , N_END    , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[24] : 有効なファイルデータ取得																							*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( TX_ACKDAT),TM( _, _, _, _ ),PF( TX_REC   , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( TX_ACKDAT),TM( _, _, _, _ ),PF( TX_REC   , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( TX_ACKDAT),TM( _, _, _, _ ),PF( TX_REC   , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( TX_ACKDAT),TM( _, _, _, _ ),PF( TX_REC   , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[25] : ファイル終端検出																									*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( TX_ACKEOT),TM( _, _, _, _ ),PF( N_EOF    , TX_EOT   , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( TX_ACKEOT),TM( _, _, _, _ ),PF( N_EOF    , TX_EOT   , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( TX_ACKEOT),TM( _, _, _, _ ),PF( N_EOF    , TX_EOT   , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( TX_ACKEOT),TM( _, _, _, _ ),PF( N_EOF    , TX_EOT   , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[26] : タイムアウト（０）	TX=受信要求(NAK/C/G)受信待ちﾀｲﾏ，RX=受信要求(NAK/C/G)送出ｲﾝﾀﾊﾞﾙﾀｲﾏ							*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_TIMOUT , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( S, _, _, _ ),PF( TX_REQ   , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( S, _, _, _ ),PF( TX_REQ   , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[27] : タイムアウト（０，ＹＭＯＤＥＭ－Ｇ）																				*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_TIMOUT , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( S, _, _, _ ),PF( TX_REQ   , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( S, _, _, _ ),PF( TX_REQ   , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[28] : リトライアウト（０）																								*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_TIMOUT , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_TIMOUT , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[29] : タイムアウト（１）	TX=ＡＣＫ受信待ちタイマ，RX=レコード受信待ちタイマ											*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_RTY   , N_RETRY  , __       , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( __       ),TM( _, S, _, _ ),PF( TX_NAK   , N_RETRY  , __       , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[30] : タイムアウト（１，ＹＭＯＤＥＭ－Ｇ）																				*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
},
/*--------------------------------------------------------------------------------------------------------------------------*/
/*	[31] : リトライアウト（１）																								*/
/*--------------------------------------------------------------------------------------------------------------------------*/
/* Current state  Next state    TimerControl      PresetFunctions                                                           */
/*                                    0  1  2  3                                                                            */
/*  0:IDLE     */{{SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  1:TX_RCVREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_TIMOUT , __       , __       , __       )},
/*  2:TX_ACKATT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  3:TX_RCVDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/*  4:TX_ACKDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  5:TX_ACKEOT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  6:TX_ACKNUL*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
/*  7:TX_SNDYMG*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},

/*  8:RX_SNDREQ*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , __       , N_TIMOUT , __       , __       , __       )},
/*  9:RX_SNDDRQ*/{ SM( __       ),TM( _, _, _, _ ),PF( __       , __       , __       , __       , __       , __       )},
/* 10:RX_RCVDAT*/{ SM( IDLE     ),TM( _, _, _, _ ),PF( TX_CAN   , N_EOF    , N_TIMOUT , __       , __       , __       )},
},
};
