﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>
#include	<shlwapi.h>


#define	REGPATH	"Software\\AjrCstXX"

#define		MYSECT	"General"

#define	NOT_VOLATILE	FALSE


/*
		NOTE :	インストール時のカスタム動作では、HKEY_CURRENT_USER にアクセスできない。
				環境変数の設定は、全てHKEY_LOCAL_MACHINE への書き込みとする
*/


//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	fLogMsg = TRUE;
static	BC		MyPath[MAX_PATH];
static	BC		MsgTxt[4096] = {0};
static	BC		ErrTxt[4096] = {0};

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIsInstallAllUser(VO);

static	BOOL	SetEnvPATH		(VO);
static	BOOL	SetAsmRefInfo	(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	BC		szRegBuf[256];
	UX		dwReturnValue = 0;

	//----- ライブラリ初期化 -----------------------------------------------------------------------------------//
	MAjcInit();

	do {
		//----- コマンドライン・オプション解析（ /Install が指定されていればエラーをログ表示しない）------------//
		if (AjcStrIStr(szCmdLine, "/NoMsg")) {
			fLogMsg = FALSE;
		}

		//----- 自プログラムのフォルダパス取得 -----------------------------------------------------------------//
		AjcGetAppPath(MyPath, MAX_PATH);

		//----- レジストリ（Lang）作成 -------------------------------------------------------------------------//
		if (AjcGetRegFileStr(REGPATH, MYSECT, "Lang", "", szRegBuf, sizeof szRegBuf) == 0) {
			AjcPutRegFileStr(REGPATH, MYSECT, "Lang", NOT_VOLATILE, "AUTO");
		}

		//----- 環境変数設定(PATH) -----------------------------------------------------------------------------//
		SetEnvPATH();

		//----- 環境変数を有効化 -------------------------------------------------------------------------------//
		SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, (LPARAM)"Environment", SMTO_ABORTIFHUNG, 5000, (PDWORD_PTR)&dwReturnValue);

		//----- .NETアセンブリ参照設定 -------------------------------------------------------------------------//
		SetAsmRefInfo();

		//----- メッセージ -------------------------------------------------------------------------------------//
		if (fLogMsg) {
			if (ErrTxt[0] == 0) {
				strcat(MsgTxt, AJCLNGSEL("\nインストール情報の設定を終了しました。",
										 "\nFinished setting the installation information."));
				MessageBox(NULL, MsgTxt, "AjrInstall", MB_OK);
			}
			else {
				strcat(ErrTxt, AJCLNGSEL("\nインストール情報の設定を失敗しました。",
										 "\nFailed to set installation information."));
				MessageBox(NULL, ErrTxt, "AjrInstall", MB_ICONERROR);
			}
		}


	} while(0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＰＡＴＨ環境変数の設定																						//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetEnvPATH(VO)
{
	BOOL	rc = FALSE;

	//	PATH環境変数中にパスが設定されていなければ、PATH環境変数更新
	if (!AjcRegHkLmEnvSrhPathItem(MyPath)) {
		//	PATH 環境変数書き込み
		rc = AjcRegHkLmEnvAddPathItem(MyPath, TRUE, AJCREG_EXPAND_SZ);

		//	メッセージテキスト追記
		if (rc) {
			strcat(MsgTxt, AJCLNGSEL("PATH 環境変数を更新しました。\n",
									 "Updated the PATH environment variable.\n"));
		}
	}
	//	PATH環境変数中にパスが設定されていれば、その旨をメッセージに追記
	else {
		strcat(MsgTxt, AJCLNGSEL("PATH 環境変数は、既に設定されています。\n",
								 "The PATH environment variable is already set.\n"));
		rc = TRUE;
	}
	//	エラーメッセージ追記
	if(!rc) {
		strcat(ErrTxt, AJCLNGSEL("PATH 環境変数の書き込みを失敗しました。\n",
								 "Writing the PATH environment variable failed.\n"));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	アセンブリの参照情報設定（[参照の追加] ダイアログ ボックスの選択肢として表示する）							//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetAsmRefInfo(VO)
{
	BOOL		rc = FALSE;
	SYSTEM_INFO	si;
	AJCREGTYPE	type = AJCREG_SZ;
	BC			path[MAX_PATH];
	BC			txt [1024];

	GetNativeSystemInfo(&si);

	//	レジストリにアセンブリの参照情報書き込み
	//	For WIN32
	if (si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL) {
		//	パスが存在しない場合は、.NET アセンブリ参照パス書き込み
		if (AjcRegGet(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L32, NULL, &type, path, MAX_PATH) == 0) {
			if (rc = AjcRegPut(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L32, NULL, AJCREG_SZ, (C_UBP)MyPath, (UI)strlen(MyPath) + 1)) {
				strcat(MsgTxt, AJCLNGSEL(".NET アセンブリ参照パスを設定しました。\n",
										 "I have set the .NET assembly reference path.\n"));
			}
		}
		//	既にパスが存在する場合は、その旨をメッセージへ追記
		else {
			if (stricmp(path, MyPath) == 0) {
				AjcSnPrintF(txt, AJCTSIZE(txt), AJCLNGSEL(".NET アセンブリ参照パスは、既に設定されています。\n",
										 				  ".NET assembly reference path is already set.\n"));
			}
			else {
				AjcSnPrintF(txt, AJCTSIZE(txt), AJCLNGSEL(".NET アセンブリ参照パスは、既に別のパスが設定されています。\n(%s)\n",
										 				  "The .NET assembly reference path is already set to another path.\n(%s)\n"), path);
			}
			strcat(MsgTxt, txt);
			rc = TRUE;
		}
	}
	//	For WIN64
	else {
		//	パスが存在しない場合は、.NET アセンブリ参照パス書き込み
		if (AjcRegGet(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L64, NULL, &type, path, MAX_PATH) == 0) {
			if (rc = AjcRegPut(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L64, NULL, AJCREG_SZ, (C_UBP)MyPath, (UI)strlen(MyPath) + 1)) {
				strcat(MsgTxt, AJCLNGSEL(".NET アセンブリ参照パスを設定しました。\n",
										 "I have set the .NET assembly reference path.\n"));
			}
		}
		//	既にパスが存在する場合は、その旨をメッセージへ追記
		else {
			if (stricmp(path, MyPath) == 0) {
				AjcSnPrintF(txt, AJCTSIZE(txt), AJCLNGSEL(".NET アセンブリ参照パスは、既に設定されています。\n",
										 				  ".NET assembly reference path is already set.\n"));
			}
			else {
				AjcSnPrintF(txt, AJCTSIZE(txt), AJCLNGSEL(".NET アセンブリ参照パスは、既に別のパスが設定されています。\n(%s)\n",
										 				  "The .NET assembly reference path is already set to another path.\n(%s)\n"), path);
			}
			strcat(MsgTxt, txt);
			rc = TRUE;
		}
	}
	//	エラーメッセージ追記
	if (!rc) {
		strcat(ErrTxt, AJCLNGSEL(".NET アセンブリ参照パスの書き込みを失敗しました。\n",
								 "Writing the .NET assembly reference failed.\n"));
	}

	return rc;
}
