﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>
#include	<Shlwapi.h>
#include	<stdio.h>
#include	"resource.h"

#define	NOT_VOLATILE	FALSE

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	HWND	hDlgMain = NULL;
static	HICON	hIcon	 = NULL;
static	int		mode	 = 0;			// 0:インストール完了待ち，1:タイマ満了待ち
static	int		TimCnt;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	LRESULT	CALLBACK DlgMainProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
static	BOOL	IsCompleteInstlation(void);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG 	msg;

	//----- アイコンロード -----------------------------//
	hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPICON));

	//----- ダイアログ生成 -----------------------------//
	hDlgMain = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	AjcMoveWindowToCenter(hDlgMain);
//	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
	//----- アイコン破棄 ------------------------------//
	DeleteObject(hIcon);

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	メイン・ダイアログ・プロシージャ																			//
//																												//
//==============================================================================================================//
//----- INIT DIALOG --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG		)
{
	//----- アイコン表示 -----------------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);

	//----- 日英ラベル表示 ---------------------------------------//
	SetWindowText(hDlg, AJCLNGSEL("あじゃら カスタムコントロール", "Ajara Custom contro"));
	SetDlgItemText(hDlg, IDC_TXT_MSG,  AJCLNGSEL("設定を有効とするには再起動が必要です。\n今すぐ再起動しますか？",
												 "You will be restart to complete the installation.\nDo you reboot now?"));
	SetDlgItemText(hDlg, IDOK	 , AJCLNGSEL("今すぐ再起動"	, "Reboot now"));
	SetDlgItemText(hDlg, IDCANCEL, AJCLNGSEL("あとで"		, "Cancel"	  ));

	SetTimer(hDlg, 1, 1000, NULL);

	return TRUE;
}
//----- DESTROY WINDOW -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	PostQuitMessage(0);

	return TRUE;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	HKEY		hKey = NULL;
	UL			type = REG_DWORD;
	UL			bytes = sizeof(DWORD);

	if (IsCompleteInstlation()) {
		KillTimer(hDlg, 1);
		Sleep(100);
		ShowWindow(hDlg, SW_SHOW);
	}

	return TRUE;
}
//----- IDOK ---------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK			)
{
	AjcExitWindows(EWX_REBOOT);
	DestroyWindow(hDlg);

	return TRUE;
}
//----- IDCANCEL -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG			)
	AJC_DLGMAP_MSG(Main, WM_DESTROY				)
	AJC_DLGMAP_MSG(Main, WM_TIMER				)

	AJC_DLGMAP_CMD(Main, IDOK					)
	AJC_DLGMAP_CMD(Main, IDCANCEL				)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	インストール終了チェック																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEnumWindows(HWND hwnd, LPARAM lParam)
{
	BOOL		rc = TRUE;
	HINSTANCE	hMod = NULL;
	UB			fname[MAX_PATH];
	UB			fext [MAX_PATH];
	UB			path [MAX_PATH];

	if (hMod = AjcGetExePathName(hwnd, path, MAX_PATH)) {
		_splitpath(path, NULL, NULL, fname, fext);
		if ((stricmp(fname, "msiexec") == 0 || stricmp(fname, "setup") == 0) && (stricmp(fext, ".exe") == 0)) {
			*((BOOL *)lParam) = FALSE;
			rc = FALSE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	IsCompleteInstlation(void)
{
	BOOL	rc = TRUE;

	EnumWindows(cbEnumWindows, (LPARAM)&rc);
	return rc;
}
