﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>


#ifdef _WIN64
	BC		ExeName[] = "AjrSetEnv64.exe";
	BC		AdmName[] = "AjrSetEnvAdm64.exe";
#else
	BC		ExeName[] = "AjrSetEnv32.exe";
	BC		AdmName[] = "AjrSetEnvAdm32.exe";
#endif

AJCEXPORT	BOOL		WINAPI	AjcIsInstallAllUser(VO);

static	BOOL	fAllUser = FALSE;

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	int		Answer = IDNO;
	BC		path[MAX_PATH];

	AjcGetAppPath(path, MAX_PATH);

	//	全てのユーザ向けにインストールされているかをチェック
	fAllUser = AjcIsInstallAllUser();

	//	全てのユーザ向けにインストールされている場合は、システムレジストリアクセスの確認
	if (fAllUser) {
		Answer = MessageBox(NULL, AJCLNGSEL("このライブラリは、全てのユーザ向けにインストールされています。\n"
											"環境変数を設定するには、システムのレジストリ情報をアクセスする必要があります。\n"
											"システムのレジストリ情報をアクセスしますか？\n\n"
											"「はい」をクリックするとシステムの情報をアクセスします。\n"
											"「いいえ」をクリックするとこのユーザだけの情報をアクセスします。\n"
											"「キャンセル」をクリックするとプログラムを終了します。",

											"This library is installed for all users.\n"
											"You need to access the system registry information to set environment variables.\n"
											"Do you want to access the system registry information?\n\n"
											"Click 'Yes' to access the system information.\n"
											"Click 'No' to access information only for current user.\n"
											"Click 'Cancel' Exit the program.\n"

											),
											"AjrSetEnv", MB_YESNOCANCEL);
	}

	if (Answer != IDCANCEL) {
		//	「はい」を応答した場合、システムレジストリをアクセス
		if (Answer == IDYES) {
			ShellExecute(NULL, NULL, AdmName, "/HKLM", path, SW_SHOWNORMAL);
		}
		//	「いいえ」を応答した場合は、このユーザのレジストリをアクセス
		else {
			ShellExecute(NULL, NULL, ExeName, "/HKCU", path, SW_SHOWNORMAL);
		}
	}
	return 0;
}
