﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>

#include	"resource.h"

/*
		NOTE :	インストール時のカスタム動作では、HKEY_CURRENT_USER にアクセスできない。
				環境変数の設定は、全てHKEY_LOCAL_MACHINE への書き込みとする
*/

//--------------------------------------------------------------------------------------------------------------//
//	インストール情報のレジストリ記録オプション	（TRUE:一時記録，FALSE:恒久記録）								//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	_DEBUG
	#define	INST_REGOPT		TRUE		//	デバッグ時はレジストリ一時記録
#else
	#define	INST_REGOPT		FALSE		//	リリース時はレジストリ恒久記録
#endif

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE	hInst		= NULL;
static	HWND		hDlgMain	= NULL;
static	HICON		hIcon		= NULL;

static	BOOL		fBfrCL	, fAftCL;
static	BOOL		fBfrLINK, fAftLINK;
static	BOOL		fBfrPATH, fAftPATH;

static	BC			BinPath[MAX_PATH];
static	BC			IncPath[MAX_PATH];
static	BC			LibPath[MAX_PATH];

static	BC			ParamCL  [MAX_PATH + 16];
static	BC			ParamLINK[MAX_PATH + 16];

static	BC			szBfrCL  [16384] = {0};
static	BC			szBfrLINK[16384] = {0};
static	BC			szBfrPATH[16384] = {0};

static	BC			szAftCL  [16384] = {0};
static	BC			szAftLINK[16384] = {0};
static	BC			szAftPATH[16384] = {0};

static	BC			EnvBuf[16384] = {0};

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIsInstallAllUser(VO);

AJC_DLGPROC_DEF(Main);

static VO	ReadRegCL	(BCP pBuf, UI lBuf);
static BOOL InsRegCL	(C_BCP pParam);
static BOOL DelRegCL	(C_BCP pParam);

static VO	ReadRegLINK	(BCP pBuf, UI lBuf);
static BOOL InsRegLINK	(C_BCP pParam);
static BOOL DelRegLINK	(C_BCP pParam);

static VO	ReadRegPATH	(BCP pBuf, UI lBuf);
static BOOL InsRegPATH	(C_BCP pPath);
static BOOL DelRegPATH	(C_BCP pPath);

static	BOOL	IsPathExist (C_BCP pVar, C_BCP pPath);
static	BOOL	IsParamExist(C_BCP pVar, C_BCP pParam);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG		msg;
	int		stl;

	hInst = hInstance;

	//----- AjrCstXX.dll初期化 ----------------------------------------------------------------//
	MAjcInit();

	//----- 現在設定されている環境変数値取得 --------------------------------------------------//
	ReadRegCL(szBfrCL  , sizeof szBfrCL  );
	ReadRegLINK(szBfrLINK, sizeof szBfrLINK);
	ReadRegPATH(szBfrPATH, sizeof szBfrPATH);

	//----- パス情報設定 ----------------------------------------------------------------------//
	AjcGetMyPath(BinPath, sizeof BinPath, IncPath, sizeof IncPath);

	//----- ＣＬパラメタ設定（ＩＮＣＬＵＤＥパスの末尾の「￥」は除去する） --------------------//
	stl = (int)MAjcStrLen(IncPath);
	if (stl > 0 && IncPath[stl - 1] == '\\') {
		IncPath[stl - 1] = 0;
	}
	AjcSnPrintF(ParamCL, sizeof ParamCL, "/I\"%s\"", IncPath);

	//----- ＬＩＮＫパラメタ設定（ＬＩＢパスの末尾の「￥」は除去する） ------------------------//
	strcpy(LibPath, BinPath);
	AjcSnPrintF(ParamLINK, sizeof ParamLINK, "/LIBPATH:\"%s\"", LibPath);

	//----- アイコンロード --------------------------------------------------------------------//
	hIcon		= LoadIcon(hInst, MAKEINTRESOURCE(IDI_APPICON));

	//----- メイン・ダイアログオープン --------------------------------------------------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ------------------------------------------------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	//----- アイコン破棄 ----------------------------------------------------------------------//
	DeleteObject(hIcon);

	//----- 設定した環境変数取得 --------------------------------------------------------------//
	ReadRegCL(szAftCL  , sizeof szAftCL  );
	ReadRegLINK(szAftLINK, sizeof szAftLINK);
	ReadRegPATH(szAftPATH, sizeof szAftPATH);

	//----- 設定が変更された場合は、環境変数を有効化 ------------------------------------------//
	if (MAjcStrICmp(szBfrCL, szAftCL) != 0 || MAjcStrICmp(szBfrLINK, szAftLINK) != 0 || MAjcStrICmp(szBfrPATH, szAftPATH) != 0) {
		//	システムへ通知
		UX	dwReturnValue;
		SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, (LPARAM) "Environment", SMTO_ABORTIFHUNG, 5000, (PDWORD_PTR)&dwReturnValue);
		//	再起動
	//	if (MessageBox(NULL, AJCLNGSEL(	"設定を有効とするためには再起動する必要があります。\n"
	//									"今すぐ再起動しますか？",
	//									"It is necessary to reboot, if validate to this setting.\n"
	//									"Do you reboot now?"), "AjrSetEnv", MB_YESNO) == IDYES) {
	//		AjcExitWindows(EWX_REBOOT);
	//	}
	}
	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	UI		SysVer;

	hDlgMain   = hDlg;
	AjcMoveWindowToCenter(hDlg);

	//----- アイコン表示 ------------------------------------------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);

	//----- Windows2000以前ならば、全ボタン操作禁止 ---------------------------------------//
	SysVer = GetVersion() & 0xFF;
	if (SysVer < 5) {
		AjcEnableDlgGroup(hDlg, IDC_GRP_BUTTONS, FALSE, FALSE);
	}

	//----- ウインド位置ロード ------------------------------------------------------------//
	AjcLoadWndPos(hDlg, "WndPos");

	//----- ツールチップ設定 --------------------------------------------------------------//
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SETCL  ), AJCLNGSEL("レジストリ内の CL 環境変数へパラメタを追加"    ,
															  "Add parameters to CL environment variables in the registry."));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SETLINK), AJCLNGSEL("レジストリ内の LINK 環境変数へパラメタを追加"  ,
															  "Add parameters to LINK environment variables in the registry."));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SETPATH), AJCLNGSEL("レジストリ内の PATH 環境変数へパスを追加"	   ,
															  "Add path to PATH environment variable in registry."));

	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_DELCL  ), AJCLNGSEL("レジストリ内の CL 環境変数からパラメタを削除"  ,
															  "Remove parameters from CL environment variables in the registry."));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_DELLINK), AJCLNGSEL("レジストリ内の LINK 環境変数からパラメタを削除",
														   "Remove parameters from LINK environment variables in the registry."));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_DELPATH), AJCLNGSEL("レジストリ内の PATH 環境変数からパスを削除"    ,
															  "Remove parameters from PATH environment variables in the registry."));


	//----- ウインドタイトル設定 ----------------------------------------------------------//
	SetWindowText(hDlg, AJCLNGSEL("環境変数の設定 ( WinCustLib )", "Setting environment variables ( WinCustLib )"));
	//----- ボタンフェース等表示 ----------------------------------------------------------//
	AjcSetDlgItemStr(hDlg, IDC_LBL_VER, AjcGetVerStr());
	AjcSetDlgItemStr(hDlg, IDC_LBL_NAME		, AJCLNGSEL("環境変数名"		, "Variable"				));
	AjcSetDlgItemStr(hDlg, IDC_LBL_CONT		, AJCLNGSEL("設定する内容"		, "Setting Content"			));

	AjcSetDlgItemStr(hDlg, IDC_LBL_REG		, AJCLNGSEL("レジストリ"		, "Registory"				));
	AjcSetDlgItemStr(hDlg, IDC_LBL_ENV		, AJCLNGSEL("環境変数"			, "Env.Var."				));

	AjcSetDlgItemStr(hDlg, IDC_RBT_SETCL	, AJCLNGSEL("設定する"			, "Set"						));
	AjcSetDlgItemStr(hDlg, IDC_RBT_SETLINK	, AJCLNGSEL("設定する"			, "Set"						));
	AjcSetDlgItemStr(hDlg, IDC_RBT_SETPATH	, AJCLNGSEL("設定する"			, "Set"						));
	AjcSetDlgItemStr(hDlg, IDC_RBT_DELCL	, AJCLNGSEL("解除する"			, "Rel."					));
	AjcSetDlgItemStr(hDlg, IDC_RBT_DELLINK	, AJCLNGSEL("解除する"			, "Rel."					));
	AjcSetDlgItemStr(hDlg, IDC_RBT_DELPATH	, AJCLNGSEL("解除する"			, "Rel."					));

	AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE1	, AJCLNGSEL("「設定する」を選択すると、上記内容をレジストリ上のシステム環境変数へ設定します。",
														"If you select 'Set', the above contents will be set in the system environment variables on the registry."));

	AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE2	, AJCLNGSEL("「解除する」を選択すると、レジストリ上のシステム環境変数から上記内容を削除します。",
														"Select 'Rel.' to delete the above contents from the system environment variables on the registry."));

	AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE3	, AJCLNGSEL("「有効」「無効」の表示は、現在環境変数に設定されているか否かを示します。",
														"'Valid' or 'Invalid' is reflected in the present environment variable."));

	AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE4	, AJCLNGSEL("「有効／無効」の表示を更新するにはプログラムをリスタートします。",
														"When the program is restarted, the 'Valid / Invalid' display will be updated."));

	//----- 設定内容表示 ------------------------------------------------------------------//
	AjcSetDlgItemStr(hDlg, IDC_TXT_CL  , ParamCL  );
	AjcSetDlgItemStr(hDlg, IDC_TXT_LINK, ParamLINK);
	AjcSetDlgItemStr(hDlg, IDC_TXT_PATH, BinPath  );

	//----- ＣＬ 有効／無効表示 -----------------------------------------------------------//
	EnvBuf[0] = 0;
	GetEnvironmentVariable("CL", EnvBuf, sizeof EnvBuf);
	if (IsParamExist(EnvBuf, ParamCL))	 AjcSetDlgItemStr(hDlg, IDC_LBL_VALCL , AJCLNGSEL("有効", "Valid" ));
	else								 AjcSetDlgItemStr(hDlg, IDC_LBL_VALCL , AJCLNGSEL("無効", "Invalid"));
	//----- ＬＩＮＫ有効／無効表示 --------------------------------------------------------//
	EnvBuf[0] = 0;
	GetEnvironmentVariable("LINK", EnvBuf, sizeof EnvBuf);
	if (IsParamExist(EnvBuf, ParamLINK)) AjcSetDlgItemStr(hDlg, IDC_LBL_VALLINK , AJCLNGSEL("有効", "Valid" ));
	else								 AjcSetDlgItemStr(hDlg, IDC_LBL_VALLINK , AJCLNGSEL("無効", "Invalid"));
	//----- ＰＡＴＨ 有効／無効表示 -------------------------------------------------------//
	EnvBuf[0] = 0;
	GetEnvironmentVariable("PATH", EnvBuf, sizeof EnvBuf);
	if (IsPathExist(EnvBuf, BinPath))	 AjcSetDlgItemStr(hDlg, IDC_LBL_VALPATH, AJCLNGSEL("有効", "Valid" ));
	else								 AjcSetDlgItemStr(hDlg, IDC_LBL_VALPATH, AJCLNGSEL("無効", "Invalid"));

	//----- ＣＬ設定済／未設定表示 --------------------------------------------------------//
	EnvBuf[0] = 0;
	ReadRegCL(EnvBuf, sizeof EnvBuf);
	if (fBfrCL	 = IsParamExist(EnvBuf, ParamCL  ))	{AjcSetDlgItemChk(hDlg, IDC_RBT_SETCL, TRUE);
													 AjcSetDlgItemStr(hDlg, IDC_RBT_SETCL, "NoAct.");
													 AjcSetDlgItemStr(hDlg, IDC_LBL_SETCL	, AJCLNGSEL("設定済", "Set"		));}
	else											{AjcSetDlgItemChk(hDlg, IDC_RBT_DELCL, TRUE);
													 AjcSetDlgItemStr(hDlg, IDC_RBT_DELCL, "NoAct.");
													 AjcSetDlgItemStr(hDlg, IDC_LBL_SETCL	, AJCLNGSEL("未設定", "Not Set"	));}
	//----- ＬＩＮＫ設定済／未設定表示 ----------------------------------------------------//
	EnvBuf[0] = 0;
	ReadRegLINK(EnvBuf, sizeof EnvBuf);
	if (fBfrLINK = IsParamExist(EnvBuf, ParamLINK)) {AjcSetDlgItemChk(hDlg, IDC_RBT_SETLINK, TRUE);
													 AjcSetDlgItemStr(hDlg, IDC_RBT_SETLINK, "NoAct.");
													 AjcSetDlgItemStr(hDlg, IDC_LBL_SETLINK , AJCLNGSEL("設定済", "Set"		));}
	else								 			{AjcSetDlgItemChk(hDlg, IDC_RBT_DELLINK, TRUE);
													 AjcSetDlgItemStr(hDlg, IDC_RBT_DELLINK, "NoAct.");
													 AjcSetDlgItemStr(hDlg, IDC_LBL_SETLINK , AJCLNGSEL("未設定", "Not Set"	));}
	//----- ＰＡＴＨ設定済／未設定表示 ----------------------------------------------------//
	EnvBuf[0] = 0;
	ReadRegPATH(EnvBuf, sizeof EnvBuf);
	if (fBfrPATH = IsParamExist(EnvBuf, BinPath  )) {AjcSetDlgItemChk(hDlg, IDC_RBT_SETPATH, TRUE);
													 AjcSetDlgItemStr(hDlg, IDC_RBT_SETPATH, "NoAct.");
													 AjcSetDlgItemStr(hDlg, IDC_LBL_SETPATH , AJCLNGSEL("設定済", "Set"		));}
	else								 			{AjcSetDlgItemChk(hDlg, IDC_RBT_DELPATH, TRUE);
													 AjcSetDlgItemStr(hDlg, IDC_RBT_DELPATH, "NoAct.");
													 AjcSetDlgItemStr(hDlg, IDC_LBL_SETPATH , AJCLNGSEL("未設定", "Not Set" ));}

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//----- ウインド位置セーブ ------------------------------------------------------------//
	AjcSaveWndPos(hDlg, "WndPos");
	//----- プログラム終了 ----------------------------------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- 「OK」ボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDOK			)
{
	BOOL	fUpdate = FALSE;

	//	CL設定
	fAftCL	 = AjcGetDlgItemChk(hDlg, IDC_RBT_SETCL  );
	if (fBfrCL != fAftCL) {
		if (fAftCL	) InsRegCL	(ParamCL);
		else		  DelRegCL	(ParamCL);
		fUpdate = TRUE;
	}
	//	LINK設定
	fAftLINK = AjcGetDlgItemChk(hDlg, IDC_RBT_SETLINK);
	if (fBfrLINK != fAftLINK) {
		if (fAftLINK) InsRegLINK(ParamLINK);
		else		  DelRegLINK(ParamLINK);
		fUpdate = TRUE;
	}
	//	PATH設定
	fAftPATH = AjcGetDlgItemChk(hDlg, IDC_RBT_SETPATH);
	if (fBfrPATH != fAftPATH) {
		if (fAftPATH) InsRegPATH(BinPath);
		else		  DelRegPATH(BinPath);
		fUpdate = TRUE;
	}

	if (fUpdate) {
		//	各コントロールを無効化しメッセージ表示
		AjcEnableCtrlsInWnd(hDlg, FALSE);
		AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE1, "");
		AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE2, "");
		AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE3, AJCLNGSEL("                                        少しお待ちください。",
													"                                        Just moment please."));
		AjcSetDlgItemStr(hDlg, IDC_LBL_NOTE4, "");
		AjcEnableDlgItem(hDlg, IDC_LBL_NOTE3, TRUE);

		//	設定内容を環境変数へ反映
		AjcRegEnableEnvironment();
	}
	DestroyWindow(hDlg);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY		)

	AJC_DLGMAP_CMD(Main, IDOK			)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	レジストリ(ＣＬ)アクセス																					//
//--------------------------------------------------------------------------------------------------------------//
//	ＣＬ文字列読み出し
static VO ReadRegCL(BCP pBuf, UI lBuf)
{
	*pBuf = 0;
	AjcRegHkLmEnvGet("CL", NULL, pBuf, lBuf);
}
//	パラメタ(/I"・・")追加
static BOOL InsRegCL(C_BCP pParam)
{
	BOOL	rc = FALSE;
	rc = AjcRegHkLmEnvAddItem("CL", pParam, ' ', FALSE, AJCREG_SZ);
	return rc;
}
//	パラメタ(/I"・・")削除
static BOOL DelRegCL(C_BCP pParam)
{
	BOOL	rc = FALSE;
	rc = AjcRegHkLmEnvDelItem("CL", pParam, ' ', TRUE);
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	レジストリ(ＬＩＮＫ)アクセス																				//
//--------------------------------------------------------------------------------------------------------------//
//	ＬＩＮＫ文字列読み出し
static VO ReadRegLINK(BCP pBuf, UI lBuf)
{
	*pBuf = 0;
	AjcRegHkLmEnvGet("LINK", NULL, pBuf, lBuf);
}
//	パラメタ(/LIBPATH"・・")追加
static BOOL InsRegLINK(C_BCP pParam)
{
	BOOL	rc = FALSE;
	rc = AjcRegHkLmEnvAddItem("LINK", pParam, ' ', FALSE, AJCREG_SZ);
	return rc;
}
//	パラメタ(/LIBPATH"・・")削除
static BOOL DelRegLINK(C_BCP pParam)
{
	BOOL	rc = FALSE;
	rc = AjcRegHkLmEnvDelItem("LINK", pParam, ' ', TRUE);
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＰＡＴＨパスアクセス																						//
//--------------------------------------------------------------------------------------------------------------//
//	ＰＡＴＨ文字列読み出し
static VO ReadRegPATH(BCP pBuf, UI lBuf)
{
	*pBuf = 0;
	AjcRegHkLmEnvGet("PATH", NULL, pBuf, lBuf);
}
//	ＰＡＴＨパス追加
static BOOL InsRegPATH(C_BCP pPath)
{
	BOOL	rc = FALSE;
	rc = AjcRegHkLmEnvAddItem("PATH", pPath, ';', TRUE, AJCREG_EXPAND_SZ);
	return rc;
}
//	ＰＡＴＨパス削除
static BOOL DelRegPATH(C_BCP pPath)
{
	BOOL	rc = FALSE;
	rc = AjcRegHkLmEnvDelItem("PATH", pPath, ';', TRUE);
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	ＰＡＴＨ文字列にパスが含まれるかチェック																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	IsPathExist(C_BCP pVar, C_BCP pPath)
{
	BOOL	rc	 = FALSE;
	BCP		pTmp = NULL;
	BCP		pStr = NULL;

	if (pTmp = malloc(strlen(pVar) + 1)) {
		strcpy(pTmp, pVar);
		if (pStr = strtok(pTmp, ";")) {
			do {
				if (stricmp(pStr, pPath) == 0) {
					rc = TRUE;
					break;
				}
			} while (pStr = strtok(NULL, ";"));
		}
		free(pTmp);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＣＬ／ＬＩＮＫ文字列にパラメタが含まれるかチェック															//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	IsParamExist(C_BCP pVar, C_BCP pParam)
{
	BOOL	rc = FALSE;

	rc = (AjcStrIStr(pVar, pParam) != NULL);

	return rc;
}
