﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>
#include	"resource.h"
//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE	hInst		= NULL;
static	HWND		hDlgMain	= NULL;
static	HICON		hIcon		= NULL;
static	SYSTEM_INFO	SysInfo;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	UI		SubSetHoriExtentByAllItem(HWND hDlg, UI id);
static	UI		SubGetHoriExtentByStr(HDC hdc, C_BCP pStr);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG		msg;

	hInst = hInstance;

	//----- アイコンロード --------------------------------------------------------------------//
	hIcon		= LoadIcon(hInst, MAKEINTRESOURCE(IDI_APPICON));

	//----- メイン・ダイアログオープン --------------------------------------------------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ------------------------------------------------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	//----- アイコン破棄 ----------------------------------------------------------------------//
	DeleteObject(hIcon);

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	hDlgMain   = hDlg;
	AjcMoveWindowToCenter(hDlg);

	//	システム情報取得
	GetNativeSystemInfo(&SysInfo);

	//	アイコン表示
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);

	//	日英テキスト 
	AjcSetDlgItemStr(hDlg, IDOK 			 , AJCLNGSEL("クリーンアップ項目の検索" 	, "Search Cleanup Items"));
	AjcSetDlgItemStr(hDlg, IDC_CMD_DEL		 , AJCLNGSEL("クリーンアップ"				, "CleanUp"));
	AjcSetDlgItemStr(hDlg, IDCANCEL 		 , AJCLNGSEL("終 了"						, "End"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_USRENV	 , AJCLNGSEL("ユーザ環境変数（CL, LINK）"	, "User Environment variable(CL, LINK)"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_USRPATH	 , AJCLNGSEL("ユーザ環境変数（PATH）"		, "User Environment variable(PATH)"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_SYSENV	 , AJCLNGSEL("システム環境変数（CL, LINK）" , "System Environment variable(CL, LINK)"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_SYSPATH	 , AJCLNGSEL("システム環境変数（PATH）" 	, "System Environment variable(PATH)"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_ASMREF	 , AJCLNGSEL(".NET FrameWork アセンブリ参照", ".NET FrameWork Assenbly Reference"));
	AjcSetDlgItemStr(hDlg, IDC_CHK_INCOLDLIB , AJCLNGSEL(" 旧ライブラリ ( AjrCtl32.dll, AjtCtl64.dll, AjaraControl ) も含める",
														 " Also includes old libraries (AjrCtl32.dll, AjtCtl64.dll, AjaraControl)"));
	//	レジストリパス表示
	AjcSetDlgItemStr(hDlg, IDC_TXT_USRENV , "HKEY_CURRNT_USER/"   AJC_REGPATH_USRENV);
	AjcSetDlgItemStr(hDlg, IDC_TXT_USRPATH, "HKEY_CURRNT_USER/"   AJC_REGPATH_USRENV);
	AjcSetDlgItemStr(hDlg, IDC_TXT_SYSENV , "HKEY_LOCAL_MACHINE/" AJC_REGPATH_SYSENV);
	AjcSetDlgItemStr(hDlg, IDC_TXT_SYSPATH, "HKEY_LOCAL_MACHINE/" AJC_REGPATH_SYSENV);

	if (SysInfo.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_ASMREF, "HKEY_LOCAL_MACHINE/" AJCMSIL_REGPATH_S32);
	}
	else {
		AjcSetDlgItemStr(hDlg, IDC_TXT_ASMREF, "HKEY_LOCAL_MACHINE/" AJCMSIL_REGPATH_S64);
	}


	//	ウインド位置ロード 
	AjcLoadWndPos(hDlg, "WndPos");

	//説明メッセージ
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_HELP, BN_CLICKED), (LPARAM)hDlg);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//	ウインド位置セーブ
	AjcSaveWndPos(hDlg, "WndPos");
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- 「クリーンアップ項目の検索」ボタン ---------------------------------------------------------------------//
static	BCP		DllLst[4] = {"AjrCst32.dll", "AjrCst64.dll", "None", "None"};
#define	MAX_DLLLST	((sizeof DllLst) / (sizeof DllLst[0]))

AJC_DLGPROC(Main, IDOK			)
{
	UI			i, Count;
	AJCREGTYPE	type;
	BCP			p;
	BC			env[16384];
	BC			txt[16384];
	BC			pv32[MAX_PATH];
	BC			pv64[MAX_PATH];

	//	ツールチップ非表示
	AjcTipTextHide();

	//	リストをリセット
	SendDlgItemMessage(hDlg, IDC_LST_USRENV , LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_LST_USRPATH, LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_LST_SYSENV , LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_LST_SYSPATH, LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_LST_ASMREF , LB_RESETCONTENT, 0, 0);
	Count = 0;

	//	ＤＬＬ名称追加（ＡｊｒＣｔｌＸＸ追加）
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_INCOLDLIB)) {
		DllLst[2] = "AjrCtl32.dll";
		DllLst[3] = "AjrCtl64.dll";
	}

	//	ユーザ環境変数(CL)
	if (AjcRegHkCuEnvGet("CL", &type, env, sizeof env)) {
		AjcSnPrintF(txt, sizeof txt, "CL=%s", env);
		SendDlgItemMessage(hDlg, IDC_LST_USRENV, LB_INSERTSTRING, -1, (LPARAM)txt);
		Count++;
	}
	//	ユーザ環境変数(LINK)
	if (AjcRegHkCuEnvGet("LINK", &type, env, sizeof env)) {
		AjcSnPrintF(txt, sizeof txt, "LINK=%s", env);
		SendDlgItemMessage(hDlg, IDC_LST_USRENV, LB_INSERTSTRING, -1, (LPARAM)txt);
		Count++;
	}
	//	ユーザ環境変数(CL, LINK)横スクロールバー設定
	SubSetHoriExtentByAllItem(hDlg, IDC_LST_USRENV);
	//	ユーザ環境変数(CL, LINK)全て選択
	SendDlgItemMessage(hDlg, IDC_LST_USRENV, LB_SETSEL, TRUE, -1);

	//	ユーザ環境変数(PATH)
	if (AjcRegHkCuEnvGet("PATH", &type, env, sizeof env)) {
		if (p = strtok(env, ";")) {
			do {
				for (i = 0; i < MAX_DLLLST; i++) {
					strcpy(txt, p); AjcPathCat(txt, DllLst[i], sizeof txt);
					if (AjcPathExists(txt)) {
						strcpy(pv32, p); AjcPathCat(pv32, "AjrVersion32.exe", sizeof pv32);
						strcpy(pv64, p); AjcPathCat(pv64, "AjrVersion64.exe", sizeof pv64);
						if (AjcPathExists(pv32) || AjcPathExists(pv64)) {
							SendDlgItemMessage(hDlg, IDC_LST_USRPATH, LB_INSERTSTRING, -1, (LPARAM)p);
							Count++;
							break;
						}
					}
				}
			} while (p = strtok(NULL, ";"));
		}
	}
	//	ユーザ環境変数(PATH)横スクロールバー設定
	SubSetHoriExtentByAllItem(hDlg, IDC_LST_USRPATH);
	//	ユーザ環境変数(PATH)全て選択
	SendDlgItemMessage(hDlg, IDC_LST_USRPATH, LB_SETSEL, TRUE, -1);

	//	システム環境変数(CL)
	if (AjcRegHkLmEnvGet("CL", &type, env, sizeof env)) {
		AjcSnPrintF(txt, sizeof txt, "CL=%s", env);
		SendDlgItemMessage(hDlg, IDC_LST_SYSENV, LB_INSERTSTRING, -1, (LPARAM)txt);
		Count++;
	}
	//	システム環境変数(LINK)
	if (AjcRegHkLmEnvGet("LINK", &type, env, sizeof env)) {
		AjcSnPrintF(txt, sizeof txt, "LINK=%s", env);
		SendDlgItemMessage(hDlg, IDC_LST_SYSENV, LB_INSERTSTRING, -1, (LPARAM)txt);
		Count++;
	}
	//	システム環境変数(CL, LINK)横スクロールバー設定
	SubSetHoriExtentByAllItem(hDlg, IDC_LST_SYSENV);
	//	システム環境変数(CL, LINK)全て選択
	SendDlgItemMessage(hDlg, IDC_LST_SYSENV, LB_SETSEL, TRUE, -1);

	//	システム環境変数(PATH)
	if (AjcRegHkLmEnvGet("PATH", &type, env, sizeof env)) {
		if (p = strtok(env, ";")) {
			do {
				for (i = 0; i < MAX_DLLLST; i++) {
					strcpy(txt, p); AjcPathCat(txt, DllLst[i], sizeof txt);
					if (AjcPathExists(txt)) {
						strcpy(pv32, p); AjcPathCat(pv32, "AjrVersion32.exe", sizeof pv32);
						strcpy(pv64, p); AjcPathCat(pv64, "AjrVersion64.exe", sizeof pv64);
						if (AjcPathExists(pv32) || AjcPathExists(pv64)) {
							SendDlgItemMessage(hDlg, IDC_LST_SYSPATH, LB_INSERTSTRING, -1, (LPARAM)p);
							Count++;
							break;
						}
					}
				}
			} while (p = strtok(NULL, ";"));
		}
	}
	//	システム環境変数(PATH)横スクロールバー設定
	SubSetHoriExtentByAllItem(hDlg, IDC_LST_SYSPATH);
	//	システム環境変数(PATH)全て選択
	SendDlgItemMessage(hDlg, IDC_LST_SYSPATH, LB_SETSEL, TRUE, -1);

	//	.NETFramework アセンブリ参照
	//	For WIN32
	if (SysInfo.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL) {	
		//	CAjrCustCtrl
		if (AjcRegGet(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L32, NULL, &type, (VOP)env, sizeof env)) {
			AjcSnPrintF(txt, sizeof txt, "%s=%s", AJCMSIL_REGPATH_KEY, env);
			SendDlgItemMessage(hDlg, IDC_LST_ASMREF, LB_INSERTSTRING, -1, (LPARAM)txt);
			Count++;
		}
		//	AjaraControl
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_INCOLDLIB)) {
			if (AjcRegGet(HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\.NETFramework\\v4.0\\AssemblyFoldersEx\\AjaraControl", NULL, &type, (VOP)env, sizeof env)) {
				AjcSnPrintF(txt, sizeof txt, "AjaraControl=%s", env);
				SendDlgItemMessage(hDlg, IDC_LST_ASMREF, LB_INSERTSTRING, -1, (LPARAM)txt);
				Count++;
			}
		}
	}
	//	For WIN64
	else {
		//	CAjrCustCtrl
		if (AjcRegGet(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L64, NULL, &type, (VOP)env, sizeof env)) {
			AjcSnPrintF(txt, sizeof txt, "%s=%s", AJCMSIL_REGPATH_KEY, env);
			SendDlgItemMessage(hDlg, IDC_LST_ASMREF, LB_INSERTSTRING, -1, (LPARAM)txt);
			Count++;
		}
		//	AjaraControl
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_INCOLDLIB)) {
			if (AjcRegGet(HKEY_LOCAL_MACHINE, "SOFTWARE\\Wow6432Node\\Microsoft\\.NETFramework\\v4.0\\AssemblyFoldersEx\\AjaraControl", NULL, &type, (VOP)env, sizeof env)) {
				AjcSnPrintF(txt, sizeof txt, "AjaraControl=%s", env);
				SendDlgItemMessage(hDlg, IDC_LST_ASMREF, LB_INSERTSTRING, -1, (LPARAM)txt);
				Count++;
			}
		}
	}
	//	.NETFramework アセンブリ参照 横スクロールバー設定
	SubSetHoriExtentByAllItem(hDlg, IDC_LST_ASMREF);
	//	.NETFramework アセンブリ参照 全て選択
	SendDlgItemMessage(hDlg, IDC_LST_ASMREF, LB_SETSEL, TRUE, -1);

	if (Count != 0) {
		AjcEnableDlgItem(hDlg, IDC_CMD_DEL, TRUE);
	}
	else {
		AjcEnableDlgItem(hDlg, IDC_CMD_DEL, FALSE);
		AjcTipTextShowCenter(hDlg, AJCLNGSEL("\n\n\n  クリーンアップ項目はありません。  \n\n\n", "\n\n\n  There are no cleanup items.  \n\n\n"), 10000, AjcGetStockFont(AJCFID_VAR14));
	}

	return TRUE;
}
//----- 「クリーンアップ」ボタン -------------------------------------------------------------------------------//
//	ユーザ環境変数(CL,LINK)クリーンアップ
static	VO		cbUsrEnv(BCP pTxt) {
	BCP		p;
	if (p = strtok(pTxt, "=")) {
		AjcRegHkCuEnvDel(p);
	}
}
//	ユーザ環境変数(PATH)クリーンアップ
static	VO		cbUsrPath(BCP pTxt) {
	AjcRegHkCuEnvDelPathItem(pTxt, FALSE);
}
//	システム環境変数(CL,LINK)クリーンアップ
static	VO		cbSysEnv(BCP pTxt) {
	BCP		p;
	if (p = strtok(pTxt, "=")) {
		AjcRegHkLmEnvDel(p);
	}
}
//	システム環境変数(PATH)クリーンアップ
static	VO		cbSysPath(BCP pTxt) {
	AjcRegHkLmEnvDelPathItem(pTxt, FALSE);
}
//	.NET アセンブリ参照クリーンアップ
static	VO		cbAsmRef(BCP pTxt) {
	BC			path[MAX_PATH];
	BCP			pPath;
	BCP			pKey;

	AjcGetDlgItemStr(hDlgMain, IDC_TXT_ASMREF, path, sizeof path);
	if (pPath = strtok(path, "/")) {
		if (pPath = strtok(NULL, "\0")) {
			if (pKey = strtok(pTxt, "=")) {
				AjcRegDelSubKey(HKEY_LOCAL_MACHINE, pPath, pKey);
			}
		}
	}
}
//	リスト検索ボディ
static	VO		SearchList(HWND hDlg, int id, VO (*cb)(BCP pTxt))
{
	int		i;
	BC		txt[16384];

	for (i = (int)SendDlgItemMessage(hDlg, id, LB_GETCOUNT, 0, 0) - 1; i >= 0; i--) {
		if (SendDlgItemMessage(hDlg, id, LB_GETSEL, i, 0)) {
			SendDlgItemMessage(hDlg, id, LB_GETTEXT, i, (LPARAM)txt);
			cb(txt);
			SendDlgItemMessage(hDlg, id, LB_DELETESTRING, i, 0);
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJC_DLGPROC(Main, IDC_CMD_DEL	)
{
	if (MessageBox(hDlg, AJCLNGSEL("選択されているインストール情報をクリーンアップします。\n\n   よろしいですか？",
								   "Cleans up the selected installation information.\\n  Are you sure?"), "AjrUCleanup", MB_YESNO) == IDYES) {
		//	ユーザ環境変数(CL, LINK)クリーンアップ
		SearchList(hDlg, IDC_LST_USRENV , cbUsrEnv);
		//	ユーザ環境変数(PATH)クリーンアップ
		SearchList(hDlg, IDC_LST_USRPATH, cbUsrPath);
		//	システム環境変数(CL, PATH)クリーンアップ
		SearchList(hDlg, IDC_LST_SYSENV , cbSysEnv);
		//	システム環境変数(PATH)クリーンアップ
		SearchList(hDlg, IDC_LST_SYSPATH, cbSysPath);
		//	.NET アセンブリ参照クリーンアップ
		SearchList(hDlg, IDC_LST_ASMREF, cbAsmRef);
	}
	return TRUE;
}
//----- 「？」ボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HELP	)
{
	//説明メッセージ
	AjcTipTextShowCenter(hDlg, 
		AJCLNGSEL(	"\n"
					" 「クリーンアップ項目の検索」ボタンを押すと、インストール情報を検索し選択表示します。\n"
					" 「クリーンアップ」ボタンを押すと、選択されているインストール情報をクリーンアップします。\n"
					"  クリーンアップしない項目は、クリックして選択状態を解除してください。\n"
					"\n"
					" ※ インストールや、手動インストールを行った場合等でインストール情報が\n"
					" 　  散在する場合、本ツールで一括してクリーンアップすることができます。\n"
					"\n"
					" ※ このメッセージは６０秒で消えますが、表示を継続するにはメッセージ上にカーソルを置いて下さい。\n"
					" 　  このメッセージを消すには、メッセージ上をクリックしてください。\n"
					,
					"\n"
					" Click the 'Search Cleanup Items' button to search for and select the installation information.\n"
					" Press the 'Cleanup' button to clean up the selected installation information.\n"
					" Deselect (click) any items that you do not want to clean up.\n"
					"\n"
					" * If the installation information is scattered due to installation or manual installation,\n"
					"   you can clean up all at once with this tool.\n"
					" * Click on this message and the message will disappear.\n"
					"\n"
		), 
		60000, AjcGetStockFont(AJCFID_VAR14));

	return TRUE;
}
//----- 「終了」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	UX	dwReturnValue;

	AjcEnableDlgItem(hDlg, IDOK 	  , FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_DEL, FALSE);
	AjcEnableDlgItem(hDlg, IDCANCEL   , FALSE);
	EnableWindow(hDlg, FALSE);

	AjcTipTextShowCenter(hDlg, AJCLNGSEL("\n\n\n  終了処理中です  \n\n\n", "\n\n\n  There are no cleanup items.  \n\n\n"), 10000, AjcGetStockFont(AJCFID_VAR14));
	AjcDoEvent();

	//	環境変数有効化
	SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, (LPARAM) "Environment", SMTO_ABORTIFHUNG, 5000, (PDWORD_PTR)&dwReturnValue);

	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY		)

	AJC_DLGMAP_CMD(Main, IDOK			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_DEL	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_HELP	)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	リストボックス項目中の文字列の最大表示ビット数設定															//
//--------------------------------------------------------------------------------------------------------------//
static	UI		SubSetHoriExtentByAllItem(HWND hDlg, UI id)
{
	int		rc = 0;
	int		ext;
	HDC		hdc;
	int		i, n;
	HWND	hLbx = GetDlgItem(hDlg, id);
	HFONT	hFSv = NULL;
	BC		txt[16384];

	hdc = GetDC(hLbx);
	hFSv = (HFONT)SelectObject(hdc, (HFONT)SendMessage(hLbx, WM_GETFONT, 0, 0));

	if ((n = (int)SendMessage(hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		for (i = 0; i < n; i++) {
			SendMessage(hLbx, LB_GETTEXT, i, (LPARAM)txt);
			ext = SubGetHoriExtentByStr(hdc, txt);
			rc = __max(rc, ext);
		}
	}
	SelectObject(hdc, hFSv);
	ReleaseDC(hLbx, hdc);

	SendMessage(hLbx, LB_SETHORIZONTALEXTENT, rc, 0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	文字列の表示ビット数取得																					//
//--------------------------------------------------------------------------------------------------------------//
static	UI		SubGetHoriExtentByStr(HDC hdc, C_BCP pStr)
{
	SIZE		sz, cw;

	cw.cx = 0;
	GetTextExtentPoint32(hdc, "W", 1, &cw);

	sz.cx = 0;
	GetTextExtentPoint32(hdc, pStr, (int)strlen(pStr), &sz);

	return sz.cx + cw.cx;
}
