﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>
#include	<Shlwapi.h>
#include	<time.h>
#include	<stdio.h>

#define	NOT_VOLATILE	FALSE

/*
		NOTE :	インストール時のカスタム動作では、HKEY_CURRENT_USER にアクセスできない。
				環境変数の設定は、全てHKEY_LOCAL_MACHINE への書き込みとする
*/

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	fLogMsg = TRUE;
static	BC		AppName[] = "AjrInstall";
static	BC		MyPath[MAX_PATH];
static	BC		ErrTxt[4096] = {0};

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIsInstallAllUser(VO);

static	BOOL	DelEnvCL	 (VO);
static	BOOL	DelEnvLINK	 (VO);
static	BOOL	DelEnvPATH	 (VO);
static	BOOL	DelAsmRefInfo(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	UX	dwReturnValue;

	//----- ライブラリ初期化 -----------------------------------------------------------------------------------//
	MAjcInit();

	do {
		//----- コマンドライン・オプション解析（ /NoMsg が指定されていればエラーをログ表示しない）--------------//
		if (AjcStrIStr(szCmdLine, "/NoMsg")) {
			fLogMsg = FALSE;
		}

		//----- 自プログラムのフォルダパス取得 -----------------------------------------------------------------//
		AjcGetAppPath(MyPath, MAX_PATH);

		//----- 環境変数の項目削除(INCLUDE, LIB, PATH) ---------------------------------------------------------//
		DelEnvCL  ();
		DelEnvLINK();
		DelEnvPATH();

		//----- 環境変数を有効化 -------------------------------------------------------------------------------//
		SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, (LPARAM)"Environment", SMTO_ABORTIFHUNG, 5000, (PDWORD_PTR)&dwReturnValue);

		//----- .NETアセンブリ参照設定 -------------------------------------------------------------------------//
		DelAsmRefInfo();

		//----- エラーメッセージ -------------------------------------------------------------------------------//
		if (fLogMsg) {
			if (ErrTxt[0] == 0) {
				MessageBox(NULL, AJCLNGSEL("インストール情報を消去しました。",
										   "You have completed the installation information settings."), "AjrUninst", MB_OK);
			}
			else {
				MessageBox(NULL, ErrTxt, "AjrUninst", MB_ICONERROR);
			}
		}

	} while(0);

	return 0;
}

//--------------------------------------------------------------------------------------------------------------//
//	ＣＬ環境変数の削除（CL の /I オプション）																	//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	DelEnvCL(VO)
{
	BOOL	rc = FALSE;
	UI		err;
	BC		TmpPath[MAX_PATH];
	BC		IncPath[MAX_PATH];
	BC		ParamCL[MAX_PATH + 16];

	//	INCLUDE パス設定
	AjcSnPrintF(TmpPath, sizeof TmpPath, "%s..\\inc", MyPath);
	if (PathCombine(IncPath, TmpPath, NULL) == NULL) {
		strcpy(IncPath, TmpPath);
	}
	//	CLの /I オプション作成
	AjcSnPrintF(ParamCL, sizeof ParamCL, "/I\"%s\"", IncPath);

	//	CL環境変数のパス項目削除
//	if (AjcIsInstallAllUser()) {
		if (AjcRegIsKeyExist (HKEY_LOCAL_MACHINE,  "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "CL", &err)) {
			rc = AjcRegHkLmEnvDelItemA("CL", ParamCL, ' ', TRUE);
		}
		else if (err == ERROR_FILE_NOT_FOUND) {
			rc = TRUE;
		}
//	}
//	else {
//		if (AjcRegIsKeyExist(HKEY_CURRENT_USER, "Environment", "CL", &err)) {
//			rc = AjcRegHkCuEnvDelItemA("CL", ParamCL, ' ', TRUE);
//		}
//		else if (err == ERROR_FILE_NOT_FOUND) {
//			rc = TRUE;
//		}
//	}
	//	エラーメッセージ
	if (!rc) {
		strcat(ErrTxt, AJCLNGSEL("インクルードパスの削除を失敗しました。\n",
								 "Failed to remove /I option from CL environment variable.\n"));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＬＩＮＫ環境変数の削除（LINK の LIBPATH オプション）														//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	DelEnvLINK(VO)
{
	BOOL	rc = FALSE;
	UI		err;
	BC		ParamLINK[MAX_PATH + 16];

	//	LINKのLIBPATHオプション作成
	AjcSnPrintF(ParamLINK, sizeof ParamLINK, "/LIBPATH:\"%s\"", MyPath);

	//	LINK環境変数の削除
//	if (AjcIsInstallAllUser()) {
		if (AjcRegIsKeyExist (HKEY_LOCAL_MACHINE,  "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "LINK", &err)) {
			rc = AjcRegHkLmEnvDelItemA("LINK", ParamLINK, ' ', TRUE);
		}
		else if (err == ERROR_FILE_NOT_FOUND) {
			rc = TRUE;
		}
//	}
//	else {
//		if (AjcRegIsKeyExist(HKEY_CURRENT_USER, "Environment", "LINK", &err)) {
//			rc = AjcRegHkCuEnvDelItemA("LINK", ParamLINK, ' ', TRUE);
//		}
//		else if (err == ERROR_FILE_NOT_FOUND) {
//			rc = TRUE;
//		}
//	}
	//	エラーメッセージ
	if (!rc) {
		strcat(ErrTxt, AJCLNGSEL("ライブラリパスの削除を失敗しました。\n",
								 "Failed to remove path from LINK environment variable.\n"));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＰＡＴＨ環境変数の削除																						//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	DelEnvPATH(VO)
{
	BOOL	rc = FALSE;
	UI		err;

	//	PATH 環境変のパス項目削除
//	if (AjcIsInstallAllUser()) {
		if (AjcRegIsKeyExist (HKEY_LOCAL_MACHINE,  "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "PATH", &err)) {
			rc = AjcRegHkLmEnvDelPathItem(MyPath, FALSE);
		}
		else if (err == ERROR_FILE_NOT_FOUND) {
			rc = TRUE;
		}
//	}
//	else {
//		if (AjcRegIsKeyExist(HKEY_CURRENT_USER, "Environment", "PATH", &err)) {
//			rc = AjcRegHkCuEnvDelPathItem(MyPath, FALSE);
//		}
//		else if (err == ERROR_FILE_NOT_FOUND) {
//			rc = TRUE;
//		}
//	}
	//	エラーメッセージ
	if (!rc) {
		strcat(ErrTxt, AJCLNGSEL("実行パス(PATH)の削除を失敗しました。\n",
								 "Failed to remove path from PATH environment variable.\n"));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	アセンブリの参照情報削除																					//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	DelAsmRefInfo(VO)
{
	BOOL		rc = FALSE;
	UI			err;
	SYSTEM_INFO	si;

	GetNativeSystemInfo(&si);

	//	For WIN32
	if (si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL) {
		if (AjcRegIsPathExist	(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L32, &err)) {
			rc = AjcRegDelSubKey(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_S32, AJCMSIL_REGPATH_KEY);
		}
		else if (err == ERROR_FILE_NOT_FOUND) {
			rc = TRUE;
		}
	}
	//	For WIN64
	else {
		if (AjcRegIsPathExist	(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_L64, &err)) {
			rc = AjcRegDelSubKey(HKEY_LOCAL_MACHINE, AJCMSIL_REGPATH_S64, AJCMSIL_REGPATH_KEY);
		}
		else if (err == ERROR_FILE_NOT_FOUND) {
			rc = TRUE;
		}
	}
	//	エラーメッセージ
	if (!rc) {
		strcat(ErrTxt,	AJCLNGSEL(".NETアセンブリ参照の消去を失敗しました。\n",
								  "Clearing .NET assembly reference failed.\n"));
	}

	return rc;
}
