﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>

#include	<stdio.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE	hInst		= NULL;			//	ＤＬＬインスタンスハンドル
static	HWND		hDlgMain	= NULL;			//	ダイアログボックスハンドル
static	HBITMAP		hBmp		= NULL;
static	HICON		hIcon		= NULL;
static	BC			VersionStr[64];

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	LRESULT	CALLBACK DlgMainProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG			msg;

	hInst = hInstance;

	//----- バージョン文字列設定 -----------------------//
	strcpy(VersionStr, AjcGetVerStr());

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)DlgMainProc);
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
static	LRESULT	CALLBACK DlgMainProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	BOOL		rc = FALSE;
	SYSTEMTIME	lt;

	switch (msg) {

		//===== WM_INITDIALOG ==================================================================================//
		case WM_INITDIALOG:
			hIcon = LoadIcon(hInst, MAKEINTRESOURCE(IDI_APPICON));
			SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
			AjcChangeBitmapColor(hBmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_APPMARK)), RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
			SendDlgItemMessage(hDlg, IDC_PIC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmp);
			SetWindowText(hDlg, AJCLNGSEL("バージョン ( WinCustLib )", "Version ( WinCustLib )"));
			SetDlgItemText(hDlg, IDC_LBL_TTL, AJCLNGSEL("Windows カスタム ライブラリ", "Windows custom library"));
			SetDlgItemText(hDlg, IDC_LBL_VER, AJCLNGSEL("バージョン", "Version"));
			SetDlgItemText(hDlg, IDC_TXT_VER, VersionStr);
			GetLocalTime(&lt);
			AjcSetDlgItemUInt(hDlg, IDC_LBL_YEAR, lt.wYear);
			AjcMoveWindowToCenter(hDlg);
			rc = TRUE;
			break;

		//===== WM_DESTROY =====================================================================================//
		case WM_DESTROY:
			DeleteObject(hIcon);
			DeleteObject(hBmp);
			PostQuitMessage(0);
			rc = TRUE;
			break;

		//===== WM_COMMAND =====================================================================================//
		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				//----- ＯＫボタン -----------------------------------------------------------------------------//
				case IDOK:
					DestroyWindow(hDlg);
					rc = TRUE;
					break;
				//----- キャンセルボタン -----------------------------------------------------------------------//
				case IDCANCEL:
					DestroyWindow(hDlg);
					rc = TRUE;
					break;
			}
			break;
	}
	return rc;
}
