﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using AjaraInit;

namespace CAjrCustCtrl
{
	[ToolboxBitmap(typeof(CAjrCPrePro), "CAjrCPrePro.bmp")]
	public partial class CAjrCPrePro : Component
	{
		//----- 外部へのイベント --------------------------//
		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Occurs ahead of other events.")]
		public event PpcEvtNtcAnyEvt		OnNtcAnyEvt;		private PpcCbkNtcAnyEvt		  m_PpcCbkNtcAnyEvt;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies the file name and line number currently being processed.")]
		public event PpcEvtNtcFileLno		OnNtcFileLno;		private PpcCbkNtcFileLno	  m_PpcCbkNtcFileLno;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies that the search for include files has started.")]
		public event PpcEvtNtcSrhStart		OnNtcSrhStart;		private PpcCbkNtcSrhStart	  m_PpcCbkNtcSrnStart;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies the search directory of include files.")]
		public event PpcEvtNtcSrhDir		OnNtcSrhDir;		private PpcCbkNtcSrhDir		  m_PpcCbkNtcSrhDir;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies that the include file search in the directory has been completed.")]
		public event PpcEvtNtcSrhEnd		OnNtcSrhEnd;		private PpcCbkNtcSrhEnd		  m_PpcCbkNtcSrhEnd;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies optional symbols for conditional compilation.")]
		public event PpcEvtNtcOptSym		OnNtcOptSym;		private PpcCbkNtcOptSym		  m_PpcCbkNtcOptSym;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies that a macro definition has been detected.")]
		public event PpcEvtNtcMacDef		OnNtcMacDef;		private PpcCbkNtcMacDef		  m_PpcCbkNtcMacDef;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies that a macro reference has been detected.")]
		public event PpcEvtNtcMacRef		OnNtcMacRef;		private PpcCbkNtcMacRef		  m_PpcCbkNtcMacRef;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies that the precompiled result is being output to a file. (This notification is frequently notified during file output.)")]
		public event PpcEvtNtcOutput		OnNtcOutput;		private PpcCbkNtcOutput		  m_PpcCbkNtcOutput;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies that an error was detected during precompilation.")]
		public event PpcEvtNtcError			OnNtcError;			private PpcCbkNtcError		  m_PpcCbkNtcError;

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Notifies the text encoding of the source file.")]
		public event PpcEvtNtcSrcTec		OnNtcSrcTec;		private PpcCbkNtcSrcTec		  m_PpcCbkNtcSrcTec;

		//======================================================================================================//
		//	ワーク																								//
		//======================================================================================================//
		private IntPtr			m_hPpc		= (IntPtr)0;
		private EPpcOption		m_Option	= EPpcOption.ALL;
		private bool			m_fExpInc	= true;
		private	ETextEncode		m_EncodeR	= ETextEncode.TEC_AUTO;

		//======================================================================================================//
		//	コンストラクタ																						//
		//======================================================================================================//
		//	コンストラクタ（１）
		public CAjrCPrePro()
		{
			InitializeComponent();
			InitOnConstruct();
		}
		//	コンストラクタ（２）
		public CAjrCPrePro(IContainer container)
		{
			container.Add(this);
			InitializeComponent();
			InitOnConstruct();
		}
		//	初期化
		private void InitOnConstruct()
		{
			//	ライブラリ初期化
			CAjrInit.Init();

			//	プリコンパイルインスタンス設定
			m_hPpc		   = CAjrApi.AjcPpcCreateForMSIL();

			//	コールバックインスタンス生成
			m_PpcCbkNtcAnyEvt	= new PpcCbkNtcAnyEvt	(cbNtcAnyEvt	);
			m_PpcCbkNtcFileLno	= new PpcCbkNtcFileLno	(cbNtcFileLno	);
			m_PpcCbkNtcSrnStart	= new PpcCbkNtcSrhStart	(cbNtcSrhStart	);
			m_PpcCbkNtcSrhDir	= new PpcCbkNtcSrhDir	(cbNtcSrhDir	);
			m_PpcCbkNtcSrhEnd	= new PpcCbkNtcSrhEnd	(cbNtcSrhEnd	);
			m_PpcCbkNtcOptSym	= new PpcCbkNtcOptSym	(cbNtcOptSym	);
			m_PpcCbkNtcMacDef	= new PpcCbkNtcMacDef	(cbNtcMacDef	);
			m_PpcCbkNtcMacRef	= new PpcCbkNtcMacRef	(cbNtcMacRef	);
			m_PpcCbkNtcOutput	= new PpcCbkNtcOutput	(cbNtcOutput	);
			m_PpcCbkNtcError	= new PpcCbkNtcError	(cbNtcError		);
			m_PpcCbkNtcSrcTec	= new PpcCbkNtcSrcTec	(cbNtcSrcTec	);

			//	終了処理登録
			this.Disposed += OnUnloadMyControl;
		}
		//----- 終了処理 ---------------------------------------------------------------------------------------//
		private void OnUnloadMyControl(object sender, EventArgs e)
		{
			if (m_hPpc != (IntPtr)0) {
				CAjrApi.AjcPpcDeleteForMSIL(m_hPpc);
				m_hPpc = (IntPtr)0;
			}
		}
		//======================================================================================================//
		//	プロパティ																							//
		//======================================================================================================//
		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Pre-compile option.")]
		public EPpcOption Option
		{
			set {m_Option = value;}
			get { return m_Option;}
		}

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Output contents of include file.")]
		public bool fExpInc
		{
			set {m_fExpInc = value;}
			get { return m_fExpInc;}
		}

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Text encode at reading.")]
		public ETextEncode TextEncodeAtRead
		{
			set {
					if (value != ETextEncode.TEC_MBC		&&
						value != ETextEncode.TEC_UTF_8		&&
						value != ETextEncode.TEC_EUC_J		&&
						value != ETextEncode.TEC_UTF_16LE	&&
						value != ETextEncode.TEC_UTF_16BE	&&
						value != ETextEncode.TEC_AUTO) {
						throw new ArgumentException("Invalid property TextEncodeAtRead = " + ((int)value).ToString() + ".");
					}
					else{
						m_EncodeR = value;
					}
				}

			get {
					return m_EncodeR;
				}
		}

		[System.ComponentModel.Category("AjrCPrePro")]
		[System.ComponentModel.Description("Error message text.(Can be read only during the OnNtcError event)")]
		public string	ErrorMessaageText
		{
			get {return CAjrApi.AjcPpcGetErrMsgTextForMSIL();}
		}

		//======================================================================================================//
		//	メソッド																							//
		//======================================================================================================//
		//----- Delete -----------------------------------------------------------------------------------------//
		public	void Delete()
		{
			CAjrApi.AjcPpcDeleteForMSIL(m_hPpc);
		}
		//----- SetBasePath ------------------------------------------------------------------------------------//
		public	void SetBasePath(string BasePath)
		{
			CAjrApi.AjcPpcSetBasePath(m_hPpc, BasePath);
		}

		//----- SetOptSym --------------------------------------------------------------------------------------//
		public	void SetOptSym(string[] OptSym)
		{
			CAjrApi.AjcPpcOptSymReset(m_hPpc);
			CAjrApi.AjcPpcOptSymCreate(m_hPpc, (int)OptSym.Length);
			for (int i = 0; i < (int)OptSym.Length; i++) {
				CAjrApi.AjcPpcOptSymSet(m_hPpc, i, OptSym[i]);
			}
		}
		//----- SetIncPath -------------------------------------------------------------------------------------//
		public	void SetIncPath(string[] IncPath)
		{
			CAjrApi.AjcPpcIncPathReset(m_hPpc);
			CAjrApi.AjcPpcIncPathCreate(m_hPpc, (int)IncPath.Length);
			for (int i = 0; i < (int)IncPath.Length; i++) {
				CAjrApi.AjcPpcIncPathSet(m_hPpc, i, IncPath[i]);
			}
		}

		//----- SetCallBack				------------------------------------------------------------------------//
		public void SetCbNtcAnyEvt	(PpcCbkNtcAnyEvt   cb) {CAjrApi.AjcPpcSetCbNtcAnyEvt  (m_hPpc, cb);}
		public void SetCbNtcFileLno (PpcCbkNtcFileLno  cb) {CAjrApi.AjcPpcSetCbNtcFileLno (m_hPpc, cb);}
		public void SetCbNtcSrhStart(PpcCbkNtcSrhStart cb) {CAjrApi.AjcPpcSetCbNtcSrhStart(m_hPpc, cb);}
		public void SetCbNtcSrhDir	(PpcCbkNtcSrhDir   cb) {CAjrApi.AjcPpcSetCbNtcSrhDir  (m_hPpc, cb);}
		public void SetCbNtcSrhEnd	(PpcCbkNtcSrhEnd   cb) {CAjrApi.AjcPpcSetCbNtcSrhEnd  (m_hPpc, cb);}
		public void SetCbNtcOptSym	(PpcCbkNtcOptSym   cb) {CAjrApi.AjcPpcSetCbNtcOptSym  (m_hPpc, cb);}
		public void SetCbNtcMacDef	(PpcCbkNtcMacDef   cb) {CAjrApi.AjcPpcSetCbNtcMacDef  (m_hPpc, cb);}
		public void SetCbNtcMacRef	(PpcCbkNtcMacRef   cb) {CAjrApi.AjcPpcSetCbNtcMacRef  (m_hPpc, cb);}
		public void SetCbNtcOutput	(PpcCbkNtcOutput   cb) {CAjrApi.AjcPpcSetCbNtcOutput  (m_hPpc, cb);}
		public void SetCbNtcError	(PpcCbkNtcError    cb) {CAjrApi.AjcPpcSetCbNtcError	  (m_hPpc, cb);}
		public void SetCbNtcSrcTec	(PpcCbkNtcSrcTec   cb) {CAjrApi.AjcPpcSetCbNtcSrcTec  (m_hPpc, cb);}

		//----- PreCompile				------------------------------------------------------------------------//
		public	EPpcResult	PreCompile(string SrcPath, string OutPath)
		{
			EPpcResult rc;
			//	オプション設定
			CAjrApi.AjcPpcSetOption(m_hPpc, m_Option);
			//	ソースファイルのテキストエンコード設定
			CAjrApi.AjcPpcSetTextEncode(m_hPpc, m_EncodeR);
			//	イベント用コールバック登録
			if (OnNtcAnyEvt		!= null) {CAjrApi.AjcPpcSetCbNtcAnyEvt	(m_hPpc, m_PpcCbkNtcAnyEvt	);}
			if (OnNtcFileLno	!= null) {CAjrApi.AjcPpcSetCbNtcFileLno (m_hPpc, m_PpcCbkNtcFileLno	);}
			if (OnNtcSrhStart	!= null) {CAjrApi.AjcPpcSetCbNtcSrhStart(m_hPpc, m_PpcCbkNtcSrnStart);}
			if (OnNtcSrhDir		!= null) {CAjrApi.AjcPpcSetCbNtcSrhDir	(m_hPpc, m_PpcCbkNtcSrhDir	);}
			if (OnNtcSrhEnd		!= null) {CAjrApi.AjcPpcSetCbNtcSrhEnd	(m_hPpc, m_PpcCbkNtcSrhEnd	);}
			if (OnNtcOptSym		!= null) {CAjrApi.AjcPpcSetCbNtcOptSym	(m_hPpc, m_PpcCbkNtcOptSym	);}
			if (OnNtcMacDef		!= null) {CAjrApi.AjcPpcSetCbNtcMacDef	(m_hPpc, m_PpcCbkNtcMacDef	);}
			if (OnNtcMacRef		!= null) {CAjrApi.AjcPpcSetCbNtcMacRef	(m_hPpc, m_PpcCbkNtcMacRef	);}
			if (OnNtcOutput		!= null) {CAjrApi.AjcPpcSetCbNtcOutput	(m_hPpc, m_PpcCbkNtcOutput	);}
			if (OnNtcError		!= null) {CAjrApi.AjcPpcSetCbNtcError	(m_hPpc, m_PpcCbkNtcError	);}
			if (OnNtcSrcTec		!= null) {CAjrApi.AjcPpcSetCbNtcSrcTec	(m_hPpc, m_PpcCbkNtcSrcTec	);}

			//	プリコンパイル実行
			if ((rc = CAjrApi.AjcPpcCompileForMSIL(m_hPpc, SrcPath)) == EPpcResult.OK) {
				if (OutPath != null && OutPath != "") {
					ETextEncode		tec;
					EBomMode		bom;
					//	ソースファイルのエンコード取得
					CAjrApi.AjcPpcGetTextEncode(m_hPpc, out tec, out bom);
					//	プリコンパイル出力ファイルのエンコード設定
					CAjrApi.AjcPpcSetTecAtTokenStreamToFile(m_hPpc, tec, bom);
					//	プリコンパイル結果をファイルへ出力
					if (!CAjrApi.AjcPpcTokenStreamToFileForMSIL(m_hPpc, OutPath, m_fExpInc)) {
						rc = EPpcResult.OUTFILE;
					}
				}
				//	トークンストリーム解放
				CAjrApi.AjcPpcReleaseObject(m_hPpc);
			}
			return rc;
		}

		//----- Stop -------------------------------------------------------------------------------------------//
		public	void	Stop()
		{
			CAjrApi.AjcPpcStop(m_hPpc);
		}
		//------------------------------------------------------------------------------------------------------//
		//	コールバック																						//
		//------------------------------------------------------------------------------------------------------//
		//----- コールバック関数（いずれかのイベント発生通知）-------------------------------------------------//
		private void cbNtcAnyEvt(EPpcNtc EvtId)
		{
			PpcArgNtcAnyEvt eva = new PpcArgNtcAnyEvt();
			if (OnNtcAnyEvt != null) {
				eva.EvtId = EvtId;
				OnNtcAnyEvt(this, eva);
			}
		}
		//----- コールバック関数（現在処理中のファイル名，行番号通知）------------------------------------------//
		private void cbNtcFileLno(string FileName, int lno, int nest)
		{
			PpcArgNtcFileLno eva = new PpcArgNtcFileLno();
			if (OnNtcFileLno != null) {
				eva.FileName = FileName;
				eva.lno 	 = lno;
				eva.nest	 = nest;
				OnNtcFileLno(this, eva);
			}
		}
		//----- コールバック関数（インクルードファイル検索開始通知）------------------------------------------//
		private void cbNtcSrhStart(string IncName, string TopPath)
		{
			PpcArgNtcSrhStart eva = new PpcArgNtcSrhStart();
			if (OnNtcSrhStart != null) {
				eva.IncName = IncName;
				eva.TopPath = TopPath;
				OnNtcSrhStart(this, eva);
			}
		}
		//----- コールバック関数（インクルードファイル検索フォルダ通知）---------------------------------------//
		private void cbNtcSrhDir(string IncName, string DirPath)
		{
			PpcArgNtcSrhDir eva = new PpcArgNtcSrhDir();
			if (OnNtcSrhDir != null) {
				eva.IncName = IncName;
				eva.DirPath	= DirPath;
				OnNtcSrhDir(this, eva);
			}
		}
		//----- コールバック関数（インクルードファイル検索終了通知）-------------------------------------------//
		private void cbNtcSrhEnd(string IncName, bool fFind)
		{
			PpcArgNtcSrhEnd eva = new PpcArgNtcSrhEnd();
			if (OnNtcSrhEnd!= null) {
				eva.IncName = IncName;
				eva.fFind	= fFind;
				OnNtcSrhEnd(this, eva);
			}
		}
		//----- コールバック関数（プリプロセス用オプションシンボル通知）----------------------------------------//
		private void cbNtcOptSym(string FilePath, int lno, string OptSym)
		{
			PpcArgNtcOptSym eva = new PpcArgNtcOptSym();
			if (OnNtcOptSym != null) {
				eva.FilePath = FilePath;
				eva.lno 	 = lno;
				eva.OptSym	 = OptSym;
				OnNtcOptSym(this, eva);
			}
		}
		//----- コールバック関数（マクロ定義通知 ）-------------------------------------------------------------//
		private void cbNtcMacDef(string FilePath, int lno, string MacName)
		{
			PpcArgNtcMacDef eva = new PpcArgNtcMacDef();
			if (OnNtcMacDef != null) {
				eva.FilePath = FilePath;
				eva.lno 	 = lno;
				eva.MacName  = MacName;
				OnNtcMacDef(this, eva);
			}
		}
		//----- コールバック関数（マクロ参照通知）--------------------------------------------------------------//
		private void cbNtcMacRef(string FilePath, int lno, string MacName)
		{
			PpcArgNtcMacRef eva = new PpcArgNtcMacRef();
			if (OnNtcMacRef != null) {
				eva.FilePath = FilePath;
				eva.lno 	 = lno;
				eva.MacName  = MacName;
				OnNtcMacRef(this, eva);
			}
		}
		//----- コールバック関数（トークンストリームをファイルへ出力中通知）------------------------------------//
		private void cbNtcOutput()
		{
			PpcArgNtcOutput eva = new PpcArgNtcOutput();
			if (OnNtcOutput != null) {
				eva.dummy	 = 0;
				OnNtcOutput(this, eva);
			}
		}
		//----- コールバック関数（エラー通知）------------------------------------------------------------------//
		private void cbNtcError(EPpcErr err, string FilePath, int lno, string param)
		{
			PpcArgNtcError eva = new PpcArgNtcError();
			if (OnNtcError != null) {
				eva.err 	 = err;
				eva.FilePath = FilePath;
				eva.lno 	 = lno;
				eva.param	 = param;
				OnNtcError(this, eva);
			}
		}

		//----- コールバック関数（ソースエンコード通知）--------------------------------------------------------//
		private void cbNtcSrcTec(string FilePath, ETextEncode tec, EBomMode bom)
		{
			PpcArgNtcSrcTec eva = new PpcArgNtcSrcTec();
			if (OnNtcSrcTec != null) {
				eva.FilePath = FilePath;
				eva.tec 	 = tec;
				eva.bom 	 = bom;
				OnNtcSrcTec(this, eva);
			}
		}

	}
}

