﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using AjaraInit;

namespace CAjrCustCtrl
{
	[ToolboxBitmap(typeof(CAjrCToken), "CAjrCToken.bmp")]
	public partial class CAjrCToken : Component
	{
		//----- 外部へのイベント --------------------------//
		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Request to read one line of source file.")]
		public event CtkEvtGetS OnGetS;
		private CtkCbkGetS	  m_CtkCbkGetS;

		//======================================================================================================//
		//	ワーク																								//
		//======================================================================================================//
		private IntPtr			m_hCtk	   = (IntPtr)0;
		private	int				m_TabWidth = 4;
		private object			m_cbParam  = null;

		private	const int		m_StkMax   = 32;
		private	int				m_StkIx    = 0;
		private	IntPtr[]		m_Stack    = new IntPtr[m_StkMax];

		//======================================================================================================//
		//	コンストラクタ																						//
		//======================================================================================================//
		//	コンストラクタ（１）
		public CAjrCToken()
		{
			InitializeComponent();
			InitOnConstruct();
		}
		//	コンストラクタ（２）
		public CAjrCToken(IContainer container)
		{
			container.Add(this);
			InitializeComponent();
			InitOnConstruct();
		}
		//	初期化
		private void InitOnConstruct()
		{
			//	ライブラリ初期化
			CAjrInit.Init();

			//	変数初期化
			m_hCtk		   = Create();

			//	後処理登録
			this.Disposed += OnUnloadMyControl;
		}
		//----- 終了処理 ---------------------------------------------------------------------------------------//
		private void OnUnloadMyControl(object sender, EventArgs e)
		{
			if (m_hCtk != (IntPtr)0) {
				CAjrApi.AjcCtkDelete(m_hCtk);
				m_hCtk = (IntPtr)0;
			}
		}
		//======================================================================================================//
		//	プロパティ																							//
		//======================================================================================================//
		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Tab width.")]
		public ECtkTabWidth TabWidth
		{
			set { if (value == ECtkTabWidth.TABW_2 || value == ECtkTabWidth.TABW_4 || value == ECtkTabWidth.TABW_8 || value == ECtkTabWidth.TABW_16) {
					  m_TabWidth = (int)value;
				  }
				}
			get { return (ECtkTabWidth)m_TabWidth;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Include C++ tokens.")]
		public bool optCPlusPlus
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f |	(uint)	ECtkOpt.CPLUSPLUS);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f &	(uint)~ECtkOpt.CPLUSPLUS);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.CPLUSPLUS) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Include spaces/line breaks/comments in tokens.")]
		public bool optIncSpace
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f |	(uint) ECtkOpt.INCSPACE);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f &	(uint)~ECtkOpt.INCSPACE);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.INCSPACE) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Include dollar sign ($) as symbol text.")]
		public bool optIncDollar
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f | (uint) ECtkOpt.INCSYM_DOLLAR);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f & (uint)~ECtkOpt.INCSYM_DOLLAR);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.INCSYM_DOLLAR) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Include at sign (@) as symbol character.")]
		public bool optIncAtMark
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f | (uint) ECtkOpt.INCSYM_ATMARK);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f & (uint)~ECtkOpt.INCSYM_ATMARK);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.INCSYM_ATMARK) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Include multibyte characters as symbol characters.")]
		public bool optIncMbs
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f | (uint) ECtkOpt.INCSYM_MBSTR);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f & (uint)~ECtkOpt.INCSYM_MBSTR);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.INCSYM_MBSTR) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Treat symbol + Dot(.) + number string as one symbol (Ex. P3.12).")]
		public bool optIncDotSym
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f | (uint) ECtkOpt.DOTSYMBOL);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f & (uint)~ECtkOpt.DOTSYMBOL);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.DOTSYMBOL) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Allow hexadecimal numbers in assembler notation (ending H, ex. 0FFH).")]
		public bool optIncAsmHex
		{
			set { uint f = CAjrApi.AjcCtkGetFlag(m_hCtk);	
				  if (value) CAjrApi.AjcCtkSetFlag(m_hCtk, f | (uint) ECtkOpt.ASMHEX);
				  else		 CAjrApi.AjcCtkSetFlag(m_hCtk, f & (uint)~ECtkOpt.ASMHEX);
				}
			get { return ((CAjrApi.AjcCtkGetFlag(m_hCtk) & (int)ECtkOpt.ASMHEX) != 0) ? true : false;}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Current token code.")]
		public ECtkCode CurToken
		{
			get	{ return CAjrApi.AjcCtkGetCurToken(m_hCtk);	}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Current suffix of numeric value.")]
		public ECtkSuf CurSuffix
		{
			get	{ return CAjrApi.AjcCtkGetCurSuffix(m_hCtk);	}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Current flag of token.")]
		public ECtkFlg CurFlag
		{
			get	{ return CAjrApi.AjcCtkGetCurFlag(m_hCtk);	}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Current Line number.")]
		public int CurLineNumber
		{
			get	{ return CAjrApi.AjcCtkGetCurLineNumber(m_hCtk);	}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Current digit position of token.")]
		public int CurPosition
		{
			get	{ return CAjrApi.AjcCtkGetCurPosition(m_hCtk, m_TabWidth);	}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Current error code.")]
		public ECtkError CurError
		{
			get	{ return CAjrApi.AjcCtkGetCurError(m_hCtk);	}
		}

		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Callback object parameter.")]
		public object cbParam
		{
			set { m_cbParam = value;}
			get	{ return m_cbParam;	}
		}

		//======================================================================================================//
		//	メソッド																							//
		//======================================================================================================//
		//----- Create					------------------------------------------------------------------------//
		private IntPtr Create()
		{
			IntPtr	rc;
			m_CtkCbkGetS = new CtkCbkGetS(cbGetS);
			rc = CAjrApi.AjcCtkCreate(m_CtkCbkGetS, (IntPtr)0);
			return rc;
		}
		//----- Reset					------------------------------------------------------------------------//
		public	void Reset()
		{
			CAjrApi.AjcCtkReset(m_hCtk);
		}
		//----- SetCallBack				------------------------------------------------------------------------//
		public	void SetCallBack(CtkCbkGetS cbGetS)
		{
			CAjrApi.AjcCtkSetCallBack(m_hCtk, cbGetS, (IntPtr)0);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	void SetCallBack(CtkCbkGetS cbGetS, IntPtr cbp)
		{
			CAjrApi.AjcCtkSetCallBack(m_hCtk, cbGetS, cbp);
		}
		//----- Delete					------------------------------------------------------------------------//
		public void Delete()
		{
			//	スタック上のインスrタンス消去
			while (m_StkIx > 1) {
				CAjrApi.AjcCtkDelete(m_Stack[m_StkIx]);
				m_StkIx--;
				m_hCtk = m_Stack[m_StkIx];
			}
			//	インスタンス消去
			CAjrApi.AjcCtkDelete(m_hCtk);
		}
		//----- GetToken				------------------------------------------------------------------------//
		public bool GetToken(out string syl)
		{
			return CAjrApi.AjcCtkGetToken(m_hCtk, out syl);
		}
		//----- PeekToken				------------------------------------------------------------------------//
		public bool PeekToken(out string syl)
		{
			return CAjrApi.AjcCtkPeekToken(m_hCtk, out syl);
		}
		//----- TokenString				------------------------------------------------------------------------//
		public string TokenString(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkGetTokenString(tkn);
		}
		//----- Push					------------------------------------------------------------------------//
		public	void	Push()
		{
			if (m_StkIx < m_StkMax - 1) {
				m_Stack[m_StkIx] = m_hCtk = CAjrApi.AjcCtkGetReplicatedHandle(m_hCtk);
				m_StkIx++;
			}
			else {
				throw new InvalidOperationException("Instance stack overflow.");
			}
		}
		//----- Pop						------------------------------------------------------------------------//
		public	void	Pop()
		{
			if (m_StkIx > 0) {
				CAjrApi.AjcCtkDelete(m_Stack[m_StkIx]);
				m_StkIx--;
				m_hCtk = m_Stack[m_StkIx];
			}
			else {
				throw new InvalidOperationException("Instance stack underflow.");
			}
		}

		//----- IsUserSymbol			------------------------------------------------------------------------//
		public bool IsUserSymbol(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsUsrSym(tkn);
		}

		//----- IsReservedSymbol		------------------------------------------------------------------------//
		public bool IsReservedSymbol(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsRsvSym(tkn);
		}

		//----- IsNumericValue			------------------------------------------------------------------------//
		public bool IsIsNumericValue(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsValue(tkn);
		}

		//----- IsString				------------------------------------------------------------------------//
		public bool IsString(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsString(tkn);
		}

		//----- IsPathName				------------------------------------------------------------------------//
		public bool IsPathName(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsPathName(tkn);
		}

		//----- IsDelimiter				------------------------------------------------------------------------//
		public bool IsDelimiter(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsDelimit(tkn);
		}

		//----- IsSymbol				------------------------------------------------------------------------//
		public bool IsSymbol(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsSymbol(tkn);
		}

		//----- IsValSym				------------------------------------------------------------------------//
		public bool IsValSym(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsValSym(tkn);
		}

		//----- IsSpace					------------------------------------------------------------------------//
		public bool IsSpace(ECtkCode tkn)
		{
			return CAjrApi.AjcCtkIsSpace(tkn);
		}

		//----- コールバック関数（１行読み出し）----------------------------------------------------------------//
		private bool cbGetS(IntPtr pBuf, int lBuf, IntPtr cbp)
		{
			bool rc = false;

			CtkArgGetS eva = new CtkArgGetS();
			if (OnGetS != null) {
				eva.pBuf = pBuf;
				eva.lBuf = lBuf;
				eva.cbp  = cbp;
				rc = OnGetS(this, eva);
			}
			return rc;
		}

	}
}

