﻿using System;
using System.IO;
using System.Reflection;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Runtime.InteropServices;
using AjaraInit;

namespace CAjrCustCtrl
{
	//----------------------------------------------------------------------------------------------------------//
	[System.Drawing.ToolboxBitmap(typeof(CAjrFileSearch), "CAjrFileSearch.bmp")]
	public partial class CAjrFileSearch : Component
	{
		//----- 外部へのイベント --------------------------//
		[System.ComponentModel.Category("AjrCToken")]
		[System.ComponentModel.Description("Notify a file found.")]
		public event FsrEvtFindFile 	  OnFindFile;
		private 	 FsrCbkFindFile m_FsrCbkFindFile;

		//----- コンストラクタ（１） ---------------------------------------------------------------------------//
		public CAjrFileSearch()
		{
			InitializeComponent();

			//	初期化
			InitOnConstruct();
		}

		//----- コンストラクタ（２） ---------------------------------------------------------------------------//
		public CAjrFileSearch(IContainer container)
		{
			container.Add(this);

			InitializeComponent();

			//	初期化
			InitOnConstruct();
		}
		//----- 初期化コード -----------------------------------------------------------------------------------//
		private void InitOnConstruct()
		{
			//	ライブラリ初期化
			CAjrInit.Init();

			//	イベントオブジェクト
			m_FsrCbkFindFile = new FsrCbkFindFile(cbGsrFindFile);
		}
		//======================================================================================================//
		//	API 	AjcFileSearch.h																				//
		//======================================================================================================//
		//----- AjcSetNtcSearchingDir		   -----------------------------------------------------------------//
		public void SetNtcSearchingDir(bool fNotify)
		{
			CAjrApi.AjcSetNtcSearchingDir(fNotify);
		}
		//----- AjcSearchFiles				   -----------------------------------------------------------------//
		public int SearchFiles(string dir, string wild, bool fSubDir, IntPtr cbp)
		{
			int	rc;
			rc = CAjrApi.AjcSearchFiles(dir, wild, fSubDir, cbp, m_FsrCbkFindFile);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public int SearchFiles(string dir, string wild, bool fSubDir)
		{
			return SearchFiles(dir, wild, fSubDir, (IntPtr)0);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public int SearchFiles(string dir, string wild, bool fSubDir, IntPtr cbp, FsrCbkFindFile cb)
		{
			int	rc;
			rc = CAjrApi.AjcSearchFiles(dir, wild, fSubDir, cbp, cb);
			return rc;
		}
		//----- AjcSearchMyComputer 		   -----------------------------------------------------------------//
		public int SearchMyComputer(string path, string wild, bool fRemote, IntPtr cbp)
		{
			int	rc;
			rc = CAjrApi.AjcSearchMyComputer(path, wild, fRemote, cbp, m_FsrCbkFindFile);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public int SearchMyComputer(string path, string wild, bool fRemote)
		{
			return SearchMyComputer(path, wild, fRemote, (IntPtr)0);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public int SearchMyComputer(string path, string wild, bool fRemote, IntPtr cbp, FsrCbkFindFile cb)
		{
			int	rc;
			rc = CAjrApi.AjcSearchMyComputer(path, wild, fRemote, cbp, cb);
			return rc;
		}
		//======================================================================================================//
		//	コールバック																						//
		//======================================================================================================//
		private bool cbGsrFindFile(int nest, string path, string file, EFileAtt att, uint ftime, IntPtr cbp)
		{
			bool rc = false;
			FsrArgFindFile eva = new FsrArgFindFile();
			eva.nest		   = nest;
			eva.PathName	   = path;
			eva.FileName	   = file;
			eva.FileAtt 	   = att;
			eva.FTime		   = ftime;
			eva.cbp			   = cbp;
			if (OnFindFile != null) {
				rc = OnFindFile(this, eva);
			}
			return rc;
		}
	}
}
