﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Reflection;
using CAjrCustCtrl;

//==============================================================================================================//
//																												//
//	ＤＬＬインタフェース モジュール																				//
//																												//
//==============================================================================================================//
namespace AjaraInit
{
	//----------------------------------------------------------------------------------------------------------//
	//																											//
	//	ＡＰＩ初期化																							//
	//																											//
	//----------------------------------------------------------------------------------------------------------//
	public static class CAjrInit
	{
		static private bool fFirstInit = true;

		public static bool Init()
		{
			bool	rc = true;

			if (fFirstInit) {
				fFirstInit = false;

				//	ＤＬＬ初期化関数
				CAjrApi.AjcInit();

				//	プロファイル記録先＝レジストリ	
				CAjrApi.AjcSetProfileIsRegistory(true);

				//	アイコン切り替え
				CAjrApi.AjcChangeIconToMsil();

			}
			return rc;
		}
	}
	//----------------------------------------------------------------------------------------------------------//
	//																											//
	//	ＤＬＬインタフェース																					//
	//																											//
	//----------------------------------------------------------------------------------------------------------//
	public static class CAjrApi
	{
		//======================================================================================================//
		//		● プロセス種別(32Bit / 64Bit)判断																//
		//======================================================================================================//
		private static bool Is32Bit()
		{
			return !Environment.Is64BitProcess;
		}

		//======================================================================================================//
		//	オブジェクトから IntPtr プロパティ取得																//
		//======================================================================================================//
		public static IntPtr GetPropIntPtr(object obj, string PropName)
		{
			IntPtr	rc;
			Type type = obj.GetType();
			PropertyInfo prop = type.GetProperty(PropName);
			rc = (IntPtr)prop.GetValue(obj, null);
			return rc;
		}

		//======================================================================================================//
		//	初期化																								//
		//======================================================================================================//
		//----- ●AjcInit --------------------------------------------------------------------------------------//
		public static void AjcInit()
		{
			if (Is32Bit()) A32Init(0, 0);
			else		   A64Init(0, 0);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcInit@8", ExactSpelling=true)]
		private static extern void A32Init(int dmy1, int dmy2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcInit", ExactSpelling=true)]
		private static extern void A64Init(int dmy1, int dmy2);

		//======================================================================================================//
		//	共通																								//
		//======================================================================================================//
		//----- 言語選択テキスト -------------------------------------------------------------------------------//
		static public string LngSel(string Jpn, string Eng)
		{
			string s;
			if (CAjrApi.AjcGetLangId() == ELangId.Japanese) {
				s = Jpn;
			}
			else {
				s = Eng;
			}
			return s;
		}
		//----- MakeFormatString（書式文字列作成）--------------------------------------------------------------//
		static public string MakeFormatString(string format, object[] args)
		{
			string	fmt;	//	書式記述子("{n...}")
			string	zer;	//	書式記述子のインデクスをゼロとした文字列("{0..."})
			string	rep;	//	書式変換した文字列
			string	rsu;	//	出力文字列
			int		ix;		//	書式インデクス

			//	作成文字列初期化
			rsu = format;
			//	Ｃ＃書式の "{{" と "}}" を 0xFFFA と 0xFFFB に変換した文字列作成
			rsu = CAjrApi.AjcMsilEncDblBrkt(rsu);
			//	単項の書式文字列作成
			fmt = CAjrApi.AjcMsilGetFormatItem (rsu, out ix);
			while (ix != -1) {
				//	Ｃ＃書式のインデクスを "0" にした文字列作成（ "{n:...}" --> "{0...}" ）
				if (ix == 0) zer = fmt;
				else		 zer = CAjrApi.AjcMsilFormatIxToZero(fmt);
				//	単項の書式変換
				rep = string.Format(zer, args[ix]);
				//	Ｃ＃書式用置換文字列の "{" と "}" を 0xFFFA と 0xFFFB に変換した文字列作成
				rep = CAjrApi.AjcMsilEncBrkt(rep);
				//	書式化した文字列変換
				rsu = rsu.Replace(fmt, rep);
				//	単項の書式文字列作成
				fmt = CAjrApi.AjcMsilGetFormatItem(rsu, out ix);
			}
			//	Ｃ＃書式結果文字列の "{" と "}" を 復元(0xFFFA -> "{", 0xFFFB -> "}")
			rsu = CAjrApi.AjcMsilRcvBrkt(rsu);

			return rsu;
		}

		//======================================================================================================//
		//	Ajc3dVec.h																							//
		//======================================================================================================//

		//----- ●AjcSin ---------------------------------------------------------------------------------------//
		public static double AjcSin(double degree)
		{
			double	rc;
			if (Is32Bit()) rc = A32Sin(degree);
			else		   rc = A64Sin(degree);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSin@8", ExactSpelling=true)]
		private static extern double A32Sin(double degree);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSin", ExactSpelling=true)]
		private static extern double A64Sin(double degree);

		//----- ●AjcSinh --------------------------------------------------------------------------------------//
		public static double AjcSinh(double degree)
		{
			double	rc;
			if (Is32Bit()) rc = A32Sinh(degree);
			else		   rc = A64Sinh(degree);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSinh@8", ExactSpelling=true)]
		private static extern double A32Sinh(double degree);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSinh", ExactSpelling=true)]
		private static extern double A64Sinh(double degree);

		//----- ●AjcASin --------------------------------------------------------------------------------------//
		public static double AjcASin(double x)
		{
			double	rc;
			if (Is32Bit()) rc = A32ASin(x);
			else		   rc = A64ASin(x);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcASin@8", ExactSpelling=true)]
		private static extern double A32ASin(double x);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcASin", ExactSpelling=true)]
		private static extern double A64ASin(double x);

		//----- ●AjcCos ---------------------------------------------------------------------------------------//
		public static double AjcCos(double degree)
		{
			double	rc;
			if (Is32Bit()) rc = A32Cos(degree);
			else		   rc = A64Cos(degree);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCos@8", ExactSpelling=true)]
		private static extern double A32Cos(double degree);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCos", ExactSpelling=true)]
		private static extern double A64Cos(double degree);

		//----- ●AjcCosh --------------------------------------------------------------------------------------//
		public static double AjcCosh(double degree)
		{
			double	rc;
			if (Is32Bit()) rc = A32Cosh(degree);
			else		   rc = A64Cosh(degree);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCosh@8", ExactSpelling=true)]
		private static extern double A32Cosh(double degree);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCosh", ExactSpelling=true)]
		private static extern double A64Cosh(double degree);

		//----- ●AjcACos --------------------------------------------------------------------------------------//
		public static double AjcACos(double x)
		{
			double	rc;
			if (Is32Bit()) rc = A32ACos(x);
			else		   rc = A64ACos(x);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcACos@8", ExactSpelling=true)]
		private static extern double A32ACos(double x);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcACos", ExactSpelling=true)]
		private static extern double A64ACos(double x);

		//----- ●AjcTan ---------------------------------------------------------------------------------------//
		public static double AjcTan(double degree)
		{
			double	rc;
			if (Is32Bit()) rc = A32Tan(degree);
			else		   rc = A64Tan(degree);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTan@8", ExactSpelling=true)]
		private static extern double A32Tan(double degree);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTan", ExactSpelling=true)]
		private static extern double A64Tan(double degree);

		//----- ●AjcTanh --------------------------------------------------------------------------------------//
		public static double AjcTanh(double degree)
		{
			double	rc;
			if (Is32Bit()) rc = A32Tanh(degree);
			else		   rc = A64Tanh(degree);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTanh@8", ExactSpelling=true)]
		private static extern double A32Tanh(double degree);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTanh", ExactSpelling=true)]
		private static extern double A64Tanh(double degree);

		//----- ●AjcATan --------------------------------------------------------------------------------------//
		public static double AjcATan(double x)
		{
			double	rc;
			if (Is32Bit()) rc = A32ATan(x);
			else		   rc = A64ATan(x);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcATan@8", ExactSpelling=true)]
		private static extern double A32ATan(double x);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcATan", ExactSpelling=true)]
		private static extern double A64ATan(double x);

		//----- ●AjcATan2 -------------------------------------------------------------------------------------//
		public static double AjcATan2(double y, double x)
		{
			double	rc;
			if (Is32Bit()) rc = A32ATan2(y, x);
			else		   rc = A64ATan2(y, x);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcATan2@16", ExactSpelling=true)]
		private static extern double A32ATan2(double y, double x);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcATan2", ExactSpelling=true)]
		private static extern double A64ATan2(double y, double x);

		//
		//	３Ｄベクトル演算
		//

		//----- ●AjcV3dAdd ------------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dAdd(AJC3DVEC v1, AJC3DVEC v2)
		{
			AJC3DVEC	vr;
			if (Is32Bit()) A32V3dAdd(ref v1, ref v2, out vr);
			else		   A64V3dAdd(ref v1, ref v2, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dAdd@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dAdd(ref AJC3DVEC pV1, ref AJC3DVEC pV2, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dAdd", ExactSpelling=true)]
		private static extern IntPtr A64V3dAdd(ref AJC3DVEC pV1, ref AJC3DVEC pV2, out AJC3DVEC pR);

		//----- ●AjcV3dSub ------------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dSub(AJC3DVEC v1, AJC3DVEC v2)
		{
			AJC3DVEC	vr;
			if (Is32Bit()) A32V3dSub(ref v1, ref v2, out vr);
			else		   A64V3dSub(ref v1, ref v2, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dSub@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dSub(ref AJC3DVEC pV1, ref AJC3DVEC pV2, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dSub", ExactSpelling=true)]
		private static extern IntPtr A64V3dSub(ref AJC3DVEC pV1, ref AJC3DVEC pV2, out AJC3DVEC pR);

		//----- ●AjcV3dMult -----------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dMult(AJC3DVEC v, double n)
		{
			AJC3DVEC vr;
			if (Is32Bit()) A32V3dMult(ref v, n, out vr);
			else		   A64V3dMult(ref v, n, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dMult@16", ExactSpelling=true)]
		private static extern IntPtr A32V3dMult(ref AJC3DVEC pV, double n, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dMult", ExactSpelling=true)]
		private static extern IntPtr A64V3dMult(ref AJC3DVEC pV, double n, out AJC3DVEC pR);

		//----- ●AjcV3dDiv ------------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dDiv(AJC3DVEC v, double n)
		{
			AJC3DVEC	vr;
			if (Is32Bit()) A32V3dDiv(ref v, n, out vr);
			else		   A64V3dDiv(ref v, n, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dDiv@16", ExactSpelling=true)]
		private static extern IntPtr A32V3dDiv(ref AJC3DVEC pV, double n, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dDiv", ExactSpelling=true)]
		private static extern IntPtr A64V3dDiv(ref AJC3DVEC pV, double n, out AJC3DVEC pR);

		//----- ●AjcV3dSetLineVec -----------------------------------------------------------------------------//
		public static AJC3DLVEC AjcV3dSetLineVec(AJC3DVEC p1, AJC3DVEC p2)
		{
			AJC3DLVEC vr;
			if (Is32Bit()) A32V3dSetLineVec(ref p1, ref p2, out vr);
			else		   A64V3dSetLineVec(ref p1, ref p2, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dSetLineVec@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dSetLineVec(ref AJC3DVEC p1, ref AJC3DVEC p2, out AJC3DLVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dSetLineVec", ExactSpelling=true)]
		private static extern IntPtr A64V3dSetLineVec(ref AJC3DVEC pV, ref AJC3DVEC p2, out AJC3DLVEC pR);

		//----- ●AjcV3dSetLinePoint ---------------------------------------------------------------------------//
		public static AJC3DLINE AjcV3dSetLinePoint(AJC3DVEC p1, AJC3DVEC p2)
		{
			AJC3DLINE vr;
			if (Is32Bit()) A32V3dSetLinePoint(ref p1, ref p2, out vr);
			else		   A64V3dSetLinePoint(ref p1, ref p2, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dSetLinePoint@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dSetLinePoint(ref AJC3DVEC p1, ref AJC3DVEC p2, out AJC3DLINE pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dSetLinePoint", ExactSpelling=true)]
		private static extern IntPtr A64V3dSetLinePoint(ref AJC3DVEC p1, ref AJC3DVEC p2, out AJC3DLINE pR);

		//----- ●AjcV3dSetTriPoint ----------------------------------------------------------------------------//
		public static AJC3DTRI AjcV3dSetTriPoint(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3)
		{
			AJC3DTRI tri;
			if (Is32Bit()) A32V3dSetTriPoint(ref p1, ref p2, ref p3, out tri);
			else		   A64V3dSetTriPoint(ref p1, ref p2, ref p3, out tri);
			return tri;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dSetTriPoint@16", ExactSpelling=true)]
		private static extern IntPtr A32V3dSetTriPoint(ref AJC3DVEC p1, ref AJC3DVEC p2, ref AJC3DVEC p3, out AJC3DTRI pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dSetTriPoint", ExactSpelling=true)]
		private static extern IntPtr A64V3dSetTriPoint(ref AJC3DVEC p1, ref AJC3DVEC p2, ref AJC3DVEC p3, out AJC3DTRI pR);

		//----- ●AjcV3dLength ---------------------------------------------------------------------------------//
		public static double AjcV3dLength(AJC3DVEC v)
		{
			double	rc;
			if (Is32Bit()) rc = A32V3dLength(ref v);
			else		   rc = A64V3dLength(ref v);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dLength@4", ExactSpelling=true)]
		private static extern double A32V3dLength(ref AJC3DVEC pV);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dLength", ExactSpelling=true)]
		private static extern double A64V3dLength(ref AJC3DVEC pV);

		//----- ●AjcV3dLVecCenter -----------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dLVecCenter(AJC3DLVEC vl)
		{
			AJC3DVEC pc;
			if (Is32Bit()) A32V3dLVecCenter(ref vl, out pc);
			else		   A64V3dLVecCenter(ref vl, out pc);
			return pc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dLVecCenter@8", ExactSpelling=true)]
		private static extern double A32V3dLVecCenter(ref AJC3DLVEC pV, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dLVecCenter", ExactSpelling=true)]
		private static extern double A64V3dLVecCenter(ref AJC3DLVEC pV, out AJC3DVEC pR);

		//----- ●AjcV3dLineCenter -----------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dLineCenter(AJC3DLINE vl)
		{
			AJC3DVEC pc;
			if (Is32Bit()) A32V3dLineCenter(ref vl, out pc);
			else		   A64V3dLineCenter(ref vl, out pc);
			return pc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dLineCenter@8", ExactSpelling=true)]
		private static extern double A32V3dLineCenter(ref AJC3DLINE pV, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dLineCenter", ExactSpelling=true)]
		private static extern double A64V3dLineCenter(ref AJC3DLINE pV, out AJC3DVEC pR);

		//----- ●AjcV3dOuter ----------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dOuter(AJC3DVEC v1, AJC3DVEC v2)
		{
			AJC3DVEC vo;
			if (Is32Bit()) A32V3dOuter(ref v1, ref v2, out vo);
			else		   A64V3dOuter(ref v1, ref v2, out vo);
			return vo;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dOuter@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dOuter(ref AJC3DVEC pV1, ref AJC3DVEC pV2, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dOuter", ExactSpelling=true)]
		private static extern IntPtr A64V3dOuter(ref AJC3DVEC pV1, ref AJC3DVEC pV2, out AJC3DVEC pR);

		//----- ●AjcV3dInner ----------------------------------------------------------------------------------//
		public static double AjcV3dInner(AJC3DVEC v1, AJC3DVEC v2)
		{
			double	rc;
			if (Is32Bit()) rc = A32V3dInner(ref v1, ref v2);
			else		   rc = A64V3dInner(ref v1, ref v2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dInner@8", ExactSpelling=true)]
		private static extern double A32V3dInner(ref AJC3DVEC pV1, ref AJC3DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dInner", ExactSpelling=true)]
		private static extern double A64V3dInner(ref AJC3DVEC pV1, ref AJC3DVEC pV2);

		//----- ●AjcV3dPlaneVec -------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dPlaneVec(AJC3DTRI tri)
		{
			AJC3DVEC vh;
			if (Is32Bit()) A32V3dPlaneVec(ref tri, out vh);
			else		   A64V3dPlaneVec(ref tri, out vh);
			return vh;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dPlaneVec@8", ExactSpelling=true)]
		private static extern IntPtr A32V3dPlaneVec(ref AJC3DTRI pV, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dPlaneVec", ExactSpelling=true)]
		private static extern IntPtr A64V3dPlaneVec(ref AJC3DTRI pV, out AJC3DVEC pR);

		//----- ●AjcV3dNormal ---------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dNormal(AJC3DVEC v)
		{
			AJC3DVEC vu;
			if (Is32Bit()) A32V3dNormal(ref v, out vu);
			else		   A64V3dNormal(ref v, out vu);
			return vu;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dNormal@8", ExactSpelling=true)]
		private static extern IntPtr A32V3dNormal(ref AJC3DVEC pV, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dNormal", ExactSpelling=true)]
		private static extern IntPtr A64V3dNormal(ref AJC3DVEC pV, out AJC3DVEC pR);

		//----- ●AjcV3dTheta ----------------------------------------------------------------------------------//
		public static double AjcV3dTheta(AJC3DVEC v1, AJC3DVEC v2)
		{
			double	rc;
			if (Is32Bit()) rc = A32V3dTheta(ref v1, ref v2);
			else		   rc = A64V3dTheta(ref v1, ref v2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dTheta@8", ExactSpelling=true)]
		private static extern double A32V3dTheta(ref AJC3DVEC pV1, ref AJC3DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dTheta", ExactSpelling=true)]
		private static extern double A64V3dTheta(ref AJC3DVEC pV1, ref AJC3DVEC pV2);

		//----- ●AjcV3dVertVecP2L -----------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dVertVecP2L(AJC3DLVEC vl, AJC3DVEC pt)
		{
			AJC3DVEC vr;
			if (Is32Bit()) A32V3dVertVecP2L(ref vl, ref pt, out vr);
			else		   A64V3dVertVecP2L(ref vl, ref pt, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dVertVecP2L@12", ExactSpelling=true)]
		private static extern double A32V3dVertVecP2L(ref AJC3DLVEC pL, ref AJC3DVEC pt, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dVertVecP2L", ExactSpelling=true)]
		private static extern double A64V3dVertVecP2L(ref AJC3DLVEC pL, ref AJC3DVEC pt, out AJC3DVEC pR);

		//----- ●AjcV3dDistP2L --------------------------------------------------------------------------------//
		public static double AjcV3dDistP2L(AJC3DLVEC vl, AJC3DVEC pt, out AJC3DVEC vr)
		{
			double	rc;
			if (Is32Bit()) rc = A32V3dDistP2L(ref vl, ref pt, out vr);
			else		   rc = A64V3dDistP2L(ref vl, ref pt, out vr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dDistP2L@12", ExactSpelling=true)]
		private static extern double A32V3dDistP2L(ref AJC3DLVEC pL, ref AJC3DVEC pP, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dDistP2L", ExactSpelling=true)]
		private static extern double A64V3dDistP2L(ref AJC3DLVEC pL, ref AJC3DVEC pP, out AJC3DVEC pR);

		//----- ●AjcV3dDistP2P --------------------------------------------------------------------------------//
		public static double AjcV3dDistP2P(AJC3DVEC p1, AJC3DVEC p2)
		{
			double	rc;
			if (Is32Bit()) rc = A32V3dDistP2P(ref p1, ref p2);
			else		   rc = A64V3dDistP2P(ref p1, ref p2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dDistP2P@8", ExactSpelling=true)]
		private static extern double A32V3dDistP2P(ref AJC3DVEC pV1, ref AJC3DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dDistP2P", ExactSpelling=true)]
		private static extern double A64V3dDistP2P(ref AJC3DVEC pV1, ref AJC3DVEC pV2);

		//----- ●AjcV3dCrossL2L -------------------------------------------------------------------------------//

		//----- ●AjcV3dCrossL2LEx -----------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dCrossL2LEx(AJC3DLVEC vl1, AJC3DLVEC vl2)
		{
			AJC3DVEC px;
			if (Is32Bit()) A32V3dCrossL2LEx(ref vl1, ref vl2, out px);
			else		   A64V3dCrossL2LEx(ref vl1, ref vl2, out px);
			return px;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dCrossL2LEx@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dCrossL2LEx(ref AJC3DLVEC pL1, ref AJC3DLVEC pL2, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dCrossL2LEx", ExactSpelling=true)]
		private static extern IntPtr A64V3dCrossL2LEx(ref AJC3DLVEC pL1, ref AJC3DLVEC pL2, out AJC3DVEC pR);

		//----- ●AjcV3dCrossP2F -------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dCrossP2F(AJC3DLVEC vl, AJC3DVEC pt)
		{
			AJC3DVEC px;
			if (Is32Bit()) A32V3dCrossP2F(ref vl, ref pt, out px);
			else		   A64V3dCrossP2F(ref vl, ref pt, out px);
			return px;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dCrossP2F@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dCrossP2F(ref AJC3DLVEC pL, ref AJC3DVEC pP, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dCrossP2F", ExactSpelling=true)]
		private static extern IntPtr A64V3dCrossP2F(ref AJC3DLVEC pL, ref AJC3DVEC pP, out AJC3DVEC pR);

		//----- ●AjcV3dOrthoVecOnPlane ------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dOrthoVecOnPlane(AJC3DLINE vl, AJC3DVEC vh)
		{
			AJC3DVEC vx;
			if (Is32Bit()) A32V3dOrthoVecOnPlane(ref vl, ref vh, out vx);
			else		   A64V3dOrthoVecOnPlane(ref vl, ref vh, out vx);
			return vx;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dOrthoVecOnPlane@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dOrthoVecOnPlane(ref AJC3DLINE pL, ref AJC3DVEC vh, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dOrthoVecOnPlane", ExactSpelling=true)]
		private static extern IntPtr A64V3dOrthoVecOnPlane(ref AJC3DLINE pL, ref AJC3DVEC vh, out AJC3DVEC pR);

		//----- ●AjcV3dMultMat --------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dMultMat(AJC3DVEC v, AJC3DMAT m)
		{
			AJC3DVEC vr;
			if (Is32Bit()) A32V3dMultMat(ref v, ref m, out vr);
			else		   A64V3dMultMat(ref v, ref m, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dMultMat@12", ExactSpelling=true)]
		private static extern IntPtr A32V3dMultMat(ref AJC3DVEC v, ref AJC3DMAT m, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dMultMat", ExactSpelling=true)]
		private static extern IntPtr A64V3dMultMat(ref AJC3DVEC v, ref AJC3DMAT m, out AJC3DVEC pR);

		//----- ●AjcV3dRotateX --------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dRotateX(AJC3DVEC pt, double t)
		{
			AJC3DVEC pr;
			if (Is32Bit()) A32V3dRotateX(ref pt, t, out pr);
			else		   A64V3dRotateX(ref pt, t, out pr);
			return pr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dRotateX@16", ExactSpelling=true)]
		private static extern IntPtr A32V3dRotateX(ref AJC3DVEC pV, double t, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dRotateX", ExactSpelling=true)]
		private static extern IntPtr A64V3dRotateX(ref AJC3DVEC pV, double t, out AJC3DVEC pR);

		//----- ●AjcV3dRotateY --------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dRotateY(AJC3DVEC pt, double t)
		{
			AJC3DVEC pr;
			if (Is32Bit()) A32V3dRotateY(ref pt, t, out pr);
			else		   A64V3dRotateY(ref pt, t, out pr);
			return pr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dRotateY@16", ExactSpelling=true)]
		private static extern IntPtr A32V3dRotateY(ref AJC3DVEC pV, double t, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dRotateY", ExactSpelling=true)]
		private static extern IntPtr A64V3dRotateY(ref AJC3DVEC pV, double t, out AJC3DVEC pR);

		//----- ●AjcV3dRotateZ --------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dRotateZ(AJC3DVEC pt, double t)
		{
			AJC3DVEC pr;
			if (Is32Bit()) A32V3dRotateZ(ref pt, t, out pr);
			else		   A64V3dRotateZ(ref pt, t, out pr);
			return pr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dRotateZ@16", ExactSpelling=true)]
		private static extern IntPtr A32V3dRotateZ(ref AJC3DVEC pV, double t, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dRotateZ", ExactSpelling=true)]
		private static extern IntPtr A64V3dRotateZ(ref AJC3DVEC pV, double t, out AJC3DVEC pR);

		//----- ●AjcV3dRotateAny ------------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dRotateAny(AJC3DVEC pt, double t, AJC3DVEC vs)
		{
			AJC3DVEC pr;
			if (Is32Bit()) A32V3dRotateAny(ref pt, t, ref vs, out pr);
			else		   A64V3dRotateAny(ref pt, t, ref vs, out pr);
			return pr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dRotateAny@20", ExactSpelling=true)]
		private static extern IntPtr A32V3dRotateAny(ref AJC3DVEC pV, double t, ref AJC3DVEC pAny, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dRotateAny", ExactSpelling=true)]
		private static extern IntPtr A64V3dRotateAny(ref AJC3DVEC pV, double t, ref AJC3DVEC pAny, out AJC3DVEC pR);

		//----- ●AjcV3dAnyOrthoVec ----------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dAnyOrthoVec(AJC3DVEC v)
		{
			AJC3DVEC vr;
			if (Is32Bit()) A32V3dAnyOrthoVec(ref v, out vr);
			else		   A64V3dAnyOrthoVec(ref v, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dAnyOrthoVec@8", ExactSpelling=true)]
		private static extern IntPtr A32V3dAnyOrthoVec(ref AJC3DVEC pV, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dAnyOrthoVec", ExactSpelling=true)]
		private static extern IntPtr A64V3dAnyOrthoVec(ref AJC3DVEC pV, out AJC3DVEC pR);

		//----- ●AjcV3dRotateOnPlane --------------------------------------------------------------------------//
		public static AJC3DVEC AjcV3dRotateOnPlane(AJC3DVEC pt, AJC3DLVEC vl, double t)
		{
			AJC3DVEC pr;
			if (Is32Bit()) A32V3dRotateOnPlane(ref pt, ref vl, t, out pr);
			else		   A64V3dRotateOnPlane(ref pt, ref vl, t, out pr);
			return pr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dRotateOnPlane@20", ExactSpelling=true)]
		private static extern IntPtr A32V3dRotateOnPlane(ref AJC3DVEC pP, ref AJC3DLVEC pC, double theta, out AJC3DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dRotateOnPlane", ExactSpelling=true)]
		private static extern IntPtr A64V3dRotateOnPlane(ref AJC3DVEC pP, ref AJC3DLVEC pC, double theta, out AJC3DVEC pR);

		//----- ●AjcV3dCalcCircle -----------------------------------------------------------------------------//

		//----- ●AjcV3dCalcCircleEx ---------------------------------------------------------------------------//

		//----- ●AjcV3dCalcCircleV ----------------------------------------------------------------------------//

		//----- ●AjcV3dCalcCircleVEx --------------------------------------------------------------------------//
		public static double AjcV3dCalcCircleVEx(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, out AJC3DVEC vc, out AJC3DVEC vh, out AJC3DCIRINFO ci)
		{
			double			r;
			if (Is32Bit()) r = A32V3dCalcCircleVEx(ref p1, ref p2, ref p3, out vc, out vh, out ci);
			else		   r = A64V3dCalcCircleVEx(ref p1, ref p2, ref p3, out vc, out vh, out ci);
			return r;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dCalcCircleVEx@24", ExactSpelling=true)]
		private static extern double A32V3dCalcCircleVEx(ref AJC3DVEC p1, ref AJC3DVEC p2, ref AJC3DVEC p3, out AJC3DVEC vc, out AJC3DVEC vh, out AJC3DCIRINFO cif);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dCalcCircleVEx", ExactSpelling=true)]
		private static extern double A64V3dCalcCircleVEx(ref AJC3DVEC p1, ref AJC3DVEC p2, ref AJC3DVEC p3, out AJC3DVEC vc, out AJC3DVEC vh, out AJC3DCIRINFO cif);

		//----- ●AjcV3dCalcSphere -----------------------------------------------------------------------------//

		//----- ●AjcV3dCalcSphereEx ---------------------------------------------------------------------------//

		//----- ●AjcV3dCalcSphereV ----------------------------------------------------------------------------//

		//----- ●AjcV3dCalcSphereVEx --------------------------------------------------------------------------//
		public static double AjcV3dCalcSphereVEx(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, AJC3DVEC p4, out AJC3DVEC vc, out AJC3DSPHINFO si)
		{
			double			r;
			if (Is32Bit()) r = A32V3dCalcSphereVEx(ref p1, ref p2, ref p3, ref p4, out vc, out si);
			else		   r = A64V3dCalcSphereVEx(ref p1, ref p2, ref p3, ref p4, out vc, out si);
			return r;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV3dCalcSphereVEx@24", ExactSpelling=true)]
		private static extern double A32V3dCalcSphereVEx(ref AJC3DVEC p1, ref AJC3DVEC p2, ref AJC3DVEC p3, ref AJC3DVEC p4, out AJC3DVEC vc, out AJC3DSPHINFO sif);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV3dCalcSphereVEx", ExactSpelling=true)]
		private static extern double A64V3dCalcSphereVEx(ref AJC3DVEC p1, ref AJC3DVEC p2, ref AJC3DVEC p3, ref AJC3DVEC p4, out AJC3DVEC vc, out AJC3DSPHINFO sif);

		//
		//	２Ｄベクトル演算
		//
		//----- ●AjcV2dAdd ------------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dAdd(AJC2DVEC v1, AJC2DVEC v2)
		{
			AJC2DVEC	vr;
			if (Is32Bit()) A32V2dAdd(ref v1, ref v2, out vr);
			else		   A64V2dAdd(ref v1, ref v2, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dAdd@12", ExactSpelling=true)]
		private static extern IntPtr A32V2dAdd(ref AJC2DVEC pV1, ref AJC2DVEC pV2, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dAdd", ExactSpelling=true)]
		private static extern IntPtr A64V2dAdd(ref AJC2DVEC pV1, ref AJC2DVEC pV2, out AJC2DVEC pR);

		//----- ●AjcV2dSub ------------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dSub(AJC2DVEC v1, AJC2DVEC v2)
		{
			AJC2DVEC	vr;
			if (Is32Bit()) A32V2dSub(ref v1, ref v2, out vr);
			else		   A64V2dSub(ref v1, ref v2, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dSub@12", ExactSpelling=true)]
		private static extern IntPtr A32V2dSub(ref AJC2DVEC pV1, ref AJC2DVEC pV2, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dSub", ExactSpelling=true)]
		private static extern IntPtr A64V2dSub(ref AJC2DVEC pV1, ref AJC2DVEC pV2, out AJC2DVEC pR);

		//----- ●AjcV2dMult -----------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dMult(AJC2DVEC v, double n)
		{
			AJC2DVEC vr;
			if (Is32Bit()) A32V2dMult(ref v, n, out vr);
			else		   A64V2dMult(ref v, n, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dMult@16", ExactSpelling=true)]
		private static extern IntPtr A32V2dMult(ref AJC2DVEC pV, double n, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dMult", ExactSpelling=true)]
		private static extern IntPtr A64V2dMult(ref AJC2DVEC pV, double n, out AJC2DVEC pR);

		//----- ●AjcV2dDiv ------------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dDiv(AJC2DVEC v, double n)
		{
			AJC2DVEC	vr;
			if (Is32Bit()) A32V2dDiv(ref v, n, out vr);
			else		   A64V2dDiv(ref v, n, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dDiv@16", ExactSpelling=true)]
		private static extern IntPtr A32V2dDiv(ref AJC2DVEC pV, double n, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dDiv", ExactSpelling=true)]
		private static extern IntPtr A64V2dDiv(ref AJC2DVEC pV, double n, out AJC2DVEC pR);

		//----- ●AjcV2dLength ---------------------------------------------------------------------------------//
		public static double AjcV2dLength(AJC2DVEC v)
		{
			double	rc;
			if (Is32Bit()) rc = A32V2dLength(ref v);
			else		   rc = A64V2dLength(ref v);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dLength@4", ExactSpelling=true)]
		private static extern double A32V2dLength(ref AJC2DVEC pV);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dLength", ExactSpelling=true)]
		private static extern double A64V2dLength(ref AJC2DVEC pV);

		//----- ●AjcV2dOuter ----------------------------------------------------------------------------------//
		public static double AjcV2dOuter(AJC2DVEC v1, AJC2DVEC v2)
		{
			double rc;
			if (Is32Bit()) rc = A32V2dOuter(ref v1, ref v2);
			else		   rc = A64V2dOuter(ref v1, ref v2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dOuter@8", ExactSpelling=true)]
		private static extern double A32V2dOuter(ref AJC2DVEC pV1, ref AJC2DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dOuter", ExactSpelling=true)]
		private static extern double A64V2dOuter(ref AJC2DVEC pV1, ref AJC2DVEC pV2);

		//----- ●AjcV2dInner ----------------------------------------------------------------------------------//
		public static double AjcV2dInner(AJC2DVEC v1, AJC2DVEC v2)
		{
			double	rc;
			if (Is32Bit()) rc = A32V2dInner(ref v1, ref v2);
			else		   rc = A64V2dInner(ref v1, ref v2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dInner@8", ExactSpelling=true)]
		private static extern double A32V2dInner(ref AJC2DVEC pV1, ref AJC2DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dInner", ExactSpelling=true)]
		private static extern double A64V2dInner(ref AJC2DVEC pV1, ref AJC2DVEC pV2);

		//----- ●AjcV2dNormal ---------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dNormal(AJC2DVEC v)
		{
			AJC2DVEC vu;
			if (Is32Bit()) A32V2dNormal(ref v, out vu);
			else		   A64V2dNormal(ref v, out vu);
			return vu;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dNormal@8", ExactSpelling=true)]
		private static extern IntPtr A32V2dNormal(ref AJC2DVEC pV, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dNormal", ExactSpelling=true)]
		private static extern IntPtr A64V2dNormal(ref AJC2DVEC pV, out AJC2DVEC pR);

		//----- ●AjcV2dTheta ----------------------------------------------------------------------------------//
		public static double AjcV2dTheta(AJC2DVEC v1, AJC2DVEC v2)
		{
			double	rc;
			if (Is32Bit()) rc = A32V2dTheta(ref v1, ref v2);
			else		   rc = A64V2dTheta(ref v1, ref v2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dTheta@8", ExactSpelling=true)]
		private static extern double A32V2dTheta(ref AJC2DVEC pV1, ref AJC2DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dTheta", ExactSpelling=true)]
		private static extern double A64V2dTheta(ref AJC2DVEC pV1, ref AJC2DVEC pV2);

		//----- ●AjcV2dVertVecP2L -----------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dVertVecP2L(AJC2DLVEC vl, AJC2DVEC pt)
		{
			AJC2DVEC vr;
			if (Is32Bit()) A32V2dVertVecP2L(ref vl, ref pt, out vr);
			else		   A64V2dVertVecP2L(ref vl, ref pt, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dVertVecP2L@12", ExactSpelling=true)]
		private static extern double A32V2dVertVecP2L(ref AJC2DLVEC pL, ref AJC2DVEC pt, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dVertVecP2L", ExactSpelling=true)]
		private static extern double A64V2dVertVecP2L(ref AJC2DLVEC pL, ref AJC2DVEC pt, out AJC2DVEC pR);

		//----- ●AjcV2dDistP2L --------------------------------------------------------------------------------//
		public static double AjcV2dDistP2L(AJC2DLVEC vl, AJC2DVEC pt, out AJC2DVEC vr)
		{
			double	rc;
			if (Is32Bit()) rc = A32V2dDistP2L(ref vl, ref pt, out vr);
			else		   rc = A64V2dDistP2L(ref vl, ref pt, out vr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dDistP2L@12", ExactSpelling=true)]
		private static extern double A32V2dDistP2L(ref AJC2DLVEC pL, ref AJC2DVEC pP, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dDistP2L", ExactSpelling=true)]
		private static extern double A64V2dDistP2L(ref AJC2DLVEC pL, ref AJC2DVEC pP, out AJC2DVEC pR);

		//----- ●AjcV2dDistP2P --------------------------------------------------------------------------------//
		public static double AjcV2dDistP2P(AJC2DVEC p1, AJC2DVEC p2)
		{
			double	rc;
			if (Is32Bit()) rc = A32V2dDistP2P(ref p1, ref p2);
			else		   rc = A64V2dDistP2P(ref p1, ref p2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dDistP2P@8", ExactSpelling=true)]
		private static extern double A32V2dDistP2P(ref AJC2DVEC pV1, ref AJC2DVEC pV2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dDistP2P", ExactSpelling=true)]
		private static extern double A64V2dDistP2P(ref AJC2DVEC pV1, ref AJC2DVEC pV2);

		//----- ●AjcV2dCrossL2L -------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dCrossL2LEx(AJC2DLVEC vl1, AJC2DLVEC vl2)
		{
			AJC2DVEC px;
			if (Is32Bit()) A32V2dCrossL2LEx(ref vl1, ref vl2, out px);
			else		   A64V2dCrossL2LEx(ref vl1, ref vl2, out px);
			return px;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dCrossL2L@12", ExactSpelling=true)]
		private static extern IntPtr A32V2dCrossL2LEx(ref AJC2DLVEC pL1, ref AJC2DLVEC pL2, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dCrossL2L", ExactSpelling=true)]
		private static extern IntPtr A64V2dCrossL2LEx(ref AJC2DLVEC pL1, ref AJC2DLVEC pL2, out AJC2DVEC pR);

		//----- ●AjcV2dRotate ---------------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dRotate(AJC2DVEC pt, double t)
		{
			AJC2DVEC pr;
			if (Is32Bit()) A32V2dRotate(ref pt, t, out pr);
			else		   A64V2dRotate(ref pt, t, out pr);
			return pr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dRotate@16", ExactSpelling=true)]
		private static extern IntPtr A32V2dRotate(ref AJC2DVEC pV, double t, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dRotate", ExactSpelling=true)]
		private static extern IntPtr A64V2dRotate(ref AJC2DVEC pV, double t, out AJC2DVEC pR);

		//----- ●AjcV2dAnyOrthoVec ----------------------------------------------------------------------------//
		public static AJC2DVEC AjcV2dAnyOrthoVec(AJC2DVEC v)
		{
			AJC2DVEC vr;
			if (Is32Bit()) A32V2dAnyOrthoVec(ref v, out vr);
			else		   A64V2dAnyOrthoVec(ref v, out vr);
			return vr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcV2dAnyOrthoVec@8", ExactSpelling=true)]
		private static extern IntPtr A32V2dAnyOrthoVec(ref AJC2DVEC pV, out AJC2DVEC pR);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcV2dAnyOrthoVec", ExactSpelling=true)]
		private static extern IntPtr A64V2dAnyOrthoVec(ref AJC2DVEC pV, out AJC2DVEC pR);

		//======================================================================================================//
		//	AjcAvlTree.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcBitmap.h 																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcCheckSum.h																						//
		//======================================================================================================//

		//----- ●AjcCalcByteSum -------------------------------------------------------------------------------//

		//----- ●AjcCalcByteSumN ------------------------------------------------------------------------------//
		unsafe public static byte AjcCalcByteSumN(void *p, int len)
		{
			byte	rc;
			if (Is32Bit()) rc = A32CalcByteSumN(p, len);
			else		   rc = A64CalcByteSumN(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static char AjcCalcByteSumN(IntPtr p, int len)
		{
			char	rc;
			if (Is32Bit()) rc = A32CalcByteSumN(p, len);
			else		   rc = A64CalcByteSumN(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcByteSumN@8", ExactSpelling=true)]
		unsafe private static extern byte A32CalcByteSumN(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcByteSumN@8", ExactSpelling=true)]
		private static extern char A32CalcByteSumN(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcByteSumN", ExactSpelling=true)]
		unsafe private static extern byte A64CalcByteSumN(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcByteSumN", ExactSpelling=true)]
		private static extern char A64CalcByteSumN(IntPtr sp,int len);

		//----- ●AjcCalcByteSumS ------------------------------------------------------------------------------//
		unsafe public static byte AjcCalcByteSumS(void *p, int len)
		{
			byte	rc;
			if (Is32Bit()) rc = A32CalcByteSumS(p, len);
			else		   rc = A64CalcByteSumS(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static char AjcCalcByteSumS(IntPtr p, int len)
		{
			char	rc;
			if (Is32Bit()) rc = A32CalcByteSumS(p, len);
			else		   rc = A64CalcByteSumS(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcByteSumS@8", ExactSpelling=true)]
		unsafe private static extern byte A32CalcByteSumS(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcByteSumS@8", ExactSpelling=true)]
		private static extern char A32CalcByteSumS(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcByteSumS", ExactSpelling=true)]
		unsafe private static extern byte A64CalcByteSumS(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcByteSumS", ExactSpelling=true)]
		private static extern char A64CalcByteSumS(IntPtr sp,int len);

		//----- ●AjcCalcByteSumX ------------------------------------------------------------------------------//
		unsafe public static byte AjcCalcByteSumX(void *p, int len)
		{
			byte	rc;
			if (Is32Bit()) rc = A32CalcByteSumX(p, len);
			else		   rc = A64CalcByteSumX(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static char AjcCalcByteSumX(IntPtr p, int len)
		{
			char	rc;
			if (Is32Bit()) rc = A32CalcByteSumX(p, len);
			else		   rc = A64CalcByteSumX(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcByteSumX@8", ExactSpelling=true)]
		unsafe private static extern byte A32CalcByteSumX(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcByteSumX@8", ExactSpelling=true)]
		private static extern char A32CalcByteSumX(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcByteSumX", ExactSpelling=true)]
		unsafe private static extern byte A64CalcByteSumX(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcByteSumX", ExactSpelling=true)]
		private static extern char A64CalcByteSumX(IntPtr sp,int len);

		//----- ●AjcSetByteSum --------------------------------------------------------------------------------//
		unsafe public static void AjcSetByteSum(void *p, int len)
		{
			if (Is32Bit()) A32SetByteSum(p, len);
			else		   A64SetByteSum(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetByteSum(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetByteSum(p, len);
			else		   A64SetByteSum(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSum@8", ExactSpelling=true)]
		unsafe private static extern void A32SetByteSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSum@8", ExactSpelling=true)]
		private static extern void A32SetByteSum(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSum", ExactSpelling=true)]
		unsafe private static extern void A64SetByteSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSum", ExactSpelling=true)]
		private static extern void A64SetByteSum(IntPtr rec,int rl);

		//----- ●AjcSetByteSumN -------------------------------------------------------------------------------//
		unsafe public static void AjcSetByteSumN(void *p, int len)
		{
			if (Is32Bit()) A32SetByteSumN(p, len);
			else		   A64SetByteSumN(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetByteSumN(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetByteSumN(p, len);
			else		   A64SetByteSumN(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSumN@8", ExactSpelling=true)]
		unsafe private static extern void A32SetByteSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSumN@8", ExactSpelling=true)]
		private static extern void A32SetByteSumN(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSumN", ExactSpelling=true)]
		unsafe private static extern void A64SetByteSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSumN", ExactSpelling=true)]
		private static extern void A64SetByteSumN(IntPtr rec,int rl);

		//----- ●AjcSetByteSumS -------------------------------------------------------------------------------//
		unsafe public static void AjcSetByteSumS(void *p, int len)
		{
			if (Is32Bit()) A32SetByteSumS(p, len);
			else		   A64SetByteSumS(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetByteSumS(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetByteSumS(p, len);
			else		   A64SetByteSumS(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSumS@8", ExactSpelling=true)]
		unsafe private static extern void A32SetByteSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSumS@8", ExactSpelling=true)]
		private static extern void A32SetByteSumS(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSumS", ExactSpelling=true)]
		unsafe private static extern void A64SetByteSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSumS", ExactSpelling=true)]
		private static extern void A64SetByteSumS(IntPtr rec,int rl);

		//----- ●AjcSetByteSumX -------------------------------------------------------------------------------//
		unsafe public static void AjcSetByteSumX(void *p, int len)
		{
			if (Is32Bit()) A32SetByteSumX(p, len);
			else		   A64SetByteSumX(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetByteSumX(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetByteSumX(p, len);
			else		   A64SetByteSumX(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSumX@8", ExactSpelling=true)]
		unsafe private static extern void A32SetByteSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetByteSumX@8", ExactSpelling=true)]
		private static extern void A32SetByteSumX(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSumX", ExactSpelling=true)]
		unsafe private static extern void A64SetByteSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetByteSumX", ExactSpelling=true)]
		private static extern void A64SetByteSumX(IntPtr rec,int rl);

		//----- ●AjcChkByteSum --------------------------------------------------------------------------------//
		unsafe public static bool AjcChkByteSum(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSum(p, len);
			else		   rc = A64ChkByteSum(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkByteSum(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSum(p, len);
			else		   rc = A64ChkByteSum(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSum@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkByteSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSum@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkByteSum(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSum", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkByteSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSum", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkByteSum(IntPtr rec,int rl);

		//----- ●AjcChkByteSumN -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkByteSumN(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSumN(p, len);
			else		   rc = A64ChkByteSumN(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkByteSumN(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSumN(p, len);
			else		   rc = A64ChkByteSumN(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSumN@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkByteSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSumN@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkByteSumN(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSumN", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkByteSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSumN", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkByteSumN(IntPtr rec,int rl);

		//----- ●AjcChkByteSumS -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkByteSumS(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSumS(p, len);
			else		   rc = A64ChkByteSumS(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkByteSumS(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSumS(p, len);
			else		   rc = A64ChkByteSumS(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSumS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkByteSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSumS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkByteSumS(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSumS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkByteSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSumS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkByteSumS(IntPtr rec,int rl);

		//----- ●AjcChkByteSumX -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkByteSumX(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSumX(p, len);
			else		   rc = A64ChkByteSumX(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkByteSumX(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkByteSumX(p, len);
			else		   rc = A64ChkByteSumX(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSumX@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkByteSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkByteSumX@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkByteSumX(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSumX", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkByteSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkByteSumX", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkByteSumX(IntPtr rec,int rl);

		//----- ●AjcCalcWordSum -------------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSum(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSum(p, len);
			else		   rc = A64CalcWordSum(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSum(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSum(p, len);
			else		   rc = A64CalcWordSum(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSum@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSum(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSum@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSum(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSum", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSum(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSum", ExactSpelling=true)]
		private static extern ushort A64CalcWordSum(IntPtr sp,int len);

		//----- ●AjcCalcWordSumN ------------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumN(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumN(p, len);
			else		   rc = A64CalcWordSumN(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumN(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumN(p, len);
			else		   rc = A64CalcWordSumN(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumN@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumN(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumN@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumN(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumN", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumN(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumN", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumN(IntPtr sp,int len);

		//----- ●AjcCalcWordSumS ------------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumS(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumS(p, len);
			else		   rc = A64CalcWordSumS(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumS(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumS(p, len);
			else		   rc = A64CalcWordSumS(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumS@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumS(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumS@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumS(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumS", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumS(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumS", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumS(IntPtr sp,int len);

		//----- ●AjcCalcWordSumX ------------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumX(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumX(p, len);
			else		   rc = A64CalcWordSumX(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumX(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumX(p, len);
			else		   rc = A64CalcWordSumX(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumX@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumX(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumX@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumX(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumX", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumX(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumX", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumX(IntPtr sp,int len);

		//----- ●AjcSetWordSum --------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSum(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSum(p, len);
			else		   A64SetWordSum(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSum(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSum(p, len);
			else		   A64SetWordSum(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSum@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSum@8", ExactSpelling=true)]
		private static extern void A32SetWordSum(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSum", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSum", ExactSpelling=true)]
		private static extern void A64SetWordSum(IntPtr rec,int rl);

		//----- ●AjcSetWordSumN -------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumN(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumN(p, len);
			else		   A64SetWordSumN(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumN(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumN(p, len);
			else		   A64SetWordSumN(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumN@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumN@8", ExactSpelling=true)]
		private static extern void A32SetWordSumN(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumN", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumN", ExactSpelling=true)]
		private static extern void A64SetWordSumN(IntPtr rec,int rl);

		//----- ●AjcSetWordSumS -------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumS(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumS(p, len);
			else		   A64SetWordSumS(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumS(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumS(p, len);
			else		   A64SetWordSumS(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumS@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumS@8", ExactSpelling=true)]
		private static extern void A32SetWordSumS(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumS", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumS", ExactSpelling=true)]
		private static extern void A64SetWordSumS(IntPtr rec,int rl);

		//----- ●AjcSetWordSumX -------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumX(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumX(p, len);
			else		   A64SetWordSumX(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumX(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumX(p, len);
			else		   A64SetWordSumX(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumX@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumX@8", ExactSpelling=true)]
		private static extern void A32SetWordSumX(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumX", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumX", ExactSpelling=true)]
		private static extern void A64SetWordSumX(IntPtr rec,int rl);

		//----- ●AjcChkWordSum --------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSum(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSum(p, len);
			else		   rc = A64ChkWordSum(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSum(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSum(p, len);
			else		   rc = A64ChkWordSum(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSum@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSum@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSum(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSum", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSum(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSum", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSum(IntPtr rec,int rl);

		//----- ●AjcChkWordSumN -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumN(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumN(p, len);
			else		   rc = A64ChkWordSumN(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumN(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumN(p, len);
			else		   rc = A64ChkWordSumN(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumN@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumN@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumN(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumN", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumN(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumN", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumN(IntPtr rec,int rl);

		//----- ●AjcChkWordSumS -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumS(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumS(p, len);
			else		   rc = A64ChkWordSumS(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumS(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumS(p, len);
			else		   rc = A64ChkWordSumS(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumS(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumS(IntPtr rec,int rl);

		//----- ●AjcChkWordSumX -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumX(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumX(p, len);
			else		   rc = A64ChkWordSumX(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumX(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumX(p, len);
			else		   rc = A64ChkWordSumX(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumX@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumX@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumX(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumX", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumX(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumX", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumX(IntPtr rec,int rl);

		//----- ●AjcCalcWordSumR ------------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumR(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumR(p, len);
			else		   rc = A64CalcWordSumR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumR(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumR(p, len);
			else		   rc = A64CalcWordSumR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumR@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumR@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumR(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumR", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumR", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumR(IntPtr sp,int len);

		//----- ●AjcCalcWordSumNR -----------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumNR(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumNR(p, len);
			else		   rc = A64CalcWordSumNR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumNR(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumNR(p, len);
			else		   rc = A64CalcWordSumNR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumNR@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumNR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumNR@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumNR(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumNR", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumNR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumNR", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumNR(IntPtr sp,int len);

		//----- ●AjcCalcWordSumSR -----------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumSR(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumSR(p, len);
			else		   rc = A64CalcWordSumSR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumSR(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumSR(p, len);
			else		   rc = A64CalcWordSumSR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumSR@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumSR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumSR@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumSR(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumSR", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumSR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumSR", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumSR(IntPtr sp,int len);

		//----- ●AjcCalcWordSumXR -----------------------------------------------------------------------------//
		unsafe public static ushort AjcCalcWordSumXR(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumXR(p, len);
			else		   rc = A64CalcWordSumXR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcCalcWordSumXR(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CalcWordSumXR(p, len);
			else		   rc = A64CalcWordSumXR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumXR@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CalcWordSumXR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCalcWordSumXR@8", ExactSpelling=true)]
		private static extern ushort A32CalcWordSumXR(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumXR", ExactSpelling=true)]
		unsafe private static extern ushort A64CalcWordSumXR(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCalcWordSumXR", ExactSpelling=true)]
		private static extern ushort A64CalcWordSumXR(IntPtr sp,int len);

		//----- ●AjcSetWordSumR -------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumR(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumR(p, len);
			else		   A64SetWordSumR(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumR(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumR(p, len);
			else		   A64SetWordSumR(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumR@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumR@8", ExactSpelling=true)]
		private static extern void A32SetWordSumR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumR", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumR", ExactSpelling=true)]
		private static extern void A64SetWordSumR(IntPtr rec,int rl);

		//----- ●AjcSetWordSumNR ------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumNR(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumNR(p, len);
			else		   A64SetWordSumNR(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumNR(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumNR(p, len);
			else		   A64SetWordSumNR(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumNR@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumNR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumNR@8", ExactSpelling=true)]
		private static extern void A32SetWordSumNR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumNR", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumNR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumNR", ExactSpelling=true)]
		private static extern void A64SetWordSumNR(IntPtr rec,int rl);

		//----- ●AjcSetWordSumSR ------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumSR(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumSR(p, len);
			else		   A64SetWordSumSR(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumSR(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumSR(p, len);
			else		   A64SetWordSumSR(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumSR@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumSR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumSR@8", ExactSpelling=true)]
		private static extern void A32SetWordSumSR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumSR", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumSR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumSR", ExactSpelling=true)]
		private static extern void A64SetWordSumSR(IntPtr rec,int rl);

		//----- ●AjcSetWordSumXR ------------------------------------------------------------------------------//
		unsafe public static void AjcSetWordSumXR(void *p, int len)
		{
			if (Is32Bit()) A32SetWordSumXR(p, len);
			else		   A64SetWordSumXR(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetWordSumXR(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetWordSumXR(p, len);
			else		   A64SetWordSumXR(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumXR@8", ExactSpelling=true)]
		unsafe private static extern void A32SetWordSumXR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetWordSumXR@8", ExactSpelling=true)]
		private static extern void A32SetWordSumXR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumXR", ExactSpelling=true)]
		unsafe private static extern void A64SetWordSumXR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetWordSumXR", ExactSpelling=true)]
		private static extern void A64SetWordSumXR(IntPtr rec,int rl);

		//----- ●AjcChkWordSumR -------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumR(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumR(p, len);
			else		   rc = A64ChkWordSumR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumR(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumR(p, len);
			else		   rc = A64ChkWordSumR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumR(IntPtr rec,int rl);

		//----- ●AjcChkWordSumNR ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumNR(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumNR(p, len);
			else		   rc = A64ChkWordSumNR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumNR(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumNR(p, len);
			else		   rc = A64ChkWordSumNR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumNR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumNR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumNR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumNR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumNR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumNR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumNR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumNR(IntPtr rec,int rl);

		//----- ●AjcChkWordSumSR ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumSR(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumSR(p, len);
			else		   rc = A64ChkWordSumSR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumSR(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumSR(p, len);
			else		   rc = A64ChkWordSumSR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumSR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumSR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumSR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumSR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumSR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumSR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumSR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumSR(IntPtr rec,int rl);

		//----- ●AjcChkWordSumXR ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkWordSumXR(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumXR(p, len);
			else		   rc = A64ChkWordSumXR(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkWordSumXR(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkWordSumXR(p, len);
			else		   rc = A64ChkWordSumXR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumXR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkWordSumXR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkWordSumXR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkWordSumXR(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumXR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkWordSumXR(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkWordSumXR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkWordSumXR(IntPtr rec,int rl);

		//======================================================================================================//
		//	AjcCip.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcCRC.h																							//
		//======================================================================================================//

		//----- ●AjcCrc16L ------------------------------------------------------------------------------------//
		public static ushort AjcCrc16L(byte ByteData, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32Crc16L(ByteData, ini);
			else		   rc = A64Crc16L(ByteData, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCrc16L@8", ExactSpelling=true)]
		private static extern ushort A32Crc16L(byte ByteData, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCrc16L", ExactSpelling=true)]
		private static extern ushort A64Crc16L(byte ByteData, ushort ini);

		//----- ●AjcPartCrc16L --------------------------------------------------------------------------------//
		unsafe public static ushort AjcPartCrc16L(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrc16L(p, len, ini);
			else		   rc = A64PartCrc16L(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcPartCrc16L(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrc16L(p, len, ini);
			else		   rc = A64PartCrc16L(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrc16L@12", ExactSpelling=true)]
		unsafe private static extern ushort A32PartCrc16L(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrc16L@12", ExactSpelling=true)]
		private static extern ushort A32PartCrc16L(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrc16L", ExactSpelling=true)]
		unsafe private static extern ushort A64PartCrc16L(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrc16L", ExactSpelling=true)]
		private static extern ushort A64PartCrc16L(IntPtr sp,int len,ushort ini);

		//----- ●AjcBlkCrc16L ---------------------------------------------------------------------------------//
		unsafe public static ushort AjcBlkCrc16L(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrc16L(p, len, ini);
			else		   rc = A64BlkCrc16L(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcBlkCrc16L(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrc16L(p, len, ini);
			else		   rc = A64BlkCrc16L(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrc16L@12", ExactSpelling=true)]
		unsafe private static extern ushort A32BlkCrc16L(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrc16L@12", ExactSpelling=true)]
		private static extern ushort A32BlkCrc16L(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrc16L", ExactSpelling=true)]
		unsafe private static extern ushort A64BlkCrc16L(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrc16L", ExactSpelling=true)]
		private static extern ushort A64BlkCrc16L(IntPtr sp,int len,ushort ini);

		//----- ●AjcSetCrc16L ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrc16L(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16L(p, len, ini);
			else		   A64SetCrc16L(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrc16L(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16L(p, len, ini);
			else		   A64SetCrc16L(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16L@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrc16L(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16L@12", ExactSpelling=true)]
		private static extern void A32SetCrc16L(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16L", ExactSpelling=true)]
		unsafe private static extern void A64SetCrc16L(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16L", ExactSpelling=true)]
		private static extern void A64SetCrc16L(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetCrc16L_BE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrc16L_BE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16L_BE(p, len, ini);
			else		   A64SetCrc16L_BE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrc16L_BE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16L_BE(p, len, ini);
			else		   A64SetCrc16L_BE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16L_BE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrc16L_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16L_BE@12", ExactSpelling=true)]
		private static extern void A32SetCrc16L_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16L_BE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrc16L_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16L_BE", ExactSpelling=true)]
		private static extern void A64SetCrc16L_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetCrc16L_LE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrc16L_LE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16L_LE(p, len, ini);
			else		   A64SetCrc16L_LE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrc16L_LE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16L_LE(p, len, ini);
			else		   A64SetCrc16L_LE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16L_LE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrc16L_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16L_LE@12", ExactSpelling=true)]
		private static extern void A32SetCrc16L_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16L_LE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrc16L_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16L_LE", ExactSpelling=true)]
		private static extern void A64SetCrc16L_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkCrc16L ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrc16L(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16L(p, len, ini);
			else		   rc = A64ChkCrc16L(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrc16L(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16L(p, len, ini);
			else		   rc = A64ChkCrc16L(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16L@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrc16L(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16L@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrc16L(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16L", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrc16L(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16L", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrc16L(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkCrc16L_BE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrc16L_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16L_BE(p, len, ini);
			else		   rc = A64ChkCrc16L_BE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrc16L_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16L_BE(p, len, ini);
			else		   rc = A64ChkCrc16L_BE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16L_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrc16L_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16L_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrc16L_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16L_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrc16L_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16L_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrc16L_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkCrc16L_LE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrc16L_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16L_LE(p, len, ini);
			else		   rc = A64ChkCrc16L_LE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrc16L_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16L_LE(p, len, ini);
			else		   rc = A64ChkCrc16L_LE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16L_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrc16L_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16L_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrc16L_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16L_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrc16L_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16L_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrc16L_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcCrc16R ------------------------------------------------------------------------------------//
		public static ushort AjcCrc16R(byte ByteData, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32Crc16R(ByteData, ini);
			else		   rc = A64Crc16R(ByteData, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCrc16R@8", ExactSpelling=true)]
		private static extern ushort A32Crc16R(byte ByteData, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCrc16R", ExactSpelling=true)]
		private static extern ushort A64Crc16R(byte ByteData, ushort ini);

		//----- ●AjcPartCrc16R --------------------------------------------------------------------------------//
		unsafe public static ushort AjcPartCrc16R(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrc16R(p, len, ini);
			else		   rc = A64PartCrc16R(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcPartCrc16R(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrc16R(p, len, ini);
			else		   rc = A64PartCrc16R(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrc16R@12", ExactSpelling=true)]
		unsafe private static extern ushort A32PartCrc16R(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrc16R@12", ExactSpelling=true)]
		private static extern ushort A32PartCrc16R(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrc16R", ExactSpelling=true)]
		unsafe private static extern ushort A64PartCrc16R(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrc16R", ExactSpelling=true)]
		private static extern ushort A64PartCrc16R(IntPtr sp,int len,ushort ini);

		//----- ●AjcBlkCrc16R ---------------------------------------------------------------------------------//
		unsafe public static ushort AjcBlkCrc16R(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrc16R(p, len, ini);
			else		   rc = A64BlkCrc16R(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcBlkCrc16R(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrc16R(p, len, ini);
			else		   rc = A64BlkCrc16R(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrc16R@12", ExactSpelling=true)]
		unsafe private static extern ushort A32BlkCrc16R(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrc16R@12", ExactSpelling=true)]
		private static extern ushort A32BlkCrc16R(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrc16R", ExactSpelling=true)]
		unsafe private static extern ushort A64BlkCrc16R(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrc16R", ExactSpelling=true)]
		private static extern ushort A64BlkCrc16R(IntPtr sp,int len,ushort ini);

		//----- ●AjcSetCrc16R ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrc16R(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16R(p, len, ini);
			else		   A64SetCrc16R(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrc16R(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16R(p, len, ini);
			else		   A64SetCrc16R(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16R@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrc16R(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16R@12", ExactSpelling=true)]
		private static extern void A32SetCrc16R(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16R", ExactSpelling=true)]
		unsafe private static extern void A64SetCrc16R(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16R", ExactSpelling=true)]
		private static extern void A64SetCrc16R(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetCrc16R_BE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrc16R_BE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16R_BE(p, len, ini);
			else		   A64SetCrc16R_BE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrc16R_BE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16R_BE(p, len, ini);
			else		   A64SetCrc16R_BE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16R_BE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrc16R_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16R_BE@12", ExactSpelling=true)]
		private static extern void A32SetCrc16R_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16R_BE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrc16R_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16R_BE", ExactSpelling=true)]
		private static extern void A64SetCrc16R_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetCrc16R_LE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrc16R_LE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16R_LE(p, len, ini);
			else		   A64SetCrc16R_LE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrc16R_LE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrc16R_LE(p, len, ini);
			else		   A64SetCrc16R_LE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16R_LE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrc16R_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrc16R_LE@12", ExactSpelling=true)]
		private static extern void A32SetCrc16R_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16R_LE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrc16R_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrc16R_LE", ExactSpelling=true)]
		private static extern void A64SetCrc16R_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkCrc16R ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrc16R(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16R(p, len, ini);
			else		   rc = A64ChkCrc16R(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrc16R(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16R(p, len, ini);
			else		   rc = A64ChkCrc16R(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16R@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrc16R(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16R@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrc16R(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16R", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrc16R(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16R", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrc16R(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkCrc16R_BE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrc16R_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16R_BE(p, len, ini);
			else		   rc = A64ChkCrc16R_BE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrc16R_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16R_BE(p, len, ini);
			else		   rc = A64ChkCrc16R_BE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16R_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrc16R_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16R_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrc16R_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16R_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrc16R_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16R_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrc16R_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkCrc16R_LE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrc16R_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16R_LE(p, len, ini);
			else		   rc = A64ChkCrc16R_LE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrc16R_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrc16R_LE(p, len, ini);
			else		   rc = A64ChkCrc16R_LE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16R_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrc16R_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrc16R_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrc16R_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16R_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrc16R_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrc16R_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrc16R_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcCrcItL ------------------------------------------------------------------------------------//
		public static ushort AjcCrcItL(byte ByteData, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CrcItL(ByteData, ini);
			else		   rc = A64CrcItL(ByteData, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCrcItL@8", ExactSpelling=true)]
		private static extern ushort A32CrcItL(byte ByteData, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCrcItL", ExactSpelling=true)]
		private static extern ushort A64CrcItL(byte ByteData, ushort ini);

		//----- ●AjcPartCrcItL --------------------------------------------------------------------------------//
		unsafe public static ushort AjcPartCrcItL(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrcItL(p, len, ini);
			else		   rc = A64PartCrcItL(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcPartCrcItL(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrcItL(p, len, ini);
			else		   rc = A64PartCrcItL(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrcItL@12", ExactSpelling=true)]
		unsafe private static extern ushort A32PartCrcItL(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrcItL@12", ExactSpelling=true)]
		private static extern ushort A32PartCrcItL(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrcItL", ExactSpelling=true)]
		unsafe private static extern ushort A64PartCrcItL(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrcItL", ExactSpelling=true)]
		private static extern ushort A64PartCrcItL(IntPtr sp,int len,ushort ini);

		//----- ●AjcBlkCrcItL ---------------------------------------------------------------------------------//
		unsafe public static ushort AjcBlkCrcItL(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrcItL(p, len, ini);
			else		   rc = A64BlkCrcItL(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcBlkCrcItL(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrcItL(p, len, ini);
			else		   rc = A64BlkCrcItL(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrcItL@12", ExactSpelling=true)]
		unsafe private static extern ushort A32BlkCrcItL(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrcItL@12", ExactSpelling=true)]
		private static extern ushort A32BlkCrcItL(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrcItL", ExactSpelling=true)]
		unsafe private static extern ushort A64BlkCrcItL(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrcItL", ExactSpelling=true)]
		private static extern ushort A64BlkCrcItL(IntPtr sp,int len,ushort ini);

		//----- ●AjcBlkXMODEM ---------------------------------------------------------------------------------//
		unsafe public static ushort AjcBlkXMODEM(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkXMODEM(p, len);
			else		   rc = A64BlkXMODEM(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcBlkXMODEM(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkXMODEM(p, len);
			else		   rc = A64BlkXMODEM(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkXMODEM@8", ExactSpelling=true)]
		unsafe private static extern ushort A32BlkXMODEM(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkXMODEM@8", ExactSpelling=true)]
		private static extern ushort A32BlkXMODEM(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkXMODEM", ExactSpelling=true)]
		unsafe private static extern ushort A64BlkXMODEM(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkXMODEM", ExactSpelling=true)]
		private static extern ushort A64BlkXMODEM(IntPtr sp,int len);

		//----- ●AjcSetCrcItL ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrcItL(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItL(p, len, ini);
			else		   A64SetCrcItL(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrcItL(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItL(p, len, ini);
			else		   A64SetCrcItL(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItL@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrcItL(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItL@12", ExactSpelling=true)]
		private static extern void A32SetCrcItL(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItL", ExactSpelling=true)]
		unsafe private static extern void A64SetCrcItL(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItL", ExactSpelling=true)]
		private static extern void A64SetCrcItL(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetXMODEM ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetXMODEM(void *p, int len)
		{
			if (Is32Bit()) A32SetXMODEM(p, len);
			else		   A64SetXMODEM(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetXMODEM(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetXMODEM(p, len);
			else		   A64SetXMODEM(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetXMODEM@8", ExactSpelling=true)]
		unsafe private static extern void A32SetXMODEM(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetXMODEM@8", ExactSpelling=true)]
		private static extern void A32SetXMODEM(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetXMODEM", ExactSpelling=true)]
		unsafe private static extern void A64SetXMODEM(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetXMODEM", ExactSpelling=true)]
		private static extern void A64SetXMODEM(IntPtr rec,int rl);

		//----- ●AjcSetCrcItL_BE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrcItL_BE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItL_BE(p, len, ini);
			else		   A64SetCrcItL_BE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrcItL_BE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItL_BE(p, len, ini);
			else		   A64SetCrcItL_BE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItL_BE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrcItL_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItL_BE@12", ExactSpelling=true)]
		private static extern void A32SetCrcItL_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItL_BE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrcItL_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItL_BE", ExactSpelling=true)]
		private static extern void A64SetCrcItL_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetXMODEM_BE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetXMODEM_BE(void *p, int len)
		{
			if (Is32Bit()) A32SetXMODEM_BE(p, len);
			else		   A64SetXMODEM_BE(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetXMODEM_BE(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetXMODEM_BE(p, len);
			else		   A64SetXMODEM_BE(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetXMODEM_BE@8", ExactSpelling=true)]
		unsafe private static extern void A32SetXMODEM_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetXMODEM_BE@8", ExactSpelling=true)]
		private static extern void A32SetXMODEM_BE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetXMODEM_BE", ExactSpelling=true)]
		unsafe private static extern void A64SetXMODEM_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetXMODEM_BE", ExactSpelling=true)]
		private static extern void A64SetXMODEM_BE(IntPtr rec,int rl);

		//----- ●AjcSetCrcItL_LE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrcItL_LE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItL_LE(p, len, ini);
			else		   A64SetCrcItL_LE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrcItL_LE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItL_LE(p, len, ini);
			else		   A64SetCrcItL_LE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItL_LE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrcItL_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItL_LE@12", ExactSpelling=true)]
		private static extern void A32SetCrcItL_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItL_LE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrcItL_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItL_LE", ExactSpelling=true)]
		private static extern void A64SetCrcItL_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetXMODEM_LE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetXMODEM_LE(void *p, int len)
		{
			if (Is32Bit()) A32SetXMODEM_LE(p, len);
			else		   A64SetXMODEM_LE(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetXMODEM_LE(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetXMODEM_LE(p, len);
			else		   A64SetXMODEM_LE(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetXMODEM_LE@8", ExactSpelling=true)]
		unsafe private static extern void A32SetXMODEM_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetXMODEM_LE@8", ExactSpelling=true)]
		private static extern void A32SetXMODEM_LE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetXMODEM_LE", ExactSpelling=true)]
		unsafe private static extern void A64SetXMODEM_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetXMODEM_LE", ExactSpelling=true)]
		private static extern void A64SetXMODEM_LE(IntPtr rec,int rl);

		//----- ●AjcChkCrcItL ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrcItL(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItL(p, len, ini);
			else		   rc = A64ChkCrcItL(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrcItL(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItL(p, len, ini);
			else		   rc = A64ChkCrcItL(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItL@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrcItL(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItL@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrcItL(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrcItL(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrcItL(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkXMODEM ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkXMODEM(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkXMODEM(p, len);
			else		   rc = A64ChkXMODEM(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkXMODEM(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkXMODEM(p, len);
			else		   rc = A64ChkXMODEM(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkXMODEM@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkXMODEM(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkXMODEM@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkXMODEM(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkXMODEM", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkXMODEM(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkXMODEM", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkXMODEM(IntPtr rec,int rl);

		//----- ●AjcChkCrcItL_BE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrcItL_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItL_BE(p, len, ini);
			else		   rc = A64ChkCrcItL_BE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrcItL_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItL_BE(p, len, ini);
			else		   rc = A64ChkCrcItL_BE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItL_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrcItL_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItL_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrcItL_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItL_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrcItL_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItL_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrcItL_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkXMODEM_BE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkXMODEM_BE(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkXMODEM_BE(p, len);
			else		   rc = A64ChkXMODEM_BE(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkXMODEM_BE(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkXMODEM_BE(p, len);
			else		   rc = A64ChkXMODEM_BE(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkXMODEM_BE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkXMODEM_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkXMODEM_BE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkXMODEM_BE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkXMODEM_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkXMODEM_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkXMODEM_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkXMODEM_BE(IntPtr rec,int rl);

		//----- ●AjcChkCrcItL_LE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrcItL_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItL_LE(p, len, ini);
			else		   rc = A64ChkCrcItL_LE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrcItL_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItL_LE(p, len, ini);
			else		   rc = A64ChkCrcItL_LE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItL_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrcItL_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItL_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrcItL_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItL_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrcItL_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItL_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrcItL_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkXMODEM_LE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkXMODEM_LE(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkXMODEM_LE(p, len);
			else		   rc = A64ChkXMODEM_LE(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkXMODEM_LE(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkXMODEM_LE(p, len);
			else		   rc = A64ChkXMODEM_LE(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkXMODEM_LE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkXMODEM_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkXMODEM_LE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkXMODEM_LE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkXMODEM_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkXMODEM_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkXMODEM_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkXMODEM_LE(IntPtr rec,int rl);

		//----- ●AjcCrcItR ------------------------------------------------------------------------------------//
		public static ushort AjcCrcItR(byte ByteData, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32CrcItR(ByteData, ini);
			else		   rc = A64CrcItR(ByteData, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCrcItR@8", ExactSpelling=true)]
		unsafe private static extern ushort A32CrcItR(byte ByteData, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCrcItR", ExactSpelling=true)]
		unsafe private static extern ushort A64CrcItR(byte ByteData, ushort ini);

		//----- ●AjcPartCrcItR --------------------------------------------------------------------------------//
		unsafe public static ushort AjcPartCrcItR(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrcItR(p, len, ini);
			else		   rc = A64PartCrcItR(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcPartCrcItR(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32PartCrcItR(p, len, ini);
			else		   rc = A64PartCrcItR(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrcItR@12", ExactSpelling=true)]
		unsafe private static extern ushort A32PartCrcItR(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPartCrcItR@12", ExactSpelling=true)]
		private static extern ushort A32PartCrcItR(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrcItR", ExactSpelling=true)]
		unsafe private static extern ushort A64PartCrcItR(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPartCrcItR", ExactSpelling=true)]
		private static extern ushort A64PartCrcItR(IntPtr sp,int len,ushort ini);

		//----- ●AjcBlkCrcItR ---------------------------------------------------------------------------------//
		unsafe public static ushort AjcBlkCrcItR(void *p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrcItR(p, len, ini);
			else		   rc = A64BlkCrcItR(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcBlkCrcItR(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkCrcItR(p, len, ini);
			else		   rc = A64BlkCrcItR(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrcItR@12", ExactSpelling=true)]
		unsafe private static extern ushort A32BlkCrcItR(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkCrcItR@12", ExactSpelling=true)]
		private static extern ushort A32BlkCrcItR(IntPtr sp, int len, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrcItR", ExactSpelling=true)]
		unsafe private static extern ushort A64BlkCrcItR(void *sp, int len, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkCrcItR", ExactSpelling=true)]
		private static extern ushort A64BlkCrcItR(IntPtr sp,int len,ushort ini);

		//----- ●AjcBlkFCS ------------------------------------------------------------------------------------//
		unsafe public static ushort AjcBlkFCS(void *p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkFCS(p, len);
			else		   rc = A64BlkFCS(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ushort AjcBlkFCS(IntPtr p, int len)
		{
			ushort	rc;
			if (Is32Bit()) rc = A32BlkFCS(p, len);
			else		   rc = A64BlkFCS(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkFCS@8", ExactSpelling=true)]
		unsafe private static extern ushort A32BlkFCS(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBlkFCS@8", ExactSpelling=true)]
		private static extern ushort A32BlkFCS(IntPtr sp, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkFCS", ExactSpelling=true)]
		unsafe private static extern ushort A64BlkFCS(void *sp, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBlkFCS", ExactSpelling=true)]
		private static extern ushort A64BlkFCS(IntPtr sp,int len);

		//----- ●AjcSetCrcItR ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrcItR(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItR(p, len, ini);
			else		   A64SetCrcItR(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrcItR(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItR(p, len, ini);
			else		   A64SetCrcItR(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItR@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrcItR(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItR@12", ExactSpelling=true)]
		private static extern void A32SetCrcItR(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItR", ExactSpelling=true)]
		unsafe private static extern void A64SetCrcItR(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItR", ExactSpelling=true)]
		private static extern void A64SetCrcItR(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetFCS ------------------------------------------------------------------------------------//
		unsafe public static void AjcSetFCS(void *p, int len)
		{
			if (Is32Bit()) A32SetFCS(p, len);
			else		   A64SetFCS(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetFCS(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetFCS(p, len);
			else		   A64SetFCS(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetFCS@8", ExactSpelling=true)]
		unsafe private static extern void A32SetFCS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetFCS@8", ExactSpelling=true)]
		private static extern void A32SetFCS(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetFCS", ExactSpelling=true)]
		unsafe private static extern void A64SetFCS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetFCS", ExactSpelling=true)]
		private static extern void A64SetFCS(IntPtr rec,int rl);

		//----- ●AjcSetCrcItR_BE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrcItR_BE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItR_BE(p, len, ini);
			else		   A64SetCrcItR_BE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrcItR_BE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItR_BE(p, len, ini);
			else		   A64SetCrcItR_BE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItR_BE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrcItR_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItR_BE@12", ExactSpelling=true)]
		private static extern void A32SetCrcItR_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItR_BE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrcItR_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItR_BE", ExactSpelling=true)]
		private static extern void A64SetCrcItR_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetFCS_BE ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetFCS_BE(void *p, int len)
		{
			if (Is32Bit()) A32SetFCS_BE(p, len);
			else		   A64SetFCS_BE(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetFCS_BE(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetFCS_BE(p, len);
			else		   A64SetFCS_BE(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetFCS_BE@8", ExactSpelling=true)]
		unsafe private static extern void A32SetFCS_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetFCS_BE@8", ExactSpelling=true)]
		private static extern void A32SetFCS_BE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetFCS_BE", ExactSpelling=true)]
		unsafe private static extern void A64SetFCS_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetFCS_BE", ExactSpelling=true)]
		private static extern void A64SetFCS_BE(IntPtr rec,int rl);

		//----- ●AjcSetCrcItR_LE ------------------------------------------------------------------------------//
		unsafe public static void AjcSetCrcItR_LE(void *p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItR_LE(p, len, ini);
			else		   A64SetCrcItR_LE(p, len, ini);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetCrcItR_LE(IntPtr p, int len, ushort ini)
		{
			if (Is32Bit()) A32SetCrcItR_LE(p, len, ini);
			else		   A64SetCrcItR_LE(p, len, ini);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItR_LE@12", ExactSpelling=true)]
		unsafe private static extern void A32SetCrcItR_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetCrcItR_LE@12", ExactSpelling=true)]
		private static extern void A32SetCrcItR_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItR_LE", ExactSpelling=true)]
		unsafe private static extern void A64SetCrcItR_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetCrcItR_LE", ExactSpelling=true)]
		private static extern void A64SetCrcItR_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcSetFCS_LE ---------------------------------------------------------------------------------//
		unsafe public static void AjcSetFCS_LE(void *p, int len)
		{
			if (Is32Bit()) A32SetFCS_LE(p, len);
			else		   A64SetFCS_LE(p, len);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcSetFCS_LE(IntPtr p, int len)
		{
			if (Is32Bit()) A32SetFCS_LE(p, len);
			else		   A64SetFCS_LE(p, len);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetFCS_LE@8", ExactSpelling=true)]
		unsafe private static extern void A32SetFCS_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetFCS_LE@8", ExactSpelling=true)]
		private static extern void A32SetFCS_LE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetFCS_LE", ExactSpelling=true)]
		unsafe private static extern void A64SetFCS_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetFCS_LE", ExactSpelling=true)]
		private static extern void A64SetFCS_LE(IntPtr rec,int rl);

		//----- ●AjcChkCrcItR ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrcItR(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItR(p, len, ini);
			else		   rc = A64ChkCrcItR(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrcItR(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItR(p, len, ini);
			else		   rc = A64ChkCrcItR(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItR@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrcItR(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItR@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrcItR(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrcItR(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrcItR(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkFCS ------------------------------------------------------------------------------------//
		unsafe public static bool AjcChkFCS(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkFCS(p, len);
			else		   rc = A64ChkFCS(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkFCS(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkFCS(p, len);
			else		   rc = A64ChkFCS(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkFCS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkFCS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkFCS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkFCS(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkFCS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkFCS(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkFCS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkFCS(IntPtr rec,int rl);

		//----- ●AjcChkCrcItR_BE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrcItR_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItR_BE(p, len, ini);
			else		   rc = A64ChkCrcItR_BE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrcItR_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItR_BE(p, len, ini);
			else		   rc = A64ChkCrcItR_BE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItR_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrcItR_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItR_BE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrcItR_BE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItR_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrcItR_BE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItR_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrcItR_BE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkFCS_BE ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkFCS_BE(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkFCS_BE(p, len);
			else		   rc = A64ChkFCS_BE(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkFCS_BE(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkFCS_BE(p, len);
			else		   rc = A64ChkFCS_BE(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkFCS_BE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkFCS_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkFCS_BE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkFCS_BE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkFCS_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkFCS_BE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkFCS_BE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkFCS_BE(IntPtr rec,int rl);

		//----- ●AjcChkCrcItR_LE ------------------------------------------------------------------------------//
		unsafe public static bool AjcChkCrcItR_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItR_LE(p, len, ini);
			else		   rc = A64ChkCrcItR_LE(p, len, ini);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkCrcItR_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkCrcItR_LE(p, len, ini);
			else		   rc = A64ChkCrcItR_LE(p, len, ini);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItR_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkCrcItR_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkCrcItR_LE@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkCrcItR_LE(IntPtr rec, int rl, ushort ini);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItR_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkCrcItR_LE(void *rec, int rl, ushort ini);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkCrcItR_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkCrcItR_LE(IntPtr rec,int rl,ushort ini);

		//----- ●AjcChkFCS_LE ---------------------------------------------------------------------------------//
		unsafe public static bool AjcChkFCS_LE(void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkFCS_LE(p, len);
			else		   rc = A64ChkFCS_LE(p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcChkFCS_LE(IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ChkFCS_LE(p, len);
			else		   rc = A64ChkFCS_LE(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkFCS_LE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ChkFCS_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChkFCS_LE@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ChkFCS_LE(IntPtr rec, int rl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkFCS_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ChkFCS_LE(void *rec, int rl);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChkFCS_LE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ChkFCS_LE(IntPtr rec,int rl);

		//======================================================================================================//
		//	AjcCToken.h 																						//
		//======================================================================================================//

		//----- ●AjcCtkCreate ---------------------------------------------------------------------------------//
		public static IntPtr	AjcCtkCreate(CtkCbkGetS cbGetS, IntPtr cbp)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32CtkCreate(0, cbGetS, cbp);
			else		   rc = A64CtkCreate(0, cbGetS, cbp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkCreateW@12", ExactSpelling=true)]
		private static extern IntPtr A32CtkCreate(int flag, CtkCbkGetS cbGetS, IntPtr cbp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkCreateW", ExactSpelling=true)]
		private static extern IntPtr A64CtkCreate(int flag, CtkCbkGetS cbGetS, IntPtr cbp);

		//----- ●AjcCtkReset ----------------------------------------------------------------------------------//
		public static bool	AjcCtkReset(IntPtr hCtk)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CtkReset(hCtk);
			else		   rc = A64CtkReset(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkReset@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkReset(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkReset", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkReset(IntPtr hCtk);

		//----- ●AjcCtkSetCallBack ----------------------------------------------------------------------------//
		public static bool	AjcCtkSetCallBack(IntPtr hCtk, CtkCbkGetS cbGetS, IntPtr cbp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CtkSetCallBack(hCtk, cbGetS, cbp);
			else		   rc = A64CtkSetCallBack(hCtk, cbGetS, cbp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkSetCallBackW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkSetCallBack(IntPtr hCtk, CtkCbkGetS cbGetS, IntPtr cbp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkSetCallBackW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkSetCallBack(IntPtr hCtk, CtkCbkGetS cbGetS, IntPtr cbp);

		//----- ●AjcCtkSetCallBackParam -----------------------------------------------------------------------//

		//----- ●AjcCtkDelete ---------------------------------------------------------------------------------//
		public static bool	AjcCtkDelete(IntPtr hCtk)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CtkDelete(hCtk);
			else		   rc = A64CtkDelete(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkDelete@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkDelete(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkDelete", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkDelete(IntPtr hCtk);

		//----- ●AjcCtkSetFlag --------------------------------------------------------------------------------//
		public static bool	AjcCtkSetFlag(IntPtr hCtk, uint flag)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CtkSetFlag(hCtk, flag);
			else		   rc = A64CtkSetFlag(hCtk, flag);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkSetFlag@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkSetFlag(IntPtr hCtk, uint flag);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkSetFlag", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkSetFlag(IntPtr hCtk, uint flag);

		//----- ●AjcCtkGetFlag --------------------------------------------------------------------------------//
		public static uint	AjcCtkGetFlag(IntPtr hCtk)
		{
			uint	rc;
			if (Is32Bit()) rc = A32CtkGetFlag(hCtk);
			else		   rc = A64CtkGetFlag(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetFlag@4", ExactSpelling=true)]
		private static extern uint A32CtkGetFlag(IntPtr hSpl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetFlag", ExactSpelling=true)]
		private static extern uint A64CtkGetFlag(IntPtr hSpl);

		//----- ●AjcCtkGetToken -------------------------------------------------------------------------------//
		public static bool	AjcCtkGetToken(IntPtr hCtk, out string syl)
		{
			bool	rc;
			StringBuilder s = new StringBuilder(1024);
			if (Is32Bit()) rc = A32CtkGetToken(hCtk, s, (int)s.Capacity);
			else		   rc = A64CtkGetToken(hCtk, s, (int)s.Capacity);
			syl = s.ToString();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetTokenW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkGetToken(IntPtr hCtk, StringBuilder buf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetTokenW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkGetToken(IntPtr hCtk, StringBuilder buf, int lBuf);

		//----- ●AjcCtkPeekToken ------------------------------------------------------------------------------//
		public static bool	AjcCtkPeekToken(IntPtr hCtk, out string syl)
		{
			bool	rc;
			StringBuilder s = new StringBuilder(1024);
			if (Is32Bit()) rc = A32CtkPeekToken(hCtk, s, (int)s.Capacity);
			else		   rc = A64CtkPeekToken(hCtk, s, (int)s.Capacity);
			syl = s.ToString();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkPeekTokenW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkPeekToken(IntPtr hCtk, StringBuilder buf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkPeekTokenW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkPeekToken(IntPtr hCtk, StringBuilder buf, int lBuf);

		//----- ●AjcCtkGetTokenString -------------------------------------------------------------------------//
		public static string	AjcCtkGetTokenString(ECtkCode tkn)
		{
			string	rc;
			if (Is32Bit()) rc = A32CtkGetTokenString(tkn);
			else		   rc = A64CtkGetTokenString(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetTokenStringW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.LPWStr)]
		private static extern string A32CtkGetTokenString(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetTokenStringW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.LPWStr)]
		private static extern string A64CtkGetTokenString(ECtkCode tkn);

		//----- ●AjcCtkGetReplicatedHandle --------------------------------------------------------------------//
		public static IntPtr	AjcCtkGetReplicatedHandle(IntPtr hCtk)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32CtkGetReplicatedHandle(hCtk);
			else		   rc = A64CtkGetReplicatedHandle(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetReplicatedHandle@4", ExactSpelling=true)]
		private static extern IntPtr A32CtkGetReplicatedHandle(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetReplicatedHandle", ExactSpelling=true)]
		private static extern IntPtr A64CtkGetReplicatedHandle(IntPtr hCtk);

		//----- ●AjcCtkGetCurToken ----------------------------------------------------------------------------//
		public static ECtkCode	AjcCtkGetCurToken(IntPtr hCtk)
		{
			ECtkCode	rc;
			if (Is32Bit()) rc = A32CtkGetCurToken(hCtk);
			else		   rc = A64CtkGetCurToken(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetCurToken@4", ExactSpelling=true)]
		private static extern ECtkCode A32CtkGetCurToken(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetCurToken", ExactSpelling=true)]
		private static extern ECtkCode A64CtkGetCurToken(IntPtr hCtk);

		//----- ●AjcCtkGetCurSuffix ---------------------------------------------------------------------------//
		public static ECtkSuf	AjcCtkGetCurSuffix(IntPtr hCtk)
		{
			ECtkSuf		rc;
			if (Is32Bit()) rc = A32CtkGetCurSuffix(hCtk);
			else		   rc = A64CtkGetCurSuffix(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetCurSuffix@4", ExactSpelling=true)]
		private static extern ECtkSuf A32CtkGetCurSuffix(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetCurSuffix", ExactSpelling=true)]
		private static extern ECtkSuf A64CtkGetCurSuffix(IntPtr hCtk);

		//----- ●AjcCtkGetCurFlag -----------------------------------------------------------------------------//
		public static ECtkFlg	AjcCtkGetCurFlag(IntPtr hCtk)
		{
			ECtkFlg		rc;
			if (Is32Bit()) rc = (ECtkFlg)A32CtkGetCurFlag(hCtk);
			else		   rc = (ECtkFlg)A64CtkGetCurFlag(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetCurFlag@4", ExactSpelling=true)]
		private static extern int A32CtkGetCurFlag(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetCurFlag", ExactSpelling=true)]
		private static extern int A64CtkGetCurFlag(IntPtr hCtk);

		//----- ●AjcCtkGetCurLineNumber -----------------------------------------------------------------------//
		public static int	AjcCtkGetCurLineNumber(IntPtr hCtk)
		{
			int		rc;
			if (Is32Bit()) rc = A32CtkGetCurLineNumber(hCtk);
			else		   rc = A64CtkGetCurLineNumber(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetCurLineNumber@4", ExactSpelling=true)]
		private static extern int A32CtkGetCurLineNumber(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetCurLineNumber", ExactSpelling=true)]
		private static extern int A64CtkGetCurLineNumber(IntPtr hCtk);

		//----- ●AjcCtkGetCurPosition -------------------------------------------------------------------------//
		public static int	AjcCtkGetCurPosition(IntPtr hCtk, int TabWidth)
		{
			int		rc;
			if (Is32Bit()) rc = A32CtkGetCurPosition(hCtk, TabWidth);
			else		   rc = A64CtkGetCurPosition(hCtk, TabWidth);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetCurPosition@8", ExactSpelling=true)]
		private static extern int A32CtkGetCurPosition(IntPtr hCtk, int TabWidth);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetCurPosition", ExactSpelling=true)]
		private static extern int A64CtkGetCurPosition(IntPtr hCtk, int TabWidth);

		//----- ●AjcCtkGetCurError ----------------------------------------------------------------------------//
		public static ECtkError	AjcCtkGetCurError(IntPtr hCtk)
		{
			ECtkError		rc;
			if (Is32Bit()) rc = A32CtkGetCurError(hCtk);
			else		   rc = A64CtkGetCurError(hCtk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkGetCurError@4", ExactSpelling=true)]
		private static extern ECtkError A32CtkGetCurError(IntPtr hCtk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkGetCurError", ExactSpelling=true)]
		private static extern ECtkError A64CtkGetCurError(IntPtr hCtk);

		//----- ●AjcCtkIsUsrSym -------------------------------------------------------------------------------//
		public static bool	AjcCtkIsUsrSym(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsUsrSym(tkn);
			else		   rc = A64CtkIsUsrSym(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsUsrSym@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsUsrSym(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsUsrSym", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsUsrSym(ECtkCode tkn);

		//----- ●AjcCtkIsRsvSym -------------------------------------------------------------------------------//
		public static bool	AjcCtkIsRsvSym(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsRsvSym(tkn);
			else		   rc = A64CtkIsRsvSym(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsRsvSym@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsRsvSym(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsRsvSym", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsRsvSym(ECtkCode tkn);

		//----- ●AjcCtkIsValue --------------------------------------------------------------------------------//
		public static bool	AjcCtkIsValue(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsValue(tkn);
			else		   rc = A64CtkIsValue(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsValue@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsValue(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsValue", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsValue(ECtkCode tkn);

		//----- ●AjcCtkIsString -------------------------------------------------------------------------------//
		public static bool	AjcCtkIsString(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsString(tkn);
			else		   rc = A64CtkIsString(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsString@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsString(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsString", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsString(ECtkCode tkn);

		//----- ●AjcCtkIsPathName -----------------------------------------------------------------------------//
		public static bool	AjcCtkIsPathName(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsPathName(tkn);
			else		   rc = A64CtkIsPathName(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsPathName@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsPathName(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsPathName", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsPathName(ECtkCode tkn);

		//----- ●AjcCtkIsDelimit ------------------------------------------------------------------------------//
		public static bool	AjcCtkIsDelimit(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsDelimit(tkn);
			else		   rc = A64CtkIsDelimit(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsDelimit@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsDelimit(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsDelimit", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsDelimit(ECtkCode tkn);

		//----- ●AjcCtkIsSymbol -------------------------------------------------------------------------------//
		public static bool	AjcCtkIsSymbol(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsSymbol(tkn);
			else		   rc = A64CtkIsSymbol(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsSymbol@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsSymbol(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsSymbol", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsSymbol(ECtkCode tkn);

		//----- ●AjcCtkIsValSym -------------------------------------------------------------------------------//
		public static bool	AjcCtkIsValSym(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsValSym(tkn);
			else		   rc = A64CtkIsValSym(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsValSym@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsValSym(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsValSym", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsValSym(ECtkCode tkn);

		//----- ●AjcCtkIsSpace --------------------------------------------------------------------------------//
		public static bool	AjcCtkIsSpace(ECtkCode tkn)
		{
			bool		rc;
			if (Is32Bit()) rc = A32CtkIsSpace(tkn);
			else		   rc = A64CtkIsSpace(tkn);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCtkIsSpace@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CtkIsSpace(ECtkCode tkn);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCtkIsSpace", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CtkIsSpace(ECtkCode tkn);

		//======================================================================================================//
		//	AjcCtrl3dGraphic.h																					//
		//======================================================================================================//

		//----- ●AjcG3dInit -----------------------------------------------------------------------------------//
		public static bool AjcG3dInit(IntPtr hwnd, double x1, double y1, double z1, double x2, double y2, double z2, int style)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dInit(hwnd, x1, y1, z1, x2, y2, z2, style);
			else		   rc = A64G3dInit(hwnd, x1, y1, z1, x2, y2, z2, style);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dInit@56", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dInit(IntPtr hwnd, double x1, double y1, double z1, double x2, double y2, double z2, int style);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dInit", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dInit(IntPtr hwnd, double x1, double y1, double z1, double x2, double y2, double z2, int style);

		//----- ●AjcG3dInitV ----------------------------------------------------------------------------------//

		//----- ●AjcG3dSetProp --------------------------------------------------------------------------------//

		//----- ●AjcG3dAdjustRange ----------------------------------------------------------------------------//
		public static bool AjcG3dAdjustRange(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dAdjustRange(hwnd);
			else		   rc = A64G3dAdjustRange(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dAdjustRange@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dAdjustRange(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dAdjustRange", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dAdjustRange(IntPtr hwnd);

		//----- ●AjcG3dSetRange -------------------------------------------------------------------------------//
		public static bool AjcG3dSetRange(IntPtr hwnd, double x1, double y1, double z1, double x2, double y2, double z2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetRange(hwnd, x1, y1, z1, x2, y2, z2);
			else		   rc = A64G3dSetRange(hwnd, x1, y1, z1, x2, y2, z2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetRange@52", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetRange(IntPtr hwnd, double x1, double y1, double z1, double x2, double y2, double z2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetRange", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetRange(IntPtr hwnd,double x1,double y1,double z1,double x2,double y2,double z2);

		//----- ●AjcG3dSetCenter ------------------------------------------------------------------------------//
		public static bool AjcG3dSetCenter(IntPtr hwnd, double xc, double yc, double zc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetCenter(hwnd, xc, yc, zc);
			else		   rc = A64G3dSetCenter(hwnd, xc, yc, zc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetCenter@28", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetCenter(IntPtr hwnd, double xc, double yc, double zc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetCenter", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetCenter(IntPtr hwnd,double xc,double yc,double zc);

		//----- ●AjcG3dSetWidth -------------------------------------------------------------------------------//
		public static bool AjcG3dSetWidth(IntPtr hwnd, double xr, double yr, double zr)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetWidth(hwnd, xr, yr, zr);
			else		   rc = A64G3dSetWidth(hwnd, xr, yr, zr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetWidth@28", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetWidth(IntPtr hwnd, double xr, double yr, double zr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetWidth", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetWidth(IntPtr hwnd,double xr,double yr,double zr);

		//----- ●AjcG3dClearAllShape --------------------------------------------------------------------------//
		public static bool AjcG3dClearAllShape(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dClearAllShape(hwnd);
			else		   rc = A64G3dClearAllShape(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dClearAllShape@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dClearAllShape(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dClearAllShape", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dClearAllShape(IntPtr hwnd);

		//----- ●AjcG3dSetSameRangeWidth ----------------------------------------------------------------------//
		public static bool AjcG3dSetSameRangeWidth(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetSameRangeWidth(hwnd);
			else		   rc = A64G3dSetSameRangeWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSameRangeWidth@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetSameRangeWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSameRangeWidth", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetSameRangeWidth(IntPtr hwnd);

		//----- ●AjcG3dSetFixedAspect -------------------------------------------------------------------------//
		public static bool AjcG3dSetFixedAspect(IntPtr hwnd, bool fFixed)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetFixedAspect(hwnd, fFixed);
			else		   rc = A64G3dSetFixedAspect(hwnd, fFixed);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetFixedAspect@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetFixedAspect(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fFixed);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetFixedAspect", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetFixedAspect(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool fFixed);

		//----- ●AjcG3dSetColor -------------------------------------------------------------------------------//
		public static bool AjcG3dSetColor(IntPtr hwnd, int id, int rgbP, int rgbN)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetColor(hwnd, id, rgbP, rgbN);
			else		   rc = A64G3dSetColor(hwnd, id, rgbP, rgbN);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetColor@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetColor(IntPtr hwnd, int id, int rgbP, int rgbN);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetColor", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetColor(IntPtr hwnd,int id, int rgbP, int rgbN);

		//----- ●AjcG3dClearPlot ------------------------------------------------------------------------------//
		public static bool AjcG3dClearPlot(IntPtr hwnd, int id)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dClearPlot(hwnd, id);
			else		   rc = A64G3dClearPlot(hwnd, id);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dClearPlot@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dClearPlot(IntPtr hwnd, int id);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dClearPlot", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dClearPlot(IntPtr hwnd,int id);

		//----- ●AjcG3dSetPlotNumber --------------------------------------------------------------------------//
		public static bool AjcG3dSetPlotNumber(IntPtr hwnd, int id, int PlotNumber)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetPlotNumber(hwnd, id, PlotNumber);
			else		   rc = A64G3dSetPlotNumber(hwnd, id, PlotNumber);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetPlotNumber@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetPlotNumber(IntPtr hwnd, int id, int PlotNumber);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetPlotNumber", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetPlotNumber(IntPtr hwnd,int id,int PlotNumber);

		//----- ●AjcG3dSetPlotSize ----------------------------------------------------------------------------//
		public static bool AjcG3dSetPlotSize(IntPtr hwnd, int id, int PixelSize, int PixelSizeE)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetPlotSize(hwnd, id, PixelSize, PixelSizeE);
			else		   rc = A64G3dSetPlotSize(hwnd, id, PixelSize, PixelSizeE);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetPlotSize@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetPlotSize(IntPtr hwnd, int id, int PixelSize, int PixelSizeE);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetPlotSize", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetPlotSize(IntPtr hwnd,int id,int PixelSize,int PixelSizeE);

		//----- ●AjcG3dClearShape -----------------------------------------------------------------------------//
		public static bool AjcG3dClearShape(IntPtr hwnd, int id)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dClearShape(hwnd, id);
			else		   rc = A64G3dClearShape(hwnd, id);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dClearShape@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dClearShape(IntPtr hwnd, int id);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dClearShape", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dClearShape(IntPtr hwnd,int id);

		//----- ●AjcG3dPutPlotData ----------------------------------------------------------------------------//
		public static bool AjcG3dPutPlotData(IntPtr hwnd, int id, double x, double y, double z)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dPutPlotData(hwnd, id, x, y, z);
			else		   rc = A64G3dPutPlotData(hwnd, id, x, y, z);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dPutPlotData@32", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dPutPlotData(IntPtr hwnd, int id, double x, double y, double z);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dPutPlotData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dPutPlotData(IntPtr hwnd,int id,double x,double y,double z);

		//----- ●AjcG3dPutPlotDataV ---------------------------------------------------------------------------//

		//----- ●AjcG3dPixel ----------------------------------------------------------------------------------//
		public static bool AjcG3dPixel(IntPtr hwnd, int id, double x, double y, double z, int PixelSize)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dPixel(hwnd, id, x, y, z, PixelSize);
			else		   rc = A64G3dPixel(hwnd, id, x, y, z, PixelSize);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dPixel@36", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dPixel(IntPtr hwnd, int id, double x, double y, double z, int PixelSize);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dPixel", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dPixel(IntPtr hwnd,int id,double x,double y,double z,int PixelSize);

		//----- ●AjcG3dLine -----------------------------------------------------------------------------------//
		public static bool AjcG3dLine(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dLine(hwnd, id, x1, y1, z1, x2, y2, z2);
			else		   rc = A64G3dLine(hwnd, id, x1, y1, z1, x2, y2, z2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dLine@56", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dLine(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dLine", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dLine(IntPtr hwnd,int id,double x1,double y1,double z1,double x2,double y2,double z2);

		//----- ●AjcG3dMoveTo ---------------------------------------------------------------------------------//
		public static bool AjcG3dMoveTo(IntPtr hwnd, int id, double x, double y, double z)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dMoveTo(hwnd, id, x, y, z);
			else		   rc = A64G3dMoveTo(hwnd, id, x, y, z);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dMoveTo@32", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dMoveTo(IntPtr hwnd, int id, double x, double y, double z);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dMoveTo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dMoveTo(IntPtr hwnd, int id, double x, double y, double z);

		//----- ●AjcG3dLineTo ---------------------------------------------------------------------------------//
		public static bool AjcG3dLineTo(IntPtr hwnd, int id, double x, double y, double z)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dLineTo(hwnd, id, x, y, z);
			else		   rc = A64G3dLineTo(hwnd, id, x, y, z);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dLineTo@32", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dLineTo(IntPtr hwnd, int id, double x, double y, double z);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dLineTo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dLineTo(IntPtr hwnd, int id, double x, double y, double z);

		//----- ●AjcG3dArrow ----------------------------------------------------------------------------------//
		public static bool AjcG3dArrow(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dArrow(hwnd, id, x1, y1, z1, x2, y2, z2);
			else		   rc = A64G3dArrow(hwnd, id, x1, y1, z1, x2, y2, z2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dArrow@56", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dArrow(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dArrow", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dArrow(IntPtr hwnd,int id,double x1,double y1,double z1,double x2,double y2,double z2);

		//----- ●AjcG3dArrowTo --------------------------------------------------------------------------------//
		public static bool AjcG3dArrowTo(IntPtr hwnd, int id, double x, double y, double z)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dArrowTo(hwnd, id, x, y, z);
			else		   rc = A64G3dArrowTo(hwnd, id, x, y, z);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dArrowTo@32", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dArrowTo(IntPtr hwnd, int id, double x, double y, double z);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dArrowTo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dArrowTo(IntPtr hwnd, int id, double x, double y, double z);

		//----- ●AjcG3dTriangle -------------------------------------------------------------------------------//
		public static bool AjcG3dTriangle(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dTriangle(hwnd, id, x1, y1, z1, x2, y2, z2, x3, y3, z3);
			else		   rc = A64G3dTriangle(hwnd, id, x1, y1, z1, x2, y2, z2, x3, y3, z3);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dTriangle@80", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dTriangle(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dTriangle", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dTriangle(IntPtr hwnd,int id,double x1,double y1,double z1,double x2,double y2,double z2,double x3,double y3,double z3);

		//----- ●AjcG3dSquare ---------------------------------------------------------------------------------//
		public static bool AjcG3dSquare(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSquare(hwnd, id, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
			else		   rc = A64G3dSquare(hwnd, id, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSquare@104", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSquare(IntPtr hwnd, int id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSquare", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSquare(IntPtr hwnd,int id,double x1,double y1,double z1,double x2,double y2,double z2,double x3,double y3,double z3,double x4,double y4,double z4);

		//----- ●AjcG3dCube -----------------------------------------------------------------------------------//
		public static bool AjcG3dCube(IntPtr hwnd, int id, double xc, double yc, double zc, double xr, double yr, double zr, int division)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dCube(hwnd, id, xc, yc, zc, xr, yr, zr, division);
			else		   rc = A64G3dCube(hwnd, id, xc, yc, zc, xr, yr, zr, division);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dCube@60", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dCube(IntPtr hwnd, int id, double xc, double yc, double zc, double xr, double yr, double zr, int division);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dCube", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dCube(IntPtr hwnd,int id,double xc,double yc,double zc,double xr,double yr,double zr,int division);

		//----- ●AjcG3dSphere ---------------------------------------------------------------------------------//
		public static bool AjcG3dSphere(IntPtr hwnd, int id, double xc, double yc, double zc, double xr, double yr, double zr, int slice, int stack)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSphere(hwnd, id, xc, yc, zc, xr, yr, zr, slice, stack);
			else		   rc = A64G3dSphere(hwnd, id, xc, yc, zc, xr, yr, zr, slice, stack);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSphere@64", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSphere(IntPtr hwnd, int id, double xc, double yc, double zc, double xr, double yr, double zr, int slice, int stack);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSphere", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSphere(IntPtr hwnd,int id,double xc,double yc,double zc,double xr,double yr,double zr,int slice,int stack);

		//----- ●AjcG3dDefPlane -------------------------------------------------------------------------------//
		public static bool AjcG3dDefPlane(IntPtr hwnd, int id, double xc, double yc, double zc, double xv, double yv, double zv, double xo, double yo, double zo)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dDefPlane(hwnd, id, xc, yc, zc, xv, yv, zv, xo, yo, zo);
			else		   rc = A64G3dDefPlane(hwnd, id, xc, yc, zc, xv, yv, zv, xo, yo, zo);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dDefPlane@80", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dDefPlane(IntPtr hwnd, int id, double xc, double yc, double zc, double xv, double yv, double zv, double xo, double yo, double zo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dDefPlane", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dDefPlane(IntPtr hwnd,int id,double xc,double yc,double zc,double xv,double yv,double zv,double xo,double yo,double zo);

		//----- ●AjcG3dSetAngle -------------------------------------------------------------------------------//
		public static bool AjcG3dSetAngle(IntPtr hwnd, double rtx, double rty, double rtz)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetAngle(hwnd, rtx, rty, rtz);
			else		   rc = A64G3dSetAngle(hwnd, rtx, rty, rtz);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetAngle@28", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetAngle(IntPtr hwnd, double rtx, double rty, double rtz);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetAngle", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetAngle(IntPtr hwnd,double rtx,double rty,double rtz);

		//----- ●AjcG3dSetAngleV ------------------------------------------------------------------------------//
		public static bool AjcG3dSetAngleV(IntPtr hwnd, ref AJC3DVEC pVSiten)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetAngleV(hwnd, ref pVSiten);
			else		   rc = A64G3dSetAngleV(hwnd, ref pVSiten);
			return rc;
		}
		//-----------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetAngleV@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetAngleV(IntPtr hwnd, ref AJC3DVEC pVSiten);
		//-----------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetAngleV", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetAngleV(IntPtr hwnd, ref AJC3DVEC pVSiten);

		//----- ●AjcG3dSetAngleXY -----------------------------------------------------------------------------//
		public static bool AjcG3dSetAngleXY(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetAngleXY(hwnd);
			else		   rc = A64G3dSetAngleXY(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetAngleXY@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetAngleXY(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetAngleXY", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetAngleXY(IntPtr hwnd);

		//----- ●AjcG3dSetAngleXZ -----------------------------------------------------------------------------//
		public static bool AjcG3dSetAngleXZ(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetAngleXZ(hwnd);
			else		   rc = A64G3dSetAngleXZ(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetAngleXZ@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetAngleXZ(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetAngleXZ", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetAngleXZ(IntPtr hwnd);

		//----- ●AjcG3dSetAngleYZ -----------------------------------------------------------------------------//
		public static bool AjcG3dSetAngleYZ(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetAngleYZ(hwnd);
			else		   rc = A64G3dSetAngleYZ(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetAngleYZ@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetAngleYZ(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetAngleYZ", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetAngleYZ(IntPtr hwnd);

		//----- ●AjcG3dSetAngle3D -----------------------------------------------------------------------------//
		public static bool AjcG3dSetAngle3D(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetAngle3D(hwnd);
			else		   rc = A64G3dSetAngle3D(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetAngle3D@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetAngle3D(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetAngle3D", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetAngle3D(IntPtr hwnd);

		//----- ●AjcG3dSetPlane -----------------------------------------------------------------------------//
		public static bool AjcG3dSetPlane(IntPtr hwnd, int HoriAxis, int VertAxis)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSetPlane(hwnd, HoriAxis, VertAxis);
			else		   rc = A64G3dSetPlane(hwnd, HoriAxis, VertAxis);
			return rc;
		}
		//----------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetPlane@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetPlane(IntPtr hwnd, int HoriAxis, int VertAxis);
		//----------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetPlane", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetPlane(IntPtr hwnd, int HoriAxis, int VertAxis);

		//----- ●AjcG3dLoadProp -------------------------------------------------------------------------------//
		public static bool AjcG3dLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dLoadProp(hwnd, pProfileSect, pDefProp);
			else		   rc = A64G3dLoadProp(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dLoadPropW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dLoadPropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dLoadProp(IntPtr hwnd,string pProfileSect,IntPtr pDefProp);

		//----- ●AjcG3dSaveProp -------------------------------------------------------------------------------//
		public static bool AjcG3dSaveProp(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSaveProp(hwnd, pProfileSect);
			else		   rc = A64G3dSaveProp(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSavePropW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSaveProp(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSavePropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSaveProp(IntPtr hwnd,string pProfileSect);

		//----- ●AjcG3dLoadPropEx -----------------------------------------------------------------------------//
		public static bool AjcG3dLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dLoadPropEx(hwnd, pProfileSect, pDefProp);
			else		   rc = A64G3dLoadPropEx(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dLoadPropExW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dLoadPropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dLoadPropEx(IntPtr hwnd,string pProfileSect,IntPtr pDefProp);

		//----- ●AjcG3dSavePropEx -----------------------------------------------------------------------------//
		public static bool AjcG3dSavePropEx(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dSavePropEx(hwnd, pProfileSect);
			else		   rc = A64G3dSavePropEx(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSavePropExW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSavePropEx(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSavePropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSavePropEx(IntPtr hwnd,string pProfileSect);

		//----- ●AjcG2dInit -----------------------------------------------------------------------------------//
		public static bool AjcG2dInit(IntPtr hwnd, double x1, double y1, double x2, double y2, int style)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dInit(hwnd, x1, y1, x2, y2, style);
			else		   rc = A64G2dInit(hwnd, x1, y1, x2, y2, style);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dInit@40", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dInit(IntPtr hwnd, double x1, double y1, double x2, double y2, int style);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dInit", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dInit(IntPtr hwnd,double x1,double y1,double x2,double y2,int style);

		//----- ●AjcG2dAdjustRange ----------------------------------------------------------------------------//
		public static bool AjcG2dAdjustRange(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dAdjustRange(hwnd);
			else		   rc = A64G2dAdjustRange(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dAdjustRange@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dAdjustRange(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dAdjustRange", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dAdjustRange(IntPtr hwnd);

		//----- ●AjcG2dSetRange -------------------------------------------------------------------------------//
		public static bool AjcG2dSetRange(IntPtr hwnd, double x1, double y1, double x2, double y2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetRange(hwnd, x1, y1, x2, y2);
			else		   rc = A64G2dSetRange(hwnd, x1, y1, x2, y2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetRange@36", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetRange(IntPtr hwnd, double x1, double y1, double x2, double y2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetRange", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetRange(IntPtr hwnd,double x1,double y1,double x2,double y2);

		//----- ●AjcG2dSetCenter ------------------------------------------------------------------------------//
		public static bool AjcG2dSetCenter(IntPtr hwnd, double xc, double yc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetCenter(hwnd, xc, yc);
			else		   rc = A64G2dSetCenter(hwnd, xc, yc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetCenter@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetCenter(IntPtr hwnd, double xc, double yc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetCenter", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetCenter(IntPtr hwnd,double xc,double yc);

		//----- ●AjcG2dSetWidth -------------------------------------------------------------------------------//
		public static bool AjcG2dSetWidth(IntPtr hwnd, double xr, double yr)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetWidth(hwnd, xr, yr);
			else		   rc = A64G2dSetWidth(hwnd, xr, yr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetWidth@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetWidth(IntPtr hwnd, double xr, double yr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetWidth", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetWidth(IntPtr hwnd,double xr,double yr);

		//----- ●AjcG2dClearAllShape --------------------------------------------------------------------------//
		public static bool AjcG2dClearAllShape(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dClearAllShape(hwnd);
			else		   rc = A64G2dClearAllShape(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dClearAllShape@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dClearAllShape(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dClearAllShape", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dClearAllShape(IntPtr hwnd);

		//----- ●AjcG2dSetSameRangeWidth ----------------------------------------------------------------------//
		public static bool AjcG2dSetSameRangeWidth(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetSameRangeWidth(hwnd);
			else		   rc = A64G2dSetSameRangeWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetSameRangeWidth@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetSameRangeWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetSameRangeWidth", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetSameRangeWidth(IntPtr hwnd);

		//----- ●AjcG2dSetFixedAspect -------------------------------------------------------------------------//
		public static bool AjcG2dSetFixedAspect(IntPtr hwnd, bool fFixed)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetFixedAspect(hwnd, fFixed);
			else		   rc = A64G2dSetFixedAspect(hwnd, fFixed);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetFixedAspect@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetFixedAspect(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fFixed);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetFixedAspect", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetFixedAspect(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool fFixed);

		//----- ●AjcG2dSetColor -------------------------------------------------------------------------------//
		public static bool AjcG2dSetColor(IntPtr hwnd, int id, int rgb)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetColor(hwnd, id, rgb);
			else		   rc = A64G2dSetColor(hwnd, id, rgb);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetColor@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetColor(IntPtr hwnd, int id, int rgb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetColor", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetColor(IntPtr hwnd,int id, int rgb);

		//----- ●AjcG2dClearPlot ------------------------------------------------------------------------------//
		public static bool AjcG2dClearPlot(IntPtr hwnd, int id)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dClearPlot(hwnd, id);
			else		   rc = A64G2dClearPlot(hwnd, id);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dClearPlot@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dClearPlot(IntPtr hwnd, int id);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dClearPlot", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dClearPlot(IntPtr hwnd,int id);

		//----- ●AjcG2dSetPlotNumber --------------------------------------------------------------------------//
		public static bool AjcG2dSetPlotNumber(IntPtr hwnd, int id, int PlotNumber)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetPlotNumber(hwnd, id, PlotNumber);
			else		   rc = A64G2dSetPlotNumber(hwnd, id, PlotNumber);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetPlotNumber@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetPlotNumber(IntPtr hwnd, int id, int PlotNumber);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetPlotNumber", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetPlotNumber(IntPtr hwnd,int id,int PlotNumber);

		//----- ●AjcG2dSetPlotSize ----------------------------------------------------------------------------//
		public static bool AjcG2dSetPlotSize(IntPtr hwnd, int id, int PixelSize, int PixelSizeE)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSetPlotSize(hwnd, id, PixelSize, PixelSizeE);
			else		   rc = A64G2dSetPlotSize(hwnd, id, PixelSize, PixelSizeE);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSetPlotSize@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSetPlotSize(IntPtr hwnd, int id, int PixelSize, int PixelSizeE);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSetPlotSize", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSetPlotSize(IntPtr hwnd,int id,int PixelSize,int PixelSizeE);

		//----- ●AjcG2dClearShape -----------------------------------------------------------------------------//
		public static bool AjcG2dClearShape(IntPtr hwnd, int id)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dClearShape(hwnd, id);
			else		   rc = A64G2dClearShape(hwnd, id);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dClearShape@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dClearShape(IntPtr hwnd, int id);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dClearShape", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dClearShape(IntPtr hwnd,int id);

		//----- ●AjcG2dPutPlotData ----------------------------------------------------------------------------//
		public static bool AjcG2dPutPlotData(IntPtr hwnd, int id, double x, double y)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dPutPlotData(hwnd, id, x, y);
			else		   rc = A64G2dPutPlotData(hwnd, id, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dPutPlotData@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dPutPlotData(IntPtr hwnd, int id, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dPutPlotData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dPutPlotData(IntPtr hwnd,int id,double x,double y);

		//----- ●AjcG2dLoadProp -------------------------------------------------------------------------------//
		public static bool AjcG2dLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dLoadProp(hwnd, pProfileSect, pDefProp);
			else		   rc = A64G2dLoadProp(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dLoadPropW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dLoadPropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dLoadProp(IntPtr hwnd,string pProfileSect,IntPtr pDefProp);

		//----- ●AjcG2dSaveProp -------------------------------------------------------------------------------//
		public static bool AjcG2dSaveProp(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSaveProp(hwnd, pProfileSect);
			else		   rc = A64G2dSaveProp(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSavePropW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSaveProp(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSavePropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSaveProp(IntPtr hwnd,string pProfileSect);

		//----- ●AjcG2dLoadPropEx -----------------------------------------------------------------------------//
		public static bool AjcG2dLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dLoadPropEx(hwnd, pProfileSect, pDefProp);
			else		   rc = A64G2dLoadPropEx(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dLoadPropExW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dLoadPropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dLoadPropEx(IntPtr hwnd,string pProfileSect,IntPtr pDefProp);

		//----- ●AjcG2dSavePropEx -----------------------------------------------------------------------------//
		public static bool AjcG2dSavePropEx(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSavePropEx(hwnd, pProfileSect);
			else		   rc = A64G2dSavePropEx(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSavePropExW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSavePropEx(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSavePropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSavePropEx(IntPtr hwnd,string pProfileSect);

		//----- ●AjcG2dFillB ----------------------------------------------------------------------------------//
		public static bool AjcG2dFillB(IntPtr hwnd, int id, int idBorder, double x, double y)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dFillB(hwnd, id, idBorder, x, y);
			else		   rc = A64G2dFillB(hwnd, id, idBorder, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dFillB@28", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dFillB(IntPtr hwnd, int id, int idBorder, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dFillB", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dFillB(IntPtr hwnd,int id,int idBorder,double x,double y);

		//----- ●AjcG2dFillBV ---------------------------------------------------------------------------------//

		//----- ●AjcG2dFillS ----------------------------------------------------------------------------------//
		public static bool AjcG2dFillS(IntPtr hwnd, int id, double x, double y)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dFillS(hwnd, id, x, y);
			else		   rc = A64G2dFillS(hwnd, id, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dFillS@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dFillS(IntPtr hwnd, int id, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dFillS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dFillS(IntPtr hwnd,int id,double x,double y);

		//----- ●AjcG2dGetPixel -------------------------------------------------------------------------------//
		public static int AjcG2dGetPixel(IntPtr hwnd, double x, double y)
		{
			int	rc;
			if (Is32Bit()) rc = A32G2dGetPixel(hwnd, x, y);
			else		   rc = A64G2dGetPixel(hwnd, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dGetPixel@20", ExactSpelling=true)]
		private static extern int A32G2dGetPixel(IntPtr hwnd, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dGetPixel", ExactSpelling=true)]
		private static extern int A64G2dGetPixel(IntPtr hwnd,double x,double y);

		//----- ●AjcG2dPixel ----------------------------------------------------------------------------------//
		public static bool AjcG2dPixel(IntPtr hwnd, int id, double x, double y, int PixelSize)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dPixel(hwnd, id, x, y, PixelSize);
			else		   rc = A64G2dPixel(hwnd, id, x, y, PixelSize);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dPixel@28", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dPixel(IntPtr hwnd, int id, double x, double y, int PixelSize);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dPixel", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dPixel(IntPtr hwnd,int id,double x,double y,int PixelSize);

		//----- ●AjcG2dLine -----------------------------------------------------------------------------------//
		public static bool AjcG2dLine(IntPtr hwnd, int id, double x1, double y1, double x2, double y2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dLine(hwnd, id, x1, y1, x2, y2);
			else		   rc = A64G2dLine(hwnd, id, x1, y1, x2, y2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dLine@40", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dLine(IntPtr hwnd, int id, double x1, double y1, double x2, double y2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dLine", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dLine(IntPtr hwnd,int id,double x1,double y1,double x2,double y2);

		//----- ●AjcG2dMoveTo ---------------------------------------------------------------------------------//
		public static bool AjcG2dMoveTo(IntPtr hwnd, int id, double x, double y)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dMoveTo(hwnd, id, x, y);
			else		   rc = A64G2dMoveTo(hwnd, id, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dMoveTo@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dMoveTo(IntPtr hwnd, int id, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dMoveTo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dMoveTo(IntPtr hwnd, int id, double x, double y);

		//----- ●AjcG2dLineTo ---------------------------------------------------------------------------------//
		public static bool AjcG2dLineTo(IntPtr hwnd, int id, double x, double y)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dLineTo(hwnd, id, x, y);
			else		   rc = A64G2dLineTo(hwnd, id, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dLineTo@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dLineTo(IntPtr hwnd, int id, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dLineTo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dLineTo(IntPtr hwnd, int id, double x, double y);

		//----- ●AjcG2dArrow ----------------------------------------------------------------------------------//
		public static bool AjcG2dArrow(IntPtr hwnd, int id, double x1, double y1, double x2, double y2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dArrow(hwnd, id, x1, y1, x2, y2);
			else		   rc = A64G2dArrow(hwnd, id, x1, y1, x2, y2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dArrow@40", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dArrow(IntPtr hwnd, int id, double x1, double y1, double x2, double y2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dArrow", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dArrow(IntPtr hwnd,int id,double x1,double y1,double x2,double y2);

		//----- ●AjcG2dArrowTo --------------------------------------------------------------------------------//
		public static bool AjcG2dArrowTo(IntPtr hwnd, int id, double x, double y)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dArrowTo(hwnd, id, x, y);
			else		   rc = A64G2dArrowTo(hwnd, id, x, y);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dArrowTo@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dArrowTo(IntPtr hwnd, int id, double x, double y);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dArrowTo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dArrowTo(IntPtr hwnd, int id, double x, double y);

		//----- ●AjcG2dTriangle -------------------------------------------------------------------------------//
		public static bool AjcG2dTriangle(IntPtr hwnd, int id, double x1, double y1, double x2, double y2, double x3, double y3)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dTriangle(hwnd, id, x1, y1, x2, y2, x3, y3);
			else		   rc = A64G2dTriangle(hwnd, id, x1, y1, x2, y2, x3, y3);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dTriangle@56", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dTriangle(IntPtr hwnd, int id, double x1, double y1, double x2, double y2, double x3, double y3);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dTriangle", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dTriangle(IntPtr hwnd,int id,double x1,double y1,double x2,double y2,double x3,double y3);

		//----- ●AjcG2dSquare ---------------------------------------------------------------------------------//
		public static bool AjcG2dSquare(IntPtr hwnd, int id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dSquare(hwnd, id, x1, y1, x2, y2, x3, y3, x4, y4);
			else		   rc = A64G2dSquare(hwnd, id, x1, y1, x2, y2, x3, y3, x4, y4);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dSquare@72", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dSquare(IntPtr hwnd, int id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dSquare", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dSquare(IntPtr hwnd,int id,double x1,double y1,double x2,double y2,double x3,double y3,double x4,double y4);

		//----- ●AjcG2dRectangle ------------------------------------------------------------------------------//
		public static bool AjcG2dRectangle(IntPtr hwnd, int id, double x1, double y1, double x2, double y2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dRectangle(hwnd, id, x1, y1, x2, y2);
			else		   rc = A64G2dRectangle(hwnd, id, x1, y1, x2, y2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dRectangle@40", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dRectangle(IntPtr hwnd, int id, double x1, double y1, double x2, double y2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dRectangle", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dRectangle(IntPtr hwnd,int id,double x1,double y1,double x2,double y2);

		//----- ●AjcG2dRectangleV -----------------------------------------------------------------------------//

		//----- ●AjcG2dEllipse --------------------------------------------------------------------------------//
		public static bool AjcG2dEllipse(IntPtr hwnd, int id, double xc, double yc, double rx, double ry)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dEllipse(hwnd, id, xc, yc, rx, ry);
			else		   rc = A64G2dEllipse(hwnd, id, xc, yc, rx, ry);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dEllipse@40", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dEllipse(IntPtr hwnd, int id, double xc, double yc, double rx, double ry);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dEllipse", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dEllipse(IntPtr hwnd, int id, double xc, double yc, double rx, double ry);

		//----- ●AjcG2dStarEx --------------------------------------------------------------------------------//
		public static bool AjcG2dStarEx(IntPtr hwnd, int id, double xc, double yc, double r1, double r2, int nVertex, double rot, bool fInscribedLine)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G2dStarEx(hwnd, id, xc, yc, r1, r2, nVertex, rot, fInscribedLine);
			else		   rc = A64G2dStarEx(hwnd, id, xc, yc, r1, r2, nVertex, rot, fInscribedLine);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG2dStarEx@56", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G2dStarEx(IntPtr hwnd, int id, double xc, double yc, double r1, double r2, int nVertex, double rot, [MarshalAs(UnmanagedType.Bool)]bool fInscribedLine);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG2dStarEx", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G2dStarEx(IntPtr hwnd, int id, double xc, double yc, double r1, double r2, int nVertex, double rot, [MarshalAs(UnmanagedType.Bool)]bool fInscribedLine);

		//----- ●AjcG3dEnablePopupMenu ------------------------------------------------------------------------//
		public static void AjcG3dEnablePopupMenu(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32G3dEnablePopupMenu(hwnd, fEnable);
			else		   A64G3dEnablePopupMenu(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dEnablePopupMenu@8", ExactSpelling=true)]
		private static extern void A32G3dEnablePopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dEnablePopupMenu", ExactSpelling=true)]
		private static extern void A64G3dEnablePopupMenu(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcG3dSetNtcRClk -----------------------------------------------------------------------------//

		//----- ●AjcG3dSetTipText -----------------------------------------------------------------------------//
		public static void AjcG3dSetTipText(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32G3dSetTipText(hwnd, pTxt);
			else		   A64G3dSetTipText(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetTipTextW@8", ExactSpelling=true)]
		private static extern void A32G3dSetTipText(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetTipTextW", ExactSpelling=true)]
		private static extern void A64G3dSetTipText(IntPtr hwnd,string pTxt);

		//----- ●AjcG3dGetTipText -----------------------------------------------------------------------------//
		public static void AjcG3dGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32G3dGetTipText(hwnd, pBuf, lBuf);
			else		   A64G3dGetTipText(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetTipTextW@12", ExactSpelling=true)]
		private static extern void A32G3dGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetTipTextW", ExactSpelling=true)]
		private static extern void A64G3dGetTipText(IntPtr hwnd,StringBuilder pBuf,int lBuf);

		//----- ●AjcG3dSetChkBoxTipText -----------------------------------------------------------------------//
		public static void AjcG3dSetChkBoxTipText(IntPtr hwnd, int n, string pTxt)
		{
			if (Is32Bit()) A32G3dSetChkBoxTipText(hwnd, n, pTxt);
			else		   A64G3dSetChkBoxTipText(hwnd, n, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetChkBoxTipTextW@12", ExactSpelling=true)]
		private static extern void A32G3dSetChkBoxTipText(IntPtr hwnd, int n, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetChkBoxTipTextW", ExactSpelling=true)]
		private static extern void A64G3dSetChkBoxTipText(IntPtr hwnd, int n,string pTxt);

		//----- ●AjcG3dGetChkBoxTipText -----------------------------------------------------------------------//
		public static void AjcG3dGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32G3dGetChkBoxTipText(hwnd, n, pBuf, lBuf);
			else		   A64G3dGetChkBoxTipText(hwnd, n, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetChkBoxTipTextW@16", ExactSpelling=true)]
		private static extern void A32G3dGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetChkBoxTipTextW", ExactSpelling=true)]
		private static extern void A64G3dGetChkBoxTipText(IntPtr hwnd,int n,StringBuilder pBuf,int lBuf);

		//----- ●AjcG3dSetTipShowAlways -----------------------------------------------------------------------//
		public static void AjcG3dSetTipShowAlways(IntPtr hwnd, bool fShowAlways)
		{
			if (Is32Bit()) A32AjcG3dSetTipShowAlways(hwnd, fShowAlways);
			else		   A64AjcG3dSetTipShowAlways(hwnd, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetTipShowAlways@8", ExactSpelling=true)]
		private static extern void A32AjcG3dSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetTipShowAlways", ExactSpelling=true)]
		private static extern void A64AjcG3dSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);

		//----- ●AjcG3dSetChkBoxTipShowAlways -----------------------------------------------------------------------//
		public static void AjcG3dSetChkBoxTipShowAlways(IntPtr hwnd, int n, bool fShowAlways)
		{
			if (Is32Bit()) A32AjcG3dSetChkBoxTipShowAlways(hwnd, n, fShowAlways);
			else		   A64AjcG3dSetChkBoxTipShowAlways(hwnd, n, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetChkBoxTipShowAlways@12", ExactSpelling=true)]
		private static extern void A32AjcG3dSetChkBoxTipShowAlways(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetChkBoxTipShowAlways", ExactSpelling=true)]
		private static extern void A64AjcG3dSetChkBoxTipShowAlways(IntPtr hwnd,int n, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);

		//----- ●AjcG3dSetFilter ------------------------------------------------------------------------------//
		public static void AjcG3dSetFilter(IntPtr hwnd, int n, bool state)
		{
			if (Is32Bit()) A32G3dSetFilter(hwnd, n, state);
			else		   A64G3dSetFilter(hwnd, n, state);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetFilter@12", ExactSpelling=true)]
		private static extern void A32G3dSetFilter(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)] bool state);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetFilter", ExactSpelling=true)]
		private static extern void A64G3dSetFilter(IntPtr hwnd,int n,[MarshalAs(UnmanagedType.Bool)] bool state);

		//----- ●AjcG3dGetFilter ------------------------------------------------------------------------------//
		public static bool AjcG3dGetFilter(IntPtr hwnd, int n)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetFilter(hwnd, n);
			else		   rc = A64G3dGetFilter(hwnd, n);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetFilter@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetFilter(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetFilter", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetFilter(IntPtr hwnd,int n);

		//----- ●AjcG3dGetDroppedFile -------------------------------------------------------------------------//
		public static string AjcG3dGetDroppedFile(IntPtr hwnd)
		{
			string	rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32G3dGetDroppedFile(hwnd, s)) rc = s.ToString();
				else											rc = "";
			}
			else {
				if (A64G3dGetDroppedFile(hwnd, s)) rc = s.ToString();
				else											rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetDroppedFileW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetDroppedFile(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcG3dGetDroppedFileW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetDroppedFile(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcG3dGetDroppedDir --------------------------------------------------------------------------//
		public static string AjcG3dGetDroppedDir(IntPtr hwnd)
		{
			string		rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32G3dGetDroppedDir(hwnd, s)) rc = s.ToString();
				else										   rc = "";
			}
			else {
				if (A64G3dGetDroppedDir(hwnd, s)) rc = s.ToString();
				else										   rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetDroppedDirW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetDroppedDir(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcG3dGetDroppedDirW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetDroppedDir(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcG3dSetTitleText ---------------------------------------------------------------------------//
		public static bool AjcG3dSetTitleText(IntPtr hwnd, string Text, Color TextColor, Color BackColor, Font TextFont)
		{
			bool	rc;
			int 	TxtCol = TextColor == Color.Empty ? -1 : (TextColor.B << 16 | TextColor.G << 8 | TextColor.R);
			int 	BakCol = BackColor == Color.Empty ? -1 : (BackColor.B << 16 | BackColor.G << 8 | BackColor.R);
			IntPtr	hFont  = TextFont  == null ?  (IntPtr)0 : TextFont.ToHfont();
			if (Is32Bit()) rc = A32G3dSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			else		   rc = A64G3dSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetTitleTextW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetTitleTextW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);

		//----- ●AjcG3dPause ----------------------------------------------------------------------------------//
		public static void AjcG3dPause(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dPause(hwnd, f);
			else		   A64G3dPause(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dPause@8", ExactSpelling=true)]
		private static extern void A32G3dPause(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dPause", ExactSpelling=true)]
		private static extern void A64G3dPause(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dEnableMesDraw --------------------------------------------------------------------------//
		public static bool AjcG3dEnableMesDraw(IntPtr hwnd, bool f)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dEnableMesDraw(hwnd, f);
			else		   rc = A64G3dEnableMesDraw(hwnd, f);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dEnableMesDraw@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dEnableMesDraw(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dEnableMesDraw", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dEnableMesDraw(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dCreateForMSIL --------------------------------------------------------------------------//
		public static IntPtr AjcG3dCreateForMSIL(IntPtr hOwner, G3dCbkFileDrop CbkFileDrop,
																G3dCbkDirDrop  CbkDirDrop,
																G3dCbkRClick   CbkRClick,
																G3dCbkPltLst   CbkPltLst)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32G3dCreateForMSIL(hOwner, CbkFileDrop,
															CbkDirDrop ,
															CbkRClick  ,
															CbkPltLst);
			else		   rc = A64G3dCreateForMSIL(hOwner, CbkFileDrop,
															CbkDirDrop ,
															CbkRClick,
															CbkPltLst);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dCreateForMSIL@20", ExactSpelling=true)]
		private static extern IntPtr A32G3dCreateForMSIL(IntPtr hOwner, G3dCbkFileDrop	cbFileDrop ,
																		G3dCbkDirDrop	cbDirDrop  ,
																		G3dCbkRClick	cbRClick   ,
																		G3dCbkPltLst	cbPltLst);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64G3dCreateForMSIL(IntPtr hOwner, G3dCbkFileDrop cbFileDrop,
																		G3dCbkDirDrop  cbDirDrop ,
																		G3dCbkRClick   cbRClick	,
																		G3dCbkPltLst   cbPltLst);

		//----- ●AjcG3dGetSty_RECTSCALE -----------------------------------------------------------------------//
		public static bool AjcG3dGetSty_RECTSCALE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_RECTSCALE(hwnd);
			else		   rc = A64G3dGetSty_RECTSCALE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_RECTSCALE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_RECTSCALE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_RECTSCALE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_RECTSCALE(IntPtr hwnd);

		//----- ●AjcG3dSetSty_RECTSCALE -----------------------------------------------------------------------//
		public static void AjcG3dSetSty_RECTSCALE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_RECTSCALE(hwnd, f);
			else		   A64G3dSetSty_RECTSCALE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_RECTSCALE@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_RECTSCALE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_RECTSCALE", ExactSpelling=true)]
		private static extern void A64G3dSetSty_RECTSCALE(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SCALEVALUE_X --------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SCALEVALUE_X(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SCALEVALUE_X(hwnd);
			else		   rc = A64G3dGetSty_SCALEVALUE_X(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SCALEVALUE_X@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SCALEVALUE_X(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SCALEVALUE_X", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SCALEVALUE_X(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SCALEVALUE_X --------------------------------------------------------------------//
		public static void AjcG3dSetSty_SCALEVALUE_X(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SCALEVALUE_X(hwnd, f);
			else		   A64G3dSetSty_SCALEVALUE_X(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SCALEVALUE_X@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SCALEVALUE_X(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SCALEVALUE_X", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SCALEVALUE_X(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SCALEVALUE_Y --------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SCALEVALUE_Y(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SCALEVALUE_Y(hwnd);
			else		   rc = A64G3dGetSty_SCALEVALUE_Y(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SCALEVALUE_Y@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SCALEVALUE_Y(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SCALEVALUE_Y", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SCALEVALUE_Y(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SCALEVALUE_Y --------------------------------------------------------------------//
		public static void AjcG3dSetSty_SCALEVALUE_Y(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SCALEVALUE_Y(hwnd, f);
			else		   A64G3dSetSty_SCALEVALUE_Y(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SCALEVALUE_Y@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SCALEVALUE_Y(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SCALEVALUE_Y", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SCALEVALUE_Y(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SCALEVALUE_Z --------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SCALEVALUE_Z(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SCALEVALUE_Z(hwnd);
			else		   rc = A64G3dGetSty_SCALEVALUE_Z(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SCALEVALUE_Z@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SCALEVALUE_Z(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SCALEVALUE_Z", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SCALEVALUE_Z(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SCALEVALUE_Z --------------------------------------------------------------------//
		public static void AjcG3dSetSty_SCALEVALUE_Z(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SCALEVALUE_Z(hwnd, f);
			else		   A64G3dSetSty_SCALEVALUE_Z(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SCALEVALUE_Z@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SCALEVALUE_Z(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SCALEVALUE_Z", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SCALEVALUE_Z(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_ELPSSCALE -----------------------------------------------------------------------//
		public static bool AjcG3dGetSty_ELPSSCALE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_ELPSSCALE(hwnd);
			else		   rc = A64G3dGetSty_ELPSSCALE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_ELPSSCALE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_ELPSSCALE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_ELPSSCALE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_ELPSSCALE(IntPtr hwnd);

		//----- ●AjcG3dSetSty_ELPSSCALE -----------------------------------------------------------------------//
		public static void AjcG3dSetSty_ELPSSCALE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_ELPSSCALE(hwnd, f);
			else		   A64G3dSetSty_ELPSSCALE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_ELPSSCALE@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_ELPSSCALE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_ELPSSCALE", ExactSpelling=true)]
		private static extern void A64G3dSetSty_ELPSSCALE(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SCALE_XY ------------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SCALE_XY(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SCALE_XY(hwnd);
			else		   rc = A64G3dGetSty_SCALE_XY(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SCALE_XY@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SCALE_XY(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SCALE_XY", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SCALE_XY(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SCALE_XY ------------------------------------------------------------------------//
		public static void AjcG3dSetSty_SCALE_XY(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SCALE_XY(hwnd, f);
			else		   A64G3dSetSty_SCALE_XY(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SCALE_XY@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SCALE_XY(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SCALE_XY", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SCALE_XY(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SCALE_XZ ------------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SCALE_XZ(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SCALE_XZ(hwnd);
			else		   rc = A64G3dGetSty_SCALE_XZ(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SCALE_XZ@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SCALE_XZ(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SCALE_XZ", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SCALE_XZ(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SCALE_XZ ------------------------------------------------------------------------//
		public static void AjcG3dSetSty_SCALE_XZ(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SCALE_XZ(hwnd, f);
			else		   A64G3dSetSty_SCALE_XZ(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SCALE_XZ@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SCALE_XZ(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SCALE_XZ", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SCALE_XZ(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SCALE_YZ ------------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SCALE_YZ(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SCALE_YZ(hwnd);
			else		   rc = A64G3dGetSty_SCALE_YZ(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SCALE_YZ@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SCALE_YZ(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SCALE_YZ", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SCALE_YZ(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SCALE_YZ ------------------------------------------------------------------------//
		public static void AjcG3dSetSty_SCALE_YZ(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SCALE_YZ(hwnd, f);
			else		   A64G3dSetSty_SCALE_YZ(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SCALE_YZ@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SCALE_YZ(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SCALE_YZ", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SCALE_YZ(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_NODEPTHCTRL ---------------------------------------------------------------------//
		public static bool AjcG3dGetSty_NODEPTHCTRL(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_NODEPTHCTRL(hwnd);
			else		   rc = A64G3dGetSty_NODEPTHCTRL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_NODEPTHCTRL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_NODEPTHCTRL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_NODEPTHCTRL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_NODEPTHCTRL(IntPtr hwnd);

		//----- ●AjcG3dSetSty_NODEPTHCTRL ---------------------------------------------------------------------//
		public static void AjcG3dSetSty_NODEPTHCTRL(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_NODEPTHCTRL(hwnd, f);
			else		   A64G3dSetSty_NODEPTHCTRL(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_NODEPTHCTRL@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_NODEPTHCTRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_NODEPTHCTRL", ExactSpelling=true)]
		private static extern void A64G3dSetSty_NODEPTHCTRL(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_NOBORDER ------------------------------------------------------------------------//
		public static bool AjcG3dGetSty_NOBORDER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_NOBORDER(hwnd);
			else		   rc = A64G3dGetSty_NOBORDER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_NOBORDER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_NOBORDER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_NOBORDER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_NOBORDER(IntPtr hwnd);

		//----- ●AjcG3dSetSty_NOBORDER ------------------------------------------------------------------------//
		public static void AjcG3dSetSty_NOBORDER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_NOBORDER(hwnd, f);
			else		   A64G3dSetSty_NOBORDER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_NOBORDER@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_NOBORDER", ExactSpelling=true)]
		private static extern void A64G3dSetSty_NOBORDER(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_NOFILTER ------------------------------------------------------------------------//
		public static bool AjcG3dGetSty_NOFILTER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_NOFILTER(hwnd);
			else		   rc = A64G3dGetSty_NOFILTER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_NOFILTER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_NOFILTER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_NOFILTER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_NOFILTER(IntPtr hwnd);

		//----- ●AjcG3dSetSty_NOFILTER ------------------------------------------------------------------------//
		public static void AjcG3dSetSty_NOFILTER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_NOFILTER(hwnd, f);
			else		   A64G3dSetSty_NOFILTER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_NOFILTER@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_NOFILTER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_NOFILTER", ExactSpelling=true)]
		private static extern void A64G3dSetSty_NOFILTER(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_NOANGLE -------------------------------------------------------------------------//
		public static bool AjcG3dGetSty_NOANGLE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_NOANGLE(hwnd);
			else		   rc = A64G3dGetSty_NOANGLE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_NOANGLE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_NOANGLE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_NOANGLE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_NOANGLE(IntPtr hwnd);

		//----- ●AjcG3dSetSty_NOANGLE -------------------------------------------------------------------------//
		public static void AjcG3dSetSty_NOANGLE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_NOANGLE(hwnd, f);
			else		   A64G3dSetSty_NOANGLE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_NOANGLE@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_NOANGLE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_NOANGLE", ExactSpelling=true)]
		private static extern void A64G3dSetSty_NOANGLE(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SPHERESCALE ---------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SPHERESCALE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SPHERESCALE(hwnd);
			else		   rc = A64G3dGetSty_SPHERESCALE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SPHERESCALE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SPHERESCALE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SPHERESCALE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SPHERESCALE(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SPHERESCALE ---------------------------------------------------------------------//
		public static void AjcG3dSetSty_SPHERESCALE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SPHERESCALE(hwnd, f);
			else		   A64G3dSetSty_SPHERESCALE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SPHERESCALE@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SPHERESCALE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SPHERESCALE", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SPHERESCALE(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SHOWAXIS_X ----------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SHOWAXIS_X(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SHOWAXIS_X(hwnd);
			else		   rc = A64G3dGetSty_SHOWAXIS_X(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SHOWAXIS_X@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SHOWAXIS_X(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SHOWAXIS_X", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SHOWAXIS_X(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SHOWAXIS_X ----------------------------------------------------------------------//
		public static void AjcG3dSetSty_SHOWAXIS_X(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SHOWAXIS_X(hwnd, f);
			else		   A64G3dSetSty_SHOWAXIS_X(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SHOWAXIS_X@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SHOWAXIS_X(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SHOWAXIS_X", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SHOWAXIS_X(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SHOWAXIS_Y ----------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SHOWAXIS_Y(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SHOWAXIS_Y(hwnd);
			else		   rc = A64G3dGetSty_SHOWAXIS_Y(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SHOWAXIS_Y@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SHOWAXIS_Y(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SHOWAXIS_Y", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SHOWAXIS_Y(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SHOWAXIS_Y ----------------------------------------------------------------------//
		public static void AjcG3dSetSty_SHOWAXIS_Y(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SHOWAXIS_Y(hwnd, f);
			else		   A64G3dSetSty_SHOWAXIS_Y(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SHOWAXIS_Y@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SHOWAXIS_Y(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SHOWAXIS_Y", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SHOWAXIS_Y(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetSty_SHOWAXIS_Z ----------------------------------------------------------------------//
		public static bool AjcG3dGetSty_SHOWAXIS_Z(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetSty_SHOWAXIS_Z(hwnd);
			else		   rc = A64G3dGetSty_SHOWAXIS_Z(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetSty_SHOWAXIS_Z@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetSty_SHOWAXIS_Z(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetSty_SHOWAXIS_Z", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetSty_SHOWAXIS_Z(IntPtr hwnd);

		//----- ●AjcG3dSetSty_SHOWAXIS_Z ----------------------------------------------------------------------//
		public static void AjcG3dSetSty_SHOWAXIS_Z(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32G3dSetSty_SHOWAXIS_Z(hwnd, f);
			else		   A64G3dSetSty_SHOWAXIS_Z(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetSty_SHOWAXIS_Z@8", ExactSpelling=true)]
		private static extern void A32G3dSetSty_SHOWAXIS_Z(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetSty_SHOWAXIS_Z", ExactSpelling=true)]
		private static extern void A64G3dSetSty_SHOWAXIS_Z(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcG3dGetProp_Rot_x --------------------------------------------------------------------------//
		public static double AjcG3dGetProp_Rot_x(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_Rot_x(hwnd);
			else		   rc = A64G3dGetProp_Rot_x(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_Rot_x@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_Rot_x(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_Rot_x", ExactSpelling=true)]
		private static extern double A64G3dGetProp_Rot_x(IntPtr hwnd);

		//----- ●AjcG3dSetProp_Rot_x --------------------------------------------------------------------------//
		public static void AjcG3dSetProp_Rot_x(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_Rot_x(hwnd, n);
			else		   A64G3dSetProp_Rot_x(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Rot_x@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Rot_x(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Rot_x", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Rot_x(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_Rot_y --------------------------------------------------------------------------//
		public static double AjcG3dGetProp_Rot_y(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_Rot_y(hwnd);
			else		   rc = A64G3dGetProp_Rot_y(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_Rot_y@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_Rot_y(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_Rot_y", ExactSpelling=true)]
		private static extern double A64G3dGetProp_Rot_y(IntPtr hwnd);

		//----- ●AjcG3dSetProp_Rot_y --------------------------------------------------------------------------//
		public static void AjcG3dSetProp_Rot_y(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_Rot_y(hwnd, n);
			else		   A64G3dSetProp_Rot_y(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Rot_y@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Rot_y(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Rot_y", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Rot_y(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_Rot_z --------------------------------------------------------------------------//
		public static double AjcG3dGetProp_Rot_z(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_Rot_z(hwnd);
			else		   rc = A64G3dGetProp_Rot_z(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_Rot_z@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_Rot_z(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_Rot_z", ExactSpelling=true)]
		private static extern double A64G3dGetProp_Rot_z(IntPtr hwnd);

		//----- ●AjcG3dSetProp_Rot_z --------------------------------------------------------------------------//
		public static void AjcG3dSetProp_Rot_z(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_Rot_z(hwnd, n);
			else		   A64G3dSetProp_Rot_z(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Rot_z@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Rot_z(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Rot_z", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Rot_z(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_Cent_x -------------------------------------------------------------------------//
		public static double AjcG3dGetProp_Cent_x(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_Cent_x(hwnd);
			else		   rc = A64G3dGetProp_Cent_x(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_Cent_x@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_Cent_x(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_Cent_x", ExactSpelling=true)]
		private static extern double A64G3dGetProp_Cent_x(IntPtr hwnd);

		//----- ●AjcG3dSetProp_Cent_x -------------------------------------------------------------------------//
		public static void AjcG3dSetProp_Cent_x(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_Cent_x(hwnd, n);
			else		   A64G3dSetProp_Cent_x(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Cent_x@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Cent_x(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Cent_x", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Cent_x(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_Cent_y -------------------------------------------------------------------------//
		public static double AjcG3dGetProp_Cent_y(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_Cent_y(hwnd);
			else		   rc = A64G3dGetProp_Cent_y(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_Cent_y@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_Cent_y(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_Cent_y", ExactSpelling=true)]
		private static extern double A64G3dGetProp_Cent_y(IntPtr hwnd);

		//----- ●AjcG3dSetProp_Cent_y -------------------------------------------------------------------------//
		public static void AjcG3dSetProp_Cent_y(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_Cent_y(hwnd, n);
			else		   A64G3dSetProp_Cent_y(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Cent_y@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Cent_y(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Cent_y", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Cent_y(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_Cent_z -------------------------------------------------------------------------//
		public static double AjcG3dGetProp_Cent_z(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_Cent_z(hwnd);
			else		   rc = A64G3dGetProp_Cent_z(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_Cent_z@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_Cent_z(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_Cent_z", ExactSpelling=true)]
		private static extern double A64G3dGetProp_Cent_z(IntPtr hwnd);

		//----- ●AjcG3dSetProp_Cent_z -------------------------------------------------------------------------//
		public static void AjcG3dSetProp_Cent_z(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_Cent_z(hwnd, n);
			else		   A64G3dSetProp_Cent_z(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Cent_z@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Cent_z(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Cent_z", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Cent_z(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_xr -----------------------------------------------------------------------------//
		public static double AjcG3dGetProp_xr(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_xr(hwnd);
			else		   rc = A64G3dGetProp_xr(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_xr@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_xr(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_xr", ExactSpelling=true)]
		private static extern double A64G3dGetProp_xr(IntPtr hwnd);

		//----- ●AjcG3dSetProp_xr -----------------------------------------------------------------------------//
		public static void AjcG3dSetProp_xr(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_xr(hwnd, n);
			else		   A64G3dSetProp_xr(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_xr@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_xr(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_xr", ExactSpelling=true)]
		private static extern void A64G3dSetProp_xr(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_yr -----------------------------------------------------------------------------//
		public static double AjcG3dGetProp_yr(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_yr(hwnd);
			else		   rc = A64G3dGetProp_yr(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_yr@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_yr(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_yr", ExactSpelling=true)]
		private static extern double A64G3dGetProp_yr(IntPtr hwnd);

		//----- ●AjcG3dSetProp_yr -----------------------------------------------------------------------------//
		public static void AjcG3dSetProp_yr(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_yr(hwnd, n);
			else		   A64G3dSetProp_yr(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_yr@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_yr(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_yr", ExactSpelling=true)]
		private static extern void A64G3dSetProp_yr(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_zr -----------------------------------------------------------------------------//
		public static double AjcG3dGetProp_zr(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_zr(hwnd);
			else		   rc = A64G3dGetProp_zr(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_zr@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_zr(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_zr", ExactSpelling=true)]
		private static extern double A64G3dGetProp_zr(IntPtr hwnd);

		//----- ●AjcG3dSetProp_zr -----------------------------------------------------------------------------//
		public static void AjcG3dSetProp_zr(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_zr(hwnd, n);
			else		   A64G3dSetProp_zr(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_zr@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_zr(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_zr", ExactSpelling=true)]
		private static extern void A64G3dSetProp_zr(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_ratio --------------------------------------------------------------------------//
		public static double AjcG3dGetProp_ratio(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32G3dGetProp_ratio(hwnd);
			else		   rc = A64G3dGetProp_ratio(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_ratio@4", ExactSpelling=true)]
		private static extern double A32G3dGetProp_ratio(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_ratio", ExactSpelling=true)]
		private static extern double A64G3dGetProp_ratio(IntPtr hwnd);

		//----- ●AjcG3dSetProp_ratio --------------------------------------------------------------------------//
		public static void AjcG3dSetProp_ratio(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32G3dSetProp_ratio(hwnd, n);
			else		   A64G3dSetProp_ratio(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_ratio@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_ratio(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_ratio", ExactSpelling=true)]
		private static extern void A64G3dSetProp_ratio(IntPtr hwnd,double n);

		//----- ●AjcG3dGetProp_PlotSize -----------------------------------------------------------------------//
		public static int AjcG3dGetProp_PlotSize(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32G3dGetProp_PlotSize(hwnd);
			else		   rc = A64G3dGetProp_PlotSize(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_PlotSize@4", ExactSpelling=true)]
		private static extern int A32G3dGetProp_PlotSize(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_PlotSize", ExactSpelling=true)]
		private static extern int A64G3dGetProp_PlotSize(IntPtr hwnd);

		//----- ●AjcG3dSetProp_PlotSize -----------------------------------------------------------------------//
		public static void AjcG3dSetProp_PlotSize(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32G3dSetProp_PlotSize(hwnd, n);
			else		   A64G3dSetProp_PlotSize(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_PlotSize@8", ExactSpelling=true)]
		private static extern void A32G3dSetProp_PlotSize(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_PlotSize", ExactSpelling=true)]
		private static extern void A64G3dSetProp_PlotSize(IntPtr hwnd,int n);

		//----- ●AjcG3dGetProp_PlotSizeE ----------------------------------------------------------------------//
		public static int AjcG3dGetProp_PlotSizeE(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32G3dGetProp_PlotSizeE(hwnd);
			else		   rc = A64G3dGetProp_PlotSizeE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_PlotSizeE@4", ExactSpelling=true)]
		private static extern int A32G3dGetProp_PlotSizeE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_PlotSizeE", ExactSpelling=true)]
		private static extern int A64G3dGetProp_PlotSizeE(IntPtr hwnd);

		//----- ●AjcG3dSetProp_PlotSizeE ----------------------------------------------------------------------//
		public static void AjcG3dSetProp_PlotSizeE(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32G3dSetProp_PlotSizeE(hwnd, n);
			else		   A64G3dSetProp_PlotSizeE(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_PlotSizeE@8", ExactSpelling=true)]
		private static extern void A32G3dSetProp_PlotSizeE(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_PlotSizeE", ExactSpelling=true)]
		private static extern void A64G3dSetProp_PlotSizeE(IntPtr hwnd,int n);

		//----- ●AjcG3dGetProp_fPlotLine ----------------------------------------------------------------------//
		public static bool AjcG3dGetProp_fPlotLine(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetProp_fPlotLine(hwnd);
			else		   rc = A64G3dGetProp_fPlotLine(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_fPlotLine@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetProp_fPlotLine(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_fPlotLine", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetProp_fPlotLine(IntPtr hwnd);

		//----- ●AjcG3dSetProp_fPlotLine ----------------------------------------------------------------------//
		public static void AjcG3dSetProp_fPlotLine(IntPtr hwnd, bool n)
		{
			if (Is32Bit()) A32G3dSetProp_fPlotLine(hwnd, n);
			else		   A64G3dSetProp_fPlotLine(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_fPlotLine@8", ExactSpelling=true)]
		private static extern void A32G3dSetProp_fPlotLine(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_fPlotLine", ExactSpelling=true)]
		private static extern void A64G3dSetProp_fPlotLine(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool n);

		//----- ●AjcG3dGetProp_fAspect1 -----------------------------------------------------------------------//
		public static bool AjcG3dGetProp_fAspect1(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetProp_fAspect1(hwnd);
			else		   rc = A64G3dGetProp_fAspect1(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_fAspect1@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetProp_fAspect1(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_fAspect1", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetProp_fAspect1(IntPtr hwnd);

		//----- ●AjcG3dSetProp_fAspect1 -----------------------------------------------------------------------//
		public static void AjcG3dSetProp_fAspect1(IntPtr hwnd, bool n)
		{
			if (Is32Bit()) A32G3dSetProp_fAspect1(hwnd, n);
			else		   A64G3dSetProp_fAspect1(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_fAspect1@8", ExactSpelling=true)]
		private static extern void A32G3dSetProp_fAspect1(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_fAspect1", ExactSpelling=true)]
		private static extern void A64G3dSetProp_fAspect1(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool n);

		//----- ●AjcG3dGetProp_MaxPlot ------------------------------------------------------------------------//
		public static int AjcG3dGetProp_MaxPlot(IntPtr hwnd, int ix)
		{
			int	rc;
			if (Is32Bit()) rc = A32G3dGetProp_MaxPlot(hwnd, ix);
			else		   rc = A64G3dGetProp_MaxPlot(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_MaxPlot@8", ExactSpelling=true)]
		private static extern int A32G3dGetProp_MaxPlot(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_MaxPlot", ExactSpelling=true)]
		private static extern int A64G3dGetProp_MaxPlot(IntPtr hwnd,int ix);

		//----- ●AjcG3dSetProp_MaxPlot ------------------------------------------------------------------------//
		public static void AjcG3dSetProp_MaxPlot(IntPtr hwnd, int ix, int n)
		{
			if (Is32Bit()) A32G3dSetProp_MaxPlot(hwnd, ix, n);
			else		   A64G3dSetProp_MaxPlot(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_MaxPlot@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_MaxPlot(IntPtr hwnd, int ix, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_MaxPlot", ExactSpelling=true)]
		private static extern void A64G3dSetProp_MaxPlot(IntPtr hwnd,int ix,int n);

		//----- ●AjcG3dGetProp_rgbP ---------------------------------------------------------------------------//
		public static int AjcG3dGetProp_rgbP(IntPtr hwnd, int ix)
		{
			int	rc;
			if (Is32Bit()) rc = A32G3dGetProp_rgbP(hwnd, ix);
			else		   rc = A64G3dGetProp_rgbP(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_rgbP@8", ExactSpelling=true)]
		private static extern int A32G3dGetProp_rgbP(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_rgbP", ExactSpelling=true)]
		private static extern int A64G3dGetProp_rgbP(IntPtr hwnd,int ix);

		//----- ●AjcG3dSetProp_rgbP ---------------------------------------------------------------------------//
		public static void AjcG3dSetProp_rgbP(IntPtr hwnd, int ix, int n)
		{
			if (Is32Bit()) A32G3dSetProp_rgbP(hwnd, ix, n);
			else		   A64G3dSetProp_rgbP(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_rgbP@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_rgbP(IntPtr hwnd, int ix, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_rgbP", ExactSpelling=true)]
		private static extern void A64G3dSetProp_rgbP(IntPtr hwnd,int ix,int n);

		//----- ●AjcG3dGetProp_rgbN ---------------------------------------------------------------------------//
		public static int AjcG3dGetProp_rgbN(IntPtr hwnd, int ix)
		{
			int	rc;
			if (Is32Bit()) rc = A32G3dGetProp_rgbN(hwnd, ix);
			else		   rc = A64G3dGetProp_rgbN(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetProp_rgbN@8", ExactSpelling=true)]
		private static extern int A32G3dGetProp_rgbN(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetProp_rgbN", ExactSpelling=true)]
		private static extern int A64G3dGetProp_rgbN(IntPtr hwnd,int ix);

		//----- ●AjcG3dSetProp_rgbN ---------------------------------------------------------------------------//
		public static void AjcG3dSetProp_rgbN(IntPtr hwnd, int ix, int n)
		{
			if (Is32Bit()) A32G3dSetProp_rgbN(hwnd, ix, n);
			else		   A64G3dSetProp_rgbN(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_rgbN@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_rgbN(IntPtr hwnd, int ix, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_rgbN", ExactSpelling=true)]
		private static extern void A64G3dSetProp_rgbN(IntPtr hwnd,int ix,int n);

		//----- ●AjcG3dSetProp_WndSize ------------------------------------------------------------------------//
		public static void AjcG3dSetProp_WndSize(IntPtr hwnd, int width, int height)
		{
			if (Is32Bit()) A32G3dSetProp_WndSize(hwnd, width, height);
			else		   A64G3dSetProp_WndSize(hwnd, width, height);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_WndSize@12", ExactSpelling=true)]
		private static extern void A32G3dSetProp_WndSize(IntPtr hwnd, int width, int height);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_WndSize", ExactSpelling=true)]
		private static extern void A64G3dSetProp_WndSize(IntPtr hwnd,int width,int height);

		//----- ●AjcG3dSetProp_Set2dMode ----------------------------------------------------------------------//
		public static void AjcG3dSetProp_Set2dMode(IntPtr hwnd)
		{
			if (Is32Bit()) A32G3dSetProp_Set2dMode(hwnd);
			else		   A64G3dSetProp_Set2dMode(hwnd);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetProp_Set2dMode@4", ExactSpelling=true)]
		private static extern void A32G3dSetProp_Set2dMode(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetProp_Set2dMode", ExactSpelling=true)]
		private static extern void A64G3dSetProp_Set2dMode(IntPtr hwnd);

		//----- ●AjcG3dSetProp_AcceptFiles --------------------------------------------------------------------//
		public static void AjcG3dSetProp_AcceptFiles(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32G3dSetProp_AcceptFiles(hwnd, fEnable);
			else		   A64G3dSetProp_AcceptFiles(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcG3dSetProp_AcceptFiles@8", ExactSpelling = true)]
		private static extern void A32G3dSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcG3dSetProp_AcceptFiles", ExactSpelling = true)]
		private static extern void A64G3dSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcG3dGetProp_AcceptFiles --------------------------------------------------------------------//
		public static bool AjcG3dGetProp_AcceptFiles(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32G3dGetProp_AcceptFiles(hwnd);
			else		   rc = A64G3dGetProp_AcceptFiles(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcG3dGetProp_AcceptFiles@4", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dGetProp_AcceptFiles(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcG3dGetProp_AcceptFiles", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dGetProp_AcceptFiles(IntPtr hwnd);

		//----- ●AjcG3dGetPlotEvtInfo -------------------------------------------------------------------------//
		public static int AjcG3dGetPlotEvtInfo(IntPtr pItem, int ix, out double x, out double y, out double z)
		{
			int	rc;
			if (Is32Bit()) rc = A32G3dGetPlotEvtInfo(pItem, ix, out x, out y, out z);
			else		   rc = A64G3dGetPlotEvtInfo(pItem, ix, out x, out y, out z);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetPlotEvtInfo@20", ExactSpelling=true)]
		private static extern int A32G3dGetPlotEvtInfo(IntPtr pItem, int ix, out double x, out double y, out double z);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetPlotEvtInfo", ExactSpelling=true)]
		private static extern int A64G3dGetPlotEvtInfo(IntPtr pItem, int ix, out double x, out double y, out double z);

		//----- ●AjcG3dSetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcG3dSetTipTextForMSIL(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32G3dSetTipTextForMSIL(hwnd, pTxt);
			else		   A64G3dSetTipTextForMSIL(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetTipTextForMSIL@8", ExactSpelling=true)]
		private static extern void A32G3dSetTipTextForMSIL(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64G3dSetTipTextForMSIL(IntPtr hwnd,string pTxt);

		//----- ●AjcG3dGetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcG3dGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32G3dGetTipTextForMSIL(hwnd, pBuf, lBuf);
			else		   A64G3dGetTipTextForMSIL(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32G3dGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64G3dGetTipTextForMSIL(IntPtr hwnd,StringBuilder pBuf,int lBuf);

		//----- ●AjcG3dSetChkBoxTipTextForMSIL -----------------------------------------------------------------------//
		public static void AjcG3dSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt)
		{
			if (Is32Bit()) A32G3dSetChkBoxTipTextForMSIL(hwnd, n, pTxt);
			else		   A64G3dSetChkBoxTipTextForMSIL(hwnd, n, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetChkBoxTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32G3dSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetChkBoxTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64G3dSetChkBoxTipTextForMSIL(IntPtr hwnd,int n,string pTxt);

		//----- ●AjcG3dGetChkBoxTipTextForMSIL -----------------------------------------------------------------------//
		public static void AjcG3dGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32G3dGetChkBoxTipTextForMSIL(hwnd, n, pBuf, lBuf);
			else		   A64G3dGetChkBoxTipTextForMSIL(hwnd, n, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dGetChkBoxTipTextForMSIL@16", ExactSpelling=true)]
		private static extern void A32G3dGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dGetChkBoxTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64G3dGetChkBoxTipTextForMSIL(IntPtr hwnd,int n,StringBuilder pBuf,int lBuf);

		//----- ●AjcG3dSetTextFont ----------------------------------------------------------------------------//
		public static IntPtr AjcG3dSetTextFont(IntPtr hwnd, IntPtr hFont)
		{
			IntPtr rc;
			if (Is32Bit()) rc = A32G3dSetTextFont(hwnd, hFont);
			else		   rc = A64G3dSetTextFont(hwnd, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dSetTextFont@8", ExactSpelling=true)]
		private static extern IntPtr A32G3dSetTextFont(IntPtr hwnd, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dSetTextFont", ExactSpelling=true)]
		private static extern IntPtr A64G3dSetTextFont(IntPtr hwnd, IntPtr hFont);

		//----- ●AjcG3dTextOutW -------------------------------------------------------------------------------//
		public static int AjcG3dTextOutW(IntPtr hwnd, int x, int y, string pTxt)
		{
			int		rc;
			if (Is32Bit()) rc = A32G3dTextOutW(hwnd, x, y, pTxt);
			else		   rc = A64G3dTextOutW(hwnd, x, y, pTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dTextOutW@16", ExactSpelling=true)]
		private static extern int A32G3dTextOutW(IntPtr hwnd, int x, int y, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dTextOutW", ExactSpelling=true)]
		private static extern int A64G3dTextOutW(IntPtr hwnd, int x, int y, string pTxt);

		//----- ●AjcG3dTextOut2DForMSIL -----------------------------------------------------------------------//
		public static int AjcG3dTextOut2DForMSIL(IntPtr hwnd, EAJCTXOMD md, double x, double y, string pTxt)
		{
			int		rc;
			if (Is32Bit()) rc = A32G3dTextOut2DForMSIL(hwnd, md, x, y, pTxt);
			else		   rc = A64G3dTextOut2DForMSIL(hwnd, md, x, y, pTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dTextOut2DForMSIL@28", ExactSpelling=true)]
		private static extern int A32G3dTextOut2DForMSIL(IntPtr hwnd, EAJCTXOMD md, double x, double y, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dTextOut2DForMSIL", ExactSpelling=true)]
		private static extern int A64G3dTextOut2DForMSIL(IntPtr hwnd, EAJCTXOMD md, double x, double y, string pTxt);

		//----- ●AjcG3dTextOut3DForMSIL -----------------------------------------------------------------------//
		public static int AjcG3dTextOut3DForMSIL(IntPtr hwnd, EAJCTXOMD md, double x, double y, double z, string pTxt)
		{
			int		rc;
			if (Is32Bit()) rc = A32G3dTextOut3DForMSIL(hwnd, md, x, y, z, pTxt);
			else		   rc = A64G3dTextOut3DForMSIL(hwnd, md, x, y, z, pTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dTextOut3DForMSIL@36", ExactSpelling=true)]
		private static extern int A32G3dTextOut3DForMSIL(IntPtr hwnd, EAJCTXOMD md, double x, double y, double z, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dTextOut3DForMSIL", ExactSpelling=true)]
		private static extern int A64G3dTextOut3DForMSIL(IntPtr hwnd, EAJCTXOMD md, double x, double y, double z, string pTxt);

		//----- ●AjcG3dClearText ------------------------------------------------------------------------------//
		public static bool AjcG3dClearText(IntPtr hwnd, int key)
		{
			bool		rc;
			if (Is32Bit()) rc = A32G3dClearText(hwnd, key);
			else		   rc = A64G3dClearText(hwnd, key);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dClearText@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dClearText(IntPtr hwnd, int key);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dClearText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dClearText(IntPtr hwnd, int key);

		//----- ●AjcG3dClearAllText ---------------------------------------------------------------------------//
		public static bool AjcG3dClearAllText(IntPtr hwnd)
		{
			bool		rc;
			if (Is32Bit()) rc = A32G3dClearAllText(hwnd);
			else		   rc = A64G3dClearAllText(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcG3dClearAllText@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32G3dClearAllText(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcG3dClearAllText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64G3dClearAllText(IntPtr hwnd);

		//======================================================================================================//
		//	AjcCtrlBarGraph.h																					//
		//======================================================================================================//

		//----- ●AjcBarPutRealData ----------------------------------------------------------------------------//
		public static bool AjcBarPutRealData(IntPtr hwnd, double dat)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarPutRealData(hwnd, dat);
			else		   rc = A64BarPutRealData(hwnd, dat);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutRealDataW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarPutRealData(IntPtr hwnd, double dat);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutRealDataW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarPutRealData(IntPtr hwnd,double dat);

		//----- ●AjcBarSetBarTtl ------------------------------------------------------------------------------//
		public static bool AjcBarSetBarTtl(IntPtr hwnd, string pTtl)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarSetBarTtl(hwnd, pTtl);
			else		   rc = A64BarSetBarTtl(hwnd, pTtl);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetBarTtlW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSetBarTtl(IntPtr hwnd, string pTtl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetBarTtlW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSetBarTtl(IntPtr hwnd,string pTtl);

		//----- ●AjcBarSetVUnit -------------------------------------------------------------------------------//
		public static bool AjcBarSetVUnit(IntPtr hwnd, string pUnit)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarSetVUnit(hwnd, pUnit);
			else		   rc = A64BarSetVUnit(hwnd, pUnit);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetVUnitW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSetVUnit(IntPtr hwnd, string pUnit);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetVUnitW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSetVUnit(IntPtr hwnd,string pUnit);

		//----- ●AjcBarPurge ----------------------------------------------------------------------------------//
		public static bool AjcBarPurge(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarPurge(hwnd);
			else		   rc = A64BarPurge(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPurge@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarPurge(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPurge", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarPurge(IntPtr hwnd);

		//----- ●AjcBarShowBorder -----------------------------------------------------------------------------//
		public static void AjcBarShowBorder(IntPtr hwnd, bool fShow, int rgb)
		{
			if (Is32Bit()) A32BarShowBorder(hwnd, fShow, rgb);
			else		   A64BarShowBorder(hwnd, fShow, rgb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarShowBorder@12", ExactSpelling=true)]
		private static extern void A32BarShowBorder(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShow, int rgb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarShowBorder", ExactSpelling=true)]
		private static extern void A64BarShowBorder(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool fShow, int rgb);

		//----- ●AjcBarLoadProp -------------------------------------------------------------------------------//
		public static bool AjcBarLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarLoadProp(hwnd, pProfileSect, pDefProp);
			else		   rc = A64BarLoadProp(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarLoadPropW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarLoadPropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarLoadProp(IntPtr hwnd,string pProfileSect,IntPtr pDefProp);

		//----- ●AjcBarSaveProp -------------------------------------------------------------------------------//
		public static bool AjcBarSaveProp(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarSaveProp(hwnd, pProfileSect);
			else		   rc = A64BarSaveProp(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSavePropW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSaveProp(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSavePropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSaveProp(IntPtr hwnd,string pProfileSect);

		//----- ●AjcBarLoadPropEx -----------------------------------------------------------------------------//
		public static bool AjcBarLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarLoadPropEx(hwnd, pProfileSect, pDefProp);
			else		   rc = A64BarLoadPropEx(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarLoadPropExW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarLoadPropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarLoadPropEx(IntPtr hwnd,string pProfileSect,IntPtr pDefProp);

		//----- ●AjcBarSavePropEx -----------------------------------------------------------------------------//
		public static bool AjcBarSavePropEx(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarSavePropEx(hwnd, pProfileSect);
			else		   rc = A64BarSavePropEx(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSavePropExW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSavePropEx(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSavePropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSavePropEx(IntPtr hwnd,string pProfileSect);

		//----- ●AjcBarEnablePopupMenu ------------------------------------------------------------------------//
		public static void AjcBarEnablePopupMenu(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32BarEnablePopupMenu(hwnd, fEnable);
			else		   A64BarEnablePopupMenu(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarEnablePopupMenu@8", ExactSpelling=true)]
		private static extern void A32BarEnablePopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarEnablePopupMenu", ExactSpelling=true)]
		private static extern void A64BarEnablePopupMenu(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcBarSetTipText -----------------------------------------------------------------------------//
		public static void AjcBarSetTipText(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32BarSetTipText(hwnd, pTxt);
			else		   A64BarSetTipText(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetTipTextW@8", ExactSpelling=true)]
		private static extern void A32BarSetTipText(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetTipTextW", ExactSpelling=true)]
		private static extern void A64BarSetTipText(IntPtr hwnd, string pTxt);

		//----- ●AjcBarGetTipText -----------------------------------------------------------------------------//
		public static void AjcBarGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32BarGetTipText(hwnd, pBuf, lBuf);
			else		   A64BarGetTipText(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetTipTextW@12", ExactSpelling=true)]
		private static extern void A32BarGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetTipTextW", ExactSpelling=true)]
		private static extern void A64BarGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcBarSetTipShowAlways -----------------------------------------------------------------------//
		public static void AjcBarSetTipShowAlways(IntPtr hwnd, bool fShowAlways)
		{
			if (Is32Bit()) A32AjcBarSetTipShowAlways(hwnd, fShowAlways);
			else		   A64AjcBarSetTipShowAlways(hwnd, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetTipShowAlways@8", ExactSpelling=true)]
		private static extern void A32AjcBarSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetTipShowAlways", ExactSpelling=true)]
		private static extern void A64AjcBarSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);

		//----- ●AjcBarSetChkBoxTipShowAlways -----------------------------------------------------------------------//
		public static void AjcBarSetChkBoxTipShowAlways(IntPtr hwnd, int n, bool fShowAlways)
		{
			if (Is32Bit()) A32AjcBarSetChkBoxTipShowAlways(hwnd, n, fShowAlways);
			else		   A64AjcBarSetChkBoxTipShowAlways(hwnd, n, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetChkBoxTipShowAlways@12", ExactSpelling=true)]
		private static extern void A32AjcBarSetChkBoxTipShowAlways(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetChkBoxTipShowAlways", ExactSpelling=true)]
		private static extern void A64AjcBarSetChkBoxTipShowAlways(IntPtr hwnd,int n, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);

		//----- ●AjcBarSetChkBoxTipText -----------------------------------------------------------------------//
		public static void AjcBarSetChkBoxTipText(IntPtr hwnd, int n, string pTxt)
		{
			if (Is32Bit()) A32BarSetChkBoxTipText(hwnd, n, pTxt);
			else		   A64BarSetChkBoxTipText(hwnd, n, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetChkBoxTipTextW@12", ExactSpelling=true)]
		private static extern void A32BarSetChkBoxTipText(IntPtr hwnd, int n, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetChkBoxTipTextW", ExactSpelling=true)]
		private static extern void A64BarSetChkBoxTipText(IntPtr hwnd,int n,string pTxt);

		//----- ●AjcBarGetChkBoxTipText -----------------------------------------------------------------------//
		public static void AjcBarGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32BarGetChkBoxTipText(hwnd, n, pBuf, lBuf);
			else		   A64BarGetChkBoxTipText(hwnd, n, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetChkBoxTipTextW@16", ExactSpelling=true)]
		private static extern void A32BarGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetChkBoxTipTextW", ExactSpelling=true)]
		private static extern void A64BarGetChkBoxTipText(IntPtr hwnd,int n,StringBuilder pBuf,int lBuf);

		//----- ●AjcBarGetScrollPos ---------------------------------------------------------------------------//
		public static int AjcBarGetScrollPos(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetScrollPos(hwnd);
			else		   rc = A64BarGetScrollPos(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetScrollPos@4", ExactSpelling=true)]
		private static extern int A32BarGetScrollPos(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetScrollPos", ExactSpelling=true)]
		private static extern int A64BarGetScrollPos(IntPtr hwnd);

		//----- ●AjcBarSetScrollPos ---------------------------------------------------------------------------//
		public static void AjcBarSetScrollPos(IntPtr hwnd, int pos)
		{
			if (Is32Bit()) A32BarSetScrollPos(hwnd, pos);
			else		   A64BarSetScrollPos(hwnd, pos);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetScrollPos@8", ExactSpelling=true)]
		private static extern void A32BarSetScrollPos(IntPtr hwnd, int pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetScrollPos", ExactSpelling=true)]
		private static extern void A64BarSetScrollPos(IntPtr hwnd,int pos);

		//----- ●AjcBarSetFilter ------------------------------------------------------------------------------//
		public static void AjcBarSetFilter(IntPtr hwnd, int n, bool state)
		{
			if (Is32Bit()) A32BarSetFilter(hwnd, n, state);
			else		   A64BarSetFilter(hwnd, n, state);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetFilter@12", ExactSpelling=true)]
		private static extern void A32BarSetFilter(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)] bool state);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetFilter", ExactSpelling=true)]
		private static extern void A64BarSetFilter(IntPtr hwnd,int n,[MarshalAs(UnmanagedType.Bool)] bool state);

		//----- ●AjcBarGetFilter ------------------------------------------------------------------------------//
		public static bool AjcBarGetFilter(IntPtr hwnd, int n)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarGetFilter(hwnd, n);
			else		   rc = A64BarGetFilter(hwnd, n);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetFilter@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetFilter(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetFilter", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetFilter(IntPtr hwnd,int n);

		//----- ●AjcBarSetHLineAtt ----------------------------------------------------------------------------//
		public static bool AjcBarSetHLineAtt(IntPtr hwnd, int id, int color, int width, int style)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarSetHLineAtt(hwnd, id, color, width, style);
			else		   rc = A64BarSetHLineAtt(hwnd, id, color, width, style);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetHLineAtt@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSetHLineAtt(IntPtr hwnd, int id, int color, int width, int style);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetHLineAtt", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSetHLineAtt(IntPtr hwnd,int id, int color,int width, int style);

		//----- ●AjcBarSetHLinePos ----------------------------------------------------------------------------//
		public static bool AjcBarSetHLinePos(IntPtr hwnd, int id, double pos)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarSetHLinePos(hwnd, id, pos);
			else		   rc = A64BarSetHLinePos(hwnd, id, pos);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetHLinePos@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSetHLinePos(IntPtr hwnd, int id, double pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetHLinePos", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSetHLinePos(IntPtr hwnd,int id,double pos);

		//----- ●AjcBarEnableHLine ----------------------------------------------------------------------------//
		public static bool AjcBarEnableHLine(IntPtr hwnd, int id, bool fEnable)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarEnableHLine(hwnd, id, fEnable);
			else		   rc = A64BarEnableHLine(hwnd, id, fEnable);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarEnableHLine@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarEnableHLine(IntPtr hwnd, int id, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarEnableHLine", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarEnableHLine(IntPtr hwnd,int id,[MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcBarGetCharSize ----------------------------------------------------------------------------//
		public static void AjcBarGetCharSize(IntPtr hwnd, IntPtr pSize)
		{
			if (Is32Bit()) A32BarGetCharSize(hwnd, pSize);
			else		   A64BarGetCharSize(hwnd, pSize);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetCharSize@8", ExactSpelling=true)]
		private static extern void A32BarGetCharSize(IntPtr hwnd, IntPtr pSize);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetCharSize", ExactSpelling=true)]
		private static extern void A64BarGetCharSize(IntPtr hwnd,IntPtr pSize);

		//----- ●AjcBarGetDroppedFile -------------------------------------------------------------------------//
		public static string AjcBarGetDroppedFile(IntPtr hwnd)
		{
			string	rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32BarGetDroppedFile(hwnd, s)) rc = s.ToString();
				else											rc = "";
			}
			else {
				if (A64BarGetDroppedFile(hwnd, s)) rc = s.ToString();
				else											rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetDroppedFileW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetDroppedFile(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcBarGetDroppedFileW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetDroppedFile(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcBarGetDroppedDir --------------------------------------------------------------------------//
		public static string AjcBarGetDroppedDir(IntPtr hwnd)
		{
			string		rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32BarGetDroppedDir(hwnd, s)) rc = s.ToString();
				else										   rc = "";
			}
			else {
				if (A64BarGetDroppedDir(hwnd, s)) rc = s.ToString();
				else										   rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetDroppedDirW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetDroppedDir(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcBarGetDroppedDirW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetDroppedDir(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcBarSetTitleText ---------------------------------------------------------------------------//
		public static bool AjcBarSetTitleText(IntPtr hwnd, string Text, Color TextColor, Color BackColor, Font TextFont)
		{
			bool	rc;
			int 	TxtCol = TextColor == Color.Empty ? -1 : (TextColor.B << 16 | TextColor.G << 8 | TextColor.R);
			int 	BakCol = BackColor == Color.Empty ? -1 : (BackColor.B << 16 | BackColor.G << 8 | BackColor.R);
			IntPtr	hFont  = TextFont  == null ?  (IntPtr)0 : TextFont.ToHfont();
			if (Is32Bit()) rc = A32BarSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			else		   rc = A64BarSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetTitleTextW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetTitleTextW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);

		//----- ●AjcBarCreateForMSIL --------------------------------------------------------------------------//
		public static IntPtr AjcBarCreateForMSIL(IntPtr hOwner, bool fShowScrollBar, BarCbkRangeChanged CbkRangeChanged,
																					 BarCbkNtcScrollPos CbkNtcScrollPos,
																					 BarCbkFileDrop		CbkFileDrop	   ,
																					 BarCbkDirDrop		CbkDirDrop	   ,
																					 BarCbkRClick		CbkRClick)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32BarCreateForMSIL(hOwner, fShowScrollBar, CbkRangeChanged,
																			CbkNtcScrollPos,
																			CbkFileDrop	   ,
																			CbkDirDrop	   ,
																			CbkRClick);
			else		   rc = A64BarCreateForMSIL(hOwner, fShowScrollBar, CbkRangeChanged,
																			CbkNtcScrollPos,
																			CbkFileDrop	   ,
																			CbkDirDrop	   ,
																			CbkRClick);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarCreateForMSIL@28", ExactSpelling=true)]
		private static extern IntPtr A32BarCreateForMSIL(IntPtr hOwner, [MarshalAs(UnmanagedType.Bool)] bool fShowScrollBar,
								 										BarCbkRangeChanged cbRangeChanged,
																		BarCbkNtcScrollPos cbNtcScrollPos,
																		BarCbkFileDrop	   cbFileDrop	 ,
																		BarCbkDirDrop	   cbDirDrop	 ,
																		BarCbkRClick	   cbRClick);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64BarCreateForMSIL(IntPtr hOwner,	[MarshalAs(UnmanagedType.Bool)] bool fShowScrollBar,
																		BarCbkRangeChanged	cbRangeChanged,
																		BarCbkNtcScrollPos	cbNtcScrollPos,
																		BarCbkFileDrop		cbFileDrop,
																		BarCbkDirDrop		cbDirDrop,
																		BarCbkRClick		cbRClick);

		//----- ●AjcBarGetSty_NOBORDER ------------------------------------------------------------------------//
		public static bool AjcBarGetSty_NOBORDER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarGetSty_NOBORDER(hwnd);
			else		   rc = A64BarGetSty_NOBORDER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetSty_NOBORDER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetSty_NOBORDER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetSty_NOBORDER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetSty_NOBORDER(IntPtr hwnd);

		//----- ●AjcBarSetSty_NOBORDER ------------------------------------------------------------------------//
		public static void AjcBarSetSty_NOBORDER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32BarSetSty_NOBORDER(hwnd, f);
			else		   A64BarSetSty_NOBORDER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetSty_NOBORDER@8", ExactSpelling=true)]
		private static extern void A32BarSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetSty_NOBORDER", ExactSpelling=true)]
		private static extern void A64BarSetSty_NOBORDER(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcBarGetSty_LINEGRAPH -----------------------------------------------------------------------//
		public static bool AjcBarGetSty_LINEGRAPH(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarGetSty_LINEGRAPH(hwnd);
			else		   rc = A64BarGetSty_LINEGRAPH(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetSty_LINEGRAPH@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetSty_LINEGRAPH(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetSty_LINEGRAPH", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetSty_LINEGRAPH(IntPtr hwnd);

		//----- ●AjcBarSetSty_LINEGRAPH -----------------------------------------------------------------------//
		public static void AjcBarSetSty_LINEGRAPH(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32BarSetSty_LINEGRAPH(hwnd, f);
			else		   A64BarSetSty_LINEGRAPH(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet=CharSet.Unicode, EntryPoint="_AjcBarSetSty_LINEGRAPH@8", ExactSpelling=true)]
		private static extern void A32BarSetSty_LINEGRAPH(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetSty_LINEGRAPH", ExactSpelling=true)]
		private static extern void A64BarSetSty_LINEGRAPH(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcBarGetSty_NOFILTER ------------------------------------------------------------------------//
		public static bool AjcBarGetSty_NOFILTER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarGetSty_NOFILTER(hwnd);
			else		   rc = A64BarGetSty_NOFILTER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetSty_NOFILTER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetSty_NOFILTER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetSty_NOFILTER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetSty_NOFILTER(IntPtr hwnd);

		//----- ●AjcBarSetSty_NOFILTER ------------------------------------------------------------------------//
		public static void AjcBarSetSty_NOFILTER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32BarSetSty_NOFILTER(hwnd, f);
			else		   A64BarSetSty_NOFILTER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetSty_NOFILTER@8", ExactSpelling=true)]
		private static extern void A32BarSetSty_NOFILTER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetSty_NOFILTER", ExactSpelling=true)]
		private static extern void A64BarSetSty_NOFILTER(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcBarGetProp_RngL ---------------------------------------------------------------------------//
		public static double AjcBarGetProp_RngL(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32BarGetProp_RngL(hwnd);
			else		   rc = A64BarGetProp_RngL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_RngL@4", ExactSpelling=true)]
		private static extern double A32BarGetProp_RngL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_RngL", ExactSpelling=true)]
		private static extern double A64BarGetProp_RngL(IntPtr hwnd);

		//----- ●AjcBarSetProp_RngL ---------------------------------------------------------------------------//
		public static void AjcBarSetProp_RngL(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32BarSetProp_RngL(hwnd, n);
			else		   A64BarSetProp_RngL(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_RngL@12", ExactSpelling=true)]
		private static extern void A32BarSetProp_RngL(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_RngL", ExactSpelling=true)]
		private static extern void A64BarSetProp_RngL(IntPtr hwnd,double n);

		//----- ●AjcBarGetProp_RngH ---------------------------------------------------------------------------//
		public static double AjcBarGetProp_RngH(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32BarGetProp_RngH(hwnd);
			else		   rc = A64BarGetProp_RngH(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_RngH@4", ExactSpelling=true)]
		private static extern double A32BarGetProp_RngH(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_RngH", ExactSpelling=true)]
		private static extern double A64BarGetProp_RngH(IntPtr hwnd);

		//----- ●AjcBarSetProp_RngH ---------------------------------------------------------------------------//
		public static void AjcBarSetProp_RngH(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32BarSetProp_RngH(hwnd, n);
			else		   A64BarSetProp_RngH(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_RngH@12", ExactSpelling=true)]
		private static extern void A32BarSetProp_RngH(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_RngH", ExactSpelling=true)]
		private static extern void A64BarSetProp_RngH(IntPtr hwnd,double n);

		//----- ●AjcBarGetProp_Base ---------------------------------------------------------------------------//
		public static double AjcBarGetProp_Base(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32BarGetProp_Base(hwnd);
			else		   rc = A64BarGetProp_Base(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_Base@4", ExactSpelling=true)]
		private static extern double A32BarGetProp_Base(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_Base", ExactSpelling=true)]
		private static extern double A64BarGetProp_Base(IntPtr hwnd);

		//----- ●AjcBarSetProp_Base ---------------------------------------------------------------------------//
		public static void AjcBarSetProp_Base(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32BarSetProp_Base(hwnd, n);
			else		   A64BarSetProp_Base(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_Base@12", ExactSpelling=true)]
		private static extern void A32BarSetProp_Base(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_Base", ExactSpelling=true)]
		private static extern void A64BarSetProp_Base(IntPtr hwnd,double n);

		//----- ●AjcBarGetProp_MaxBuf -------------------------------------------------------------------------//
		public static int AjcBarGetProp_MaxBuf(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_MaxBuf(hwnd);
			else		   rc = A64BarGetProp_MaxBuf(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_MaxBuf@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_MaxBuf(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_MaxBuf", ExactSpelling=true)]
		private static extern int A64BarGetProp_MaxBuf(IntPtr hwnd);

		//----- ●AjcBarSetProp_MaxBuf -------------------------------------------------------------------------//
		public static void AjcBarSetProp_MaxBuf(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32BarSetProp_MaxBuf(hwnd, n);
			else		   A64BarSetProp_MaxBuf(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_MaxBuf@8", ExactSpelling=true)]
		private static extern void A32BarSetProp_MaxBuf(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_MaxBuf", ExactSpelling=true)]
		private static extern void A64BarSetProp_MaxBuf(IntPtr hwnd,int n);

		//----- ●AjcBarGetProp_MaxItem ------------------------------------------------------------------------//
		public static int AjcBarGetProp_MaxItem(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_MaxItem(hwnd);
			else		   rc = A64BarGetProp_MaxItem(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_MaxItem@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_MaxItem(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_MaxItem", ExactSpelling=true)]
		private static extern int A64BarGetProp_MaxItem(IntPtr hwnd);

		//----- ●AjcBarSetProp_MaxItem ------------------------------------------------------------------------//
		public static void AjcBarSetProp_MaxItem(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32BarSetProp_MaxItem(hwnd, n);
			else		   A64BarSetProp_MaxItem(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_MaxItem@8", ExactSpelling=true)]
		private static extern void A32BarSetProp_MaxItem(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_MaxItem", ExactSpelling=true)]
		private static extern void A64BarSetProp_MaxItem(IntPtr hwnd,int n);

		//----- ●AjcBarGetProp_ScaleWidth ---------------------------------------------------------------------//
		public static int AjcBarGetProp_ScaleWidth(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_ScaleWidth(hwnd);
			else		   rc = A64BarGetProp_ScaleWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_ScaleWidth@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_ScaleWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_ScaleWidth", ExactSpelling=true)]
		private static extern int A64BarGetProp_ScaleWidth(IntPtr hwnd);

		//----- ●AjcBarSetProp_ScaleWidth ---------------------------------------------------------------------//
		public static void AjcBarSetProp_ScaleWidth(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32BarSetProp_ScaleWidth(hwnd, n);
			else		   A64BarSetProp_ScaleWidth(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_ScaleWidth@8", ExactSpelling=true)]
		private static extern void A32BarSetProp_ScaleWidth(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_ScaleWidth", ExactSpelling=true)]
		private static extern void A64BarSetProp_ScaleWidth(IntPtr hwnd,int n);

		//----- ●AjcBarGetProp_BarWidth -----------------------------------------------------------------------//
		public static int AjcBarGetProp_BarWidth(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_BarWidth(hwnd);
			else		   rc = A64BarGetProp_BarWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_BarWidth@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_BarWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_BarWidth", ExactSpelling=true)]
		private static extern int A64BarGetProp_BarWidth(IntPtr hwnd);

		//----- ●AjcBarSetProp_BarWidth -----------------------------------------------------------------------//
		public static void AjcBarSetProp_BarWidth(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32BarSetProp_BarWidth(hwnd, n);
			else		   A64BarSetProp_BarWidth(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_BarWidth@8", ExactSpelling=true)]
		private static extern void A32BarSetProp_BarWidth(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_BarWidth", ExactSpelling=true)]
		private static extern void A64BarSetProp_BarWidth(IntPtr hwnd,int n);

		//----- ●AjcBarGetProp_MinWidth -----------------------------------------------------------------------//
		public static int AjcBarGetProp_MinWidth(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_MinWidth(hwnd);
			else		   rc = A64BarGetProp_MinWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_MinWidth@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_MinWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_MinWidth", ExactSpelling=true)]
		private static extern int A64BarGetProp_MinWidth(IntPtr hwnd);

		//----- ●AjcBarSetProp_MinWidth -----------------------------------------------------------------------//
		public static void AjcBarSetProp_MinWidth(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32BarSetProp_MinWidth(hwnd, n);
			else		   A64BarSetProp_MinWidth(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_MinWidth@8", ExactSpelling=true)]
		private static extern void A32BarSetProp_MinWidth(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_MinWidth", ExactSpelling=true)]
		private static extern void A64BarSetProp_MinWidth(IntPtr hwnd,int n);

		//----- ●AjcBarGetProp_BarTtlLines --------------------------------------------------------------------//
		public static int AjcBarGetProp_BarTtlLines(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_BarTtlLines(hwnd);
			else		   rc = A64BarGetProp_BarTtlLines(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_BarTtlLines@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_BarTtlLines(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_BarTtlLines", ExactSpelling=true)]
		private static extern int A64BarGetProp_BarTtlLines(IntPtr hwnd);

		//----- ●AjcBarSetProp_BarTtlLines --------------------------------------------------------------------//
		public static void AjcBarSetProp_BarTtlLines(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32BarSetProp_BarTtlLines(hwnd, n);
			else		   A64BarSetProp_BarTtlLines(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_BarTtlLines@8", ExactSpelling=true)]
		private static extern void A32BarSetProp_BarTtlLines(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_BarTtlLines", ExactSpelling=true)]
		private static extern void A64BarSetProp_BarTtlLines(IntPtr hwnd, int n);

		//----- ●AjcBarGetProp_rgb ----------------------------------------------------------------------------//
		public static int AjcBarGetProp_rgb(IntPtr hwnd, int ix)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_rgb(hwnd, ix);
			else		   rc = A64BarGetProp_rgb(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_rgb@8", ExactSpelling=true)]
		private static extern int A32BarGetProp_rgb(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_rgb", ExactSpelling=true)]
		private static extern int A64BarGetProp_rgb(IntPtr hwnd,int ix);

		//----- ●AjcBarSetProp_rgb ----------------------------------------------------------------------------//
		public static void AjcBarSetProp_rgb(IntPtr hwnd, int ix, int n)
		{
			if (Is32Bit()) A32BarSetProp_rgb(hwnd, ix, n);
			else		   A64BarSetProp_rgb(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_rgb@12", ExactSpelling=true)]
		private static extern void A32BarSetProp_rgb(IntPtr hwnd, int ix, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_rgb", ExactSpelling=true)]
		private static extern void A64BarSetProp_rgb(IntPtr hwnd,int ix,int n);

		//----- ●AjcBarGetProp_CharWidth ----------------------------------------------------------------------//
		public static int AjcBarGetProp_CharWidth(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_CharWidth(hwnd);
			else		   rc = A64BarGetProp_CharWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_CharWidth@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_CharWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_CharWidth", ExactSpelling=true)]
		private static extern int A64BarGetProp_CharWidth(IntPtr hwnd);

		//----- ●AjcBarGetProp_CharHeight ---------------------------------------------------------------------//
		public static int AjcBarGetProp_CharHeight(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32BarGetProp_CharHeight(hwnd);
			else		   rc = A64BarGetProp_CharHeight(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetProp_CharHeight@4", ExactSpelling=true)]
		private static extern int A32BarGetProp_CharHeight(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetProp_CharHeight", ExactSpelling=true)]
		private static extern int A64BarGetProp_CharHeight(IntPtr hwnd);

		//----- ●AjcBarSetProp_WndSize ------------------------------------------------------------------------//
		public static void AjcBarSetProp_WndSize(IntPtr hwnd, int width, int height)
		{
			if (Is32Bit()) A32BarSetProp_WndSize(hwnd, width, height);
			else		   A64BarSetProp_WndSize(hwnd, width, height);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetProp_WndSize@12", ExactSpelling=true)]
		private static extern void A32BarSetProp_WndSize(IntPtr hwnd, int width, int height);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetProp_WndSize", ExactSpelling=true)]
		private static extern void A64BarSetProp_WndSize(IntPtr hwnd,int width,int height);

		//----- ●AjcBarSetProp_AcceptFiles --------------------------------------------------------------------//
		public static void AjcBarSetProp_AcceptFiles(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32BarSetProp_AcceptFiles(hwnd, fEnable);
			else		   A64BarSetProp_AcceptFiles(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcBarSetProp_AcceptFiles@8", ExactSpelling = true)]
		private static extern void A32BarSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcBarSetProp_AcceptFiles", ExactSpelling = true)]
		private static extern void A64BarSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcBarGetProp_AcceptFiles --------------------------------------------------------------------//
		public static bool AjcBarGetProp_AcceptFiles(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32BarGetProp_AcceptFiles(hwnd);
			else		   rc = A64BarGetProp_AcceptFiles(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcBarGetProp_AcceptFiles@4", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarGetProp_AcceptFiles(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcBarGetProp_AcceptFiles", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarGetProp_AcceptFiles(IntPtr hwnd);

		//----- ●AjcBarPutData1 -------------------------------------------------------------------------------//
		public static void AjcBarPutData1(IntPtr hwnd, string pBarTtl, double dat0)
		{
			if (Is32Bit()) A32BarPutData1(hwnd, pBarTtl, dat0);
			else		   A64BarPutData1(hwnd, pBarTtl, dat0);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData1@16", ExactSpelling=true)]
		private static extern void A32BarPutData1(IntPtr hwnd, string pBarTtl, double dat0);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData1", ExactSpelling=true)]
		private static extern void A64BarPutData1(IntPtr hwnd,string pBarTtl,double dat0);

		//----- ●AjcBarPutData2 -------------------------------------------------------------------------------//
		public static void AjcBarPutData2(IntPtr hwnd, string pBarTtl, double dat0, double dat1)
		{
			if (Is32Bit()) A32BarPutData2(hwnd, pBarTtl, dat0, dat1);
			else		   A64BarPutData2(hwnd, pBarTtl, dat0, dat1);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData2@24", ExactSpelling=true)]
		private static extern void A32BarPutData2(IntPtr hwnd, string pBarTtl, double dat0, double dat1);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData2", ExactSpelling=true)]
		private static extern void A64BarPutData2(IntPtr hwnd,string pBarTtl,double dat0,double dat1);

		//----- ●AjcBarPutData3 -------------------------------------------------------------------------------//
		public static void AjcBarPutData3(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2)
		{
			if (Is32Bit()) A32BarPutData3(hwnd, pBarTtl, dat0, dat1, dat2);
			else		   A64BarPutData3(hwnd, pBarTtl, dat0, dat1, dat2);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData3@32", ExactSpelling=true)]
		private static extern void A32BarPutData3(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData3", ExactSpelling=true)]
		private static extern void A64BarPutData3(IntPtr hwnd,string pBarTtl,double dat0,double dat1,double dat2);

		//----- ●AjcBarPutData4 -------------------------------------------------------------------------------//
		public static void AjcBarPutData4(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3)
		{
			if (Is32Bit()) A32BarPutData4(hwnd, pBarTtl, dat0, dat1, dat2, dat3);
			else		   A64BarPutData4(hwnd, pBarTtl, dat0, dat1, dat2, dat3);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData4@40", ExactSpelling=true)]
		private static extern void A32BarPutData4(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData4", ExactSpelling=true)]
		private static extern void A64BarPutData4(IntPtr hwnd,string pBarTtl,double dat0,double dat1,double dat2,double dat3);

		//----- ●AjcBarPutData5 -------------------------------------------------------------------------------//
		public static void AjcBarPutData5(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4)
		{
			if (Is32Bit()) A32BarPutData5(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4);
			else		   A64BarPutData5(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData5@48", ExactSpelling=true)]
		private static extern void A32BarPutData5(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData5", ExactSpelling=true)]
		private static extern void A64BarPutData5(IntPtr hwnd,string pBarTtl,double dat0,double dat1,double dat2,double dat3,double dat4);

		//----- ●AjcBarPutData6 -------------------------------------------------------------------------------//
		public static void AjcBarPutData6(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5)
		{
			if (Is32Bit()) A32BarPutData6(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4, dat5);
			else		   A64BarPutData6(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4, dat5);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData6@56", ExactSpelling=true)]
		private static extern void A32BarPutData6(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData6", ExactSpelling=true)]
		private static extern void A64BarPutData6(IntPtr hwnd,string pBarTtl,double dat0,double dat1,double dat2,double dat3,double dat4,double dat5);

		//----- ●AjcBarPutData7 -------------------------------------------------------------------------------//
		public static void AjcBarPutData7(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6)
		{
			if (Is32Bit()) A32BarPutData7(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4, dat5, dat6);
			else		   A64BarPutData7(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4, dat5, dat6);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData7@64", ExactSpelling=true)]
		private static extern void A32BarPutData7(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData7", ExactSpelling=true)]
		private static extern void A64BarPutData7(IntPtr hwnd,string pBarTtl,double dat0,double dat1,double dat2,double dat3,double dat4,double dat5,double dat6);

		//----- ●AjcBarPutData8 -------------------------------------------------------------------------------//
		public static void AjcBarPutData8(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7)
		{
			if (Is32Bit()) A32BarPutData8(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4, dat5, dat6, dat7);
			else		   A64BarPutData8(hwnd, pBarTtl, dat0, dat1, dat2, dat3, dat4, dat5, dat6, dat7);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarPutData8@72", ExactSpelling=true)]
		private static extern void A32BarPutData8(IntPtr hwnd, string pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarPutData8", ExactSpelling=true)]
		private static extern void A64BarPutData8(IntPtr hwnd,string pBarTtl,double dat0,double dat1,double dat2,double dat3,double dat4,double dat5,double dat6,double dat7);

		//----- ●AjcBarSetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcBarSetTipTextForMSIL(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32BarSetTipTextForMSIL(hwnd, pTxt);
			else		   A64BarSetTipTextForMSIL(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetTipTextForMSIL@8", ExactSpelling=true)]
		private static extern void A32BarSetTipTextForMSIL(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64BarSetTipTextForMSIL(IntPtr hwnd, string pTxt);

		//----- ●AjcBarGetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcBarGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32BarGetTipTextForMSIL(hwnd, pBuf, lBuf);
			else		   A64BarGetTipTextForMSIL(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32BarGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64BarGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcBarSetChkBoxTipTextForMSIL ----------------------------------------------------------------//
		public static void AjcBarSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt)
		{
			if (Is32Bit()) A32BarSetChkBoxTipTextForMSIL(hwnd, n, pTxt);
			else		   A64BarSetChkBoxTipTextForMSIL(hwnd, n, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetChkBoxTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32BarSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetChkBoxTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64BarSetChkBoxTipTextForMSIL(IntPtr hwnd,int n,string pTxt);

		//----- ●AjcBarGetChkBoxTipTextForMSIL ----------------------------------------------------------------//
		public static void AjcBarGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32BarGetChkBoxTipTextForMSIL(hwnd, n, pBuf, lBuf);
			else		   A64BarGetChkBoxTipTextForMSIL(hwnd, n, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarGetChkBoxTipTextForMSIL@16", ExactSpelling=true)]
		private static extern void A32BarGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarGetChkBoxTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64BarGetChkBoxTipTextForMSIL(IntPtr hwnd,int n,StringBuilder pBuf,int lBuf);

		//----- ●AjcBarSetTextFont ----------------------------------------------------------------------------//
		public static IntPtr AjcBarSetTextFont(IntPtr hwnd, IntPtr hFont)
		{
			IntPtr rc;
			if (Is32Bit()) rc = A32BarSetTextFont(hwnd, hFont);
			else		   rc = A64BarSetTextFont(hwnd, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarSetTextFont@8", ExactSpelling=true)]
		private static extern IntPtr A32BarSetTextFont(IntPtr hwnd, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarSetTextFont", ExactSpelling=true)]
		private static extern IntPtr A64BarSetTextFont(IntPtr hwnd, IntPtr hFont);

		//----- ●AjcBarTextOutW -------------------------------------------------------------------------------//
		public static int AjcBarTextOutW(IntPtr hwnd, int x, int y, string pTxt)
		{
			int		rc;
			if (Is32Bit()) rc = A32BarTextOutW(hwnd, x, y, pTxt);
			else		   rc = A64BarTextOutW(hwnd, x, y, pTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarTextOutW@16", ExactSpelling=true)]
		private static extern int A32BarTextOutW(IntPtr hwnd, int x, int y, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarTextOutW", ExactSpelling=true)]
		private static extern int A64BarTextOutW(IntPtr hwnd, int x, int y, string pTxt);

		//----- ●AjcBarClearText ------------------------------------------------------------------------------//
		public static bool AjcBarClearText(IntPtr hwnd, int key)
		{
			bool		rc;
			if (Is32Bit()) rc = A32BarClearText(hwnd, key);
			else		   rc = A64BarClearText(hwnd, key);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarClearText@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarClearText(IntPtr hwnd, int key);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarClearText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarClearText(IntPtr hwnd, int key);

		//----- ●AjcBarClearAllText ---------------------------------------------------------------------------//
		public static bool AjcBarClearAllText(IntPtr hwnd)
		{
			bool		rc;
			if (Is32Bit()) rc = A32BarClearAllText(hwnd);
			else		   rc = A64BarClearAllText(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcBarClearAllText@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32BarClearAllText(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcBarClearAllText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64BarClearAllText(IntPtr hwnd);

		//======================================================================================================//
		//	AjcCtrlInpVal.h 																					//
		//======================================================================================================//

		//----- ●AjcIvSetTipShowAlways -----------------------------------------------------------------------//
		public static void AjcIvSetTipShowAlways(IntPtr hwnd, bool fShowAlways)
		{
			if (Is32Bit()) A32IvSetTipShowAlways(hwnd, fShowAlways);
			else		   A64IvSetTipShowAlways(hwnd, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetTipShowAlways@8", ExactSpelling=true)]
		private static extern void A32IvSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetTipShowAlways", ExactSpelling=true)]
		private static extern void A64IvSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShowAlways);

		//----- ●AjcIvEnaDefTipText ---------------------------------------------------------------------------//
		public static bool AjcIvEnaDefTipText(IntPtr hwnd, bool fEnable)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvEnaDefTipText(hwnd, fEnable);
			else		   rc = A64IvEnaDefTipText(hwnd, fEnable);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvEnaDefTipText@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvEnaDefTipText(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvEnaDefTipText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvEnaDefTipText(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fEnable);

		//----- ●AjcIvCreateForMSIL ---------------------------------------------------------------------------//
		public static IntPtr AjcIvCreateForMSIL(IntPtr hOwner, IvCbkNtcIntValue  CbkNtcIntValue,
															   IvCbkNtcRealValue CbkNtcRealValue,
															   IvCbkNtcRClick	 CbkNtcRClick)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32IvCreateForMSIL(hOwner, CbkNtcIntValue, CbkNtcRealValue, CbkNtcRClick);
			else		   rc = A64IvCreateForMSIL(hOwner, CbkNtcIntValue, CbkNtcRealValue, CbkNtcRClick);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvCreateForMSIL@16", ExactSpelling=true)]
		private static extern IntPtr A32IvCreateForMSIL(IntPtr hOwner, IvCbkNtcIntValue cbNtcIntValue, IvCbkNtcRealValue cbNtcRealValue, IvCbkNtcRClick CbkNtcRClick);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64IvCreateForMSIL(IntPtr hOwner, IvCbkNtcIntValue cbNtcIntValue, IvCbkNtcRealValue cbNtcRealValue, IvCbkNtcRClick CbkNtcRClick);

		//----- ●AjcIvGetSty_AUTOEDIT -------------------------------------------------------------------------//
		public static bool AjcIvGetSty_AUTOEDIT(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_AUTOEDIT(hwnd);
			else		   rc = A64IvGetSty_AUTOEDIT(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_AUTOEDIT@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_AUTOEDIT(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_AUTOEDIT", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_AUTOEDIT(IntPtr hwnd);

		//----- ●AjcIvSetSty_AUTOEDIT -------------------------------------------------------------------------//
		public static void AjcIvSetSty_AUTOEDIT(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_AUTOEDIT(hwnd, f);
			else		   A64IvSetSty_AUTOEDIT(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_AUTOEDIT@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_AUTOEDIT(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_AUTOEDIT", ExactSpelling=true)]
		private static extern void A64IvSetSty_AUTOEDIT(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_SHOWHEX --------------------------------------------------------------------------//
		public static bool AjcIvGetSty_SHOWHEX(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_SHOWHEX(hwnd);
			else		   rc = A64IvGetSty_SHOWHEX(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_SHOWHEX@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_SHOWHEX(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_SHOWHEX", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_SHOWHEX(IntPtr hwnd);

		//----- ●AjcIvSetSty_SHOWHEX --------------------------------------------------------------------------//
		public static void AjcIvSetSty_SHOWHEX(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_SHOWHEX(hwnd, f);
			else		   A64IvSetSty_SHOWHEX(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_SHOWHEX@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_SHOWHEX(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_SHOWHEX", ExactSpelling=true)]
		private static extern void A64IvSetSty_SHOWHEX(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_NOBLINK --------------------------------------------------------------------------//
		public static bool AjcIvGetSty_NOBLINK(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_NOBLINK(hwnd);
			else		   rc = A64IvGetSty_NOBLINK(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_NOBLINK@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_NOBLINK(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_NOBLINK", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_NOBLINK(IntPtr hwnd);

		//----- ●AjcIvSetSty_NOBLINK --------------------------------------------------------------------------//
		public static void AjcIvSetSty_NOBLINK(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_NOBLINK(hwnd, f);
			else		   A64IvSetSty_NOBLINK(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_NOBLINK@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_NOBLINK(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_NOBLINK", ExactSpelling=true)]
		private static extern void A64IvSetSty_NOBLINK(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_NOBORDER -------------------------------------------------------------------------//
		public static bool AjcIvGetSty_NOBORDER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_NOBORDER(hwnd);
			else		   rc = A64IvGetSty_NOBORDER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_NOBORDER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_NOBORDER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_NOBORDER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_NOBORDER(IntPtr hwnd);

		//----- ●AjcIvSetSty_NOBORDER -------------------------------------------------------------------------//
		public static void AjcIvSetSty_NOBORDER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_NOBORDER(hwnd, f);
			else		   A64IvSetSty_NOBORDER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_NOBORDER@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_NOBORDER", ExactSpelling=true)]
		private static extern void A64IvSetSty_NOBORDER(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_NOSLD ----------------------------------------------------------------------------//
		public static bool AjcIvGetSty_NOSLD(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_NOSLD(hwnd);
			else		   rc = A64IvGetSty_NOSLD(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_NOSLD@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_NOSLD(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_NOSLD", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_NOSLD(IntPtr hwnd);

		//----- ●AjcIvSetSty_NOSLD ----------------------------------------------------------------------------//
		public static void AjcIvSetSty_NOSLD(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_NOSLD(hwnd, f);
			else		   A64IvSetSty_NOSLD(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_NOSLD@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_NOSLD(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_NOSLD", ExactSpelling=true)]
		private static extern void A64IvSetSty_NOSLD(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_NOBTN ----------------------------------------------------------------------------//
		public static bool AjcIvGetSty_NOBTN(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_NOBTN(hwnd);
			else		   rc = A64IvGetSty_NOBTN(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_NOBTN@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_NOBTN(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_NOBTN", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_NOBTN(IntPtr hwnd);

		//----- ●AjcIvSetSty_NOBTN ----------------------------------------------------------------------------//
		public static void AjcIvSetSty_NOBTN(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_NOBTN(hwnd, f);
			else		   A64IvSetSty_NOBTN(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_NOBTN@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_NOBTN(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_NOBTN", ExactSpelling=true)]
		private static extern void A64IvSetSty_NOBTN(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_NOSPN ----------------------------------------------------------------------------//
		public static bool AjcIvGetSty_NOSPN(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_NOSPN(hwnd);
			else		   rc = A64IvGetSty_NOSPN(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_NOSPN@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_NOSPN(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_NOSPN", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_NOSPN(IntPtr hwnd);

		//----- ●AjcIvSetSty_NOSPN ----------------------------------------------------------------------------//
		public static void AjcIvSetSty_NOSPN(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_NOSPN(hwnd, f);
			else		   A64IvSetSty_NOSPN(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_NOSPN@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_NOSPN(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_NOSPN", ExactSpelling=true)]
		private static extern void A64IvSetSty_NOSPN(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_SEPARATE -------------------------------------------------------------------------//
		public static bool AjcIvGetSty_SEPARATE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_SEPARATE(hwnd);
			else		   rc = A64IvGetSty_SEPARATE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_SEPARATE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_SEPARATE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_SEPARATE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_SEPARATE(IntPtr hwnd);

		//----- ●AjcIvSetSty_SEPARATE -------------------------------------------------------------------------//
		public static void AjcIvSetSty_SEPARATE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_SEPARATE(hwnd, f);
			else		   A64IvSetSty_SEPARATE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_SEPARATE@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_SEPARATE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_SEPARATE", ExactSpelling=true)]
		private static extern void A64IvSetSty_SEPARATE(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetSty_REALMODE -------------------------------------------------------------------------//
		public static bool AjcIvGetSty_REALMODE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetSty_REALMODE(hwnd);
			else		   rc = A64IvGetSty_REALMODE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetSty_REALMODE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetSty_REALMODE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetSty_REALMODE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetSty_REALMODE(IntPtr hwnd);

		//----- ●AjcIvSetSty_REALMODE -------------------------------------------------------------------------//
		public static void AjcIvSetSty_REALMODE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32IvSetSty_REALMODE(hwnd, f);
			else		   A64IvSetSty_REALMODE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetSty_REALMODE@8", ExactSpelling=true)]
		private static extern void A32IvSetSty_REALMODE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetSty_REALMODE", ExactSpelling=true)]
		private static extern void A64IvSetSty_REALMODE(IntPtr hwnd,[MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcIvGetProp_min -----------------------------------------------------------------------------//
		public static double AjcIvGetProp_min(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32IvGetProp_min(hwnd);
			else		   rc = A64IvGetProp_min(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_min@4", ExactSpelling=true)]
		private static extern double A32IvGetProp_min(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_min", ExactSpelling=true)]
		private static extern double A64IvGetProp_min(IntPtr hwnd);

		//----- ●AjcIvSetProp_min -----------------------------------------------------------------------------//
		public static void AjcIvSetProp_min(IntPtr hwnd, double value)
		{
			if (Is32Bit()) A32IvSetProp_min(hwnd, value);
			else		   A64IvSetProp_min(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_min@12", ExactSpelling=true)]
		private static extern void A32IvSetProp_min(IntPtr hwnd, double value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_min", ExactSpelling=true)]
		private static extern void A64IvSetProp_min(IntPtr hwnd,double value);

		//----- ●AjcIvGetProp_max -----------------------------------------------------------------------------//
		public static double AjcIvGetProp_max(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32IvGetProp_max(hwnd);
			else		   rc = A64IvGetProp_max(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_max@4", ExactSpelling=true)]
		private static extern double A32IvGetProp_max(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_max", ExactSpelling=true)]
		private static extern double A64IvGetProp_max(IntPtr hwnd);

		//----- ●AjcIvSetProp_max -----------------------------------------------------------------------------//
		public static void AjcIvSetProp_max(IntPtr hwnd, double value)
		{
			if (Is32Bit()) A32IvSetProp_max(hwnd, value);
			else		   A64IvSetProp_max(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_max@12", ExactSpelling=true)]
		private static extern void A32IvSetProp_max(IntPtr hwnd, double value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_max", ExactSpelling=true)]
		private static extern void A64IvSetProp_max(IntPtr hwnd,double value);

		//----- ●AjcIvGetProp_SldUnit -------------------------------------------------------------------------//
		public static double AjcIvGetProp_SldUnit(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32IvGetProp_SldUnit(hwnd);
			else		   rc = A64IvGetProp_SldUnit(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_SldUnit@4", ExactSpelling=true)]
		private static extern double A32IvGetProp_SldUnit(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_SldUnit", ExactSpelling=true)]
		private static extern double A64IvGetProp_SldUnit(IntPtr hwnd);

		//----- ●AjcIvSetProp_SldUnit -------------------------------------------------------------------------//
		public static void AjcIvSetProp_SldUnit(IntPtr hwnd, double value)
		{
			if (Is32Bit()) A32IvSetProp_SldUnit(hwnd, value);
			else		   A64IvSetProp_SldUnit(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_SldUnit@12", ExactSpelling=true)]
		private static extern void A32IvSetProp_SldUnit(IntPtr hwnd, double value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_SldUnit", ExactSpelling=true)]
		private static extern void A64IvSetProp_SldUnit(IntPtr hwnd,double value);

		//----- ●AjcIvGetProp_SldPage -------------------------------------------------------------------------//
		public static double AjcIvGetProp_SldPage(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32IvGetProp_SldPage(hwnd);
			else		   rc = A64IvGetProp_SldPage(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_SldPage@4", ExactSpelling=true)]
		private static extern double A32IvGetProp_SldPage(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_SldPage", ExactSpelling=true)]
		private static extern double A64IvGetProp_SldPage(IntPtr hwnd);

		//----- ●AjcIvSetProp_SldPage -------------------------------------------------------------------------//
		public static void AjcIvSetProp_SldPage(IntPtr hwnd, double value)
		{
			if (Is32Bit()) A32IvSetProp_SldPage(hwnd, value);
			else		   A64IvSetProp_SldPage(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_SldPage@12", ExactSpelling=true)]
		private static extern void A32IvSetProp_SldPage(IntPtr hwnd, double value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_SldPage", ExactSpelling=true)]
		private static extern void A64IvSetProp_SldPage(IntPtr hwnd,double value);

		//----- ●AjcIvGetProp_SpnStep -------------------------------------------------------------------------//
		public static double AjcIvGetProp_SpnStep(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32IvGetProp_SpnStep(hwnd);
			else		   rc = A64IvGetProp_SpnStep(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_SpnStep@4", ExactSpelling=true)]
		private static extern double A32IvGetProp_SpnStep(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_SpnStep", ExactSpelling=true)]
		private static extern double A64IvGetProp_SpnStep(IntPtr hwnd);

		//----- ●AjcIvSetProp_SpnStep -------------------------------------------------------------------------//
		public static void AjcIvSetProp_SpnStep(IntPtr hwnd, double value)
		{
			if (Is32Bit()) A32IvSetProp_SpnStep(hwnd, value);
			else		   A64IvSetProp_SpnStep(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_SpnStep@12", ExactSpelling=true)]
		private static extern void A32IvSetProp_SpnStep(IntPtr hwnd, double value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_SpnStep", ExactSpelling=true)]
		private static extern void A64IvSetProp_SpnStep(IntPtr hwnd,double value);

		//----- ●AjcIvGetProp_TextLen -------------------------------------------------------------------------//
		public static int AjcIvGetProp_TextLen(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32IvGetProp_TextLen(hwnd);
			else		   rc = A64IvGetProp_TextLen(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_TextLen@4", ExactSpelling=true)]
		private static extern int A32IvGetProp_TextLen(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_TextLen", ExactSpelling=true)]
		private static extern int A64IvGetProp_TextLen(IntPtr hwnd);

		//----- ●AjcIvSetProp_TextLen -------------------------------------------------------------------------//
		public static void AjcIvSetProp_TextLen(IntPtr hwnd, int value)
		{
			if (Is32Bit()) A32IvSetProp_TextLen(hwnd, value);
			else		   A64IvSetProp_TextLen(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_TextLen@8", ExactSpelling=true)]
		private static extern void A32IvSetProp_TextLen(IntPtr hwnd, int value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_TextLen", ExactSpelling=true)]
		private static extern void A64IvSetProp_TextLen(IntPtr hwnd,int value);

		//----- ●AjcIvGetProp_PrecisionDlg --------------------------------------------------------------------//
		public static int AjcIvGetProp_PrecisionDlg(int value)
		{
			int	rc;
			if (Is32Bit()) rc = A32IvGetProp_PrecisionDlg(value);
			else		   rc = A64IvGetProp_PrecisionDlg(value);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_PrecisionDlg@4", ExactSpelling=true)]
		private static extern int A32IvGetProp_PrecisionDlg(int value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_PrecisionDlg", ExactSpelling=true)]
		private static extern int A64IvGetProp_PrecisionDlg(int value);

		//----- ●AjcIvGetProp_Precision -----------------------------------------------------------------------//
		public static int AjcIvGetProp_Precision(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32IvGetProp_Precision(hwnd);
			else		   rc = A64IvGetProp_Precision(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_Precision@4", ExactSpelling=true)]
		private static extern int A32IvGetProp_Precision(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_Precision", ExactSpelling=true)]
		private static extern int A64IvGetProp_Precision(IntPtr hwnd);

		//----- ●AjcIvSetProp_Precision -----------------------------------------------------------------------//
		public static void AjcIvSetProp_Precision(IntPtr hwnd, int value)
		{
			if (Is32Bit()) A32IvSetProp_Precision(hwnd, value);
			else		   A64IvSetProp_Precision(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_Precision@8", ExactSpelling=true)]
		private static extern void A32IvSetProp_Precision(IntPtr hwnd, int value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_Precision", ExactSpelling=true)]
		private static extern void A64IvSetProp_Precision(IntPtr hwnd,int value);

		//----- ●AjcIvGetProp_HexLen --------------------------------------------------------------------------//
		public static int AjcIvGetProp_HexLen(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32IvGetProp_HexLen(hwnd);
			else		   rc = A64IvGetProp_HexLen(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_HexLen@4", ExactSpelling=true)]
		private static extern int A32IvGetProp_HexLen(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_HexLen", ExactSpelling=true)]
		private static extern int A64IvGetProp_HexLen(IntPtr hwnd);

		//----- ●AjcIvSetProp_HexLen --------------------------------------------------------------------------//
		public static void AjcIvSetProp_HexLen(IntPtr hwnd, int value)
		{
			if (Is32Bit()) A32IvSetProp_HexLen(hwnd, value);
			else		   A64IvSetProp_HexLen(hwnd, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_HexLen@8", ExactSpelling=true)]
		private static extern void A32IvSetProp_HexLen(IntPtr hwnd, int value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_HexLen", ExactSpelling=true)]
		private static extern void A64IvSetProp_HexLen(IntPtr hwnd,int value);

		//----- ●AjcIvSetProp_WndSize -------------------------------------------------------------------------//
		public static void AjcIvSetProp_WndSize(IntPtr hwnd, int width, int height)
		{
			if (Is32Bit()) A32IvSetProp_WndSize(hwnd, width, height);
			else		   A64IvSetProp_WndSize(hwnd, width, height);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_WndSize@12", ExactSpelling=true)]
		private static extern void A32IvSetProp_WndSize(IntPtr hwnd, int width, int height);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_WndSize", ExactSpelling=true)]
		private static extern void A64IvSetProp_WndSize(IntPtr hwnd,int width,int height);

		//----- ●AjcIvGetProp_BorderColor ---------------------------------------------------------------------//
		public static int AjcIvGetProp_BorderColor(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32IvGetProp_BorderColor(hwnd);
			else		   rc = A64IvGetProp_BorderColor(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetProp_BorderColor@4", ExactSpelling=true)]
		private static extern int A32IvGetProp_BorderColor(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetProp_BorderColor", ExactSpelling=true)]
		private static extern int A64IvGetProp_BorderColor(IntPtr hwnd);

		//----- ●AjcIvSetProp_BorderColor ---------------------------------------------------------------------//
		public static void AjcIvSetProp_BorderColor(IntPtr hwnd, int rgb)
		{
			if (Is32Bit()) A32IvSetProp_BorderColor(hwnd, rgb);
			else		   A64IvSetProp_BorderColor(hwnd, rgb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetProp_BorderColor@8", ExactSpelling=true)]
		private static extern void A32IvSetProp_BorderColor(IntPtr hwnd, int rgb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetProp_BorderColor", ExactSpelling=true)]
		private static extern void A64IvSetProp_BorderColor(IntPtr hwnd,int rgb);

		//----- ●AjcIvGetIntValue -----------------------------------------------------------------------------//
		public static int AjcIvGetIntValue(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32IvGetIntValue(hwnd);
			else		   rc = A64IvGetIntValue(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetIntValue@4", ExactSpelling=true)]
		private static extern int A32IvGetIntValue(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetIntValue", ExactSpelling=true)]
		private static extern int A64IvGetIntValue(IntPtr hwnd);

		//----- ●AjcIvSetIntValue -----------------------------------------------------------------------------//
		public static void AjcIvSetIntValue(IntPtr hwnd, int value, bool fNtc)
		{
			if (Is32Bit()) A32IvSetIntValue(hwnd, value, fNtc);
			else		   A64IvSetIntValue(hwnd, value, fNtc);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetIntValue@12", ExactSpelling=true)]
		private static extern void A32IvSetIntValue(IntPtr hwnd, int value, [MarshalAs(UnmanagedType.Bool)] bool fNtc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetIntValue", ExactSpelling=true)]
		private static extern void A64IvSetIntValue(IntPtr hwnd, int value, [MarshalAs(UnmanagedType.Bool)] bool fNtc);

		//----- ●AjcIvGetRealValue ----------------------------------------------------------------------------//
		public static double AjcIvGetRealValue(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32IvGetRealValue(hwnd);
			else		   rc = A64IvGetRealValue(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetRealValue@4", ExactSpelling=true)]
		private static extern double A32IvGetRealValue(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetRealValue", ExactSpelling=true)]
		private static extern double A64IvGetRealValue(IntPtr hwnd);

		//----- ●AjcIvSetRealValue ----------------------------------------------------------------------------//
		public static void AjcIvSetRealValue(IntPtr hwnd, double value, bool fNtc)
		{
			if (Is32Bit()) A32IvSetRealValue(hwnd, value, fNtc);
			else		   A64IvSetRealValue(hwnd, value, fNtc);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetRealValue@16", ExactSpelling=true)]
		private static extern void A32IvSetRealValue(IntPtr hwnd, double value, [MarshalAs(UnmanagedType.Bool)] bool fNtc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetRealValue", ExactSpelling=true)]
		private static extern void A64IvSetRealValue(IntPtr hwnd, double value, [MarshalAs(UnmanagedType.Bool)] bool fNtc);

		//----- ●AjcIvGetText ---------------------------------------------------------------------------------//
		public static string AjcIvGetText(IntPtr hwnd)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32IvGetText(hwnd, s, s.Capacity);
			else		   A64IvGetText(hwnd, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetText@12", ExactSpelling=true)]
		private static extern void A32IvGetText(IntPtr hwnd, StringBuilder pText, int lText);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetText", ExactSpelling=true)]
		private static extern void A64IvGetText(IntPtr hwnd,StringBuilder pText,int lText);

		//----- ●AjcIvSetText ---------------------------------------------------------------------------------//
		public static void AjcIvSetText(IntPtr hwnd, string text)
		{
			if (Is32Bit()) A32IvSetText(hwnd, text);
			else		   A64IvSetText(hwnd, text);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetText@8", ExactSpelling=true)]
		private static extern void A32IvSetText(IntPtr hwnd, string pText);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetText", ExactSpelling=true)]
		private static extern void A64IvSetText(IntPtr hwnd,string pText);

		//----- ●AjcIvSetTipTextForMSIL -----------------------------------------------------------------------//
		public static void AjcIvSetTipTextForMSIL(IntPtr hwnd, string pText)
		{
			if (Is32Bit()) A32IvSetTipTextForMSIL(hwnd, pText);
			else		   A64IvSetTipTextForMSIL(hwnd, pText);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvSetTipTextForMSIL@8", ExactSpelling=true)]
		private static extern void A32IvSetTipTextForMSIL(IntPtr hwnd, string pText);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvSetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64IvSetTipTextForMSIL(IntPtr hwnd,string pText);

		//----- ●AjcIvGetTipTextForMSIL -----------------------------------------------------------------------//
		public static void AjcIvGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32IvGetTipTextForMSIL(hwnd, pBuf, lBuf);
			else		   A64IvGetTipTextForMSIL(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32IvGetTipTextForMSIL(IntPtr hwnd, StringBuilder pText, int lText);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64IvGetTipTextForMSIL(IntPtr hwnd,StringBuilder pText,int lText);

		//----- ●AjcIvGetEditState -------------------------------------------------------------------------//
		public static bool AjcIvGetEditState(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32IvGetEditState(hwnd);
			else		   rc = A64IvGetEditState(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcIvGetEditState@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32IvGetEditState(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcIvGetEditState", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64IvGetEditState(IntPtr hwnd);

		//======================================================================================================//
		//	AjcCtrlListBox.h																					//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcCtrlLogFile.h																					//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcCtrlTimeChart.h																					//
		//======================================================================================================//

		//----- ●AjcTchStop -----------------------------------------------------------------------------------//
		public static bool AjcTchStop(IntPtr hwnd)
		{
			bool rc;
			if (Is32Bit()) rc = A32TchStop(hwnd);
			else		   rc = A64TchStop(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchStop@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchStop(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcTchStop", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchStop(IntPtr hwnd);

		//----- ●AjcTchStart ----------------------------------------------------------------------------------//
		public static bool AjcTchStart(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchStart(hwnd);
			else		   rc = A64TchStart(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchStart@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchStart(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchStart", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchStart(IntPtr hwnd);

		//----- ●AjcTchPurge ----------------------------------------------------------------------------------//
		public static bool AjcTchPurge(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchPurge(hwnd);
			else		   rc = A64TchPurge(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPurge@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchPurge(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPurge", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchPurge(IntPtr hwnd);

		//----- ●AjcTchPutRealData ----------------------------------------------------------------------------//
		public static bool AjcTchPutRealData(IntPtr hwnd, IntPtr pData)
		{
			bool	rc=false;
			if (Is32Bit()) rc = A32TchPutRealData(hwnd, pData);
			else		   rc = A64TchPutRealData(hwnd, pData);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutRealData@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchPutRealData(IntPtr hwnd, IntPtr dat);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutRealData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchPutRealData(IntPtr hwnd, IntPtr dat);

		//----- ●AjcTchPutIntData -----------------------------------------------------------------------------//

		//----- ●AjcTchGetRealRange ---------------------------------------------------------------------------//

		//----- ●AjcTchSetRealRange ---------------------------------------------------------------------------//

		//----- ●AjcTchAdjustRange ----------------------------------------------------------------------------//
		public static bool AjcTchAdjustRange(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchAdjustRange(hwnd);
			else		   rc = A64TchAdjustRange(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcTchAdjustRange@4", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchAdjustRange(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcTchAdjustRange", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchAdjustRange(IntPtr hwnd);

		//----- ●AjcTchSetTimeScale ---------------------------------------------------------------------------//

		//----- ●AjcTchLoadPermInfo ---------------------------------------------------------------------------//
		public static bool AjcTchLoadPermInfo(IntPtr hwnd, string pProfileSect, string pKeyPrefix)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchLoadPermInfo(hwnd, pProfileSect, pKeyPrefix);
			else		   rc = A64TchLoadPermInfo(hwnd, pProfileSect, pKeyPrefix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchLoadPermInfoW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchLoadPermInfo(IntPtr hwnd, string pProfileSect, string pKeyPrefix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchLoadPermInfoW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchLoadPermInfo(IntPtr hwnd, string pProfileSect, string pKeyPrefix);

		//----- ●AjcTchSavePermInfo -------------------------------------------------------------------------------//
		public static bool AjcTchSavePermInfo(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchSavePermInfo(hwnd);
			else		   rc = A64TchSavePermInfo(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSavePermInfo@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchSavePermInfo(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSavePermInfo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchSavePermInfo(IntPtr hwnd);

		//----- ●AjcTchLoadProp -------------------------------------------------------------------------------//
		public static bool AjcTchLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchLoadProp(hwnd, pProfileSect, pDefProp);
			else		   rc = A64TchLoadProp(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchLoadPropW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchLoadPropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);

		//----- ●AjcTchSaveProp -------------------------------------------------------------------------------//
		public static bool AjcTchSaveProp(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchSaveProp(hwnd, pProfileSect);
			else		   rc = A64TchSaveProp(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSavePropW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchSaveProp(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSavePropW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchSaveProp(IntPtr hwnd, string pProfileSect);

		//----- ●AjcTchLoadPropEx -----------------------------------------------------------------------------//
		public static bool AjcTchLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchLoadPropEx(hwnd, pProfileSect, pDefProp);
			else		   rc = A64TchLoadPropEx(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchLoadPropExW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchLoadPropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchLoadPropEx(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);

		//----- ●AjcTchSavePropEx -----------------------------------------------------------------------------//
		public static bool AjcTchSavePropEx(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchSavePropEx(hwnd, pProfileSect);
			else		   rc = A64TchSavePropEx(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSavePropExW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchSavePropEx(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSavePropExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchSavePropEx(IntPtr hwnd, string pProfileSect);

		//----- ●AjcTchEnablePopupMenu ------------------------------------------------------------------------//
		public static void AjcTchEnablePopupMenu(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32TchEnablePopupMenu(hwnd, fEnable);
			else		   A64TchEnablePopupMenu(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchEnablePopupMenu@8", ExactSpelling=true)]
		private static extern void A32TchEnablePopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchEnablePopupMenu", ExactSpelling=true)]
		private static extern void A64TchEnablePopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcTchSetTipText -----------------------------------------------------------------------------//
		public static void AjcTchSetTipText(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32TchSetTipText(hwnd, pTxt);
			else		   A64TchSetTipText(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetTipTextW@8", ExactSpelling=true)]
		private static extern void A32TchSetTipText(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetTipTextW", ExactSpelling=true)]
		private static extern void A64TchSetTipText(IntPtr hwnd, string pTxt);

		//----- ●AjcTchGetTipText -----------------------------------------------------------------------------//
		public static void AjcTchGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32TchGetTipText(hwnd, pBuf, lBuf);
			else		   A64TchGetTipText(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetTipTextW@12", ExactSpelling=true)]
		private static extern void A32TchGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetTipTextW", ExactSpelling=true)]
		private static extern void A64TchGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcTchSetTipShowAlways -----------------------------------------------------------------------//
		public static void AjcTchSetTipShowAlways(IntPtr hwnd, bool fShowAlways)
		{
			if (Is32Bit()) A32AjcTchSetTipShowAlways(hwnd, fShowAlways);
			else		   A64AjcTchSetTipShowAlways(hwnd, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetTipShowAlways@8", ExactSpelling=true)]
		private static extern void A32AjcTchSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetTipShowAlways", ExactSpelling=true)]
		private static extern void A64AjcTchSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);

		//----- ●AjcTchSetChkBoxTipShowAlways -----------------------------------------------------------------------//
		public static void AjcTchSetChkBoxTipShowAlways(IntPtr hwnd, int n, bool fShowAlways)
		{
			if (Is32Bit()) A32AjcTchSetChkBoxTipShowAlways(hwnd, n, fShowAlways);
			else		   A64AjcTchSetChkBoxTipShowAlways(hwnd, n, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetChkBoxTipShowAlways@12", ExactSpelling=true)]
		private static extern void A32AjcTchSetChkBoxTipShowAlways(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetChkBoxTipShowAlways", ExactSpelling=true)]
		private static extern void A64AjcTchSetChkBoxTipShowAlways(IntPtr hwnd,int n, [MarshalAs(UnmanagedType.Bool)]bool fShowAlways);

		//----- ●AjcTchSetChkBoxTipText -----------------------------------------------------------------------//
		public static void AjcTchSetChkBoxTipText(IntPtr hwnd, int n, string pTxt)
		{
			if (Is32Bit()) A32TchSetChkBoxTipText(hwnd, n, pTxt);
			else		   A64TchSetChkBoxTipText(hwnd, n, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetChkBoxTipTextW@12", ExactSpelling=true)]
		private static extern void A32TchSetChkBoxTipText(IntPtr hwnd, int n, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetChkBoxTipTextW", ExactSpelling=true)]
		private static extern void A64TchSetChkBoxTipText(IntPtr hwnd, int n, string pTxt);

		//----- ●AjcTchGetChkBoxTipText -----------------------------------------------------------------------//
		public static void AjcTchGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32TchGetChkBoxTipText(hwnd, n, pBuf, lBuf);
			else		   A64TchGetChkBoxTipText(hwnd, n, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetChkBoxTipTextW@16", ExactSpelling=true)]
		private static extern void A32TchGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetChkBoxTipTextW", ExactSpelling=true)]
		private static extern void A64TchGetChkBoxTipText(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);

		//----- ●AjcTchSetMaxLineDist -------------------------------------------------------------------------//
		public static void AjcTchSetMaxLineDist(IntPtr hwnd, double MaxLineDist)
		{
			if (Is32Bit()) A32TchSetMaxLineDist(hwnd, MaxLineDist);
			else		   A64TchSetMaxLineDist(hwnd, MaxLineDist);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetMaxLineDist@12", ExactSpelling=true)]
		private static extern void A32TchSetMaxLineDist(IntPtr hwnd, double MaxLineDist);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetMaxLineDist", ExactSpelling=true)]
		private static extern void A64TchSetMaxLineDist(IntPtr hwnd, double MaxLineDist);

		//----- ●AjcTchGetMaxLineDist -------------------------------------------------------------------------//
		public static double AjcTchGetMaxLineDist(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32TchGetMaxLineDist(hwnd);
			else		   rc = A64TchGetMaxLineDist(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetMaxLineDist@4", ExactSpelling=true)]
		private static extern double A32TchGetMaxLineDist(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetMaxLineDist", ExactSpelling=true)]
		private static extern double A64TchGetMaxLineDist(IntPtr hwnd);

		//----- ●AjcTchGetScrollPos ---------------------------------------------------------------------------//
		public static int AjcTchGetScrollPos(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetScrollPos(hwnd);
			else		   rc = A64TchGetScrollPos(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetScrollPos@4", ExactSpelling=true)]
		private static extern int A32TchGetScrollPos(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetScrollPos", ExactSpelling=true)]
		private static extern int A64TchGetScrollPos(IntPtr hwnd);

		//----- ●AjcTchSetScrollPos ---------------------------------------------------------------------------//
		public static void AjcTchSetScrollPos(IntPtr hwnd, int pos)
		{
			if (Is32Bit()) A32TchSetScrollPos(hwnd, pos);
			else		   A64TchSetScrollPos(hwnd, pos);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetScrollPos@8", ExactSpelling=true)]
		private static extern void A32TchSetScrollPos(IntPtr hwnd, int pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetScrollPos", ExactSpelling=true)]
		private static extern void A64TchSetScrollPos(IntPtr hwnd, int pos);

		//----- ●AjcTchSetFilter ------------------------------------------------------------------------------//
		public static void AjcTchSetFilter(IntPtr hwnd, int n, bool state)
		{
			if (Is32Bit()) A32TchSetFilter(hwnd, n, state);
			else		   A64TchSetFilter(hwnd, n, state);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetFilter@12", ExactSpelling=true)]
		private static extern void A32TchSetFilter(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)] bool state);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetFilter", ExactSpelling=true)]
		private static extern void A64TchSetFilter(IntPtr hwnd, int n, [MarshalAs(UnmanagedType.Bool)] bool state);

		//----- ●AjcTchGetFilter ------------------------------------------------------------------------------//
		public static bool AjcTchGetFilter(IntPtr hwnd, int n)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetFilter(hwnd, n);
			else		   rc = A64TchGetFilter(hwnd, n);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetFilter@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetFilter(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetFilter", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetFilter(IntPtr hwnd, int n);

		//----- ●AjcTchSetHLineAtt ----------------------------------------------------------------------------//
		public static bool AjcTchSetHLineAtt(IntPtr hwnd, int id, int color, int width, ETchLineStyle style)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchSetHLineAtt(hwnd, id, color, width, style);
			else		   rc = A64TchSetHLineAtt(hwnd, id, color, width, style);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetHLineAtt@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchSetHLineAtt(IntPtr hwnd, int id, int color, int width, ETchLineStyle style);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetHLineAtt", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchSetHLineAtt(IntPtr hwnd, int id, int color, int width, ETchLineStyle style);

		//----- ●AjcTchSetHLinePos ----------------------------------------------------------------------------//
		public static bool AjcTchSetHLinePos(IntPtr hwnd, int id, double pos)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchSetHLinePos(hwnd, id, pos);
			else		   rc = A64TchSetHLinePos(hwnd, id, pos);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetHLinePos@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchSetHLinePos(IntPtr hwnd, int id, double pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetHLinePos", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchSetHLinePos(IntPtr hwnd, int id, double pos);

		//----- ●AjcTchEnableHLine ----------------------------------------------------------------------------//
		public static bool AjcTchEnableHLine(IntPtr hwnd, int id, bool fEnable)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchEnableHLine(hwnd, id, fEnable);
			else		   rc = A64TchEnableHLine(hwnd, id, fEnable);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchEnableHLine@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchEnableHLine(IntPtr hwnd, int id, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchEnableHLine", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchEnableHLine(IntPtr hwnd, int id, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcTchSetVLine -------------------------------------------------------------------------------//
		public static void AjcTchSetVLine(IntPtr hwnd, int color, int width, ETchLineStyle style)
		{
			if (Is32Bit()) A32TchSetVLine(hwnd, color, width, style);
			else		   A64TchSetVLine(hwnd, color, width, style);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetVLine@16", ExactSpelling=true)]
		private static extern void A32TchSetVLine(IntPtr hwnd, int color, int width, ETchLineStyle style);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetVLine", ExactSpelling=true)]
		private static extern void A64TchSetVLine(IntPtr hwnd, int color, int width, ETchLineStyle style);

		//----- ●AjcTchEnableVLine ----------------------------------------------------------------------------//
		public static void AjcTchEnableVLine(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32TchEnableVLine(hwnd, fEnable);
			else		   A64TchEnableVLine(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchEnableVLine@8", ExactSpelling=true)]
		private static extern void A32TchEnableVLine(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchEnableVLine", ExactSpelling=true)]
		private static extern void A64TchEnableVLine(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcTchGetDroppedFile -------------------------------------------------------------------------//
		public static string AjcTchGetDroppedFile(IntPtr hwnd)
		{
			string	rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32TchGetDroppedFile(hwnd, s)) rc = s.ToString();
				else							   rc = "";
			}
			else {
				if (A64TchGetDroppedFile(hwnd, s)) rc = s.ToString();
				else							   rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetDroppedFileW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetDroppedFile(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcTchGetDroppedFileW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetDroppedFile(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcTchGetDroppedDir --------------------------------------------------------------------------//
		public static string AjcTchGetDroppedDir(IntPtr hwnd)
		{
			string		rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32TchGetDroppedDir(hwnd, s)) rc = s.ToString();
				else							  rc = "";
			}
			else {
				if (A64TchGetDroppedDir(hwnd, s)) rc = s.ToString();
				else							  rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetDroppedDirW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetDroppedDir(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcTchGetDroppedDirW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetDroppedDir(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcTchSetTitleText ---------------------------------------------------------------------------//
		public static bool AjcTchSetTitleText(IntPtr hwnd, string Text, Color TextColor, Color BackColor, Font TextFont)
		{
			bool	rc;
			int 	TxtCol = TextColor == Color.Empty ? -1 : (TextColor.B << 16 | TextColor.G << 8 | TextColor.R);
			int 	BakCol = BackColor == Color.Empty ? -1 : (BackColor.B << 16 | BackColor.G << 8 | BackColor.R);
			IntPtr	hFont  = TextFont  == null ?  (IntPtr)0 : TextFont.ToHfont();
			if (Is32Bit()) rc = A32TchSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			else		   rc = A64TchSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetTitleTextW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetTitleTextW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);

		//----- ●AjcTchPause ----------------------------------------------------------------------------------//
		public static bool AjcTchPause(IntPtr hwnd, bool f)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchPause(hwnd, f);
			else		   rc = A64TchPause(hwnd, f);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPause@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchPause(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPause", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchPause(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchEnableMesDraw --------------------------------------------------------------------------//
		public static bool AjcTchEnableMesDraw(IntPtr hwnd, bool f)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchEnableMesDraw(hwnd, f);
			else		   rc = A64TchEnableMesDraw(hwnd, f);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchEnableMesDraw@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchEnableMesDraw(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchEnableMesDraw", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchEnableMesDraw(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchCreateForMSIL --------------------------------------------------------------------------//
		public static IntPtr AjcTchCreateForMSIL(IntPtr hOwner, bool fShowScrollBar, TchCbkRangeChanged CbkRangeChanged, 
																					 TchCbkNtcScrollPos CbkNtcScrollPos,
																					 TchCbkFileDrop		CbkFileDrop	 ,
																					 TchCbkDirDrop		CbkDirDrop	 ,
																					 TchCbkRClick		CbkRClick)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32TchCreateForMSIL(hOwner, fShowScrollBar, CbkRangeChanged,
																			CbkNtcScrollPos,
																			CbkFileDrop    ,
																			CbkDirDrop	   ,
																			CbkRClick	   );
			else		   rc = A64TchCreateForMSIL(hOwner, fShowScrollBar, CbkRangeChanged,
																			CbkNtcScrollPos,
																			CbkFileDrop    ,
																			CbkDirDrop	   ,
																			CbkRClick	   );
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchCreateForMSIL@28", ExactSpelling=true)]
		private static extern IntPtr A32TchCreateForMSIL(IntPtr hOwner, [MarshalAs(UnmanagedType.Bool)] bool fShowScrollBar,
																		TchCbkRangeChanged cbRangeChanged, 
																		TchCbkNtcScrollPos cbNtcScrollPos,
																		TchCbkFileDrop	   cbFileDrop	 ,
																		TchCbkDirDrop	   cbDirDrop	 ,
																		TchCbkRClick	   cbRClick);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64TchCreateForMSIL(IntPtr hOwner, [MarshalAs(UnmanagedType.Bool)] bool fShowScrollBar,
																		TchCbkRangeChanged cbRangeChanged,
																		TchCbkNtcScrollPos cbNtcScrollPos,
																		TchCbkFileDrop	   cbFileDrop	 ,
																		TchCbkDirDrop	   cbDirDrop	 ,
																		TchCbkRClick	   cbRClick);

		//----- ●AjcTchGetSty_NOBORDER ------------------------------------------------------------------------//
		public static bool AjcTchGetSty_NOBORDER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetSty_NOBORDER(hwnd);
			else		   rc = A64TchGetSty_NOBORDER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetSty_NOBORDER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetSty_NOBORDER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetSty_NOBORDER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetSty_NOBORDER(IntPtr hwnd);

		//----- ●AjcTchSetSty_NOBORDER ------------------------------------------------------------------------//
		public static void AjcTchSetSty_NOBORDER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32TchSetSty_NOBORDER(hwnd, f);
			else		   A64TchSetSty_NOBORDER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetSty_NOBORDER@8", ExactSpelling=true)]
		private static extern void A32TchSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetSty_NOBORDER", ExactSpelling=true)]
		private static extern void A64TchSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchGetSty_NOSCALELINE ---------------------------------------------------------------------//
		public static bool AjcTchGetSty_NOSCALELINE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetSty_NOSCALELINE(hwnd);
			else		   rc = A64TchGetSty_NOSCALELINE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetSty_NOSCALELINE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetSty_NOSCALELINE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetSty_NOSCALELINE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetSty_NOSCALELINE(IntPtr hwnd);

		//----- ●AjcTchSetSty_NOSCALELINE ---------------------------------------------------------------------//
		public static void AjcTchSetSty_NOSCALELINE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32TchSetSty_NOSCALELINE(hwnd, f);
			else		   A64TchSetSty_NOSCALELINE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetSty_NOSCALELINE@8", ExactSpelling=true)]
		private static extern void A32TchSetSty_NOSCALELINE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetSty_NOSCALELINE", ExactSpelling=true)]
		private static extern void A64TchSetSty_NOSCALELINE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchGetSty_NOSCALEVALUE --------------------------------------------------------------------//
		public static bool AjcTchGetSty_NOSCALEVALUE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetSty_NOSCALEVALUE(hwnd);
			else		   rc = A64TchGetSty_NOSCALEVALUE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetSty_NOSCALEVALUE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetSty_NOSCALEVALUE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetSty_NOSCALEVALUE", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetSty_NOSCALEVALUE(IntPtr hwnd);

		//----- ●AjcTchSetSty_NOSCALEVALUE --------------------------------------------------------------------//
		public static void AjcTchSetSty_NOSCALEVALUE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32TchSetSty_NOSCALEVALUE(hwnd, f);
			else		   A64TchSetSty_NOSCALEVALUE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetSty_NOSCALEVALUE@8", ExactSpelling=true)]
		private static extern void A32TchSetSty_NOSCALEVALUE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetSty_NOSCALEVALUE", ExactSpelling=true)]
		private static extern void A64TchSetSty_NOSCALEVALUE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchGetSty_NOFILTER ------------------------------------------------------------------------//
		public static bool AjcTchGetSty_NOFILTER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetSty_NOFILTER(hwnd);
			else		   rc = A64TchGetSty_NOFILTER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetSty_NOFILTER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetSty_NOFILTER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetSty_NOFILTER", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetSty_NOFILTER(IntPtr hwnd);

		//----- ●AjcTchSetSty_NOFILTER ------------------------------------------------------------------------//
		public static void AjcTchSetSty_NOFILTER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32TchSetSty_NOFILTER(hwnd, f);
			else		   A64TchSetSty_NOFILTER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetSty_NOFILTER@8", ExactSpelling=true)]
		private static extern void A32TchSetSty_NOFILTER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetSty_NOFILTER", ExactSpelling=true)]
		private static extern void A64TchSetSty_NOFILTER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchGetSty_NOSCROLLBAR ---------------------------------------------------------------------//
		public static bool AjcTchGetSty_NOSCROLLBAR(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetSty_NOSCROLLBAR(hwnd);
			else		   rc = A64TchGetSty_NOSCROLLBAR(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetSty_NOSCROLLBAR@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetSty_NOSCROLLBAR(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetSty_NOSCROLLBAR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetSty_NOSCROLLBAR(IntPtr hwnd);

		//----- ●AjcTchSetSty_NOSCROLLBAR ---------------------------------------------------------------------//
		public static void AjcTchSetSty_NOSCROLLBAR(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32TchSetSty_NOSCROLLBAR(hwnd, f);
			else		   A64TchSetSty_NOSCROLLBAR(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetSty_NOSCROLLBAR@8", ExactSpelling=true)]
		private static extern void A32TchSetSty_NOSCROLLBAR(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetSty_NOSCROLLBAR", ExactSpelling=true)]
		private static extern void A64TchSetSty_NOSCROLLBAR(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcTchGetProp_RngL ---------------------------------------------------------------------------//
		public static double AjcTchGetProp_RngL(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32TchGetProp_RngL(hwnd);
			else		   rc = A64TchGetProp_RngL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_RngL@4", ExactSpelling=true)]
		private static extern double A32TchGetProp_RngL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_RngL", ExactSpelling=true)]
		private static extern double A64TchGetProp_RngL(IntPtr hwnd);

		//----- ●AjcTchSetProp_RngL ---------------------------------------------------------------------------//
		public static void AjcTchSetProp_RngL(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32TchSetProp_RngL(hwnd, n);
			else		   A64TchSetProp_RngL(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_RngL@12", ExactSpelling=true)]
		private static extern void A32TchSetProp_RngL(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_RngL", ExactSpelling=true)]
		private static extern void A64TchSetProp_RngL(IntPtr hwnd, double n);

		//----- ●AjcTchGetProp_RngH ---------------------------------------------------------------------------//
		public static double AjcTchGetProp_RngH(IntPtr hwnd)
		{
			double	rc;
			if (Is32Bit()) rc = A32TchGetProp_RngH(hwnd);
			else		   rc = A64TchGetProp_RngH(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_RngH@4", ExactSpelling=true)]
		private static extern double A32TchGetProp_RngH(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_RngH", ExactSpelling=true)]
		private static extern double A64TchGetProp_RngH(IntPtr hwnd);

		//----- ●AjcTchSetProp_RngH ---------------------------------------------------------------------------//
		public static void AjcTchSetProp_RngH(IntPtr hwnd, double n)
		{
			if (Is32Bit()) A32TchSetProp_RngH(hwnd, n);
			else		   A64TchSetProp_RngH(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_RngH@12", ExactSpelling=true)]
		private static extern void A32TchSetProp_RngH(IntPtr hwnd, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_RngH", ExactSpelling=true)]
		private static extern void A64TchSetProp_RngH(IntPtr hwnd, double n);

		//----- ●AjcTchGetProp_TmScale ------------------------------------------------------------------------//
		public static int AjcTchGetProp_TmScale(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_TmScale(hwnd);
			else		   rc = A64TchGetProp_TmScale(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_TmScale@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_TmScale(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_TmScale", ExactSpelling=true)]
		private static extern int A64TchGetProp_TmScale(IntPtr hwnd);

		//----- ●AjcTchSetProp_TmScale ------------------------------------------------------------------------//
		public static void AjcTchSetProp_TmScale(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_TmScale(hwnd, n);
			else		   A64TchSetProp_TmScale(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_TmScale@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_TmScale(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_TmScale", ExactSpelling=true)]
		private static extern void A64TchSetProp_TmScale(IntPtr hwnd, int n);

		//----- ●AjcTchGetProp_MaxBuf -------------------------------------------------------------------------//
		public static int AjcTchGetProp_MaxBuf(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_MaxBuf(hwnd);
			else		   rc = A64TchGetProp_MaxBuf(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_MaxBuf@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_MaxBuf(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_MaxBuf", ExactSpelling=true)]
		private static extern int A64TchGetProp_MaxBuf(IntPtr hwnd);

		//----- ●AjcTchSetProp_MaxBuf -------------------------------------------------------------------------//
		public static void AjcTchSetProp_MaxBuf(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_MaxBuf(hwnd, n);
			else		   A64TchSetProp_MaxBuf(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_MaxBuf@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_MaxBuf(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_MaxBuf", ExactSpelling=true)]
		private static extern void A64TchSetProp_MaxBuf(IntPtr hwnd, int n);

		//----- ●AjcTchGetProp_MaxItem ------------------------------------------------------------------------//
		public static int AjcTchGetProp_MaxItem(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_MaxItem(hwnd);
			else		   rc = A64TchGetProp_MaxItem(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_MaxItem@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_MaxItem(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_MaxItem", ExactSpelling=true)]
		private static extern int A64TchGetProp_MaxItem(IntPtr hwnd);

		//----- ●AjcTchSetProp_MaxItem ------------------------------------------------------------------------//
		public static void AjcTchSetProp_MaxItem(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_MaxItem(hwnd, n);
			else		   A64TchSetProp_MaxItem(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_MaxItem@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_MaxItem(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_MaxItem", ExactSpelling=true)]
		private static extern void A64TchSetProp_MaxItem(IntPtr hwnd, int n);

		//----- ●AjcTchGetProp_AveNum -------------------------------------------------------------------------//
		public static int AjcTchGetProp_AveNum(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_AveNum(hwnd);
			else		   rc = A64TchGetProp_AveNum(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_AveNum@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_AveNum(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_AveNum", ExactSpelling=true)]
		private static extern int A64TchGetProp_AveNum(IntPtr hwnd);

		//----- ●AjcTchSetProp_AveNum -------------------------------------------------------------------------//
		public static void AjcTchSetProp_AveNum(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_AveNum(hwnd, n);
			else		   A64TchSetProp_AveNum(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_AveNum@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_AveNum(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_AveNum", ExactSpelling=true)]
		private static extern void A64TchSetProp_AveNum(IntPtr hwnd, int n);

		//----- ●AjcTchGetProp_ofs ----------------------------------------------------------------------------//
		public static double AjcTchGetProp_ofs(IntPtr hwnd, int ix)
		{
			double	rc;
			if (Is32Bit()) rc = A32TchGetProp_ofs(hwnd, ix);
			else		   rc = A64TchGetProp_ofs(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_ofs@8", ExactSpelling=true)]
		private static extern double A32TchGetProp_ofs(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_ofs", ExactSpelling=true)]
		private static extern double A64TchGetProp_ofs(IntPtr hwnd, int ix);

		//----- ●AjcTchSetProp_ofs ----------------------------------------------------------------------------//
		public static void AjcTchSetProp_ofs(IntPtr hwnd, int ix, double n)
		{
			if (Is32Bit()) A32TchSetProp_ofs(hwnd, ix, n);
			else		   A64TchSetProp_ofs(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_ofs@16", ExactSpelling=true)]
		private static extern void A32TchSetProp_ofs(IntPtr hwnd, int ix, double n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_ofs", ExactSpelling=true)]
		private static extern void A64TchSetProp_ofs(IntPtr hwnd, int ix, double n);

		//----- ●AjcTchGetProp_rgb ----------------------------------------------------------------------------//
		public static int AjcTchGetProp_rgb(IntPtr hwnd, int ix)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_rgb(hwnd, ix);
			else		   rc = A64TchGetProp_rgb(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_rgb@8", ExactSpelling=true)]
		private static extern int A32TchGetProp_rgb(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_rgb", ExactSpelling=true)]
		private static extern int A64TchGetProp_rgb(IntPtr hwnd, int ix);

		//----- ●AjcTchSetProp_rgb ----------------------------------------------------------------------------//
		public static void AjcTchSetProp_rgb(IntPtr hwnd, int ix, int n)
		{
			if (Is32Bit()) A32TchSetProp_rgb(hwnd, ix, n);
			else		   A64TchSetProp_rgb(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_rgb@12", ExactSpelling=true)]
		private static extern void A32TchSetProp_rgb(IntPtr hwnd, int ix, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_rgb", ExactSpelling=true)]
		private static extern void A64TchSetProp_rgb(IntPtr hwnd, int ix, int n);

		//----- ●AjcTchGetProp_IpKnd --------------------------------------------------------------------------//
		public static int AjcTchGetProp_IpKnd(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_IpKnd(hwnd);
			else		   rc = A64TchGetProp_IpKnd(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_IpKnd@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_IpKnd(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_IpKnd", ExactSpelling=true)]
		private static extern int A64TchGetProp_IpKnd(IntPtr hwnd);

		//----- ●AjcTchSetProp_IpKnd --------------------------------------------------------------------------//
		public static void AjcTchSetProp_IpKnd(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_IpKnd(hwnd, n);
			else		   A64TchSetProp_IpKnd(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_IpKnd@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_IpKnd(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_IpKnd", ExactSpelling=true)]
		private static extern void A64TchSetProp_IpKnd(IntPtr hwnd, int n);

		//----- ●AjcTchGetProp_IpNum --------------------------------------------------------------------------//
		public static int AjcTchGetProp_IpNum(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_IpNum(hwnd);
			else		   rc = A64TchGetProp_IpNum(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_IpNum@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_IpNum(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_IpNum", ExactSpelling=true)]
		private static extern int A64TchGetProp_IpNum(IntPtr hwnd);

		//----- ●AjcTchSetProp_IpNum --------------------------------------------------------------------------//
		public static void AjcTchSetProp_IpNum(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_IpNum(hwnd, n);
			else		   A64TchSetProp_IpNum(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_IpNum@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_IpNum(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_IpNum", ExactSpelling=true)]
		private static extern void A64TchSetProp_IpNum(IntPtr hwnd, int n);

		//----- ●AjcTchGetProp_IpWidth ------------------------------------------------------------------------//
		public static int AjcTchGetProp_IpWidth(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32TchGetProp_IpWidth(hwnd);
			else		   rc = A64TchGetProp_IpWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetProp_IpWidth@4", ExactSpelling=true)]
		private static extern int A32TchGetProp_IpWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetProp_IpWidth", ExactSpelling=true)]
		private static extern int A64TchGetProp_IpWidth(IntPtr hwnd);

		//----- ●AjcTchSetProp_IpWidth ------------------------------------------------------------------------//
		public static void AjcTchSetProp_IpWidth(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32TchSetProp_IpWidth(hwnd, n);
			else		   A64TchSetProp_IpWidth(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_IpWidth@8", ExactSpelling=true)]
		private static extern void A32TchSetProp_IpWidth(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_IpWidth", ExactSpelling=true)]
		private static extern void A64TchSetProp_IpWidth(IntPtr hwnd, int n);

		//----- ●AjcTchSetProp_WndSize ------------------------------------------------------------------------//
		public static void AjcTchSetProp_WndSize(IntPtr hwnd, int width, int height)
		{
			if (Is32Bit()) A32TchSetProp_WndSize(hwnd, width, height);
			else		   A64TchSetProp_WndSize(hwnd, width, height);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetProp_WndSize@12", ExactSpelling=true)]
		private static extern void A32TchSetProp_WndSize(IntPtr hwnd, int width, int height);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetProp_WndSize", ExactSpelling=true)]
		private static extern void A64TchSetProp_WndSize(IntPtr hwnd, int width, int height);

		//----- ●AjcTchSetProp_AcceptFiles --------------------------------------------------------------------//
		public static void AjcTchSetProp_AcceptFiles(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32TchSetProp_AcceptFiles(hwnd, fEnable);
			else		   A64TchSetProp_AcceptFiles(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcTchSetProp_AcceptFiles@8", ExactSpelling = true)]
		private static extern void A32TchSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcTchSetProp_AcceptFiles", ExactSpelling = true)]
		private static extern void A64TchSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcTchGetProp_AcceptFiles --------------------------------------------------------------------//
		public static bool AjcTchGetProp_AcceptFiles(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32TchGetProp_AcceptFiles(hwnd);
			else		   rc = A64TchGetProp_AcceptFiles(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcTchGetProp_AcceptFiles@4", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchGetProp_AcceptFiles(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcTchGetProp_AcceptFiles", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchGetProp_AcceptFiles(IntPtr hwnd);

		//----- ●AjcTchSetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcTchSetTipTextForMSIL(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32TchSetTipTextForMSIL(hwnd, pTxt);
			else		   A64TchSetTipTextForMSIL(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetTipTextForMSIL@8", ExactSpelling=true)]
		private static extern void A32TchSetTipTextForMSIL(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64TchSetTipTextForMSIL(IntPtr hwnd, string pTxt);

		//----- ●AjcTchGetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcTchGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32TchGetTipTextForMSIL(hwnd, pBuf, lBuf);
			else		   A64TchGetTipTextForMSIL(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32TchGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64TchGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcTchSetChkBoxTipTextForMSIL ----------------------------------------------------------------//
		public static void AjcTchSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt)
		{
			if (Is32Bit()) A32TchSetChkBoxTipTextForMSIL(hwnd, n, pTxt);
			else		   A64TchSetChkBoxTipTextForMSIL(hwnd, n, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetChkBoxTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32TchSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetChkBoxTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64TchSetChkBoxTipTextForMSIL(IntPtr hwnd, int n, string pTxt);

		//----- ●AjcTchGetChkBoxTipTextForMSIL ----------------------------------------------------------------//
		public static void AjcTchGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32TchGetChkBoxTipTextForMSIL(hwnd, n, pBuf, lBuf);
			else		   A64TchGetChkBoxTipTextForMSIL(hwnd, n, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchGetChkBoxTipTextForMSIL@16", ExactSpelling=true)]
		private static extern void A32TchGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchGetChkBoxTipTextForMSIL", ExactSpelling=true)]
		private static extern void A64TchGetChkBoxTipTextForMSIL(IntPtr hwnd, int n, StringBuilder pBuf, int lBuf);

		//----- ●AjcTchPutData1 -------------------------------------------------------------------------------//
		public static void AjcTchPutData1(IntPtr hwnd, double dat0)
		{
			if (Is32Bit()) A32TchPutData1(hwnd, dat0);
			else		   A64TchPutData1(hwnd, dat0);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData1@12", ExactSpelling=true)]
		private static extern void A32TchPutData1(IntPtr hwnd, double dat0);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData1", ExactSpelling=true)]
		private static extern void A64TchPutData1(IntPtr hwnd,double dat0);

		//----- ●AjcTchPutData2 -------------------------------------------------------------------------------//
		public static void AjcTchPutData2(IntPtr hwnd, double dat0, double dat1)
		{
			if (Is32Bit()) A32TchPutData2(hwnd, dat0, dat1);
			else		   A64TchPutData2(hwnd, dat0, dat1);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData2@20", ExactSpelling=true)]
		private static extern void A32TchPutData2(IntPtr hwnd, double dat0, double dat1);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData2", ExactSpelling=true)]
		private static extern void A64TchPutData2(IntPtr hwnd,double dat0,double dat1);

		//----- ●AjcTchPutData3 -------------------------------------------------------------------------------//
		public static void AjcTchPutData3(IntPtr hwnd, double dat0, double dat1, double dat2)
		{
			if (Is32Bit()) A32TchPutData3(hwnd, dat0, dat1, dat2);
			else		   A64TchPutData3(hwnd, dat0, dat1, dat2);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData3@28", ExactSpelling=true)]
		private static extern void A32TchPutData3(IntPtr hwnd, double dat0, double dat1, double dat2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData3", ExactSpelling=true)]
		private static extern void A64TchPutData3(IntPtr hwnd,double dat0,double dat1,double dat2);

		//----- ●AjcTchPutData4 -------------------------------------------------------------------------------//
		public static void AjcTchPutData4(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3)
		{
			if (Is32Bit()) A32TchPutData4(hwnd, dat0, dat1, dat2, dat3);
			else		   A64TchPutData4(hwnd, dat0, dat1, dat2, dat3);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData4@36", ExactSpelling=true)]
		private static extern void A32TchPutData4(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData4", ExactSpelling=true)]
		private static extern void A64TchPutData4(IntPtr hwnd,double dat0,double dat1,double dat2,double dat3);

		//----- ●AjcTchPutData5 -------------------------------------------------------------------------------//
		public static void AjcTchPutData5(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4)
		{
			if (Is32Bit()) A32TchPutData5(hwnd, dat0, dat1, dat2, dat3, dat4);
			else		   A64TchPutData5(hwnd, dat0, dat1, dat2, dat3, dat4);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData5@44", ExactSpelling=true)]
		private static extern void A32TchPutData5(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData5", ExactSpelling=true)]
		private static extern void A64TchPutData5(IntPtr hwnd,double dat0,double dat1,double dat2,double dat3,double dat4);

		//----- ●AjcTchPutData6 -------------------------------------------------------------------------------//
		public static void AjcTchPutData6(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5)
		{
			if (Is32Bit()) A32TchPutData6(hwnd, dat0, dat1, dat2, dat3, dat4, dat5);
			else		   A64TchPutData6(hwnd, dat0, dat1, dat2, dat3, dat4, dat5);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData6@52", ExactSpelling=true)]
		private static extern void A32TchPutData6(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData6", ExactSpelling=true)]
		private static extern void A64TchPutData6(IntPtr hwnd,double dat0,double dat1,double dat2,double dat3,double dat4,double dat5);

		//----- ●AjcTchPutData7 -------------------------------------------------------------------------------//
		public static void AjcTchPutData7(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6)
		{
			if (Is32Bit()) A32TchPutData7(hwnd, dat0, dat1, dat2, dat3, dat4, dat5, dat6);
			else		   A64TchPutData7(hwnd, dat0, dat1, dat2, dat3, dat4, dat5, dat6);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData7@60", ExactSpelling=true)]
		private static extern void A32TchPutData7(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData7", ExactSpelling=true)]
		private static extern void A64TchPutData7(IntPtr hwnd,double dat0,double dat1,double dat2,double dat3,double dat4,double dat5,double dat6);

		//----- ●AjcTchPutData8 -------------------------------------------------------------------------------//
		public static void AjcTchPutData8(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7)
		{
			if (Is32Bit()) A32TchPutData8(hwnd, dat0, dat1, dat2, dat3, dat4, dat5, dat6, dat7);
			else		   A64TchPutData8(hwnd, dat0, dat1, dat2, dat3, dat4, dat5, dat6, dat7);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchPutData8@68", ExactSpelling=true)]
		private static extern void A32TchPutData8(IntPtr hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchPutData8", ExactSpelling=true)]
		private static extern void A64TchPutData8(IntPtr hwnd,double dat0,double dat1,double dat2,double dat3,double dat4,double dat5,double dat6,double dat7);

		//----- ●AjcTchMesPeriShow -------------------------------------------------------------------------------//
		public static void AjcTchMesPeriShow(IntPtr hwnd, bool fShow)
		{
			if (Is32Bit()) A32TchMesPeriShow(hwnd, fShow);
			else		   A64TchMesPeriShow(hwnd, fShow);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchMesPeriShow@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern void A32TchMesPeriShow(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShow);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchMesPeriShow", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern void A64TchMesPeriShow(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)]bool fShow);

		//----- ●AjcTchMesPeriReset -------------------------------------------------------------------------------//
		public static void AjcTchMesPeriReset(IntPtr hwnd)
		{
			if (Is32Bit()) A32TchMesPeriReset(hwnd);
			else		   A64TchMesPeriReset(hwnd);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchMesPeriReset@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern void A32TchMesPeriReset(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchMesPeriReset", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern void A64TchMesPeriReset(IntPtr hwnd);

		//----- ●AjcTchSetTextFont ----------------------------------------------------------------------------//
		public static IntPtr AjcTchSetTextFont(IntPtr hwnd, IntPtr hFont)
		{
			IntPtr rc;
			if (Is32Bit()) rc = A32TchSetTextFont(hwnd, hFont);
			else		   rc = A64TchSetTextFont(hwnd, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchSetTextFont@8", ExactSpelling=true)]
		private static extern IntPtr A32TchSetTextFont(IntPtr hwnd, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchSetTextFont", ExactSpelling=true)]
		private static extern IntPtr A64TchSetTextFont(IntPtr hwnd, IntPtr hFont);

		//----- ●AjcTchTextOutW -------------------------------------------------------------------------------//
		public static int AjcTchTextOutW(IntPtr hwnd, int x, int y, string pTxt)
		{
			int		rc;
			if (Is32Bit()) rc = A32TchTextOutW(hwnd, x, y, pTxt);
			else		   rc = A64TchTextOutW(hwnd, x, y, pTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchTextOutW@16", ExactSpelling=true)]
		private static extern int A32TchTextOutW(IntPtr hwnd, int x, int y, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchTextOutW", ExactSpelling=true)]
		private static extern int A64TchTextOutW(IntPtr hwnd, int x, int y, string pTxt);

		//----- ●AjcTchClearText ------------------------------------------------------------------------------//
		public static bool AjcTchClearText(IntPtr hwnd, int key)
		{
			bool		rc;
			if (Is32Bit()) rc = A32TchClearText(hwnd, key);
			else		   rc = A64TchClearText(hwnd, key);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchClearText@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchClearText(IntPtr hwnd, int key);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchClearText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchClearText(IntPtr hwnd, int key);

		//----- ●AjcTchClearAllText ---------------------------------------------------------------------------//
		public static bool AjcTchClearAllText(IntPtr hwnd)
		{
			bool		rc;
			if (Is32Bit()) rc = A32TchClearAllText(hwnd);
			else		   rc = A64TchClearAllText(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcTchClearAllText@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32TchClearAllText(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcTchClearAllText", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64TchClearAllText(IntPtr hwnd);

		//======================================================================================================//
		//	AjcCtrlVT100.h																						//
		//======================================================================================================//

		//----- ●AjcVthSetFocus ------------------------------------------------------------------------------//
		public static bool AjcVthSetFocus(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetFocus(hwnd);
			else		   rc = A64VthSetFocus(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetFocus@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetFocus(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetFocus", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetFocus(IntPtr hwnd);

		//----- ●AjcVthSetProp --------------------------------------------------------------------------------//

		//----- ●AjcVthGetVramFitSize -------------------------------------------------------------------------//
		public static bool AjcVthGetVramFitSize(IntPtr hwnd, ref int pWidth, ref int pHeight)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetVramFitSize(hwnd, ref pWidth, ref pHeight);
			else		   rc = A64VthGetVramFitSize(hwnd, ref pWidth, ref pHeight);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetVramFitSize@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetVramFitSize(IntPtr hwnd, ref int pWidth, ref int pHeight);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetVramFitSize", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetVramFitSize(IntPtr hwnd, ref int pWidth, ref int pHeight);

		//----- ●AjcVthPutChar --------------------------------------------------------------------------------//
		public static bool AjcVthPutChar(IntPtr hwnd, byte c)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthPutChar(hwnd, c);
			else		   rc = A64VthPutChar(hwnd, c);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcVthPutChar(IntPtr hwnd, ushort c)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthPutChar(hwnd, c);
			else		   rc = A64VthPutChar(hwnd, c);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthPutCharA@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthPutChar(IntPtr hwnd, byte c);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthPutCharW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthPutChar(IntPtr hwnd, ushort c);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthPutCharA", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthPutChar(IntPtr hwnd, byte c);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthPutCharW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthPutChar(IntPtr hwnd, int c);

		//----- ●AjcVthPutText --------------------------------------------------------------------------------//
		public static bool AjcVthPutText(IntPtr hwnd, string pTxt, int lTxt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthPutText(hwnd, pTxt, lTxt);
			else		   rc = A64VthPutText(hwnd, pTxt, lTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthPutTextW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthPutText(IntPtr hwnd, string pTxt, int lTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthPutTextW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthPutText(IntPtr hwnd, string pTxt, int lTxt);

		//----- ●AjcVthTimeStamp ------------------------------------------------------------------------------//
		public static bool AjcVthTimeStamp(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthTimeStamp(hwnd);
			else		   rc = A64VthTimeStamp(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthTimeStamp@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthTimeStamp(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthTimeStamp", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthTimeStamp(IntPtr hwnd);

		//----- ●AjcVthHexDump --------------------------------------------------------------------------------//
		unsafe public static bool AjcVthHexDump(IntPtr hwnd, Byte[] bin)
		{
			bool	rc;
			fixed (void* p = &bin[0]) {
				if (Is32Bit()) rc = A32VthHexDump(hwnd, p, bin.Length);
				else		   rc = A64VthHexDump(hwnd, p, bin.Length);
			}
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcVthHexDump(IntPtr hwnd, void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthHexDump(hwnd, p, len);
			else		   rc = A64VthHexDump(hwnd, p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcVthHexDump(IntPtr hwnd, IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthHexDump(hwnd, p, len);
			else		   rc = A64VthHexDump(hwnd, p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthHexDump@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32VthHexDump(IntPtr hwnd, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthHexDump@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32VthHexDump(IntPtr hwnd, IntPtr p, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthHexDump", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64VthHexDump(IntPtr hwnd, void* p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthHexDump", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64VthHexDump(IntPtr hwnd, IntPtr p, int len);

		//----- ●AjcVthLocate ---------------------------------------------------------------------------------//
		public static bool AjcVthLocate(IntPtr hwnd, int line, int col)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthLocate(hwnd, line, col);
			else		   rc = A64VthLocate(hwnd, line, col);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthLocate@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthLocate(IntPtr hwnd, int line, int col);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthLocate", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthLocate(IntPtr hwnd, int line, int col);

		//----- ●AjcVthSetColor -------------------------------------------------------------------------------//
		public static bool AjcVthSetColor(IntPtr hwnd, int PaletteNo)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetColor(hwnd, PaletteNo);
			else		   rc = A64VthSetColor(hwnd, PaletteNo);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetColor@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetColor(IntPtr hwnd, int PaletteNo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetColor", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetColor(IntPtr hwnd, int PaletteNo);

		//----- ●AjcVthSetBkColor -----------------------------------------------------------------------------//
		public static bool AjcVthSetBkColor(IntPtr hwnd, int PaletteNo)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetBkColor(hwnd, PaletteNo);
			else		   rc = A64VthSetBkColor(hwnd, PaletteNo);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetBkColor@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetBkColor(IntPtr hwnd, int PaletteNo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetBkColor", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetBkColor(IntPtr hwnd, int PaletteNo);

		//----- ●AjcVthSetWndBkColor --------------------------------------------------------------------------//
		public static bool AjcVthSetWndBkColor(IntPtr hwnd, int PaletteNo)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetWndBkColor(hwnd, PaletteNo);
			else		   rc = A64VthSetWndBkColor(hwnd, PaletteNo);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetWndBkColor@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetWndBkColor(IntPtr hwnd, int PaletteNo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetWndBkColor", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetWndBkColor(IntPtr hwnd, int PaletteNo);

		//----- ●AjcVthSetPalette -----------------------------------------------------------------------------//

		//----- ●AjcVthGetCursorPos ---------------------------------------------------------------------------//
		public static int AjcVthGetCursorPos(IntPtr hwnd, ref int pLine, ref int pCol)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetCursorPos(hwnd, ref pLine, ref pCol);
			else		   rc = A64VthGetCursorPos(hwnd, ref pLine, ref pCol);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetCursorPos@12", ExactSpelling=true)]
		private static extern int A32VthGetCursorPos(IntPtr hwnd, ref int pLine, ref int pCol);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetCursorPos", ExactSpelling = true)]
		private static extern int A64VthGetCursorPos(IntPtr hwnd, ref int pLine, ref int pCol);

		//----- ●AjcVthGetColor -------------------------------------------------------------------------------//
		public static int AjcVthGetColor(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetColor(hwnd);
			else		   rc = A64VthGetColor(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetColor@4", ExactSpelling=true)]
		private static extern int A32VthGetColor(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetColor", ExactSpelling = true)]
		private static extern int A64VthGetColor(IntPtr hwnd);

		//----- ●AjcVthGetBkColor -----------------------------------------------------------------------------//
		public static int AjcVthGetBkColor(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetBkColor(hwnd);
			else		   rc = A64VthGetBkColor(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetBkColor@4", ExactSpelling=true)]
		private static extern int A32VthGetBkColor(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetBkColor", ExactSpelling = true)]
		private static extern int A64VthGetBkColor(IntPtr hwnd);

		//----- ●AjcVthGetWndBkColor --------------------------------------------------------------------------//
		public static int AjcVthGetWndBkColor(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetWndBkColor(hwnd);
			else		   rc = A64VthGetWndBkColor(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetWndBkColor@4", ExactSpelling=true)]
		private static extern int A32VthGetWndBkColor(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetWndBkColor", ExactSpelling = true)]
		private static extern int A64VthGetWndBkColor(IntPtr hwnd);

		//----- ●AjcVthSelect ---------------------------------------------------------------------------------//
		public static bool AjcVthSelect(IntPtr hwnd, int slp, int scp, int elp, int ecp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSelect(hwnd, slp, scp, elp, ecp);
			else		   rc = A64VthSelect(hwnd, slp, scp, elp, ecp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSelect@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSelect(IntPtr hwnd, int slp, int scp, int elp, int ecp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSelect", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSelect(IntPtr hwnd, int slp, int scp, int elp, int ecp);

		//----- ●AjcVthSelectAll ------------------------------------------------------------------------------//
		public static bool AjcVthSelectAll(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSelectAll(hwnd);
			else		   rc = A64VthSelectAll(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSelectAll@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSelectAll(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSelectAll", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSelectAll(IntPtr hwnd);

		//----- ●AjcVthCopyText -------------------------------------------------------------------------------//
		public static bool AjcVthCopyText(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthCopyText(hwnd);
			else		   rc = A64VthCopyText(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthCopyText@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthCopyText(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthCopyText", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthCopyText(IntPtr hwnd);

		//----- ●AjcVthSetFont --------------------------------------------------------------------------------//
		public static bool AjcVthSetFont(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetFont(hwnd);
			else		   rc = A64VthSetFont(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetFont@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetFont(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetFont", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetFont(IntPtr hwnd);

		//----- ●AjcVthFontDialog -----------------------------------------------------------------------------//

		//----- ●AjcVthShowCaret ------------------------------------------------------------------------------//
		public static bool AjcVthShowCaret(IntPtr hwnd, bool fShow)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthShowCaret(hwnd, fShow);
			else		   rc = A64VthShowCaret(hwnd, fShow);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthShowCaret@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthShowCaret(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShow);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthShowCaret", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthShowCaret(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShow);

		//----- ●AjcVthClearAllText ---------------------------------------------------------------------------//
		public static bool AjcVthClearAllText(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthClearAllText(hwnd);
			else		   rc = A64VthClearAllText(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthClearAllText@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthClearAllText(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthClearAllText", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthClearAllText(IntPtr hwnd);

		//----- ●AjcVthGetDroppedFile -------------------------------------------------------------------------//
		public static string AjcVthGetDroppedFile(IntPtr hwnd)
		{
			string	rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32VthGetDroppedFile(hwnd, s)) rc = s.ToString();
				else											rc = "";
			}
			else {
				if (A64VthGetDroppedFile(hwnd, s)) rc = s.ToString();
				else											rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetDroppedFileW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetDroppedFile(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetDroppedFileW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetDroppedFile(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcVthGetDroppedDir --------------------------------------------------------------------------//
		public static string AjcVthGetDroppedDir(IntPtr hwnd)
		{
			string		rc;
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) {
				if (A32VthGetDroppedDir(hwnd, s)) rc = s.ToString();
				else										   rc = "";
			}
			else {
				if (A64VthGetDroppedDir(hwnd, s)) rc = s.ToString();
				else										   rc = "";
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetDroppedDirW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetDroppedDir(IntPtr hwnd, StringBuilder buf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetDroppedDirW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetDroppedDir(IntPtr hwnd, StringBuilder buf);

		//----- ●AjcVthGetDroppedDirEx ------------------------------------------------------------------------//

		//----- ●AjcVthLoadProp -------------------------------------------------------------------------------//
		public static bool AjcVthLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthLoadProp(hwnd, pProfileSect, pDefProp);
			else		   rc = A64VthLoadProp(hwnd, pProfileSect, pDefProp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthLoadPropW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthLoadPropW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthLoadProp(IntPtr hwnd, string pProfileSect, IntPtr pDefProp);

		//----- ●AjcVthSaveProp -------------------------------------------------------------------------------//
		public static bool AjcVthSaveProp(IntPtr hwnd, string pProfileSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSaveProp(hwnd, pProfileSect);
			else		   rc = A64VthSaveProp(hwnd, pProfileSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSavePropW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSaveProp(IntPtr hwnd, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSavePropW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSaveProp(IntPtr hwnd, string pProfileSect);

		//----- ●AjcVthLoadPermInfo -------------------------------------------------------------------------------//
		public static bool AjcVthLoadPermInfo(IntPtr hwnd, string pProfileSect, string pKeyPrefix)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthLoadPermInfo(hwnd, pProfileSect, pKeyPrefix);
			else		   rc = A64VthLoadPermInfo(hwnd, pProfileSect, pKeyPrefix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthLoadPermInfoW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthLoadPermInfo(IntPtr hwnd, string pProfileSect, string pKeyPrefix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthLoadPermInfoW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthLoadPermInfo(IntPtr hwnd, string pProfileSect, string pKeyPrefix);

		//----- ●AjcVthSavePermInfo ---------------------------------------------------------------------------//
		public static bool AjcVthSavePermInfo(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSaveFont(hwnd);
			else		   rc = A64VthSaveFont(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSavePermInfo@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSaveFont(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSavePermInfo", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSaveFont(IntPtr hwnd);

		//----- ●AjcVthEnablePopupMenu ------------------------------------------------------------------------//
		public static void AjcVthEnablePopupMenu(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32VthEnablePopupMenu(hwnd, fEnable);
			else		   A64VthEnablePopupMenu(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthEnablePopupMenu@8", ExactSpelling=true)]
		private static extern void A32VthEnablePopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthEnablePopupMenu", ExactSpelling = true)]
		private static extern void A64VthEnablePopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcVthSetNtcRClk -----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetNtcRClk@16", ExactSpelling=true)]
		private static extern void A32VthSetNtcRClk(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fNtcRClk, int MsgRBDown, int MsgRBUp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetNtcRClk", ExactSpelling = true)]
		private static extern void A64VthSetNtcRClk(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fNtcRClk, int MsgRBDown, int MsgRBUp);

		//----- ●AjcVthGetSelectedText ------------------------------------------------------------------------//
		public static int AjcVthGetSelectedText(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetSelectedText(hwnd, pBuf, lBuf);
			else		   rc = A64VthGetSelectedText(hwnd, pBuf, lBuf);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSelectedTextW@12", ExactSpelling=true)]
		private static extern int A32VthGetSelectedText(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSelectedTextW", ExactSpelling = true)]
		private static extern int A64VthGetSelectedText(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcVthGetDblClickedLine ----------------------------------------------------------------------//
		public static int AjcVthGetDblClickedLine(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetDblClickedLine(hwnd, pBuf, lBuf);
			else		   rc = A64VthGetDblClickedLine(hwnd, pBuf, lBuf);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static int AjcVthGetDblClickedLine(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetDblClickedLine(hwnd, (IntPtr)0, (int)0);
			else		   rc = A64VthGetDblClickedLine(hwnd, (IntPtr)0, (int)0);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetDblClickedLineW@12", ExactSpelling=true)]
		private static extern int A32VthGetDblClickedLine(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetDblClickedLineW@12", ExactSpelling=true)]
		private static extern int A32VthGetDblClickedLine(IntPtr hwnd, IntPtr pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetDblClickedLineW", ExactSpelling = true)]
		private static extern int A64VthGetDblClickedLine(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetDblClickedLineW", ExactSpelling = true)]
		private static extern int A64VthGetDblClickedLine(IntPtr hwnd, IntPtr pBuf, int lBuf);

		//----- ●AjcVthGetDblClickedLineEx --------------------------------------------------------------------//
		public static int AjcVthGetDblClickedLineEx(IntPtr hwnd, StringBuilder pBuf, int lBuf, out int line, out int pos)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetDblClickedLineEx(hwnd, pBuf, lBuf, out line, out pos);
			else		   rc = A64VthGetDblClickedLineEx(hwnd, pBuf, lBuf, out line, out pos);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static int AjcVthGetDblClickedLineEx(IntPtr hwnd, out int line, out int pos)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetDblClickedLineEx(hwnd, (IntPtr)0, 0, out line, out pos);
			else		   rc = A64VthGetDblClickedLineEx(hwnd, (IntPtr)0, 0, out line, out pos);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetDblClickedLineExW@20", ExactSpelling=true)]
		private static extern int A32VthGetDblClickedLineEx(IntPtr hwnd, StringBuilder pBuf, int lBuf, out int line, out int pos);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetDblClickedLineExW@20", ExactSpelling=true)]
		private static extern int A32VthGetDblClickedLineEx(IntPtr hwnd, IntPtr pBuf		, int lBuf, out int line, out int pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetDblClickedLineExW", ExactSpelling=true)]
		private static extern int A64VthGetDblClickedLineEx(IntPtr hwnd, StringBuilder pBuf, int lBuf, out int line, out int pos);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetDblClickedLineExW", ExactSpelling=true)]
		private static extern int A64VthGetDblClickedLineEx(IntPtr hwnd, IntPtr pBuf		, int lBuf, out int line, out int pos);

		//----- ●AjcVthSetTipText -----------------------------------------------------------------------------//
		public static void AjcVthSetTipText(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32VthSetTipText(hwnd, pTxt);
			else		   A64VthSetTipText(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetTipTextW@8", ExactSpelling=true)]
		private static extern void A32VthSetTipText(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetTipTextW", ExactSpelling = true)]
		private static extern void A64VthSetTipText(IntPtr hwnd, string pTxt);

		//----- ●AjcVthGetTipText -----------------------------------------------------------------------------//
		public static void AjcVthGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32VthGetTipText(hwnd, pBuf, lBuf);
			else		   A64VthGetTipText(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetTipTextW@12", ExactSpelling=true)]
		private static extern void A32VthGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetTipTextW", ExactSpelling = true)]
		private static extern void A64VthGetTipText(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcVthSetTipShowAlways ----------------------------------------------------------------------//
		public static void AjcVthSetTipShowAlways(IntPtr hwnd, bool fShowAlways)
		{
			if (Is32Bit()) A32VthSetTipShowAlways(hwnd, fShowAlways);
			else		   A64VthSetTipShowAlways(hwnd, fShowAlways);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetTipShowAlways@8", ExactSpelling=true)]
		private static extern void A32VthSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShowAlways);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetTipShowAlways", ExactSpelling = true)]
		private static extern void A64VthSetTipShowAlways(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fShowAlways);

		//----- ●AjcVthGetCharInfo ----------------------------------------------------------------------------//

		//----- ●AjcVthGetLinesPerWindow ----------------------------------------------------------------------//
		public static int AjcVthGetLinesPerWindow(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetLinesPerWindow(hwnd);
			else		   rc = A64VthGetLinesPerWindow(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetLinesPerWindow@4", ExactSpelling=true)]
		private static extern int A32VthGetLinesPerWindow(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetLinesPerWindow", ExactSpelling = true)]
		private static extern int A64VthGetLinesPerWindow(IntPtr hwnd);

		//----- ●AjcVthGetValidLines --------------------------------------------------------------------------//
		public static int AjcVthGetValidLines(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetValidLines(hwnd);
			else		   rc = A64VthGetValidLines(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetValidLines@4", ExactSpelling=true)]
		private static extern int A32VthGetValidLines(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetValidLines", ExactSpelling = true)]
		private static extern int A64VthGetValidLines(IntPtr hwnd);

		//----- ●AjcVthGetIxOfWndTopLine ----------------------------------------------------------------------//
		public static int AjcVthGetIxOfWndTopLine(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetIxOfWndTopLine(hwnd);
			else		   rc = A64VthGetIxOfWndTopLine(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetIxOfWndTopLine@4", ExactSpelling=true)]
		private static extern int A32VthGetIxOfWndTopLine(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetIxOfWndTopLine", ExactSpelling = true)]
		private static extern int A64VthGetIxOfWndTopLine(IntPtr hwnd);

		//----- ●AjcVthSetTitleText ---------------------------------------------------------------------------//
		public static bool AjcVthSetTitleText(IntPtr hwnd, string Text, Color TextColor, Color BackColor, Font TextFont)
		{
			bool	rc;
			int 	TxtCol = TextColor == Color.Empty ? -1 : (TextColor.B << 16 | TextColor.G << 8 | TextColor.R);
			int 	BakCol = BackColor == Color.Empty ? -1 : (BackColor.B << 16 | BackColor.G << 8 | BackColor.R);
			IntPtr	hFont  = TextFont  == null ?  (IntPtr)0 : TextFont.ToHfont();
			if (Is32Bit()) rc = A32VthSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			else		   rc = A64VthSetTitleText(hwnd, Text, TxtCol, BakCol, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetTitleTextW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetTitleTextW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetTitleText(IntPtr hwnd, string Text, int TextColor, int BackColor, IntPtr hFont);

		//----- ●AjcVthSaveTextToFile -------------------------------------------------------------------------//

		//----- ●AjcVthSaveHtmlToFile -------------------------------------------------------------------------//

		//----- ●AjcVthGetLineCount ---------------------------------------------------------------------------//
		public static int AjcVthGetLineCount(IntPtr hwnd)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthGetLineCount(hwnd);
			else		   rc = A64VthGetLineCount(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetLineCount@4", ExactSpelling=true)]
		private static extern int A32VthGetLineCount(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetLineCount", ExactSpelling=true)]
		private static extern int A64VthGetLineCount(IntPtr hwnd);

		//----- ●AjcVthGetCursorPosInfo -----------------------------------------------------------------------//
		public static bool AjcVthGetCursorPosInfo(IntPtr hwnd, out int line, out int pos)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetCursorPosInfo(hwnd, out line, out pos);
			else		   rc = A64VthGetCursorPosInfo(hwnd, out line, out pos);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetCursorPosInfo@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetCursorPosInfo(IntPtr hwnd, out int line, out int col);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetCursorPosInfo", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetCursorPosInfo(IntPtr hwnd, out int line, out int col);

		//----- ●AjcVthGetLineText ----------------------------------------------------------------------------//
		public static bool AjcVthGetLineText(IntPtr hwnd, int pos, StringBuilder pBuf, int lBuf)
		{
			bool		rc;
			if (Is32Bit()) rc = A32VthGetLineText(hwnd, pos, pBuf, lBuf);
			else		   rc = A64VthGetLineText(hwnd, pos, pBuf, lBuf);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetLineTextW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetLineText(IntPtr hwnd, int pos, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint="AjcVthGetLineTextW", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetLineText(IntPtr hwnd, int pos, StringBuilder pBuf, int lBuf);

		//----- ●AjcVthGetVScrollPos --------------------------------------------------------------------------//
		public static int AjcVthGetVScrollPos(IntPtr hwnd)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthGetVScrollPos(hwnd);
			else		   rc = A64VthGetVScrollPos(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetVScrollPos@4", ExactSpelling=true)]
		private static extern int A32VthGetVScrollPos(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetVScrollPos", ExactSpelling=true)]
		private static extern int A64VthGetVScrollPos(IntPtr hwnd);

		//----- ●AjcVthGetHScrollPos --------------------------------------------------------------------------//
		public static int AjcVthGetHScrollPos(IntPtr hwnd)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthGetHScrollPos(hwnd);
			else		   rc = A64VthGetHScrollPos(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetHScrollPos@4", ExactSpelling=true)]
		private static extern int A32VthGetHScrollPos(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetHScrollPos", ExactSpelling=true)]
		private static extern int A64VthGetHScrollPos(IntPtr hwnd);

		//----- ●AjcVthSetVScrollPos --------------------------------------------------------------------------//
		public static bool AjcVthSetVScrollPos(IntPtr hwnd, int pos)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetVScrollPos(hwnd, pos);
			else		   rc = A64VthSetVScrollPos(hwnd, pos);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetVScrollPos@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetVScrollPos(IntPtr hwnd, int pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetVScrollPos", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetVScrollPos(IntPtr hwnd, int pos);

		//----- ●AjcVthSetHScrollPos --------------------------------------------------------------------------//
		public static bool AjcVthSetHScrollPos(IntPtr hwnd, int pos)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetHScrollPos(hwnd, pos);
			else		   rc = A64VthSetHScrollPos(hwnd, pos);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetHScrollPos@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetHScrollPos(IntPtr hwnd, int pos);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetHScrollPos", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetHScrollPos(IntPtr hwnd, int pos);

		//----- ●AjcVthGetWindowSize --------------------------------------------------------------------------//

		//----- ●AjcVthSetFindProfileSectW --------------------------------------------------------------------//
		public static void AjcVthSetFindProfileSectW(IntPtr hwnd, string sect)
		{
			if (Is32Bit()) A32VthSetFindProfileSectW(hwnd, sect);
			else		   A64VthSetFindProfileSectW(hwnd, sect);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetFindProfileSectW@8", ExactSpelling=true)]
		private static extern void A32VthSetFindProfileSectW(IntPtr hwnd, string sect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetFindProfileSectW", ExactSpelling=true)]
		private static extern void A64VthSetFindProfileSectW(IntPtr hwnd, string sect);

		//----- ●AjcVthSetFindKey -----------------------------------------------------------------------------//
		public static void AjcVthSetFindKey(IntPtr hwnd, Keys key)
		{
			if (Is32Bit()) A32AjcVthSetFindKey(hwnd, key);
			else		   A64AjcVthSetFindKey(hwnd, key);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetFindKey@8", ExactSpelling=true)]
		private static extern void A32AjcVthSetFindKey(IntPtr hwnd, Keys key);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetFindKey", ExactSpelling=true)]
		private static extern void A64AjcVthSetFindKey(IntPtr hwnd, Keys key);

		//----- ●AjcVthSearchBelow ----------------------------------------------------------------------------//
		public static int AjcVthSearchBelow(IntPtr hwnd, string str, int delimiter)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthSearchBelow(hwnd, str, delimiter);
			else		   rc = A64VthSearchBelow(hwnd, str, delimiter);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSearchBelowW@12", ExactSpelling=true)]
		private static extern int A32VthSearchBelow(IntPtr hwnd, string str, int delimiter);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSearchBelowW", ExactSpelling=true)]
		private static extern int A64VthSearchBelow(IntPtr hwnd, string str, int delimiter);

		//----- ●AjcVthSearchBelowEx ----------------------------------------------------------------------------//
		public static int AjcVthSearchBelowEx(IntPtr hwnd, string str, string dlm, string any, bool fTrim, bool fIgnoreWidth)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthSearchBelow(hwnd, str, dlm, any, fTrim, fIgnoreWidth);
			else		   rc = A64VthSearchBelow(hwnd, str, dlm, any, fTrim, fIgnoreWidth);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSearchBelowExW@24", ExactSpelling=true)]
		private static extern int A32VthSearchBelow(IntPtr hwnd, string str, string dlm, string any, [MarshalAs(UnmanagedType.Bool)] bool fTrim, [MarshalAs(UnmanagedType.Bool)] bool fIgnoreWidth);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSearchBelowExW", ExactSpelling=true)]
		private static extern int A64VthSearchBelow(IntPtr hwnd, string str, string dlm, string any, [MarshalAs(UnmanagedType.Bool)] bool fTrim, [MarshalAs(UnmanagedType.Bool)] bool fIgnoreWidth);

		//----- ●AjcVthSearchAbove ----------------------------------------------------------------------------//
		public static int AjcVthSearchAbove(IntPtr hwnd, string str, int delimiter)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthSearchAbove(hwnd, str, delimiter);
			else		   rc = A64VthSearchAbove(hwnd, str, delimiter);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSearchAboveW@12", ExactSpelling=true)]
		private static extern int A32VthSearchAbove(IntPtr hwnd, string str, int delimiter);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSearchAboveW", ExactSpelling=true)]
		private static extern int A64VthSearchAbove(IntPtr hwnd, string str, int delimiter);

		//----- ●AjcVthSearchAboveEx ----------------------------------------------------------------------------//
		public static int AjcVthSearchAboveEx(IntPtr hwnd, string str, string dlm, string any, bool fTrim, bool fIgnoreWidth)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthSearchAbove(hwnd, str, dlm, any, fTrim, fIgnoreWidth);
			else		   rc = A64VthSearchAbove(hwnd, str, dlm, any, fTrim, fIgnoreWidth);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSearchAboveExW@24", ExactSpelling=true)]
		private static extern int A32VthSearchAbove(IntPtr hwnd, string str, string dlm, string any, [MarshalAs(UnmanagedType.Bool)] bool fTrim, [MarshalAs(UnmanagedType.Bool)] bool fIgnoreWidth);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSearchAboveExW", ExactSpelling=true)]
		private static extern int A64VthSearchAbove(IntPtr hwnd, string str, string dlm, string any, [MarshalAs(UnmanagedType.Bool)] bool fTrim, [MarshalAs(UnmanagedType.Bool)] bool fIgnoreWidth);

		//----- ●AjcVthPause ----------------------------------------------------------------------------------//
		public static void AjcVthPause(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthPause(hwnd, f);
			else		   A64VthPause(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthPause@8", ExactSpelling=true)]
		private static extern void A32VthPause(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthPause", ExactSpelling=true)]
		private static extern void A64VthPause(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthSetLFActInPopupMenu --------------------------------------------------------------------//
		public static void AjcVthSetLFActInPopupMenu(IntPtr hwnd, bool flag)
		{
			if (Is32Bit()) A32VthSetLFActInPopupMenu(hwnd, flag);
			else		   A64VthSetLFActInPopupMenu(hwnd, flag);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetLFActInPopupMenu@8", ExactSpelling=true)]
		private static extern void A32VthSetLFActInPopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetLFActInPopupMenu", ExactSpelling=true)]
		private static extern void A64VthSetLFActInPopupMenu(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetLFActInPopupMenu --------------------------------------------------------------------//
		public static bool AjcVthGetLFActInPopupMenu(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetLFActInPopupMenu(hwnd);
			else		   rc = A64VthGetLFActInPopupMenu(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetLFActInPopupMenu@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetLFActInPopupMenu(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetLFActInPopupMenu", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetLFActInPopupMenu(IntPtr hwnd);

		//----- ●AjcVthCreateForMSIL --------------------------------------------------------------------------//
		public static IntPtr AjcVthCreateForMSIL(IntPtr hOwner, VthCbkNtcDblClk  CbkNtcDblClk ,
																VthCbkNtcKeyIn	 CbkNtcKeyIn  ,
																VthCbkNtcVKeyIn  CbkNtcVKeyIn ,
																VthCbkNtcVKeyOut CbkNtcVKeyOut,
																VthCbkFileDrop	 CbkFileDrop  ,
																VthCbkDirDrop	 CbkDirDrop	 ,
																VthCbkCharInfo	 CbkCharInfo  ,
																VthCbkRClick	 CbkRClick	 )
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32VthCreateForMSIL(hOwner, CbkNtcDblClk , 
															CbkNtcKeyIn  ,
															CbkNtcVKeyIn ,
															CbkNtcVKeyOut,
															CbkFileDrop  ,
															CbkDirDrop	 ,
															CbkCharInfo  ,
															CbkRClick	 );
			else		   rc = A64VthCreateForMSIL(hOwner, CbkNtcDblClk , 
															CbkNtcKeyIn  ,
															CbkNtcVKeyIn ,
															CbkNtcVKeyOut,
															CbkFileDrop  ,
															CbkDirDrop	 ,
															CbkCharInfo  ,
															CbkRClick	 );
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthCreateForMSIL@36", ExactSpelling=true)]
		private static extern IntPtr A32VthCreateForMSIL(IntPtr hOwner, VthCbkNtcDblClk  cbNtcDblClk ,
																		VthCbkNtcKeyIn	 cbNtcKeyIn	,
																		VthCbkNtcVKeyIn  cbNtcVKeyIn ,
																		VthCbkNtcVKeyOut cbNtcVKeyOut,
																		VthCbkFileDrop	 cbFileDrop	,
																		VthCbkDirDrop	 cbDirDrop	,
																		VthCbkCharInfo	 cbCharInfo	,
																		VthCbkRClick	 cbRClick	);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthCreateForMSIL", ExactSpelling = true)]
		private static extern IntPtr A64VthCreateForMSIL(IntPtr hOwner, VthCbkNtcDblClk  cbNtcDblClk ,
																		VthCbkNtcKeyIn	 cbNtcKeyIn	,
																		VthCbkNtcVKeyIn  cbNtcVKeyIn ,
																		VthCbkNtcVKeyOut cbNtcVKeyOut,
																		VthCbkFileDrop	 cbFileDrop	,
																		VthCbkDirDrop	 cbDirDrop	,
																		VthCbkCharInfo	 cbCharInfo	,
																		VthCbkRClick	 cbRClick	);

		//----- ●AjcVthGetSty_LOGFILE -------------------------------------------------------------------------//
		public static bool AjcVthGetSty_LOGFILE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_LOGFILE(hwnd);
			else		   rc = A64VthGetSty_LOGFILE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_LOGFILE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_LOGFILE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_LOGFILE", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_LOGFILE(IntPtr hwnd);

		//----- ●AjcVthSetSty_LOGFILE -------------------------------------------------------------------------//
		public static void AjcVthSetSty_LOGFILE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_LOGFILE(hwnd, f);
			else		   A64VthSetSty_LOGFILE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_LOGFILE@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_LOGFILE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_LOGFILE", ExactSpelling = true)]
		private static extern void A64VthSetSty_LOGFILE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthSetSty_FIXEDPITCH ------------------------------------------------------------------------//
		public static void AjcVthSetSty_FIXEDPITCH(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_FIXEDPITCH(hwnd, f);
			else		   A64VthSetSty_FIXEDPITCH(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_FIXEDPITCH@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_FIXEDPITCH(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_FIXEDPITCH", ExactSpelling = true)]
		private static extern void A64VthSetSty_FIXEDPITCH(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_FIXEDPITCH ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_FIXEDPITCH(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_FIXEDPITCH(hwnd);
			else		   rc = A64VthGetSty_FIXEDPITCH(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_FIXEDPITCH@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_FIXEDPITCH(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_FIXEDPITCH", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_FIXEDPITCH(IntPtr hwnd);

		//----- ●AjcVthSetSty_FAST ---------------------------------------------------------------------------//
		public static void AjcVthSetSty_FAST(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_FAST(hwnd, f);
			else		   A64VthSetSty_FAST(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_FAST@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_FAST(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_FAST", ExactSpelling = true)]
		private static extern void A64VthSetSty_FAST(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_FAST ---------------------------------------------------------------------------//
		public static bool AjcVthGetSty_FAST(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_FAST(hwnd);
			else		   rc = A64VthGetSty_FAST(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_FAST@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_FAST(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_FAST", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_FAST(IntPtr hwnd);

		//----- ●AjcVthSetSty_NOCLSBTN ---------------------------------------------------------------------------//
		public static void AjcVthSetSty_NOCLSBTN(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_NOCLSBTN(hwnd, f);
			else		   A64VthSetSty_NOCLSBTN(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_NOCLSBTN@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_NOCLSBTN(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_NOCLSBTN", ExactSpelling = true)]
		private static extern void A64VthSetSty_NOCLSBTN(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_NOCLSBTN ---------------------------------------------------------------------------//
		public static bool AjcVthGetSty_NOCLSBTN(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_NOCLSBTN(hwnd);
			else		   rc = A64VthGetSty_NOCLSBTN(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_NOCLSBTN@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_NOCLSBTN(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_NOCLSBTN", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_NOCLSBTN(IntPtr hwnd);

		//----- ●AjcVthSetSty_FIXEDFONT ------------------------------------------------------------------------//
		public static void AjcVthSetSty_FIXEDFONT(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_FIXEDFONT(hwnd, f);
			else		   A64VthSetSty_FIXEDFONT(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_FIXEDFONT@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_FIXEDFONT(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_FIXEDFONT", ExactSpelling = true)]
		private static extern void A64VthSetSty_FIXEDFONT(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_FIXEDFONT ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_FIXEDFONT(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_FIXEDFONT(hwnd);
			else		   rc = A64VthGetSty_FIXEDFONT(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_FIXEDFONT@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_FIXEDFONT(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_FIXEDFONT", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_FIXEDFONT(IntPtr hwnd);

		//----- ●AjcVthSetSty_FIXEDLF ------------------------------------------------------------------------//
		public static void AjcVthSetSty_FIXEDLF(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_FIXEDLF(hwnd, f);
			else		   A64VthSetSty_FIXEDLF(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_FIXEDLF@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_FIXEDLF(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_FIXEDLF", ExactSpelling = true)]
		private static extern void A64VthSetSty_FIXEDLF(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_FIXEDLF ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_FIXEDLF(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_FIXEDLF(hwnd);
			else		   rc = A64VthGetSty_FIXEDLF(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_FIXEDLF@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_FIXEDLF(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_FIXEDLF", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_FIXEDLF(IntPtr hwnd);

		//----- ●AjcVthSetSty_NOVSCROLL ------------------------------------------------------------------------//
		public static void AjcVthSetSty_NOVSCROLL(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_NOVSCROLL(hwnd, f);
			else		   A64VthSetSty_NOVSCROLL(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_NOVSCROLL@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_NOVSCROLL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_NOVSCROLL", ExactSpelling = true)]
		private static extern void A64VthSetSty_NOVSCROLL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_NOVSCROLL ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_NOVSCROLL(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_NOVSCROLL(hwnd);
			else		   rc = A64VthGetSty_NOVSCROLL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_NOVSCROLL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_NOVSCROLL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_NOVSCROLL", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_NOVSCROLL(IntPtr hwnd);

		//----- ●AjcVthSetSty_NOHSCROLL ------------------------------------------------------------------------//
		public static void AjcVthSetSty_NOHSCROLL(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_NOHSCROLL(hwnd, f);
			else		   A64VthSetSty_NOHSCROLL(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_NOHSCROLL@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_NOHSCROLL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_NOHSCROLL", ExactSpelling = true)]
		private static extern void A64VthSetSty_NOHSCROLL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_NOHSCROLL ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_NOHSCROLL(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_NOHSCROLL(hwnd);
			else		   rc = A64VthGetSty_NOHSCROLL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_NOHSCROLL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_NOHSCROLL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_NOHSCROLL", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_NOHSCROLL(IntPtr hwnd);

		//----- ●AjcVthGetSty_NOSCRL --------------------------------------------------------------------------//
		public static bool AjcVthGetSty_NOSCRL(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_NOSCRL(hwnd);
			else		   rc = A64VthGetSty_NOSCRL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_NOSCRL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_NOSCRL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_NOSCRL", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_NOSCRL(IntPtr hwnd);

		//----- ●AjcVthSetSty_NOSCRL --------------------------------------------------------------------------//
		public static void AjcVthSetSty_NOSCRL(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_NOSCRL(hwnd, f);
			else		   A64VthSetSty_NOSCRL(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_NOSCRL@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_NOSCRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_NOSCRL", ExactSpelling = true)]
		private static extern void A64VthSetSty_NOSCRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_NOBORDER ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_NOBORDER(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_NOBORDER(hwnd);
			else		   rc = A64VthGetSty_NOBORDER(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_NOBORDER@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_NOBORDER(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_NOBORDER", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_NOBORDER(IntPtr hwnd);

		//----- ●AjcVthSetSty_NOBORDER ------------------------------------------------------------------------//
		public static void AjcVthSetSty_NOBORDER(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_NOBORDER(hwnd, f);
			else		   A64VthSetSty_NOBORDER(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_NOBORDER@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_NOBORDER", ExactSpelling = true)]
		private static extern void A64VthSetSty_NOBORDER(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_NOSCRLOUT -----------------------------------------------------------------------//
		public static bool AjcVthGetSty_NOSCRLOUT(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_NOSCRLOUT(hwnd);
			else		   rc = A64VthGetSty_NOSCRLOUT(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_NOSCRLOUT@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_NOSCRLOUT(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_NOSCRLOUT", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_NOSCRLOUT(IntPtr hwnd);

		//----- ●AjcVthSetSty_NOSCRLOUT -----------------------------------------------------------------------//
		public static void AjcVthSetSty_NOSCRLOUT(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_NOSCRLOUT(hwnd, f);
			else		   A64VthSetSty_NOSCRLOUT(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_NOSCRLOUT@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_NOSCRLOUT(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_NOSCRLOUT", ExactSpelling = true)]
		private static extern void A64VthSetSty_NOSCRLOUT(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_CRCTRL --------------------------------------------------------------------------//
		public static bool AjcVthGetSty_CRCTRL(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_CRCTRL(hwnd);
			else		   rc = A64VthGetSty_CRCTRL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_CRCTRL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_CRCTRL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_CRCTRL", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_CRCTRL(IntPtr hwnd);

		//----- ●AjcVthSetSty_CRCTRL --------------------------------------------------------------------------//
		public static void AjcVthSetSty_CRCTRL(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_CRCTRL(hwnd, f);
			else		   A64VthSetSty_CRCTRL(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_CRCTRL@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_CRCTRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_CRCTRL", ExactSpelling = true)]
		private static extern void A64VthSetSty_CRCTRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_LFCTRL --------------------------------------------------------------------------//
		public static bool AjcVthGetSty_LFCTRL(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_LFCTRL(hwnd);
			else		   rc = A64VthGetSty_LFCTRL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_LFCTRL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_LFCTRL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_LFCTRL", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_LFCTRL(IntPtr hwnd);

		//----- ●AjcVthSetSty_LFCTRL --------------------------------------------------------------------------//
		public static void AjcVthSetSty_LFCTRL(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_LFCTRL(hwnd, f);
			else		   A64VthSetSty_LFCTRL(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_LFCTRL@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_LFCTRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_LFCTRL", ExactSpelling = true)]
		private static extern void A64VthSetSty_LFCTRL(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetSty_SEPARATE ------------------------------------------------------------------------//
		public static bool AjcVthGetSty_SEPARATE(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetSty_SEPARATE(hwnd);
			else		   rc = A64VthGetSty_SEPARATE(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetSty_SEPARATE@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetSty_SEPARATE(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetSty_SEPARATE", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetSty_SEPARATE(IntPtr hwnd);

		//----- ●AjcVthSetSty_SEPARATE ------------------------------------------------------------------------//
		public static void AjcVthSetSty_SEPARATE(IntPtr hwnd, bool f)
		{
			if (Is32Bit()) A32VthSetSty_SEPARATE(hwnd, f);
			else		   A64VthSetSty_SEPARATE(hwnd, f);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetSty_SEPARATE@8", ExactSpelling=true)]
		private static extern void A32VthSetSty_SEPARATE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetSty_SEPARATE", ExactSpelling = true)]
		private static extern void A64VthSetSty_SEPARATE(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool f);

		//----- ●AjcVthGetProp_VramW --------------------------------------------------------------------------//
		public static int AjcVthGetProp_VramW(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_VramW(hwnd);
			else		   rc = A64VthGetProp_VramW(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_VramW@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_VramW(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_VramW", ExactSpelling = true)]
		private static extern int A64VthGetProp_VramW(IntPtr hwnd);

		//----- ●AjcVthSetProp_VramW --------------------------------------------------------------------------//
		public static void AjcVthSetProp_VramW(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_VramW(hwnd, n);
			else		   A64VthSetProp_VramW(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_VramW@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_VramW(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_VramW", ExactSpelling = true)]
		private static extern void A64VthSetProp_VramW(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_VramH --------------------------------------------------------------------------//
		public static int AjcVthGetProp_VramH(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_VramH(hwnd);
			else		   rc = A64VthGetProp_VramH(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_VramH@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_VramH(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_VramH", ExactSpelling = true)]
		private static extern int A64VthGetProp_VramH(IntPtr hwnd);

		//----- ●AjcVthSetProp_VramH --------------------------------------------------------------------------//
		public static void AjcVthSetProp_VramH(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_VramH(hwnd, n);
			else		   A64VthSetProp_VramH(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_VramH@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_VramH(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_VramH", ExactSpelling = true)]
		private static extern void A64VthSetProp_VramH(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_CaretH -------------------------------------------------------------------------//
		public static int AjcVthGetProp_CaretH(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_CaretH(hwnd);
			else		   rc = A64VthGetProp_CaretH(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_CaretH@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_CaretH(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_CaretH", ExactSpelling = true)]
		private static extern int A64VthGetProp_CaretH(IntPtr hwnd);

		//----- ●AjcVthSetProp_CaretH -------------------------------------------------------------------------//
		public static void AjcVthSetProp_CaretH(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_CaretH(hwnd, n);
			else		   A64VthSetProp_CaretH(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_CaretH@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_CaretH(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_CaretH", ExactSpelling = true)]
		private static extern void A64VthSetProp_CaretH(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_MaxLines -----------------------------------------------------------------------//
		public static int AjcVthGetProp_MaxLines(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_MaxLines(hwnd);
			else		   rc = A64VthGetProp_MaxLines(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_MaxLines@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_MaxLines(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_MaxLines", ExactSpelling = true)]
		private static extern int A64VthGetProp_MaxLines(IntPtr hwnd);

		//----- ●AjcVthSetProp_MaxLines -----------------------------------------------------------------------//
		public static void AjcVthSetProp_MaxLines(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_MaxLines(hwnd, n);
			else		   A64VthSetProp_MaxLines(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_MaxLines@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_MaxLines(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_MaxLines", ExactSpelling = true)]
		private static extern void A64VthSetProp_MaxLines(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_TabStep ------------------------------------------------------------------------//
		public static int AjcVthGetProp_TabStep(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_TabStep(hwnd);
			else		   rc = A64VthGetProp_TabStep(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_TabStep@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_TabStep(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_TabStep", ExactSpelling = true)]
		private static extern int A64VthGetProp_TabStep(IntPtr hwnd);

		//----- ●AjcVthSetProp_TabStep ------------------------------------------------------------------------//
		public static void AjcVthSetProp_TabStep(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_TabStep(hwnd, n);
			else		   A64VthSetProp_TabStep(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_TabStep@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_TabStep(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_TabStep", ExactSpelling = true)]
		private static extern void A64VthSetProp_TabStep(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_LSpace -------------------------------------------------------------------------//
		public static int AjcVthGetProp_LSpace(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_LSpace(hwnd);
			else		   rc = A64VthGetProp_LSpace(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_LSpace@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_LSpace(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_LSpace", ExactSpelling = true)]
		private static extern int A64VthGetProp_LSpace(IntPtr hwnd);

		//----- ●AjcVthSetProp_LSpace -------------------------------------------------------------------------//
		public static void AjcVthSetProp_LSpace(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_LSpace(hwnd, n);
			else		   A64VthSetProp_LSpace(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_LSpace@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_LSpace(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_LSpace", ExactSpelling = true)]
		private static extern void A64VthSetProp_LSpace(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_PendSize -----------------------------------------------------------------------//
		public static int AjcVthGetProp_PendSize(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_PendSize(hwnd);
			else		   rc = A64VthGetProp_PendSize(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_PendSize@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_PendSize(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_PendSize", ExactSpelling = true)]
		private static extern int A64VthGetProp_PendSize(IntPtr hwnd);

		//----- ●AjcVthSetProp_PendSize -----------------------------------------------------------------------//
		public static void AjcVthSetProp_PendSize(IntPtr hwnd, int n)
		{
			if (Is32Bit()) A32VthSetProp_PendSize(hwnd, n);
			else		   A64VthSetProp_PendSize(hwnd, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_PendSize@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_PendSize(IntPtr hwnd, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_PendSize", ExactSpelling = true)]
		private static extern void A64VthSetProp_PendSize(IntPtr hwnd, int n);

		//----- ●AjcVthGetProp_rgb ----------------------------------------------------------------------------//
		public static int AjcVthGetProp_rgb(IntPtr hwnd, int ix)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_rgb(hwnd, ix);
			else		   rc = A64VthGetProp_rgb(hwnd, ix);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_rgb@8", ExactSpelling=true)]
		private static extern int A32VthGetProp_rgb(IntPtr hwnd, int ix);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_rgb", ExactSpelling = true)]
		private static extern int A64VthGetProp_rgb(IntPtr hwnd, int ix);

		//----- ●AjcVthSetProp_rgb ----------------------------------------------------------------------------//
		public static void AjcVthSetProp_rgb(IntPtr hwnd, int ix, int n)
		{
			if (Is32Bit()) A32VthSetProp_rgb(hwnd, ix, n);
			else		   A64VthSetProp_rgb(hwnd, ix, n);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_rgb@12", ExactSpelling=true)]
		private static extern void A32VthSetProp_rgb(IntPtr hwnd, int ix, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_rgb", ExactSpelling = true)]
		private static extern void A64VthSetProp_rgb(IntPtr hwnd, int ix, int n);

		//----- ●AjcVthGetProp_CharWidth ----------------------------------------------------------------------//
		public static int AjcVthGetProp_CharWidth(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_CharWidth(hwnd);
			else		   rc = A64VthGetProp_CharWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_CharWidth@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_CharWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_CharWidth", ExactSpelling = true)]
		private static extern int A64VthGetProp_CharWidth(IntPtr hwnd);

		//----- ●AjcVthGetProp_CharHeight ---------------------------------------------------------------------//
		public static int AjcVthGetProp_CharHeight(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_CharHeight(hwnd);
			else		   rc = A64VthGetProp_CharHeight(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_CharHeight@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_CharHeight(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_CharHeight", ExactSpelling = true)]
		private static extern int A64VthGetProp_CharHeight(IntPtr hwnd);

		//----- ●AjcVthGetProp_LineHeight ---------------------------------------------------------------------//
		public static int AjcVthGetProp_LineHeight(IntPtr hwnd)
		{
			int	rc;
			if (Is32Bit()) rc = A32VthGetProp_LineHeight(hwnd);
			else		   rc = A64VthGetProp_LineHeight(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_LineHeight@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_LineHeight(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_LineHeight", ExactSpelling = true)]
		private static extern int A64VthGetProp_LineHeight(IntPtr hwnd);

		//----- ●AjcVthSetProp_WndSize ------------------------------------------------------------------------//
		public static void AjcVthSetProp_WndSize(IntPtr hwnd, int width, int height)
		{
			if (Is32Bit()) A32VthSetProp_WndSize(hwnd, width, height);
			else		   A64VthSetProp_WndSize(hwnd, width, height);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_WndSize@12", ExactSpelling=true)]
		private static extern void A32VthSetProp_WndSize(IntPtr hwnd, int width, int height);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_WndSize", ExactSpelling = true)]
		private static extern void A64VthSetProp_WndSize(IntPtr hwnd, int width, int height);

		//----- ●AjcVthGetProp_Font ---------------------------------------------------------------------------//
		public static string AjcVthGetProp_Font(string str)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32VthGetProp_Font(str, s, 512);
			else		   A64VthGetProp_Font(str, s, 512);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_Font@12", ExactSpelling=true)]
		private static extern void A32VthGetProp_Font(string pS, StringBuilder pD, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_Font", ExactSpelling = true)]
		private static extern void A64VthGetProp_Font(string pS, StringBuilder pD, int len);

		//----- ●AjcVthSetProp_Font ---------------------------------------------------------------------------//
		public static void AjcVthSetProp_Font(IntPtr hwnd, string pText)
		{
			if (Is32Bit()) A32VthSetProp_Font(hwnd, pText);
			else		   A64VthSetProp_Font(hwnd, pText);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetProp_Font@8", ExactSpelling=true)]
		private static extern void A32VthSetProp_Font(IntPtr hwnd, string pText);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_Font", ExactSpelling = true)]
		private static extern void A64VthSetProp_Font(IntPtr hwnd, string pText);

		//----- ●AjcVthSetProp_AcceptFiles --------------------------------------------------------------------//
		public static void AjcVthSetProp_AcceptFiles(IntPtr hwnd, bool fEnable)
		{
			if (Is32Bit()) A32VthSetProp_AcceptFiles(hwnd, fEnable);
			else		   A64VthSetProp_AcceptFiles(hwnd, fEnable);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcVthSetProp_AcceptFiles@8", ExactSpelling = true)]
		private static extern void A32VthSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetProp_AcceptFiles", ExactSpelling = true)]
		private static extern void A64VthSetProp_AcceptFiles(IntPtr hwnd, [MarshalAs(UnmanagedType.Bool)] bool fEnable);

		//----- ●AjcVthGetProp_AcceptFiles --------------------------------------------------------------------//
		public static bool AjcVthGetProp_AcceptFiles(IntPtr hwnd)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthGetProp_AcceptFiles(hwnd);
			else		   rc = A64VthGetProp_AcceptFiles(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll", CharSet = CharSet.Unicode, EntryPoint = "_AjcVthGetProp_AcceptFiles@4", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthGetProp_AcceptFiles(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetProp_AcceptFiles", ExactSpelling = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthGetProp_AcceptFiles(IntPtr hwnd);

		//----- ●AjcVthGetProp_WndHeight ----------------------------------------------------------------------//
		public static int AjcVthGetProp_WndHeight(IntPtr hwnd)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthGetProp_WndHeight(hwnd);
			else		   rc = A64VthGetProp_WndHeight(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_WndHeight@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_WndHeight(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetProp_WndHeight", ExactSpelling=true)]
		private static extern int A64VthGetProp_WndHeight(IntPtr hwnd);

		//----- ●AjcVthGetProp_WndWidth -----------------------------------------------------------------------//
		public static int AjcVthGetProp_WndWidth(IntPtr hwnd)
		{
			int		rc;
			if (Is32Bit()) rc = A32VthGetProp_WndWidth(hwnd);
			else		   rc = A64VthGetProp_WndWidth(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetProp_WndWidth@4", ExactSpelling=true)]
		private static extern int A32VthGetProp_WndWidth(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetProp_WndWidth", ExactSpelling=true)]
		private static extern int A64VthGetProp_WndWidth(IntPtr hwnd);

		//----- ●AjcVthSetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcVthSetTipTextForMSIL(IntPtr hwnd, string pTxt)
		{
			if (Is32Bit()) A32VthSetTipTextForMSIL(hwnd, pTxt);
			else		   A64VthSetTipTextForMSIL(hwnd, pTxt);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetTipTextForMSIL@8", ExactSpelling=true)]
		private static extern void A32VthSetTipTextForMSIL(IntPtr hwnd, string pTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthSetTipTextForMSIL", ExactSpelling = true)]
		private static extern void A64VthSetTipTextForMSIL(IntPtr hwnd, string pTxt);

		//----- ●AjcVthGetTipTextForMSIL ----------------------------------------------------------------------//
		public static void AjcVthGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf)
		{
			if (Is32Bit()) A32VthGetTipTextForMSIL(hwnd, pBuf, lBuf);
			else		   A64VthGetTipTextForMSIL(hwnd, pBuf, lBuf);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetTipTextForMSIL@12", ExactSpelling=true)]
		private static extern void A32VthGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll", CharSet = CharSet.Unicode, EntryPoint = "AjcVthGetTipTextForMSIL", ExactSpelling = true)]
		private static extern void A64VthGetTipTextForMSIL(IntPtr hwnd, StringBuilder pBuf, int lBuf);

		//----- ●AjcVthSetDefFont -------------------------------------------------------------------------------//
		public static void AjcVthSetDefFont(IntPtr hwnd, IntPtr hFont)
		{
			if (Is32Bit()) A32VthSetDefFont(hwnd, hFont);
			else		   A64VthSetDefFont(hwnd, hFont);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetDefFont@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetDefFont(IntPtr hwnd, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetDefFont", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetDefFont(IntPtr hwnd, IntPtr hFont);

		//----- ●AjcVthSaveIniPropForMSIL ---------------------------------------------------------------------//
		public static void AjcVthSaveIniPropForMSIL(IntPtr hwnd)
		{
			if (Is32Bit()) A32VthSaveIniPropForMSIL(hwnd);
			else		   A64VthSaveIniPropForMSIL(hwnd);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSaveIniPropForMSIL@4", ExactSpelling=true)]
		private static extern void A32VthSaveIniPropForMSIL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSaveIniPropForMSIL", ExactSpelling=true)]
		private static extern void A64VthSaveIniPropForMSIL(IntPtr hwnd);

		//----- ●AjcVthSetFontForMSIL ---------------------------------------------------------------------//
		public static bool AjcVthSetFontForMSIL(IntPtr hwnd, IntPtr hFont)
		{
			bool	rc;
			if (Is32Bit()) rc = A32VthSetFontForMSIL(hwnd, hFont);
			else		   rc = A64VthSetFontForMSIL(hwnd, hFont);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthSetFontForMSIL@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32VthSetFontForMSIL(IntPtr hwnd, IntPtr hFont);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthSetFontForMSIL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64VthSetFontForMSIL(IntPtr hwnd, IntPtr hFont);

		//----- ●AjcVthGetFontForMSIL ---------------------------------------------------------------------//
		public static IntPtr AjcVthGetFontForMSIL(IntPtr hwnd)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32VthGetFontForMSIL(hwnd);
			else		   rc = A64VthGetFontForMSIL(hwnd);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcVthGetFontForMSIL@4", ExactSpelling=true)]
		private static extern IntPtr A32VthGetFontForMSIL(IntPtr hwnd);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcVthGetFontForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64VthGetFontForMSIL(IntPtr hwnd);


		//======================================================================================================//
		//	AjcDateAndTime.h																					//
		//======================================================================================================//

		//----- ●AjcMsilTime1970ToSysTime ---------------------------------------------------------------------//
		public static DateTime AjcMsilTime1970ToSysTime(uint Time1970)
		{
			int	year, month, day, hour, minute, second;
			if (Is32Bit()) A32MsilTime1970ToSysTime(Time1970, out year, out month, out day, out hour, out minute, out second);
			else		   A64MsilTime1970ToSysTime(Time1970, out year, out month, out day, out hour, out minute, out second);
			return new DateTime(year, month, day, hour, minute, second);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilTime1970ToSysTime@28", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32MsilTime1970ToSysTime(uint Time1970, out int year, out int month, out int day, out int hour, out int minute, out int second);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilTime1970ToSysTime", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64MsilTime1970ToSysTime(uint Time1970, out int year, out int month, out int day, out int hour, out int minute, out int second);

		//----- ●AjcMsilTime1970ToSysTimeL --------------------------------------------------------------------//
		public static DateTime AjcMsilTime1970ToSysTimeL(ulong Time1970)
		{
			int	year, month, day, hour, minute, second;
			if (Is32Bit()) A32MsilTime1970ToSysTimeL(Time1970, out year, out month, out day, out hour, out minute, out second);
			else		   A64MsilTime1970ToSysTimeL(Time1970, out year, out month, out day, out hour, out minute, out second);
			return new DateTime(year, month, day, hour, minute, second);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilTime1970ToSysTimeL@32", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32MsilTime1970ToSysTimeL(ulong Time1970, out int year, out int month, out int day, out int hour, out int minute, out int second);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilTime1970ToSysTimeL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64MsilTime1970ToSysTimeL(ulong Time1970, out int year, out int month, out int day, out int hour, out int minute, out int second);

		//----- ●AjcMsilSysTimeToTime1970 ---------------------------------------------------------------------//
		public static uint AjcMsilSysTimeToTime1970(DateTime dt)
		{
			uint	Time1970 = 0xFFFFFFFF;
			if (Is32Bit()) Time1970 = A32MsilSysTimeToTime1970(dt.Year, dt.Month, dt.Day, dt.Hour, dt.Minute, dt.Second);
			else		   Time1970 = A64MsilSysTimeToTime1970(dt.Year, dt.Month, dt.Day, dt.Hour, dt.Minute, dt.Second);
			return Time1970;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilSysTimeToTime1970@24", ExactSpelling=true)]
		private static extern uint A32MsilSysTimeToTime1970(int year, int month, int day, int hour, int minute, int second);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilSysTimeToTime1970", ExactSpelling=true)]
		private static extern uint A64MsilSysTimeToTime1970(int year, int month, int day, int hour, int minute, int second);

		//----- ●AjcMsilSysTimeToTime1970L --------------------------------------------------------------------//
		public static ulong AjcMsilSysTimeToTime1970L(DateTime dt)
		{
			ulong	Time1970 = 0xFFFFFFFFFFFFFFFF;
			if (Is32Bit()) Time1970 = A32MsilSysTimeToTime1970L(dt.Year, dt.Month, dt.Day, dt.Hour, dt.Minute, dt.Second);
			else		   Time1970 = A64MsilSysTimeToTime1970L(dt.Year, dt.Month, dt.Day, dt.Hour, dt.Minute, dt.Second);
			return Time1970;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilSysTimeToTime1970L@24", ExactSpelling=true)]
		private static extern ulong A32MsilSysTimeToTime1970L(int year, int month, int day, int hour, int minute, int second);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilSysTimeToTime1970L", ExactSpelling=true)]
		private static extern ulong A64MsilSysTimeToTime1970L(int year, int month, int day, int hour, int minute, int second);

		//----- ●AjcMsilSysTimeToLocalTime --------------------------------------------------------------------//
		public static DateTime AjcMsilSysTimeToLocalTime(DateTime dt)
		{
			int	   year   = dt.Year;
			int    month  = dt.Month;
			int    day	  = dt.Day;
			int    hour   = dt.Hour;
			int    minute = dt.Minute;
			int    second = dt.Second;
			if (Is32Bit()) A32MsilSysTimeToLocalTime(ref year, ref month, ref day, ref hour, ref minute, ref second);
			else		   A64MsilSysTimeToLocalTime(ref year, ref month, ref day, ref hour, ref minute, ref second);
			return new DateTime(year, month, day, hour, minute,second);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilSysTimeToLocalTime@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32MsilSysTimeToLocalTime(ref int year, ref int month, ref int day, ref int hour, ref int minute, ref int second);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilSysTimeToLocalTime", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64MsilSysTimeToLocalTime(ref int year, ref int month, ref int day, ref int hour, ref int minute, ref int second);

		//======================================================================================================//
		//	AjcDibSect.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcDlgItem.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcFFT.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcFileDir.h																						//
		//======================================================================================================//
		//----- ●AjcCopyFolderStructEx ------------------------------------------------------------------------//
		public static bool AjcCopyFolderStructEx(string dirFrom, string dirTo, EFscOpt opt, IntPtr cbp, FopCbkScpNtc cbScpNtc, FopCbkScpQry cbScpQry)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CopyFolderStructEx(dirFrom, dirTo, opt, cbp, cbScpNtc, cbScpQry);
			else		   rc = A64CopyFolderStructEx(dirFrom, dirTo, opt, cbp, cbScpNtc, cbScpQry);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCopyFolderStructExW@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CopyFolderStructEx(string PathFrom, string PathTo, EFscOpt opt, IntPtr cbp, FopCbkScpNtc cbCpyNtc, FopCbkScpQry cbScpQry);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCopyFolderStructExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CopyFolderStructEx(string PathFrom, string PathTo, EFscOpt opt, IntPtr cbp, FopCbkScpNtc cbCpyNtc, FopCbkScpQry cbScpQry);

		//----- ●AjcCopyFilesEx -------------------------------------------------------------------------------//
		public static bool AjcCopyFilesEx(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt, IntPtr cbp, FopCbkFcpNtc cbFcpNtc, FopCbkFcpQry cbFcpQry, FopCbkFcpPgs cbFcpPgs)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CopyFilesEx(PathFrom, PathTo, WildCard, opt, cbp, cbFcpNtc, cbFcpQry, cbFcpPgs);
			else		   rc = A64CopyFilesEx(PathFrom, PathTo, WildCard, opt, cbp, cbFcpNtc, cbFcpQry, cbFcpPgs);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCopyFilesExW@32", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CopyFilesEx(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt, IntPtr cbp,
																						FopCbkFcpNtc cbFcpNtc, FopCbkFcpQry cbFcpQry, FopCbkFcpPgs cbFcpPgs);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCopyFilesExW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CopyFilesEx(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt, IntPtr cbp,
																						FopCbkFcpNtc cbFcpNtc, FopCbkFcpQry cbFcpQry, FopCbkFcpPgs cbFcpPgs);

		//----- ●AjcRemoveFolder ------------------------------------------------------------------------------//
		public static bool AjcRemoveFolder(string dir, IntPtr cbp, FopCbkRmvDir cb)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RemoveFolder(dir, cbp, cb);
			else		   rc = A64RemoveFolder(dir, cbp, cb);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRemoveFolderW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RemoveFolder(string dir, IntPtr cbp, FopCbkRmvDir cbRmvDir);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRemoveFolderW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RemoveFolder(string dir, IntPtr cbp, FopCbkRmvDir cbRmvDir);

		//----- ●AjcCleanFolder -------------------------------------------------------------------------------//
		public static bool AjcCleanFolder(string dir, IntPtr cbp, FopCbkRmvDir cb)
		{
			bool	rc;
			if (Is32Bit()) rc = A32CleanFolder(dir, cbp, cb);
			else		   rc = A64CleanFolder(dir, cbp, cb);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCleanFolderW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CleanFolder(string dir, IntPtr cbp, FopCbkRmvDir cbRmvDir);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCleanFolderW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CleanFolder(string dir, IntPtr cbp, FopCbkRmvDir cbRmvDir);

		//----- ●AjcEnumFileMatchingListMsil ------------------------------------------------------------------//
		public static int AjcEnumFileMatchingListMsil(string path1, string path2, EFmlOpt opt, IntPtr cbp, FopCbkFmlQuery cbQuery, FopCbkFmlEnum cbEnum)
		{
			int		rc;
			if (Is32Bit()) rc = A32EnumFileMatchingListMsil(path1, path2, opt, cbp, cbQuery, cbEnum);
			else		   rc = A64EnumFileMatchingListMsil(path1, path2, opt, cbp, cbQuery, cbEnum);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcEnumFileMatchingListMsil@24", ExactSpelling=true)]
		private static extern int A32EnumFileMatchingListMsil(string path1, string path2, EFmlOpt opt, IntPtr cbp, FopCbkFmlQuery cbQuery, FopCbkFmlEnum cbEnum);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcEnumFileMatchingListMsil", ExactSpelling=true)]
		private static extern int A64EnumFileMatchingListMsil(string path1, string path2, EFmlOpt opt, IntPtr cbp, FopCbkFmlQuery cbQuery, FopCbkFmlEnum cbEnum);

		//----- ●AjcPathExists --------------------------------------------------------------------------------//
		public static bool AjcPathExists(string path)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PathExists(path);
			else		   rc = A64PathExists(path);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPathExistsW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PathExists(string path);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPathExistsW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PathExists(string path);

		//----- ●AjcPathMatchSpec --------------------------------------------------------------------------------//
		public static bool AjcPathMatchSpec(string path, string WildCards)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PathMatchSpec(path, WildCards);
			else		   rc = A64PathMatchSpec(path, WildCards);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPathMatchSpecW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PathMatchSpec(string path, string wild);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPathMatchSpecW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PathMatchSpec(string path, string wild);

		//----- ●AjcPathMatchStr --------------------------------------------------------------------------------//
		public static bool AjcPathMatchStr(string path, string WildCards)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PathMatchStr(path, WildCards);
			else		   rc = A64PathMatchStr(path, WildCards);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPathMatchStrW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PathMatchStr(string path, string wild);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPathMatchStrW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PathMatchStr(string path, string wild);

		//----- ●AjcPathIsDirectory ---------------------------------------------------------------------------//
		public static bool AjcPathIsDirectory(string DirPath)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PathIsDirectory(DirPath);
			else		   rc = A64PathIsDirectory(DirPath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPathIsDirectoryW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PathIsDirectory(string path);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPathIsDirectoryW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PathIsDirectory(string path);

		//----- ●AjcPathIsFile --------------------------------------------------------------------------------//
		public static bool AjcPathIsFile(string FilePath)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PathIsFile(FilePath);
			else		   rc = A64PathIsFile(FilePath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPathIsFileW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PathIsFile(string path);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPathIsFileW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PathIsFile(string path);

		//----- ●AjcGetFileSize -------------------------------------------------------------------------------//
		public static long AjcGetFileSize(string FilePath)
		{
			long	rc;
			if (Is32Bit()) rc = A32GetFileSize(FilePath);
			else		   rc = A64GetFileSize(FilePath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetFileSizeW@4", ExactSpelling=true)]
		private static extern long A32GetFileSize(string path);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetFileSizeW", ExactSpelling=true)]
		private static extern long A64GetFileSize(string path);

		//----- ●AjcGetFileTime1970 ---------------------------------------------------------------------------//
		public static uint AjcGetFileTime1970(string FilePath)
		{
			uint	rc;
			if (Is32Bit()) rc = A32GetFileTime1970(FilePath);
			else		   rc = A64GetFileTime1970(FilePath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetFileTime1970W@4", ExactSpelling=true)]
		private static extern uint A32GetFileTime1970(string path);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetFileTime1970W", ExactSpelling=true)]
		private static extern uint A64GetFileTime1970(string path);

		//----- ●AjcFileCompare -------------------------------------------------------------------------------//
		public static bool AjcFileCompare(string File1, string File2)
		{
			bool	rc;
			if (Is32Bit()) rc = A32FileCompare(File1, File2);
			else		   rc = A64FileCompare(File1, File2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcFileCompareW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32FileCompare(string File1, string File2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcFileCompareW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64FileCompare(string File1, string File2);

		//======================================================================================================//
		//	AjcFileSearch.h 																					//
		//======================================================================================================//

		//----- ●AjcSetNtcSearchingDir ------------------------------------------------------------------------//
		public static void AjcSetNtcSearchingDir(bool fNotify)
		{
			if (Is32Bit()) A32SetNtcSearchingDir(fNotify);
			else		   A64SetNtcSearchingDir(fNotify);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetNtcSearchingDir@4", ExactSpelling=true)]
		private static extern void A32SetNtcSearchingDir([MarshalAs(UnmanagedType.Bool)] bool fNotify);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetNtcSearchingDir", ExactSpelling=true)]
		private static extern void A64SetNtcSearchingDir([MarshalAs(UnmanagedType.Bool)] bool fNotify);

		//----- ●AjcSearchFiles -------------------------------------------------------------------------------//
		public static int AjcSearchFiles(string dir, string wild, bool fSubDir, IntPtr cbp, FsrCbkFindFile cb)
		{
			int	rc;
			if (Is32Bit()) rc = A32SearchFiles(dir, wild, fSubDir, cbp, cb);
			else		   rc = A64SearchFiles(dir, wild, fSubDir, cbp, cb);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSearchFilesW@20", ExactSpelling=true)]
		private static extern int A32SearchFiles(string pDir, string pWild, [MarshalAs(UnmanagedType.Bool)] bool fSubDir,
												 IntPtr cbp, FsrCbkFindFile cbFindFile);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSearchFilesW", ExactSpelling=true)]
		private static extern int A64SearchFiles(string pDir,string pWild,[MarshalAs(UnmanagedType.Bool)] bool fSubDir,
												IntPtr cbp, FsrCbkFindFile cbFindFile);

		//----- ●AjcSearchMyComputer --------------------------------------------------------------------------//
		public static int AjcSearchMyComputer(string path, string wild, bool fRemote, IntPtr cbp, FsrCbkFindFile cb)
		{
			int	rc;
			if (Is32Bit()) rc = A32SearchMyComputer(path, wild, fRemote, cbp, cb);
			else		   rc = A64SearchMyComputer(path, wild, fRemote, cbp, cb);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSearchMyComputerW@20", ExactSpelling=true)]
		private static extern int A32SearchMyComputer(string pPath, string pWild, [MarshalAs(UnmanagedType.Bool)] bool fRemote,
												 IntPtr cbp, FsrCbkFindFile cbFindFile);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSearchMyComputerW", ExactSpelling=true)]
		private static extern int A64SearchMyComputer(string pPath, string pWild, [MarshalAs(UnmanagedType.Bool)] bool fRemote,
												IntPtr cbp, FsrCbkFindFile cbFindFile);

		//======================================================================================================//
		//	AjcGeneral.h																						//
		//======================================================================================================//

		//----- ●AjcDifferenceOfTheta -------------------------------------------------------------------------//
		public static double AjcDifferenceOfTheta(double t1, double t2)
		{
			double	rc;
			if (Is32Bit()) rc = A32DifferenceOfTheta(t1, t2);
			else		   rc = A64DifferenceOfTheta(t1, t2);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcDifferenceOfTheta@16", ExactSpelling=true)]
		private static extern double A32DifferenceOfTheta(double t1, double t2);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcDifferenceOfTheta", ExactSpelling=true)]
		private static extern double A64DifferenceOfTheta(double t1, double t2);

		//----- ●AjcExitWindows -------------------------------------------------------------------------------//
		public static bool AjcExitWindows(EExitWindows flag, bool force)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ExitWindows(flag | (force ? EExitWindows.EWX_FORCE : (EExitWindows)0));
			else		   rc = A64ExitWindows(flag | (force ? EExitWindows.EWX_FORCE : (EExitWindows)0));
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcExitWindows(EExitWindows flag)
		{
			return AjcExitWindows(flag, false);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcExitWindows@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ExitWindows(EExitWindows flag);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcExitWindows", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ExitWindows(EExitWindows flag);

		//======================================================================================================//
		//	AjcGetFileDir.h 																					//
		//======================================================================================================//

		//----- ●AjcGetSaveFile -------------------------------------------------------------------------------//
		public static bool	AjcGetSaveFile(IntPtr hOwner, string title, string filter, string defExt, StringBuilder s, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32GetSaveFile(hOwner, title, filter, defExt, s, len);
			else		   rc = A64GetSaveFile(hOwner, title, filter, defExt, s, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetSaveFileW@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetSaveFile(IntPtr hWnd, string pTitle, string pFilter, string pDefExt, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetSaveFileW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetSaveFile(IntPtr hWnd,string pTitle,string pFilter,string pDefExt,StringBuilder pBuf,int lBuf);

		//----- ●AjcGetOpenFile -------------------------------------------------------------------------------//
		public static bool AjcGetOpenFile(IntPtr hOwner, string title, string filter, string defExt, StringBuilder s, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32GetOpenFile(hOwner, title, filter, defExt, s, len);
			else		   rc = A64GetOpenFile(hOwner, title, filter, defExt, s, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetOpenFileW@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetOpenFile(IntPtr hWnd, string pTitle, string pFilter, string pDefExt, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetOpenFileW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetOpenFile(IntPtr hWnd,string pTitle,string pFilter,string pDefExt,StringBuilder pBuf,int lBuf);

		//----- ●AjcGetOpenFiles ------------------------------------------------------------------------------//
		unsafe public static IntPtr* AjcGetOpenFiles(IntPtr hOwner, string initialPath, string title, string filter, string defExt, bool fMulti, out int nFiles)
		{
			IntPtr		*pArr;
			if (Is32Bit()) pArr = A32GetOpenFiles(hOwner, initialPath, title, filter, defExt, fMulti, out nFiles);
			else		   pArr = A64GetOpenFiles(hOwner, initialPath, title, filter, defExt, fMulti, out nFiles);
			return pArr;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetOpenFilesW@28", ExactSpelling=true)]
		unsafe private static extern IntPtr *A32GetOpenFiles(IntPtr hWnd, string pInitialPath, string pTitle, string pFilter, string pDefExt,
																			 [MarshalAs(UnmanagedType.Bool)] bool fMulti, out int pNum);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetOpenFilesW", ExactSpelling=true)]
		unsafe private static extern IntPtr *A64GetOpenFiles(IntPtr hWnd, string pInitialPath,string pTitle, string pFilter, string pDefExt,
																			 [MarshalAs(UnmanagedType.Bool)] bool fMulti, out int pNum);

		//----- ●AjcReleaseOpenedFilesArray -------------------------------------------------------------------//
		unsafe public static void AjcReleaseOpenedFilesArray(IntPtr *pArr)
		{
			if (Is32Bit()) A32ReleaseOpenedFilesArray(pArr);
			else		   A64ReleaseOpenedFilesArray(pArr);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcReleaseOpenedFilesArray@4", ExactSpelling=true)]
		unsafe private static extern void A32ReleaseOpenedFilesArray(IntPtr *pArr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcReleaseOpenedFilesArray", ExactSpelling=true)]
		unsafe private static extern void A64ReleaseOpenedFilesArray(IntPtr *pArr);

		//----- ●AjcGetFolderName -----------------------------------------------------------------------------//
		public static bool AjcGetFolderName(IntPtr hOwner, string wndTitle, string boxTitle, StringBuilder s, bool fTailIsDelimiter)
		{
			bool	rc;
			if (Is32Bit()) rc = A32GetFolderName(hOwner, wndTitle, boxTitle, s, fTailIsDelimiter);
			else		   rc = A64GetFolderName(hOwner, wndTitle, boxTitle, s, fTailIsDelimiter);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetFolderNameW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetFolderName(IntPtr hWnd, string pWndTtl, string pBoxTtl, StringBuilder pBuf,
																			 [MarshalAs(UnmanagedType.Bool)] bool fTailIsDelimiter);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetFolderNameW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetFolderName(IntPtr hWnd, string pWndTtl, string pBoxTtl, StringBuilder pBuf,
																			 [MarshalAs(UnmanagedType.Bool)] bool fTailIsDelimiter);

		//----- ●AjcGetAppPath --------------------------------------------------------------------------------//
		public static string AjcGetAppPath()
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32GetAppPath(s, (int)s.Capacity);
			else		   A64GetAppPath(s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetAppPathW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetAppPath(StringBuilder pBuf, int bfl);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetAppPathW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetAppPath(StringBuilder pBuf,int bfl);

		//======================================================================================================//
		//	AjcHeapSort.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcHexData.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcImgFunc.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcIniFile.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcLzhDecode.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcMain.h																							//
		//======================================================================================================//

		//----- ●AjcGetLangId ---------------------------------------------------------------------------------//
		public static ELangId AjcGetLangId()
		{
			ELangId rc;
			if (Is32Bit()) rc = A32GetLangId();
			else		   rc = A64GetLangId();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetLangId@0", ExactSpelling=true)]
		private static extern ELangId A32GetLangId();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetLangId", ExactSpelling=true)]
		private static extern ELangId A64GetLangId();

		//----- ●AjcGetProfileUInt ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileUIntW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetProfileBool(string pSecName, string pKeyName, [MarshalAs(UnmanagedType.Bool)] bool defValue);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileUIntW@12", ExactSpelling=true)]
		private static extern uint A32GetProfile(string pSecName, string pKeyName, uint defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileUIntW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetProfileBool(string pSecName, string pKeyName, [MarshalAs(UnmanagedType.Bool)] bool defValue);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileUIntW", ExactSpelling=true)]
		private static extern uint A64GetProfile(string pSecName, string pKeyName, uint defValue);

		//----- ●AjcGetProfileSInt ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileSIntW@12", ExactSpelling=true)]
		private static extern int A32GetProfile(string pSecName, string pKeyName, int defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileSIntW", ExactSpelling=true)]
		private static extern int A64GetProfile(string pSecName, string pKeyName, int defValue);

		//----- ●AjcGetProfileHex -----------------------------------------------------------------------------//
		public static uint AjcGetProfileHex(string sec, string key, uint defValue)
		{
			uint	rc;
			if (Is32Bit()) rc = A32GetProfileHex(sec, key, defValue);
			else		   rc = A64GetProfileHex(sec, key, defValue);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileHexW@12", ExactSpelling=true)]
		private static extern uint A32GetProfileHex(string pSecName, string pKeyName, uint defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileHexW", ExactSpelling=true)]
		private static extern uint A64GetProfileHex(string pSecName, string pKeyName, uint defValue);

		//----- ●AjcGetProfileReal ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileRealW@16", ExactSpelling=true)]
		private static extern double A32GetProfile(string pSecName, string pKeyName, double defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileRealW", ExactSpelling=true)]
		private static extern double A64GetProfile(string pSecName, string pKeyName, double defValue);

		//----- ●AjcGetProfileStr -----------------------------------------------------------------------------//
		public static string AjcGetProfileStr(string sec, string key, string defValue)
		{
			StringBuilder s = new StringBuilder(4096);
			if (Is32Bit()) {
				A32GetProfileStr(sec, key, defValue, s, (int)s.Capacity);
			}
			else {
				A64GetProfileStr(sec, key, defValue, s, (int)s.Capacity);
			}
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileStrW@20", ExactSpelling=true)]
		private static extern int A32GetProfileStr(string pSecName, string pKeyName, string pDefStr, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileStrW", ExactSpelling=true)]
		private static extern int A64GetProfileStr(string pSecName, string pKeyName, string pDefStr, StringBuilder pBuf, int lBuf);

		//----- ●AjcPutProfileUInt ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileUIntW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfileBool(string pSecName, string pKeyName, [MarshalAs(UnmanagedType.Bool)] bool Value);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileUIntW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfile(string pSecName, string pKeyName, uint Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileUIntW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfileBool(string pSecName, string pKeyName, [MarshalAs(UnmanagedType.Bool)] bool Value);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileUIntW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfile(string pSecName, string pKeyName, uint Value);

		//----- ●AjcPutProfileSInt ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileSIntW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfile(string pSecName, string pKeyName, int Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileSIntW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfile(string pSecName, string pKeyName, int Value);

		//----- ●AjcPutProfileHex -----------------------------------------------------------------------------//
		public static void AjcPutProfileHex(string sec, string key, uint value)
		{
			if (Is32Bit()) A32PutProfileHex(sec, key, value);
			else		   A64PutProfileHex(sec, key, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileHexW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfileHex(string pSecName, string pKeyName, uint Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileHexW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfileHex(string pSecName, string pKeyName, uint Value);

		//----- ●AjcPutProfileReal ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileRealW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfile(string pSecName, string pKeyName, double Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileRealW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfile(string pSecName, string pKeyName, double Value);

		//----- ●AjcPutProfileStr -----------------------------------------------------------------------------//
		public static void AjcPutProfileStr(string sec, string key, string value)
		{
			if (Is32Bit()) A32PutProfileStr(sec, key, value);
			else		   A64PutProfileStr(sec, key, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileStrW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfileStr(string pSecName, string pKeyName, string pStr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileStrW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfileStr(string pSecName, string pKeyName, string pStr);

		//----- ●AjcChangeIconToMsil --------------------------------------------------------------------------//
		public static void AjcChangeIconToMsil()
		{
			if (Is32Bit()) A32ChangeIconToMsil();
			else		   A64ChangeIconToMsil();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcChangeIconToMsil@0", ExactSpelling=true)]
		private static extern void A32ChangeIconToMsil();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcChangeIconToMsil", ExactSpelling=true)]
		private static extern void A64ChangeIconToMsil();

		//----- ●AjcSetLangId ---------------------------------------------------------------------------------//
		public static void AjcSetLangId(ELangId Lid)
		{
			if (Is32Bit()) A32SetLangId(Lid);
			else		   A64SetLangId(Lid);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetLangId@4", ExactSpelling=true)]
		private static extern void A32SetLangId(ELangId Lid);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetLangId", ExactSpelling=true)]
		private static extern void A64SetLangId(ELangId Lid);

		//----- ●AjcSetProfileIsRegistory ---------------------------------------------------------------------//
		public static bool AjcSetProfileIsRegistory(bool fRegistory)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SetProfileIsRegistory(fRegistory);
			else		   rc = A64SetProfileIsRegistory(fRegistory);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetProfileIsRegistory@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SetProfileIsRegistory([MarshalAs(UnmanagedType.Bool)] bool fRegistory);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetProfileIsRegistory", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SetProfileIsRegistory([MarshalAs(UnmanagedType.Bool)] bool fRegistory);

		//----- ●AjcSetRegOptionVolatile ----------------------------------------------------------------------//
		public static void AjcSetRegOptionVolatile(bool fVolatile)
		{
			if (Is32Bit()) A32SetRegOptionVolatile(fVolatile);
			else		   A64SetRegOptionVolatile(fVolatile);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetRegOptionVolatile@4", ExactSpelling=true)]
		private static extern void A32SetRegOptionVolatile([MarshalAs(UnmanagedType.Bool)] bool fVolatile);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetRegOptionVolatile", ExactSpelling=true)]
		private static extern void A64SetRegOptionVolatile([MarshalAs(UnmanagedType.Bool)] bool fVolatile);

		//----- ●AjcGetRegOptionVolatile ----------------------------------------------------------------------//
		public static bool AjcGetRegOptionVolatile()
		{
			bool	rc;
			if (Is32Bit()) rc = A32GetRegOptionVolatile();
			else		   rc = A64GetRegOptionVolatile();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetRegOptionVolatile@0", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetRegOptionVolatile();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetRegOptionVolatile", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetRegOptionVolatile();

		//----- ●AjcSetIniFilePath ----------------------------------------------------------------------------//
		public static void AjcSetIniFilePath(string IniFilePath)
		{
			if (Is32Bit()) A32SetIniFilePath(IniFilePath);
			else		   A64SetIniFilePath(IniFilePath);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetIniFilePathW@4", ExactSpelling=true)]
		private static extern void A32SetIniFilePath(string pIniPath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetIniFilePathW", ExactSpelling=true)]
		private static extern void A64SetIniFilePath(string pIniPath);

		//----- ●AjcGetIniFilePath ----------------------------------------------------------------------------//
		public static string AjcGetIniFilePath()
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32GetIniFilePath(s, (int)s.Capacity);
			else		   A64GetIniFilePath(s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetIniFilePathW@8", ExactSpelling=true)]
		private static extern void A32GetIniFilePath(StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetIniFilePathW", ExactSpelling=true)]
		private static extern void A64GetIniFilePath(StringBuilder pBuf, int lBuf);

		//----- ●AjcSetRegRootPath ----------------------------------------------------------------------------//
		public static void AjcSetRegRootPath(string RootPath)
		{
			if (Is32Bit()) A32SetRegRootPath(RootPath);
			else		   A64SetRegRootPath(RootPath);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetRegRootPathW@4", ExactSpelling=true)]
		private static extern void A32SetRegRootPath(string pRootPath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetRegRootPathW", ExactSpelling=true)]
		private static extern void A64SetRegRootPath(string pRootPath);

		//----- ●AjcGetRegRootPath ----------------------------------------------------------------------------//
		public static string AjcGetRegRootPath()
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32GetRegRootPath(s, (int)s.Capacity);
			else		   A64GetRegRootPath(s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetRegRootPathW@8", ExactSpelling=true)]
		private static extern void A32GetRegRootPath(StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetRegRootPathW", ExactSpelling=true)]
		private static extern void A64GetRegRootPath(StringBuilder pBuf, int lBuf);

		//----- ●AjcSetRegMidPath -----------------------------------------------------------------------------//
		public static void AjcSetRegMidPath(string MidPath)
		{
			if (Is32Bit()) A32SetRegMidPath(MidPath);
			else		   A64SetRegMidPath(MidPath);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetRegMidPathW@4", ExactSpelling=true)]
		private static extern void A32SetRegMidPath(string pMidPath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetRegMidPathW", ExactSpelling=true)]
		private static extern void A64SetRegMidPath(string pMidPath);

		//----- ●AjcGetRegMidPath -----------------------------------------------------------------------------//
		public static string AjcGetRegMidPath()
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32GetRegMidPath(s, (int)s.Capacity);
			else		   A64GetRegMidPath(s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetRegMidPathW@8", ExactSpelling=true)]
		private static extern void A32GetRegMidPath(StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetRegMidPathW", ExactSpelling=true)]
		private static extern void A64GetRegMidPath(StringBuilder pBuf, int lBuf);

		//----- ●AjcSetProfilePath ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetProfilePathW@4", ExactSpelling=true)]
		private static extern int A32SetProfilePath(string pPath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetProfilePathW", ExactSpelling=true)]
		private static extern int A64SetProfilePath(string pPath);

		//----- ●AjcGetProfilePath ----------------------------------------------------------------------------//
		public static string AjcGetProfilePath()
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32GetProfilePath(s, s.Capacity);
			else		   A64GetProfilePath(s, s.Capacity);
			return s.ToString();
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string AjcGetProfilePath(StringBuilder s)
		{
			if (Is32Bit()) A32GetProfilePath(s, s.Capacity);
			else		   A64GetProfilePath(s, s.Capacity);
			return s.ToString();
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		//	※AjcGetProfilePath()は、プロファイル記録先を返す為、AjcGetProfileIsRegistory()として、ここに定義
		//	
		public static bool AjcGetProfileIsRegistory()
		{
			bool rc;
			if (Is32Bit()) rc = A32GetProfilePath(null, 0);
			else		   rc = A64GetProfilePath(null, 0);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfilePathW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32GetProfilePath(StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfilePathW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64GetProfilePath(StringBuilder pBuf, int lBuf);

		//----- ●AjcGetProfile --------------------------------------------------------------------------------//
		public static int AjcGetProfile(string sec, string key, int defValue)
		{
			int	rc;
			if (Is32Bit()) rc = A32GetProfile(sec, key, defValue);
			else		   rc = A64GetProfile(sec, key, defValue);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static uint AjcGetProfile(string sec, string key, uint defValue)
		{
			uint	rc;
			if (Is32Bit()) rc = A32GetProfile(sec, key, defValue);
			else		   rc = A64GetProfile(sec, key, defValue);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static double AjcGetProfile(string sec, string key, double defValue)
		{
			double	rc;
			if (Is32Bit()) rc = A32GetProfile(sec, key, defValue);
			else		   rc = A64GetProfile(sec, key, defValue);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ulong AjcGetProfile(string sec, string key, ulong defValue)
		{
			ulong	rc;
			if (Is32Bit()) rc = A32GetProfile(sec, key, defValue);
			else		   rc = A64GetProfile(sec, key, defValue);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static long AjcGetProfile(string sec, string key, long defValue)
		{
			long	rc;
			if (Is32Bit()) rc = A32GetProfile(sec, key, defValue);
			else		   rc = A64GetProfile(sec, key, defValue);
			return rc;
		}

		//----- ●AjcGetProfileBool ----------------------------------------------------------------------------//
		public static bool AjcGetProfileBool(string sec, string key, bool defValue)
		{
			bool	rc;
			if (Is32Bit()) rc = A32GetProfileBool(sec, key, defValue);
			else		   rc = A64GetProfileBool(sec, key, defValue);
			return rc;
		}

		//----- ●AjcGetProfileUI64 ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileUI64W@16", ExactSpelling=true)]
		private static extern ulong A32GetProfile(string pSecName, string pKeyName, ulong defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileUI64W", ExactSpelling=true)]
		private static extern ulong A64GetProfile(string pSecName, string pKeyName, ulong defValue);

		//----- ●AjcGetProfileSI64 ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileSI64W@16", ExactSpelling=true)]
		private static extern long A32GetProfile(string pSecName, string pKeyName, long defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileSI64W", ExactSpelling=true)]
		private static extern long A64GetProfile(string pSecName, string pKeyName, long defValue);

		//----- ●AjcGetProfileH64 -----------------------------------------------------------------------------//
		public static ulong AjcGetProfileH64(string sec, string key, ulong defValue)
		{
			ulong	rc;
			if (Is32Bit()) rc = A32GetProfileH64(sec, key, defValue);
			else		   rc = A64GetProfileH64(sec, key, defValue);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetProfileH64W@16", ExactSpelling=true)]
		private static extern ulong A32GetProfileH64(string pSecName, string pKeyName, ulong defValue);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetProfileH64W", ExactSpelling=true)]
		private static extern ulong A64GetProfileH64(string pSecName, string pKeyName, ulong defValue);

		//----- ●AjcPutProfile --------------------------------------------------------------------------------//
		public static void AjcPutProfile(string sec, string key, int value)
		{
			if (Is32Bit()) A32PutProfile(sec, key, value);
			else		   A64PutProfile(sec, key, value);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcPutProfile(string sec, string key, uint value)
		{
			if (Is32Bit()) A32PutProfile(sec, key, value);
			else		   A64PutProfile(sec, key, value);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcPutProfile(string sec, string key, double value)
		{
			if (Is32Bit()) A32PutProfile(sec, key, value);
			else		   A64PutProfile(sec, key, value);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcPutProfile(string sec, string key, ulong value)
		{
			if (Is32Bit()) A32PutProfile(sec, key, value);
			else		   A64PutProfile(sec, key, value);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void AjcPutProfile(string sec, string key, long value)
		{
			if (Is32Bit()) A32PutProfile(sec, key, value);
			else		   A64PutProfile(sec, key, value);
		}

		//----- ●AjcPutProfileBool ----------------------------------------------------------------------------//
		public static void AjcPutProfileBool(string sec, string key, bool value)
		{
			if (Is32Bit()) A32PutProfileBool(sec, key, value);
			else		   A64PutProfileBool(sec, key, value);
		}

		//----- ●AjcPutProfileUI64 ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileUI64W@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfile(string pSecName, string pKeyName, ulong Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileUI64W", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfile(string pSecName, string pKeyName, ulong Value);

		//----- ●AjcPutProfileSI64 ----------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileSI64W@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfile(string pSecName, string pKeyName, long Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileSI64W", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfile(string pSecName, string pKeyName, long Value);

		//----- ●AjcPutProfileH64 -----------------------------------------------------------------------------//
		public static void AjcPutProfileH64(string sec, string key, ulong value)
		{
			if (Is32Bit()) A32PutProfileH64(sec, key, value);
			else		   A64PutProfileH64(sec, key, value);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPutProfileH64W@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PutProfileH64(string pSecName, string pKeyName, ulong Value);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPutProfileH64W", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PutProfileH64(string pSecName, string pKeyName, ulong Value);

		//----- ●AjcDelProfileSect ----------------------------------------------------------------------------//
		public static void AjcDelProfileSect(string sec)
		{
			if (Is32Bit()) A32DelProfileSect(sec);
			else		   A64DelProfileSect(sec);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcDelProfileSectW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32DelProfileSect(string pSecName);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcDelProfileSectW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64DelProfileSect(string pSecName);

		//----- ●AjcDelProfileKey -----------------------------------------------------------------------------//
		public static void AjcDelProfileKey(string sec, string key)
		{
			if (Is32Bit()) A32DelProfileKey(sec, key);
			else		   A64DelProfileKey(sec, key);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcDelProfileKeyW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32DelProfileKey(string pSecName, string pKeyName);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcDelProfileKeyW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64DelProfileKey(string pSecName, string pKeyName);

		//----- ●AjcRemoveProfileSect -------------------------------------------------------------------------//
		public static void AjcRemoveProfileSect(string sec)
		{
			if (Is32Bit()) A32RemoveProfileSect(sec);
			else		   A64RemoveProfileSect(sec);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRemoveProfileSectW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RemoveProfileSect(string pSecName);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRemoveProfileSectW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RemoveProfileSect(string pSecName);

		//----- ●AjcCleanupProfileSect ------------------------------------------------------------------------//
		public static void AjcCleanupProfileSect(string sec)
		{
			if (Is32Bit()) A32CleanupProfileSect(sec);
			else		   A64CleanupProfileSect(sec);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCleanupProfileSectW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32CleanupProfileSect(string pSecName);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCleanupProfileSectW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64CleanupProfileSect(string pSecName);

		//----- ●AjcCloseProfile ------------------------------------------------------------------------------//
		public static void AjcCloseProfile()
		{
			if (Is32Bit()) A32CloseProfile();
			else		   A64CloseProfile();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcCloseProfile@0", ExactSpelling=true)]
		private static extern void A32CloseProfile();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcCloseProfile", ExactSpelling=true)]
		private static extern void A64CloseProfile();

		//----- ●AjcGetVersion --------------------------------------------------------------------------------//
		public static string AjcGetVersion()
		{
			StringBuilder s = new StringBuilder(128);
			if (Is32Bit()) A32GetVersion(s, s.Capacity);
			else		   A64GetVersion(s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetVersionW@8", ExactSpelling=true)]
		private static extern void A32GetVersion(StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetVersionW", ExactSpelling=true)]
		private static extern void A64GetVersion(StringBuilder pBuf, int lBuf);

		//----- ●AjcMemPeekUB ---------------------------------------------------------------------------------//
		static		  public byte	AjcMemPeekUB(IntPtr pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekUB(pMem)	: CAjrApi.A64MemPeekUB(pMem));}
		static unsafe public byte	AjcMemPeekUB(void*	pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekUB(pMem)	: CAjrApi.A64MemPeekUB(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekUB@4", ExactSpelling=true)]
		public		  static extern byte  A32MemPeekUB(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekUB@4", ExactSpelling=true)]
		public unsafe static extern byte  A32MemPeekUB(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekUB", ExactSpelling=true)]
		public		  static extern byte  A64MemPeekUB(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekUB", ExactSpelling=true)]
		public unsafe static extern byte  A64MemPeekUB(void*  pMem);

		//----- ●AjcMemPeekUW ---------------------------------------------------------------------------------//
		static		  public ushort AjcMemPeekUW(IntPtr pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekUW(pMem)	: CAjrApi.A64MemPeekUW(pMem));}
		static unsafe public ushort AjcMemPeekUW(void*	pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekUW(pMem)	: CAjrApi.A64MemPeekUW(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekUW@4", ExactSpelling=true)]
		public		  static extern ushort A32MemPeekUW(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekUW@4", ExactSpelling=true)]
		public unsafe static extern ushort A32MemPeekUW(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekUW", ExactSpelling=true)]
		public		  static extern ushort A64MemPeekUW(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekUW", ExactSpelling=true)]
		public unsafe static extern ushort A64MemPeekUW(void*  pMem);

		//----- ●AjcMemPeekUL ---------------------------------------------------------------------------------//
		static		  public int	AjcMemPeekUI(IntPtr pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekUI(pMem)	: CAjrApi.A64MemPeekUI(pMem));}
		static unsafe public int	AjcMemPeekUI(void*	pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekUI(pMem)	: CAjrApi.A64MemPeekUI(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekUL@4", ExactSpelling=true)]
		public		  static extern int A32MemPeekUI(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekUL@4", ExactSpelling=true)]
		public unsafe static extern int A32MemPeekUI(void*	pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekUL", ExactSpelling=true)]
		public		  static extern int A64MemPeekUI(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekUL", ExactSpelling=true)]
		public unsafe static extern int A64MemPeekUI(void*	pMem);

		//----- ●AjcMemPeekULL --------------------------------------------------------------------------------//
		static		  public ulong	AjcMemPeekULL(IntPtr pMem) {return (Is32Bit() ? CAjrApi.A32MemPeekULL(pMem) : CAjrApi.A64MemPeekULL(pMem));}
		static unsafe public ulong	AjcMemPeekULL(void*  pMem) {return (Is32Bit() ? CAjrApi.A32MemPeekULL(pMem) : CAjrApi.A64MemPeekULL(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekULL@4", ExactSpelling=true)]
		public		  static extern ulong A32MemPeekULL(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekULL@4", ExactSpelling=true)]
		public unsafe static extern ulong A32MemPeekULL(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekULL", ExactSpelling=true)]
		public		  static extern ulong A64MemPeekULL(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekULL", ExactSpelling=true)]
		public unsafe static extern ulong A64MemPeekULL(void*  pMem);

		//----- ●AjcMemPeekSB ---------------------------------------------------------------------------------//
		static		  public sbyte	AjcMemPeekSB(IntPtr pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekSB(pMem)	: CAjrApi.A64MemPeekSB(pMem));}
		static unsafe public sbyte	AjcMemPeekSB(void*	pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekSB(pMem)	: CAjrApi.A64MemPeekSB(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSB@4", ExactSpelling=true)]
		public		  static extern sbyte A32MemPeekSB(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSB@4", ExactSpelling=true)]
		public unsafe static extern sbyte A32MemPeekSB(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSB", ExactSpelling=true)]
		public		  static extern sbyte A64MemPeekSB(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSB", ExactSpelling=true)]
		public unsafe static extern sbyte A64MemPeekSB(void*  pMem);

		//----- ●AjcMemPeekSW ---------------------------------------------------------------------------------//
		static		  public short	AjcMemPeekSW(IntPtr pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekSW(pMem)	: CAjrApi.A64MemPeekSW(pMem));}
		static unsafe public short	AjcMemPeekSW(void*	pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekSW(pMem)	: CAjrApi.A64MemPeekSW(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSW@4", ExactSpelling=true)]
		public		  static extern short  A32MemPeekSW(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSW@4", ExactSpelling=true)]
		public unsafe static extern short  A32MemPeekSW(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSW", ExactSpelling=true)]
		public		  static extern short  A64MemPeekSW(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSW", ExactSpelling=true)]
		public unsafe static extern short  A64MemPeekSW(void*  pMem);

		//----- ●AjcMemPeekSL ---------------------------------------------------------------------------------//
		static		  public int	AjcMemPeekSI(IntPtr pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekSI(pMem)	: CAjrApi.A64MemPeekSI(pMem));}
		static unsafe public int	AjcMemPeekSI(void*	pMem)  {return (Is32Bit() ? CAjrApi.A32MemPeekSI(pMem)	: CAjrApi.A64MemPeekSI(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSL@4", ExactSpelling=true)]
		public		  static extern int  A32MemPeekSI(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSL@4", ExactSpelling=true)]
		public unsafe static extern int  A32MemPeekSI(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSL", ExactSpelling=true)]
		public		  static extern int  A64MemPeekSI(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSL", ExactSpelling=true)]
		public unsafe static extern int  A64MemPeekSI(void*  pMem);

		//----- ●AjcMemPeekSLL --------------------------------------------------------------------------------//
		static		  public long	AjcMemPeekSLL(IntPtr pMem) {return (Is32Bit() ? CAjrApi.A32MemPeekSLL(pMem) : CAjrApi.A64MemPeekSLL(pMem));}
		static unsafe public long	AjcMemPeekSLL(void*  pMem) {return (Is32Bit() ? CAjrApi.A32MemPeekSLL(pMem) : CAjrApi.A64MemPeekSLL(pMem));}
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSLL@4", ExactSpelling=true)]
		public		  static extern long  A32MemPeekSLL(IntPtr pMem);
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemPeekSLL@4", ExactSpelling=true)]
		public unsafe static extern long  A32MemPeekSLL(void*  pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSLL", ExactSpelling=true)]
		public		  static extern long  A64MemPeekSLL(IntPtr pMem);
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemPeekSLL", ExactSpelling=true)]
		public unsafe static extern long  A64MemPeekSLL(void*  pMem);

		//----- ●AjcMemCopy -----------------------------------------------------------------------------------//
		static unsafe public IntPtr AjcMemCopy(void* pDest, void* pSrc, int len)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = CAjrApi.A32MemCopy(pDest, pSrc, len);
			else		   rc = CAjrApi.A64MemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		static		  public IntPtr AjcMemCopy(IntPtr pDest, IntPtr pSrc, int len)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = CAjrApi.A32MemCopy(pDest, pSrc, len);
			else		   rc = CAjrApi.A64MemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		static unsafe public IntPtr AjcMemCopy(void* pDest, IntPtr pSrc, int len)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = CAjrApi.A32MemCopy(pDest, pSrc, len);
			else		   rc = CAjrApi.A64MemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		static unsafe public IntPtr AjcMemCopy(IntPtr pDest, void* pSrc, int len)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = CAjrApi.A32MemCopy(pDest, pSrc, len);
			else		   rc = CAjrApi.A64MemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		static unsafe public IntPtr AjcMemCopy(ref byte pDest, IntPtr pSrc, int len)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = CAjrApi.A32MemCopy(ref pDest, pSrc, len);
			else		   rc = CAjrApi.A64MemCopy(ref pDest, pSrc, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemCopy@12", ExactSpelling=true)]
		public unsafe static extern IntPtr A32MemCopy(void *pDest	 , void *pSrc , int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemCopy@12", ExactSpelling=true)]
		public		  static extern IntPtr A32MemCopy(IntPtr pDest	 , IntPtr pSrc, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemCopy@12", ExactSpelling=true)]
		public unsafe static extern IntPtr A32MemCopy(void *pDest	 , IntPtr pSrc, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemCopy@12", ExactSpelling=true)]
		public unsafe static extern IntPtr A32MemCopy(IntPtr pDest	 , void* pSrc , int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMemCopy@12", ExactSpelling=true)]
		public unsafe static extern IntPtr A32MemCopy(ref byte pDest , IntPtr pSrc , int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemCopy", ExactSpelling=true)]
		public unsafe static extern IntPtr A64MemCopy(void *pDest, void *pSrc	, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemCopy", ExactSpelling=true)]
		public		  static extern IntPtr A64MemCopy(IntPtr pDest, IntPtr pSrc , int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemCopy", ExactSpelling=true)]
		public unsafe static extern IntPtr A64MemCopy(void *pDest , IntPtr pSrc, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemCopy", ExactSpelling=true)]
		public unsafe static extern IntPtr A64MemCopy(IntPtr pDest , void* pSrc , int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMemCopy", ExactSpelling=true)]
		public unsafe static extern IntPtr A64MemCopy(ref byte pDest , IntPtr pSrc , int len);

		//----- ●AjcWStrLen -----------------------------------------------------------------------------------//
		public static int AjcWStrLen(StringBuilder pStr)
		{
			int	rc;
			if (Is32Bit()) rc = A32WStrLen(pStr);
			else		   rc = A64WStrLen(pStr);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static int AjcWStrLen(IntPtr pStr)
		{
			int	rc;
			if (Is32Bit()) rc = A32WStrLen(pStr);
			else		   rc = A64WStrLen(pStr);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		 unsafe public static int AjcWStrLen(void* pStr)
		{
			int	rc;
			if (Is32Bit()) rc = A32WStrLen(pStr);
			else		   rc = A64WStrLen(pStr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrLen@4", ExactSpelling=true)]
		private static extern int A32WStrLen(StringBuilder pStr);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrLen@4", ExactSpelling=true)]
		private static extern int A32WStrLen(IntPtr pStr);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrLen@4", ExactSpelling=true)]
		unsafe private static extern int A32WStrLen(void *pStr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrLen", ExactSpelling=true)]
		private static extern int A64WStrLen(StringBuilder pStr);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrLen", ExactSpelling=true)]
		private static extern int A64WStrLen(IntPtr pStr);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrLen", ExactSpelling=true)]
		unsafe private static extern int A64WStrLen(void *pStr);

		//----- ●AjcWStrCopy ----------------------------------------------------------------------------------//
		//- - - (IntPtr ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public		  static bool AjcWStrCopy(IntPtr pDest, string pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public		  static bool AjcWStrCopy(IntPtr pDest, StringBuilder pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public		  static bool AjcWStrCopy(IntPtr pDest, IntPtr pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcWStrCopy(IntPtr pDest, void* pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - (void* ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - --------//
		unsafe public static bool AjcWStrCopy(void* pDest, string pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcWStrCopy(void* pDest, StringBuilder pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcWStrCopy(void* pDest, IntPtr pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcWStrCopy(void* pDest, void* pSrc, int lDest)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, lDest);
			else		   rc = A64WStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - (StringBuilder ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public		  static bool AjcWStrCopy(StringBuilder pDest, IntPtr pSrc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, pDest.Capacity);
			else		   rc = A64WStrCopy(pDest, pSrc, pDest.Capacity);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcWStrCopy(StringBuilder pDest, void* pSrc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32WStrCopy(pDest, pSrc, pDest.Capacity);
			else		   rc = A64WStrCopy(pDest, pSrc, pDest.Capacity);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		//- - - (IntPtr ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private 	   static extern bool A32WStrCopy(IntPtr pDest, string		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(IntPtr pDest, StringBuilder pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private 	   static extern bool A32WStrCopy(IntPtr pDest, IntPtr		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(IntPtr pDest, void*		  pSrc, int lDest);
		//- - - (void* ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(void* pDest, string		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(void* pDest, StringBuilder  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(void* pDest, IntPtr		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(void* pDest, void*		  pSrc, int lDest);
		//- - - (StringBuilder ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private 	   static extern bool A32WStrCopy(StringBuilder pDest, IntPtr pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcWStrCopy@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32WStrCopy(StringBuilder pDest, void*  pSrc, int lDest);
		//------------------------------------------------------------------------------------------------------//
		//- - - (IntPtr ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private 	   static extern bool A64WStrCopy(IntPtr pDest, string		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(IntPtr pDest, StringBuilder pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private 	   static extern bool A64WStrCopy(IntPtr pDest, IntPtr		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(IntPtr pDest, void*		  pSrc, int lDest);
		//- - - (void* ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(void* pDest, string		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(void* pDest, StringBuilder  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(void* pDest, IntPtr		  pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(void* pDest, void*		  pSrc, int lDest);
		//- - - (StringBuilder ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private 	   static extern bool A64WStrCopy(StringBuilder pDest, IntPtr pSrc, int lDest);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcWStrCopy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64WStrCopy(StringBuilder pDest, void*  pSrc, int lDest);

		//----- ●AjcByteCharToWideChar ------------------------------------------------------------------------//
		unsafe public static string AjcByteCharToWideChar(void* pSrc)
		{
			int		len;
			if (Is32Bit()) len = A32ByteCharToWideChar(pSrc, null, 0);
			else		   len = A64ByteCharToWideChar(pSrc, null, 0);
			StringBuilder s = new StringBuilder(len);
			if (Is32Bit()) A32ByteCharToWideChar(pSrc, s, s.Capacity);
			else		   A64ByteCharToWideChar(pSrc, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcByteCharToWideChar@12", ExactSpelling=true)]
		unsafe private static extern int A32ByteCharToWideChar(void *pSrc, StringBuilder pDest, int lDest);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcByteCharToWideChar", ExactSpelling=true)]
		unsafe private static extern int A64ByteCharToWideChar(void *pSrc, StringBuilder pDest, int lDest);

		//----- ●AjcCalcRangeStep -----------------------------------------------------------------------------//

		//----- ●AjcMsilEncDblBrkt ----------------------------------------------------------------------------//
		 public static string AjcMsilEncDblBrkt(string fmt)
		{
			StringBuilder s = new StringBuilder(fmt.Length + 1);
			if (Is32Bit()) A32MsilEncDblBrkt(fmt, s);
			else		   A64MsilEncDblBrkt(fmt, s);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilEncDblBrktW@8", ExactSpelling=true)]
		private static extern void A32MsilEncDblBrkt(string pFmt, StringBuilder pBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilEncDblBrktW", ExactSpelling=true)]
		private static extern void A64MsilEncDblBrkt(string pFmt, StringBuilder pBuf);

		//----- ●AjcMsilEncBrkt -------------------------------------------------------------------------------//
		 public static string AjcMsilEncBrkt(string str)
		{
			StringBuilder s = new StringBuilder(str.Length + 1);
			if (Is32Bit()) A32MsilEncBrkt(str, s);
			else		   A64MsilEncBrkt(str, s);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilEncBrktW@8", ExactSpelling=true)]
		private static extern void A32MsilEncBrkt(string pFmt, StringBuilder pBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilEncBrktW", ExactSpelling=true)]
		private static extern void A64MsilEncBrkt(string pFmt, StringBuilder pBuf);

		//----- ●AjcMsilRcvBrkt -------------------------------------------------------------------------------//
		 public static string AjcMsilRcvBrkt(string str)
		{
			StringBuilder s = new StringBuilder(str.Length + 1);
			if (Is32Bit()) A32MsilRcvBrkt(str, s);
			else		   A64MsilRcvBrkt(str, s);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilRcvBrktW@8", ExactSpelling=true)]
		private static extern void A32MsilRcvBrkt(string pFmt, StringBuilder pBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilRcvBrktW", ExactSpelling=true)]
		private static extern void A64MsilRcvBrkt(string pFmt, StringBuilder pBuf);

		//----- ●AjcMsilGetFormatItem -------------------------------------------------------------------------//
		 public static string AjcMsilGetFormatItem(string fmt, out int ix)
		{
			StringBuilder s = new StringBuilder(fmt.Length + 1);
			if (Is32Bit()) ix = A32MsilGetFormatItem(fmt, s);
			else		   ix = A64MsilGetFormatItem(fmt, s);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilGetFormatItemW@8", ExactSpelling=true)]
		private static extern int A32MsilGetFormatItem(string pFmt, StringBuilder pBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilGetFormatItemW", ExactSpelling=true)]
		private static extern int A64MsilGetFormatItem(string pFmt, StringBuilder pBuf);

		//----- ●AjcMsilFormatIxToZero ------------------------------------------------------------------------//
		 public static string AjcMsilFormatIxToZero(string fmt)
		{
			StringBuilder s = new StringBuilder(fmt.Length + 1);
			if (Is32Bit()) A32MsilFormatIxToZero(fmt, s);
			else		   A64MsilFormatIxToZero(fmt, s);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMsilFormatIxToZeroW@8", ExactSpelling=true)]
		private static extern void A32MsilFormatIxToZero(string pFmt, StringBuilder pBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMsilFormatIxToZeroW", ExactSpelling=true)]
		private static extern void A64MsilFormatIxToZero(string pFmt, StringBuilder pBuf);

		//----- ●AjcPtrToString -------------------------------------------------------------------------------//
		public static string		AjcPtrToString(IntPtr pStr)
		{
			string		rc	= null;
			int			len;
			if (pStr != (IntPtr)0) {
				len = AjcPtrToStrLen(pStr);
				StringBuilder s = new StringBuilder(len + 1);
				if (Is32Bit()) A32PtrToString(pStr, s, s.Capacity);
				else		   A64PtrToString(pStr, s, s.Capacity);
				rc = s.ToString();
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPtrToStringW@12", ExactSpelling=true)]
		private static extern void A32PtrToString(IntPtr pStr, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPtrToStringW", ExactSpelling=true)]
		private static extern void A64PtrToString(IntPtr pStr, StringBuilder pBuf, int lBuf);

		//----- ●AjcPtrToStrLen -------------------------------------------------------------------------------//
		public static int		AjcPtrToStrLen(IntPtr pStr)
		{
			int		rc;
			if (Is32Bit()) rc = A32PtrToStrLen(pStr);
			else		   rc = A64PtrToStrLen(pStr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPtrToStrLenW@4", ExactSpelling=true)]
		private static extern int A32PtrToStrLen(IntPtr pStr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPtrToStrLenW", ExactSpelling=true)]
		private static extern int A64PtrToStrLen(IntPtr pStr);

		//======================================================================================================//
		//	AjcMAlloc.h 																						//
		//======================================================================================================//

		//----- ●AjcMAlloc ------------------------------------------------------------------------------------//
		public static IntPtr AjcMAlloc(IntPtr size)
		{
			IntPtr rc;
			if (Is32Bit()) rc = A32MAlloc(size, "dummy32", 32);
			else		   rc = A64MAlloc(size, "dummy64", 64);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMAllocW@12", ExactSpelling=true)]
		private static extern IntPtr A32MAlloc(IntPtr size, string FName, int lno);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMAllocW", ExactSpelling=true)]
		private static extern IntPtr A64MAlloc(IntPtr size, string FName, int lno);

		//----- ●AjcMFree -------------------------------------------------------------------------------------//
		public static IntPtr AjcMFree(IntPtr Addr)
		{
			IntPtr rc;
			if (Is32Bit()) rc = A32MFree(Addr);
			else		   rc = A64MFree(Addr);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcMFree@4", ExactSpelling=true)]
		private static extern IntPtr A32MFree(IntPtr Addr);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcMFree", ExactSpelling=true)]
		private static extern IntPtr A64MFree(IntPtr Addr);

		//----- ●AjcSetMemError -------------------------------------------------------------------------------//
		public static void AjcSetMemError(IntPtr cbp, BinCbkOutOfMemory CbkNtcMemError)
		{
			if (Is32Bit()) A32SetMemError(cbp, CbkNtcMemError);
			else		   A64SetMemError(cbp, CbkNtcMemError);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetMemErrorW@8", ExactSpelling=true)]
		private static extern void A32SetMemError(IntPtr cbp, BinCbkOutOfMemory cbNtcMemError);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetMemErrorW", ExactSpelling=true)]
		private static extern void A64SetMemError(IntPtr cbp, BinCbkOutOfMemory cbNtcMemError);

		//======================================================================================================//
		//	AjcMbxF.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcMbxV.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcMonitorInfo.h																					//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcMsgMap.h 																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcPopupMenu.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcPowMg.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcPrePro.h 																						//
		//======================================================================================================//

		//----- ●AjcPpcCreate ---------------------------------------------------------------------------------//

		//----- ●AjcPpcSetOption ------------------------------------------------------------------------------//
		public static bool	AjcPpcSetOption(IntPtr hPpc, EPpcOption opt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcSetOption(hPpc, opt);
			else		   rc = A64PpcSetOption(hPpc, opt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetOption@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcSetOption(IntPtr hPpc, EPpcOption opt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetOption", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcSetOption(IntPtr hPpc, EPpcOption opt);

		//----- ●AjcPpcGetOption ------------------------------------------------------------------------------//
		public static EPpcOption	AjcPpcGetOption(IntPtr hPpc, EPpcOption opt)
		{
			EPpcOption	rc;
			if (Is32Bit()) rc = A32PpcGetOption(hPpc);
			else		   rc = A64PpcGetOption(hPpc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcGetOption@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern EPpcOption A32PpcGetOption(IntPtr hPpc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcGetOption", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern EPpcOption A64PpcGetOption(IntPtr hPpc);

		//----- ●AjcPpcReleaseObject --------------------------------------------------------------------------//
		public static bool	AjcPpcReleaseObject(IntPtr hPpc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcReleaseObject(hPpc);
			else		   rc = A64PpcReleaseObject(hPpc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcReleaseObject@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcReleaseObject(IntPtr hPpc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcReleaseObject", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcReleaseObject(IntPtr hPpc);

		//----- ●AjcPpcStop -----------------------------------------------------------------------------------//
		public static bool	AjcPpcStop(IntPtr hPpc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcStop(hPpc);
			else		   rc = A64PpcStop(hPpc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcStop@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcStop(IntPtr hPpc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcStop", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcStop(IntPtr hPpc);

		//----- ●AjcPpcTokenStreamToFile ----------------------------------------------------------------------//

		//----- ●AjcPpcSetTecAtTokenStreamToFile --------------------------------------------------------------//
		public static bool	AjcPpcSetTecAtTokenStreamToFile(IntPtr hPpc, ETextEncode tec, EBomMode bom)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcSetTecAtTokenStreamToFile(hPpc, tec, bom);
			else		   rc = A64PpcSetTecAtTokenStreamToFile(hPpc, tec, bom);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetTecAtTokenStreamToFile@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcSetTecAtTokenStreamToFile(IntPtr hPpc, ETextEncode tec, EBomMode bom);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetTecAtTokenStreamToFile", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcSetTecAtTokenStreamToFile(IntPtr hPpc, ETextEncode tec, EBomMode bom);

		//----- ●AjcPpcSetTextEncode --------------------------------------------------------------------------//
		public static bool	AjcPpcSetTextEncode(IntPtr hPpc, ETextEncode tec)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcSetTextEncode(hPpc, tec);
			else		   rc = A64PpcSetTextEncode(hPpc, tec);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetTextEncode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcSetTextEncode(IntPtr hPpc, ETextEncode tec);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetTextEncode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcSetTextEncode(IntPtr hPpc, ETextEncode tec);

		//----- ●AjcPpcGetTextEncode --------------------------------------------------------------------------//
		public static bool	AjcPpcGetTextEncode(IntPtr hPpc, out ETextEncode tec, out EBomMode bom)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcGetTextEncode(hPpc, out tec, out bom);
			else		   rc = A64PpcGetTextEncode(hPpc, out tec, out bom);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcGetTextEncode@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcGetTextEncode(IntPtr hPpc, out ETextEncode tec, out EBomMode bom);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcGetTextEncode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcGetTextEncode(IntPtr hPpc, out ETextEncode tec, out EBomMode bom);

		//----- ●AjcPpcCreateForMSIL --------------------------------------------------------------------------//
		public static IntPtr	AjcPpcCreateForMSIL()
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32PpcCreateForMSIL();
			else		   rc = A64PpcCreateForMSIL();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcCreateForMSIL@0", ExactSpelling=true)]
		private static extern IntPtr A32PpcCreateForMSIL();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64PpcCreateForMSIL();

		//----- ●AjcPpcDeleteForMSIL --------------------------------------------------------------------------//
		public static bool	AjcPpcDeleteForMSIL(IntPtr hPpc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcDeleteForMSIL(hPpc);
			else		   rc = A64PpcDeleteForMSIL(hPpc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcDeleteForMSIL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcDeleteForMSIL(IntPtr hPpc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcDeleteForMSIL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcDeleteForMSIL(IntPtr hPpc);

		//----- ●AjcPpcCompileForMSIL -------------------------------------------------------------------------//
		public static EPpcResult	AjcPpcCompileForMSIL(IntPtr hPpc, string SrcPath)
		{
			EPpcResult	rc;
			if (Is32Bit()) rc = A32PpcCompileForMSIL(hPpc, SrcPath);
			else		   rc = A64PpcCompileForMSIL(hPpc, SrcPath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcCompileForMSIL@8", ExactSpelling=true)]
		private static extern EPpcResult A32PpcCompileForMSIL(IntPtr hPpc, string SrcPath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcCompileForMSIL", ExactSpelling=true)]
		private static extern EPpcResult A64PpcCompileForMSIL(IntPtr hPpc, string SrcPath);

		//----- ●AjcPpcTokenStreamToFileForMSIL ---------------------------------------------------------------//
		public static bool	AjcPpcTokenStreamToFileForMSIL(IntPtr hPpc, string OutPath, bool fExpInc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcTokenStreamToFileForMSIL(hPpc, OutPath, fExpInc, (int)EPpcComItem.ALL);
			else		   rc = A64PpcTokenStreamToFileForMSIL(hPpc, OutPath, fExpInc, (int)EPpcComItem.ALL);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcTokenStreamToFileForMSIL@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcTokenStreamToFileForMSIL(IntPtr hPpc, string OutPath, bool fExpInc, int CommOutOfkndPP);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcTokenStreamToFileForMSIL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcTokenStreamToFileForMSIL(IntPtr hPpc, string OutPath, bool fExpInc, int CommOutOfkndPP);

		//----- ●AjcPpcSetBasePath ----------------------------------------------------------------------------//
		public static bool	AjcPpcSetBasePath(IntPtr hPpc, string BasePath)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcSetBasePath(hPpc, BasePath);
			else		   rc = A64PpcSetBasePath(hPpc, BasePath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetBasePath@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcSetBasePath(IntPtr hPpc, string BasePath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetBasePath", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcSetBasePath(IntPtr hPpc, string BasePath);

		//----- ●AjcPpcIncPathReset ---------------------------------------------------------------------------//
		public static bool	AjcPpcIncPathReset(IntPtr hPpc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcIncPathReset(hPpc);
			else		   rc = A64PpcIncPathReset(hPpc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcIncPathReset@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcIncPathReset(IntPtr hPpc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcIncPathReset", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcIncPathReset(IntPtr hPpc);

		//----- ●AjcPpcIncPathCreate --------------------------------------------------------------------------//
		public static bool	AjcPpcIncPathCreate(IntPtr hPpc, int n)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcIncPathCreate(hPpc, n);
			else		   rc = A64PpcIncPathCreate(hPpc, n);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcIncPathCreate@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcIncPathCreate(IntPtr hPpc, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcIncPathCreate", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcIncPathCreate(IntPtr hPpc, int n);

		//----- ●AjcPpcIncPathSet -----------------------------------------------------------------------------//
		public static bool	AjcPpcIncPathSet(IntPtr hPpc, int ix, string IncPath)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcIncPathSet(hPpc, ix, IncPath);
			else		   rc = A64PpcIncPathSet(hPpc, ix, IncPath);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcIncPathSet@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcIncPathSet(IntPtr hPpc, int ix, string IncPath);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcIncPathSet", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcIncPathSet(IntPtr hPpc, int ix, string IncPath);

		//----- ●AjcPpcOptSymReset ----------------------------------------------------------------------------//
		public static bool	AjcPpcOptSymReset(IntPtr hPpc)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcOptSymReset(hPpc);
			else		   rc = A64PpcOptSymReset(hPpc);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcOptSymReset@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcOptSymReset(IntPtr hPpc);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcOptSymReset", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcOptSymReset(IntPtr hPpc);

		//----- ●AjcPpcOptSymCreate ---------------------------------------------------------------------------//
		public static bool	AjcPpcOptSymCreate(IntPtr hPpc, int n)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcOptSymCreate(hPpc, n);
			else		   rc = A64PpcOptSymCreate(hPpc, n);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcOptSymCreate@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcOptSymCreate(IntPtr hPpc, int n);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcOptSymCreate", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcOptSymCreate(IntPtr hPpc, int n);

		//----- ●AjcPpcOptSymSet ------------------------------------------------------------------------------//
		public static bool	AjcPpcOptSymSet(IntPtr hPpc, int ix, string OptSym)
		{
			bool	rc;
			if (Is32Bit()) rc = A32PpcOptSymSet(hPpc, ix, OptSym);
			else		   rc = A64PpcOptSymSet(hPpc, ix, OptSym);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcOptSymSet@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32PpcOptSymSet(IntPtr hPpc, int ix, string OptSym);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcOptSymSet", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64PpcOptSymSet(IntPtr hPpc, int ix, string OptSym);

		//----- ●AjcPpcSetCbNtcAnyEvt -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcAnyEvt(IntPtr hPpc, PpcCbkNtcAnyEvt cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcAnyEvt(hPpc, cb);
			else		   A64PpcSetCbNtcAnyEvt(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcAnyEvt@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcAnyEvt(IntPtr hPpc, PpcCbkNtcAnyEvt cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcAnyEvt", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcAnyEvt(IntPtr hPpc, PpcCbkNtcAnyEvt cb);

		//----- ●AjcPpcSetCbNtcFileLno ------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcFileLno(IntPtr hPpc, PpcCbkNtcFileLno cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcFileLno(hPpc, cb);
			else		   A64PpcSetCbNtcFileLno(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcFileLno@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcFileLno(IntPtr hPpc, PpcCbkNtcFileLno cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcFileLno", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcFileLno(IntPtr hPpc, PpcCbkNtcFileLno cb);

		//----- ●AjcPpcSetCbNtcSrhStart -----------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcSrhStart(IntPtr hPpc, PpcCbkNtcSrhStart cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcSrhStart(hPpc, cb);
			else		   A64PpcSetCbNtcSrhStart(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcSrhStart@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcSrhStart(IntPtr hPpc, PpcCbkNtcSrhStart cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcSrhStart", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcSrhStart(IntPtr hPpc, PpcCbkNtcSrhStart cb);

		//----- ●AjcPpcSetCbNtcSrhDir -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcSrhDir(IntPtr hPpc, PpcCbkNtcSrhDir cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcSrhDir(hPpc, cb);
			else		   A64PpcSetCbNtcSrhDir(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcSrhDir@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcSrhDir(IntPtr hPpc, PpcCbkNtcSrhDir cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcSrhDir", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcSrhDir(IntPtr hPpc, PpcCbkNtcSrhDir cb);

		//----- ●AjcPpcSetCbNtcSrhEnd -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcSrhEnd(IntPtr hPpc, PpcCbkNtcSrhEnd cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcSrhEnd(hPpc, cb);
			else		   A64PpcSetCbNtcSrhEnd(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcSrhEnd@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcSrhEnd(IntPtr hPpc, PpcCbkNtcSrhEnd cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcSrhEnd", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcSrhEnd(IntPtr hPpc, PpcCbkNtcSrhEnd cb);

		//----- ●AjcPpcSetCbNtcOptSym -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcOptSym(IntPtr hPpc, PpcCbkNtcOptSym cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcOptSym(hPpc, cb);
			else		   A64PpcSetCbNtcOptSym(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcOptSym@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcOptSym(IntPtr hPpc, PpcCbkNtcOptSym cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcOptSym", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcOptSym(IntPtr hPpc, PpcCbkNtcOptSym cb);

		//----- ●AjcPpcSetCbNtcMacDef -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcMacDef(IntPtr hPpc, PpcCbkNtcMacDef cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcMacDef(hPpc, cb);
			else		   A64PpcSetCbNtcMacDef(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcMacDef@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcMacDef(IntPtr hPpc, PpcCbkNtcMacDef cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcMacDef", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcMacDef(IntPtr hPpc, PpcCbkNtcMacDef cb);

		//----- ●AjcPpcSetCbNtcMacRef -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcMacRef(IntPtr hPpc, PpcCbkNtcMacRef cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcMacRef(hPpc, cb);
			else		   A64PpcSetCbNtcMacRef(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcMacRef@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcMacRef(IntPtr hPpc, PpcCbkNtcMacRef cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcMacRef", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcMacRef(IntPtr hPpc, PpcCbkNtcMacRef cb);

		//----- ●AjcPpcSetCbNtcOutput -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcOutput(IntPtr hPpc, PpcCbkNtcOutput cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcOutput(hPpc, cb);
			else		   A64PpcSetCbNtcOutput(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcOutput@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcOutput(IntPtr hPpc, PpcCbkNtcOutput cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcOutput", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcOutput(IntPtr hPpc, PpcCbkNtcOutput cb);

		//----- ●AjcPpcSetCbNtcSrcTec -------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcSrcTec(IntPtr hPpc, PpcCbkNtcSrcTec cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcSrcTec(hPpc, cb);
			else		   A64PpcSetCbNtcSrcTec(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcSrcTec@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcSrcTec(IntPtr hPpc, PpcCbkNtcSrcTec cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcSrcTec", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcSrcTec(IntPtr hPpc, PpcCbkNtcSrcTec cb);

		//----- ●AjcPpcSetCbNtcError --------------------------------------------------------------------------//
		public static void	AjcPpcSetCbNtcError(IntPtr hPpc, PpcCbkNtcError cb)
		{
			if (Is32Bit()) A32PpcSetCbNtcError(hPpc, cb);
			else		   A64PpcSetCbNtcError(hPpc, cb);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcSetCbNtcError@8", ExactSpelling=true)]
		private static extern void A32PpcSetCbNtcError(IntPtr hPpc, PpcCbkNtcError cb);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcSetCbNtcError", ExactSpelling=true)]
		private static extern void A64PpcSetCbNtcError(IntPtr hPpc, PpcCbkNtcError cb);

		//----- ●AjcPpcGetErrMsgTextForMSIL -------------------------------------------------------------------//
		public static string	AjcPpcGetErrMsgTextForMSIL()
		{
			StringBuilder s = new StringBuilder(1024);
			if (Is32Bit()) A32PpcGetErrMsgTextForMSIL(s, (int)s.Capacity);
			else		   A64PpcGetErrMsgTextForMSIL(s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcPpcGetErrMsgTextForMSIL@8", ExactSpelling=true)]
		private static extern void A32PpcGetErrMsgTextForMSIL(StringBuilder buf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcPpcGetErrMsgTextForMSIL", ExactSpelling=true)]
		private static extern void A64PpcGetErrMsgTextForMSIL(StringBuilder buf, int lBuf);

		//======================================================================================================//
		//	AjcPrinter.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcProcessMem.h 																					//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcQueF.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcQueV.h																							//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcRegFile.h																						//
		//======================================================================================================//

		//----- ●AjcSetRegTopKey ------------------------------------------------------------------------------//
		public static void AjcSetRegTopKey(EAjcHKey hKey)
		{
			if (Is32Bit()) A32SetRegTopKey((IntPtr)hKey);
			else		   A64SetRegTopKey((IntPtr)hKey);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSetRegTopKey@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern void A32SetRegTopKey(IntPtr hKey);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSetRegTopKey", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern void A64SetRegTopKey(IntPtr hKey);

		//----- ●AjcGetRegTopKey ------------------------------------------------------------------------------//
		public static EAjcHKey AjcGetRegTopKey()
		{
			EAjcHKey rc;
			if (Is32Bit()) rc = A32GetRegTopKey();
			else		   rc = A64GetRegTopKey();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcGetRegTopKey@0", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern EAjcHKey A32GetRegTopKey();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcGetRegTopKey", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern EAjcHKey A64GetRegTopKey();

		//----- ●AjcRegHkCuEnvGet -----------------------------------------------------------------------------//
		public static string AjcRegHkCuEnvGet(string name, out ERegType type)
		{
			StringBuilder s = new StringBuilder(1024);
			if (Is32Bit()) A32RegHkCuEnvGet(name, out type, s, (int)s.Capacity);
			else		   A64RegHkCuEnvGet(name, out type, s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvGetW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvGet(string name, out ERegType type, StringBuilder s, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvGetW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvGet(string name, out ERegType type, StringBuilder s, int len);

		//----- ●AjcRegHkLmEnvGet -----------------------------------------------------------------------------//
		public static string AjcRegHkLmEnvGet(string name, out ERegType type)
		{
			StringBuilder s = new StringBuilder(1024);
			if (Is32Bit()) A32RegHkLmEnvGet(name, out type, s, (int)s.Capacity);
			else		   A64RegHkLmEnvGet(name, out type, s, (int)s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvGetW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvGet(string name, out ERegType type, StringBuilder s, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvGetW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvGet(string name, out ERegType type, StringBuilder s, int len);

		//----- ●AjcRegHkCuEnvPut -----------------------------------------------------------------------------//
		public static bool AjcRegHkCuEnvPut(string name, ERegType type, string text)
		{
			bool	rc = false;
			if (Is32Bit()) rc = A32RegHkCuEnvPut(name, type, text);
			else		   rc = A64RegHkCuEnvPut(name, type, text);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvPutW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvPut(string name, ERegType type, string text);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvPutW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvPut(string name, ERegType type, string text);

		//----- ●AjcRegHkLmEnvPut -----------------------------------------------------------------------------//
		public static bool AjcRegHkLmEnvPut(string name, ERegType type, string text)
		{
			bool	rc = false;
			if (Is32Bit()) rc = A32RegHkLmEnvPut(name, type, text);
			else		   rc = A64RegHkLmEnvPut(name, type, text);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvPutW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvPut(string name, ERegType type, string text);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvPutW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvPut(string name, ERegType type, string text);

		//----- ●AjcRegHkCuEnvDel -----------------------------------------------------------------------------//
		public static bool AjcRegHkCuEnvDel(string name)
		{
			bool	rc = false;
			if (Is32Bit()) rc = A32RegHkCuEnvDel(name);
			else		   rc = A64RegHkCuEnvDel(name);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvDelW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvDel(string name);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvDelW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvDel(string name);

		//----- ●AjcRegHkLmEnvDel -----------------------------------------------------------------------------//
		public static bool AjcRegHkLmEnvDel(string name)
		{
			bool	rc = false;
			if (Is32Bit()) rc = A32RegHkLmEnvDel(name);
			else		   rc = A64RegHkLmEnvDel(name);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvDelW@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvDel(string name);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvDelW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvDel(string name);

		//----- ●AjcRegHkCuEnvAddItem -------------------------------------------------------------------------//
		public static bool AjcRegHkCuEnvAddItem(string name, string item, char dlm, bool fFront, ERegType type)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkCuEnvAddItem(name, item, dlm, fFront, type);
			else		   rc = A64RegHkCuEnvAddItem(name, item, dlm, fFront, type);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvAddItemW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvAddItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvAddItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvAddItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);

		//----- ●AjcRegHkLmEnvAddItem -------------------------------------------------------------------------//
		public static bool AjcRegHkLmEnvAddItem(string name, string item, char dlm, bool fFront, ERegType type)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkLmEnvAddItem(name, item, dlm, fFront, type);
			else		   rc = A64RegHkLmEnvAddItem(name, item, dlm, fFront, type);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvAddItemW@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvAddItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvAddItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvAddItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);

		//----- ●AjcRegHkCuEnvAddPathItem ---------------------------------------------------------------------//
		public static bool AjcRegHkCuEnvAddPathItem(string path, bool fFront, ERegType type)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkCuEnvAddPathItem(path, fFront, type);
			else		   rc = A64RegHkCuEnvAddPathItem(path, fFront, type);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvAddPathItemW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvAddPathItem(string path, [MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvAddPathItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvAddPathItem(string path,[MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);

		//----- ●AjcRegHkLmEnvAddPathItem ---------------------------------------------------------------------//
		public static bool AjcRegHkLmEnvAddPathItem(string path, bool fFront, ERegType type)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkLmEnvAddPathItem(path, fFront, type);
			else		   rc = A64RegHkLmEnvAddPathItem(path, fFront, type);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvAddPathItemW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvAddPathItem(string path, [MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvAddPathItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvAddPathItem(string path,[MarshalAs(UnmanagedType.Bool)] bool fFront, ERegType type);

		//----- ●AjcRegHkCuEnvDelItem -------------------------------------------------------------------------//
		public static bool AjcRegHkCuEnvDelItem(string name, string item, char dlm, bool fErase)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkCuEnvDelItem(name, item, dlm, fErase);
			else		   rc = A64RegHkCuEnvDelItem(name, item, dlm, fErase);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvDelItemW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvDelItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fErase);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvDelItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvDelItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fErase);

		//----- ●AjcRegHkLmEnvDelItem -------------------------------------------------------------------------//
		public static bool AjcRegHkLmEnvDelItem(string name, string item, char dlm, bool fErase)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkLmEnvDelItem(name, item, dlm, fErase);
			else		   rc = A64RegHkLmEnvDelItem(name, item, dlm, fErase);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvDelItemW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvDelItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fErase);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvDelItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvDelItem(string name, string item, char dlm, [MarshalAs(UnmanagedType.Bool)] bool fErase);

		//----- ●AjcRegHkCuEnvDelPathItem ---------------------------------------------------------------------//
		public static bool AjcRegHkCuEnvDelPathItem(string path, bool fErase)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkCuEnvDelPathItem(path, fErase);
			else		   rc = A64RegHkCuEnvDelPathItem(path, fErase);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkCuEnvDelPathItemW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkCuEnvDelPathItem(string path, [MarshalAs(UnmanagedType.Bool)] bool fErase);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkCuEnvDelPathItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkCuEnvDelPathItem(string path,[MarshalAs(UnmanagedType.Bool)] bool fErase);

		//----- ●AjcRegHkLmEnvDelPathItem ---------------------------------------------------------------------//
		public static bool AjcRegHkLmEnvDelPathItem(string path, bool fErase)
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegHkLmEnvDelPathItem(path, fErase);
			else		   rc = A64RegHkLmEnvDelPathItem(path, fErase);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegHkLmEnvDelPathItemW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegHkLmEnvDelPathItem(string path, [MarshalAs(UnmanagedType.Bool)] bool fErase);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegHkLmEnvDelPathItemW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegHkLmEnvDelPathItem(string path,[MarshalAs(UnmanagedType.Bool)] bool fErase);

		//----- ●AjcRegEnableEnvironment ---------------------------------------------------------------------//
		public static bool AjcRegEnableEnvironment()
		{
			bool	rc;
			if (Is32Bit()) rc = A32RegEnableEnvironment();
			else		   rc = A64RegEnableEnvironment();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcRegEnableEnvironment@0", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32RegEnableEnvironment();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcRegEnableEnvironment", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64RegEnableEnvironment();

		//======================================================================================================//
		//	AjcRingBuf.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcSbcComboBox.h																					//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcSbcRadioBtns.h																					//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcSepStream.h																						//
		//======================================================================================================//

		//======================================================================================================//
		//	AjcSerialComPort.h																					//
		//======================================================================================================//

		//----- ●AjcScpCreate ---------------------------------------------------------------------------------//
		public static IntPtr AjcScpCreate()
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32ScpCreate();
			else		   rc = A64ScpCreate();
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpCreateW@0", ExactSpelling=true)]
		private static extern IntPtr A32ScpCreate();
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpCreateW", ExactSpelling=true)]
		private static extern IntPtr A64ScpCreate();

		//----- ●AjcScpDelete ---------------------------------------------------------------------------------//
		public static bool AjcScpDelete(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpDelete(hScp);
			else		   rc = A64ScpDelete(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpDelete@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpDelete(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpDelete", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpDelete(IntPtr hScp);

		//----- ●AjcScpSetMode --------------------------------------------------------------------------------//
		public static bool AjcScpSetMode(IntPtr hScp, IntPtr hWndNtc, int WndMsgNtc, bool fTextChunk)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetMode(hScp, hWndNtc, WndMsgNtc, fTextChunk);
			else		   rc = A64ScpSetMode(hScp, hWndNtc, WndMsgNtc, fTextChunk);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetMode@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetMode(IntPtr hScp, IntPtr hWndNtc, int WndMsgNtc, [MarshalAs(UnmanagedType.Bool)] bool fTextChunk);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetMode(IntPtr hScp, IntPtr hWndNtc, int WndMsgNtc, [MarshalAs(UnmanagedType.Bool)] bool fTextChunk);

		//----- ●AjcScpOpen -----------------------------------------------------------------------------------//
		public static bool AjcScpOpen(IntPtr hScp, int Port, int Rate, int DataBits, int Parity, int StopBit)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpOpen(hScp, Port, Rate, DataBits, Parity, StopBit);
			else		   rc = A64ScpOpen(hScp, Port, Rate, DataBits, Parity, StopBit);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpOpen@24", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpOpen(IntPtr hScp, int Port, int Rate, int DataBits, int Parity, int StopBit);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpOpen", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpOpen(IntPtr hScp, int Port, int Rate, int DataBits, int Parity, int StopBit);

		//----- ●AjcScpOpenEx ---------------------------------------------------------------------------------//
		public static bool AjcScpOpenEx(IntPtr hScp, int Port, IntPtr pDcb, IntPtr pTmo)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpOpenEx(hScp, Port, pDcb, pTmo);
			else		   rc = A64ScpOpenEx(hScp, Port, pDcb, pTmo);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpOpenEx@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpOpenEx(IntPtr hScp, int Port, IntPtr pDcb, IntPtr pTmo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpOpenEx", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpOpenEx(IntPtr hScp, int Port, IntPtr pDcb, IntPtr pTmo);

		//----- ●AjcScpOpenSlot -------------------------------------------------------------------------------//
		public static bool AjcScpOpenSlot(IntPtr hScp, string pRemoteHostName, string pRemoteSlotName)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpOpenSlot(hScp, pRemoteHostName, pRemoteSlotName);
			else		   rc = A64ScpOpenSlot(hScp, pRemoteHostName, pRemoteSlotName);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpOpenSlotW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpOpenSlot(IntPtr hScp, string pHost, string pSlot);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpOpenSlotW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpOpenSlot(IntPtr hScp, string pHost, string pSlot);

		//----- ●AjcScpOpenSock -------------------------------------------------------------------------------//
		public static bool AjcScpOpenSock(IntPtr hScp, string pServName, uint PortNo)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpOpenSock(hScp, pServName, PortNo);
			else		   rc = A64ScpOpenSock(hScp, pServName, PortNo);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpOpenSockW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpOpenSock(IntPtr hScp, string pHost, uint PortNo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpOpenSockW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpOpenSock(IntPtr hScp, string pHost, uint PortNo);

		//----- ●AjcScpOpenDefault ----------------------------------------------------------------------------//
		public static bool AjcScpOpenDefault(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpOpenDefault(hScp);
			else		   rc = A64ScpOpenDefault(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpOpenDefault@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpOpenDefault(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpOpenDefault", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpOpenDefault(IntPtr hScp);

		//----- ●AjcScpOpenSelect -----------------------------------------------------------------------------//
		public static bool AjcScpOpenSelect(IntPtr hScp, int sel)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpOpenSelect(hScp, sel);
			else		   rc = A64ScpOpenSelect(hScp, sel);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpOpenSelect@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpOpenSelect(IntPtr hScp, int sel);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpOpenSelect", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpOpenSelect(IntPtr hScp, int sel);

		//----- ●AjcScpClose ----------------------------------------------------------------------------------//
		public static bool AjcScpClose(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpClose(hScp);
			else		   rc = A64ScpClose(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpClose@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpClose(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpClose", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpClose(IntPtr hScp);

		//----- ●AjcScpGetSelectedPort ------------------------------------------------------------------------//
		public static int AjcScpGetSelectedPort(IntPtr hScp)
		{
			int	rc;
			if (Is32Bit()) rc = A32ScpGetSelectedPort(hScp);
			else		   rc = A64ScpGetSelectedPort(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetSelectedPort@4", ExactSpelling=true)]
		private static extern int A32ScpGetSelectedPort(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetSelectedPort", ExactSpelling=true)]
		private static extern int A64ScpGetSelectedPort(IntPtr hScp);

		//----- ●AjcScpIsOpened -------------------------------------------------------------------------------//
		public static int AjcScpIsOpened(IntPtr hScp)
		{
			int	rc;
			if (Is32Bit()) rc = A32ScpIsOpened(hScp);
			else		   rc = A64ScpIsOpened(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpIsOpened@4", ExactSpelling=true)]
		private static extern int A32ScpIsOpened(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpIsOpened", ExactSpelling=true)]
		private static extern int A64ScpIsOpened(IntPtr hScp);

		//----- ●AjcScpSendChar -------------------------------------------------------------------------------//
		public static bool AjcScpSendChar(IntPtr hScp, byte code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendCharA(hScp, code);
			else		   rc = A64ScpSendCharA(hScp, code);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcScpSendChar(IntPtr hScp, ushort code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendCharW(hScp, code);
			else		   rc = A64ScpSendCharW(hScp, code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendCharA@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendCharA(IntPtr hScp, byte code);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendCharW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendCharW(IntPtr hScp, ushort code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendCharA", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendCharA(IntPtr hScp, byte code);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendCharW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendCharW(IntPtr hScp, ushort code);

		//----- ●AjcScpSendWord14LF ---------------------------------------------------------------------------//
		public static bool AjcScpSendWord14LF(IntPtr hScp, int code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendWord14LF(hScp, code);
			else		   rc = A64ScpSendWord14LF(hScp, code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendWord14LF@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendWord14LF(IntPtr hScp, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendWord14LF", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendWord14LF(IntPtr hScp, int code);

		//----- ●AjcScpSendWord14HF ---------------------------------------------------------------------------//
		public static bool AjcScpSendWord14HF(IntPtr hScp, int code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendWord14HF(hScp, code);
			else		   rc = A64ScpSendWord14HF(hScp, code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendWord14HF@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendWord14HF(IntPtr hScp, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendWord14HF", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendWord14HF(IntPtr hScp, int code);

		//----- ●AjcScpSetByteSeqRxWord14 ---------------------------------------------------------------------//
		public static bool AjcScpSetByteSeqRxWord14(IntPtr hScp, EScpByteSeq ByteSequence)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetByteSeqRxWord14(hScp, ByteSequence);
			else		   rc = A64ScpSetByteSeqRxWord14(hScp, ByteSequence);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetByteSeqRxWord14@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetByteSeqRxWord14(IntPtr hScp, EScpByteSeq code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetByteSeqRxWord14", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetByteSeqRxWord14(IntPtr hScp, EScpByteSeq code);

		//----- ●AjcScpGetByteSeqRxWord14 ---------------------------------------------------------------------//
		public static EScpByteSeq AjcScpGetByteSeqRxWord14(IntPtr hScp)
		{
			EScpByteSeq	rc;
			if (Is32Bit()) rc = A32ScpGetByteSeqRxWord14(hScp);
			else		   rc = A64ScpGetByteSeqRxWord14(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetByteSeqRxWord14@4", ExactSpelling=true)]
		private static extern EScpByteSeq A32ScpGetByteSeqRxWord14(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetByteSeqRxWord14", ExactSpelling=true)]
		private static extern EScpByteSeq A64ScpGetByteSeqRxWord14(IntPtr hScp);

		//----- ●AjcScpSendText -------------------------------------------------------------------------------//
		public static bool AjcScpSendText(IntPtr hScp, string pTxt, int lTxt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendText(hScp, pTxt, lTxt);
			else		   rc = A64ScpSendText(hScp, pTxt, lTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendTextW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendText(IntPtr hScp, string pTxt, int lTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendTextW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendText(IntPtr hScp, string pTxt, int lTxt);

		//----- ●AjcScpSendBinData ----------------------------------------------------------------------------//
		public static bool AjcScpSendBinData(IntPtr hScp, Byte[] bin)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendBinData(hScp, ref bin[0], bin.Length);
			else		   rc = A64ScpSendBinData(hScp, ref bin[0], bin.Length);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcScpSendBinData(IntPtr hScp, void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendBinData(hScp, p, len);
			else		   rc = A64ScpSendBinData(hScp, p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcScpSendBinData(IntPtr hScp, IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendBinData(hScp, p, len);
			else		   rc = A64ScpSendBinData(hScp, p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendBinData@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendBinData(IntPtr hScp, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendBinData@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ScpSendBinData(IntPtr hScp, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendBinData@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendBinData(IntPtr hScp, IntPtr p, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendBinData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendBinData(IntPtr hScp, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendBinData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ScpSendBinData(IntPtr hScp, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendBinData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendBinData(IntPtr hScp, IntPtr p, int len);

		//----- ●AjcScpSendPacket -----------------------------------------------------------------------------//
		unsafe public static int AjcScpSendPacket(IntPtr hScp, Byte[] bin)
		{
			int	rc;
			fixed (void* p = &bin[0]) {
				if (Is32Bit()) rc = A32ScpSendPacket(hScp, ref bin[0], bin.Length);
				else		   rc = A64ScpSendPacket(hScp, ref bin[0], bin.Length);
			}
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static int AjcScpSendPacket(IntPtr hScp, void *p, int len)
		{
			int	rc;
			if (Is32Bit()) rc = A32ScpSendPacket(hScp, p, len);
			else		   rc = A64ScpSendPacket(hScp, p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static int AjcScpSendPacket(IntPtr hScp, IntPtr p, int len)
		{
			int	rc;
			if (Is32Bit()) rc = A32ScpSendPacket(hScp, p, len);
			else		   rc = A64ScpSendPacket(hScp, p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendPacket@12", ExactSpelling=true)]
		private static extern int A32ScpSendPacket(IntPtr hScp, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendPacket@12", ExactSpelling=true)]
		unsafe private static extern int A32ScpSendPacket(IntPtr hScp, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendPacket@12", ExactSpelling=true)]
		private static extern int A32ScpSendPacket(IntPtr hScp, IntPtr p, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendPacket", ExactSpelling=true)]
		private static extern int A64ScpSendPacket(IntPtr hScp, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendPacket", ExactSpelling=true)]
		unsafe private static extern int A64ScpSendPacket(IntPtr hScp, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendPacket", ExactSpelling=true)]
		private static extern int A64ScpSendPacket(IntPtr hScp, IntPtr p, int len);

		//----- ●AjcScpSendBreak ------------------------------------------------------------------------------//
		public static bool AjcScpSendBreak(IntPtr hScp, bool fBreak)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSendBreak(hScp, fBreak);
			else		   rc = A64ScpSendBreak(hScp, fBreak);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSendBreak@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSendBreak(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fBreak);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSendBreak", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSendBreak(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fBreak);

		//----- ●AjcScpSetEvtMask -----------------------------------------------------------------------------//
		public static bool AjcScpSetEvtMask(IntPtr hScp, int evt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetEvtMask(hScp, (int)evt);
			else		   rc = A64ScpSetEvtMask(hScp, (int)evt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetEvtMask@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetEvtMask(IntPtr hScp, int Mask);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetEvtMask", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetEvtMask(IntPtr hScp, int Mask);

		//----- ●AjcScpGetEvtMask -----------------------------------------------------------------------------//
		public static EScpEvt AjcScpGetEvtMask(IntPtr hScp)
		{
			EScpEvt	rc;
			if (Is32Bit()) rc = (EScpEvt)A32ScpGetEvtMask(hScp);
			else		   rc = (EScpEvt)A64ScpGetEvtMask(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetEvtMask@4", ExactSpelling=true)]
		private static extern int A32ScpGetEvtMask(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetEvtMask", ExactSpelling=true)]
		private static extern int A64ScpGetEvtMask(IntPtr hScp);

		//----- ●AjcScpSetDTR ---------------------------------------------------------------------------------//
		public static bool AjcScpSetDTR(IntPtr hScp, bool fActive)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetDTR(hScp, fActive);
			else		   rc = A64ScpSetDTR(hScp, fActive);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetDTR@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetDTR(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fActive);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetDTR", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetDTR(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fActive);

		//----- ●AjcScpSetRTS ---------------------------------------------------------------------------------//
		public static bool AjcScpSetRTS(IntPtr hScp, bool fActive)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetRTS(hScp, fActive);
			else		   rc = A64ScpSetRTS(hScp, fActive);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetRTS@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetRTS(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fActive);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetRTS", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetRTS(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fActive);

		//----- ●AjcScpGetSigState ----------------------------------------------------------------------------//
		public static int AjcScpGetSigState(IntPtr hScp)
		{
			int	rc;
			if (Is32Bit()) rc = A32ScpGetSigState(hScp);
			else		   rc = A64ScpGetSigState(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetSigState@4", ExactSpelling=true)]
		private static extern int A32ScpGetSigState(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetSigState", ExactSpelling=true)]
		private static extern int A64ScpGetSigState(IntPtr hScp);

		//----- ●AjcScpPurgeRecvData --------------------------------------------------------------------------//
		public static bool AjcScpPurgeRecvData(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpPurgeRecvData(hScp);
			else		   rc = A64ScpPurgeRecvData(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpPurgeRecvData@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpPurgeRecvData(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpPurgeRecvData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpPurgeRecvData(IntPtr hScp);

		//----- ●AjcScpPurgeSendData --------------------------------------------------------------------------//
		public static bool AjcScpPurgeSendData(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpPurgeSendData(hScp);
			else		   rc = A64ScpPurgeSendData(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpPurgeSendData@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpPurgeSendData(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpPurgeSendData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpPurgeSendData(IntPtr hScp);

		//----- ●AjcScpPurgeAllData ---------------------------------------------------------------------------//
		public static bool AjcScpPurgeAllData(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpPurgeAllData(hScp);
			else		   rc = A64ScpPurgeAllData(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpPurgeAllData@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpPurgeAllData(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpPurgeAllData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpPurgeAllData(IntPtr hScp);

		//----- ●AjcScpSetParam -------------------------------------------------------------------------------//

		//----- ●AjcScpWaitEvent ------------------------------------------------------------------------------//
		unsafe public static bool AjcScpWaitEvent(IntPtr hScp, ref IntPtr wParam, ref IntPtr lParam, int msTime)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpWaitEvent(hScp, ref wParam, ref lParam, msTime);
			else		   rc = A64ScpWaitEvent(hScp, ref wParam, ref lParam, msTime);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpWaitEvent@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ScpWaitEvent(IntPtr hScp, ref IntPtr wParam, ref IntPtr lParam, int msTime);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpWaitEvent", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ScpWaitEvent(IntPtr hScp, ref IntPtr wParam, ref IntPtr lParam, int msTime);

		//----- ●AjcScpGetEventData ---------------------------------------------------------------------------//
		unsafe public static bool AjcScpGetEventData(IntPtr hScp, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpGetEventData(hScp, lParam, out pDat, out lDat, out Param);
			else		   rc = A64ScpGetEventData(hScp, lParam, out pDat, out lDat, out Param);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetEventData@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32ScpGetEventData(IntPtr hScp, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetEventData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64ScpGetEventData(IntPtr hScp, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param);

		//----- ●AjcScpRelEventData ---------------------------------------------------------------------------//
		public static bool AjcScpRelEventData(IntPtr hScp, IntPtr lParam)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpRelEventData(hScp, lParam);
			else		   rc = A64ScpRelEventData(hScp, lParam);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpRelEventData@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpRelEventData(IntPtr hScp, IntPtr lParam);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpRelEventData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpRelEventData(IntPtr hScp, IntPtr lParam);

		//----- ●AjcScpSetPktCtrlCode -------------------------------------------------------------------------//
		public static bool AjcScpSetPktCtrlCode(IntPtr hScp, int stx, int etx, int dle)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetPktCtrlCode(hScp, stx, etx, dle);
			else		   rc = A64ScpSetPktCtrlCode(hScp, stx, etx, dle);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetPktCtrlCode@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetPktCtrlCode(IntPtr hScp, int stx, int etx, int dle);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetPktCtrlCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetPktCtrlCode(IntPtr hScp, int stx, int etx, int dle);

		//----- ●AjcScpSetPktTimeout --------------------------------------------------------------------------//
		public static bool AjcScpSetPktTimeout(IntPtr hScp, int msTime)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetPktTimeout(hScp, msTime);
			else		   rc = A64ScpSetPktTimeout(hScp, msTime);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetPktTimeout@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetPktTimeout(IntPtr hScp, int msTime);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetPktTimeout", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetPktTimeout(IntPtr hScp, int msTime);

		//----- ●AjcScpEnablePortSelectionEx ------------------------------------------------------------------//
		public static bool AjcScpEnablePortSelectionEx(IntPtr hScp, bool fEnableComPort, bool fEnableMailSlot, bool fEnableSocket)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpEnablePortSelectionEx(hScp, fEnableComPort, fEnableMailSlot, fEnableSocket);
			else		   rc = A64ScpEnablePortSelectionEx(hScp, fEnableComPort, fEnableMailSlot, fEnableSocket);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpEnablePortSelectionEx@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpEnablePortSelectionEx(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fEnableComPort,
																		   [MarshalAs(UnmanagedType.Bool)] bool fEnableMailSlot,
																		   [MarshalAs(UnmanagedType.Bool)] bool fEnablSocket);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpEnablePortSelectionEx", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpEnablePortSelectionEx(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fEnableComPort,
																		   [MarshalAs(UnmanagedType.Bool)] bool fEnableMailSlot,
																		   [MarshalAs(UnmanagedType.Bool)] bool fEnableSocket);

		//----- ●AjcScpDlgParamEasy ---------------------------------------------------------------------------//
		public static bool AjcScpDlgParamEasy(IntPtr hScp, IntPtr hWndOwner)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpDlgParamEasy(hScp, hWndOwner);
			else		   rc = A64ScpDlgParamEasy(hScp, hWndOwner);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpDlgParamEasy@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpDlgParamEasy(IntPtr hScp, IntPtr hWndOwner);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpDlgParamEasy", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpDlgParamEasy(IntPtr hScp, IntPtr hWndOwner);

		//----- ●AjcScpDlgParamDetail -------------------------------------------------------------------------//
		public static bool AjcScpDlgParamDetail(IntPtr hScp, IntPtr hWndOwner)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpDlgParamDetail(hScp, hWndOwner);
			else		   rc = A64ScpDlgParamDetail(hScp, hWndOwner);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpDlgParamDetail@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpDlgParamDetail(IntPtr hScp, IntPtr hWndOwner);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpDlgParamDetail", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpDlgParamDetail(IntPtr hScp, IntPtr hWndOwner);

		//----- ●AjcScpDlgParamDetailEx -----------------------------------------------------------------------//

		//----- ●AjcScpSetDialogGrayMask ----------------------------------------------------------------------//
		public static bool AjcScpSetDialogGrayMask(IntPtr hScp, int mskGray)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetDialogGrayMask(hScp, mskGray);
			else		   rc = A64ScpSetDialogGrayMask(hScp, mskGray);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetDialogGrayMask@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetDialogGrayMask(IntPtr hScp, int mskGray);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetDialogGrayMask", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetDialogGrayMask(IntPtr hScp, int mskGray);

		//----- ●AjcScpGetDefaultParam ------------------------------------------------------------------------//
		public static void AjcScpGetDefaultParam(IntPtr pDcb, IntPtr pTmo)
		{
			if (Is32Bit()) A32ScpGetDefaultParam(pDcb, pTmo);
			else		   A64ScpGetDefaultParam(pDcb, pTmo);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetDefaultParam@8", ExactSpelling=true)]
		private static extern void A32ScpGetDefaultParam(IntPtr pDcb, IntPtr pTmo);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetDefaultParam", ExactSpelling=true)]
		private static extern void A64ScpGetDefaultParam(IntPtr pDcb, IntPtr pTmo);

		//----- ●AjcScpGetSsepHandle --------------------------------------------------------------------------//
		public static IntPtr AjcScpGetSsepHandle(IntPtr hScp)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32ScpGetSsepHandle(hScp);
			else		   rc = A64ScpGetSsepHandle(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetSsepHandle@4", ExactSpelling=true)]
		private static extern IntPtr A32ScpGetSsepHandle(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetSsepHandle", ExactSpelling=true)]
		private static extern IntPtr A64ScpGetSsepHandle(IntPtr hScp);

		//----- ●AjcScpGetPortPathName ------------------------------------------------------------------------//
		public static IntPtr AjcScpGetPortPathName(IntPtr hScp)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32ScpGetPortPathName(hScp);
			else		   rc = A64ScpGetPortPathName(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetPortPathNameW@4", ExactSpelling=true)]
		private static extern IntPtr A32ScpGetPortPathName(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetPortPathNameW", ExactSpelling=true)]
		private static extern IntPtr A64ScpGetPortPathName(IntPtr hScp);

		//----- ●AjcScpGetPortName ----------------------------------------------------------------------------//
		public static IntPtr AjcScpGetPortName(IntPtr hScp)
		{
			IntPtr	rc;
			if (Is32Bit()) rc = A32ScpGetPortName(hScp);
			else		   rc = A64ScpGetPortName(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetPortNameW@4", ExactSpelling=true)]
		private static extern IntPtr A32ScpGetPortName(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetPortNameW", ExactSpelling=true)]
		private static extern IntPtr A64ScpGetPortName(IntPtr pW);

		//----- ●AjcScpGetPortDevName -------------------------------------------------------------------------//
		public static string AjcScpGetPortDevName(string ComPortName)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetPortDevName(ComPortName, s, s.Capacity);
			else		   A64ScpGetPortDevName(ComPortName, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetPortDevNameW@12", ExactSpelling=true)]
		private static extern IntPtr A32ScpGetPortDevName(string ComPortName, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetPortDevNameW", ExactSpelling=true)]
		private static extern IntPtr A64ScpGetPortDevName(string ComPortName, StringBuilder pBuf, int lBuf);

		//----- ●AjcScpSetChunkMode ---------------------------------------------------------------------------//
		public static bool AjcScpSetChunkMode(IntPtr hScp, EScpChunkMode ChunkMode)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetChunkMode(hScp, ChunkMode);
			else		   rc = A64ScpSetChunkMode(hScp, ChunkMode);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetChunkMode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetChunkMode(IntPtr hScp, EScpChunkMode ChunkMode);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetChunkMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetChunkMode(IntPtr hScp, EScpChunkMode ChunkMode);

		//----- ●AjcScpGetChunkMode ---------------------------------------------------------------------------//
		public static EScpChunkMode AjcScpGetChunkMode(IntPtr hScp)
		{
			EScpChunkMode	rc;
			if (Is32Bit()) rc = A32ScpGetChunkMode(hScp);
			else		   rc = A64ScpGetChunkMode(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetChunkMode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern EScpChunkMode A32ScpGetChunkMode(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetChunkMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern EScpChunkMode A64ScpGetChunkMode(IntPtr hScp);

		//----- ●AjcScpSetRxTextCode --------------------------------------------------------------------------//
		public static bool AjcScpSetRxTextCode(IntPtr hScp, EScpRxTextCode code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetRxTextCode(hScp, (int)code);
			else		   rc = A64ScpSetRxTextCode(hScp, (int)code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetRxTextCode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetRxTextCode(IntPtr hScp, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetRxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetRxTextCode(IntPtr hScp, int code);

		//----- ●AjcScpGetRxTextCode --------------------------------------------------------------------------//

		//----- ●AjcScpGetActualRxTextCode --------------------------------------------------------------------------//
		public static EScpRxTextCode AjcScpGetActualRxTextCode(IntPtr hScp)
		{
			EScpRxTextCode	rc;
			if (Is32Bit()) rc = A32ScpGetActualRxTextCode(hScp);
			else		   rc = A64ScpGetActualRxTextCode(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetActualRxTextCode@4", ExactSpelling=true)]
		private static extern EScpRxTextCode A32ScpGetActualRxTextCode(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetActualRxTextCode", ExactSpelling=true)]
		private static extern EScpRxTextCode A64ScpGetActualRxTextCode(IntPtr hScp);

		//----- ●AjcScpGetActualTxTextCode --------------------------------------------------------------------------//
		public static EScpTxTextCode AjcScpGetActualTxTextCode(IntPtr hScp)
		{
			EScpTxTextCode	rc;
			if (Is32Bit()) rc = A32ScpGetActualTxTextCode(hScp);
			else		   rc = A64ScpGetActualTxTextCode(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetActualTxTextCode@4", ExactSpelling=true)]
		private static extern EScpTxTextCode A32ScpGetActualTxTextCode(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetActualTxTextCode", ExactSpelling=true)]
		private static extern EScpTxTextCode A64ScpGetActualTxTextCode(IntPtr hScp);

		//----- ●AjcScpSetTxTextCode --------------------------------------------------------------------------//
		public static bool AjcScpSetTxTextCode(IntPtr hScp, EScpTxTextCode code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetTxTextCode(hScp, (int)code);
			else		   rc = A64ScpSetTxTextCode(hScp, (int)code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetTxTextCode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetTxTextCode(IntPtr hScp, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetTxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetTxTextCode(IntPtr hScp, int code);

		//----- ●AjcScpCreateMySlot ---------------------------------------------------------------------------//
		public static bool AjcScpCreateMySlot(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpCreateMySlot(hScp);
			else		   rc = A64ScpCreateMySlot(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpCreateMySlot@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpCreateMySlot(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpCreateMySlot", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpCreateMySlot(IntPtr hScp);

		//----- ●AjcScpDeleteMySlot ---------------------------------------------------------------------------//
		public static bool AjcScpDeleteMySlot(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpDeleteMySlot(hScp);
			else		   rc = A64ScpDeleteMySlot(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpDeleteMySlot@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpDeleteMySlot(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpDeleteMySlot", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpDeleteMySlot(IntPtr hScp);

		//----- ●AjcScpMySlotIsCreated ------------------------------------------------------------------------//
		public static bool AjcScpMySlotIsCreated(IntPtr hScp)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpMySlotIsCreated(hScp);
			else		   rc = A64ScpMySlotIsCreated(hScp);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpMySlotIsCreated@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpMySlotIsCreated(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpMySlotIsCreated", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpMySlotIsCreated(IntPtr hScp);

		//----- ●AjcScpSetMailSlotNames -----------------------------------------------------------------------//
		public static bool AjcScpSetMailSlotNames(IntPtr hScp, string pMySlot, string pRmtHost, string pRmtSlot)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetMailSlotNames(hScp, pMySlot, pRmtHost, pRmtSlot);
			else		   rc = A64ScpSetMailSlotNames(hScp, pMySlot, pRmtHost, pRmtSlot);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetMailSlotNamesW@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetMailSlotNames(IntPtr hScp, string pMySlot, string pRmtHost, string pRmtSlot);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetMailSlotNamesW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetMailSlotNames(IntPtr hScp, string pMySlot, string pRmtHost, string pRmtSlot);

		//----- ●AjcScpSetTxSpeedLimit ------------------------------------------------------------------------//
		public static bool AjcScpSetTxSpeedLimit(IntPtr hScp, bool flag, int bps)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetTxSpeedLimit(hScp, flag, bps);
			else		   rc = A64ScpSetTxSpeedLimit(hScp, flag, bps);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetTxSpeedLimit@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetTxSpeedLimit(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)]bool flag, int bps);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetTxSpeedLimit", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetTxSpeedLimit(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)]bool flag, int bps);

		//----- ●AjcScpGetTxSpeedLimit ------------------------------------------------------------------------//
		public static bool AjcScpGetTxSpeedLimit(IntPtr hScp, out int bps)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpGetTxSpeedLimit(hScp, out bps);
			else		   rc = A64ScpGetTxSpeedLimit(hScp, out bps);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetTxSpeedLimit@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpGetTxSpeedLimit(IntPtr hScp, out int bps);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetTxSpeedLimit", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpGetTxSpeedLimit(IntPtr hScp, out int bps);

		//----- ●AjcScpLoadParamFromProfile -------------------------------------------------------------------//
		public static bool AjcScpLoadParamFromProfile(IntPtr hScp, string pSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpLoadParamFromProfile(hScp, pSect);
			else		   rc = A64ScpLoadParamFromProfile(hScp, pSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpLoadParamFromProfileW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpLoadParamFromProfile(IntPtr hScp, string pSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpLoadParamFromProfileW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpLoadParamFromProfile(IntPtr hScp, string pSect);

		//----- ●AjcScpSaveParamToProfile ---------------------------------------------------------------------//
		public static bool AjcScpSaveParamToProfile(IntPtr hScp, string pSect)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSaveParamToProfile(hScp, pSect);
			else		   rc = A64ScpSaveParamToProfile(hScp, pSect);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSaveParamToProfileW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSaveParamToProfile(IntPtr hScp, string pSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSaveParamToProfileW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSaveParamToProfile(IntPtr hScp, string pSect);

		//----- ●AjcScpCreateForMSIL --------------------------------------------------------------------------//
		unsafe public static IntPtr AjcScpCreateForMSIL(ScpCbkPortState  CbkPortState ,
														ScpCbkRxChunkTxt CbkRxChunkTxt,
														ScpCbkRxChunkBin CbkRxChunkBin,
														ScpCbkRxText	 CbkRxText	  ,
														ScpCbkRxEsc 	 CbkRxEsc	  ,
														ScpCbkRxCtrl	 CbkRxCtrl	  ,
														ScpCbkRxPacket	 CbkRxPacket  ,
														ScpCbkTxEmpty	 CbkTxEmpty	  ,
														ScpCbkRxNoPkt	 CbkRxNoPkt	  ,
														ScpCbkRxWord14	 CbkRxWord14  ,
														ScpCbkRxInvChunk CbkRxInvChunk,
														ScpCbkError 	 CbkError	  ,
														ScpCbkNtcRING	 CbkNtcRING	  ,
														ScpCbkNtcRLSD	 CbkNtcRLSD	  ,
														ScpCbkNtcDSR	 CbkNtcDSR	  ,
														ScpCbkNtcCTS	 CbkNtcCTS	  )
		{
			IntPtr	rc;
			if (Is32Bit()) {
				rc = A32ScpCreateForMSIL(CbkPortState, CbkRxChunkTxt, CbkRxChunkBin , CbkRxText ,
													   CbkRxEsc 	, CbkRxCtrl 	, CbkRxPacket	, CbkTxEmpty,
													   CbkRxNoPkt	, CbkRxWord14	, CbkRxInvChunk , CbkError	,
													   CbkNtcRING	, CbkNtcRLSD	,CbkNtcDSR	, CbkNtcCTS );
			}
			else {
				rc = A64ScpCreateForMSIL(CbkPortState, CbkRxChunkTxt, CbkRxChunkBin , CbkRxText ,
													   CbkRxEsc 	, CbkRxCtrl 	, CbkRxPacket	, CbkTxEmpty, 
													   CbkRxNoPkt	, CbkRxWord14	, CbkRxInvChunk , CbkError	 , 
													   CbkNtcRING	, CbkNtcRLSD	, CbkNtcDSR , CbkNtcCTS );
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpCreateForMSIL@64", ExactSpelling=true)]
		private static extern IntPtr A32ScpCreateForMSIL(	ScpCbkPortState  cbPortState ,
															ScpCbkRxChunkTxt cbRxChunkTxt,
															ScpCbkRxChunkBin cbRxChunkBin,
															ScpCbkRxText	 cbRxText	 ,
															ScpCbkRxEsc 	 cbRxEsc	 ,
															ScpCbkRxCtrl	 cbRxCtrl	 ,
															ScpCbkRxPacket	 cbRxPacket  ,
															ScpCbkTxEmpty	 cbTxEmpty	 ,
															ScpCbkRxNoPkt	 cbRxNoPkt	 ,
															ScpCbkRxWord14	 cbRxWord14	 ,
															ScpCbkRxInvChunk cbRxInvChunk,
															ScpCbkError 	 cbError	 ,
															ScpCbkNtcRING	 cbNtcRING	 ,
															ScpCbkNtcRLSD	 cbNtcRLSD	 ,
															ScpCbkNtcDSR	 cbNtcDSR	 ,
															ScpCbkNtcCTS	 cbNtcCTS	 );
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64ScpCreateForMSIL(	ScpCbkPortState  cbPortState ,
															ScpCbkRxChunkTxt cbRxChunkTxt,
															ScpCbkRxChunkBin cbRxChunkBin,
															ScpCbkRxText	 cbRxText	 ,
															ScpCbkRxEsc 	 cbRxEsc	 ,
															ScpCbkRxCtrl	 cbRxCtrl	 ,
															ScpCbkRxPacket	 cbRxPacket  ,
															ScpCbkTxEmpty	 cbTxEmpty	 ,
															ScpCbkRxNoPkt	 cbRxNoPkt	 ,
															ScpCbkRxWord14	 cbRxWord14	 ,
															ScpCbkRxInvChunk cbRxInvChunk,
															ScpCbkError 	 cbError	 ,
															ScpCbkNtcRING	 cbNtcRING	 ,
															ScpCbkNtcRLSD	 cbNtcRLSD	 ,
															ScpCbkNtcDSR	 cbNtcDSR	 ,
															ScpCbkNtcCTS	 cbNtcCTS	 );

		//----- ●AjcScpCreateMySlotForMSIL --------------------------------------------------------------------//
		public static void AjcScpCreateMySlotForMSIL(IntPtr hScp)
		{
			if (Is32Bit()) A32ScpCreateMySlotForMSIL(hScp);
			else		   A64ScpCreateMySlotForMSIL(hScp);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpCreateMySlotForMSIL@4", ExactSpelling=true)]
		private static extern void A32ScpCreateMySlotForMSIL(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpCreateMySlotForMSIL", ExactSpelling=true)]
		private static extern void A64ScpCreateMySlotForMSIL(IntPtr hScp);

		//----- ●AjcScpSetModeForMSIL -------------------------------------------------------------------------//
		public static bool AjcScpSetModeForMSIL(IntPtr hScp, bool fEventMode)
		{
			bool	rc;
			if (Is32Bit()) rc = A32ScpSetModeForMSIL(hScp, fEventMode);
			else		   rc = A64ScpSetModeForMSIL(hScp, fEventMode);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetModeForMSIL@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32ScpSetModeForMSIL(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fEventMode);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetModeForMSIL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64ScpSetModeForMSIL(IntPtr hScp, [MarshalAs(UnmanagedType.Bool)] bool fEventMode);

		//----- ●AjcScpGetPortNameForMSIL ---------------------------------------------------------------------//
		public static string AjcScpGetPortNameForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetPortNameForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetPortNameForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetPortNameForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetPortNameForMSIL(IntPtr hScp, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetPortNameForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetPortNameForMSIL(IntPtr hScp, StringBuilder pBuf, int lBuf);

		//----- ●AjcScpGetPortPathNameForMSIL -----------------------------------------------------------------//
		public static string AjcScpGetPortPathNameForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetPortPathNameForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetPortPathNameForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetPortPathNameForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetPortPathNameForMSIL(IntPtr hScp, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetPortPathNameForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetPortPathNameForMSIL(IntPtr hScp,StringBuilder pBuf,int lBuf);

		//----- ●AjcScpGetMySlotPathNameForMSIL ---------------------------------------------------------------//
		public static string AjcScpGetMySlotPathNameForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetMySlotPathNameForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetMySlotPathNameForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetMySlotPathNameForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetMySlotPathNameForMSIL(IntPtr hScp, StringBuilder pBuf, int lBuf);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetMySlotPathNameForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetMySlotPathNameForMSIL(IntPtr hScp,StringBuilder pBuf,int lBuf);

		//----- ●AjcScpDeleteForMSIL --------------------------------------------------------------------------//
		public static void AjcScpDeleteForMSIL(IntPtr hScp)
		{
			if (Is32Bit()) A32ScpDeleteForMSIL(hScp);
			else		   A64ScpDeleteForMSIL(hScp);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpDeleteForMSIL@4", ExactSpelling=true)]
		private static extern void A32ScpDeleteForMSIL(IntPtr hScp);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpDeleteForMSIL", ExactSpelling=true)]
		private static extern void A64ScpDeleteForMSIL(IntPtr hScp);

		//----- ●AjcScpSetProfileSectForMSIL ------------------------------------------------------------------//
		public static void AjcScpSetProfileSectForMSIL(IntPtr hScp, string pSect)
		{
			if (Is32Bit()) A32ScpSetProfileSectForMSIL(hScp, pSect);
			else		   A64ScpSetProfileSectForMSIL(hScp, pSect);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetProfileSectForMSIL@8", ExactSpelling=true)]
		private static extern void A32ScpSetProfileSectForMSIL(IntPtr hScp, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetProfileSectForMSIL", ExactSpelling=true)]
		private static extern void A64ScpSetProfileSectForMSIL(IntPtr hScp, string pProfileSect);

		//----- ●AjcScpGetProfileSectForMSIL ------------------------------------------------------------------//
		public static string AjcScpGetProfileSectForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetProfileSectForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetProfileSectForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetProfileSectForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetProfileSectForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetProfileSectForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetProfileSectForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);

		//----- ●AjcScpSetMySlotForMSIL -----------------------------------------------------------------------//
		public static void AjcScpSetMySlotForMSIL(IntPtr hScp, string MySlot)
		{
			if (Is32Bit()) A32ScpSetMySlotForMSIL(hScp, MySlot);
			else		   A64ScpSetMySlotForMSIL(hScp, MySlot);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetMySlotForMSIL@8", ExactSpelling=true)]
		private static extern void A32ScpSetMySlotForMSIL(IntPtr hScp, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetMySlotForMSIL", ExactSpelling=true)]
		private static extern void A64ScpSetMySlotForMSIL(IntPtr hScp, string pProfileSect);

		//----- ●AjcScpGetMySlotForMSIL -----------------------------------------------------------------------//
		public static string AjcScpGetMySlotForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetMySlotForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetMySlotForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetMySlotForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetMySlotForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetMySlotForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetMySlotForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);

		//----- ●AjcScpSetRmtHostForMSIL ----------------------------------------------------------------------//
		public static void AjcScpSetRmtHostForMSIL(IntPtr hScp, string RmtHost)
		{
			if (Is32Bit()) A32ScpSetRmtHostForMSIL(hScp, RmtHost);
			else		   A64ScpSetRmtHostForMSIL(hScp, RmtHost);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetRmtHostForMSIL@8", ExactSpelling=true)]
		private static extern void A32ScpSetRmtHostForMSIL(IntPtr hScp, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetRmtHostForMSIL", ExactSpelling=true)]
		private static extern void A64ScpSetRmtHostForMSIL(IntPtr hScp, string pProfileSect);

		//----- ●AjcScpGetRmtHostForMSIL ----------------------------------------------------------------------//
		public static string AjcScpGetRmtHostForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetRmtHostForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetRmtHostForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetRmtHostForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetRmtHostForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetRmtHostForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetRmtHostForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);

		//----- ●AjcScpSetRmtSlotForMSIL ----------------------------------------------------------------------//
		public static void AjcScpSetRmtSlotForMSIL(IntPtr hScp, string RmtSlot)
		{
			if (Is32Bit()) A32ScpSetRmtSlotForMSIL(hScp, RmtSlot);
			else		   A64ScpSetRmtSlotForMSIL(hScp, RmtSlot);
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpSetRmtSlotForMSIL@8", ExactSpelling=true)]
		private static extern void A32ScpSetRmtSlotForMSIL(IntPtr hScp, string pProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpSetRmtSlotForMSIL", ExactSpelling=true)]
		private static extern void A64ScpSetRmtSlotForMSIL(IntPtr hScp, string pProfileSect);

		//----- ●AjcScpGetRmtSlotForMSIL ----------------------------------------------------------------------//
		public static string AjcScpGetRmtSlotForMSIL(IntPtr hScp)
		{
			StringBuilder s = new StringBuilder(512);
			if (Is32Bit()) A32ScpGetRmtSlotForMSIL(hScp, s, s.Capacity);
			else		   A64ScpGetRmtSlotForMSIL(hScp, s, s.Capacity);
			return s.ToString();
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcScpGetRmtSlotForMSIL@12", ExactSpelling=true)]
		private static extern void A32ScpGetRmtSlotForMSIL(IntPtr hScp, StringBuilder pProfileSect, int lProfileSect);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcScpGetRmtSlotForMSIL", ExactSpelling=true)]
		private static extern void A64ScpGetRmtSlotForMSIL(IntPtr hSct, StringBuilder pProfileSect, int lProfileSect);

		//======================================================================================================//
		//	AjcSockClient.h 																					//
		//======================================================================================================//

		//----- ●AjcSctCreate ---------------------------------------------------------------------------------//

		//----- ●AjcSctDelete ---------------------------------------------------------------------------------//

		//----- ●AjcSctDisconnectEx ---------------------------------------------------------------------------//
		public static bool AjcSctDisconnectEx(IntPtr hSct, int msTimeout)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctDisconnectEx(hSct, msTimeout);
			else		   rc = A64SctDisconnectEx(hSct, msTimeout);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctDisconnectEx@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctDisconnectEx(IntPtr hSct, int msTimeout);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctDisconnectEx", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctDisconnectEx(IntPtr hSct, int msTimeout);

		//----- ●AjcSctGetState ---------------------------------------------------------------------------//
		public static ESctState AjcSctGetState(IntPtr hSct)
		{
			ESctState	rc;
			if (Is32Bit()) rc = A32SctGetState(hSct);
			else		   rc = A64SctGetState(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetState@4", ExactSpelling=true)]
		private static extern ESctState A32SctGetState(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetState", ExactSpelling=true)]
		private static extern ESctState A64SctGetState(IntPtr hSct);

		//----- ●AjcSctSetChunkMode ---------------------------------------------------------------------------//
		public static bool AjcSctSetChunkMode(IntPtr hSct, ESctChunkMode ChunkMode)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSetChunkMode(hSct, ChunkMode);
			else		   rc = A64SctSetChunkMode(hSct, ChunkMode);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSetChunkMode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSetChunkMode(IntPtr hSct, ESctChunkMode ChunkMode);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSetChunkMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSetChunkMode(IntPtr hSct, ESctChunkMode ChunkMode);

		//----- ●AjcSctGetChunkMode ---------------------------------------------------------------------------//
		public static ESctChunkMode AjcSctGetChunkMode(IntPtr hSct)
		{
			ESctChunkMode	rc;
			if (Is32Bit()) rc = A32SctGetChunkMode(hSct);
			else		   rc = A64SctGetChunkMode(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetChunkMode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ESctChunkMode A32SctGetChunkMode(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetChunkMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ESctChunkMode A64SctGetChunkMode(IntPtr hSct);

		//----- ●AjcSctSetEvtMask -----------------------------------------------------------------------------//
		public static bool AjcSctSetEvtMask(IntPtr hSct, ESctEvt evt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSetEvtMask(hSct, evt);
			else		   rc = A64SctSetEvtMask(hSct, evt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSetEvtMask@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSetEvtMask(IntPtr hSct, ESctEvt Mask);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSetEvtMask", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSetEvtMask(IntPtr hSct, ESctEvt Mask);

		//----- ●AjcSctGetEvtMask -----------------------------------------------------------------------------//
		public static ESctEvt AjcSctGetEvtMask(IntPtr hSct)
		{
			ESctEvt	rc;
			if (Is32Bit()) rc = (ESctEvt)A32SctGetEvtMask(hSct);
			else		   rc = (ESctEvt)A64SctGetEvtMask(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetEvtMask@4", ExactSpelling=true)]
		private static extern int A32SctGetEvtMask(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetEvtMask", ExactSpelling=true)]
		private static extern int A64SctGetEvtMask(IntPtr hSct);

		//----- ●AjcSctSetRxTextCode --------------------------------------------------------------------------//
		public static bool AjcSctSetRxTextCode(IntPtr hSct, ESctRxTextCode code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSetRxTextCode(hSct, (int)code);
			else		   rc = A64SctSetRxTextCode(hSct, (int)code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSetRxTextCode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSetRxTextCode(IntPtr hSct, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSetRxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSetRxTextCode(IntPtr hSct, int code);

		//----- ●AjcSctGetRxTextCode --------------------------------------------------------------------------//
		public static ESctRxTextCode AjcSctGetRxTextCode(IntPtr hSct)
		{
			ESctRxTextCode	rc;
			if (Is32Bit()) rc = (ESctRxTextCode)A32SctGetRxTextCode(hSct);
			else		   rc = (ESctRxTextCode)A64SctGetRxTextCode(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetRxTextCode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A32SctGetRxTextCode(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetRxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A64SctGetRxTextCode(IntPtr hSct);

		//----- ●AjcSctGetActualRxTextCode --------------------------------------------------------------------------//
		public static ESctRxTextCode AjcSctGetActualRxTextCode(IntPtr hSct)
		{
			ESctRxTextCode	rc;
			if (Is32Bit()) rc = A32SctGetActualRxTextCode(hSct);
			else		   rc = A64SctGetActualRxTextCode(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetActualRxTextCode@4", ExactSpelling=true)]
		private static extern ESctRxTextCode A32SctGetActualRxTextCode(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetActualRxTextCode", ExactSpelling=true)]
		private static extern ESctRxTextCode A64SctGetActualRxTextCode(IntPtr hSct);

		//----- ●AjcSctGetActualTxTextCode --------------------------------------------------------------------------//
		public static ESctTxTextCode AjcSctGetActualTxTextCode(IntPtr hSct)
		{
			ESctTxTextCode	rc;
			if (Is32Bit()) rc = A32SctGetActualTxTextCode(hSct);
			else		   rc = A64SctGetActualTxTextCode(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetActualTxTextCode@4", ExactSpelling=true)]
		private static extern ESctTxTextCode A32SctGetActualTxTextCode(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetActualTxTextCode", ExactSpelling=true)]
		private static extern ESctTxTextCode A64SctGetActualTxTextCode(IntPtr hSct);

		//----- ●AjcSctSetTxTextCode --------------------------------------------------------------------------//
		public static bool AjcSctSetTxTextCode(IntPtr hSct, ESctTxTextCode code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSetTxTextCode(hSct, (int)code);
			else		   rc = A64SctSetTxTextCode(hSct, (int)code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSetTxTextCode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSetTxTextCode(IntPtr hSct, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSetTxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSetTxTextCode(IntPtr hSct, int code);

		//----- ●AjcSctGetTxTextCode --------------------------------------------------------------------------//
		public static ESctTxTextCode AjcSctGetTxTextCode(IntPtr hSct)
		{
			ESctTxTextCode	rc;
			if (Is32Bit()) rc = (ESctTxTextCode)A32SctGetTxTextCode(hSct);
			else		   rc = (ESctTxTextCode)A64SctGetTxTextCode(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetTxTextCode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A32SctGetTxTextCode(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetTxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A64SctGetTxTextCode(IntPtr hSct);

		//----- ●AjcSctWaitEvent ------------------------------------------------------------------------------//
		public static bool AjcSctWaitEvent(IntPtr hSct, ref IntPtr wParam, ref IntPtr lParam, int msTime)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctWaitEvent(hSct, ref wParam, ref lParam, msTime);
			else		   rc = A64SctWaitEvent(hSct, ref wParam, ref lParam, msTime);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctWaitEvent@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SctWaitEvent(IntPtr hSct, ref IntPtr wParam, ref IntPtr lParam, int msTime);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctWaitEvent", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SctWaitEvent(IntPtr hSct, ref IntPtr wParam, ref IntPtr lParam, int msTime);

		//----- ●AjcSctGetEventData ---------------------------------------------------------------------------//
		unsafe public static bool AjcSctGetEventData(IntPtr hSct, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctGetEventData(hSct, lParam, out pDat, out lDat, out Param);
			else		   rc = A64SctGetEventData(hSct, lParam, out pDat, out lDat, out Param);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctGetEventData@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SctGetEventData(IntPtr hSct, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctGetEventData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SctGetEventData(IntPtr hSct, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param);

		//----- ●AjcSctRelEventData ---------------------------------------------------------------------------//
		public static bool AjcSctRelEventData(IntPtr hSct, IntPtr lParam)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctRelEventData(hSct, lParam);
			else		   rc = A64SctRelEventData(hSct, lParam);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctRelEventData@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctRelEventData(IntPtr hSct, IntPtr lParam);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctRelEventData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctRelEventData(IntPtr hSct, IntPtr lParam);

		//----- ●AjcSctSetPktCtrlCode -------------------------------------------------------------------------//
		public static bool AjcSctSetPktCtrlCode(IntPtr hSct, int stx, int etx, int dle)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSetPktCtrlCode(hSct, stx, etx, dle);
			else		   rc = A64SctSetPktCtrlCode(hSct, stx, etx, dle);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSetPktCtrlCode@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSetPktCtrlCode(IntPtr hSct, int stx, int etx, int dle);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSetPktCtrlCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSetPktCtrlCode(IntPtr hSct, int stx, int etx, int dle);

		//----- ●AjcSctGetPktCtrlCode -------------------------------------------------------------------------//

		//----- ●AjcSctSetPktTimeout --------------------------------------------------------------------------//
		public static bool AjcSctSetPktTimeout(IntPtr hSct, int msTime)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSetPktTimeout(hSct, msTime);
			else		   rc = A64SctSetPktTimeout(hSct, msTime);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSetPktTimeout@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSetPktTimeout(IntPtr hSct, int msTime);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSetPktTimeout", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSetPktTimeout(IntPtr hSct, int msTime);

		//----- ●AjcSctGetPktTimeout --------------------------------------------------------------------------//

		//----- ●AjcSctSendChar -------------------------------------------------------------------------------//
		public static bool AjcSctSendChar(IntPtr hSct, byte code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSendCharA(hSct, code);
			else		   rc = A64SctSendCharA(hSct, code);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcSctSendChar(IntPtr hSct, int code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSendCharW(hSct, (ushort)code);
			else		   rc = A64SctSendCharW(hSct, (ushort)code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendCharA@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSendCharA(IntPtr hSct, byte code);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendCharW@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSendCharW(IntPtr hSct, ushort code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendCharA", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSendCharA(IntPtr hSct, byte code);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendCharW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSendCharW(IntPtr hSct, ushort code);

		//----- ●AjcSctSendText -------------------------------------------------------------------------------//
		public static bool AjcSctSendText(IntPtr hSct, string pTxt, int lTxt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSendText(hSct, pTxt, lTxt);
			else		   rc = A64SctSendText(hSct, pTxt, lTxt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendTextW@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSendText(IntPtr hSct, string pTxt, int lTxt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendTextW", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSendText(IntPtr hSct, string pTxt, int lTxt);

		//----- ●AjcSctSendBinData ----------------------------------------------------------------------------//
		public static bool AjcSctSendBinData(IntPtr hSct, Byte[] bin)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSendBinData(hSct, ref bin[0], bin.Length);
			else		   rc = A64SctSendBinData(hSct, ref bin[0], bin.Length);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool AjcSctSendBinData(IntPtr hSct, void *p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSendBinData(hSct, p, len);
			else		   rc = A64SctSendBinData(hSct, p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AjcSctSendBinData(IntPtr hSct, IntPtr p, int len)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctSendBinData(hSct, p, len);
			else		   rc = A64SctSendBinData(hSct, p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendBinData@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSendBinData(IntPtr hSct, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendBinData@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SctSendBinData(IntPtr hSct, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendBinData@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctSendBinData(IntPtr hSct, IntPtr p, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendBinData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSendBinData(IntPtr hSct, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendBinData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SctSendBinData(IntPtr hSct, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendBinData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctSendBinData(IntPtr hSct, IntPtr p, int len);

		//----- ●AjcSctSendPacket -----------------------------------------------------------------------------//
		public static int AjcSctSendPacket(IntPtr hSct, Byte[] bin)
		{
			int	rc;
			if (Is32Bit()) rc = A32SctSendPacket(hSct, ref bin[0], bin.Length);
			else		   rc = A64SctSendPacket(hSct, ref bin[0], bin.Length);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static int AjcSctSendPacket(IntPtr hSct, void *p, int len)
		{
			int	rc;
			if (Is32Bit()) rc = A32SctSendPacket(hSct, p, len);
			else		   rc = A64SctSendPacket(hSct, p, len);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static int AjcSctSendPacket(IntPtr hSct, IntPtr p, int len)
		{
			int	rc;
			if (Is32Bit()) rc = A32SctSendPacket(hSct, p, len);
			else		   rc = A64SctSendPacket(hSct, p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendPacket@12", ExactSpelling=true)]
		private static extern int A32SctSendPacket(IntPtr hSct, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendPacket@12", ExactSpelling=true)]
		unsafe private static extern int A32SctSendPacket(IntPtr hSct, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctSendPacket@12", ExactSpelling=true)]
		private static extern int A32SctSendPacket(IntPtr hSct, IntPtr p, int len);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendPacket", ExactSpelling=true)]
		private static extern int A64SctSendPacket(IntPtr hSct, ref byte bin, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendPacket", ExactSpelling=true)]
		unsafe private static extern int A64SctSendPacket(IntPtr hSct, void *p, int len);
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctSendPacket", ExactSpelling=true)]
		private static extern int A64SctSendPacket(IntPtr hSct, IntPtr p, int len);

		//----- ●AjcSctPurgeRecvData --------------------------------------------------------------------------//
		public static bool AjcSctPurgeRecvData(IntPtr hSct)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctPurgeRecvData(hSct);
			else		   rc = A64SctPurgeRecvData(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctPurgeRecvData@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctPurgeRecvData(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctPurgeRecvData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctPurgeRecvData(IntPtr hSct);

		//----- ●AjcSctPurgeSendData --------------------------------------------------------------------------//
		public static bool AjcSctPurgeSendData(IntPtr hSct)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctPurgeSendData(hSct);
			else		   rc = A64SctPurgeSendData(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctPurgeSendData@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctPurgeSendData(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctPurgeSendData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctPurgeSendData(IntPtr hSct);

		//----- ●AjcSctPurgeAllData ---------------------------------------------------------------------------//
		public static bool AjcSctPurgeAllData(IntPtr hSct)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctPurgeAllData(hSct);
			else		   rc = A64SctPurgeAllData(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctPurgeAllData@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctPurgeAllData(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctPurgeAllData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctPurgeAllData(IntPtr hSct);

		//----- ●AjcSctCreateForMSIL --------------------------------------------------------------------------//
		unsafe public static IntPtr AjcSctCreateForMSIL(SctCbkRxText	 	CbkRxText		,
														SctCbkRxEsc		 	CbkRxEsc		,
														SctCbkRxCtrl	 	CbkRxCtrl		,
														SctCbkRxPacket	 	CbkRxPacket		,
														SctCbkRxNoPkt	 	CbkRxNoPkt		,
														SctCbkTxEmpty	 	CbkTxEmpty		,
														SctCbkRxChunkTxt 	CbkRxChunkTxt	,
														SctCbkRxChunkBin 	CbkRxChunkBin	,
														SctCbkRxInvChunk 	CbkRxInvChunk	,
														SctCbkConnect	 	CbkConnect		,
														SctCbkDisconnect	CbkDisconnect	,
														SctCbkCnFail		CbkCnFail		,
														SctCbkRecvError		CbkRecvError	,
														SctCbkSendError		CbkSendError	,
														SctCbkGeneralError	CbkGeneralError)
		{
			IntPtr	rc;
			if (Is32Bit()) {
				rc = A32SctCreateForMSIL(CbkRxText	, CbkRxEsc	   , CbkRxCtrl , CbkRxPacket  ,
													  CbkRxNoPkt   , CbkTxEmpty, CbkRxChunkTxt, CbkRxChunkBin,
													  CbkRxInvChunk, CbkConnect, CbkDisconnect, CbkCnFail,
													  CbkRecvError , CbkSendError , CbkGeneralError);
			}
			else {
				rc = A64SctCreateForMSIL(CbkRxText	, CbkRxEsc	   , CbkRxCtrl , CbkRxPacket  ,
													  CbkRxNoPkt   , CbkTxEmpty, CbkRxChunkTxt, CbkRxChunkBin,
													  CbkRxInvChunk, CbkConnect, CbkDisconnect, CbkCnFail,
													  CbkRecvError , CbkSendError , CbkGeneralError);
			}
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctCreateForMSIL@60", ExactSpelling=true)]
		private static extern IntPtr A32SctCreateForMSIL(	SctCbkRxText	 	cbRxText	  ,
															SctCbkRxEsc		 	cbRxEsc		  ,
															SctCbkRxCtrl	 	cbRxCtrl	  ,
															SctCbkRxPacket	 	cbRxPacket	  ,
															SctCbkRxNoPkt	 	cbRxNoPkt	  ,
															SctCbkTxEmpty	 	cbTxEmpty	  ,
															SctCbkRxChunkTxt 	cbRxChunkTxt  ,
															SctCbkRxChunkBin 	cbRxChunkBin  ,
															SctCbkRxInvChunk 	cbRxInvChunk  ,
															SctCbkConnect	 	cbConnect	  ,
															SctCbkDisconnect	cbDisconnect  ,
															SctCbkCnFail		cbCnFail	  ,
															SctCbkRecvError		cbRecvError	  ,
															SctCbkSendError		cbSendError	  ,
															SctCbkGeneralError	cbGeneralError);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctCreateForMSIL", ExactSpelling=true)]
		private static extern IntPtr A64SctCreateForMSIL(	SctCbkRxText	 	cbRxText	  ,	
															SctCbkRxEsc		 	cbRxEsc		  ,	
															SctCbkRxCtrl	 	cbRxCtrl	  ,	
															SctCbkRxPacket	 	cbRxPacket	  ,	
															SctCbkRxNoPkt	 	cbRxNoPkt	  ,	
															SctCbkTxEmpty	 	cbTxEmpty	  ,	
															SctCbkRxChunkTxt 	cbRxChunkTxt  ,	
															SctCbkRxChunkBin 	cbRxChunkBin  ,	
															SctCbkRxInvChunk 	cbRxInvChunk  ,	
															SctCbkConnect	 	cbConnect	  ,	
															SctCbkDisconnect	cbDisconnect  ,	
															SctCbkCnFail		cbCnFail	  ,
															SctCbkRecvError		cbRecvError	  ,	
															SctCbkSendError		cbSendError	  ,	
															SctCbkGeneralError	cbGeneralError);

		//----- ●AjcSctConnectForMSIL -------------------------------------------------------------------------//
		public static bool AjcSctConnectForMSIL(IntPtr hSct, string pServ, string pPort, ESctFamily Family, bool fOnEvent)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctConnectForMSIL(hSct, pServ, pPort, Family, fOnEvent);
			else		   rc = A64SctConnectForMSIL(hSct, pServ, pPort, Family, fOnEvent);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctConnectForMSIL@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctConnectForMSIL(IntPtr hSct, string pServ, string pPort, ESctFamily Family, [MarshalAs(UnmanagedType.Bool)]bool fOnEvent);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctConnectForMSIL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctConnectForMSIL(IntPtr hSct, string pServ, string pPort, ESctFamily Family, [MarshalAs(UnmanagedType.Bool)]bool fOnEvent);

		//----- ●AjcSctDeleteForMSIL --------------------------------------------------------------------------//
		public static bool AjcSctDeleteForMSIL(IntPtr hSct)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SctDeleteForMSIL(hSct);
			else		   rc = A64SctDeleteForMSIL(hSct);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSctDeleteForMSIL@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SctDeleteForMSIL(IntPtr hSct);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSctDeleteForMSIL", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SctDeleteForMSIL(IntPtr hSct);

		//======================================================================================================//
		//	AjcSockServer.h 																					//
		//======================================================================================================//
		//----- ●AjcSsvSetOpt -----------------------------------------------------------------------------------//
		public static bool AjcSsvSetOpt(IntPtr hSsv, ESsvServOpt opt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvSetOpt(hSsv, opt);
			else		   rc = A64SsvSetOpt(hSsv, opt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvSetOpt@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvSetOpt(IntPtr hSsv, ESsvServOpt opt);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvSetOpt", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvSetOpt(IntPtr hSsv, ESsvServOpt opt);

		//----- ●AjcSsvGetOpt -----------------------------------------------------------------------------------//
		public static ESsvServOpt AjcSsvGetOpt(IntPtr hSsv)
		{
			ESsvServOpt	rc;
			if (Is32Bit()) rc = A32SsvGetOpt(hSsv);
			else		   rc = A64SsvGetOpt(hSsv);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetOpt@4", ExactSpelling=true)]
		private static extern ESsvServOpt A32SsvGetOpt(IntPtr hSsv);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetOpt", ExactSpelling=true)]
		private static extern ESsvServOpt A64SsvGetOpt(IntPtr hSsv);

		//----- ●AjcSsvStop -----------------------------------------------------------------------------------//
		public static bool AjcSsvStop(IntPtr hSsv, int msTimeout)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvStop(hSsv, msTimeout);
			else		   rc = A64SsvStop(hSsv, msTimeout);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvStop@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvStop(IntPtr hSsv, int msTimeout);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvStop", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvStop(IntPtr hSsv, int msTimeout);

		//----- ●AjcSsvSetChunkMode ---------------------------------------------------------------------------//
		public static bool AjcSsvSetChunkMode(IntPtr hSsv, ESsvChunkMode ChunkMode)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvSetChunkMode(hSsv, ChunkMode);
			else		   rc = A64SsvSetChunkMode(hSsv, ChunkMode);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvSetChunkMode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvSetChunkMode(IntPtr hSsv, ESsvChunkMode ChunkMode);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvSetChunkMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvSetChunkMode(IntPtr hSsv, ESsvChunkMode ChunkMode);

		//----- ●AjcSsvGetChunkMode ---------------------------------------------------------------------------//
		public static ESsvChunkMode AjcSsvGetChunkMode(IntPtr hSsv)
		{
			ESsvChunkMode	rc;
			if (Is32Bit()) rc = A32SsvGetChunkMode(hSsv);
			else		   rc = A64SsvGetChunkMode(hSsv);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetChunkMode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ESsvChunkMode A32SsvGetChunkMode(IntPtr hSsv);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetChunkMode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ESsvChunkMode A64SsvGetChunkMode(IntPtr hSsv);

		//----- ●AjcSsvSetEvtMask -----------------------------------------------------------------------------//
		public static bool AjcSsvSetEvtMask(IntPtr hSsv, int evt)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvSetEvtMask(hSsv, evt);
			else		   rc = A64SsvSetEvtMask(hSsv, evt);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvSetEvtMask@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvSetEvtMask(IntPtr hSsv, int Mask);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvSetEvtMask", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvSetEvtMask(IntPtr hSsv, int Mask);

		//----- ●AjcSsvGetEvtMask -----------------------------------------------------------------------------//
		public static ESsvEvt AjcSsvGetEvtMask(IntPtr hSsv)
		{
			ESsvEvt	rc;
			if (Is32Bit()) rc = (ESsvEvt)A32SsvGetEvtMask(hSsv);
			else		   rc = (ESsvEvt)A64SsvGetEvtMask(hSsv);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetEvtMask@4", ExactSpelling=true)]
		private static extern int A32SsvGetEvtMask(IntPtr hSsv);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetEvtMask", ExactSpelling=true)]
		private static extern int A64SsvGetEvtMask(IntPtr hSsv);

		//----- ●AjcSsvSetRxTextCode --------------------------------------------------------------------------//
		public static bool AjcSsvSetRxTextCode(IntPtr hSsv, ESsvRxTextCode code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvSetRxTextCode(hSsv, (int)code);
			else		   rc = A64SsvSetRxTextCode(hSsv, (int)code);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ESsvRxTextCode AjcSsvSetRxTextCode(IntPtr hSsv)
		{
			ESsvRxTextCode	rc;
			if (Is32Bit()) rc = (ESsvRxTextCode)A32SsvGetRxTextCode(hSsv);
			else		   rc = (ESsvRxTextCode)A64SsvGetRxTextCode(hSsv);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvSetRxTextCode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvSetRxTextCode(IntPtr hSsv, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvSetRxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvSetRxTextCode(IntPtr hSsv, int code);

		//----- ●AjcSsvGetRxTextCode --------------------------------------------------------------------------//
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetRxTextCode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A32SsvGetRxTextCode(IntPtr hSsv);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetRxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A64SsvGetRxTextCode(IntPtr hSsv);

		//----- ●AjcSsvSetTxTextCode --------------------------------------------------------------------------//
		public static bool AjcSsvSetTxTextCode(IntPtr hSsv, ESsvTxTextCode code)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvSetTxTextCode(hSsv, (int)code);
			else		   rc = A64SsvSetTxTextCode(hSsv, (int)code);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvSetTxTextCode@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvSetTxTextCode(IntPtr hSsv, int code);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvSetTxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvSetTxTextCode(IntPtr hSsv, int code);

		//----- ●AjcSsvGetTxTextCode --------------------------------------------------------------------------//
		public static ESsvTxTextCode AjcSsvGetTxTextCode(IntPtr hSsv)
		{
			ESsvTxTextCode	rc;
			if (Is32Bit()) rc = (ESsvTxTextCode)A32SsvGetTxTextCode(hSsv);
			else		   rc = (ESsvTxTextCode)A64SsvGetTxTextCode(hSsv);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetTxTextCode@4", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A32SsvGetTxTextCode(IntPtr hSsv);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetTxTextCode", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern int A64SsvGetTxTextCode(IntPtr hSsv);

		//----- ●AjcSsvWaitEvent ------------------------------------------------------------------------------//
		public static bool AjcSsvWaitEvent(IntPtr hSsv, ref IntPtr wParam, ref IntPtr lParam, int msTime)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvWaitEvent(hSsv, ref wParam, ref lParam, msTime);
			else		   rc = A64SsvWaitEvent(hSsv, ref wParam, ref lParam, msTime);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvWaitEvent@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SsvWaitEvent(IntPtr hSsv, ref IntPtr wParam, ref IntPtr lParam, int msTime);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvWaitEvent", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SsvWaitEvent(IntPtr hSsv, ref IntPtr wParam, ref IntPtr lParam, int msTime);

		//----- ●AjcSsvGetEventData ---------------------------------------------------------------------------//
		unsafe public static bool AjcSsvGetEventData(IntPtr hSsv, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvGetEventData(hSsv, lParam, out pDat, out lDat, out Param);
			else		   rc = A64SsvGetEventData(hSsv, lParam, out pDat, out lDat, out Param);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetEventData@20", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SsvGetEventData(IntPtr hSsv, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetEventData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SsvGetEventData(IntPtr hSsv, IntPtr lParam, out IntPtr pDat, out int lDat, out int Param);

		//----- ●AjcSsvGetClient ------------------------------------------------------------------------------//
		unsafe public static bool AjcSsvGetClient(IntPtr hSsv, IntPtr lParam, ref IntPtr hCli)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvGetClient(hSsv, lParam, ref hCli);
			else		   rc = A64SsvGetClient(hSsv, lParam, ref hCli);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvGetClient@12", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SsvGetClient(IntPtr hSsv, IntPtr lParam, ref IntPtr hCli);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvGetClient", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SsvGetClient(IntPtr hSsv, IntPtr lParam, ref IntPtr hCli);

		//----- ●AjcSsvIsClientValid --------------------------------------------------------------------------//
		unsafe public static bool AjcSsvIsClientValid(IntPtr hSsv, IntPtr hCli)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvIsClientValid(hSsv, hCli);
			else		   rc = A64SsvIsClientValid(hSsv, hCli);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvIsClientValid@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A32SsvIsClientValid(IntPtr hSsv, IntPtr hCli);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvIsClientValid", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		unsafe private static extern bool A64SsvIsClientValid(IntPtr hSsv, IntPtr hCli);

		//----- ●AjcSsvRelEventData ---------------------------------------------------------------------------//
		public static bool AjcSsvRelEventData(IntPtr hSsv, IntPtr lParam)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvRelEventData(hSsv, lParam);
			else		   rc = A64SsvRelEventData(hSsv, lParam);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvRelEventData@8", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvRelEventData(IntPtr hSsv, IntPtr lParam);
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst64.dll",CharSet=CharSet.Unicode,EntryPoint="AjcSsvRelEventData", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A64SsvRelEventData(IntPtr hSsv, IntPtr lParam);

		//----- ●AjcSsvSetPktCtrlCode -------------------------------------------------------------------------//
		public static bool AjcSsvSetPktCtrlCode(IntPtr hSsv, int stx, int etx, int dle)
		{
			bool	rc;
			if (Is32Bit()) rc = A32SsvSetPktCtrlCode(hSsv, stx, etx, dle);
			else		   rc = A64SsvSetPktCtrlCode(hSsv, stx, etx, dle);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		[DllImport("AjrCst32.dll",CharSet=CharSet.Unicode,EntryPoint="_AjcSsvSetPktCtrlCode@16", ExactSpelling=true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool A32SsvSetPktCtrlCode(IntPtr hSsv, int stx, int etx, int dle);
		//-