﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using AjaraInit;

namespace CAjrCustCtrl
{
	[ToolboxBitmap(typeof(CAjrSphereData), "CAjr3SphereData.bmp")]
	public partial class CAjrSphereData : Component
	{
		//----- ワーク -----------------------------------------------------------------------------------------//
		private IntPtr			m_hSpd;
		private AJCSPD_PARAM	m_param;

		//----- コンストラクタ（１） ---------------------------------------------------------------------------//
		public CAjrSphereData()
		{
			InitializeComponent();
			//	初期化
			InitOnConstruct();
		}

		//----- コンストラクタ（２） ---------------------------------------------------------------------------//
		public CAjrSphereData(IContainer container)
		{
			container.Add(this);

			InitializeComponent();
			//	初期化
			InitOnConstruct();
		}
		//----- 初期化コード -----------------------------------------------------------------------------------//
		private void InitOnConstruct()
		{
			//	ライブラリ初期化
			CAjrInit.Init();

			//	変数初期化
			m_hSpd 			= CAjrApi.AjcSpdCreate(0);
			CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);

			//	終了イベント設定
			this.Disposed += OnUnloadMyControl;
		}
		//----- 終了処理 ---------------------------------------------------------------------------------------//
		private void OnUnloadMyControl(object sender, EventArgs e)
		{
			if (m_hSpd != (IntPtr)0) {
				CAjrApi.AjcSpdDelete(m_hSpd);
			}
		}
		//------------------------------------------------------------------------------------------------------//
		//	プロパティ																							//
		//------------------------------------------------------------------------------------------------------//
		//----- 中心Ｘ				----------------------------------------------------------------------------//
		[System.ComponentModel.Category("AjrSphereData")]
		[System.ComponentModel.Description("Center position x")]
		public double cent_x {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.cent_x = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.cent_x;
				}
		}
		//----- 中心Ｙ				----------------------------------------------------------------------------//
		[System.ComponentModel.Category("AjrSphereData")]
		[System.ComponentModel.Description("Center position y")]
		public double cent_y {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.cent_y = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.cent_y;
				}
		}
		//----- 中心Ｚ				----------------------------------------------------------------------------//
		[System.ComponentModel.Category("AjrSphereData")]
		[System.ComponentModel.Description("Center position y")]
		public double cent_z {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.cent_z = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.cent_z;
				}
		}
		//----- 球半径				----------------------------------------------------------------------------//
		[System.ComponentModel.Category("AjrsphereData")]
		[System.ComponentModel.Description("Sphere radius")]
		public double radius {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.radius = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.radius;
				}
		}
		//----- 球半径の誤差		----------------------------------------------------------------------------//
		[System.ComponentModel.Category("AjrsphereData")]
		[System.ComponentModel.Description("Sphere radius error range")]
		public double error_range {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.noise = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.noise;
				}
		}
		//----- 回転軸のＸ軸回転角度・最大値	----------------------------------------------------------------//
		[System.ComponentModel.Category("AjrsphereData")]
		[System.ComponentModel.Description("X-axis rotation angle of rotation axis")]
		public double rot_x {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.xrot = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.xrot;
				}
		}
		//----- 回転軸のＹ軸回転角度・最大値	----------------------------------------------------------------//
		[System.ComponentModel.Category("AjrsphereData")]
		[System.ComponentModel.Description("Y-axis rotation angle of rotation axis")]
		public double rot_y {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.yrot = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.yrot;
				}
		}
		//----- プロット点の回転角度・最大値	----------------------------------------------------------------//
		[System.ComponentModel.Category("AjrsphereData")]
		[System.ComponentModel.Description("Angular velocity of plot points")]
		public double pitch {
			set {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					m_param.pitch = value;
					CAjrApi.AjcSpdSetParam(m_hSpd, ref m_param);
				}
			get {	CAjrApi.AjcSpdGetParam(m_hSpd, ref m_param);
					return m_param.pitch;
				}
		}
		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- パラメタ設定 -----------------------------------------------------------------------------------//
		public void SetParam(AJCSPD_PARAM param)
		{
			CAjrApi.AjcSpdSetParam(m_hSpd, ref param);
		}
		//----- パラメタ取得 -----------------------------------------------------------------------------------//
		public AJCSPD_PARAM GetParam()
		{
			AJCSPD_PARAM param = new AJCSPD_PARAM();
			CAjrApi.AjcSpdGetParam(m_hSpd, ref param);
			return param;
		}
		//----- 演算 -------------------------------------------------------------------------------------------//
		public AJC3DVEC Calc()
		{
			AJC3DVEC v = new AJC3DVEC();
			CAjrApi.AjcSpdCalc(m_hSpd, ref v.x, ref v.y, ref v.z);
			return v;
		}
	}
}
