﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Reflection;
using AjaraInit;
using CAjrCustCtrl;

namespace CAjrCustCtrl
{
	[ToolboxBitmap(typeof(CAjrStatic), "CAjrStatic.bmp")]
	public partial class CAjrStatic : Component
	{
		//----- コンストラクタ（１） ---------------------------------------------------------------------------//
		public CAjrStatic()
		{
			InitializeComponent();

			CAjrInit.Init();
		}

		//----- コンストラクタ（２） ---------------------------------------------------------------------------//
		public CAjrStatic(IContainer container)
		{
			container.Add(this);

			InitializeComponent();

			CAjrInit.Init();
			this.Disposed  += OnUnloadMyControl;			//	終了イベント設定
		}
		//----- 終了処理 ---------------------------------------------------------------------------------------//
		private void OnUnloadMyControl(object sender, EventArgs e)
		{
			
		}
		//------------------------------------------------------------------------------------------------------//
		//	プロパティ（ツールチップ	SAjrTip）																//
		//------------------------------------------------------------------------------------------------------//
		//----- ツールチップのデフォルトテキスト表示色 ---------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Default text color")]
		public Color DefTextColor
		{
			set {SAjrTip.SetDefTextColor(value);}
			get {return  SAjrTip.GetDefTextColor();}
		}

		//----- ツールチップのデフォルト外枠表示色 -------------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Default border color")]
		public Color DefBorderColor
		{
			set {SAjrTip.SetDefBorderColor(value);}
			get {return  SAjrTip.GetDefBorderColor();}
		}

		//----- ツールチップのデフォルトウインド背景色 ---------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Default back-ground color")]
		public Color DefBackGround
		{
			set {SAjrTip.SetDefBackGround(value);}
			get {return  SAjrTip.GetDefBackGround();}
		}

		//----- ツールチップのデフォルトフォント --------------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Default font")]
		public Font DefFont
		{
			set {SAjrTip.SetDefFont(value);}
			get {return SAjrTip.GetDefFont();}
		}

		//----- ツールチップのデフォルト遅延時間 --------------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Default display delay time")]
		public int DefDelayTime
		{
			set {SAjrTip.SetDefDelayTime(value);}
			get {return SAjrTip.GetDefDelayTime();}
		}

		//----- ツールチップのデフォルト表示時間 --------------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Default display time")]
		public int DefDisplayTime
		{
			set {SAjrTip.SetDefDisplayTime(value);}
			get {return SAjrTip.GetDefDisplayTime();}
		}

		//----- ツールチップのコントロール間移動猶予時間 -------------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("Window time of move between controls")]
		public int WindowTime
		{
			set {SAjrTip.SetWindowTime(value);}
			get {return SAjrTip.GetWindowTime();}
		}
		//----- 全コントロールで、アクティブ時のみ表示設定 -----------------------------------------------------//
		[System.ComponentModel.Category("SAjrTip[ToolTip]")]
		[System.ComponentModel.Description("When set to 'true', all controls display tooltips only when inactive. If set to 'false', it will be displayed according to the individual ShowAlways property settings.")]
		public bool ShowForOnlyActive
		{
			set {SAjrTip.SetShowForOnlyActive(value);}
			get {return SAjrTip.GetShowForOnlyActive();}
		}
		//------------------------------------------------------------------------------------------------------//
		//	プロパティ（汎用ファンクション	SAjrGsr）															//
		//------------------------------------------------------------------------------------------------------//
		//----- バージョン文字列 -------------------------------------------------------------------------------//
		[System.ComponentModel.Category("SAjrGsr[General function]")]
		[System.ComponentModel.Description("Version string")]
		public string Version
		{
			get {return  SAjrGsr.GetVersion();}
		}

	}
	//==========================================================================================================//
	//																											//
	//	コンソール	SAjrCon																						//
	//																											//
	//==========================================================================================================//
	public static class SAjrCon
	{
		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- １行入力				------------------------------------------------------------------------//
		//- - - 引数無し - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine()
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, 0, 0, Color.Empty, Color.Empty, null, null);
			return rc;
		}
		//- - - ヘルプのみ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, 0, 0, Color.Empty, Color.Empty, HelpText, null);
			return rc;
		}
		//- - - 初期テキスト，入力文字数		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetLine(string InitialText, int len)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, 0, len, 0, Color.Empty, Color.Empty, null, null);
			return rc;
		}
		//- - - 初期テキスト，入力文字数，ヘルプ  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetLine(string InitialText, int len, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, 0, len, 0, Color.Empty, Color.Empty, HelpText, null);
			return rc;
		}
		//- - - 初期テキスト，入力文字数，オプション  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetLine(string InitialText, int len, ECInGetLineOpt Option)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, 0, len, Option, Color.Empty, Color.Empty, null, null);
			return rc;
		}
		//- - - 初期テキスト，入力文字数，オプション，ヘルプ  - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetLine(string InitialText, int len, ECInGetLineOpt Option, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, 0, len, Option, Color.Empty, Color.Empty, HelpText, null);
			return rc;
		}
		//- - - 初期テキスト，入力文字数，オプション，表示色  - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetLine(string InitialText, int len, ECInGetLineOpt Option, Color ForeColor, Color BackColor)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, 0, len, Option, ForeColor, BackColor, null, null);
			return rc;
		}
		//- - - 初期テキスト，入力文字数，オプション，表示色，ヘルプ  - - - - - - - - - - - - - - - - - - - - - //
		public static string GetLine(string InitialText, int len, ECInGetLineOpt Option, Color ForeColor, Color BackColor, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, 0, len, Option, ForeColor, BackColor, HelpText, null);
			return rc;
		}
		//- - - オプション - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(ECInGetLineOpt Option)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, 0, Option, Color.Empty, Color.Empty, null, null);
			return rc;
		}
		//- - - オプション，ヘルプ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(ECInGetLineOpt Option, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, 0, Option, Color.Empty, Color.Empty, HelpText, null);
			return rc;
		}
		//- - - 入力文字数 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(int len)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, len, 0, Color.Empty, Color.Empty, null, null);
			return rc;
		}
		//- - - 入力文字数，ヘルプ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(int len, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, len, 0, Color.Empty, Color.Empty, HelpText, null);
			return rc;
		}
		//- - - 入力文字数，オプション - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(int len, ECInGetLineOpt Option)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, len, Option, Color.Empty, Color.Empty, null, null);
			return rc;
		}
		//- - - 入力文字数，オプション，ヘルプ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(int len, ECInGetLineOpt Option, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(null, 0, len, 0, Color.Empty, Color.Empty, HelpText, null);
			return rc;
		}
		//- - - コールバック以外全て指定 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(string InitialText, int FieldLen, int len, ECInGetLineOpt Option, Color ForeColor, Color BackColor, string HelpText)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, FieldLen, len, Option, ForeColor, BackColor, HelpText, null);
			return rc;
		}
		//- - - 全て指定 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public static string GetLine(string InitialText, int FieldLen, int len, ECInGetLineOpt Option, Color ForeColor, Color BackColor, string HelpText, ConCbkNtcArgs cbNtcArgs)
		{
			string rc = CAjrApi.AjcConInputForMSIL(InitialText, FieldLen, len, Option, ForeColor, BackColor, HelpText, cbNtcArgs);
			return rc;
		}

		//----- 最大ウインドサイズ取得	------------------------------------------------------------------------//
		public static void GetMaxWndSize(out int cx, out int cy)
		{
			CAjrApi.AjcGetConsoleMaxWndSize(out cx, out cy);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Size GetMaxWndSize()
		{
			int		cx, cy;
			CAjrApi.AjcGetConsoleMaxWndSize(out cx, out cy);
			Size sz = new Size(cx, cy);
			return sz;
		}
		//----- バッファサイズ設定	----------------------------------------------------------------------------//
		public static void SetBufSize(int cx, int cy)
		{
			CAjrApi.AjcSetConsoleBufSize(cx, cy);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SetBufSize(Size sz)
		{
			CAjrApi.AjcSetConsoleBufSize(sz.Width, sz.Height);
		}
		//----- バッファサイズ取得	----------------------------------------------------------------------------//
		public static void GetBufSize(out int cx, out int cy)
		{
			CAjrApi.AjcGetConsoleBufSize(out cx, out cy);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Size GetBufSize()
		{
			int  cx, cy;
			CAjrApi.AjcGetConsoleBufSize(out cx, out cy);
			Size sz = new Size(cx, cy);
			return sz;
		}
		//----- ウインド矩形設定	----------------------------------------------------------------------------//
		public static void SetWndRect(int left, int top, int right, int bottom)
		{
			CAjrApi.AjcSetConsoleWndRect(left, top, right, bottom);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SetWndRect(Rectangle r)
		{
			CAjrApi.AjcSetConsoleWndRect(r.Left, r.Top, r.Right, r.Bottom);
		}
		//----- ウインド矩形取得	----------------------------------------------------------------------------//
		public static void GetWndRect(out int left, out int top, out int right, out int bottom)
		{
			CAjrApi.AjcGetConsoleWndRect(out left, out top, out right, out bottom);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Rectangle GetWndRect()
		{
			int left, top, right, bottom;
			CAjrApi.AjcGetConsoleWndRect(out left, out top, out right, out bottom);
			Rectangle rc = new Rectangle(left, top, right - left, bottom - top);
			return rc;
		}
		//----- 表示色設定			----------------------------------------------------------------------------//
		public static void SetColor(Color ForeColor, Color BackColor)
		{
			CAjrApi.AjcSetConsoleColor(ForeColor, BackColor);
		}
		//----- 表示色取得			----------------------------------------------------------------------------//
		public static void GetColor(out Color ForeColor, out Color BackColor)
		{
			CAjrApi.AjcGetConsoleColor(out ForeColor, out BackColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Color GetForeColor()
		{
			return CAjrApi.AjcGetConsoleForeColor();
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Color GetBackColor()
		{
			return CAjrApi.AjcGetConsoleBackColor();
		}
		//----- パレット選択			-------------------------------------------------------------------------//
		public static void SelectPalette(int ForePalette, int BackPalette)
		{
			CAjrApi.AjcSelConsolePalette(ForePalette, BackPalette);
		}
		//----- パレット設定			 ------------------------------------------------------------------------//
		public static void SetPalette(Color[] Palette)
		{
			if (Palette.Length >= 16) {
				CAjrApi.AjcSetConsolePalette(Palette);
			}
			else {throw new ArgumentException("Invalid number of array elements.");}
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SetPalette(int ix, Color color)
		{
			CAjrApi.AjcSetConsolePalByIx(ix, color);
		}
		//----- パレット取得			------------------------------------------------------------------------//
		public static Color[] GetPalette()
		{
			Color[] OutPal = new Color[16];
			CAjrApi.AjcGetConsolePalette(out OutPal);
			return OutPal;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Color GetPalette(int ix)
		{
			return CAjrApi.AjcGetConsolePalByIx(ix);
		}
		//----- カーソル位置設定		------------------------------------------------------------------------//
		public static void SetCursorPos(int x, int y)
		{
			CAjrApi.AjcSetConsoleCursor(x, y);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SetCursorPos(Point pt)
		{
			CAjrApi.AjcSetConsoleCursor(pt.X, pt.Y);
		}
		//----- カーソル位置取得		------------------------------------------------------------------------//
		public static void GetCursorPos(out int x, out int y)
		{
			CAjrApi.AjcGetConsoleCursor(out x, out y);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Point GetCursorPos()
		{
			int x, y;
			CAjrApi.AjcGetConsoleCursor(out x, out y);
			Point pt = new Point(x, y);
			return pt;
		}
	}
	//==========================================================================================================//
	//																											//
	//	ツールチップ	SAjrTip																					//
	//																											//
	//==========================================================================================================//
	public static class SAjrTip
	{
		private static Font		m_TipDefFont = new Font("MS UI Gothic", 9);		//	デフォルトフォント

		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- デフォルトテキスト表示色 設定			 -------------------------------------------------------//
		public static void SetDefTextColor(Color color)
		{
			CAjrApi.AjcTipTextSetDefTextColor(color);
		}
		//----- デフォルトテキスト表示色 取得			 -------------------------------------------------------//
		public static Color GetDefTextColor()
		{
			return	CAjrApi.AjcTipTextGetDefTextColor();
		}
		//----- デフォルト外枠表示色 設定				 -------------------------------------------------------//
		public static void SetDefBorderColor(Color color)
		{
			CAjrApi.AjcTipTextSetDefBorderColor(color);
		}
		//----- デフォルト外枠表示色 取得				 -------------------------------------------------------//
		public static Color GetDefBorderColor()
		{
			return	CAjrApi.AjcTipTextGetDefBorderColor();
		}
		//----- デフォルトウインド背景表示色 設定		 -------------------------------------------------------//
		public static void SetDefBackGround(Color color)
		{
			CAjrApi.AjcTipTextSetDefBkColor(color);
		}
		//----- デフォルトウインド背景表示色 取得		 -------------------------------------------------------//
		public static Color GetDefBackGround()
		{
			return	CAjrApi.AjcTipTextGetDefBkColor();
		}
		//----- デフォルトフォント設定					--------------------------------------------------------//
		public static void SetDefFont(Font font)
		{
			m_TipDefFont = font;
			CAjrApi.AjcTipTextSetDefFont(m_TipDefFont);
		}
		//----- デフォルトフォント取得					--------------------------------------------------------//
		public static Font GetDefFont()
		{
			return m_TipDefFont;
		}
		//----- デフォルト表示遅延時間設定				--------------------------------------------------------//
		public static void SetDefDelayTime(int msTime)
		{
			CAjrApi.AjcTipTextSetDefMsDelay(msTime);
		}
		//----- デフォルト表示遅延時間取得				--------------------------------------------------------//
		public static int GetDefDelayTime()
		{
			return CAjrApi.AjcTipTextGetDefMsDelay();
		}
		//----- デフォルト表示時間設定					--------------------------------------------------------//
		public static void SetDefDisplayTime(int msTime)
		{
			CAjrApi.AjcTipTextSetDefMsShow(msTime);
		}
		//----- デフォルト表示時間取得					--------------------------------------------------------//
		public static int GetDefDisplayTime()
		{
			return CAjrApi.AjcTipTextGetDefMsShow();
		}
		//----- コントロール間移動猶予時間 設定				----------------------------------------------------//
		public static void SetWindowTime(int msTime)
		{
			CAjrApi.AjcTipTextSetWindowTime(msTime);
		}
		//----- コントロール間移動猶予時間 取得				----------------------------------------------------//
		public static int GetWindowTime()
		{
			return CAjrApi.AjcTipTextGetWindowTime();
		}
		//----- 全コントロールで、アクティブ時のみ表示 設定 ----------------------------------------------------//
		public static void SetShowForOnlyActive(bool fShowForOnlyActive)
		{
			CAjrApi.AjcTipTextSetShowForActive(fShowForOnlyActive);
		}
		//----- 全コントロールで、アクティブ時のみ表示 取得 ----------------------------------------------------//
		public static bool GetShowForOnlyActive()
		{
			return CAjrApi.AjcTipTextGetShowForActive();
		}
		//----- ツールチップ設定 -------------------------------------------------------------------------------//
		public static void Add(object ctrl, string text)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAdd(hwnd, text);
		}
		//- - - （時間指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, int msDelay, int msShow)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, msDelay, msShow, null, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （フォント指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, Font font)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, 1000, 5000, font, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, Color TextColor, Color BackGround, Color BorderColor)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, 1000, 5000, null, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, Color TextColor, Color BackGround, bool fBorder)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, 1000, 5000, null, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （時間，フォント指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, int msDelay, int msShow, Font font)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, msDelay, msShow, null, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （時間，色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, int msDelay, int msShow, Color TextColor, Color BackGround, Color BorderColor)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, msDelay, msShow, null, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, int msDelay, int msShow, Color TextColor, Color BackGround, bool fBorder)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, msDelay, msShow, null, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （フォント，色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, Font font, Color TextColor, Color BackGround, Color BorderColor)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, 1000, 5000, font, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, Font font, Color TextColor, Color BackGround, bool fBorder)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, 1000, 5000, font, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （全指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, int msDelay, int msShow, Font font, Color TextColor, Color BackGround, Color BorderColor)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, msDelay, msShow, font, TextColor, BackGround, BorderColor);
		}
		//- - - （全指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Add(object ctrl, string text, int msDelay, int msShow, Font font, Color TextColor, Color BackGround, bool fBorder)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextAddEx(hwnd, text, msDelay, msShow, font, TextColor, BackGround, fBorder ? -1 : -2);
		}

		//----- ツールチップ表示条件設定 -----------------------------------------------------------------------//
		public static void SetShowAlways(object ctrl, bool fShowAlways)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextSetShowAlways(hwnd, fShowAlways);
		}

		//----- ツールチップ表示条件取得 -----------------------------------------------------------------------//
		public static bool GetShowAlways(object ctrl)
		{
			bool	rc;
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			rc = CAjrApi.AjcTipTextGetShowAlways(hwnd);
			return rc;
		}

		//----- 全てのチップテキストの表示許可／禁止設定 -------------------------------------------------------//
		public static void SetEnableAll(bool fEnable)
		{
			CAjrApi.AjcTipTextEnableAll(fEnable);
		}

		//----- 全てのチップテキストの表示許可／禁止状態取得 ---------------------------------------------------//
		public static bool GetEnableAll()
		{
			return CAjrApi.AjcTipTextGetEnableAllState();
		}

		//----- ツールチップ関連付け解除 -----------------------------------------------------------------------//
		public static void Remove(object ctrl)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextRemove(hwnd);
		}

		//----- 全てのツールチップ関連付け解除 -----------------------------------------------------------------//
		public static void Remove()
		{
			CAjrApi.AjcTipTextRemoveAll();
		}

		//----- コールバック設定 -------------------------------------------------------------------------------//
		public static void SetCallBack(object ctrl, IntPtr cbp, TipCbkNeedText cbNeedText)
		{
			SetCallBack(ctrl, cbp, cbNeedText, (TipCbkChkPoint)null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SetCallBack(object ctrl, IntPtr cbp, TipCbkChkPoint cbChkPoint)
		{
			SetCallBack(ctrl, cbp, (TipCbkNeedText)null, cbChkPoint);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SetCallBack(object ctrl, IntPtr cbp, TipCbkNeedText cbNeedText, TipCbkChkPoint cbChkPoint)
		{
			IntPtr hwnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcTipTextSetCallBack(hwnd, cbp, cbChkPoint, cbNeedText);
		}

		//----- マウスカーソルをツールチップ上へ移動 -----------------------------------------------------------//
		public static void MoveCursor()
		{
			MoveCursor(ETipCurMove.CENTER);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void MoveCursor(ETipCurMove mvc)
		{
			CAjrApi.AjcTipTextMoveCursor(mvc);
		}

		//----- カラーパレット設定 -----------------------------------------------------------------------------//
		public static void SetPalette(int ix, Color color)
		{
			CAjrApi.AjcTipTextSetPalette(ix, color);
		}

		//----- ツールチップのサイズ取得 -----------------------------------------------------------------------//
		public static void GetSize(string text, Font font, bool fBorder, out Size size)
		{
			AJCSIZE sz;
			CAjrApi.AjcTipTextGetSize(0, 0, text, font, fBorder, out sz);
			size = new Size(sz.cx, sz.cy);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static Size GetSize(string text, Font font, bool fBorder)
		{
			AJCSIZE sz;
			CAjrApi.AjcTipTextGetSize(0, 0, text, font, fBorder, out sz);
			Size	rc = new Size(sz.cx, sz.cy);
			return rc;
		}
		//----- チップテキスト表示 -----------------------------------------------------------------------------//
		public static void Show(int x, int y, string text)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, -1, null, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （時間指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, int msTime)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, msTime, null, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （フォント指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, Font font)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, -1, font, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, -1, null, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, -1, null, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （時間，フォント指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, int msTime, Font font)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, msTime, font, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （時間，色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, int msTime, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, msTime, null, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, int msTime, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, msTime, null, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （フォント，色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, Font font, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, -1, font, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, string text, Font font, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowEx(x, y, 0, 0, text, -1, font, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （全指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, int cx, int cy, string text, int msTime, Font font, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowEx(x, y, cx, cy, text, msTime, font, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void Show(int x, int y, int cx, int cy, string text, int msTime, Font font, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowEx(x, y, cx, cy, text, msTime, font, TextColor, BackGround, fBorder ? -1 : -2);
		}

		//----- ウインドの中央にチップテキスト表示 -------------------------------------------------------------//
		public static void ShowCenter(Control ctl, string text)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, -1, null, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （時間指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, int msTime)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, msTime, null, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （フォント指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, Font font)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, -1, font, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, -1, null, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, -1, null, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （時間，フォント指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, int msTime, Font font)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, msTime, font, Color.Empty, Color.Empty, Color.Empty);
		}
		//- - - （時間，色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, int msTime, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, msTime, null, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, int msTime, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, msTime, null, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （フォント，色指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, Font font, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, -1, font, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, string text, Font font, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), 0, 0, text, -1, font, TextColor, BackGround, fBorder ? -1 : -2);
		}
		//- - - （全指定）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, int cx, int cy, string text, int msTime, Font font, Color TextColor, Color BackGround, Color BorderColor)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), cx, cy, text, msTime, font, TextColor, BackGround, BorderColor);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowCenter(Control ctl, int cx, int cy, string text, int msTime, Font font, Color TextColor, Color BackGround, bool fBorder)
		{
			CAjrApi.AjcTipTextShowCenterEx(CAjrApi.GetPropIntPtr(ctl, "Handle"), cx, cy, text, msTime, font, TextColor, BackGround, fBorder ? -1 : -2);
		}

		//----- チップテキスト非表示 ---------------------------------------------------------------------------//
		public static void Hide()
		{
			CAjrApi.AjcTipTextHide();
		}
		//----- ビットマップ登録 -------------------------------------------------------------------------------//
		public static void RegistBitmap(Bitmap bmp, uint id, int x, int y, int cx, int cy)
		{
            CAjrApi.AjcTipTextRegistBitmap(bmp.GetHbitmap(), id, x, y, cx, cy);
		}
		//----- アイコン登録 -----------------------------------------------------------------------------------//
		public static void RegistIcon(Icon ico, uint id, int x, int y, int cx, int cy)
		{
			CAjrApi.AjcTipTextRegistIcon(ico.Handle, id, x, y, cx, cy);
		}
		//----- イメージ登録解除 -------------------------------------------------------------------------------//
		public static void UnregistImage(uint id)
		{
			CAjrApi.AjcTipTextUnregistImage(id);
		}
	}
	//==========================================================================================================//
	//																											//
	//	プロファイル／レジストリアクセス	SAjrReg																//
	//																											//
	//==========================================================================================================//
	public static class SAjrReg
	{
		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- プロファイル記録先 設定 				--------------------------------------------------------//
		public static void SetProfileDev(EProfileDev ProfileDev)
		{
			if (ProfileDev == EProfileDev.INIFILE) CAjrApi.AjcSetProfileIsRegistory(false);
			else								   CAjrApi.AjcSetProfileIsRegistory(true );
		}
		//----- プロファイル記録先 取得 				--------------------------------------------------------//
		public static EProfileDev GetProfileDev()
		{
			EProfileDev	rc;
			if (!CAjrApi.AjcGetProfileIsRegistory()) rc = EProfileDev.INIFILE;
			else									 rc = EProfileDev.REGISTORY;
			return rc;
		}
		//----- レジストリ記録モード 設定 				--------------------------------------------------------//
		public static void SetRegistoryMode(ERegRecMode mode)
		{
			if (mode == ERegRecMode.VOLATILE) {
				CAjrApi.AjcSetRegOptionVolatile(true);
			}
			else {
				CAjrApi.AjcSetRegOptionVolatile(false);
			}
		}
		//----- レジストリ記録モード 取得 				--------------------------------------------------------//
		public static ERegRecMode GetRegistoryMode()
		{
			return (CAjrApi.AjcGetRegOptionVolatile() ? ERegRecMode.VOLATILE : ERegRecMode.NON_VOLATILE);
		}
		//----- レジストリトップキー 設定 				--------------------------------------------------------//
		public static void SetRegTopKey(EAjcHKey TopKey)
		{
			CAjrApi.AjcSetRegTopKey(TopKey);
		}
		//----- レジストリトップキー 取得 				--------------------------------------------------------//
		public static EAjcHKey GetRegTopKey()
		{
			return CAjrApi.AjcGetRegTopKey();
		}
		//----- レジストリ・ルートパス 設定 			--------------------------------------------------------//
		public static void SetRegRootPath(string RootPath)
		{
			CAjrApi.AjcSetRegRootPath(RootPath);
		}
		//----- レジストリ・ルートパス 取得 			--------------------------------------------------------//
		public static string GetRegRootPath()
		{
			return CAjrApi.AjcGetRegRootPath();
		}
		//----- レジストリ・ミドルパス 設定 			--------------------------------------------------------//
		public static void SetRegMidPath(string MidPath)
		{
			CAjrApi.AjcSetRegMidPath(MidPath);
		}
		//----- レジストリ・ミドルパス 取得 			--------------------------------------------------------//
		public static string GetRegMidPath()
		{
			return CAjrApi.AjcGetRegMidPath();
		}
		//----- .INIファイルパス 設定 					--------------------------------------------------------//
		public static void SetIniFilePath(string IniPath)
		{
			CAjrApi.AjcSetIniFilePath(IniPath);
		}
		//----- .INIファイルパス 取得 					--------------------------------------------------------//
		public static string GetIniFilePath()
		{
			return CAjrApi.AjcGetIniFilePath();
		}
		//----- 読み出し（ブール）-----------------------------------------------------------------------------//
		public static bool Read(string sec, string key, bool defValue)
		{
			bool	rc;
			rc = CAjrApi.AjcGetProfileBool(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（32Bit 符号なし整数）------------------------------------------------------------------//
		public static uint Read(string sec, string key, uint defValue)
		{
			uint	rc;
			rc = CAjrApi.AjcGetProfile(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（32Bit 符号つき整数）------------------------------------------------------------------//
		public static int Read(string sec, string key, int defValue)
		{
			int	rc;
			rc = CAjrApi.AjcGetProfile(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（32Bit Hex）---------------------------------------------------------------------------//
		public static uint ReadHex(string sec, string key, uint defValue)
		{
			uint	rc;
			rc = CAjrApi.AjcGetProfileHex(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（実数）--------------------------------------------------------------------------------//
		public static double Read(string sec, string key, double defValue)
		{
			double	rc;
			rc = CAjrApi.AjcGetProfile(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（64Bit 符号なし整数）------------------------------------------------------------------//
		public static ulong Read(string sec, string key, ulong defValue)
		{
			ulong	rc;
			rc = CAjrApi.AjcGetProfile(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（64Bit 符号つき整数）------------------------------------------------------------------//
		public static long Read(string sec, string key, long defValue)
		{
			long	rc;
			rc = CAjrApi.AjcGetProfile(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（64Bit Hex）---------------------------------------------------------------------------//
		public static ulong ReadH64(string sec, string key, ulong defValue)
		{
			ulong	rc;
			rc = CAjrApi.AjcGetProfileH64(sec, key, defValue);
			return rc;
		}
		//----- 読み出し（文字列）------------------------------------------------------------------------------//
		public static string Read(string sec, string key, string defValue)
		{
			string rc;
			rc = CAjrApi.AjcGetProfileStr(sec, key, defValue);
			return rc;
		}
		//----- 書き込み（ブール）------------------------------------------------------------------------------//
		public static void Write(string sec, string key, bool value)
		{
			CAjrApi.AjcPutProfileBool(sec, key, value);
		}
		//----- 書き込み（32Bit 符号なし整数）------------------------------------------------------------------//
		public static void Write(string sec, string key, uint value)
		{
			CAjrApi.AjcPutProfile(sec, key, value);
		}
		//----- 書き込み（32Bit 符号つき整数）------------------------------------------------------------------//
		public static void Write(string sec, string key, int value)
		{
			CAjrApi.AjcPutProfile(sec, key, value);
		}
		//----- 書き込み（32Bit Hex）---------------------------------------------------------------------------//
		public static void WriteHex(string sec, string key, uint value)
		{
			CAjrApi.AjcPutProfileHex(sec, key, value);
		}
		//----- 書き込み（実数）--------------------------------------------------------------------------------//
		public static void Write(string sec, string key, double value)
		{
			CAjrApi.AjcPutProfile(sec, key, value);
		}
		//----- 書き込み（64Bit 符号なし整数）------------------------------------------------------------------//
		public static void Write(string sec, string key, ulong value)
		{
			CAjrApi.AjcPutProfile(sec, key, value);
		}
		//----- 書き込み（64Bit 符号つき整数）------------------------------------------------------------------//
		public static void Write(string sec, string key, long value)
		{
			CAjrApi.AjcPutProfile(sec, key, value);
		}
		//----- 書き込み（64Bit Hex）---------------------------------------------------------------------------//
		public static void WriteH64(string sec, string key, ulong value)
		{
			CAjrApi.AjcPutProfileH64(sec, key, value);
		}
		//----- 書き込み（文字列）------------------------------------------------------------------------------//
		public static void Write(string sec, string key, string value)
		{
			CAjrApi.AjcPutProfileStr(sec, key, value);
		}
		//----- プロファイルセクション削除 ---------------------------------------------------------------------//
		public static void DelSect(string sec)
		{
			CAjrApi.AjcDelProfileSect(sec);
		}
		//----- プロファイルキー削除 ---------------------------------------------------------------------------//
		public static void DelKey(string sec, string key)
		{
			CAjrApi.AjcDelProfileKey(sec, key);
		}
		//----- プロファイルセクション消去 ---------------------------------------------------------------------//
		public static void RemoveSect(string sec)
		{
			CAjrApi.AjcRemoveProfileSect(sec);
		}
		//----- プロファイルセクションクリーンアップ -----------------------------------------------------------//
		public static void CleanupSect(string sec)
		{
			CAjrApi.AjcCleanupProfileSect(sec);
		}
		//----- プロファイル・クローズ -------------------------------------------------------------------------//
		public static void Close()
		{
			CAjrApi.AjcCloseProfile();
		}
		//------------------------------------------------------------------------------------------------------//
		//	ウインドの位置，サイズのセーブ／ロード																//
		//------------------------------------------------------------------------------------------------------//
		//----- ウインド位置ロード		------------------------------------------------------------------------//
		public static void LoadWndPos(object wnd)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			LoadWndPos(hWnd, "WndPos", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndPos(object wnd, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			LoadWndPos(hWnd, "WndPos", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndPos(object wnd, string sec, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			LoadWndPos(hWnd, sec, prefix);
		}

		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndPos(IntPtr Handle)
		{
			LoadWndPos(Handle, "WndPos", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndPos(IntPtr Handle, string prefix)
		{
			LoadWndPos(Handle, "WndPos", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndPos(IntPtr Handle, string sec, string prefix)
		{
			CAjrApi.AjcLoadWndPosEx(Handle, sec, prefix);
		}
		//----- ウインド位置セーブ		------------------------------------------------------------------------//
		public static void SaveWndPos(object wnd)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			SaveWndPos(hWnd, "WndPos", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndPos(object wnd, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			SaveWndPos(hWnd, "WndPos", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndPos(object wnd, string sec, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			SaveWndPos(hWnd, sec, prefix);
		}

		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndPos(IntPtr Handle)
		{
			SaveWndPos(Handle, "WndPos", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndPos(IntPtr Handle, string prefix)
		{
			SaveWndPos(Handle, "WndPos", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndPos(IntPtr Handle, string sec, string prefix)
		{
			CAjrApi.AjcSaveWndPosEx(Handle, sec, prefix);
		}
		//----- ウインド矩形ロード		------------------------------------------------------------------------//
		public static void LoadWndRect(object wnd)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			LoadWndRect(hWnd, "WndRect", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndRect(object wnd, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			LoadWndRect(hWnd, "WndRect", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndRect(object wnd, string sec, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			LoadWndRect(hWnd, sec, prefix);
		}

		public static void LoadWndRect(IntPtr Handle)
		{
			LoadWndRect(Handle, "WndRect", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndRect(IntPtr Handle, string prefix)
		{
			LoadWndRect(Handle, "WndRect", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadWndRect(IntPtr Handle, string sec, string prefix)
		{
			CAjrApi.AjcLoadWndRectEx(Handle, sec, prefix);
		}
		//----- ウインド矩形セーブ		------------------------------------------------------------------------//
		public static void SaveWndRect(object wnd)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			SaveWndRect(hWnd, "WndRect", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndRect(object wnd, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			SaveWndRect(hWnd, "WndRect", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndRect(object wnd, string sec, string prefix)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(wnd, "Handle");
			SaveWndRect(hWnd, sec, prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndRect(IntPtr Handle)
		{
			SaveWndRect(Handle, "WndRect", "WP");
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndRect(IntPtr Handle, string prefix)
		{
			SaveWndRect(Handle, "WndRect", prefix);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveWndRect(IntPtr Handle, string sec, string prefix)
		{
			CAjrApi.AjcSaveWndRectEx(Handle, sec, prefix);
		}
		//------------------------------------------------------------------------------------------------------//
		//	フォーム内全コントロールのロード／セーブ															//
		//------------------------------------------------------------------------------------------------------//
		//----- コントロール収集 -------------------------------------------------------------------------------//
		private static Control[] GetAllControls(Control top)
		{
			ArrayList buf = new ArrayList();
			foreach (Control c in top.Controls) {
				buf.Add(c);
				buf.AddRange(GetAllControls(c));
			}
			return (Control[])buf.ToArray(typeof(Control));
		}
		//----- 名前検索 ---------------------------------------------------------------------------------------//
		private static bool FindNames(string name, string[] names)
		{
			bool	rc = false;
			foreach (string s in names) {
				if (s == name) {
					rc = true;
					break;
				}
			}
			return rc;
		}
		//----- 全コントロールセーブ ---------------------------------------------------------------------------//
		public static void SaveAllCtrls(Control form)
		{
			SubSaveAllCtrls(form, form.Name, null, null, ESaveAllOpt.NoOption);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SavEAllCtrls(Control form, string[] names)
		{
			SubSaveAllCtrls(form, form.Name, names, null, ESaveAllOpt.NoOption);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveAllCtrlsExc(Control form, string[] excludes)
		{
			SubSaveAllCtrls(form, form.Name, null, excludes, ESaveAllOpt.NoOption);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveAllCtrls(Control form, ESaveAllOpt opt)
		{
			SubSaveAllCtrls(form, form.Name, null, null, opt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SavEAllCtrls(Control form, string[] names, ESaveAllOpt opt)
		{
			SubSaveAllCtrls(form, form.Name, names, null, opt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void SaveAllCtrlsExc(Control form, string[] excludes, ESaveAllOpt opt)
		{
			SubSaveAllCtrls(form, form.Name, null, excludes, opt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		private static void SubSaveAllCtrls(Control form, string sec, string[] includes, string[] excludes, ESaveAllOpt opt)
		{
			bool	fDo = false;

			//	コントロール収集
			Control[] all = GetAllControls(form);
			//	設定値セーブ
 			foreach (Control c in all) {
				Type type = c.GetType();
				if (c.TabStop || type.Name == "RadioButton") {

					if		(includes != null) fDo =  (FindNames(type.Name, includes) || FindNames(c.Name, includes));
					else if (excludes != null) fDo = !(FindNames(type.Name, excludes) || FindNames(c.Name, excludes));
					else					   fDo = true;

					if (fDo) {
						switch (type.Name) {
							case "TextBox":
								//	「読み出し専用テキストを除外」指定無し or 読み出し専用テキスト以外
								if ((opt & ESaveAllOpt.ExcReadOnlyText) == 0 || !(((TextBox)c).ReadOnly)) {
									Write(sec, c.Name, ((TextBox)c).Text);
								}
								else {
									DelKey(sec, c.Name);
								}
								break;
							case "CheckBox":
								Write(sec, c.Name, ((CheckBox)c).Checked);
								break;
							case "RadioButton":
								Write(sec, c.Name, ((RadioButton)c).Checked);
								break;
							case "ListBox":
							case "CheckedListBox":
								SaveListBox(form, c);
								break;
							case "ComboBox":
								SaveComboBox(form, c);
								break;
							case "CAjrInpValue":
								if (((CAjrInpValue)c)._RealMode) Write(sec, c.Name, ((CAjrInpValue)c).Value);
								else							 Write(sec, c.Name, ((CAjrInpValue)c).IntValue);
								break;
							case "CAjrVT100":
								((CAjrVT100)c).SavePermInfoToProfile();
								break;
							case "CAjrTimeChart":
								((CAjrTimeChart)c).SavePermInfoToProfile();
								break;
						}
					}
				}
			}
		}
		//----- 全コントロールロード ---------------------------------------------------------------------------//
		public static void LoadAllCtrls(Control form)
		{
			SubLoadAllCtrls(form, form.Name, null, null, ELoadAllOpt.NoOption);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadAllCtrls(Control form, string[] includes)
		{
			SubLoadAllCtrls(form, form.Name, includes, null, ELoadAllOpt.NoOption);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadAllCtrlsExc(Control form, string[] excludes)
		{
			SubLoadAllCtrls(form, form.Name, null, excludes, ELoadAllOpt.NoOption);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadAllCtrls(Control form, ELoadAllOpt opt)
		{
			SubLoadAllCtrls(form, form.Name, null, null, opt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadAllCtrls(Control form, string[] includes, ELoadAllOpt opt)
		{
			SubLoadAllCtrls(form, form.Name, includes, null, opt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void LoadAllCtrlsExc(Control form, string[] excludes, ELoadAllOpt opt)
		{
			SubLoadAllCtrls(form, form.Name, null, excludes, opt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		private static void SubLoadAllCtrls(Control form, string sec, string[] includes, string[] excludes, ELoadAllOpt opt)
		{
			bool	fDo = false;

			//	コントロール収集
			Control[] all = GetAllControls(form);
			//	設定値ロード（テキストボックス，チェックボックス，ラジオボタン）
			foreach (Control c in all) {
				Type type = c.GetType();
				if (c.TabStop || type.Name == "RadioButton") {

					if		(includes != null) fDo =  (FindNames(type.Name, includes) || FindNames(c.Name, includes));
					else if (excludes != null) fDo = !(FindNames(type.Name, excludes) || FindNames(c.Name, excludes));
					else					   fDo = true;

					if (fDo) {
						switch (type.Name) {
							case "TextBox":
								((TextBox)c).Text = Read(sec, c.Name, ((TextBox)c).Text);
								break;
							case "CheckBox":
								((CheckBox)c).Checked = Read(sec, c.Name, ((CheckBox)c).Checked);
								break;
							case "RadioButton":
								if (Read(sec, c.Name, false)) {
									((RadioButton)c).Checked = true;
									//	「ラジオボタンでClick()イベント生成」指定あり
									if ((opt & ELoadAllOpt.RbtClickEvent) != 0) {
										((RadioButton)c).PerformClick();
									}
								}
								break;
						}
					}
				}
			}

			//	設定値ロード（リストボックス，コンボボックス）
			foreach (Control c in all) {
				Type type = c.GetType();
				if (c.TabStop) {

					if		(includes != null) fDo =  (FindNames(type.Name, includes) || FindNames(c.Name, includes));
					else if (excludes != null) fDo = !(FindNames(type.Name, excludes) || FindNames(c.Name, excludes));
					else					   fDo = true;

					if (fDo) {
						switch (type.Name) {
							case "ListBox":
							case "CheckedListBox":
								LoadListBox(form, c);
								break;
							case "ComboBox":
								LoadComboBox(form, c);
								break;
						}
					}
				}
			}

			//	設定値ロード（数値入力，ＶＴ１００，タイムチャート）
			foreach (Control c in all) {
				Type type = c.GetType();
				if (c.TabStop) {

					if		(includes != null) fDo =  (FindNames(type.Name, includes) || FindNames(c.Name, includes));
					else if (excludes != null) fDo = !(FindNames(type.Name, excludes) || FindNames(c.Name, excludes));
					else					   fDo = true;

					if (fDo) {
						switch (type.Name) {
							case "CAjrInpValue":
								if (((CAjrInpValue)c)._RealMode) ((CAjrInpValue)c).Value	= Read(sec, c.Name, ((CAjrInpValue)c).Value);
								else							 ((CAjrInpValue)c).IntValue = Read(sec, c.Name, ((CAjrInpValue)c).IntValue);
								break;
							case "CAjrVT100":
								((CAjrVT100)c).LoadPermInfoFromProfile(sec + "\\" + c.Name);
								break;
							case "CAjrTimeChart":
								((CAjrTimeChart)c).LoadPermInfoFromProfile(sec + "\\" + c.Name);
								break;
						}
					}
				}
			}

		}
		//----- リストボックスセーブ ---------------------------------------------------------------------------//
		public static void SaveListBox(Control form, Control list_box)
		{
			Type type = list_box.GetType();
			if (type.Name == "ListBox" || type.Name == "CheckedListBox") {
				ListBox lbx = (ListBox)list_box;
				string	sec = form.Name + "\\" + lbx.Name;
				string	sel;
				//	プロファイルセクション消去
				DelSect(sec);
				//	項目数セーブ
				Write(sec, "LbxCnt", lbx.Items.Count);
				//	項目セーブ
				for (int i = 0; i < lbx.Items.Count; i++) {
					if (type.Name == "ListBox") {
						if (lbx.GetSelected(i)) sel = "10";
						else					sel = "00";
					}
					else {
						if (lbx.GetSelected(i)) {
							if (((CheckedListBox)list_box).GetItemCheckState(i) == CheckState.Checked) sel = "11";
							else																	   sel = "10";
						}
						else {
							if (((CheckedListBox)list_box).GetItemCheckState(i) == CheckState.Checked) sel = "01";
							else																	   sel = "00";
						}
					}
					Write(sec, "Lbx" + i.ToString("00000"), sel + lbx.Items[i].ToString());
				}
			}
		}
		//----- リストボックスロード ---------------------------------------------------------------------------//
		public static void LoadListBox(Control form, Control list_box)
		{
			Type type = list_box.GetType();
			if (type.Name == "ListBox" || type.Name == "CheckedListBox") {
				ListBox lbx = (ListBox)list_box;
				string	sec = form.Name + "\\" + lbx.Name;
				string	sel;
				string	sitem;
				//	項目数読み出し
				int cnt = Read(sec, "CboCnt", -999);
				if (cnt != -999) {
					//	リストボックスクリアー
					lbx.Items.Clear();
					//	項目ロード
					for (int i = 0; i < cnt; i++) {
						sitem = Read(sec, "Lbx" + i.ToString("00000"), "#$$@AjcLbxNoItem@$$#");
						if (sitem == "#$$@AjcLbxNoItem@$$#") break;
						if (sitem.Length >= 2) {
							sel = sitem.Substring(0, 2);
							sitem = sitem.Remove(0, 2);
							int ix = lbx.Items.Add(sitem);
							if (ix >= 0) {
								//	選択状態設定
								if (sel == "10" || sel == "11") {
									lbx.SetSelected(ix, true);
								}
								//	チェック状態設定
								if (type.Name == "CheckedListBox") {
									if (sel == "01" || sel == "11") {
										((CheckedListBox)list_box).SetItemCheckState(i, CheckState.Checked);
									}
								}
							}
						}
					}
				}
			}
		}
		//----- コンボボックスセーブ ---------------------------------------------------------------------------//
		public static void SaveComboBox(Control form, Control combo_box)
		{
			Type type = combo_box.GetType();
			if (type.Name == "ComboBox") {
				ComboBox cbo = (ComboBox)combo_box;
				string	sec = form.Name + "\\" + cbo.Name;
				//	プロファイルセクション消去
				DelSect(sec);
				//	項目数セーブ
				Write(sec, "CboCnt", cbo.Items.Count);
				//	項目セーブ
				for (int i = 0; i < cbo.Items.Count; i++) {
					Write(sec, "Cbo" + i.ToString("00000"), cbo.Items[i].ToString());
				}
				//	選択インデクスセーブ
				Write(sec, "CboSel", cbo.SelectedIndex);
			}
		}
		//----- コンボボックスロード ---------------------------------------------------------------------------//
		public static void LoadComboBox(Control form, Control combo_box)
		{
			Type type = combo_box.GetType();
			if (type.Name == "ComboBox") {
				ComboBox cbo = (ComboBox)combo_box;
				string	sec = form.Name + "\\" + cbo.Name;
				string	sitem;
				//	項目数読み出し
				int cnt = Read(sec, "CboCnt", -999);
				if (cnt != -999) {
					//	コンボボックスクリアー
					cbo.Items.Clear();
					//	項目ロード
					for (int i = 0; i < cnt; i++) {
						sitem = Read(sec, "Cbo" + i.ToString("00000"), "#$$@AjcCboNoItem@$$#");
						if (sitem == "#$$@AjcCboNoItem@$$#") break;
						if (sitem.Length >= 1) {
							cbo.Items.Add(sitem);
						}
					}
					//	選択状態設定
					int sel = Read(sec, "CboSel", -1);
					if (sel >= 0) {
						cbo.SelectedIndex = sel;
					}
				}
			}
		}
		//------------------------------------------------------------------------------------------------------//
		//	レジストリの環境変数																				//
		//------------------------------------------------------------------------------------------------------//
		//----- ユーザ環境変数取得				   -------------------------------------------------------------//
		public static string GetUserEnv(string name, out ERegType type)
		{
			string	rc = null;
			rc = CAjrApi.AjcRegHkCuEnvGet(name, out type);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetUserEnv(string name)
		{
			string	rc = null;
			ERegType type;
			rc = CAjrApi.AjcRegHkCuEnvGet(name, out type);
			return rc;
		}
		//----- システム環境変数取得			   -------------------------------------------------------------//
		public static string GetSysEnv(string name, out ERegType type)
		{
			string	rc = null;
			rc = CAjrApi.AjcRegHkLmEnvGet(name, out type);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetSysEnv(string name)
		{
			string	rc = null;
			ERegType type;
			rc = CAjrApi.AjcRegHkLmEnvGet(name, out type);
			return rc;
		}
		//----- ユーザ環境変数書き込み			   -------------------------------------------------------------//
		public static bool PutUserEnv(string name, string text, ERegType type)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvPut(name, type, text);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool PutUserEnv(string name, string text)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvPut(name, ERegType.SZ, text);
			return rc;
		}
		//----- システム環境変数書き込み		   -------------------------------------------------------------//
		public static bool PutSysEnv(string name, string text, ERegType type)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvPut(name, type, text);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool PutSysEnv(string name, string text)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvPut(name, ERegType.SZ, text);
			return rc;
		}
		//----- ユーザ環境変数削除			   -----------------------------------------------------------------//
		public static bool DelUserEnv(string name)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvDel(name);
			return rc;
		}
		//----- システム環境変数削除		   -----------------------------------------------------------------//
		public static bool DelSysEnv(string name)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvDel(name);
			return rc;
		}
		//----- ユーザ環境変数へ項目追加	   -----------------------------------------------------------------//
		public static bool AddUserEnvItem(string name, string item, char dlm)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvAddItem(name, item, dlm, false, ERegType.SZ);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AddUserEnvItem(string name, string item, char dlm, bool fFront)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvAddItem(name, item, dlm, fFront, ERegType.SZ);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AddUserEnvItem(string name, string item, char dlm, ERegType type)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvAddItem(name, item, dlm, false, type);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AddUserEnvItem(string name, string item, char dlm, bool fFront, ERegType type)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvAddItem(name, item, dlm, fFront, type);
			return rc;
		}
		//----- システム環境変数へ項目追加	   -----------------------------------------------------------------//
		public static bool AddSysEnvItem(string name, string item, char dlm)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvAddItem(name, item, dlm, false, ERegType.SZ);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AddSysEnvItem(string name, string item, char dlm, bool fFront)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvAddItem(name, item, dlm, fFront, ERegType.SZ);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AddSysEnvItem(string name, string item, char dlm, ERegType type)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvAddItem(name, item, dlm, false, type);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool AddSysEnvItem(string name, string item, char dlm, bool fFront, ERegType type)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvAddItem(name, item, dlm, fFront, type);
			return rc;
		}
		//----- ユーザ環境変数から項目削除	   -----------------------------------------------------------------//
		public static bool DelUserEnvItem(string name, string item, char dlm, bool fErase)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvDelItem(name, item, dlm, fErase);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool DelUserEnvItem(string name, string item)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkCuEnvDelItem(name, item, ';', false);
			return rc;
		}
		//----- システム環境変数から項目削除	----------------------------------------------------------------//
		public static bool DelSysEnvItem(string name, string item, char dlm, bool fErase)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvDelItem(name, item, dlm, fErase);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool DelSysEnvItem(string name, string item)
		{
			bool	rc;
			rc = CAjrApi.AjcRegHkLmEnvDelItem(name, item, ';', false);
			return rc;
		}
		//----- 環境変数の有効化	----------------------------------------------------------------------------//
		public static void EnableEnvironment()
		{
			CAjrApi.AjcRegEnableEnvironment();
		}
	}
	//==========================================================================================================//
	//																											//
	//	ファイル／フォルダ操作	SAjrFop																			//
	//																											//
	//==========================================================================================================//
	public static class SAjrFop
	{
		//======================================================================================================//
		//	API	AjcFileDir.h 																					//
		//======================================================================================================//
		//----- AjcCopyFolderStructEx --------------------------------------------------------------------------//
		public static bool CopyFolderStruct(string dirFrom, string dirTo)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, EFscOpt.NONE, (IntPtr)0, null, null);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, FopCbkScpNtc cbCpyNtc)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, EFscOpt.NONE, (IntPtr)0, cbCpyNtc, null);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, EFscOpt opt, FopCbkScpNtc cbCpyNtc)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, opt, (IntPtr)0, cbCpyNtc, null);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, FopCbkScpNtc cbCpyNtc, FopCbkScpQry cbCpyQry)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, EFscOpt.NONE, (IntPtr)0, cbCpyNtc, cbCpyQry);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, EFscOpt opt, FopCbkScpNtc cbCpyNtc, FopCbkScpQry cbCpyQry)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, EFscOpt.NONE, (IntPtr)0, cbCpyNtc, cbCpyQry);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, IntPtr cbp, FopCbkScpNtc cbCpyNtc)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, EFscOpt.NONE, cbp, cbCpyNtc, null);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, IntPtr cbp, FopCbkScpNtc cbCpyNtc, FopCbkScpQry cbCpyQry)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, EFscOpt.NONE, cbp, cbCpyNtc, cbCpyQry);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFolderStruct(string dirFrom, string dirTo, EFscOpt opt, IntPtr cbp, FopCbkScpNtc cbCpyNtc, FopCbkScpQry cbCpyQry)
		{
			bool	rc;
			rc = CAjrApi.AjcCopyFolderStructEx(dirFrom, dirTo, opt, cbp, cbCpyNtc, cbCpyQry);
			return rc;
		}
		//----- AjcCopyFilesEx			------------------------------------------------------------------------//
		public static bool CopyFiles(string PathFrom, string PathTo)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, "*.*"	, ECpyfOpt.CREATEALWAYS, (IntPtr)0, null, null, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, ECpyfOpt.CREATEALWAYS, (IntPtr)0, null, null, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, opt, (IntPtr)0, null, null, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt,			  FopCbkFcpNtc cbFcpNtc)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, opt, (IntPtr)0, cbFcpNtc, null, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt, IntPtr cbp, FopCbkFcpNtc cbFcpNtc)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, opt, cbp		, cbFcpNtc, null, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt,			  FopCbkFcpNtc cbFcpNtc, FopCbkFcpQry cbFcpQry)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, opt, (IntPtr)0, cbFcpNtc, cbFcpQry, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt, IntPtr cbp, FopCbkFcpNtc cbFcpNtc, FopCbkFcpQry cbFcpQry)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, opt, cbp		, cbFcpNtc, cbFcpQry, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CopyFiles(string PathFrom, string PathTo, string WildCard, ECpyfOpt opt, IntPtr cbp, FopCbkFcpNtc cbFcpNtc, FopCbkFcpQry cbFcpQry, FopCbkFcpPgs cbFcpPgs)
		{
			return CAjrApi.AjcCopyFilesEx(PathFrom, PathTo, WildCard, opt, cbp		, cbFcpNtc, cbFcpQry, cbFcpPgs);
		}
		//----- AjcRemoveFolder			------------------------------------------------------------------------//
		public static bool RemoveFolder(string path)
		{
			return CAjrApi.AjcRemoveFolder(path, (IntPtr)0, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool RemoveFolder(string path, FopCbkRmvDir cb)
		{
			bool	rc;
			rc = CAjrApi.AjcRemoveFolder(path, (IntPtr)0, cb);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool RemoveFolder(string path, IntPtr cbp, FopCbkRmvDir cbRmv)
		{
			bool	rc;
			rc = CAjrApi.AjcRemoveFolder(path, cbp, cbRmv);
			return rc;
		}
		//----- AjcCleanFolder			------------------------------------------------------------------------//
		public static bool CleanFolder(string path)
		{
			return CAjrApi.AjcCleanFolder(path, (IntPtr)0, null);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CleanFolder(string path, FopCbkRmvDir cbRmv)
		{
			bool	rc;
			rc = CAjrApi.AjcCleanFolder(path, (IntPtr)0, cbRmv);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool CleanFolder(string path, IntPtr cbp, FopCbkRmvDir cbRmv)
		{
			bool	rc;
			rc = CAjrApi.AjcCleanFolder(path, cbp, cbRmv);
			return rc;
		}
		//----- AjcAjcEnumFilesMatchingList	--------------------------------------------------------------------//
		public static int EnumFileMatchingList(string path1, string path2, IntPtr cbp, FopCbkFmlEnum cbEnum)
		{
			int	rc;
			rc = CAjrApi.AjcEnumFileMatchingListMsil(path1, path2, EFmlOpt.NODIR, cbp, null, cbEnum);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static int EnumFileMatchingList(string path1, string path2, EFmlOpt opt, IntPtr cbp, FopCbkFmlQuery cbQuery, FopCbkFmlEnum cbEnum)
		{
			int	rc;
			rc = CAjrApi.AjcEnumFileMatchingListMsil(path1, path2, opt, cbp, cbQuery, cbEnum);
			return rc;
		}
		//----- AjcPathMatchSpec			--------------------------------------------------------------------//
		public static bool PathMatchSpecs(string path, string specs)
		{
			bool	rc;
			rc = CAjrApi.AjcPathMatchSpec(path, specs);
			return rc;
		}
		//----- AjcPathMatchStr			------------------------------------------------------------------------//
		public static bool PathMatchStrings(string path, string strings)
		{
			bool	rc;
			rc = CAjrApi.AjcPathMatchStr(path, strings);
			return rc;
		}
		//----- AjcPathExists			------------------------------------------------------------------------//
		public static bool IsExistsPath(string path)
		{
			bool	rc;
			rc = CAjrApi.AjcPathExists(path);
			return rc;
		}
		//----- AjcPathIsDirectory		------------------------------------------------------------------------//
		public static bool IsPathDirectory(string path)
		{
			bool	rc;
			rc = CAjrApi.AjcPathIsDirectory(path);
			return rc;
		}
		//----- AjcPathIsFile			------------------------------------------------------------------------//
		public static bool IsPathFile(string path)
		{
			bool	rc;
			rc = CAjrApi.AjcPathIsFile(path);
			return rc;
		}
		//----- AjcGetFileSize			------------------------------------------------------------------------//
		public static long GetFileSize(string path)
		{
			long	rc;
			rc = CAjrApi.AjcGetFileSize(path);
			return rc;
		}
		//----- AjcGetFileTime1970		------------------------------------------------------------------------//
		public static uint GetFileTime1970(string path)
		{
			uint	rc;
			rc = CAjrApi.AjcGetFileTime1970(path);
			return rc;
		}
		//----- AjcFileCompare			------------------------------------------------------------------------//
		public static bool FileCompare(string path1, string path2)
		{
			bool	rc;
			rc = CAjrApi.AjcFileCompare(path1, path2);
			return rc;
		}
	}
	//==========================================================================================================//
	//																											//
	//	３Ｄベクトル演算	SAjrMath																			//
	//																											//
	//==========================================================================================================//
	public static class SAjrMath
	{
		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- Sin							   -----------------------------------------------------------------//
		public static double Sin(double degree)
		{
			double	rc;
			rc = CAjrApi.AjcSin(degree);
			return rc;
		}
		//----- Sinh 						   -----------------------------------------------------------------//
		public static double Sinh(double degree)
		{
			double	rc;
			rc = CAjrApi.AjcSinh(degree);
			return rc;
		}
		//----- ASin 						   -----------------------------------------------------------------//
		public static double ASin(double x)
		{
			double	rc;
			rc = CAjrApi.AjcASin(x);
			return rc;
		}
		//----- Cos							   -----------------------------------------------------------------//
		public static double Cos(double degree)
		{
			double	rc;
			rc = CAjrApi.AjcCos(degree);
			return rc;
		}
		//----- Cosh 						   -----------------------------------------------------------------//
		public static double Cosh(double degree)
		{
			double	rc;
			rc = CAjrApi.AjcCosh(degree);
			return rc;
		}
		//----- ACos 						   -----------------------------------------------------------------//
		public static double ACos(double x)
		{
			double	rc;
			rc = CAjrApi.AjcACos(x);
			return rc;
		}
		//----- Tan							   -----------------------------------------------------------------//
		public static double Tan(double degree)
		{
			double	rc;
			rc = CAjrApi.AjcTan(degree);
			return rc;
		}
		//----- Tanh 						   -----------------------------------------------------------------//
		public static double Tanh(double degree)
		{
			double	rc;
			rc = CAjrApi.AjcTanh(degree);
			return rc;
		}
		//----- ATan 						   -----------------------------------------------------------------//
		public static double ATan(double x)
		{
			double	rc;
			rc = CAjrApi.AjcATan(x);
			return rc;
		}
		//----- ATan2						   -----------------------------------------------------------------//
		public static double ATan2(double y, double x)
		{
			double	rc;
			rc = CAjrApi.AjcATan2(y, x);
			return rc;
		}
		//
		//	３Ｄベクトル演算
		//
		//----- V3dAdd						   -----------------------------------------------------------------//
		public static AJC3DVEC V3dAdd(AJC3DVEC v1, AJC3DVEC v2)
		{
			AJC3DVEC	vr;
			vr = CAjrApi.AjcV3dAdd(v1, v2);
			return vr;
		}
		//----- V3dSub						   -----------------------------------------------------------------//
		public static AJC3DVEC V3dSub(AJC3DVEC v1, AJC3DVEC v2)
		{
			AJC3DVEC	vr;
			vr = CAjrApi.AjcV3dSub(v1, v2);
			return vr;
		}
		//----- V3dMult						   -----------------------------------------------------------------//
		public static AJC3DVEC V3dMult(AJC3DVEC v, double n)
		{
			AJC3DVEC vr;
			vr = CAjrApi.AjcV3dMult(v, n);
			return vr;
		}
		//----- V3dDiv						   -----------------------------------------------------------------//
		public static AJC3DVEC V3dDiv(AJC3DVEC v, double n)
		{
			AJC3DVEC	vr;
			vr = CAjrApi.AjcV3dDiv(v, n);
			return vr;
		}
		//----- V3dSetLineVec				   -----------------------------------------------------------------//
		public static AJC3DLVEC V3dSetLineVec(AJC3DVEC p1, AJC3DVEC p2)
		{
			AJC3DLVEC vr;
			vr = CAjrApi.AjcV3dSetLineVec(p1, p2);
			return vr;
		}
		//----- V3dSetLinePoint				   -----------------------------------------------------------------//
		public static AJC3DLINE V3dSetLinePoint(AJC3DVEC p1, AJC3DVEC p2)
		{
			AJC3DLINE vr;
			vr = CAjrApi.AjcV3dSetLinePoint(p1, p2);
			return vr;
		}
		//----- V3dSetTriPoint				   -----------------------------------------------------------------//
		public static AJC3DTRI V3dSetTriPoint(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3)
		{
			AJC3DTRI tri;
			tri = CAjrApi.AjcV3dSetTriPoint(p1, p2, p3);
			return tri;
		}
		//----- V3dLength					   -----------------------------------------------------------------//
		public static double V3dLength(AJC3DVEC v)
		{
			double	rc;
			rc = CAjrApi.AjcV3dLength(v);
			return rc;
		}
		//----- V3dLineCenter				   -----------------------------------------------------------------//
		public static AJC3DVEC V3dLineCenter(AJC3DLVEC vl)
		{
			AJC3DVEC pc;
			pc = CAjrApi.AjcV3dLVecCenter(vl);
			return pc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static AJC3DVEC V3dLineCenter(AJC3DLINE vl)
		{
			AJC3DVEC pc;
			pc = CAjrApi.AjcV3dLineCenter(vl);
			return pc;
		}

		//----- V3dOuter 					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dOuter(AJC3DVEC v1, AJC3DVEC v2)
		{
			AJC3DVEC vo;
			vo = CAjrApi.AjcV3dOuter(v1, v2);
			return vo;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static AJC3DVEC V3dOuter(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3)
		{
			AJC3DVEC v1, v2, vo;
			v1 = CAjrApi.AjcV3dSub(p2, p1);
			v2 = CAjrApi.AjcV3dSub(p3, p2);
			vo = CAjrApi.AjcV3dOuter(v1, v2);
			return vo;
		}
		//----- V3dInner 					   -----------------------------------------------------------------//
		public static double V3dInner(AJC3DVEC v1, AJC3DVEC v2)
		{
			double	rc;
			rc = CAjrApi.AjcV3dInner(v1, v2);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static double V3dInner(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3)
		{
			double	 rc;
			AJC3DVEC v1, v2;
			v1 = CAjrApi.AjcV3dSub(p2, p1);
			v2 = CAjrApi.AjcV3dSub(p3, p2);
			rc = CAjrApi.AjcV3dInner(v1, v2);
			return rc;
		}
		//----- V3dPlaneVec					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dPlaneVec(AJC3DTRI tri)
		{
			AJC3DVEC vh;
			vh = CAjrApi.AjcV3dPlaneVec(tri);
			return vh;
		}
		//----- V3dNormal					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dNormal(AJC3DVEC v)
		{
			AJC3DVEC vu;
			vu = CAjrApi.AjcV3dNormal(v);
			return vu;
		}
		//----- V3dTheta 					   -----------------------------------------------------------------//
		public static double V3dTheta(AJC3DVEC v1, AJC3DVEC v2)
		{
			double	rc;
			rc = CAjrApi.AjcV3dTheta(v1, v2);
			return rc;
		}
		//----- V3dVertVecP2L				   -----------------------------------------------------------------//
		public static AJC3DVEC V3dVertVecP2L(AJC3DLVEC vl, AJC3DVEC pt)
		{
			AJC3DVEC vr;
			vr = CAjrApi.AjcV3dVertVecP2L(vl, pt);
			return vr;
		}
		//----- V3dDistP2L					   -----------------------------------------------------------------//
		public static double V3dDistP2L(AJC3DLVEC vl, AJC3DVEC pt, out AJC3DVEC vr)
		{
			double	rc;
			rc = CAjrApi.AjcV3dDistP2L(vl, pt, out vr);
			return rc;
		}
		//----- V3dDistP2P					   -----------------------------------------------------------------//
		public static double V3dDistP2P(AJC3DVEC p1, AJC3DVEC p2)
		{
			double	rc;
			rc = CAjrApi.AjcV3dDistP2P(p1, p2);
			return rc;
		}
		//----- V3dCrossL2L					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dCrossL2L(AJC3DLVEC vl1, AJC3DLVEC vl2)
		{
			AJC3DVEC px;
			px = CAjrApi.AjcV3dCrossL2LEx(vl1, vl2);
			return px;
		}
		//----- V3dCrossP2F					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dCrossP2F(AJC3DLVEC vl, AJC3DVEC pt)
		{
			AJC3DVEC px;
			px = CAjrApi.AjcV3dCrossP2F(vl, pt);
			return px;
		}
		//----- V3dOrthoVecOnPlane			   -----------------------------------------------------------------//
		public static AJC3DVEC V3dOrthoVecOnPlane(AJC3DLINE vl, AJC3DVEC vh)
		{
			AJC3DVEC vx;
			vx = CAjrApi.AjcV3dOrthoVecOnPlane(vl, vh);
			return vx;
		}
		//----- V3dMultMat					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dMultMat(AJC3DVEC v, AJC3DMAT m)
		{
			AJC3DVEC vr;
			vr = CAjrApi.AjcV3dMultMat(v, m);
			return vr;
		}
		//----- V3dRotateX					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dRotateX(AJC3DVEC pt, double t)
		{
			AJC3DVEC pr;
			pr = CAjrApi.AjcV3dRotateX(pt, t);
			return pr;
		}
		//----- V3dRotateY					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dRotateY(AJC3DVEC pt, double t)
		{
			AJC3DVEC pr;
			pr = CAjrApi.AjcV3dRotateY(pt, t);
			return pr;
		}
		//----- V3dRotateZ					   -----------------------------------------------------------------//
		public static AJC3DVEC V3dRotateZ(AJC3DVEC pt, double t)
		{
			AJC3DVEC pr;
			pr = CAjrApi.AjcV3dRotateZ(pt, t);
			return pr;
		}
		//----- V3dRotateAny 				   -----------------------------------------------------------------//
		public static AJC3DVEC V3dRotateAny(AJC3DVEC pt, double t, AJC3DVEC vs)
		{
			AJC3DVEC pr;
			pr = CAjrApi.AjcV3dRotateAny(pt, t, vs);
			return pr;
		}
		//----- V3dAnyOrthoVec				   -----------------------------------------------------------------//
		public static AJC3DVEC V3dAnyOrthoVec(AJC3DVEC v)
		{
			AJC3DVEC vr;
			vr = CAjrApi.AjcV3dAnyOrthoVec(v);
			return vr;
		}
		//----- V3dRotateOnPlane	 		   -----------------------------------------------------------------//
		public static AJC3DVEC V3dRotateOnPlane(AJC3DVEC pt, AJC3DLVEC vl, double t)
		{
			AJC3DVEC pr;
			pr = CAjrApi.AjcV3dRotateOnPlane(pt, vl, t);
			return pr;
		}
		//----- V3dCalcCircle		 		   -----------------------------------------------------------------//
		public static double V3dCalcCircle(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, out AJC3DVEC vc)
		{
			double			r;
			AJC3DVEC		vh;
			AJC3DCIRINFO	ci;
			r = CAjrApi.AjcV3dCalcCircleVEx(p1, p2, p3, out vc, out vh, out ci);
			return r;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static double V3dCalcCircle(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, out AJC3DVEC vc, out AJC3DVEC vh)
		{
			double			r;
			AJC3DCIRINFO	ci;
			r = CAjrApi.AjcV3dCalcCircleVEx(p1, p2, p3, out vc, out vh, out ci);
			return r;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static double V3dCalcCircle(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, out AJC3DVEC vc, out AJC3DVEC vh, out AJC3DCIRINFO ci)
		{
			double			r;
			r = CAjrApi.AjcV3dCalcCircleVEx(p1, p2, p3, out vc, out vh, out ci);
			return r;
		}
		//----- V3dCalcSphere		 		   -----------------------------------------------------------------//
		public static double V3dCalcSphere(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, AJC3DVEC p4, out AJC3DVEC vc)
		{
			double			r;
			AJC3DSPHINFO	si;
			r = CAjrApi.AjcV3dCalcSphereVEx(p1, p2, p3, p4, out vc, out si);
			return r;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static double V3dCalcSphere(AJC3DVEC p1, AJC3DVEC p2, AJC3DVEC p3, AJC3DVEC p4, out AJC3DVEC vc, out AJC3DSPHINFO si)
		{
			double			r;
			r = CAjrApi.AjcV3dCalcSphereVEx(p1, p2, p3, p4, out vc, out si);
			return r;
		}
		//
		//	２Ｄベクトル演算
		//
		//----- V2dAdd						   -----------------------------------------------------------------//
		public static AJC2DVEC V2dAdd(AJC2DVEC v1, AJC2DVEC v2)
		{
			AJC2DVEC	vr;
			vr = CAjrApi.AjcV2dAdd(v1, v2);
			return vr;
		}
		//----- V2dSub						   -----------------------------------------------------------------//
		public static AJC2DVEC V2dSub(AJC2DVEC v1, AJC2DVEC v2)
		{
			AJC2DVEC	vr;
			vr = CAjrApi.AjcV2dSub(v1, v2);
			return vr;
		}
		//----- V2dMult						   -----------------------------------------------------------------//
		public static AJC2DVEC V2dMult(AJC2DVEC v, double n)
		{
			AJC2DVEC vr;
			vr = CAjrApi.AjcV2dMult(v, n);
			return vr;
		}
		//----- V2dDiv						   -----------------------------------------------------------------//
		public static AJC2DVEC V2dDiv(AJC2DVEC v, double n)
		{
			AJC2DVEC	vr;
			vr = CAjrApi.AjcV2dDiv(v, n);
			return vr;
		}
		//----- V2dLength					   -----------------------------------------------------------------//
		public static double V2dLength(AJC2DVEC v)
		{
			double	rc;
			rc = CAjrApi.AjcV2dLength(v);
			return rc;
		}
		//----- V2dOuter 					   -----------------------------------------------------------------//
		public static double V2dOuter(AJC2DVEC v1, AJC2DVEC v2)
		{
			double rc;
			rc = CAjrApi.AjcV2dOuter(v1, v2);
			return rc;
		}
		//----- V2dInner 					   -----------------------------------------------------------------//
		public static double V2dInner(AJC2DVEC v1, AJC2DVEC v2)
		{
			double	rc;
			rc = CAjrApi.AjcV2dInner(v1, v2);
			return rc;
		}
		//----- V2dNormal					   -----------------------------------------------------------------//
		public static AJC2DVEC V2dNormal(AJC2DVEC v)
		{
			AJC2DVEC vu;
			vu = CAjrApi.AjcV2dNormal(v);
			return vu;
		}
		//----- V2dTheta 					   -----------------------------------------------------------------//
		public static double V2dTheta(AJC2DVEC v1, AJC2DVEC v2)
		{
			double	rc;
			rc = CAjrApi.AjcV2dTheta(v1, v2);
			return rc;
		}
		//----- V2dVertVecP2L				   -----------------------------------------------------------------//
		public static AJC2DVEC V2dVertVecP2L(AJC2DLVEC vl, AJC2DVEC pt)
		{
			AJC2DVEC vr;
			vr = CAjrApi.AjcV2dVertVecP2L(vl, pt);
			return vr;
		}
		//----- V2dDistP2L					   -----------------------------------------------------------------//
		public static double V2dDistP2L(AJC2DLVEC vl, AJC2DVEC pt, out AJC2DVEC vr)
		{
			double	rc;
			rc = CAjrApi.AjcV2dDistP2L(vl, pt, out vr);
			return rc;
		}
		//----- V2dDistP2P					   -----------------------------------------------------------------//
		public static double V2dDistP2P(AJC2DVEC p1, AJC2DVEC p2)
		{
			double	rc;
			rc = CAjrApi.AjcV2dDistP2P(p1, p2);
			return rc;
		}
		//----- V2dCrossL2L					   -----------------------------------------------------------------//
		public static AJC2DVEC V2dCrossL2L(AJC2DLVEC vl1, AJC2DLVEC vl2)
		{
			AJC2DVEC px;
			px = CAjrApi.AjcV2dCrossL2LEx(vl1, vl2);
			return px;
		}
		//----- V2dRotate					   -----------------------------------------------------------------//
		public static AJC2DVEC V2dRotate(AJC2DVEC pt, double t)
		{
			AJC2DVEC pr;
			pr = CAjrApi.AjcV2dRotate(pt, t);
			return pr;
		}
		//----- V2dAnyOrthoVec				   -----------------------------------------------------------------//
		public static AJC2DVEC V2dAnyOrthoVec(AJC2DVEC v)
		{
			AJC2DVEC vr;
			vr = CAjrApi.AjcV2dAnyOrthoVec(v);
			return vr;
		}
	}
	//==========================================================================================================//
	//																											//
	//	汎用メソッド	SAjrGsr																					//
	//																											//
	//==========================================================================================================//
	public static class SAjrGsr
	{
		//----- コントロール収集 -------------------------------------------------------------------------------//
		private static Control[] GetAllControls(Control top)
		{
			ArrayList buf = new ArrayList();
			foreach (Control c in top.Controls) {
				buf.Add(c);
				buf.AddRange(GetAllControls(c));
			}
			return (Control[])buf.ToArray(typeof(Control));
		}

		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- バージョン取得 ---------------------------------------------------------------------------------//
		public	static string GetVersion()
		{
			return CAjrApi.AjcGetVersion();
		}
		//----- 言語種別 設定 ----------------------------------------------------------------------------------//
		public	static void SetLang(ELangId lang)
		{
			CAjrApi.AjcSetLangId(lang);
		}
		//----- 言語種別 取得 ----------------------------------------------------------------------------------//
		public	static ELangId GetLang()
		{
			return CAjrApi.AjcGetLangId();
		}
		//----- 言語選択テキスト				----------------------------------------------------------------//
		public	static string LangSel(string Jpn, string Eng)
		{
			string s;
			s = CAjrApi.LngSel(Jpn, Eng);
			return s;
		}
		//======================================================================================================//
		//	API 	AjcGetFileDir.h 																			//
		//======================================================================================================//
		//----- AjcGetSaveFile				   -----------------------------------------------------------------//
		public static string	GetSaveFile(string title, string filter, string defExt)
		{
			return GetSaveFile((IntPtr)0, "", title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string	GetSaveFile(string initialPath, string title, string filter, string defExt)
		{
			return GetSaveFile((IntPtr)0, initialPath, title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string	GetSaveFile(object owner, string title, string filter, string defExt)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(owner, "Handle");
			return GetSaveFile(hWnd, "", title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string	GetSaveFile(object owner, string initialPath, string title, string filter, string defExt)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(owner, "Handle");
			return GetSaveFile(hWnd, initialPath, title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string	GetSaveFile(IntPtr hOwner, string title, string filter, string defExt)
		{
			return GetSaveFile(hOwner, "", title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string	GetSaveFile(IntPtr hOwner, string initialPath, string title, string filter, string defExt)
		{
			string	rc = "";
			StringBuilder s = new StringBuilder(512);
			s.Append(initialPath);
			if (CAjrApi.AjcGetSaveFile(hOwner, title, filter, defExt, s, (int)s.Capacity)) rc = s.ToString();
			return rc;
		}
		//----- AjcGetOpenFile				   -----------------------------------------------------------------//
		public static string GetOpenFile(string title, string filter, string defExt)
		{
			return GetOpenFile((IntPtr)0, "", title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetOpenFile(string initialPath, string title, string filter, string defExt)
		{
			return GetOpenFile((IntPtr)0, initialPath, title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetOpenFile(object owner, string title, string filter, string defExt)
		{
			IntPtr hOwner = CAjrApi.GetPropIntPtr(owner, "Handle");
			return GetOpenFile(hOwner, "", title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetOpenFile(object owner, string initialPath, string title, string filter, string defExt)
		{
			IntPtr hOwner = CAjrApi.GetPropIntPtr(owner, "Handle");
			return GetOpenFile(hOwner, "", title, filter, defExt);;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetOpenFile(IntPtr hOwner, string title, string filter, string defExt)
		{
			return GetOpenFile(hOwner, "", title, filter, defExt);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetOpenFile(IntPtr hOwner, string initialPath, string title, string filter, string defExt)
		{
			string	rc = "";
			StringBuilder s = new StringBuilder(512);
			s.Append(initialPath);
			if (CAjrApi.AjcGetOpenFile(hOwner, title, filter, defExt, s, (int)s.Capacity)) rc = s.ToString();
			return rc;
		}
		//----- AjcGetOpenFiles 			   -----------------------------------------------------------------//
		public static string[] GetOpenFiles(string title, string filter, string defExt)
		{
			return GetOpenFiles((IntPtr)0, null, title, filter, defExt, true);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string[] GetOpenFiles(string initialPath, string title, string filter, string defExt)
		{
			return GetOpenFiles((IntPtr)0, initialPath, title, filter, defExt, true);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string[] GetOpenFiles(object owner, string initialPath, string title, string filter, string defExt)
		{
			IntPtr hOwner = CAjrApi.GetPropIntPtr(owner, "Handle");
			return GetOpenFiles(hOwner, null, title, filter, defExt, true);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe static public string[] GetOpenFiles(IntPtr hOwner, string initialPath, string title, string filter, string defExt, bool fMulti)
		{
			string[]	rc = null;
			IntPtr		*pArr;
			IntPtr		*p;
			int			i;
			int		nFiles;

			pArr = CAjrApi.AjcGetOpenFiles(hOwner, initialPath, title, filter, defExt, fMulti, out nFiles);

			if (pArr != null) {
				rc = new string[nFiles];
				//--- 最大パス長算出 -----------//
				int		lMax = 0;
				int		stl;
				for (i = 0, p = pArr; i < nFiles; i++, p++) {
					stl = CAjrApi.AjcWStrLen(*p);
					lMax = Math.Max(lMax, stl);
				}
				//--- ストリングバッファ確保 ---//
				StringBuilder s = new StringBuilder(lMax + 1);
				//--- パス配列作成 -------------//
				for (i = 0, p = pArr; i < nFiles; i++, p++) {
					CAjrApi.AjcWStrCopy(s, *p);
					rc[i] = s.ToString();
				}
				//--- パス配列解放 -------------//
				CAjrApi.AjcReleaseOpenedFilesArray(pArr);
			}
			return rc;
		}
		//----- AjcGetFolder				   -----------------------------------------------------------------//
		public static string GetFolder(string wndTitle, string boxTitle)
		{
			return GetFolder((IntPtr)0, wndTitle, boxTitle);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetFolder(object owner, string wndTitle, string boxTitle)
		{
			IntPtr hOwner = CAjrApi.GetPropIntPtr(owner, "Handle");
			return	GetFolder(hOwner, wndTitle, boxTitle);;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static string GetFolder(IntPtr hOwner, string wndTitle, string boxTitle)
		{
			string	rc = "";
			StringBuilder s = new StringBuilder(512);
			if (CAjrApi.AjcGetFolderName(hOwner, wndTitle, boxTitle, s, false)) {
				rc = s.ToString();
			}
			return rc;
		}
		//----- AjcGetAppPath				   -----------------------------------------------------------------//
		public static string GetAppPath()
		{
			string rc;
			rc = CAjrApi.AjcGetAppPath();
			return rc;
		}
		//======================================================================================================//
		//	API 	AjcString.h 																				//
		//======================================================================================================//
		//----- AjcPathCat					   -----------------------------------------------------------------//
		public static string PathCat(string s1, string s2)
		{
			string rc;
			rc = CAjrApi.AjcPathCat(s1, s2);
			return rc;
		}
		//----- AjcGetAfterPrefix			   -----------------------------------------------------------------//
		public static string AfterPrefix(string str, string prefix, out int val)
		{
			string rc;
			rc = CAjrApi.AjcGetAfterPrefix(str, prefix, out val);
			return rc;
		}
		//----- ●AjcStrSepDecimal ----------------------------------------------------------------------------//
		public static string SepDecimal(string strDecimal)
		{
			string rc;
			rc = CAjrApi.AjcStrSepDecimal(strDecimal);
			return rc;
		}
		//----- ●AjcStrRmvSepChar ----------------------------------------------------------------------------//
		public static string RmvSepChar(string strSepDecimal)
		{
			string rc;
			rc = CAjrApi.AjcStrRmvSepChar(strSepDecimal);
			return rc;
		}
		//======================================================================================================//
		//	API 	AjcWndItem.h																				//
		//======================================================================================================//
		//----- EnableAllControls			   -----------------------------------------------------------------//
		public static void EnableAllControls(object form, bool fEnable)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(form, "Handle");
			EnableAllControls(hWnd, fEnable);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void EnableAllControls(IntPtr hWnd, bool fEnable)
		{
			CAjrApi.AjcEnableCtrlsInWnd(hWnd, fEnable);
		}
		//----- AjcEnableGroup				   -----------------------------------------------------------------//
		public static void EnableGroup(object gbox, bool fEnableGrpBox, bool fEnableCtrls)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(gbox, "Handle");
			EnableGroup(hWnd, fEnableGrpBox, fEnableCtrls);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void EnableGroup(IntPtr hCtrl, bool fEnableGrpBox, bool fEnableCtrls)
		{
			CAjrApi.AjcEnableGroup(hCtrl, fEnableGrpBox, fEnableCtrls);
		}
		//----- AjcShowGroupEx				   -----------------------------------------------------------------//
		public static void ShowGroup(object gbox, bool fShowGrpBox, bool fShowCtrls)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(gbox, "Handle");
			ShowGroup(hWnd, fShowGrpBox, fShowCtrls);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void ShowGroup(IntPtr hWnd, bool fShowGrpBox, bool fShowCtrls)
		{
			CAjrApi.AjcShowGroupEx(hWnd, fShowGrpBox, fShowCtrls);
		}
		//----- AjcMoveGroupToLoc			   -----------------------------------------------------------------//
		public static void MoveGroup(object gbox, Point pt)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(gbox, "Handle");
			MoveGroup(hWnd, pt.X, pt.Y);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void MoveGroup(object gbox, int x, int y)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(gbox, "Handle");
			MoveGroup(hWnd, x, y);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void MoveGroup(IntPtr hWnd, Point pt)
		{
			CAjrApi.AjcMoveGroupToLoc(hWnd, pt.X, pt.Y);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void MoveGroup(IntPtr hWnd, int x, int y)
		{
			CAjrApi.AjcMoveGroupToLoc(hWnd, x, y);
		}
		//----- AjcMoveGroupToOrg			   -----------------------------------------------------------------//
		public static void MoveGroup(object gbox)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(gbox, "Handle");
			MoveGroup(hWnd);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void MoveGroup(IntPtr hWnd)
		{
			CAjrApi.AjcMoveGroupToOrg(hWnd);
		}
		//----- AjcEnableCtrlToDrop			   -----------------------------------------------------------------//
		public static void EnableDropToTextBox(object ctrl, EDropMode dm)
		{
			IntPtr hWnd = CAjrApi.GetPropIntPtr(ctrl, "Handle");
			CAjrApi.AjcEnableCtrlToDrop(hWnd, dm);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void EnableDropToTextBox(IntPtr hWnd, EDropMode dm)
		{
			CAjrApi.AjcEnableCtrlToDrop(hWnd, dm);
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void EnableDropToTextBox(Control form)
		{
			EnableDropToTextBox(form, "Drop", ',', ':');
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static void EnableDropToTextBox(Control form, string kw, Char d1, Char d2)
		{
			//	コントロール収集
			Control[] all = GetAllControls(form);
			//	設定値セーブ
 			foreach (Control c in all) {
				Type type = c.GetType();
				if (c.TabStop) {
					if (type.Name == "TextBox") {
						PropertyInfo prop = type.GetProperty("Tag");
						string str = (string)prop.GetValue(c, null);
						if (str != null) {
							string[] arr = str.Split(d1);
							foreach (string items in arr) {
								string	 item = items.Trim();
								string[] opt  = item.Split(d2);
								if (opt.Length == 2) {
									EDropMode dm = (EDropMode)0;
									opt[0] = opt[0].Trim();
									if (string.Compare(opt[0], kw, true) == 0) {
										for (int i = 0; i < opt[1].Length; i++) {
											switch (opt[1].Substring(i, 1)) {
												case "D": case "d": dm |= EDropMode.DIR;		break;
												case "F": case "f": dm |= EDropMode.FILE;		break;
												case "B": case "b": dm |= EDropMode.BOTH;		break;
												case "C": case "c": dm |= EDropMode.CONNECT;	break;
												case "N": case "n": dm |= EDropMode.NOERRTIP;	break;
											}
										}
									}
									EnableDropToTextBox(c, dm);
								}
							}
						}
					}
				}
			}
		}

		//======================================================================================================//
		//	API 	AjcGeneral.h																				//
		//======================================================================================================//
		//----- AjcDifferenceOfTheta		   -----------------------------------------------------------------//
		public static double DifferenceOfTheta(double t1, double t2)
		{
			double	rc;
			rc = CAjrApi.AjcDifferenceOfTheta(t1, t2);
			return rc;
		}
		//----- AjcExitWindows				   -----------------------------------------------------------------//
		public static bool ExitWindows(EExitWindows flag, bool force)
		{
			bool	rc;
			rc = CAjrApi.AjcExitWindows(flag | (force ? EExitWindows.EWX_FORCE : (EExitWindows)0));
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static bool ExitWindows(EExitWindows flag)
		{
			return ExitWindows(flag, false);
		}
		//======================================================================================================//
		//	API 	AjcDateAndTime.h																			//
		//======================================================================================================//
		//----- AjcMsilTime1970ToSysTime	  ------------------------------------------------------------------//
		public static DateTime Time1970ToDateAndTime(uint Time1970)
		{
			DateTime rc;

			rc = CAjrApi.AjcMsilTime1970ToSysTime(Time1970);

			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static DateTime Time1970ToDateAndTime(ulong Time1970)
		{
			DateTime rc;

			rc = CAjrApi.AjcMsilTime1970ToSysTimeL(Time1970);

			return rc;
		}
		//----- AjcMsilSysTimeToTime1970	  ------------------------------------------------------------------//
		public static uint DateAndTimeToTime1970(DateTime dt)
		{
			uint	rc;

			rc = CAjrApi.AjcMsilSysTimeToTime1970(dt);

			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public static ulong DateAndTimeToTime1970L(DateTime dt)
		{
			ulong	rc;

			rc = CAjrApi.AjcMsilSysTimeToTime1970L(dt);

			return rc;
		}
		//----- AjcMsiSysTimeToLocalTime	  ------------------------------------------------------------------//
		public static DateTime UtcTimeToLocalTime(DateTime dt)
		{
			DateTime rc;

			rc = CAjrApi.AjcMsilSysTimeToLocalTime(dt);

			return rc;
		}
		//======================================================================================================//
		//	API 	AjcWndSupport.h																				//
		//======================================================================================================//
		//----- AjcGetWindowPos --------------------------------------------------------------------------------//
		public static Point GetWindowPos(Control ctl)
		{
			Point	pt = new Point();
			int 	x, y;
			CAjrApi.AjcGetWindowPos(CAjrApi.GetPropIntPtr(ctl, "Handle"), out x, out y);
			pt.X = x;
			pt.Y = y;
			return pt;
		}
	}
	//==========================================================================================================//
	//																											//
	//	ネイティブメモリアクセス	SAjrBin																		//
	//																											//
	//==========================================================================================================//
	public static class SAjrBin
	{
		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- メモリブロック			------------------------------------------------------------------------//
		//----- AjcMAlloc				------------------------------------------------------------------------//
		public static IntPtr MAlloc(IntPtr size)
		{
			IntPtr rc;
			rc = CAjrApi.AjcMAlloc(size);
			return rc;
		}
		//----- AjcMFree				------------------------------------------------------------------------//
		public static IntPtr MFree(IntPtr addr)
		{
			IntPtr rc;
			rc = CAjrApi.AjcMFree(addr);
			return rc;
		}
		//----- AjcSetMemError			------------------------------------------------------------------------//
		private static void SetMemError(IntPtr cbp, BinCbkOutOfMemory cb)
		{
			CAjrApi.AjcSetMemError(cbp, cb);
		}

		//----- メモリコピー				   -----------------------------------------------------------------//
		//- - - (IntPtr ← IntPtr) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public		  static IntPtr MemCopy(IntPtr pDest, IntPtr pSrc, int len)
		{
			IntPtr	rc;
			rc = CAjrApi.AjcMemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - (void* ← void*) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public unsafe static IntPtr MemCopy(void* pDest, void* pSrc, int len)
		{
			IntPtr	rc;
			rc = CAjrApi.AjcMemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - (IntPtr ← void*) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public unsafe static IntPtr MemCopy(IntPtr pDest, void* pSrc, int len)
		{
			IntPtr	rc;
			rc = CAjrApi.AjcMemCopy(pDest, pSrc, len);
			return rc;
		}
		//- - - (void* ← IntPtr) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public unsafe static IntPtr MemCopy(void* pDest, IntPtr pSrc, int len)
		{
			IntPtr	rc;
			rc = CAjrApi.AjcMemCopy(pDest, pSrc, len);
			return rc;
		}


		//----- 文字列コピー				   -----------------------------------------------------------------//
		//- - - (IntPtr ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
		public		  static bool StrCopy(IntPtr pDest, string pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public		  static bool StrCopy(IntPtr pDest, StringBuilder pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public		  static bool StrCopy(IntPtr pDest, IntPtr pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool StrCopy(IntPtr pDest, void* pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - (void* ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - --------//
		unsafe public static bool StrCopy(void* pDest, string pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool StrCopy(void* pDest, StringBuilder pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool StrCopy(void* pDest, IntPtr pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool StrCopy(void* pDest, void* pSrc, int lDest)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc, lDest);
			return rc;
		}

		//- - - (StringBuilder ← 文字列) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public		  static bool StrCopy(StringBuilder pDest, IntPtr pSrc)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static bool StrCopy(StringBuilder pDest, void* pSrc)
		{
			bool	rc;
			rc = CAjrApi.AjcWStrCopy(pDest, pSrc);
			return rc;
		}

		//----- 文字列長取得			   -----------------------------------------------------------------//
		public		  static int  StrLen(IntPtr pStr)
		{
			int	rc;
			rc = CAjrApi.AjcWStrLen(pStr);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		unsafe public static int  StrLen(void* pStr)
		{
			int	rc;
			rc = CAjrApi.AjcWStrLen(pStr);
			return rc;
		}
	}
	//==========================================================================================================//
	//																											//
	//	チェックサム	SAjrCS																					//
	//																											//
	//==========================================================================================================//
	public static class SAjrCS
	{
		//------------------------------------------------------------------------------------------------------//
		//	メソッド																							//
		//------------------------------------------------------------------------------------------------------//
		//----- AjcCalcByteSumN 			   -----------------------------------------------------------------//
		unsafe public static byte CalcByteSumN(void *p, int len)
		{
			byte	rc;
			rc = CAjrApi.AjcCalcByteSumN(p, len);
			return rc;
		}
		//----- AjcCalcByteSumS 			   -----------------------------------------------------------------//
		unsafe public static byte CalcByteSumS(void *p, int len)
		{
			byte	rc;
			rc = CAjrApi.AjcCalcByteSumS(p, len);
			return rc;
		}
		//----- AjcCalcByteSumX 			   -----------------------------------------------------------------//
		unsafe public static byte CalcByteSumX(void *p, int len)
		{
			byte	rc;
			rc = CAjrApi.AjcCalcByteSumX(p, len);
			return rc;
		}
		//----- AjcSetByteSum				   -----------------------------------------------------------------//
		unsafe public static void SetByteSum(void *p, int len)
		{
			CAjrApi.AjcSetByteSum(p, len);
		}
		//----- AjcSetByteSumN				   -----------------------------------------------------------------//
		unsafe public static void SetByteSumN(void *p, int len)
		{
			CAjrApi.AjcSetByteSumN(p, len);
		}
		//----- AjcSetByteSumS				   -----------------------------------------------------------------//
		unsafe public static void SetByteSumS(void *p, int len)
		{
			CAjrApi.AjcSetByteSumS(p, len);
		}
		//----- AjcSetByteSumX				   -----------------------------------------------------------------//
		unsafe public static void SetByteSumX(void *p, int len)
		{
			CAjrApi.AjcSetByteSumX(p, len);
		}
		//----- AjcChkByteSum				   -----------------------------------------------------------------//
		unsafe public static bool ChkByteSum(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSum(p, len);
			return rc;
		}
		//----- AjcChkByteSumN				   -----------------------------------------------------------------//
		unsafe public static bool ChkByteSumN(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSumN(p, len);
			return rc;
		}
		//----- AjcChkByteSumS				   -----------------------------------------------------------------//
		unsafe public static bool ChkByteSumS(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSumS(p, len);
			return rc;
		}
		//----- AjcChkByteSumX				   -----------------------------------------------------------------//
		unsafe public static bool ChkByteSumX(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSumX(p, len);
			return rc;
		}
		//----- AjcCalcWordSum				   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSum(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSum(p, len);
			return rc;
		}
		//----- AjcCalcWordSumN 			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumN(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumN(p, len);
			return rc;
		}
		//----- AjcCalcWordSumS 			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumS(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumS(p, len);
			return rc;
		}
		//----- AjcCalcWordSumX 			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumX(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumX(p, len);
			return rc;
		}
		//----- AjcSetWordSum				   -----------------------------------------------------------------//
		unsafe public static void SetWordSum(void *p, int len)
		{
			CAjrApi.AjcSetWordSum(p, len);
		}
		//----- AjcSetWordSumN				   -----------------------------------------------------------------//
		unsafe public static void SetWordSumN(void *p, int len)
		{
			CAjrApi.AjcSetWordSumN(p, len);
		}
		//----- AjcSetWordSumS				   -----------------------------------------------------------------//
		unsafe public static void SetWordSumS(void *p, int len)
		{
			CAjrApi.AjcSetWordSumS(p, len);
		}
		//----- AjcSetWordSumX				   -----------------------------------------------------------------//
		unsafe public static void SetWordSumX(void *p, int len)
		{
			CAjrApi.AjcSetWordSumX(p, len);
		}
		//----- AjcChkWordSum				   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSum(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSum(p, len);
			return rc;
		}
		//----- AjcChkWordSumN				   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumN(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumN(p, len);
			return rc;
		}
		//----- AjcChkWordSumS				   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumS(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumS(p, len);
			return rc;
		}
		//----- AjcChkWordSumX				   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumX(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumX(p, len);
			return rc;
		}
		//----- AjcCalcWordSumR 			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumR(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumR(p, len);
			return rc;
		}
		//----- AjcCalcWordSumNR			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumNR(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumNR(p, len);
			return rc;
		}
		//----- AjcCalcWordSumSR			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumSR(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumSR(p, len);
			return rc;
		}
		//----- AjcCalcWordSumXR			   -----------------------------------------------------------------//
		unsafe public static ushort CalcWordSumXR(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumXR(p, len);
			return rc;
		}
		//----- AjcSetWordSumR				   -----------------------------------------------------------------//
		unsafe public static void SetWordSumR(void *p, int len)
		{
			CAjrApi.AjcSetWordSumR(p, len);
		}
		//----- AjcSetWordSumNR 			   -----------------------------------------------------------------//
		unsafe public static void SetWordSumNR(void *p, int len)
		{
			CAjrApi.AjcSetWordSumNR(p, len);
		}
		//----- AjcSetWordSumSR 			   -----------------------------------------------------------------//
		unsafe public static void SetWordSumSR(void *p, int len)
		{
			CAjrApi.AjcSetWordSumSR(p, len);
		}
		//----- AjcSetWordSumXR 			   -----------------------------------------------------------------//
		unsafe public static void SetWordSumXR(void *p, int len)
		{
			CAjrApi.AjcSetWordSumXR(p, len);
		}
		//----- AjcChkWordSumR				   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumR(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumR(p, len);
			return rc;
		}
		//----- AjcChkWordSumNR 			   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumNR(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumNR(p, len);
			return rc;
		}
		//----- AjcChkWordSumSR 			   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumSR(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumSR(p, len);
			return rc;
		}
		//----- AjcChkWordSumXR 			   -----------------------------------------------------------------//
		unsafe public static bool ChkWordSumXR(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumXR(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		//	チェックサム	（ＩｎｔＰｔｒ版）																	//
		//------------------------------------------------------------------------------------------------------//
		//----- AjcCalcByteSumN 			   -----------------------------------------------------------------//
		public static char CalcByteSumN(IntPtr p, int len)
		{
			char	rc;
			rc = CAjrApi.AjcCalcByteSumN(p, len);
			return rc;
		}
		//----- AjcCalcByteSumS 			   -----------------------------------------------------------------//
		public static char CalcByteSumS(IntPtr p, int len)
		{
			char	rc;
			rc = CAjrApi.AjcCalcByteSumS(p, len);
			return rc;
		}
		//----- AjcCalcByteSumX 			   -----------------------------------------------------------------//
		public static char CalcByteSumX(IntPtr p, int len)
		{
			char	rc;
			rc = CAjrApi.AjcCalcByteSumX(p, len);
			return rc;
		}
		//----- AjcSetByteSum				   -----------------------------------------------------------------//
		public static void SetByteSum(IntPtr p, int len)
		{
			CAjrApi.AjcSetByteSum(p, len);
		}
		//----- AjcSetByteSumN				   -----------------------------------------------------------------//
		public static void SetByteSumN(IntPtr p, int len)
		{
			CAjrApi.AjcSetByteSumN(p, len);
		}
		//----- AjcSetByteSumS				   -----------------------------------------------------------------//
		public static void SetByteSumS(IntPtr p, int len)
		{
			CAjrApi.AjcSetByteSumS(p, len);
		}
		//----- AjcSetByteSumX				   -----------------------------------------------------------------//
		public static void SetByteSumX(IntPtr p, int len)
		{
			CAjrApi.AjcSetByteSumX(p, len);
		}
		//----- AjcChkByteSum				   -----------------------------------------------------------------//
		public static bool ChkByteSum(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSum(p, len);
			return rc;
		}
		//----- AjcChkByteSumN				   -----------------------------------------------------------------//
		public static bool ChkByteSumN(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSumN(p, len);
			return rc;
		}
		//----- AjcChkByteSumS				   -----------------------------------------------------------------//
		public static bool ChkByteSumS(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSumS(p, len);
			return rc;
		}
		//----- AjcChkByteSumX				   -----------------------------------------------------------------//
		public static bool ChkByteSumX(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkByteSumX(p, len);
			return rc;
		}
		//----- AjcCalcWordSum				   -----------------------------------------------------------------//
		public static ushort CalcWordSum(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSum(p, len);
			return rc;
		}
		//----- AjcCalcWordSumN 			   -----------------------------------------------------------------//
		public static ushort CalcWordSumN(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumN(p, len);
			return rc;
		}
		//----- AjcCalcWordSumS 			   -----------------------------------------------------------------//
		public static ushort CalcWordSumS(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumS(p, len);
			return rc;
		}
		//----- AjcCalcWordSumX 			   -----------------------------------------------------------------//
		public static ushort CalcWordSumX(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumX(p, len);
			return rc;
		}
		//----- AjcSetWordSum				   -----------------------------------------------------------------//
		public static void SetWordSum(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSum(p, len);
		}
		//----- AjcSetWordSumN				   -----------------------------------------------------------------//
		public static void SetWordSumN(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumN(p, len);
		}
		//----- AjcSetWordSumS				   -----------------------------------------------------------------//
		public static void SetWordSumS(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumS(p, len);
		}
		//----- AjcSetWordSumX				   -----------------------------------------------------------------//
		public static void SetWordSumX(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumX(p, len);
		}
		//----- AjcChkWordSum				   -----------------------------------------------------------------//
		public static bool ChkWordSum(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSum(p, len);
			return rc;
		}
		//----- AjcChkWordSumN				   -----------------------------------------------------------------//
		public static bool ChkWordSumN(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumN(p, len);
			return rc;
		}
		//----- AjcChkWordSumS				   -----------------------------------------------------------------//
		public static bool ChkWordSumS(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumS(p, len);
			return rc;
		}
		//----- AjcChkWordSumX				   -----------------------------------------------------------------//
		public static bool ChkWordSumX(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumX(p, len);
			return rc;
		}
		//----- AjcCalcWordSumR 			   -----------------------------------------------------------------//
		public static ushort CalcWordSumR(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumR(p, len);
			return rc;
		}
		//----- AjcCalcWordSumNR			   -----------------------------------------------------------------//
		public static ushort CalcWordSumNR(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumNR(p, len);
			return rc;
		}
		//----- AjcCalcWordSumSR			   -----------------------------------------------------------------//
		public static ushort CalcWordSumSR(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumSR(p, len);
			return rc;
		}
		//----- AjcCalcWordSumXR			   -----------------------------------------------------------------//
		public static ushort CalcWordSumXR(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcCalcWordSumXR(p, len);
			return rc;
		}
		//----- AjcSetWordSumR				   -----------------------------------------------------------------//
		public static void SetWordSumR(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumR(p, len);
		}
		//----- AjcSetWordSumNR 			   -----------------------------------------------------------------//
		public static void SetWordSumNR(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumNR(p, len);
		}
		//----- AjcSetWordSumSR 			   -----------------------------------------------------------------//
		public static void SetWordSumSR(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumSR(p, len);
		}
		//----- AjcSetWordSumXR 			   -----------------------------------------------------------------//
		public static void SetWordSumXR(IntPtr p, int len)
		{
			CAjrApi.AjcSetWordSumXR(p, len);
		}
		//----- AjcChkWordSumR				   -----------------------------------------------------------------//
		public static bool ChkWordSumR(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumR(p, len);
			return rc;
		}
		//----- AjcChkWordSumNR 			   -----------------------------------------------------------------//
		public static bool ChkWordSumNR(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumNR(p, len);
			return rc;
		}
		//----- AjcChkWordSumSR 			   -----------------------------------------------------------------//
		public static bool ChkWordSumSR(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumSR(p, len);
			return rc;
		}
		//----- AjcChkWordSumXR 			   -----------------------------------------------------------------//
		public static bool ChkWordSumXR(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkWordSumXR(p, len);
			return rc;
		}
	}
	//==========================================================================================================//
	//																											//
	//	ＣＲＣ	SAjrCrc																							//
	//																											//
	//==========================================================================================================//
	public static class SAjrCrc
	{
		//------------------------------------------------------------------------------------------------------//
		//	API 	AjcCRC.h	  (＊ポインタ版）																//
		//------------------------------------------------------------------------------------------------------//
		//----- AjcCrc16L					   -----------------------------------------------------------------//
		public static ushort Crc16L(byte ByteData, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcCrc16L(ByteData, ini);
			return rc;
		}
		//----- AjcPartCrc16L				   -----------------------------------------------------------------//
		unsafe public static ushort PartCrc16L(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrc16L(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrc16L				   -----------------------------------------------------------------//
		unsafe public static ushort BlkCrc16L(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrc16L(p, len, ini);
			return rc;
		}
		//----- AjcSetCrc16L				   -----------------------------------------------------------------//
		unsafe public static void SetCrc16L(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16L(p, len, ini);
		}
		//----- AjcSetCrc16L_BE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrc16L_BE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16L_BE(p, len, ini);
		}
		//----- AjcSetCrc16L_LE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrc16L_LE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16L_LE(p, len, ini);
		}
		//----- AjcChkCrc16L				   -----------------------------------------------------------------//
		unsafe public static bool ChkCrc16L(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16L(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16L_BE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrc16L_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16L_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16L_LE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrc16L_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16L_LE(p, len, ini);
			return rc;
		}
		//----- AjcCrc16R					   -----------------------------------------------------------------//
		public static ushort Crc16R(byte ByteData, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcCrc16R(ByteData, ini);
			return rc;
		}
		//----- AjcPartCrc16R				   -----------------------------------------------------------------//
		unsafe public static ushort PartCrc16R(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrc16R(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrc16R				   -----------------------------------------------------------------//
		unsafe public static ushort BlkCrc16R(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrc16R(p, len, ini);
			return rc;
		}
		//----- AjcSetCrc16R				   -----------------------------------------------------------------//
		unsafe public static void SetCrc16R(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16R(p, len, ini);
		}
		//----- AjcSetCrc16R_BE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrc16R_BE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16R_BE(p, len, ini);
		}
		//----- AjcSetCrc16R_LE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrc16R_LE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16R_LE(p, len, ini);
		}
		//----- AjcChkCrc16R				   -----------------------------------------------------------------//
		unsafe public static bool ChkCrc16R(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16R(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16R_BE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrc16R_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16R_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16R_LE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrc16R_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16R_LE(p, len, ini);
			return rc;
		}
		//----- AjcCrcItL					   -----------------------------------------------------------------//
		public static ushort CrcItL(byte ByteData, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcCrcItL(ByteData, ini);
			return rc;
		}
		//----- AjcPartCrcItL				   -----------------------------------------------------------------//
		unsafe public static ushort PartCrcItL(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrcItL(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrcItL				   -----------------------------------------------------------------//
		unsafe public static ushort BlkCrcItL(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrcItL(p, len, ini);
			return rc;
		}
		//----- AjcBlkXMODEM				   -----------------------------------------------------------------//
		unsafe public static ushort BlkXMODEM(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkXMODEM(p, len);
			return rc;
		}
		//----- AjcSetCrcItL				   -----------------------------------------------------------------//
		unsafe public static void SetCrcItL(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItL(p, len, ini);
		}
		//----- AjcSetXMODEM				   -----------------------------------------------------------------//
		unsafe public static void SetXMODEM(void *p, int len)
		{
			CAjrApi.AjcSetXMODEM(p, len);
		}
		//----- AjcSetCrcItL_BE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrcItL_BE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItL_BE(p, len, ini);
		}
		//----- AjcSetXMODEM_BE 			   -----------------------------------------------------------------//
		unsafe public static void SetXMODEM_BE(void *p, int len)
		{
			CAjrApi.AjcSetXMODEM_BE(p, len);
		}
		//----- AjcSetCrcItL_LE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrcItL_LE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItL_LE(p, len, ini);
		}
		//----- AjcSetXMODEM_LE 			   -----------------------------------------------------------------//
		unsafe public static void SetXMODEM_LE(void *p, int len)
		{
			CAjrApi.AjcSetXMODEM_LE(p, len);
		}
		//----- AjcChkCrcItL				   -----------------------------------------------------------------//
		unsafe public static bool ChkCrcItL(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItL(p, len, ini);
			return rc;
		}
		//----- AjcChkXMODEM				   -----------------------------------------------------------------//
		unsafe public static bool ChkXMODEM(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkXMODEM(p, len);
			return rc;
		}
		//----- AjcChkCrcItL_BE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrcItL_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItL_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkXMODEM_BE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkXMODEM_BE(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkXMODEM_BE(p, len);
			return rc;
		}
		//----- AjcChkCrcItL_LE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrcItL_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItL_LE(p, len, ini);
			return rc;
		}
		//----- AjcChkXMODEM_LE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkXMODEM_LE(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkXMODEM_LE(p, len);
			return rc;
		}
		//----- AjcCrcItR					   -----------------------------------------------------------------//
		public static ushort CrcItR(byte ByteData, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcCrcItR(ByteData, ini);
			return rc;
		}
		//----- AjcPartCrcItR				   -----------------------------------------------------------------//
		unsafe public static ushort PartCrcItR(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrcItR(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrcItR				   -----------------------------------------------------------------//
		unsafe public static ushort BlkCrcItR(void *p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrcItR(p, len, ini);
			return rc;
		}
		//----- AjcBlkFCS					   -----------------------------------------------------------------//
		unsafe public static ushort BlkFCS(void *p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkFCS(p, len);
			return rc;
		}
		//----- AjcSetCrcItR				   -----------------------------------------------------------------//
		unsafe public static void SetCrcItR(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItR(p, len, ini);
		}
		//----- AjcSetFCS					   -----------------------------------------------------------------//
		unsafe public static void SetFCS(void *p, int len)
		{
			CAjrApi.AjcSetFCS(p, len);
		}
		//----- AjcSetCrcItR_BE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrcItR_BE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItR_BE(p, len, ini);
		}
		//----- AjcSetFCS_BE				   -----------------------------------------------------------------//
		unsafe public static void SetFCS_BE(void *p, int len)
		{
			CAjrApi.AjcSetFCS_BE(p, len);
		}
		//----- AjcSetCrcItR_LE 			   -----------------------------------------------------------------//
		unsafe public static void SetCrcItR_LE(void *p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItR_LE(p, len, ini);
		}
		//----- AjcSetFCS_LE				   -----------------------------------------------------------------//
		unsafe public static void SetFCS_LE(void *p, int len)
		{
			CAjrApi.AjcSetFCS_LE(p, len);
		}
		//----- AjcChkCrcItR				   -----------------------------------------------------------------//
		unsafe public static bool ChkCrcItR(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItR(p, len, ini);
			return rc;
		}
		//----- AjcChkFCS					   -----------------------------------------------------------------//
		unsafe public static bool ChkFCS(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkFCS(p, len);
			return rc;
		}
		//----- AjcChkCrcItR_BE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrcItR_BE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItR_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkFCS_BE				   -----------------------------------------------------------------//
		unsafe public static bool ChkFCS_BE(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkFCS_BE(p, len);
			return rc;
		}
		//----- AjcChkCrcItR_LE 			   -----------------------------------------------------------------//
		unsafe public static bool ChkCrcItR_LE(void *p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItR_LE(p, len, ini);
			return rc;
		}
		//----- AjcChkFCS_LE				   -----------------------------------------------------------------//
		unsafe public static bool ChkFCS_LE(void *p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkFCS_LE(p, len);
			return rc;
		}
		//------------------------------------------------------------------------------------------------------//
		//	API 	AjcCRC.h		 （ＩｎｔＰｔｒ版） 														//
		//------------------------------------------------------------------------------------------------------//
		//----- AjcPartCrc16L				   -----------------------------------------------------------------//
		public static ushort PartCrc16L(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrc16L(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrc16L				   -----------------------------------------------------------------//
		public static ushort BlkCrc16L(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrc16L(p, len, ini);
			return rc;
		}
		//----- AjcSetCrc16L				   -----------------------------------------------------------------//
		public static void SetCrc16L(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16L(p, len, ini);
		}
		//----- AjcSetCrc16L_BE 			   -----------------------------------------------------------------//
		public static void SetCrc16L_BE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16L_BE(p, len, ini);
		}
		//----- AjcSetCrc16L_LE 			   -----------------------------------------------------------------//
		public static void SetCrc16L_LE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16L_LE(p, len, ini);
		}
		//----- AjcChkCrc16L				   -----------------------------------------------------------------//
		public static bool ChkCrc16L(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16L(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16L_BE 			   -----------------------------------------------------------------//
		public static bool ChkCrc16L_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16L_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16L_LE 			   -----------------------------------------------------------------//
		public static bool ChkCrc16L_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16L_LE(p, len, ini);
			return rc;
		}
		//----- AjcPartCrc16R				   -----------------------------------------------------------------//
		public static ushort PartCrc16R(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrc16R(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrc16R				   -----------------------------------------------------------------//
		public static ushort BlkCrc16R(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrc16R(p, len, ini);
			return rc;
		}
		//----- AjcSetCrc16R				   -----------------------------------------------------------------//
		public static void SetCrc16R(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16R(p, len, ini);
		}
		//----- AjcSetCrc16R_BE 			   -----------------------------------------------------------------//
		public static void SetCrc16R_BE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16R_BE(p, len, ini);
		}
		//----- AjcSetCrc16R_LE 			   -----------------------------------------------------------------//
		public static void SetCrc16R_LE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrc16R_LE(p, len, ini);
		}
		//----- AjcChkCrc16R				   -----------------------------------------------------------------//
		public static bool ChkCrc16R(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16R(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16R_BE 			   -----------------------------------------------------------------//
		public static bool ChkCrc16R_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16R_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkCrc16R_LE 			   -----------------------------------------------------------------//
		public static bool ChkCrc16R_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrc16R_LE(p, len, ini);
			return rc;
		}
		//----- AjcPartCrcItL				   -----------------------------------------------------------------//
		public static ushort PartCrcItL(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrcItL(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrcItL				   -----------------------------------------------------------------//
		public static ushort BlkCrcItL(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrcItL(p, len, ini);
			return rc;
		}
		//----- AjcBlkXMODEM				   -----------------------------------------------------------------//
		public static ushort BlkXMODEM(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkXMODEM(p, len);
			return rc;
		}
		//----- AjcSetCrcItL				   -----------------------------------------------------------------//
		public static void SetCrcItL(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItL(p, len, ini);
		}
		//----- AjcSetXMODEM				   -----------------------------------------------------------------//
		public static void SetXMODEM(IntPtr p, int len)
		{
			CAjrApi.AjcSetXMODEM(p, len);
		}
		//----- AjcSetCrcItL_BE 			   -----------------------------------------------------------------//
		public static void SetCrcItL_BE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItL_BE(p, len, ini);
		}
		//----- AjcSetXMODEM_BE 			   -----------------------------------------------------------------//
		public static void SetXMODEM_BE(IntPtr p, int len)
		{
			CAjrApi.AjcSetXMODEM_BE(p, len);
		}
		//----- AjcSetCrcItL_LE 			   -----------------------------------------------------------------//
		public static void SetCrcItL_LE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItL_LE(p, len, ini);
		}
		//----- AjcSetXMODEM_LE 			   -----------------------------------------------------------------//
		public static void SetXMODEM_LE(IntPtr p, int len)
		{
			CAjrApi.AjcSetXMODEM_LE(p, len);
		}
		//----- AjcChkCrcItL				   -----------------------------------------------------------------//
		public static bool ChkCrcItL(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItL(p, len, ini);
			return rc;
		}
		//----- AjcChkXMODEM				   -----------------------------------------------------------------//
		public static bool ChkXMODEM(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkXMODEM(p, len);
			return rc;
		}
		//----- AjcChkCrcItL_BE 			   -----------------------------------------------------------------//
		public static bool ChkCrcItL_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItL_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkXMODEM_BE 			   -----------------------------------------------------------------//
		public static bool ChkXMODEM_BE(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkXMODEM_BE(p, len);
			return rc;
		}
		//----- AjcChkCrcItL_LE 			   -----------------------------------------------------------------//
		public static bool ChkCrcItL_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItL_LE(p, len, ini);
			return rc;
		}
		//----- AjcChkXMODEM_LE 			   -----------------------------------------------------------------//
		public static bool ChkXMODEM_LE(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkXMODEM_LE(p, len);
			return rc;
		}
		//----- AjcPartCrcItR				   -----------------------------------------------------------------//
		public static ushort PartCrcItR(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcPartCrcItR(p, len, ini);
			return rc;
		}
		//----- AjcBlkCrcItR				   -----------------------------------------------------------------//
		public static ushort BlkCrcItR(IntPtr p, int len, ushort ini)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkCrcItR(p, len, ini);
			return rc;
		}
		//----- AjcBlkFCS					   -----------------------------------------------------------------//
		public static ushort BlkFCS(IntPtr p, int len)
		{
			ushort	rc;
			rc = CAjrApi.AjcBlkFCS(p, len);
			return rc;
		}
		//----- AjcSetCrcItR				   -----------------------------------------------------------------//
		public static void SetCrcItR(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItR(p, len, ini);
		}
		//----- AjcSetFCS					   -----------------------------------------------------------------//
		public static void SetFCS(IntPtr p, int len)
		{
			CAjrApi.AjcSetFCS(p, len);
		}
		//----- AjcSetCrcItR_BE 			   -----------------------------------------------------------------//
		public static void SetCrcItR_BE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItR_BE(p, len, ini);
		}
		//----- AjcSetFCS_BE				   -----------------------------------------------------------------//
		public static void SetFCS_BE(IntPtr p, int len)
		{
			CAjrApi.AjcSetFCS_BE(p, len);
		}
		//----- AjcSetCrcItR_LE 			   -----------------------------------------------------------------//
		public static void SetCrcItR_LE(IntPtr p, int len, ushort ini)
		{
			CAjrApi.AjcSetCrcItR_LE(p, len, ini);
		}
		//----- AjcSetFCS_LE				   -----------------------------------------------------------------//
		public static void SetFCS_LE(IntPtr p, int len)
		{
			CAjrApi.AjcSetFCS_LE(p, len);
		}
		//----- AjcChkCrcItR				   -----------------------------------------------------------------//
		public static bool ChkCrcItR(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItR(p, len, ini);
			return rc;
		}
		//----- AjcChkFCS					   -----------------------------------------------------------------//
		public static bool ChkFCS(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkFCS(p, len);
			return rc;
		}
		//----- AjcChkCrcItR_BE 			   -----------------------------------------------------------------//
		public static bool ChkCrcItR_BE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItR_BE(p, len, ini);
			return rc;
		}
		//----- AjcChkFCS_BE				   -----------------------------------------------------------------//
		public static bool ChkFCS_BE(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkFCS_BE(p, len);
			return rc;
		}
		//----- AjcChkCrcItR_LE 			   -----------------------------------------------------------------//
		public static bool ChkCrcItR_LE(IntPtr p, int len, ushort ini)
		{
			bool	rc;
			rc = CAjrApi.AjcChkCrcItR_LE(p, len, ini);
			return rc;
		}
		//----- AjcChkFCS_LE				   -----------------------------------------------------------------//
		public static bool ChkFCS_LE(IntPtr p, int len)
		{
			bool	rc;
			rc = CAjrApi.AjcChkFCS_LE(p, len);
			return rc;
		}
	}
}
