﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using AjaraInit;

namespace CAjrCustCtrl
{

	[ToolboxBitmap(typeof(CAjrStrPool), "CAjrStrPool.bmp")]
	public partial class CAjrStrPool : Component
	{
		//----- 外部へのイベント --------------------------//
		[System.ComponentModel.Category("AjrStrPool")]
		[System.ComponentModel.Description("Strings enumeration notification.")]
		public event SplEvtNtcStr OnNtcStr;
		private SplCbkNtcStr	  m_SplCbkNtcStr;

		//======================================================================================================//
		//	ワーク																								//
		//======================================================================================================//
		private IntPtr			m_hSpl	  = (IntPtr)0;

		//======================================================================================================//
		//	コンストラクタ																						//
		//======================================================================================================//
		//	コンストラクタ（１）
		public CAjrStrPool()
		{
			InitializeComponent();
			InitOnConstruct();
		}
		//	コンストラクタ（２）
		public CAjrStrPool(IContainer container)
		{
			container.Add(this);
			InitializeComponent();
			InitOnConstruct();
		}
		//	初期化
		private void InitOnConstruct()
		{
			//	ライブラリ初期化
			CAjrInit.Init();

			//	変数初期化
			m_hSpl		   = CAjrApi.AjcSplCreate(ESplComp.ALPHABETIC);
			m_SplCbkNtcStr = new SplCbkNtcStr(cbSplNtcStr);

			//	終了処理登録
			this.Disposed += OnUnloadMyControl;
		}
		//----- 終了処理 ---------------------------------------------------------------------------------------//
		private void OnUnloadMyControl(object sender, EventArgs e)
		{
			if (m_hSpl != (IntPtr)0) {
				CAjrApi.AjcSplDelete(m_hSpl);
				m_hSpl = (IntPtr)0;
			}
		}
		//======================================================================================================//
		//	プロパティ																							//
		//======================================================================================================//
		[System.ComponentModel.Category("AjrStrPool")]
		[System.ComponentModel.Description("Text comparison method")]
		public ESplComp CompMode
		{
			set { CAjrApi.AjcSplSetCompMode(m_hSpl, value);	}
			get { return CAjrApi.AjcSplGetCompMode(m_hSpl);	}
		}

		[System.ComponentModel.Category("AjrStrPool")]
		[System.ComponentModel.Description("Number of registered strings")]
		public int Count
		{
			get { return CAjrApi.AjcSplNumber(m_hSpl);	}
		}


		//======================================================================================================//
		//	メソッド																							//
		//======================================================================================================//
		//----- Regist					------------------------------------------------------------------------//
		public void Regist(string str)
		{
			if (str.Length > 32766) {throw new OverflowException("str is over 32766 characters.");}

			if (CAjrApi.AjcSplRegist(m_hSpl, str) == (IntPtr)0) {
				throw new RegistrationFailureException(str);
			}
		}
		//----- RegistPtr				------------------------------------------------------------------------//
		public IntPtr RegistPtr(string str)
		{
			IntPtr	rc;

			if (str.Length > 32766) {throw new OverflowException	("str is over 32766 characters.");}

			if ((rc = CAjrApi.AjcSplRegist(m_hSpl, str)) == (IntPtr)0) {
				throw new RegistrationFailureException(str);
			}
			return rc;
		}

		//----- Find					------------------------------------------------------------------------//
		public	bool Find(string str)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplFind(m_hSpl, str);
			return (rc != (IntPtr)0) ? true : false;
		}
		//----- FindPtr					------------------------------------------------------------------------//
		public	IntPtr FindPtr(string str)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplFind(m_hSpl, str);
			return rc;
		}

		//----- PartStrInPool			------------------------------------------------------------------------//
		public	bool PartStrInPool(string PartStr)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPartStrInPool(m_hSpl, PartStr, ESplInStr.MATCHFIRST);
			return (rc != (IntPtr)0) ? true : false;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	bool PartStrInPool(string PartStr, ESplInStr param)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPartStrInPool(m_hSpl, PartStr, param);
			return (rc != (IntPtr)0) ? true : false;
		}
		//----- PartStrInPoolPtr		------------------------------------------------------------------------//
		public	IntPtr PartStrInPoolPtr(string PartStr)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPartStrInPool(m_hSpl, PartStr, ESplInStr.MATCHFIRST);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	IntPtr PartStrInPoolPtr(string PartStr, ESplInStr param)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPartStrInPool(m_hSpl, PartStr, param);
			return rc;
		}

		//----- PoolStrInStr			------------------------------------------------------------------------//
		public	bool PoolStrInStr(string PartStr)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPoolStrInStr(m_hSpl, PartStr, ESplInStr.MATCHFIRST);
			return (rc != (IntPtr)0) ? true : false;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	bool PoolStrInStr(string PartStr, ESplInStr param)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPoolStrInStr(m_hSpl, PartStr, param);
			return (rc != (IntPtr)0) ? true : false;
		}
		//----- PoolStrInStrPtr			------------------------------------------------------------------------//
		public	IntPtr PoolStrInStrPtr(string PartStr)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPoolStrInStr(m_hSpl, PartStr, ESplInStr.MATCHFIRST);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	IntPtr PoolStrInStrPtr(string PartStr, ESplInStr param)
		{
			IntPtr	rc;

			rc = CAjrApi.AjcSplPoolStrInStr(m_hSpl, PartStr, param);
			return rc;
		}

		//----- Remove					------------------------------------------------------------------------//
		public	bool	Remove(string str)
		{
			bool	rc;

			rc = CAjrApi.AjcSplRemove(m_hSpl, str);
			return rc;
		}

		//----- Reset					------------------------------------------------------------------------//
		public	void	Reset()
		{
			CAjrApi.AjcSplReset(m_hSpl);
		}

		//----- EnumStr					------------------------------------------------------------------------//
		public	int		EnumStr()
		{
			int		rc;
			rc = CAjrApi.AjcSplEnumStr(m_hSpl, (IntPtr)0, ESplSeq.Ascending, m_SplCbkNtcStr);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	int		EnumStr(ESplSeq seq)
		{
			int		rc;
			rc = CAjrApi.AjcSplEnumStr(m_hSpl, (IntPtr)0, seq, m_SplCbkNtcStr);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	int		EnumStr(ESplSeq seq, IntPtr cbp)
		{
			int		rc;
			rc = CAjrApi.AjcSplEnumStr(m_hSpl, cbp, seq, m_SplCbkNtcStr);
			return rc;
		}
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	int		EnumStr(SplCbkNtcStr cb)
		{
			int		rc;
			rc = CAjrApi.AjcSplEnumStr(m_hSpl, (IntPtr)0, ESplSeq.Ascending, cb);
			return rc;
		}

		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	int		EnumStr(ESplSeq seq, SplCbkNtcStr cb)
		{
			int		rc;
			rc = CAjrApi.AjcSplEnumStr(m_hSpl, (IntPtr)0, seq, cb);
			return rc;
		}

		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
		public	int		EnumStr(ESplSeq seq, IntPtr cbp, SplCbkNtcStr cb)
		{
			int		rc;
			rc = CAjrApi.AjcSplEnumStr(m_hSpl, cbp, seq, cb);
			return rc;
		}

		//----- PtrToString				------------------------------------------------------------------------//
		public	string	PtrToString(IntPtr ptr)
		{
			string	rc;
			rc = CAjrApi.AjcPtrToString(ptr);
			return rc;
		}

		//----- Delete					------------------------------------------------------------------------//
		public	void	Delete()
		{
			CAjrApi.AjcSplDelete(m_hSpl);
		}

		//------------------------------------------------------------------------------------------------------//
		//	コールバック																						//
		//------------------------------------------------------------------------------------------------------//
		//----- コールバック関数（文字列通知）------------------------------------------------------------------//
		private bool cbSplNtcStr(string str, IntPtr cbp)
		{
			bool rc = false;

			SplArgNtcStr eva = new SplArgNtcStr();
			eva.str = str;
			eva.cbp = cbp;
			if (OnNtcStr != null) {
				rc = OnNtcStr(this, eva);
			}
			return rc;
		}
	}
}
