﻿#include	<AjxCpp.h>


HINSTANCE	hDllInst	= NULL;			//	ＤＬＬのインスタンスハンドル

//	各モジュールの起動時初期設定
extern	BOOL	IniScp(VO);
extern	BOOL	IniSsv(VO);
extern	BOOL	IniSct(VO);

//	各モジュールの終了時後処理
extern	VO	EndScp(VO);
extern	VO	EndSsv(VO);
extern	VO	EndSct(VO);

//==============================================================================================================//
//																												//
//	ＤｌｌＭａｉｎ																								//
//																												//
//==============================================================================================================//
int	 WINAPI	 DllMain (HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved)
{
	int			rc = TRUE;

	//	●プロセス起動
	if (fdwReason == DLL_PROCESS_ATTACH) {
		hDllInst = hInstance;
		//	メモリ割り当て順序番号でブレークポイントを設定（メモリリークのデバッグ用）
		#ifdef _DEBUG
		//	_CrtSetBreakAlloc(511);
		#endif
		//	WM_COMMAND の lParam = コントロールのハンドルとする
		AjcSetCmdWithHdl(TRUE);
		//	各モジュールの起動時初期設定
		do {
			if (!(rc = IniScp())) break;
			if (!(rc = IniSsv())) break;
			if (!(rc = IniSct())) break;
		} while(0);
	}
	//	●プロセス終了
	else if (fdwReason == DLL_PROCESS_DETACH) {
		//	各モジュールの終了時後処理
		EndScp();
		EndSsv();
		EndSct();

		//	メモリ・リーク・チェック
		#ifdef _DEBUG
			if (_CrtDumpMemoryLeaks()) {
				Beep(120, 200);	Sleep(100);
				Beep(120, 200); Sleep(100);
				Beep(120, 500);
			}
		#endif
	}
	return rc;
}
