﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（キー比較）																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	int CALLBACK cbComp(UX key1, UX key2, UX cbp)
{
	CAjxAvl*	p = (CAjxAvl*)cbp;
	return p->OnKeyComp(key1, key2);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード削除通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemove(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	CAjxAvl*	p = (CAjxAvl*)cbp;
	if (!p->m_fDestruct) {
		p->OnNtcRemove(key, pNodeData, len, nest);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード読み出し通知）																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcNode (UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	CAjxAvl*	p = (CAjxAvl*)cbp;
	return p->OnNtcNode(key, pNodeData, len, nest);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxAvl::CAjxAvl() 
{
	m_fDestruct = FALSE;
	if ((m_hAvl = AjcAvlCreate ((UX)this, cbComp, cbRemove)) == NULL) {
		throw std::runtime_error("AVL cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxAvl::~CAjxAvl()
{
	if (m_hAvl != NULL) {
		m_fDestruct = TRUE;
		AjcAvlDelete(m_hAvl);
		m_hAvl = NULL;
	}
}

//	マルチスレッドの許可／禁止
BOOL	CAjxAvl::EnableMultiThread	(BOOL fEnable)
{
	return AjcAvlEnableMultiThread(m_hAvl, fEnable);
}
//----- ノードアクセス ---------------------------------------------------------------------------------//
//	ノード挿入
BOOL	CAjxAvl::InsNode			(UX key, C_VOP pNodeData, UI len)
{
	return AjcAvlInsNode(m_hAvl, key, pNodeData, len);
}
//	ノード取得
int		CAjxAvl::GetNode			(UX key, VOP	 pBuf,		UI lBuf)
{
	return AjcAvlGetNode(m_hAvl, key, pBuf, lBuf);
}
//	ノードアドレス取得
VOP		CAjxAvl::GetNodePtr			(UX	key, UIP pLen)
{
	return AjcAvlGetNodePtr(m_hAvl, key, pLen);
}
VOP		CAjxAvl::GetNodePtr			(UX	key)
{
	return AjcAvlGetNodePtr(m_hAvl, key, NULL);
}
//	ノード置換
BOOL	CAjxAvl::RepNode			(UX key, C_VOP pNodeData, UI len)
{
	return AjcAvlRepNode(m_hAvl, key, pNodeData, len);
}
//	ノード挿入／置換
BOOL	CAjxAvl::InsOrRepNode		(UX key, C_VOP pNodeData, UI len)
{
	return AjcAvlInsOrRepNode(m_hAvl, key, pNodeData, len);
}
//	ノード削除
BOOL	CAjxAvl::DelNode			(UX key)
{
	return AjcAvlDelNode(m_hAvl, key);
}
//	全ノードを削除
BOOL	CAjxAvl::DelAllNodes		()
{
	return AjcAvlDelAllNodes(m_hAvl);
}

//----- 文字列ノードアクセス ---------------------------------------------------------------------------//
//	文字列ノード挿入(ASCII)
UX		CAjxAvl::InsStrNode			(C_BCP pStr)
{
	return AjcAvlInsStrNodeA(m_hAvl, pStr);
}
//	文字列ノード挿入(UNICODE)
UX		CAjxAvl::InsStrNode			(C_WCP pStr)
{
	return AjcAvlInsStrNodeW(m_hAvl, pStr);
}

//	文字列ノード取得(ASCII)
UX		CAjxAvl::GetStrNode			(C_BCP pStr)
{
	return AjcAvlGetStrNodeA(m_hAvl, pStr);
}
//	文字列ノード取得(UNICODE)
UX		CAjxAvl::GetStrNode			(C_WCP pStr)
{
	return AjcAvlGetStrNodeW(m_hAvl, pStr);
}
//	文字列ノード挿入／取得(ASCII)
UX		CAjxAvl::InsOrGetStrNode	(C_BCP pStr)
{
	return AjcAvlInsOrGetStrNodeA(m_hAvl, pStr);
}
//	文字列ノード挿入／取得(UNICODE)
UX		CAjxAvl::InsOrGetStrNode	(C_WCP pStr)
{
	return AjcAvlInsOrGetStrNodeW(m_hAvl, pStr);
}
//	文字列ノード削除(ASCII)
UX		CAjxAvl::DelStrNode			(C_BCP pStr)
{
	return AjcAvlDelStrNodeA(m_hAvl, pStr);
}
//	文字列ノード削除(UNICODE)
UX		CAjxAvl::DelStrNode			(C_WCP pStr)
{
	return AjcAvlDelStrNodeW(m_hAvl, pStr);
}

//----- その他 -----------------------------------------------------------------------------------------//
//	ノード数取得
UI		CAjxAvl::GetCount			()
{
	return AjcAvlGetCount(m_hAvl);
}
//	全ノードのシーケンシャルな読み出し
UI		CAjxAvl::EnumNodes			(BOOL fDownSeq)
{
	return AjcAvlEnumNodesEx(m_hAvl, (UX)this, cbNtcNode, fDownSeq);
}
//	全ノードへのポインタ配列生成
PCAJCAVLPTR	CAjxAvl::CreatePtrArr	(UIP pNum, BOOL fDownSeq)
{
	return AjcAvlCreatePtrArr(m_hAvl, pNum, fDownSeq);
}
//	全ノードへのポインタ配列解放
BOOL		CAjxAvl::ReleasePtrArr	(PCAJCAVLPTR pArr)
{
	return AjcAvlReleasePtrArr(m_hAvl, pArr);
}

//----- 仮想関数 ---------------------------------------------------------------------------------------//
//	キーの比較
int		CAjxAvl::OnKeyComp			(UX key1, UX key2)
{
	int		rc = 0;

	if		(key1 < key2) rc = -1;
	else if (key1 > key2) rc =	1;

	return rc;
}
//	ノード削除通知
VO		CAjxAvl::OnNtcRemove		(UX key, VOP pNodeData, UI len, UI nest)
{
}
//	ノード読み出し通知
BOOL	CAjxAvl::OnNtcNode			(UX key, VOP pNodeData, UI len, UI nest)
{
	return FALSE;
}
