﻿#include	<AjxCpp.h>

using namespace AjxControl;

//==============================================================================================================//
//																												//
//	平衡２分木（文字列キー）																					//
//																												//
//==============================================================================================================//
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード削除通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemoveA(C_BCP key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	CAjxAvs*	p = (CAjxAvs*)cbp;
	if (!p->m_fDestruct) {
		p->OnNtcRemove(key, pNodeData, len, nest);
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemoveW(C_WCP key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	CAjxAvs*	p = (CAjxAvs*)cbp;
	if (!p->m_fDestruct) {
		p->OnNtcRemove(key, pNodeData, len, nest);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード読み出し通知）																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcNodeA (C_BCP key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	CAjxAvs*	p = (CAjxAvs*)cbp;
	return p->OnNtcNode(key, pNodeData, len, nest);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcNodeW (C_WCP key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	CAjxAvs*	p = (CAjxAvs*)cbp;
	return p->OnNtcNode(key, pNodeData, len, nest);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxAvs::CAjxAvs(BOOL fUnicode) 
{
	m_fDestruct = FALSE;

	if (m_fUnicode = fUnicode) m_hAvs = AjcAvsCreateW (AJCCMP_ALPHABETIC, (UX)this, cbRemoveW);
	else					   m_hAvs = AjcAvsCreateA (AJCCMP_ALPHABETIC, (UX)this, cbRemoveA);

	if (m_hAvs == NULL) {
		throw std::runtime_error("AVS cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxAvs::~CAjxAvs()
{
	if (m_hAvs != NULL) {
		m_fDestruct = TRUE;
		AjcAvsDelete(m_hAvs);
		m_hAvs = NULL;
	}
}

//	マルチスレッドの許可／禁止
BOOL	CAjxAvs::EnableMultiThread	(BOOL fEnable)
{
	return AjcAvsEnableMultiThread(m_hAvs, fEnable);
}
//----- ノードアクセス -----------------------------------------------------------------------------------------//
//	ノード挿入(ASCII)
BOOL	CAjxAvs::InsNode			(C_BCP key, C_VOP pNodeData, UI len)
{
	return AjcAvsInsNodeA(m_hAvs, key, pNodeData, len);
}
//	ノード挿入(UNICODE)
BOOL	CAjxAvs::InsNode			(C_WCP key, C_VOP pNodeData, UI len)
{
	return AjcAvsInsNodeW(m_hAvs, key, pNodeData, len);
}


//	ノード取得(ASCII)
int		CAjxAvs::GetNode			(C_BCP key, VOP   pBuf,	  UI lBuf)
{
	return AjcAvsGetNodeA(m_hAvs, key, pBuf, lBuf);
}
//	ノード取得(UNICODE)
int		CAjxAvs::GetNode			(C_WCP key, VOP   pBuf,	  UI lBuf)
{
	return AjcAvsGetNodeW(m_hAvs, key, pBuf, lBuf);
}


//	ノードアドレス取得(ASCII)
VOP		CAjxAvs::GetNodePtr			(C_BCP	key, UIP pLen)
{
	return AjcAvsGetNodePtrA(m_hAvs, key, pLen);
}
//	ノードアドレス取得(UNICODE)
VOP		CAjxAvs::GetNodePtr			(C_WCP	key, UIP pLen)
{
	return AjcAvsGetNodePtrW(m_hAvs, key, pLen);
}


//	ノード置換(ASCII)
BOOL	CAjxAvs::RepNode			(C_BCP key, C_VOP pNodeData, UI len)
{
	return AjcAvsRepNodeA(m_hAvs, key, pNodeData, len);
}
//	ノード置換(UNICODE)
BOOL	CAjxAvs::RepNode			(C_WCP key, C_VOP pNodeData, UI len)
{
	return AjcAvsRepNodeW(m_hAvs, key, pNodeData, len);
}


//	ノード挿入／置換(ASCII)
BOOL	CAjxAvs::InsOrRepNode		(C_BCP key, C_VOP pNodeData, UI len)
{
	return AjcAvsInsOrRepNodeA(m_hAvs, key, pNodeData, len);
}
//	ノード挿入／置換(UNICODE)
BOOL	CAjxAvs::InsOrRepNode		(C_WCP key, C_VOP pNodeData, UI len)
{
	return AjcAvsInsOrRepNodeW(m_hAvs, key, pNodeData, len);
}


//	ノード削除(ASCII)
BOOL	CAjxAvs::DelNode			(C_BCP key)
{
	return AjcAvsDelNodeA(m_hAvs, key);
}
//	ノード削除(UNICODE)
BOOL	CAjxAvs::DelNode			(C_WCP key)
{
	return AjcAvsDelNodeW(m_hAvs, key);
}


//	全ノードを削除
BOOL	CAjxAvs::DelAllNodes		()
{
	return AjcAvsDelAllNodes(m_hAvs);
}

//----- その他 -------------------------------------------------------------------------------------------------//
//	ノード数取得
UI		CAjxAvs::GetCount			()
{
	return AjcAvsGetCount(m_hAvs);
}
//	全ノードのシーケンシャルな読み出し
UI		CAjxAvs::EnumNodes			(BOOL fDownSeq)
{
	UI		rc = 0;
	if (m_fUnicode) rc = AjcAvsEnumNodesExW(m_hAvs, (UX)this, cbNtcNodeW, fDownSeq);
	else			rc = AjcAvsEnumNodesExA(m_hAvs, (UX)this, cbNtcNodeA, fDownSeq);
	return rc;
}

//	全ノードへのポインタ配列生成(ASCII)
BOOL	CAjxAvs::CreatePtrArr	(PCAJCAVSPTRA *ppArr, UIP pNum, BOOL fDownSeq)
{
	return ((ppArr != NULL) && ((*ppArr = AjcAvsCreatePtrArrA(m_hAvs, pNum, fDownSeq)) != NULL));
}
//	全ノードへのポインタ配列生成(UNICODE)
BOOL	CAjxAvs::CreatePtrArr	(PCAJCAVSPTRW *ppArr, UIP pNum, BOOL fDownSeq)
{
	return ((ppArr != NULL) && ((*ppArr = AjcAvsCreatePtrArrW(m_hAvs, pNum, fDownSeq)) != NULL));
}


//	全ノードへのポインタ配列解放(ASCII)
BOOL		CAjxAvs::ReleasePtrArr	(PCAJCAVSPTRA pArr)
{
	return AjcAvsReleasePtrArrA(m_hAvs, pArr);
}
//	全ノードへのポインタ配列解放(UNICODE)
BOOL		CAjxAvs::ReleasePtrArr	(PCAJCAVSPTRW pArr)
{
	return AjcAvsReleasePtrArrW(m_hAvs, pArr);
}

//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	ノード削除通知(ASCII)
VO	 CAjxAvs::OnNtcRemove	(C_BCP key, VOP pNodeData, UI len, UI nest)
{
}
//	ノード削除通知(UNICODE)
VO	 CAjxAvs::OnNtcRemove	(C_WCP key, VOP pNodeData, UI len, UI nest)
{
}


//	ノード読み出し通知(ASCII)
BOOL CAjxAvs::OnNtcNode		(C_BCP key, VOP pNodeData, UI len, UI nest)
{
	return FALSE;
}
//	ノード読み出し通知(UNICODE)
BOOL CAjxAvs::OnNtcNode		(C_WCP key, VOP pNodeData, UI len, UI nest)
{
	return FALSE;
}
