﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcBarSubClassed_"
#define	PROP_NAME_CTRL		"_AjcBarWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_BAR, WM_COMMAND			)
{
	CAjxBar*	p = (CAjxBar*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);

	if (p != NULL) {
		switch (HIWORD(wParam)) {
			case AJCBARN_RANGE:		p->OnNtcRange	(AjcBarGetNtcRng	((HWND)lParam));	break;		//	グラフレンジ通知		－				PAJCBAR_NTC_RANGE
			case AJCBARN_SCRPOS:	p->OnNtcScrPos	(AjcBarGetNtcScrPos	((HWND)lParam));	break;		//	スクロール位置通知		－				クスロール位置
			case AJCBARN_DBLCLK:	p->OnNtcDblClk	();										break;		//	ダブルクリック通知		－				－
			case AJCBARN_DROPFILE:	p->OnNtcDropFile(AjcBarGetNtcFiles	((HWND)lParam));	break;		//	ファイルドロップ通知	－				ファイル数
			case AJCBARN_DROPDIR:	p->OnNtcDropDir	(AjcBarGetNtcDirs	((HWND)lParam));	break;		//	フォルダドロップ通知	－				ディレクトリ数
			case AJCBARN_RCLICK:	p->OnNtcRClick	(AjcBarGetNtcRClk	((HWND)lParam));	break;		//	右クリック通知			－				PAJCBARRCLK
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_BAR);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_BAR, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_BAR);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_BAR)
	AJC_WNDMAP_MSG(SBC_BAR, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_BAR, WM_DESTROY	   )
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxBar::CAjxBar()
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxBar::~CAjxBar()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- データ投与(実数，ASCII) --------------------------------------------------------------------------------//
BOOL	CAjxBar::PutData		(double dat[]					, C_BCP pBarTtl)
{
	return AjcBarPutRealDataA	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(double d0						, C_BCP pBarTtl)
{
	double	dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;
	return AjcBarPutRealDataA	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(double d0, double d1			, C_BCP pBarTtl)
{
	double	dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;
	return AjcBarPutRealDataA	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(double d0, double d1, double d2, C_BCP pBarTtl)
{
	double	dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;	dat[2] = d2;
	return AjcBarPutRealDataA	(m_hCtrl, dat, pBarTtl);
}

//----- データ投与(整数，ASCII)  -------------------------------------------------------------------------------//
BOOL	CAjxBar::PutData		(int dat[]						, C_BCP pBarTtl)
{
	return AjcBarPutIntDataA	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(int d0							, C_BCP pBarTtl)
{
	int		dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;
	return AjcBarPutIntDataA	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(int d0, int d1					, C_BCP pBarTtl)
{
	int		dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;
	return AjcBarPutIntDataA	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(int d0, int d1, int d2			, C_BCP pBarTtl)
{
	int		dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;	dat[2] = d2;
	return AjcBarPutIntDataA	(m_hCtrl, dat, pBarTtl);
}


//----- データ投与(実数，UNICODE) ------------------------------------------------------------------------------//
BOOL	CAjxBar::PutData		(double dat[]					, C_WCP pBarTtl)
{
	return AjcBarPutRealDataW	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(double d0						, C_WCP pBarTtl)
{
	double	dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;
	return AjcBarPutRealDataW	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(double d0, double d1			, C_WCP pBarTtl)
{
	double	dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;
	return AjcBarPutRealDataW	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(double d0, double d1, double d2, C_WCP pBarTtl)
{
	double	dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;	dat[2] = d2;
	return AjcBarPutRealDataW	(m_hCtrl, dat, pBarTtl);
}

//----- データ投与(整数，UNICODE) ------------------------------------------------------------------------------//
BOOL	CAjxBar::PutData		(int dat[]						, C_WCP pBarTtl)
{
	return AjcBarPutIntDataW	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(int d0							, C_WCP pBarTtl)
{
	int		dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;
	return AjcBarPutIntDataW	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(int d0, int d1					, C_WCP pBarTtl)
{
	int		dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;
	return AjcBarPutIntDataW	(m_hCtrl, dat, pBarTtl);
}
BOOL	CAjxBar::PutData		(int d0, int d1, int d2			, C_WCP pBarTtl)
{
	int		dat[AJCBAR_MAXITEM] = {0};
	dat[0] = d0;	dat[1] = d1;	dat[2] = d2;
	return AjcBarPutIntDataW	(m_hCtrl, dat, pBarTtl);
}

//----- 棒タイトル名設定 ---------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetBarTtl		(C_BCP pTtl)
{
	return	AjcBarSetBarTtlA	(m_hCtrl, pTtl);
}
BOOL	CAjxBar::SetBarTtl		(C_WCP pTtl)
{
	return	AjcBarSetBarTtlW	(m_hCtrl, pTtl);
}

//----- 縦軸単位名設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetVUnit		(C_BCP pUnit)
{
	return	AjcBarSetVUnitA		(m_hCtrl, pUnit);
}
BOOL	CAjxBar::SetVUnit		(C_WCP pUnit)
{
	return	AjcBarSetVUnitW		(m_hCtrl, pUnit);
}

//----- データクリアー -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::Purge			()
{
	return	AjcBarPurge			(m_hCtrl);
}

//----- 外枠表示／非表示 ---------------------------------------------------------------------------------------//
BOOL	CAjxBar::ShowBorder		(BOOL fShow, COLORREF rgb)
{
	return	AjcBarShowBorder	(m_hCtrl, fShow, rgb);
}
//----- フィルタ表示／非表示 -----------------------------------------------------------------------------------//
BOOL	CAjxBar::ShowFilter		(BOOL fShow)
{
	return	AjcBarShowFilter	(m_hCtrl, fShow);
}

//----- プロパティ取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::GetProp		(PAJCBARPROP	 pBuf)
{
	return	AjcBarGetProp		(m_hCtrl, pBuf);
}
//----- プロパティ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetProp		(PCAJCBARPROP pProp)
{
	return	AjcBarSetProp		(m_hCtrl, pProp);
}

//----- レンジ取得 ---------------------------------------------------------------------------------------------//
BOOL	CAjxBar::GetRange		(double *pLow, double *pHigh)
{
	return	AjcBarGetRealRange	(m_hCtrl, pLow, pHigh);
}
BOOL	CAjxBar::GetRange		(int	*pLow, int	  *pHigh)
{
	return	AjcBarGetIntRange	(m_hCtrl, pLow, pHigh);
}
//----- レンジ設定 ---------------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetRange		(double	 low, double   high)
{
	return	AjcBarSetRealRange	(m_hCtrl, low, high);
}
BOOL	CAjxBar::SetRange		(int	 low, int	   high)
{
	return	AjcBarSetIntRange	(m_hCtrl, low, high);
}

//----- ベース値取得 -------------------------------------------------------------------------------------------//
BOOL	CAjxBar::GetBase		(double *base)
{
	return	AjcBarGetRealBase	(m_hCtrl, base);
}
BOOL	CAjxBar::GetBase		(int	*base)
{
	return	AjcBarGetIntBase	(m_hCtrl, base);
}
//----- ベース値設定 -------------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetBase		(double  base)
{
	return	AjcBarSetRealBase	(m_hCtrl, base);
}
BOOL	CAjxBar::SetBase		(int	 base)
{
	return	AjcBarSetIntBase	(m_hCtrl, base);
}

//----- バッファサイズ設定 -------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetBufSize		(int n)
{
	return	AjcBarSetBufSize	(m_hCtrl, n);
}
//----- データ項目数設定 ---------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetItemNumber	(int n)
{
	return	AjcBarSetItemNumber	(m_hCtrl, n);
}
//----- スケール値表示域の幅設定 -------------------------------------------------------------------------------//
BOOL	CAjxBar::SetScaleWidth	(int width)
{
	return	AjcBarSetScaleWidth	(m_hCtrl, width);
}
//----- 棒の幅設定 ---------------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetBarWidth	(int width)
{
	return	AjcBarSetBarWidth	(m_hCtrl, width);
}
//----- 棒表示域の幅設定 ---------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetItemWidth	(int width)
{
	return	AjcBarSetItemWidth	(m_hCtrl, width);
}
//----- 棒タイトルの最大行数設定 -------------------------------------------------------------------------------//
BOOL	CAjxBar::SetTtlLines	(int lines)
{
	return	AjcBarSetTtlLines	(m_hCtrl, lines);
}

//----- ビットマップデータ取得 ---------------------------------------------------------------------------------//
HBITMAP	CAjxBar::GetBitmap		()
{
	return	AjcBarGetBitmap		(m_hCtrl);
}

//----- プロファイルからプロパティ読出し -----------------------------------------------------------------------//
BOOL	CAjxBar::LoadProp		(C_BCP pProfileSect, PCAJCBARPROP pDefProp)
{
	return	AjcBarLoadPropA		(m_hCtrl, pProfileSect, pDefProp);
}
BOOL	CAjxBar::LoadProp		(C_WCP pProfileSect, PCAJCBARPROP pDefProp)
{
	return	AjcBarLoadPropW		(m_hCtrl, pProfileSect, pDefProp);
}

//----- プロファイルへプロパティ書き込み -----------------------------------------------------------------------//
BOOL	CAjxBar::SaveProp		(C_BCP pProfileSect)
{
	return	AjcBarSavePropA		(m_hCtrl, pProfileSect);
}
BOOL	CAjxBar::SaveProp		(C_WCP pProfileSect)
{
	return	AjcBarSavePropW		(m_hCtrl, pProfileSect);
}

//----- プロファイルからプロパティ読出し(拡張) -----------------------------------------------------------------//
BOOL	CAjxBar::LoadPropEx		(C_BCP pProfileSect, PCAJCBARPROP pDefProp)
{
	return	AjcBarLoadPropExA	(m_hCtrl, pProfileSect, pDefProp);
}
BOOL	CAjxBar::LoadPropEx		(C_WCP pProfileSect, PCAJCBARPROP pDefProp)
{
	return	AjcBarLoadPropExW	(m_hCtrl, pProfileSect, pDefProp);
}

//----- プロファイルへプロパティ書き込み(拡張) -----------------------------------------------------------------//
BOOL	CAjxBar::SavePropEx	(C_BCP pProfileSect)
{
	return	AjcBarSavePropExA	(m_hCtrl, pProfileSect);
}
BOOL	CAjxBar::SavePropEx	(C_WCP pProfileSect)
{
	return	AjcBarSavePropExW	(m_hCtrl, pProfileSect);
}

//----- 右クリックによるポップアップメニュー許可／禁止 ---------------------------------------------------------//
BOOL	CAjxBar::EnablePopupMenu		(BOOL fEnable)
{
	return	AjcBarEnablePopupMenu(m_hCtrl, fEnable);
}
//----- 右クリック通知設定 -------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetNtcRClk	 	(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	return	AjcBarSetNtcRClk	(m_hCtrl, fNtcRClk, MsgRBDown, MsgRBUp);
}

//----- ツールチップの設定 -------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetTipText	 	(C_BCP pTxt)
{
	return	AjcBarSetTipTextA	(m_hCtrl, pTxt);
}
BOOL	CAjxBar::SetTipText 	(C_WCP pTxt)
{
	return	AjcBarSetTipTextW	(m_hCtrl, pTxt);
}

//----- ツールチップの取得 -------------------------------------------------------------------------------------//
UI		CAjxBar::GetTipText		(BCP pBuf, UI lBuf)
{
	return	AjcBarGetTipTextA	(m_hCtrl, pBuf, lBuf);
}
UI		CAjxBar::GetTipText 	(WCP pBuf, UI lBuf)
{
	return	AjcBarGetTipTextW	(m_hCtrl, pBuf, lBuf);
}

//----- ツールチップ表示条件の設定 -----------------------------------------------------------------------------//
BOOL	CAjxBar::SetTipShowAlways(BOOL fShowAlways)
{
	return	AjcBarSetTipShowAlways(m_hCtrl, fShowAlways);
}
//----- ツールチップ表示条件の取得 -----------------------------------------------------------------------------//
BOOL	CAjxBar::GetTipShowAlways()
{
	return	AjcBarGetTipShowAlways	(m_hCtrl);
}

//----- フィィルタチェックボックス・ツールチップの設定 ---------------------------------------------------------//
BOOL	CAjxBar::SetChkBoxTipText(UI n, C_BCP pTxt)
{
	return	AjcBarSetChkBoxTipTextA(m_hCtrl, n, pTxt);
}
BOOL	CAjxBar::SetChkBoxTipText(UI n, C_WCP pTxt)
{
	return	AjcBarSetChkBoxTipTextW(m_hCtrl, n, pTxt);
}

//----- フィィルタチェックボックス・ツールチップの取得 ---------------------------------------------------------//
UI		CAjxBar::GetChkBoxTipText(UI n, BCP pBuf, UI lBuf)
{
	return	AjcBarGetChkBoxTipTextA(m_hCtrl, n, pBuf, lBuf);
}
UI		CAjxBar::GetChkBoxTipText(UI n, WCP pBuf, UI lBuf)
{
	return	AjcBarGetChkBoxTipTextW(m_hCtrl, n, pBuf, lBuf);
}

//----- フィルタ・チェックボックス・ツールチップ表示条件の設定 -------------------------------------------------//
BOOL	CAjxBar::SetChkBoxTipShowAlway(UI n, BOOL fShowAlways)
{
	return	AjcBarSetChkBoxTipShowAlways(m_hCtrl, n, fShowAlways);
}
//----- フィルタ・チェックボックス・ツールチップ表示条件の取得 -------------------------------------------------//
BOOL	CAjxBar::GetChkBoxTipShowAlway(UI n)
{
	return	AjcBarGetChkBoxTipShowAlways(m_hCtrl, n);
}

//----- 全ツールチップ表示条件の設定 ---------------------------------------------------------------------------//
BOOL	CAjxBar::SetTipShowAlwaysAll(BOOL fShowAlways)
{
	return	AjcBarSetTipShowAlwaysAll(m_hCtrl, fShowAlways);
}

//----- スクロール位置の取得 -----------------------------------------------------------------------------------//
int		CAjxBar::GetScrollPos	()
{
	return	AjcBarGetScrollPos	(m_hCtrl);
}
//----- スクロール位置の設定 -----------------------------------------------------------------------------------//
BOOL	CAjxBar::SetScrollPos	(int pos)
{
	return	AjcBarSetScrollPos	(m_hCtrl, pos);
}

//----- フィルタの設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetFilter		(UI n, BOOL state)
{
	return	AjcBarSetFilter		(m_hCtrl, n, state);
}
//----- フィルタの取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::GetFilter		(UI n)
{
	return	AjcBarGetFilter		(m_hCtrl, n);
}

//----- 横線の属性設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetHLineAtt	(UI id, COLORREF color, int width, int style)
{
	return	AjcBarSetHLineAtt	(m_hCtrl, id, color, width, style);
}
//----- 横線の描画位置設定 -------------------------------------------------------------------------------------//
BOOL	CAjxBar::SetHLinePos	(UI id, double pos)
{
	return	AjcBarSetHLinePos	(m_hCtrl, id, pos);
}
//----- 横線描画の許可／禁止 -----------------------------------------------------------------------------------//
BOOL	CAjxBar::EnableHLine	(UI id, BOOL fEnable)
{
	return	AjcBarEnableHLine	(m_hCtrl, id, fEnable);
}

//----- 文字サイズの取得 ---------------------------------------------------------------------------------------//
BOOL	CAjxBar::GetCharSize	(LPSIZE pSize)
{
	return	AjcBarGetCharSize	(m_hCtrl, pSize);
}

//----- ドロップされたファイル名取得 ---------------------------------------------------------------------------//
BOOL	CAjxBar::GetDroppedFile	(BC buf[MAX_PATH])
{
	return	AjcBarGetDroppedFileA(m_hCtrl, buf);
}
BOOL	CAjxBar::GetDroppedFile	(WC buf[MAX_PATH])
{
	return	AjcBarGetDroppedFileW(m_hCtrl, buf);
}

//----- ドロップされたディレクトリ名取得 -----------------------------------------------------------------------//
BOOL	CAjxBar::GetDroppedDir(BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return	AjcBarGetDroppedDirExA(m_hCtrl, buf, fTailIsDelimiter);
}
BOOL	CAjxBar::GetDroppedDir(WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return	AjcBarGetDroppedDirExW(m_hCtrl, buf, fTailIsDelimiter);
}

//----- タイトル文字列の設定 -----------------------------------------------------------------------------------//
BOOL	CAjxBar::SetTitleText	(C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	return	AjcBarSetTitleTextA	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}

BOOL	CAjxBar::SetTitleText	(C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	return	AjcBarSetTitleTextW	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}

//----- テキスト描画フォント設定 -------------------------------------------------------------------------------//
HFONT	CAjxBar::SetTextFont	(HFONT hFont)
{
	return AjcBarSetTextFont	(m_hCtrl, hFont);
}
//----- テキスト描画（ピクセル位置指定）(ASCII) ----------------------------------------------------------------//
UI		CAjxBar::TextOut		(int x, int y, C_BCP pTxt)
{
	return AjcBarTextOutA		(m_hCtrl, x, y, pTxt);
}
//----- テキスト描画（ピクセル位置指定）(UNICODE) --------------------------------------------------------------//
UI		CAjxBar::TextOut		(int x, int y, C_WCP pTxt)
{
	return AjcBarTextOutW		(m_hCtrl, x, y, pTxt);
}
//----- 書式テキスト描画（ピクセル位置指定）(ASCII) ------------------------------------------------------------//
UI		CAjxBar::PrintF			(int x, int y, C_BCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2046, pFmt, vls);
		va_end	(vls);
		rc = AjcBarTextOutA(m_hCtrl, x, y, buf);
	}
	return rc;
}
//----- 書式テキスト描画（ピクセル位置指定）(UNICODE) ----------------------------------------------------------//
UI		CAjxBar::PrintF			(int x, int y, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcBarTextOutW(m_hCtrl, x, y, buf);
	}
	return rc;
}
//----- 描画テキスト取得(ASCII) --------------------------------------------------------------------------------//
UI		CAjxBar::GetText		(UI key, BCP pBuf, UI lBuf)
{
	return AjcBarGetTextA		(m_hCtrl, key, pBuf, lBuf);
}
//----- 描画テキスト取得(UNICODE) ------------------------------------------------------------------------------//
UI		CAjxBar::GetText		(UI key, WCP pBuf, UI lBuf)
{
	return AjcBarGetTextW		(m_hCtrl, key, pBuf, lBuf);
}
//----- 描画テキストクリアー -----------------------------------------------------------------------------------//
BOOL	CAjxBar::ClearText		(UI key)
{
	return AjcBarClearText		(m_hCtrl, key);
}
//-----  全ての描画テキストクリアー ----------------------------------------------------------------------------//
BOOL	CAjxBar::ClearText		()
{
	return AjcBarClearAllText	(m_hCtrl);
}
//-----  全てのデータとテキストクリアー ------------------------------------------------------------------------//
BOOL	CAjxBar::Clear			()
{
	return AjcBarClear			(m_hCtrl);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxBar::Attach		(HWND hWnd)					//	ハンドルを関連付け
{
	HWND	hParent; 
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hWnd)) {
		::GetClassNameA(hWnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrlBarGraph") == 0) {
			//	ワーク初期化
			m_hCtrl = hWnd;
			hParent = ::GetParent(hWnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_BAR, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("BAR cannot be generated due to an invalid window class.");
	}
	else throw std::runtime_error("BAR cannot be generated due to an invalid window handle.");
}
//----- レンジ変化通知 -----------------------------------------------------------------------------------------//
VO	CAjxBar::OnNtcRange		(PCAJCBAR_NTC_RANGE pRange)
{
}
//----- スクロール位置変化通知 ---------------------------------------------------------------------------------//
VO	CAjxBar::OnNtcScrPos	(UI 				ScrPos)
{
}
//----- ダブルクリック通知 -------------------------------------------------------------------------------------//
VO	CAjxBar::OnNtcDblClk	()
{
}
//----- ファイルドロップ通知 -----------------------------------------------------------------------------------//
VO	CAjxBar::OnNtcDropFile	(UI 				nFiles)
{
}
//----- ディレクトリドロップ通知 -------------------------------------------------------------------------------//
VO	CAjxBar::OnNtcDropDir	(UI 				nDirs )
{
}
//----- 右クリック通知 -----------------------------------------------------------------------------------------//
VO	CAjxBar::OnNtcRClick	(PCAJCBARRCLK		pRClk )
{
}
