﻿#include	<AjxCpp.h>

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンソール	スタティック コントロール																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	標準出力／標準エラー のモード設定
BOOL		SAjxCon::SetStdMode			(EAJCTEC tec, BOOL fBom)
{
	return AjcSetStdMode(tec, fBom);
}

//	文字列をコンソール(標準出力)へ出力(ASCII)
int			SAjxCon::PutS				(C_BCP pStr)
{
	return AjcPutSA(pStr);
}
//	文字列をコンソール(標準出力)へ出力(UNICODE)
int			SAjxCon::PutS				(C_WCP pStr)
{
	return AjcPutSW(pStr);
}
//	書式文字列をコンソール(標準出力)へ出力(ASCII)
int			SAjxCon::PrintF				(C_BCP pFmt, ...)
{
	int		rc = -1;
	va_list vls;
	BC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcPutSA(txt);
	}
	return rc;
}
//	書式文字列をコンソール(標準出力)へ出力(UNICODE)
int			SAjxCon::PrintF				(C_WCP pFmt, ...)
{
	int		rc = -1;
	va_list vls;
	WC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcPutSW(txt);
	}
	return rc;
}
//	書式文字列をコンソール(標準エラー)へ出力(ASCII)
int	 		SAjxCon::ErrPrintF			(C_BCP pFmt, ...)
{
	int		rc = -1;
	va_list vls;
	BC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcPutSA(txt);
	}
	return rc;
}
//	書式文字列をコンソール(標準エラー)へ出力(UNICODE)
int	 		SAjxCon::ErrPrintF			(C_WCP pFmt, ...)
{
	int		rc = -1;
	va_list vls;
	WC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcPutSW(txt);
	}
	return rc;
}
//	コンソール情報取得
BOOL		SAjxCon::GetScreenBufferInfo(LPSIZE pBufSize, LPRECT pRcWnd, LPSIZE pMaxWndSize)
{
	return AjcGetConsoleScreenBufferInfo(pBufSize, pRcWnd, pMaxWndSize);
}
//	ウインド最大サイズ取得
BOOL		SAjxCon::GetMaxWndSize		(int *pCx  , int *pCy)
{
	return AjcGetConsoleMaxWndSize(pCx, pCy);
}
//	バッファサイズ設定
BOOL		SAjxCon::SetBufSize			(int cx, int cy)
{
	return AjcSetConsoleBufSize (cx, cy);
}
//	バッファサイズ取得
BOOL		SAjxCon::GetBufSize 		(int *pCx  , int *pCy)
{
	return AjcGetConsoleBufSize(pCx, pCy);
}
//	コンソールウインド矩形設定
BOOL		SAjxCon::SetWndRect			(int left  , int top  , int right  , int bottom  )
{
	return AjcSetConsoleWndRect (left, top, right, bottom);
}
//	コンソールウインド矩形取得
BOOL		SAjxCon::GetWndRect			(int *pLeft, int *pTop, int *pRight, int *pBottom)
{
	return AjcGetConsoleWndRect (pLeft, pTop, pRight, pBottom);
}
//	表示色設定
BOOL		SAjxCon::SetColor			(COLORREF	  ForeColor,   COLORREF  BackColor)
{
	return AjcSetConsoleColor(ForeColor, BackColor);
}
//	表示色取得
BOOL		SAjxCon::GetColor			(LPCOLORREF pForeColor, LPCOLORREF pBackColor)
{
	return AjcGetConsoleColor (pForeColor, pBackColor);
}
//	表示色パレット選択
BOOL		SAjxCon::SelPalette			(UI ForePalette, UI BackPalette)
{
	return AjcSelConsolePalette(ForePalette, BackPalette);
}
//	文字色パレット値の取得
COLORREF	SAjxCon::GetForeColor		()
{
	return AjcGetConsoleForeColor();
}
//	背景色パレット値の取得
COLORREF	SAjxCon::GetBackColor		()
{
	return AjcGetConsoleBackColor();
}
//	表示パレット設定（全パレット）
BOOL		SAjxCon::SetPalette			(const COLORREF Palette[16])
{
	return AjcSetConsolePalette(Palette);
}
//	表示パレット設定（単一パレット）
BOOL	 	SAjxCon::SetPalByIx			(UI ix, COLORREF color)
{
	return AjcSetConsolePalByIx(ix, color);
}
//	表示パレット取得（全パレット）
UI			SAjxCon::GetPalette			(COLORREF Palette[16])
{
	return AjcGetConsolePalette(Palette);
}
//	表示パレット取得（単一パレット）
COLORREF	SAjxCon::GetPalByIx			(UI ix)
{
	return AjcGetConsolePalByIx(ix);
}
//	カーソル位置設定
BOOL		SAjxCon::SetCursor			(int x, int y)
{
	return AjcSetConsoleCursor(x, y);
}
//	カーソル位置取得
BOOL		SAjxCon::GetCursor			(int *pX, int *pY)
{
	return AjcGetConsoleCursor(pX, pY);
}


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンソール入力 																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	コールバック(ASCII)
VO	CALLBACK cbNtcArgsA(int argc, BC *argv[], C_BCP pTxt, UX cbp)
{
	CAjxCon* p = (CAjxCon*)cbp;
	p->OnNtcStr(argc, argv, pTxt);
}
//	コールバック(UNICODE)
VO	CALLBACK cbNtcArgsW(int argc, WC *argv[], C_WCP pTxt, UX cbp)
{
	CAjxCon* p = (CAjxCon*)cbp;
	p->OnNtcStr(argc, argv, pTxt);
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
CAjxCon::CAjxCon()					//	コンストラクタ
{
}
CAjxCon::~CAjxCon()					//	デストラクタ
{
}

//----- ASCII ------------------------------------------------------------------------------------------//
//	１行入力（入力バッファ指定を内部で生成）
BOOL	 CAjxCon::Input (C_BCP pHelpText, UI lInpField, UI lBuf, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	BOOL	rc = FALSE;
	BCP		pBuf;
	if (pBuf = (BCP)malloc(lBuf)) {
		memset(pBuf, 0, lBuf);
		rc = AjcConInputExA (pBuf, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, (UX)this, cbNtcArgsA);
		free(pBuf);
	}
	return rc;
}

//	１行入力（入力バッファ指定）
BOOL	CAjxCon::Input (UI lInpField,
						BCP pBuf		  , UI lBuf,
						C_BCP pHelpText, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	return AjcConInputExA (pBuf, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, (UX)this, cbNtcArgsA);
}
//	１行入力（初期テキスト指定）
BOOL	CAjxCon::Input (C_BCP pInitialText, UI lInpField,
						BCP pBuf		  , UI lBuf,
						C_BCP pHelpText, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	return AjcConInputExA (pInitialText, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, (UX)this, cbNtcArgsA);
}

//----- UNICODE ----------------------------------------------------------------------------------------//
//	１行入力（入力バッファを内部で生成）
BOOL	 CAjxCon::Input (C_WCP pHelpText, UI lInpField, UI lBuf, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	BOOL	rc = FALSE;
	WCP		pBuf;
	if (pBuf = (WCP)malloc(lBuf * 2)) {
		memset(pBuf, 0, lBuf * 2);
		rc = AjcConInputExW (pBuf, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, (UX)this, cbNtcArgsW);
		free(pBuf);
	}
	return rc;
}
//	１行入力（入力バッファ指定）
BOOL	CAjxCon::Input (UI lInpField,
						WCP pBuf		  , UI lBuf,
						C_WCP pHelpText, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	return AjcConInputExW (pBuf, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, (UX)this, cbNtcArgsW);
}

//	１行入力（初期テキスト指定）
BOOL	CAjxCon::Input (C_WCP pInitialText, UI lInpField,
						WCP pBuf		  , UI lBuf,
						C_WCP pHelpText, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	return AjcConInputExW (pInitialText, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, (UX)this, cbNtcArgsW);
}

//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	入力テキスト通知(ASCII)
VO		CAjxCon::OnNtcStr(int argc, BC *argv[], C_BCP pTxt)
{
}
//	入力テキスト通知(UNICODE)
VO		CAjxCon::OnNtcStr(int argc, WC *argv[], C_WCP pTxt)
{
}

