﻿#include	<AjxCpp.h>

using namespace AjxControl;


//==============================================================================================================//
//																												//
//	Ｃ言語字句分解クラス(ASCII)																					//
//																												//
//==============================================================================================================//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（１行読み出し要求, ASCII）																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbCtkA (BCP pBuf, UI lBuf, UX cbp)
{
	CAjxCtk*	p = (CAjxCtk*)cbp;
	return p->OnGetLine(pBuf, lBuf);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（１行読み出し要求, UNICODE）																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbCtkW (WCP pBuf, UI lBuf, UX cbp)
{
	CAjxCtk*	p = (CAjxCtk*)cbp;
	return p->OnGetLine(pBuf, lBuf);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxCtk::CAjxCtk(BOOL fUnicode) 
{
	m_Ix	= 0;
	memset(m_hCtk, 0, sizeof m_hCtk);

	if (m_fUnicode = fUnicode) m_hCtk[m_Ix] = AjcCtkCreateW(AJCTKFLG_DOTSYMBOL | AJCTKFLG_LBF_4K, cbCtkW, (UX)this);
	else					   m_hCtk[m_Ix] = AjcCtkCreateA(AJCTKFLG_DOTSYMBOL | AJCTKFLG_LBF_4K, cbCtkA, (UX)this);


	if (m_hCtk[m_Ix] == NULL) {
		throw std::runtime_error("CTK cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxCtk::~CAjxCtk()
{
	while (m_Ix >= 0) {
		if (m_hCtk[m_Ix] != NULL) {
			AjcCtkDelete(m_hCtk[m_Ix]);
			m_hCtk[m_Ix] = NULL;
		}
		m_Ix--;
	}
}

//	リセット
BOOL	CAjxCtk::Reset			()
{
	return AjcCtkReset			(m_hCtk[m_Ix]);
}
//	機能フラグの設定
BOOL	CAjxCtk::SetFlag		(UI flag)
{
	return AjcCtkSetFlag(m_hCtk[m_Ix], flag);
}
//	機能フラグの取得
UI		CAjxCtk::GetFlag		()
{
	return AjcCtkGetFlag		(m_hCtk[m_Ix]);
}
//	字句読み出し(ASCII)
BOOL	CAjxCtk::GetToken		(BCP pStrBuf, UI lStrBuf)
{
	return AjcCtkGetTokenA		(m_hCtk[m_Ix], pStrBuf, lStrBuf);
}
//	字句読み出し(UNICODE)
BOOL	CAjxCtk::GetToken		(WCP pStrBuf, UI lStrBuf)
{
	return AjcCtkGetTokenW		(m_hCtk[m_Ix], pStrBuf, lStrBuf);
}
//	現在の字句取得(ASCII)
BOOL	CAjxCtk::PeekToken		(BCP pStrBuf, UI lStrBuf)
{
	return AjcCtkPeekTokenA		(m_hCtk[m_Ix], pStrBuf, lStrBuf);
}
//	現在の字句取得(UNICODE)
BOOL	CAjxCtk::PeekToken		(WCP pStrBuf, UI lStrBuf)
{
	return AjcCtkPeekTokenW		(m_hCtk[m_Ix], pStrBuf, lStrBuf);
}
//	読み出し位置の退避
BOOL		CAjxCtk::Push		()
{
	BOOL	rc = FALSE;
	HAJCTK	hCtk;

	if (m_Ix < CAJX_CTKMAX_STACK - 1) {
		if (hCtk = AjcCtkGetReplicatedHandle(m_hCtk[m_Ix])) {
			m_Ix++;
			m_hCtk[m_Ix] = hCtk;
			rc = TRUE;
		}
	}
	return rc;
}
//	読み出し位置の回復
BOOL		CAjxCtk::Pop		()
{
	BOOL	rc = FALSE;

	if (m_Ix >= 1) {
		AjcCtkDelete(m_hCtk[m_Ix]);
		m_Ix--;
	}
	return rc;
}
//	トークンコードに対応する文字列の取得
C_BCP	GetTokenString	(EAJCTKCODE tkn)
{
	return AjcCtkGetTokenStringA(tkn);
}
//----- トークン情報取得 ---------------------------------------------------------------------------------------//
//	エラーコード取得
UI			CAjxCtk::Error		()
{
	return AJCTK_ERROR			(m_hCtk[m_Ix]);
}
//	トークンコード取得
EAJCTKCODE	CAjxCtk::Token		()
{
	return AJCTK_TOKEN			(m_hCtk[m_Ix]);
}
//	数値定数のサフィックスコード取得
EAJCTKSUF	CAjxCtk::Suffix	()
{
	return AJCTK_SUFFIX		(m_hCtk[m_Ix]);
}
//	フラグ情報取得
UI			CAjxCtk::Flag	()
{
	return AJCTK_FLAG		(m_hCtk[m_Ix]);
}
//	当該字句が存在する、ソースプログラム上の行番号取得
UI			CAjxCtk::Line	()
{
	return	AJCTK_LINE(m_hCtk[m_Ix]);
}
//	当該字句が存在する、ライン上の桁位置を返します（タブも１文字として計算）
UI			CAjxCtk::Loc	()
{
	return	AJCTK_LOC(m_hCtk[m_Ix]);
}
//	当該字句が存在する、タブ文字(0x09)を考慮したライン上の桁位置を返します（TabStepはタブステップ幅）
UI			CAjxCtk::Pos	(UI TabStep)
{
	return	AJCTK_POS(m_hCtk[m_Ix], TabStep);
}

//----- トークンチェック ---------------------------------------------------------------------------------------//
//	トークンチェック（ユーザシンボル）
BOOL		CAjxCtk::IsUsrSym	(EAJCTKCODE tkn)
{
	return AJCTKIS_USRSYM(tkn);
}
//	トークンチェック（予約名）
BOOL		CAjxCtk::IsRsvSym	(EAJCTKCODE tkn)
{
	return AJCTKIS_RSVSYM(tkn);
}
//	トークンチェック（数値）
BOOL		CAjxCtk::IsValue	(EAJCTKCODE tkn)
{
	return AJCTKIS_VALUE(tkn);
}
//	トークンチェック（文字列）
BOOL		CAjxCtk::IsString	(EAJCTKCODE tkn)
{
	return AJCTKIS_STRING(tkn);
}
//	トークンチェック（パス名）
BOOL		CAjxCtk::IsPathName	(EAJCTKCODE tkn)
{
	return AJCTKIS_PATHNAME(tkn);
}
//	トークンチェック（デリミタ）
BOOL		CAjxCtk::IsDelimit	(EAJCTKCODE tkn)
{
	return AJCTKIS_DELIMIT(tkn);
}
//	トークンチェック（シンボル）
BOOL		CAjxCtk::IsSymbol	(EAJCTKCODE tkn)
{
	return AJCTKIS_SYMBOL(tkn);
}
//	トークンチェック（シンボル／数値）
BOOL		CAjxCtk::IsValSym	(EAJCTKCODE tkn)
{
	return AJCTKIS_VALSYM(tkn);
}
//	トークンチェック（空白）
BOOL		CAjxCtk::IsSpace	(EAJCTKCODE tkn)
{
	return AJCTKIS_SPACE(tkn);
}

//----- 仮想関数 ---------------------------------------------------------------------------------------//
//	１行読み出し要求(ASCII)
BOOL  CAjxCtk::OnGetLine	(BCP pBuf, UI lBuf)
{
	return FALSE;
}
//	１行読み出し要求(UNICODE)
BOOL  CAjxCtk::OnGetLine	(WCP pBuf, UI lBuf)
{
	return FALSE;
}
