﻿#include	<AjxCpp.h>

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スタティック関数																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//----- コントロールアクセス -------------------------------------------------------------------------//
//	コントロールの取得（符号なし整数）
UI		SAjxCtrl::GetCtrlUInt					(HWND hCtrl)
{
	return		AjcGetCtrlUInt(hCtrl);
}
//	コントロールの取得（符号付き整数）
SI		SAjxCtrl::GetCtrlSInt					(HWND hCtrl)
{
	return		AjcGetCtrlSInt(hCtrl);
}
//	コントロールの取得（１６進整数）
UI		SAjxCtrl::GetCtrlHex					(HWND hCtrl)
{
	return		AjcGetCtrlHex(hCtrl);
}
//	コントロールの取得（実数）
double	SAjxCtrl::GetCtrlReal					(HWND hCtrl)
{
	return		AjcGetCtrlReal(hCtrl);
}
//	コントロールの取得（符号なし長整数）
ULL		SAjxCtrl::GetCtrlUI64					(HWND hCtrl)
{
	return		AjcGetCtrlUI64(hCtrl);
}
//	コントロールの取得（符号なし長整数）
SLL		SAjxCtrl::GetCtrlSI64					(HWND hCtrl)
{
	return		AjcGetCtrlSI64	(hCtrl);
}
//	コントロールの取得（１６進長整数）
ULL		SAjxCtrl::GetCtrlH64					(HWND hCtrl)
{
	return		AjcGetCtrlH64(hCtrl);
}
//	コントロールの取得（チェックボックス）
UI		SAjxCtrl::GetCtrlChk					(HWND hCtrl)
{
	return		AjcGetCtrlChk(hCtrl);
}
//	コントロールの取得（文字列, ASCII）
UI		SAjxCtrl::GetCtrlStr					(HWND hCtrl, BCP   pBuf, UI lBuf)
{
	return		AjcGetCtrlStrA(hCtrl, pBuf, lBuf);
}
//	コントロールの取得（文字列,UNICODE）
UI		SAjxCtrl::GetCtrlStr					(HWND hCtrl, WCP   pBuf, UI lBuf)
{
	return		AjcGetCtrlStrW(hCtrl, pBuf, lBuf);
}
//	コントロールの取得（文字列長）
UI		SAjxCtrl::GetCtrlStrLen					(HWND hCtrl, BOOL fUnicode)
{	UI		rc = 0;

	if (fUnicode) rc = AjcGetCtrlStrLenW(hCtrl);
	else		  rc = AjcGetCtrlStrLenA(hCtrl);
	return rc;
}
//	コントロールの取得（スライダの位置）
int	 	SAjxCtrl::GetCtrlSldPos					(HWND hCtrl)
{
	return		AjcGetCtrlSldPos(hCtrl);
}
//	コントロールの取得（コンボボックス・インデクス）
UI		SAjxCtrl::GetCtrlCboIx					(HWND hCtrl)
{
	return		AjcGetCtrlCboIx(hCtrl);
}
//	コントロールの取得（コンボボックス・項目数）
UI		SAjxCtrl::GetCtrlCboCount				(HWND hCtrl)
{
	return		AjcGetCtrlCboCount(hCtrl);
}
//	コントロールの取得（コンボボックス・文字長, ASCII）
UI		SAjxCtrl::GetCtrlCboLen					(HWND hCtrl, UI ix, BOOL fUnicode)
{
	UI		rc = 0;
	if (fUnicode) rc = AjcGetCtrlCboLenW(hCtrl, ix);
	else		  rc = AjcGetCtrlCboLenA(hCtrl, ix);
	return rc;
}
//	コントロールの取得（コンボボックス・項目の文字列, ASCII）
UI		SAjxCtrl::GetCtrlCboItem				(HWND hCtrl, UI ix, BCP pBuf, UI lBuf)
{
	return		AjcGetCtrlCboItemA(hCtrl, ix, pBuf, lBuf);
}
//	コントロールの取得（コンボボックス・項目の文字列, UNICODE）
UI		SAjxCtrl::GetCtrlCboItem				(HWND hCtrl, UI ix, WCP pBuf, UI lBuf)
{
	return		AjcGetCtrlCboItemW(hCtrl, ix, pBuf, lBuf);
}
//	コントロールの取得（コンボボックス・データ値）
SX		SAjxCtrl::GetCtrlCboData				(HWND hCtrl, UI ix)
{
	return		AjcGetCtrlCboData(hCtrl, ix);
}
//	コントロールの取得（コンボボックス・文字列検索, ASCII）
UI		SAjxCtrl::GetCtrlCboFind				(HWND hCtrl, UI ix, C_BCP pStr, UI flag)
{
	return		AjcGetCtrlCboFindA(hCtrl, ix, pStr, flag);
}
//	コントロールの取得（コンボボックス・文字列検索, UNICODE）
UI		SAjxCtrl::GetCtrlCboFind				(HWND hCtrl, UI ix, C_WCP pStr, UI flag)
{
	return		AjcGetCtrlCboFindW(hCtrl, ix, pStr, flag);
}
//	コントロールの取得（コンボボックス・項目群のの最大文字列長）
UI		SAjxCtrl::GetCtrlCboMaxLen				(HWND hCtrl, BOOL fUnicode)
{
	UI		rc = 0;
	if (fUnicode) rc = AjcGetCtrlCboMaxLenW(hCtrl);
	else		  rc = AjcGetCtrlCboMaxLenA(hCtrl);
	return rc;
}
//	コントロールの設定（符号なし整数）
BOOL	SAjxCtrl::SetCtrlUInt					(HWND hCtrl, UI 	value)
{
	return		AjcSetCtrlUInt(hCtrl, value);
}
//	コントロールの設定（符号付き整数）
BOOL 	SAjxCtrl::SetCtrlSInt					(HWND hCtrl, SI 	value)
{
	return		AjcSetCtrlSInt(hCtrl, value);
}
//	コントロールの設定（１６進整数）
BOOL 	SAjxCtrl::SetCtrlHex					(HWND hCtrl, UI 	value)
{
	return		AjcSetCtrlHex(hCtrl, value);
}
//	コントロールの設定（実数）
BOOL 	SAjxCtrl::SetCtrlReal					(HWND hCtrl, double value, int prec)
{
	return		AjcSetCtrlReal(hCtrl, value, prec);
}
//	コントロールの設定（符号なし長整数）
BOOL 	SAjxCtrl::SetCtrlUI64					(HWND hCtrl, ULL	value)
{
	return		AjcSetCtrlUI64(hCtrl, value);
}
//	コントロールの設定（符号付き長整数）
BOOL 	SAjxCtrl::SetCtrlSI64					(HWND hCtrl, SLL	value)
{
	return		AjcSetCtrlSI64(hCtrl, value);
}
//	コントロールの設定（１６進長整数）
BOOL 	SAjxCtrl::SetCtrlH64					(HWND hCtrl, ULL	value)
{
	return		AjcSetCtrlH64(hCtrl, value);
}
//	コントロールの設定（符号なし整数，	３桁区切り）
BOOL 	SAjxCtrl::SepCtrlUInt					(HWND hCtrl, UI 	value)
{
	return		AjcSepCtrlUInt(hCtrl,value );
}
//	コントロールの設定（符号付き整数，	３桁区切り）
BOOL 	SAjxCtrl::SepCtrlSInt					(HWND hCtrl, SI 	value)
{
	return		AjcSepCtrlSInt(hCtrl, value);
}
//	コントロールの設定（１６進整数	，	桁数指定）
BOOL 	SAjxCtrl::SepCtrlHex					(HWND hCtrl, UI 	value, int col )
{
	return		AjcSepCtrlHex(hCtrl, value, col);
}
//	コントロールの設定（実数，		  ３桁区切り）
BOOL 	SAjxCtrl::SepCtrlReal					(HWND hCtrl, double value, int prec)
{
	return		AjcSepCtrlReal(hCtrl, value, prec);
}
//	コントロールの設定（符号なし長整数，３桁区切り）
BOOL 	SAjxCtrl::SepCtrlUI64					(HWND hCtrl, ULL	value)
{
	return		AjcSepCtrlUI64(hCtrl, value);
}
//	コントロールの設定（符号付き長整数，３桁区切り）
BOOL 	SAjxCtrl::SepCtrlSI64					(HWND hCtrl, SLL	value)
{
	return		AjcSepCtrlSI64(hCtrl, value);
}
//	コントロールの設定（１６進長整数	，桁数指定）
BOOL 	SAjxCtrl::SepCtrlH64					(HWND hCtrl, ULL	value, int col )
{
	return		AjcSepCtrlH64(hCtrl, value, col);
}
//		コントロールの設定（チェックボックス）
BOOL	SAjxCtrl::SetCtrlChk					(HWND hCtrl, UI state)
{
	return		AjcSetCtrlChk(hCtrl, state);
}
//	コントロールの設定（文字列, ASCII）
BOOL	SAjxCtrl::SetCtrlStr					(HWND hCtrl, C_BCP pStr)
{
	return		AjcSetCtrlStrA(hCtrl, pStr);
}
//	コントロールの設定（文字列, UNICODE）
BOOL	SAjxCtrl::SetCtrlStr					(HWND hCtrl, C_WCP pStr)
{
	return		AjcSetCtrlStrW(hCtrl, pStr);
}
//	コントロールの設定（書式文字列, ASCII）
BOOL	SAjxCtrl::SetCtrlFStr					(HWND hCtrl, C_BCP pFmt, ...)
{
	va_list 	 vls;
	BC			 txt[1024] = {0};

	va_start(vls, pFmt);
	AjcVSnPrintFA(txt, 1024, pFmt, vls);
	txt[1023] = 0;
	va_end	(vls);
	return		AjcSetCtrlStrA(hCtrl, txt);
}
//	コントロールの設定（書式文字列, ASCII）
BOOL	SAjxCtrl::SetCtrlFStr					(HWND hCtrl, C_WCP pFmt, ...)
{
	va_list 	 vls;
	WC			 txt[1024] = {0};

	va_start(vls, pFmt);
	AjcVSnPrintFW(txt, 1024, pFmt, vls);
	txt[1023] = 0;
	va_end	(vls);
	return		AjcSetCtrlStrW(hCtrl, txt);
}
//	コントロールの設定（エディットコントロールの桁数）
BOOL	SAjxCtrl::SetCtrlEdtLimit				(HWND hCtrl, UI limit, BOOL fUnicode)
{
	BOOL	rc = FALSE;
	if (fUnicode) rc = AjcSetCtrlEdtLimitW(hCtrl, limit);
	else		  rc = AjcSetCtrlEdtLimitA(hCtrl, limit);
	return rc;
}
//	コントロールの設定（コンボボックス・インデクス）
BOOL	SAjxCtrl::SetCtrlCboIx					(HWND hCtrl, UI ix)
{
	return		AjcSetCtrlCboIx(hCtrl, ix);
}
//	コントロールの設定（コンボボックス・項目の文字列, ASCII）
UI		SAjxCtrl::SetCtrlCboAdd					(HWND hCtrl, UI ix, C_BCP pItem, UI flag)
{
	return		AjcSetCtrlCboAddA(hCtrl, ix, pItem, flag);
}
//	コントロールの設定（コンボボックス・項目の文字列, UNICODE）
UI		SAjxCtrl::SetCtrlCboAdd					(HWND hCtrl, UI ix, C_WCP pItem, UI flag)
{
	return		AjcSetCtrlCboAddW(hCtrl, ix, pItem, flag);
}
//	コントロールの設定（コンボボックス・項目挿入, ASCII）
UI		SAjxCtrl::SetCtrlCboIns					(HWND hCtrl, UI ix, C_BCP pItem, UI flag)
{
	return		AjcSetCtrlCboInsA(hCtrl, ix, pItem, flag);
}
//	コントロールの設定（コンボボックス・項目挿入, UNICODE）
UI		SAjxCtrl::SetCtrlCboIns					(HWND hCtrl, UI ix, C_WCP pItem, UI flag)
{
	return		AjcSetCtrlCboInsW(hCtrl, ix, pItem, flag);
}
//	コントロールの設定（コンボボックス・項目削除）
BOOL	SAjxCtrl::SetCtrlCboDel					(HWND hCtrl, UI ix)
{
	return		AjcSetCtrlCboDel(hCtrl, ix);
}
//	コントロールの設定（コンボボックス・データ値）
BOOL	SAjxCtrl::SetCtrlCboData				(HWND hCtrl, UI ix, SX data)
{
	return		AjcSetCtrlCboData(hCtrl, ix, data);
}
//	コントロールの設定（コンボボックス・項目リスト, ASCII）
BOOL	SAjxCtrl::SetCtrlCboList				(HWND hCtrl, C_BCP pList)
{
	return		AjcSetCtrlCboListA(hCtrl, pList);
}
//	コントロールの設定（コンボボックス・項目リスト, UNICODE）
BOOL	SAjxCtrl::SetCtrlCboList				(HWND hCtrl, C_WCP pList)
{
	return		AjcSetCtrlCboListW(hCtrl, pList);
}
//	コントロールの設定（コンボボックス・入力可能文字数）
BOOL	SAjxCtrl::SetCtrlCboLimit				(HWND hCtrl, UI limit, BOOL fUnicode)
{
	BOOL	rc = FALSE;
	if (fUnicode) rc = AjcSetCtrlCboLimitW(hCtrl, limit);
	else		  rc = AjcSetCtrlCboLimitA(hCtrl, limit);
	return rc;
}
//	コントロールの設定（コンボボックス・リセット）
BOOL	SAjxCtrl::SetCtrlCboReset				(HWND hCtrl)
{
	return		AjcSetCtrlCboReset(hCtrl);
}
//	コントロールの設定（プログレスバーのレンジ）
BOOL	SAjxCtrl::SetCtrlPgsRange				(HWND hCtrl, int low, int high)
{
	return		AjcSetCtrlPgsRange(hCtrl, low, high);
}
//	コントロールの設定（プログレスバーの位置）
BOOL	SAjxCtrl::SetCtrlPgsPos					(HWND hCtrl, int pos)
{
	return		AjcSetCtrlPgsPos(hCtrl, pos);
}
//	コントロールの設定（スライダのレンジ）
BOOL	SAjxCtrl::SetCtrlSldRange				(HWND hCtrl, int low, int high, int page)
{
	return		AjcSetCtrlSldRange(hCtrl, low, high, page);
}
//	コントロールの設定（スライダの位置）
BOOL	SAjxCtrl::SetCtrlSldPos					(HWND hCtrl, int pos)
{
	return		AjcSetCtrlSldPos(hCtrl, pos);
}
//	コントロールの設定（スピンボタンのレンジとバディウインド
BOOL	SAjxCtrl::SetCtrlSpnInfo 				(HWND hCtrl, int low, int high, HWND hBuddy)
{
	return		AjcSetCtrlSpnInfo(hCtrl, low, high, hBuddy);
}
//	コントロールの設定（スピンボタンのレンジ
BOOL	SAjxCtrl::SetCtrlSpnRange				(HWND hCtrl, int low, int high)
{
	return		AjcSetCtrlSpnRange(hCtrl, low, high);
}
//	コントロールの設定（スピンボタンのバディウインド
BOOL	SAjxCtrl::SetCtrlSpnBuddy				(HWND hCtrl, HWND hBuddy)
{
	return		AjcSetCtrlSpnBuddy(hCtrl, hBuddy);
}
//	コントロールを兄弟ウインド中で再前面に設定する
HWND	SAjxCtrl::SetCtrlTopMostInSiblings		(HWND hCtrl)
{
	return		AjcSetCtrlTopMostInSiblings(hCtrl);
}
//	コントロールを兄弟ウインド中で再背面に設定する
HWND	SAjxCtrl::SetCtrllBackMostInSiblings	(HWND hCtrl)
{
	return		AjcSetCtrlBackMostInSiblings(hCtrl);
				
}
//	EDITコントロールにフォルダ／ファイルをドロップ可能にする
BOOL	SAjxCtrl::EnableCtrlToDrop				(HWND hCtrl, UI optDrop)
{
	return		AjcEnableCtrlToDrop(hCtrl, optDrop);
}

//----- コントロールのグレィ設定／表示／移動 -----------------------------------------------------------//
//	コントロールの有効化／無効化
BOOL	SAjxCtrl::EnableCtrl					(HWND hCtrl, BOOL fEnable)
{
	return		AjcEnableCtrl(hCtrl, fEnable);
}
//	グループボックス内の全コントロール有効化／無効化
BOOL	SAjxCtrl::EnableGroup					(HWND hCtrl, BOOL fEnaGrpBox, BOOL fEnaCtrls)
{
	return		AjcEnableGroup(hCtrl, fEnaGrpBox, fEnaCtrls);
}
//	グループボックスとグループボックス内の全コントロール表示／非表示
BOOL	SAjxCtrl::ShowGroup						(HWND hCtrl, BOOL fShow)
{
	return		AjcShowGroup(hCtrl, fShow);
}
//	グループボックスやグループボックス内の全コントロール表示／非表示（拡張）
BOOL	SAjxCtrl::ShowGroup						(HWND hCtrl, BOOL fShowGrpBox, BOOL fShowCtrls)
{
	return		AjcShowGroupEx(hCtrl, fShowGrpBox, fShowCtrls);
}
//	グループボックスとグループボックス内の全コントロールを指定位置へ移動
BOOL	SAjxCtrl::MoveGroupToLoc				(HWND hCtrl, int x, int y)
{
	return		AjcMoveGroupToLoc(hCtrl, x, y);
}
//	グループボックスとグループボックス内の全コントロールを指定コントロールの位置へ移動
BOOL	SAjxCtrl::MoveGroupToCtl				(HWND hCtrl, HWND hctl)
{
	return		AjcMoveGroupToCtl(hCtrl, hctl);
}
//	グループボックスとグループボックス内の全コントロールを移動前の位置に戻す
BOOL	SAjxCtrl::MoveGroupToOrg				(HWND hCtrl)
{
	return		AjcMoveGroupToOrg(hCtrl);
}
//----- コントロールの永続化 -----------------------------------------------------------------------------------//
//	全コントロールの永続化属性解除
BOOL	SAjxCtrl::DelAllCtrlPermAtt				(HWND hWnd)
{
	return		AjcDelAllCtrlPermAtt(hWnd);
}
//	全コントロールの設定内容の読み出し(ASCII)
BOOL	SAjxCtrl::LoadAllControlSettings		(HWND hWnd, C_BCP pSect, UI act)
{
	return		AjcLoadAllControlSettingsA(hWnd, pSect, act);
}
//	全コントロールの設定内容の読み出し(UNICODE)
BOOL	SAjxCtrl::LoadAllControlSettings		(HWND hWnd, C_WCP pSect, UI act)
{
	return		AjcLoadAllControlSettingsW(hWnd, pSect, act);
}
//	全コントロールの設定内容の書き込み
BOOL	SAjxCtrl::SaveAllControlSettings		(HWND hWnd)
{
	return		AjcSaveAllControlSettings(hWnd);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
//	各コントロールの永続化属性の設定
BOOL	SAjxCtrl::CtrlSetPermAtt				(HWND hCtrl, UI att)
{
	return AjcCtrlSetPermAtt(hCtrl, att);
}
//	テキストボックスの読み出し(読出専用の動作を指定, ASCII)
BOOL	SAjxCtrl::CtrlLoadTextBox				(HWND hCtrl, C_BCP pSect, BOOL fExcRdOnly)
{
	return		AjcCtrlLoadTextBoxExA(hCtrl, pSect, fExcRdOnly);
}
//	テキストボックスの読み出し(読出専用の動作を指定, UNICODE)
BOOL	SAjxCtrl::CtrlLoadTextBox				(HWND hCtrl, C_WCP pSect, BOOL fExcRdOnly)
{
	return		AjcCtrlLoadTextBoxExW(hCtrl, pSect, fExcRdOnly);
}
//	テキストボックスの書き込み(読出専用の動作を指定, ASCII)
BOOL	SAjxCtrl::CtrlSaveTextBox				(HWND hCtrl, C_BCP pSect, BOOL fExcRdOnly)
{
	return		AjcCtrlSaveTextBoxExA(hCtrl, pSect, fExcRdOnly);
}
//	テキストボックスの書き込み(読出専用の動作を指定, UNICODE)
BOOL	SAjxCtrl::CtrlSaveTextBox				(HWND hCtrl, C_WCP pSect, BOOL fExcRdOnly)
{
	return		AjcCtrlSaveTextBoxExW(hCtrl, pSect, fExcRdOnly);
}
//	チェックボックス／ラジオボタンの読み出し(ASCII)
BOOL	SAjxCtrl::CtrlLoadChkBox					(HWND hCtrl, C_BCP pSect, BOOL fNtc)
{
	return		AjcCtrlLoadChkBoxA(hCtrl, pSect, fNtc);
}
//	チェックボックス／ラジオボタンの読み出し(UNICODE)
BOOL	SAjxCtrl::CtrlLoadChkBox					(HWND hCtrl, C_WCP pSect, BOOL fNtc)
{
	return		AjcCtrlLoadChkBoxW(hCtrl, pSect, fNtc);
}
//	チェックボックス／ラジオボタンの書き込み(ASCII)
BOOL	SAjxCtrl::CtrlSaveChkBox					(HWND hCtrl, C_BCP pSect)
{
	return		AjcCtrlSaveChkBoxA(hCtrl, pSect);
}
//	チェックボックス／ラジオボタンの書き込み(UNICODE)
BOOL	SAjxCtrl::CtrlSaveChkBox					(HWND hCtrl, C_WCP pSect)
{
	return		AjcCtrlSaveChkBoxW(hCtrl, pSect);
}
//	コンボボックスの読み出し(ASCII)
BOOL	SAjxCtrl::CtrlLoadComboBox				(HWND hCtrl, C_BCP pSect, UI sel, BOOL fNtc)
{
	return		AjcCtrlLoadComboBoxA(hCtrl, pSect, sel, fNtc);
}
//	コンボボックスの読み出し(UNICODE)
BOOL	SAjxCtrl::CtrlLoadComboBox				(HWND hCtrl, C_WCP pSect, UI sel, BOOL fNtc)
{
	return		AjcCtrlLoadComboBoxW(hCtrl, pSect, sel, fNtc);
}
//	コンボボックスの書き込み(ASCII)
BOOL	SAjxCtrl::CtrlSaveComboBox				(HWND hCtrl, C_BCP pSect, UI sel)
{
	return		AjcCtrlSaveComboBoxA(hCtrl, pSect, sel);
}
//	コンボボックスの書き込み(UNICODE)
BOOL	SAjxCtrl::CtrlSaveComboBox				(HWND hCtrl, C_WCP pSect, UI sel)
{
	return		AjcCtrlSaveComboBoxW(hCtrl, pSect, sel);
}
//	リストボックスの読み出し(ASCII)
BOOL	SAjxCtrl::CtrlLoadListBox				(HWND hCtrl, C_BCP pSect, UI sel)
{
	return		AjcCtrlLoadListBoxA(hCtrl, pSect, sel);
}
//	リストボックスの読み出し(UNICODE)
BOOL	SAjxCtrl::CtrlLoadListBox				(HWND hCtrl, C_WCP pSect, UI sel)
{
	return		AjcCtrlLoadListBoxW(hCtrl, pSect, sel);
}
//	リストボックスの書き込み(ASCII)
BOOL	SAjxCtrl::CtrlSaveListBox				(HWND hCtrl, C_BCP pSect, UI sel)
{
	return		AjcCtrlSaveListBoxA(hCtrl, pSect, sel);
}
//	リストボックスの書き込み(UNICODE)
BOOL	SAjxCtrl::CtrlSaveListBox				(HWND hCtrl, C_WCP pSect, UI sel)
{
	return		AjcCtrlSaveListBoxW(hCtrl, pSect, sel);
}
