﻿#include	<AjxCpp.h>

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxDlg::CAjxDlg(BOOL fUnicode) 
{
	m_fUnicode = fUnicode;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxDlg::~CAjxDlg()
{
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//----- ハンドル割り当て -------------------------------------------------------------------------------//
VO		CAjxDlg::Attach(HWND hDlg)
{
	m_hDlg = hDlg;
}

//----- ダイアログ項目アクセス -------------------------------------------------------------------------//
//	ダイアログ項目の取得（符号なし整数）
UI		CAjxDlg::GetDlgItemUInt					(int id)
{
	return		AjcGetDlgItemUInt(m_hDlg, id);
}
//	ダイアログ項目の取得（符号付き整数）
SI		CAjxDlg::GetDlgItemSInt					(int id)
{
	return		AjcGetDlgItemSInt(m_hDlg, id);
}
//	ダイアログ項目の取得（１６進整数）
UI		CAjxDlg::GetDlgItemHex					(int id)
{
	return		AjcGetDlgItemHex(m_hDlg, id);
}
//	ダイアログ項目の取得（実数）
double	CAjxDlg::GetDlgItemReal					(int id)
{
	return		AjcGetDlgItemReal(m_hDlg, id);
}
//	ダイアログ項目の取得（符号なし長整数）
ULL		CAjxDlg::GetDlgItemUI64					(int id)
{
	return		AjcGetDlgItemUI64(m_hDlg, id);
}
//	ダイアログ項目の取得（符号なし長整数）
SLL		CAjxDlg::GetDlgItemSI64					(int id)
{
	return		AjcGetDlgItemSI64	(m_hDlg, id);
}
//	ダイアログ項目の取得（１６進長整数）
ULL		CAjxDlg::GetDlgItemH64					(int id)
{
	return		AjcGetDlgItemH64(m_hDlg, id);
}
//	ダイアログ項目の取得（チェックボックス）
UI		CAjxDlg::GetDlgItemChk					(int id)
{
	return		AjcGetDlgItemChk(m_hDlg, id);
}
//	ダイアログ項目の取得（文字列, ASCII）
UI		CAjxDlg::GetDlgItemStr					(int id, BCP   pBuf, UI lBuf)
{
	return		AjcGetDlgItemStrA(m_hDlg, id, pBuf, lBuf);
}
//	ダイアログ項目の取得（文字列,UNICODE）
UI		CAjxDlg::GetDlgItemStr					(int id, WCP   pBuf, UI lBuf)
{
	return		AjcGetDlgItemStrW(m_hDlg, id, pBuf, lBuf);
}
//	ダイアログ項目の取得（文字列長）
UI		CAjxDlg::GetDlgItemStrLen				(int id)
{
	UI		rc = 0;
	if (m_fUnicode) rc = AjcGetDlgItemStrLenW(m_hDlg, id);
	else			rc = AjcGetDlgItemStrLenA(m_hDlg, id);
	return rc;
}
//	ダイアログ項目の取得（スライダの位置）
int	 	CAjxDlg::GetDlgItemSldPos				(int id)
{
	return		AjcGetDlgItemSldPos(m_hDlg, id);
}
//	ダイアログ項目の取得（コンボボックス・インデクス）
UI		CAjxDlg::GetDlgItemCboIx				(int id)
{
	return		AjcGetDlgItemCboIx(m_hDlg, id);
}
//	ダイアログ項目の取得（コンボボックス・項目数）
UI		CAjxDlg::GetDlgItemCboCount				(int id)
{
	return		AjcGetDlgItemCboCount(m_hDlg, id);
}
//	ダイアログ項目の取得（コンボボックス・文字長）
UI		CAjxDlg::GetDlgItemCboLen				(int id, UI ix)
{
	UI		rc = 0;
	if (m_fUnicode) rc = AjcGetDlgItemCboLenW(m_hDlg, id, ix);
	else			rc = AjcGetDlgItemCboLenA(m_hDlg, id, ix);
	return rc;
}
//	ダイアログ項目の取得（コンボボックス・項目の文字列, ASCII）
UI		CAjxDlg::GetDlgItemCboItem				(int id, UI ix, BCP pBuf, UI lBuf)
{
	return		AjcGetDlgItemCboItemA(m_hDlg, id, ix, pBuf, lBuf);
}
//	ダイアログ項目の取得（コンボボックス・項目の文字列, UNICODE）
UI		CAjxDlg::GetDlgItemCboItem				(int id, UI ix, WCP pBuf, UI lBuf)
{
	return		AjcGetDlgItemCboItemW(m_hDlg, id, ix, pBuf, lBuf);
}
//	ダイアログ項目の取得（コンボボックス・データ値）
SX		CAjxDlg::GetDlgItemCboData				(int id, UI ix)
{
	return		AjcGetDlgItemCboData(m_hDlg, id, ix);
}
//	ダイアログ項目の取得（コンボボックス・文字列検索, ASCII）
UI		CAjxDlg::GetDlgItemCboFind				(int id, UI ix, C_BCP pStr, UI flag)
{
	return		AjcGetDlgItemCboFindA(m_hDlg, id, ix, pStr, flag);
}
//	ダイアログ項目の取得（コンボボックス・文字列検索, UNICODE）
UI		CAjxDlg::GetDlgItemCboFind				(int id, UI ix, C_WCP pStr, UI flag)
{
	return		AjcGetDlgItemCboFindW(m_hDlg, id, ix, pStr, flag);
}
//	ダイアログ項目の取得（コンボボックス・項目群のの最大文字列長）
UI		CAjxDlg::GetDlgItemCboMaxLen			(int id)
{
	UI		rc = 0;
	if (m_fUnicode) rc = AjcGetDlgItemCboMaxLenW(m_hDlg, id);
	else			rc = AjcGetDlgItemCboMaxLenA(m_hDlg, id);
	return rc;
}
//	ダイアログ項目の設定（符号なし整数）
BOOL	CAjxDlg::SetDlgItemUInt					(int id, UI 	value)
{
	return		AjcSetDlgItemUInt(m_hDlg, id, value);
}
//	ダイアログ項目の設定（符号付き整数）
BOOL 	CAjxDlg::SetDlgItemSInt					(int id, SI 	value)
{
	return		AjcSetDlgItemSInt(m_hDlg, id, value);
}
//	ダイアログ項目の設定（１６進整数）
BOOL 	CAjxDlg::SetDlgItemHex					(int id, UI 	value)
{
	return		AjcSetDlgItemHex(m_hDlg, id, value);
}
//	ダイアログ項目の設定（実数）
BOOL 	CAjxDlg::SetDlgItemReal					(int id, double value, int prec)
{
	return		AjcSetDlgItemReal(m_hDlg, id, value, prec);
}
//	ダイアログ項目の設定（符号なし長整数）
BOOL 	CAjxDlg::SetDlgItemUI64					(int id, ULL	value)
{
	return		AjcSetDlgItemUI64(m_hDlg, id, value);
}
//	ダイアログ項目の設定（符号付き長整数）
BOOL 	CAjxDlg::SetDlgItemSI64					(int id, SLL	value)
{
	return		AjcSetDlgItemSI64(m_hDlg, id, value);
}
//	ダイアログ項目の設定（１６進長整数）
BOOL 	CAjxDlg::SetDlgItemH64					(int id, ULL	value)
{
	return		AjcSetDlgItemH64(m_hDlg, id, value);
}
//	ダイアログ項目の設定（符号なし整数，  ３桁区切り）
BOOL 	CAjxDlg::SepDlgItemUInt					(int id, UI 	value)
{
	return		AjcSepDlgItemUInt(m_hDlg,id, value );
}
//	ダイアログ項目の設定（符号付き整数，  ３桁区切り）
BOOL 	CAjxDlg::SepDlgItemSInt					(int id, SI 	value)
{
	return		AjcSepDlgItemSInt(m_hDlg, id, value);
}
//	ダイアログ項目の設定（１６進整数  ，  桁数指定）
BOOL 	CAjxDlg::SepDlgItemHex					(int id, UI 	value, int col )
{
	return		AjcSepDlgItemHex(m_hDlg, id, value, col);
}
//	ダイアログ項目の設定（実数，		  ３桁区切り）
BOOL 	CAjxDlg::SepDlgItemReal					(int id, double value, int prec)
{
	return		AjcSepDlgItemReal(m_hDlg, id, value, prec);
}
//	ダイアログ項目の設定（符号なし長整数，３桁区切り）
BOOL 	CAjxDlg::SepDlgItemUI64					(int id, ULL	value)
{
	return		AjcSepDlgItemUI64(m_hDlg, id, value);
}
//	ダイアログ項目の設定（符号付き長整数，３桁区切り）
BOOL 	CAjxDlg::SepDlgItemSI64					(int id, SLL	value)
{
	return		AjcSepDlgItemSI64(m_hDlg, id, value);
}
//	ダイアログ項目の設定（１６進長整数	，桁数指定）
BOOL 	CAjxDlg::SepDlgItemH64					(int id, ULL	value, int col )
{
	return		AjcSepDlgItemH64(m_hDlg, id, value, col);
}
//		ダイアログ項目の設定（チェックボックス）
BOOL	CAjxDlg::SetDlgItemChk					(int id, UI state)
{
	return		AjcSetDlgItemChk(m_hDlg, id, state);
}
//	ダイアログ項目の設定（ラジオボタン）
BOOL	CAjxDlg::SetDlgItemRbt					(int id, int idFirst, int idLast)
{
	return		AjcSetDlgItemRbt(m_hDlg, id, idFirst, idLast);
}
//	ダイアログ項目の設定（文字列, ASCII）
BOOL	CAjxDlg::SetDlgItemStr					(int id, C_BCP pStr)
{
	return		AjcSetDlgItemStrA(m_hDlg, id, pStr);
}
//	ダイアログ項目の設定（文字列, UNICODE）
BOOL	CAjxDlg::SetDlgItemStr					(int id, C_WCP pStr)
{
	return		AjcSetDlgItemStrW(m_hDlg, id, pStr);
}
//	ダイアログ項目の設定（書式文字列, ASCII）
BOOL	CAjxDlg::SetDlgItemFStr					(int id, C_BCP pFmt, ...)
{
	va_list 	 vls;
	BC			 txt[1024] = {0};

	va_start(vls, pFmt);
	AjcVSnPrintFA(txt, 1024, pFmt, vls);
	txt[1023] = 0;
	va_end	(vls);
	return		AjcSetDlgItemStrA(m_hDlg, id, txt);
}
//	ダイアログ項目の設定（書式文字列, ASCII）
BOOL	CAjxDlg::SetDlgItemFStr					(int id, C_WCP pFmt, ...)
{
	va_list 	 vls;
	WC			 txt[1024] = {0};

	va_start(vls, pFmt);
	AjcVSnPrintFW(txt, 1024, pFmt, vls);
	txt[1023] = 0;
	va_end	(vls);
	return		AjcSetDlgItemStrW(m_hDlg, id, txt);
}
//	ダイアログ項目の設定（エディットコントロールの桁数）
BOOL	CAjxDlg::SetDlgItemEdtLimit			(int id, UI limit)
{
	BOOL	rc = FALSE;
	if (m_fUnicode) rc = AjcSetDlgItemEdtLimitW(m_hDlg, id, limit);
	else			rc = AjcSetDlgItemEdtLimitA(m_hDlg, id, limit);
	return rc;
}
//	ダイアログ項目の設定（コンボボックス・インデクス）
BOOL	CAjxDlg::SetDlgItemCboIx				(int id, UI ix)
{
	return		AjcSetDlgItemCboIx(m_hDlg, id, ix);
}
//	ダイアログ項目の設定（コンボボックス・項目の文字列, ASCII）
UI		CAjxDlg::SetDlgItemCboAdd				(int id, UI ix, C_BCP pItem, UI flag)
{
	return		AjcSetDlgItemCboAddA(m_hDlg, id, ix, pItem, flag);
}
//	ダイアログ項目の設定（コンボボックス・項目の文字列, UNICODE）
UI		CAjxDlg::SetDlgItemCboAdd				(int id, UI ix, C_WCP pItem, UI flag)
{
	return		AjcSetDlgItemCboAddW(m_hDlg, id, ix, pItem, flag);
}
//	ダイアログ項目の設定（コンボボックス・項目挿入, ASCII）
UI		CAjxDlg::SetDlgItemCboIns				(int id, UI ix, C_BCP pItem, UI flag)
{
	return		AjcSetDlgItemCboInsA(m_hDlg, id, ix, pItem, flag);
}
//	ダイアログ項目の設定（コンボボックス・項目挿入, UNICODE）
UI		CAjxDlg::SetDlgItemCboIns				(int id, UI ix, C_WCP pItem, UI flag)
{
	return		AjcSetDlgItemCboInsW(m_hDlg, id, ix, pItem, flag);
}
//	ダイアログ項目の設定（コンボボックス・項目削除）
BOOL	CAjxDlg::SetDlgItemCboDel				(int id, UI ix)
{
	return		AjcSetDlgItemCboDel(m_hDlg, id, ix);
}
//	ダイアログ項目の設定（コンボボックス・データ値）
BOOL	CAjxDlg::SetDlgItemCboData				(int id, UI ix, SX data)
{
	return		AjcSetDlgItemCboData(m_hDlg, id, ix, data);
}
//	ダイアログ項目の設定（コンボボックス・項目リスト, ASCII）
BOOL	CAjxDlg::SetDlgItemCboList				(int id, C_BCP pList)
{
	return		AjcSetDlgItemCboListA(m_hDlg, id, pList);
}
//	ダイアログ項目の設定（コンボボックス・項目リスト, UNICODE）
BOOL	CAjxDlg::SetDlgItemCboList				(int id, C_WCP pList)
{
	return		AjcSetDlgItemCboListW(m_hDlg, id, pList);
}
//	ダイアログ項目の設定（コンボボックス・入力可能文字数）
BOOL	CAjxDlg::SetDlgItemCboLimit			(int id, UI limit)
{
	BOOL	rc = FALSE;
	if (m_fUnicode) rc = AjcSetDlgItemCboLimitW(m_hDlg, id, limit);
	else			rc = AjcSetDlgItemCboLimitA(m_hDlg, id, limit);
	return rc;
}
//	ダイアログ項目の設定（コンボボックス・リセット）
BOOL	CAjxDlg::SetDlgItemCboReset				(int id)
{
	return		AjcSetDlgItemCboReset(m_hDlg, id);
}
//	ダイアログ項目の設定（プログレスバーのレンジ）
BOOL	CAjxDlg::SetDlgItemPgsRange				(int id, int low, int high)
{
	return		AjcSetDlgItemPgsRange(m_hDlg, id, low, high);
}
//	ダイアログ項目の設定（プログレスバーの位置）
BOOL	CAjxDlg::SetDlgItemPgsPos				(int id, int pos)
{
	return		AjcSetDlgItemPgsPos(m_hDlg, id, pos);
}
//	ダイアログ項目の設定（スライダのレンジ）
BOOL	CAjxDlg::SetDlgItemSldRange				(int id, int low, int high, int page)
{
	return		AjcSetDlgItemSldRange(m_hDlg, id, low, high, page);
}
//	ダイアログ項目の設定（スライダの位置）
BOOL	CAjxDlg::SetDlgItemSldPos				(int id, int pos)
{
	return		AjcSetDlgItemSldPos(m_hDlg, id, pos);
}
//	ダイアログ項目の設定（スピンボタンのレンジとバディウインド
BOOL	CAjxDlg::SetDlgItemSpnInfo 				(int id, int low, int high, int idBuddy)
{
	return		AjcSetDlgItemSpnInfo(m_hDlg, id, low, high, idBuddy);
}
//	ダイアログ項目の設定（スピンボタンのレンジ
BOOL	CAjxDlg::SetDlgItemSpnRange				(int id, int low, int high)
{
	return		AjcSetDlgItemSpnRange(m_hDlg, id, low, high);
}
//	ダイアログ項目の設定（スピンボタンのバディウインド
BOOL	CAjxDlg::SetDlgItemSpnBuddy				(int id, int idBuddy)
{
	return		AjcSetDlgItemSpnBuddy(m_hDlg, id, idBuddy);
}
//	コントロールを兄弟ウインド中で再前面に設定する
HWND	CAjxDlg::SetDlgItemTopMostInSiblings	(int id)
{
	return		AjcSetDlgItemTopMostInSiblings(m_hDlg, id);
}
//	コントロールを兄弟ウインド中で再背面に設定する
HWND	CAjxDlg::SetDlgItemlBackMostInSiblings	(int id)
{
	return		AjcSetDlgItemBackMostInSiblings(m_hDlg, id);
}
//	EDITコントロールにフォルダ／ファイルをドロップ可能にする
BOOL	CAjxDlg::EnableDlgItemToDrop			(int id, UI optDrop)
{
	return		AjcEnableDlgItemToDrop(m_hDlg, id, optDrop);
}

//----- コントロールのグレィ設定／表示／移動 -----------------------------------------------------------//
//	ダイアログ項目の有効化／無効化
BOOL	CAjxDlg::EnableDlgItem					(int id	, BOOL fEnable)
{
	return		AjcEnableDlgItem(m_hDlg, id, fEnable);
}
//	グループボックス内の全コントロール有効化／無効化
BOOL	CAjxDlg::EnableDlgGroup					(int idGrp, BOOL fEnaGrpBox, BOOL fEnaCtrls)
{
	return		AjcEnableDlgGroup(m_hDlg, idGrp, fEnaGrpBox, fEnaCtrls);
}
//	グループボックスとグループボックス内の全コントロール表示／非表示
BOOL	CAjxDlg::ShowDlgGroup					(int idGrp, BOOL fShow)
{
	return		AjcShowDlgGroup(m_hDlg, idGrp, fShow);
}
//	グループボックスやグループボックス内の全コントロール表示／非表示（拡張）
BOOL	CAjxDlg::ShowDlgGroup					(int idGrp, BOOL fShowGrpBox, BOOL fShowCtrls)
{
	return		AjcShowDlgGroupEx(m_hDlg, idGrp, fShowGrpBox, fShowCtrls);
}
//	グループボックスとグループボックス内の全コントロールを指定位置へ移動
BOOL	CAjxDlg::MoveDlgGroupToLoc				(int idGrp, int x, int y)
{
	return		AjcMoveDlgGroupToLoc(m_hDlg, idGrp, x, y);
}
//	グループボックスとグループボックス内の全コントロールを指定コントロールのへ移動
BOOL	CAjxDlg::MoveDlgGroupToCtl				(int idGrp, int idCtl)
{
	return		AjcMoveDlgGroupToCtl(m_hDlg, idGrp, idCtl);
}
//	グループボックスとグループボックス内の全コントロールを移動前の位置に戻す
BOOL	CAjxDlg::MoveDlgGroupToOrg				(int idGrp)
{
	return		AjcMoveDlgGroupToOrg(m_hDlg, idGrp);
}
//----- ダイアログ項目の永続化 -------------------------------------------------------------------------//
//	全コントロールの永続化属性解除
BOOL	CAjxDlg::DelAllCtrlPermAtt				()
{
	return		AjcDelAllCtrlPermAtt(m_hDlg);
}
//	全コントロールの設定内容の読み出し(ASCII)
BOOL	CAjxDlg::LoadAllControlSettings			(C_BCP pSect, UI act)
{
	return		AjcLoadAllControlSettingsA(m_hDlg, pSect, act);
}
//	全コントロールの設定内容の読み出し(UNICODE)
BOOL	CAjxDlg::LoadAllControlSettings			(C_WCP pSect, UI act)
{
	return		AjcLoadAllControlSettingsW(m_hDlg, pSect, act);
}
//	全コントロールの設定内容の書き込み
BOOL	CAjxDlg::SaveAllControlSettings			()
{
	return		AjcSaveAllControlSettings(m_hDlg);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
//	各コントロールの永続化属性の設定
BOOL	CAjxDlg::DlgItemSetPermAtt				(UI id, UI att)
{
	return		AjcDlgItemSetPermAtt(m_hDlg, id, att);
}
//	テキストボックスの読み出し(読出専用の動作を指定, ASCII)
BOOL	CAjxDlg::DlgItemLoadTextBox				(UI id, C_BCP pSect, BOOL fExcRdOnly)
{
	return		AjcDlgItemLoadTextBoxExA(m_hDlg, id, pSect, fExcRdOnly);
}
//	テキストボックスの読み出し(読出専用の動作を指定, UNICODE)
BOOL	CAjxDlg::DlgItemLoadTextBox				(UI id, C_WCP pSect, BOOL fExcRdOnly)
{
	return		AjcDlgItemLoadTextBoxExW(m_hDlg, id, pSect, fExcRdOnly);
}
//	テキストボックスの書き込み(読出専用の動作を指定, ASCII)
BOOL	CAjxDlg::DlgItemSaveTextBox				(UI id, C_BCP pSect, BOOL fExcRdOnly)
{
	return		AjcDlgItemSaveTextBoxExA(m_hDlg, id, pSect, fExcRdOnly);
}
//	テキストボックスの書き込み(読出専用の動作を指定, UNICODE)
BOOL	CAjxDlg::DlgItemSaveTextBox				(UI id, C_WCP pSect, BOOL fExcRdOnly)
{
	return		AjcDlgItemSaveTextBoxExW(m_hDlg, id, pSect, fExcRdOnly);
}
//	チェックボックス／ラジオボタンの読み出し(ASCII)
BOOL	CAjxDlg::DlgItemLoadChkBox				(UI id, C_BCP pSect, BOOL fNtc)
{
	return		AjcDlgItemLoadChkBoxA(m_hDlg, id, pSect, fNtc);
}
//	チェックボックス／ラジオボタンの読み出し(UNICODE)
BOOL	CAjxDlg::DlgItemLoadChkBox				(UI id, C_WCP pSect, BOOL fNtc)
{
	return		AjcDlgItemLoadChkBoxW(m_hDlg, id, pSect, fNtc);
}
//	チェックボックス／ラジオボタンの書き込み(ASCII)
BOOL	CAjxDlg::DlgItemSaveChkBox				(UI id, C_BCP pSect)
{
	return		AjcDlgItemSaveChkBoxA(m_hDlg, id, pSect);
}
//	チェックボックス／ラジオボタンの書き込み(UNICODE)
BOOL	CAjxDlg::DlgItemSaveChkBox				(UI id, C_WCP pSect)
{
	return		AjcDlgItemSaveChkBoxW(m_hDlg, id, pSect);
}
//	コンボボックスの読み出し(ASCII)
BOOL	CAjxDlg::DlgItemLoadComboBox			(UI id, C_BCP pSect, UI sel, BOOL fNtc)
{
	return		AjcDlgItemLoadComboBoxA(m_hDlg, id, pSect, sel, fNtc);
}
//	コンボボックスの読み出し(UNICODE)
BOOL	CAjxDlg::DlgItemLoadComboBox			(UI id, C_WCP pSect, UI sel, BOOL fNtc)
{
	return		AjcDlgItemLoadComboBoxW(m_hDlg, id, pSect, sel, fNtc);
}
//	コンボボックスの書き込み(ASCII)
BOOL	CAjxDlg::DlgItemSaveComboBox			(UI id, C_BCP pSect, UI sel)
{
	return		AjcDlgItemSaveComboBoxA(m_hDlg, id, pSect, sel);
}
//	コンボボックスの書き込み(UNICODE)
BOOL	CAjxDlg::DlgItemSaveComboBox			(UI id, C_WCP pSect, UI sel)
{
	return		AjcDlgItemSaveComboBoxW(m_hDlg, id, pSect, sel);
}
//	リストボックスの読み出し(ASCII)
BOOL	CAjxDlg::DlgItemLoadListBox				(UI id, C_BCP pSect, UI sel)
{
	return		AjcDlgItemLoadListBoxA(m_hDlg, id, pSect, sel);
}
//	リストボックスの読み出し(UNICODE)
BOOL	CAjxDlg::DlgItemLoadListBox				(UI id, C_WCP pSect, UI sel)
{
	return		AjcDlgItemLoadListBoxW(m_hDlg, id, pSect, sel);
}
//	リストボックスの書き込み(ASCII)
BOOL	CAjxDlg::DlgItemSaveListBox				(UI id, C_BCP pSect, UI sel)
{
	return		AjcDlgItemSaveListBoxA(m_hDlg, id, pSect, sel);
}
//	リストボックスの書き込み(UNICODE)
BOOL	CAjxDlg::DlgItemSaveListBox				(UI id, C_WCP pSect, UI sel)
{
	return		AjcDlgItemSaveListBoxW(m_hDlg, id, pSect, sel);
}

