﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxFile::CAjxFile(BOOL fUnicode) 
{
	m_BufLen   = 1024;
	m_hFile    = NULL;
	m_fUnicode = fUnicode;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxFile::~CAjxFile()
{
	if (m_hFile != NULL) {
		AjcFClose(m_hFile);
	}
}

//----- テキストファイル入力 -----------------------------------------------------------------------------------//
//	入力テキストファイルオープン(ASCII)
BOOL		CAjxFile::FOpen	(C_BCP pPath, EAJCTEC tec)
{
	BOOL	rc = FALSE;
	if (m_hFile == NULL) {
		rc = ((m_hFile = AjcFOpenA(pPath, tec)) != NULL);
	}
	return rc;
}
//	入力テキストファイルオープン(ASCII, 共有設定)
BOOL		CAjxFile::FOpenShare(C_BCP pPath, EAJCTEC tec, UI share)
{
	BOOL	rc = FALSE;
	if (m_hFile == NULL) {
		rc = ((m_hFile = AjcFOpenShareA(pPath, tec, share)) != NULL);
	}
	return rc;
}
//	入力テキストファイルオープン(UNICODE)
BOOL		CAjxFile::FOpen	(C_WCP pPath, EAJCTEC tec)
{
	BOOL	rc = FALSE;
	if (m_hFile == NULL) {
		rc = ((m_hFile = AjcFOpenW(pPath, tec)) != NULL);
	}
	return rc;
}
//	入力テキストファイルオープン(UNICODE, 共有設定)
BOOL		CAjxFile::FOpenShare(C_WCP pPath, EAJCTEC tec, UI share)
{
	BOOL	rc = FALSE;
	if (m_hFile == NULL) {
		rc = ((m_hFile = AjcFOpenShareW(pPath, tec, share)) != NULL);
	}
	return rc;
}
//	オープン済ファイルのハンドルを使用してインスタンス生成
BOOL		CAjxFile::FAttachOpened(HANDLE hFile, EAJCTEC tec)
{
	BOOL	rc = FALSE;
	if (m_hFile == NULL) {
		rc = ((m_hFile = AjcFAttachOpened(hFile, tec)) != NULL);
	}
	return rc;
}

//	文字列入力(ASCII)
BCP			CAjxFile::FGetS	(BCP pBuf, UI lBuf)
{
	return AjcFGetSA(m_hFile, pBuf, lBuf);
}
//	文字列入力(UNICODE)
WCP			CAjxFile::FGetS	(WCP pBuf, UI lBuf)
{
	return AjcFGetSW(m_hFile, pBuf, lBuf);
}
//	１文字入力(UNICODE/ASCII兼用)
UI			CAjxFile::FGetC()
{
	UI	rc = 0;
	if (m_fUnicode) rc = (UI)FGetCW();
	else			rc = (UI)FGetCA();
	return rc;
}
//	１文字入力(ASCII)
BC			CAjxFile::FGetCA()
{
	return AjcFGetCA(m_hFile);
}
//	１文字入力(UNICODE)
WC			CAjxFile::FGetCW()
{
	return AjcFGetCW(m_hFile);
}
//	ファイル読み出しポイント退避(UNICODE/ASCII兼用)
ULL			CAjxFile::FSavePoint()
{
	ULL		rc;
	if (m_fUnicode) rc = AjcFSavePointW(m_hFile);
	else			rc = AjcFSavePointA(m_hFile);
	return rc;
}
//	ファイル読み出しポイント回復
BOOL		CAjxFile::FRecvPoint()
{
	return AjcFRecvPoint(m_hFile);
}
//	入力ファイルのＥＯＦチェック
BOOL		CAjxFile::FEof	()
{
	return AjcFEof(m_hFile);
}


//----- テキストファイル出力 -----------------------------------------------------------------------------------//
//	出力テキストファイル生成(ASCII)
BOOL		CAjxFile::FCreate	(C_BCP pPath, EAJCTEC tec, BOOL fBOM)
{
	return ((m_hFile = AjcFCreateA(pPath, tec, fBOM)) != NULL);
}
//	出力テキストファイル生成(ASCII, 共有設定)
BOOL		CAjxFile::FCreateShare(C_BCP pPath, EAJCTEC tec, BOOL fBOM, UI share)
{
	return ((m_hFile = AjcFCreateShareA(pPath, tec, fBOM, share)) != NULL);
}
//	出力テキストファイル生成(UNICODE)
BOOL		CAjxFile::FCreate	(C_WCP pPath, EAJCTEC tec, BOOL fBOM)
{
	return ((m_hFile = AjcFCreateW(pPath, tec, fBOM)) != NULL);
}
//	出力テキストファイル生成(UNICODE, 共有設定)
BOOL		CAjxFile::FCreateShare(C_WCP pPath, EAJCTEC tec, BOOL fBOM, UI share)
{
	return ((m_hFile = AjcFCreateShareW(pPath, tec, fBOM, share)) != NULL);
}
//	出力テキストファイル追記(ASCII)
BOOL		CAjxFile::FAppend	(C_BCP pPath, EAJCTEC tec, BOOL fBOM)
{
	return ((m_hFile = AjcFAppendA(pPath, tec, fBOM)) != NULL);
}
//	出力テキストファイル追記(ASCII, 共有設定)
BOOL		CAjxFile::FAppendShare(C_BCP pPath, EAJCTEC tec, BOOL fBOM, UI share)
{
	return ((m_hFile = AjcFAppendShareA(pPath, tec, fBOM, share)) != NULL);
}
//	出力テキストファイル追記(UNICODE)
BOOL		CAjxFile::FAppend	(C_WCP pPath, EAJCTEC tec, BOOL fBOM)
{
	return ((m_hFile = AjcFAppendW(pPath, tec, fBOM)) != NULL);
}
//	出力テキストファイル追記(UNICODE, 共有設定)
BOOL		CAjxFile::FAppendShare(C_WCP pPath, EAJCTEC tec, BOOL fBOM, UI share)
{
	return ((m_hFile = AjcFAppendShareW(pPath, tec, fBOM, share)) != NULL);
}
//	生成済ファイルのハンドルを使用してインスタンス生成
BOOL		CAjxFile::FAttachCreated(HANDLE hFile, EAJCTEC tec, BOOL fBOM)
{
	BOOL	rc = FALSE;
	if (m_hFile == NULL) {
		rc = ((m_hFile = AjcFAttachCreated(hFile, tec, fBOM)) != NULL);
	}
	return rc;
}

//	文字列出力(ASCII)
BOOL		CAjxFile::FPutS	(C_BCP pText, UI lText)
{
	return AjcFPutSA(m_hFile, pText, lText);
}
//	文字列出力(UNICODE)
BOOL		CAjxFile::FPutS	(C_WCP pText, UI lText)
{
	return AjcFPutSW(m_hFile, pText, lText);
}
//	１文字出力(ASCII)
BOOL		CAjxFile::FPutC(BC c)
{
	return AjcFPutCA(m_hFile, c);
}
//	１文字出力(UNICODE)
BOOL		CAjxFile::FPutC	(WC c)
{
	return AjcFPutCW(m_hFile, c);
}
//	書式文字列出力(ASCII)
BOOL		CAjxFile::FPrintF	(C_BCP pFmt, ...)
{
	int		rc = 0;
	va_list vls;

	//	書式文字列出力
	va_start(vls, pFmt);
	rc = AjcFVPrintFA(m_hFile, pFmt, vls);
	va_end	(vls);
	return rc;
}
//	書式文字列出力(UNICODE)
BOOL		CAjxFile::FPrintF	(C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;

	//	書式文字列出力
	va_start(vls, pFmt);
	rc = AjcFVPrintFW(m_hFile, pFmt, vls);
	va_end	(vls);
	return rc;
}

//	書式文字列出力(可変個パラメタのポインタ指定, ASCII)
BOOL		CAjxFile::FVPrintF	(C_BCP pFmt, va_list vls)
{
	int		rc = FALSE;

	rc = AjcFVPrintFA(m_hFile, pFmt, vls);
	return rc;
}
//	書式文字列出力(可変個パラメタのポインタ指定, UNICODE)
BOOL		CAjxFile::FVPrintF	(C_WCP pFmt, va_list vls)
{
	int		rc = FALSE;

	rc = AjcFVPrintFW(m_hFile, pFmt, vls);
	return rc;
}

//	テキスト出力ファイルのフラッシュ
BOOL		CAjxFile::FFlush	()
{
	int		rc = FALSE;

	rc = AjcFFlush(m_hFile);
	return rc;
}

//----- その他 -------------------------------------------------------------------------------------------------//
//	テキストファイルクローズ
BOOL		CAjxFile::FClose	()
{
	BOOL	rc = FALSE;

	if (m_hFile != NULL) {
		rc = AjcFClose(m_hFile);
		m_hFile = NULL;
	}
	return rc;
}
//	テキストファイルをクローズしないでインスタンス解放	
BOOL		CAjxFile::FDetach()
{
	BOOL	rc = FALSE;
	if (AjcFDetach(m_hFile)) {
		m_hFile = NULL;
		rc = TRUE;
	}
	return rc;
}

//	テキストエンコード種別取得
EAJCTEC		CAjxFile::FGetTec	()
{
	return AjcFGetTec(m_hFile);
}
//	入力ファイルのＢＯＭ有無の取得
BOOL		CAjxFile::FGetBOM()
{
	return AjcFGetBOM(m_hFile);
}
//	ファイルオープン／生成状態かチェック
BOOL		CAjxFile::FIsActive()
{
	return (m_hFile != NULL);
}
//	入出力モード取得
BOOL		CAjxFile::FIsModeInput()
{
	return AjcFIsModeInput(m_hFile);
}
//	書式文字列バッファ長設定
BOOL		CAjxFile::FSetFmtLen	(UI len)
{
	BOOL	rc = FALSE;
	rc = AjcFSetFmtLen(m_hFile, len);
	return rc;
}
//	ファイルハンドル取得
HANDLE		CAjxFile::FGetFileHandle()
{
	return AjcFGetFileHandle(m_hFile);
}
