﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ファイル／ディレクトリ通知）																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 --------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbFindA (UI nest, BCP pPath, BCP pName, UI attrib, UI wtime, UX cbp)
{
	BOOL	rc = FALSE;
	CAjxFsr*	p = (CAjxFsr*)cbp;
	if (nest == -1) {
		rc = p->OnFindDir (pPath);
	}
	else {
		rc = p->OnFindFile(nest, pPath, pName, attrib, wtime);
	}
	return rc;
}
//----- ワイド文字 --------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbFindW (UI nest, WCP pPath, WCP pName, UI attrib, UI wtime, UX cbp)
{
	BOOL	rc = FALSE;
	CAjxFsr*	p = (CAjxFsr*)cbp;
	if (nest == -1) {
		rc = p->OnFindDir (pPath);
	}
	else {
		rc = p->OnFindFile(nest, pPath, pName, attrib, wtime);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxFsr::CAjxFsr() 
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxFsr::~CAjxFsr()
{
}

//	ファイル／ディレクトリ検索(ASCII)
int		CAjxFsr::SearchFiles(C_BCP pDir, C_BCP pWild, BOOL fSubDir, BOOL fNtcDir)
{
	return AjcSearchFilesExA(pDir, pWild, fSubDir, fNtcDir, (UX)this, cbFindA);
}
//	ファイル／ディレクトリ検索(UNICODE)
int		CAjxFsr::SearchFiles(C_WCP pDir, C_WCP pWild, BOOL fSubDir, BOOL fNtcDir)
{
	return AjcSearchFilesExW(pDir, pWild, fSubDir, fNtcDir, (UX)this, cbFindW);
}
//	マイコンピュータ検索(ASCII)
int		CAjxFsr::SearchMyComputer(C_BCP pPath, C_BCP pWild, BOOL fRemote, BOOL fNtcDir)
{
	return AjcSearchMyComputerExA(pPath, pWild, fRemote, fNtcDir, (UX)this, cbFindA);
}
//	マイコンピュータ検索(UNICODE)
int		CAjxFsr::SearchMyComputer(C_WCP pPath, C_WCP pWild, BOOL fRemote, BOOL fNtcDir)
{
	return AjcSearchMyComputerExW(pPath, pWild, fRemote, fNtcDir, (UX)this, cbFindW);
}


//----- 仮想関数 ---------------------------------------------------------------------------------------//
//	ディレクトリ通知(ASCII)
BOOL	CAjxFsr::OnFindDir	(BCP pPath)
{
	return TRUE;
}
//	ディレクトリ通知(UNICODE)
BOOL	CAjxFsr::OnFindDir	(WCP pPath)
{
	return TRUE;
}
//	ファイル通知(ASCII)
BOOL	CAjxFsr::OnFindFile	(UI nest, BCP pPath, BCP pName, UI att, UI wtime)
{
	return FALSE;
}
//	ファイル通知(UNICODE)
BOOL	CAjxFsr::OnFindFile	(UI nest, WCP pPath, WCP pName, UI att, UI wtime)
{
	return FALSE;
}
