﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcG2dSubClassed_"
#define	PROP_NAME_CTRL		"_AjcG2dWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_G2D, WM_COMMAND			)
{
	CAjxG2d*	p = (CAjxG2d*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);

	if (p != NULL) {
		switch (HIWORD(wParam)) {
			case AJC3DGN_PLOTLIST:	p->OnNtcPlotList(AjcG3dGetNtcList	  ((HWND)lParam));	break;	//	プロットリスト通知
			case AJC3DGN_CLEAR:		p->OnNtcClear	(AjcG3dGetNtcClrFact  ((HWND)lParam));	break;	//	データクリアー通知
			case AJC3DGN_DBLCLK:	p->OnNtcDblClk	();										break;	//	ダブルクリック通知
			case AJC3DGN_DROPFILE:	p->OnNtcDropFile(AjcG3dGetNtcFiles	  ((HWND)lParam));	break;	//	ファイルドロップ通知
			case AJC3DGN_DROPDIR:	p->OnNtcDropDir (AjcG3dGetNtcDirs	  ((HWND)lParam));	break;	//	フォルダドロップ通知
			case AJC3DGN_RCLICK:	p->OnNtcRClick	(AjcG3dGetNtcRClk	  ((HWND)lParam));	break;	//	右クリック通知
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_G2D);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_G2D, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_G2D);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_G2D)
	AJC_WNDMAP_MSG(SBC_G2D, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_G2D, WM_DESTROY	   )
AJC_WNDMAP_END


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxG2d::CAjxG2d() 
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxG2d::~CAjxG2d()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ２Ｄファンクション -----------------------------------------------------------------------------//
//	２Ｄグラフモード初期化
BOOL	CAjxG2d::Init			(double x1, double y1, double x2, double y2, UI style)
{
	return AjcG2dInit			(m_hCtrl, x1, y1, x2, y2, style);
}
//	２Ｄグラフモード初期化（ベクトル指定）
BOOL	CAjxG2d::Init			(PCAJC2DVEC pLo, PCAJC2DVEC pHi, UI style)
{
	return AjcG2dInitV			(m_hCtrl, pLo, pHi, style);
}
//	平面アングル設定
BOOL	CAjxG2d::SetPlane 	(AJCG2DAXIS_DIR HoriAxis, AJCG2DAXIS_DIR VertAxis)
{
	return AjcG2dSetPlane		(m_hCtrl, HoriAxis, VertAxis);
}
//	プロパティ設定
BOOL	CAjxG2d::SetProp		(PCAJC2DGPROP pProp)
{
	return AjcG2dSetProp		(m_hCtrl, pProp);
}
//	プロパティ取得
BOOL	CAjxG2d::GetProp		(PAJC2DGPROP  pBuf)
{
	return AjcG2dGetProp		(m_hCtrl, pBuf);
}
//	レンジ自動調整
BOOL	CAjxG2d::AdjustRange	()
{
	return AjcG2dAdjustRange	(m_hCtrl);
}
//	各軸のレンジ設定
BOOL	CAjxG2d::SetRange		(double x1, double y1, double x2, double y2)
{
	return AjcG2dSetRange		(m_hCtrl, x1, y1, x2, y2);
}
//	各軸の中心位置設定
BOOL	CAjxG2d::SetCenter	(double xc, double yc)
{
	return AjcG2dSetCenter		(m_hCtrl, xc, yc);
}
//	各軸の幅（半径）設定
BOOL	CAjxG2d::SetWidth		(double xr, double yr)
{
	return AjcG2dSetWidth		(m_hCtrl, xr, yr);
}
//	各軸のレンジ幅を同じにする
BOOL	CAjxG2d::SetSameRangeWidth()
{
	return AjcG2dSetSameRangeWidth(m_hCtrl);
}
//	レンジ設定された領域のアスペクトを１にする
BOOL	CAjxG2d::SetFixedAspect(BOOL fFixed)
{
	return AjcG2dSetFixedAspect	(m_hCtrl, fFixed);
}
//	表示色設定
BOOL	CAjxG2d::SetColor		(UI id, COLORREF rgb)
{
	return AjcG2dSetColor		(m_hCtrl, id, rgb);
}
//	プロットデータ数設定
BOOL	CAjxG2d::SetPlotNumber(UI id, UI PlotNumber)
{
	return AjcG2dSetPlotNumber	(m_hCtrl, id, PlotNumber);
}
//	プロットデータのピクセルサイズ設定
BOOL	CAjxG2d::SetPlotSize	(UI id, UI PixelSize, UI PixelSizeE)
{
	return AjcG2dSetPlotSize	(m_hCtrl, id, PixelSize, PixelSizeE);
}
//	プロットデータ投与
BOOL	CAjxG2d::PutPlotData	(UI id, double x, double y)
{
	return AjcG2dPutPlotData	(m_hCtrl, id, x, y);
}
//	プロットデータ投与（ベクトル指定）
BOOL	CAjxG2d::PutPlotData	(UI id, PCAJC2DVEC pPoint)
{
	return AjcG2dPutPlotDataV	(m_hCtrl, id, pPoint);
}
//	ビットマップデータ取得
HBITMAP	CAjxG2d::GetBitmap	()
{
	return AjcG2dGetBitmap		(m_hCtrl);
}
//	プロファイルからプロパティ値読出し(ASCII)
BOOL	CAjxG2d::LoadProp		(C_BCP pProfileSect, PCAJC2DGPROP pDefProp)
{
	return AjcG2dLoadPropA		(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルからプロパティ値読出し(UNICODE)
BOOL	CAjxG2d::LoadProp		(C_WCP pProfileSect, PCAJC2DGPROP pDefProp)
{
	return AjcG2dLoadPropW		(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルへプロパティ値書き込み(ASCII)
BOOL	CAjxG2d::SaveProp	 	(C_BCP pProfileSect)
{
	return AjcG2dSavePropA		(m_hCtrl, pProfileSect);
}
//	プロファイルへプロパティ値書き込み(UNICODE)
BOOL	CAjxG2d::SaveProp 	(C_WCP pProfileSect)
{
	return AjcG2dSavePropW		(m_hCtrl, pProfileSect);
}
//	プロファイルから詳細プロパティ値読出し(ASCII)
BOOL	CAjxG2d::LoadPropEx	(C_BCP pProfileSect, PCAJC2DGPROP pDefProp)
{
	return AjcG2dLoadPropExA	(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルから詳細プロパティ値読出し(UNICODE)
BOOL	CAjxG2d::LoadPropEx	(C_WCP pProfileSect, PCAJC2DGPROP pDefProp)
{
	return AjcG2dLoadPropExW	(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルへ詳細プロパティ値書き込み(ASCII)
BOOL	CAjxG2d::SavePropEx	(C_BCP pProfileSect)
{
	return AjcG2dSavePropExA	(m_hCtrl, pProfileSect);
}
//	プロファイルへ詳細プロパティ値書き込み(UNICODE)
BOOL	CAjxG2d::SavePropEx	(C_WCP pProfileSect)
{
	return AjcG2dSavePropExW	(m_hCtrl, pProfileSect);
}
//	ボーダー色で囲まれた部分の塗りつぶし
BOOL	CAjxG2d::FillB  		(UI id, UI idBorder, double x, double y)
{
	return AjcG2dFillB			(m_hCtrl, id, idBorder, x, y);
}
//	ボーダー色で囲まれた部分の塗りつぶし（ベクトル指定）
BOOL	CAjxG2d::FillB		(UI id, UI idBorder, PCAJC2DVEC pPoint)
{
	return AjcG2dFillBV			(m_hCtrl, id, idBorder, pPoint);
}
//	連続する白色部分の塗りつぶし
BOOL	CAjxG2d::FillS		(UI id, double x, double y)
{
	return AjcG2dFillS			(m_hCtrl, id, x, y);
}
//	連続する白色部分の塗りつぶし（ベクトル指定）
BOOL	CAjxG2d::FillS		(UI id, PCAJC2DVEC pPoint)
{
	return AjcG2dFillSV			(m_hCtrl, id, pPoint);
}
//	ピクセルの表示色取得
COLORREF CAjxG2d::GetPixel	(double x, double y)
{
	return AjcG2dGetPixel		(m_hCtrl, x, y);
}
//	ピクセルの表示色取得（ベクトル指定）
COLORREF CAjxG2d::GetPixel	(PCAJC2DVEC pPoint)
{
	return AjcG2dGetPixelV		(m_hCtrl, pPoint);
}
//	テキスト描画フォント設定
HFONT	CAjxG2d::SetTextFont	(HFONT hFont)
{
	return AjcG2dSetTextFont	(m_hCtrl, hFont);
}
//	テキスト描画（ピクセル位置指定）(ASCII)
UI		CAjxG2d::TextOut		(int x, int y, C_BCP pTxt)
{
	return AjcG2dTextOutA		(m_hCtrl, x, y, pTxt);
}
//	テキスト描画（ピクセル位置指定）(UNICODE)
UI		CAjxG2d::TextOut		(int x, int y, C_WCP pTxt)
{
	return AjcG2dTextOutW		(m_hCtrl, x, y, pTxt);
}
//	書式テキスト描画（ピクセル位置指定）(ASCII)	
UI		CAjxG2d::PrintF			(int x, int y, C_BCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2046, pFmt, vls);
		va_end	(vls);
		rc = AjcG2dTextOutA(m_hCtrl, x, y, buf);
	}
	return rc;
}
//	書式テキスト描画（ピクセル位置指定）(UNICODE)
UI		CAjxG2d::PrintF			(int x, int y, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcG2dTextOutW(m_hCtrl, x, y, buf);
	}
	return rc;
}
//	テキスト描画（２Ｄ座標指定）(ASCII)
UI		CAjxG2d::TextOutV		(AJCG2DTXOMD md, PCAJC2DVEC pV, C_BCP pTxt)
{
	return	AjcG2dTextOutVA		(m_hCtrl, md, pV, pTxt);
}
//	テキスト描画（２Ｄ座標指定）(UNICODE)
UI		CAjxG2d::TextOutV		(AJCG2DTXOMD md, PCAJC2DVEC pV, C_WCP pTxt)
{
	return	AjcG2dTextOutVW		(m_hCtrl, md, pV, pTxt);
}
//	書式テキスト描画（２Ｄ座標指定）(ASCII)	
UI		CAjxG2d::PrintFV		(AJCG2DTXOMD md, PCAJC2DVEC pV, C_BCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcG2dTextOutVA(m_hCtrl, md, pV, buf);
	}
	return rc;
}
//	書式テキスト描画（２Ｄ座標指定）(UNICODE)
UI		CAjxG2d::PrintFV		(AJCG2DTXOMD md, PCAJC2DVEC pV, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list	vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcG2dTextOutVW(m_hCtrl, md, pV, buf);
	}
	return rc;
}
//	描画テキスト取得(ASCII)	
UI		CAjxG2d::GetText		(UI key, BCP pBuf, UI lBuf)
{
	return AjcG2dGetTextA		(m_hCtrl, key, pBuf, lBuf);
}
//	描画テキスト取得(UNICODE)
UI		CAjxG2d::GetText		(UI key, WCP pBuf, UI lBuf)
{
	return AjcG2dGetTextW		(m_hCtrl, key, pBuf, lBuf);
}

//	図形描画データクリアー
BOOL	CAjxG2d::ClearShape		(UI id)
{
	return AjcG2dClearShape		(m_hCtrl, id);
}
//	全ての図形描画データクリアー
BOOL	CAjxG2d::ClearShape		()
{
	return AjcG2dClearAllShape	(m_hCtrl);
}
//	プロットデータクリアー
BOOL	CAjxG2d::ClearPlot		(UI id)
{
	return AjcG2dClearPlot		(m_hCtrl, id);
}
//	全てのプロットデータクリアー
BOOL	CAjxG2d::ClearPlot		()
{
	return AjcG2dClearAllPlot	(m_hCtrl);
}
//	描画テキストクリアー
BOOL	CAjxG2d::ClearText		(UI key)
{
	return AjcG2dClearText		(m_hCtrl, key);
}
//	 全ての描画テキストクリアー
BOOL	CAjxG2d::ClearText		()
{
	return AjcG2dClearAllText	(m_hCtrl);
}


//----- 平面描画ファンクション（２Ｄ／３Ｄ共通） -------------------------------------------------------//
//	平面にピクセル描画
BOOL	CAjxG2d::Pixel 		(UI id, double x, double y, UI PixelSize)
{
	return AjcG2dPixel			(m_hCtrl, id, x, y, PixelSize);
}
//	平面にピクセル描画（ベクトル指定）
BOOL	CAjxG2d::Pixel 		(UI id, PCAJC2DVEC pPoint, UI PixelSize)
{
	return AjcG2dPixelV			(m_hCtrl, id, pPoint, PixelSize);
}
//	平面にライン描画
BOOL	CAjxG2d::Line			(UI id, double x1, double y1, double x2, double y2)
{
	return AjcG2dLine			(m_hCtrl, id, x1, y1, x2, y2);
}
//	平面にライン描画（ベクトル指定）
BOOL	CAjxG2d::Line			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2)
{
	return AjcG2dLineV			(m_hCtrl, id, p1, p2);
}
//	平面に描画するライン／矢印の始点設定
BOOL	CAjxG2d::MoveTo		(UI id, double x, double y)
{
	return AjcG2dMoveTo			(m_hCtrl, id, x, y);
}
//	平面に描画するライン／矢印の始点設定（ベクトル指定）
BOOL	CAjxG2d::MoveTo		(UI id, PCAJC2DVEC ps)
{
	return AjcG2dMoveToV		(m_hCtrl, id, ps);
}
//	終点を指定し平面にライン描画
BOOL	CAjxG2d::LineTo		(UI id, double x, double y)
{
	return AjcG2dLineTo			(m_hCtrl, id, x, y);
}
//	終点を指定し平面にライン描画（ベクトル指定）
BOOL	CAjxG2d::LineTo		(UI id, PCAJC2DVEC pe)
{
	return AjcG2dLineToV		(m_hCtrl, id, pe);
}
//	平面に矢印描画
BOOL	CAjxG2d::Arrow		(UI id, double x1, double y1, double x2, double y2)
{
	return AjcG2dArrow			(m_hCtrl, id, x1, y1, x2, y2);
}
//	平面に矢印描画（ベクトル指定）
BOOL	CAjxG2d::Arrow		(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2)
{
	return AjcG2dArrowV			(m_hCtrl, id, p1, p2);
}
//	終点を指定し平面に矢印描画
BOOL	CAjxG2d::ArrowTo		(UI id, double x, double y)
{
	return AjcG2dArrowTo		(m_hCtrl, id, x, y);
}
//	終点を指定し平面に矢印描画（ベクトル指定）
BOOL	CAjxG2d::ArrowTo		(UI id, PCAJC2DVEC pe)
{
	return AjcG2dArrowToV		(m_hCtrl, id, pe);
}
//	平面に三角形描画
BOOL	CAjxG2d::Triangle		(UI id, double x1, double y1, double x2, double y2, double x3, double y3)
{
	return AjcG2dTriangle		(m_hCtrl, id, x1, y1, x2, y2, x3, y3);
}
//	平面に三角形描画（ベクトル指定）
BOOL	CAjxG2d::Triangle		(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3)
{
	return AjcG2dTriangleV		(m_hCtrl, id, p1, p2, p3);
}
//	平面に四角形描画
BOOL	CAjxG2d::Square		(UI id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4)
{
	return AjcG2dSquare			(m_hCtrl, id, x1, y1, x2, y2, x3, y3, x4, y4);
}
//	平面に四角形描画（ベクトル指定）
BOOL	CAjxG2d::Square		(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3, PCAJC2DVEC p4)
{
	return AjcG2dSquareV		(m_hCtrl, id, p1, p2, p3, p4);
}
//	平面に長方形描画
BOOL	CAjxG2d::Rectangle	(UI id, double x1, double y1, double x2, double y2)
{
	return AjcG2dRectangle		(m_hCtrl, id, x1, y1, x2, y2);
}
//	平面に長方形描画（ベクトル指定）
BOOL	CAjxG2d::Rectangle	(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2)
{
	return AjcG2dRectangleV		(m_hCtrl, id, p1, p2);
}
//	平面に円／楕円描画
BOOL	CAjxG2d::Ellipse		(UI id, double xc, double yc, double rx, double ry)
{
	return AjcG2dEllipse		(m_hCtrl, id, xc, yc, rx, ry);
}
//	平面に円／楕円描画（ベクトル指定）
BOOL	CAjxG2d::Ellipse		(UI id, PCAJC2DVEC pCent, double rx, double ry)
{
	return AjcG2dEllipseV		(m_hCtrl, id, pCent, rx, ry);
}
//	平面に星形描画
BOOL	CAjxG2d::Star			(UI id, double xc, double yc, double r1, double r2, UI nVtx, double rot, BOOL fInLine)
{
	return AjcG2dStarEx			(m_hCtrl, id, xc, yc, r1, r2, nVtx, rot, fInLine);
}
//	平面に星形描画（ベクトル指定）
BOOL	CAjxG2d::Star			(UI id, PCAJC2DVEC pCent    , double r1, double r2, UI  nVtx, double rot, BOOL fInLine)
{
	return AjcG2dStarVEx		(m_hCtrl, id, pCent , r1, r2, nVtx, rot, fInLine);
}

//----- ２Ｄ／３Ｄ共通ファンクション -------------------------------------------------------------------//
//	右クリックによるポップアップメニューの許可／禁止
BOOL	CAjxG2d::EnablePopupMenu	(BOOL fEnable)
{
	return AjcG3dEnablePopupMenu	(m_hCtrl, fEnable);
}
//	右クリック通知設定
BOOL	CAjxG2d::SetNtcRClk			(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	return	AjcG3dSetNtcRClk		(m_hCtrl, fNtcRClk, MsgRBDown, MsgRBUp);
}
//	ツールチップの設定(ASCII)
BOOL	CAjxG2d::SetTipText			(C_BCP pTxt)
{
	return	AjcG3dSetTipTextA		(m_hCtrl, pTxt);
}
//	ツールチップの設定(UNICODE)
BOOL	CAjxG2d::SetTipText			(C_WCP pTxt)
{
	return	AjcG3dSetTipTextW		(m_hCtrl, pTxt);
}
//	ツールチップの取得(ASCII)
UI		CAjxG2d::GetTipText			(BCP pBuf, UI lBuf)
{
	return	AjcG3dGetTipTextA		(m_hCtrl, pBuf, lBuf);
}
//	ツールチップの取得(UNICODE)
UI		CAjxG2d::GetTipText			(WCP pBuf, UI lBuf)
{
	return	AjcG3dGetTipTextW		(m_hCtrl, pBuf, lBuf);
}
//	フィルタ・チェックボックス・ツールチップの設定(ASCII)
BOOL	CAjxG2d::SetChkBoxTipText	(UI n, C_BCP pTxt)
{
	return	AjcG3dSetChkBoxTipTextA	(m_hCtrl, n, pTxt);
}
//	フィルタ・チェックボックス・ツールチップの設定(UNICODE)
BOOL	CAjxG2d::SetChkBoxTipText	(UI n, C_WCP pTxt)
{
	return	AjcG3dSetChkBoxTipTextW	(m_hCtrl, n, pTxt);
}
//	フィルタ・チェックボックス・ツールチップの取得(ASCII)
UI		CAjxG2d::GetChkBoxTipText	(UI n, BCP pBuf, UI lBuf)
{
	return	AjcG3dGetChkBoxTipTextA	(m_hCtrl, n, pBuf, lBuf);
}
//	フィルタ・チェックボックス・ツールチップの取得(UNICODE)
UI		CAjxG2d::GetChkBoxTipText	(UI n, WCP pBuf, UI lBuf)
{
	return	AjcG3dGetChkBoxTipTextW	(m_hCtrl, n, pBuf, lBuf);
}
//	ツールチップ表示条件の設定
BOOL	CAjxG2d::SetTipShowAlways	(BOOL fShowAlways)
{
	return	AjcG3dSetTipShowAlways	(m_hCtrl, fShowAlways);
}
//	ツールチップ表示条件の取得
BOOL	CAjxG2d::GetTipShowAlways	()
{
	return	AjcG3dGetTipShowAlways	(m_hCtrl);
}
//	フィルタ・チェックボックス・ツールチップの設定
BOOL	CAjxG2d::SetChkBoxTipShowAlways(UI n, BOOL fShowAlways)
{
	return	AjcG3dSetChkBoxTipShowAlways(m_hCtrl, n, fShowAlways);
}
//	フィルタ・チェックボックス・ツールチップの取得
BOOL	CAjxG2d::GetChkBoxTipShowAlways(UI n)
{
	return	AjcG3dGetChkBoxTipShowAlways(m_hCtrl, n);
}
//	全ツールチップ表示条件の設定
BOOL	CAjxG2d::SetTipShowAlwaysAll(BOOL fShowAlways)
{
	return	AjcG3dSetTipShowAlwaysAll(m_hCtrl, fShowAlways);
}
//	フィルタの設定
BOOL	CAjxG2d::SetFilter 		(UI n, BOOL state)
{
	return	AjcG3dSetFilter		(m_hCtrl, n, state);
}
//	フィルタの取得
BOOL	CAjxG2d::GetFilter 		(UI n)
{
	return	AjcG3dGetFilter		(m_hCtrl, n);
}
//	ドロップされたファイル名取得(ASCII)
BOOL	CAjxG2d::GetDroppedFile	(BC buf[MAX_PATH])
{
	return	AjcG3dGetDroppedFileA(m_hCtrl, buf);
}
//	ドロップされたファイル名取得(UNICODE)
BOOL	CAjxG2d::GetDroppedFile (WC buf[MAX_PATH])
{
	return	AjcG3dGetDroppedFileW(m_hCtrl, buf);
}
//	ドロップされたディレクトリ名取得(ASCII)
BOOL	CAjxG2d::GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return	AjcG3dGetDroppedDirExA(m_hCtrl, buf, fTailIsDelimiter);
}
//	ドロップされたディレクトリ名取得(UNICODE)
BOOL	CAjxG2d::GetDroppedDir	(WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return	AjcG3dGetDroppedDirExW(m_hCtrl, buf, fTailIsDelimiter);
}
//	タイトル文字列の設定(ASCII)
BOOL	CAjxG2d::SetTitleText	(C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)	
{
	return	AjcG3dSetTitleTextA	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}
//	タイトル文字列の設定(UNICODE)
BOOL	CAjxG2d::SetTitleText		(C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)	
{
	return	AjcG3dSetTitleTextW	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}
//	画面表示の停止／再開
BOOL	CAjxG2d::Pause				(BOOL fPause)
{
	return	AjcG3dPause			(m_hCtrl, fPause);
}
//	描画時間計測情報の許可／禁止
BOOL	CAjxG2d::EnableMesDraw		(BOOL fEnable)
{
	return	AjcG3dEnableMesDraw	(m_hCtrl, fEnable);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxG2d::Attach(HWND hwnd)
{
	HWND	hParent;
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hwnd)) {
		::GetClassNameA(hwnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrl3dGraph") == 0) {
			//	ワーク初期化
			m_hCtrl = hwnd;
			hParent = ::GetParent(hwnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_G2D, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("G2D cannot be generated due to an invalid window class.");
	}
	else throw std::runtime_error("G2D cannot be generated due to an invalid window handle.");
}
//----- プロットリスト通知 -------------------------------------------------------------------------------------//
VO		CAjxG2d::OnNtcPlotList(PCAJC3DGPLOTLIST pList)
{
}
//----- データクリアー通知 -------------------------------------------------------------------------------------//
VO		CAjxG2d::OnNtcClear(int Factor)
{
}
//----- ダブルクリック通知 -------------------------------------------------------------------------------------//
VO		CAjxG2d::OnNtcDblClk()
{
}
//----- ファイルドロップ通知 -----------------------------------------------------------------------------------//
VO		CAjxG2d::OnNtcDropFile(UI n)
{
}
//----- フォルダドロップ通知 -----------------------------------------------------------------------------------//
VO		CAjxG2d::OnNtcDropDir (UI n)
{
}
//----- 右クリック通知 -----------------------------------------------------------------------------------------//
VO		CAjxG2d::OnNtcRClick(PCAJC3DGRCLK pRClk)
{
}

