﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcG3dSubClassed_"
#define	PROP_NAME_CTRL		"_AjcG3dWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_G3D, WM_COMMAND			)
{
	CAjxG3d*	p = (CAjxG3d*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);

	if (p != NULL) {
		switch (HIWORD(wParam)) {
			case AJC3DGN_ROTTHETA:	p->OnNtcRotTheta(AjcG3dGetNtcRotTheta((HWND)lParam));	break;	//	視点角度通知
			case AJC3DGN_PLOTLIST:	p->OnNtcPlotList(AjcG3dGetNtcList	  ((HWND)lParam));	break;	//	プロットリスト通知
			case AJC3DGN_CLEAR:		p->OnNtcClear	(AjcG3dGetNtcClrFact  ((HWND)lParam));	break;	//	データクリアー通知
			case AJC3DGN_DBLCLK:	p->OnNtcDblClk	();										break;	//	ダブルクリック通知
			case AJC3DGN_DROPFILE:	p->OnNtcDropFile(AjcG3dGetNtcFiles	  ((HWND)lParam));	break;	//	ファイルドロップ通知
			case AJC3DGN_DROPDIR:	p->OnNtcDropDir (AjcG3dGetNtcDirs	  ((HWND)lParam));	break;	//	フォルダドロップ通知
			case AJC3DGN_RCLICK:	p->OnNtcRClick	(AjcG3dGetNtcRClk	  ((HWND)lParam));	break;	//	右クリック通知
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_G3D);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_G3D, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_G3D);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_G3D)
	AJC_WNDMAP_MSG(SBC_G3D, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_G3D, WM_DESTROY	   )
AJC_WNDMAP_END


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxG3d::CAjxG3d() 
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxG3d::~CAjxG3d()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ３Ｄファンクション -----------------------------------------------------------------------------//
//	３Ｄグラフモード初期化
BOOL	CAjxG3d::Init			(double x1, double y1, double z1, double x2, double y2, double z2, UI style)
{
	return AjcG3dInit			(m_hCtrl, x1, y1, z1, x2, y2, z2, style);
}
//	３Ｄグラフモード初期化（ベクトル指定）
BOOL	CAjxG3d::Init			(PCAJC3DVEC pLo, PAJC3DVEC pHi, PAJC3DVEC pRot, UI style)
{
	return AjcG3dInitV			(m_hCtrl, pLo, pHi, pRot, style);
}
//	平面アングル設定（３Ｄ）
BOOL	CAjxG3d::SetPlane 		(AJCG3DAXIS_DIR HoriAxis, AJCG3DAXIS_DIR VertAxis)
{
	return AjcG3dSetPlane		(m_hCtrl, HoriAxis, VertAxis);
}
//	プロパティ設定
BOOL	CAjxG3d::SetProp		(PCAJC3DGPROP pProp)
{
	return AjcG3dSetProp		(m_hCtrl, pProp);
}
//	プロパティ取得
BOOL	CAjxG3d::GetProp		(PAJC3DGPROP  pBuf)
{
	return AjcG3dGetProp		(m_hCtrl, pBuf);
}
//	レンジ自動調整
BOOL	CAjxG3d::AdjustRange	()
{
	return AjcG3dAdjustRange	(m_hCtrl);
}
//	各軸のレンジ設定
BOOL	CAjxG3d::SetRange		(double x1, double y1, double z1, double x2, double y2, double z2)
{
	return AjcG3dSetRange		(m_hCtrl, x1, y1, z1, x2, y2, z2);
}
//	各軸の中心位置設定
BOOL	CAjxG3d::SetCenter		(double xc, double yc, double zc)
{
	return AjcG3dSetCenter		(m_hCtrl, xc, yc, zc);
}
//	各軸の幅（半径）設定
BOOL	CAjxG3d::SetWidth		(double xr, double yr, double zr)
{
	return AjcG3dSetWidth		(m_hCtrl, xr, yr, zr);
}
//	各軸のレンジ幅を同じにする
BOOL	CAjxG3d::SetSameRangeWidth	()
{
	return AjcG3dSetSameRangeWidth(m_hCtrl);
}
//	レンジ設定された領域のアスペクトを設定する
BOOL	CAjxG3d::SetFixedAspect	(BOOL fFixed)
{
	return AjcG3dSetFixedAspect	(m_hCtrl, fFixed);
}
//	表示色設定
BOOL	CAjxG3d::SetColor		(UI id, COLORREF rgbP, COLORREF rgbN)
{
	return AjcG3dSetColor		(m_hCtrl, id, rgbP, rgbN);
}
//	プロットデータ数設定
BOOL	CAjxG3d::SetPlotNumber	(UI id, UI PlotNumber)
{
	return AjcG3dSetPlotNumber	(m_hCtrl, id, PlotNumber);
}
//	プロットデータのピクセルサイズ設定
BOOL	CAjxG3d::SetPlotSize	(UI id, UI PixelSize, UI PixelSizeE)
{
	return AjcG3dSetPlotSize	(m_hCtrl, id, PixelSize, PixelSizeE);
}
//	プロットデータ投与
BOOL	CAjxG3d::PutPlotData	(UI id, double x, double y, double z)
{
	return AjcG3dPutPlotData	(m_hCtrl, id, x, y, z);
}
//	プロットデータ投与（ベクトル指定）
BOOL	CAjxG3d::PutPlotData	(UI id, PCAJC3DVEC pPoint)
{
	return AjcG3dPutPlotDataV	(m_hCtrl, id, pPoint);
}
//	ピクセル描画
BOOL	CAjxG3d::Pixel			(UI id, double x , double y , double z , UI PixelSize)
{
	return AjcG3dPixel			(m_hCtrl, id, x, y, z, PixelSize);
}
//	ピクセル描画（ベクトル指定）
BOOL	CAjxG3d::Pixel			(UI id, PCAJC3DVEC pPoint, UI PixelSize)
{
	return AjcG3dPixelV			(m_hCtrl, id, pPoint, PixelSize);
}
//	ライン描画
BOOL	CAjxG3d::Line			(UI id, double x1, double y1, double z1, double x2, double y2, double z2)
{
	return AjcG3dLine			(m_hCtrl, id, x1, y1, z1, x2, y2, z2);
}
//	ライン描画（ベクトル指定）
BOOL	CAjxG3d::Line			(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2)
{
	return AjcG3dLineV			(m_hCtrl, id, p1, p2);
}
//	ライン／矢印の始点設定
BOOL	CAjxG3d::MoveTo			(UI id, double x, double y, double z)
{
	return AjcG3dMoveTo			(m_hCtrl, id, x, y, z);
}
//	ライン／矢印の始点設定（ベクトル指定）
BOOL	CAjxG3d::MoveTo			(UI id, PCAJC3DVEC ps)
{
	return AjcG3dMoveToV		(m_hCtrl, id, ps);
}
//	ラインの終点を設定しライン描画
BOOL	CAjxG3d::LineTo			(UI id, double x, double y, double z)
{
	return AjcG3dLineTo			(m_hCtrl, id, x, y, z);
}
//	ラインの終点を設定しライン描画（ベクトル指定）
BOOL	CAjxG3d::LineTo			(UI id, PCAJC3DVEC pe)
{
	return AjcG3dLineToV		(m_hCtrl, id, pe);
}
//	矢印描画
BOOL	CAjxG3d::Arrow			(UI id, double x1, double y1, double z1, double x2, double y2, double z2)
{
	return AjcG3dArrow			(m_hCtrl, id, x1, y1, z1, x2, y2, z2);
}
//	矢印描画（ベクトル指定）
BOOL	CAjxG3d::Arrow			(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2)
{
	return AjcG3dArrowV			(m_hCtrl, id, p1, p2);
}
//	ラインの終点を設定し矢印描画
BOOL	CAjxG3d::ArrowTo		(UI id, double x, double y, double z)
{
	return AjcG3dArrowTo		(m_hCtrl, id, x, y, z);
}
//	ラインの終点を設定し矢印描画（ベクトル指定）
BOOL	CAjxG3d::ArrowTo		(UI id, PCAJC3DVEC pe)
{
	return AjcG3dArrowToV		(m_hCtrl, id, pe);
}
//	三角形描画
BOOL	CAjxG3d::Triangle		(UI id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3)
{
	return AjcG3dTriangle		(m_hCtrl, id, x1, y1, z1, x2, y2, z2, x3, y3, z3);
}
//	三角形描画（ベクトル指定）
BOOL	CAjxG3d::Triangle		(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3)
{
	return AjcG3dTriangleV		(m_hCtrl, id, p1, p2, p3);
}
//		四角形描画
BOOL	CAjxG3d::Square			(UI id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4)
{
	return AjcG3dSquare			(m_hCtrl, id, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
}
//	四角形描画（ベクトル指定）
BOOL	CAjxG3d::Square			(UI id, PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PCAJC3DVEC p4)
{
	return AjcG3dSquareV		(m_hCtrl, id, p1, p2, p3, p4);
}
//	立方体／長方体描画
BOOL	CAjxG3d::Cube			(UI id, double xc, double yc, double zc, double xr, double yr, double zr, UI division)
{
	return AjcG3dCube			(m_hCtrl, id, xc, yc, zc, xr, yr, zr,division);
}
//	立方体／長方体描画（ベクトル指定）
BOOL	CAjxG3d::Cube			(UI id, PCAJC3DVEC pCent, double xr, double yr, double zr, UI division)
{
	return AjcG3dCubeV			(m_hCtrl, id, pCent, xr, yr, zr, division);
}
//	球／楕球描画
BOOL	CAjxG3d::Sphere			(UI id, double xc, double yc, double zc, double xr, double yr, double zr, UI slice, UI stack)
{
	return AjcG3dSphere			(m_hCtrl, id, xc, yc, zc, xr, yr, zr, slice, stack);
}
//	球／楕球描画（ベクトル指定）
BOOL	CAjxG3d::Sphere			(UI id, PCAJC3DVEC pCent, double rx, double ry, double rz, UI slice, UI stack)
{
	return AjcG3dSphereV		(m_hCtrl, id, pCent, rx, ry, rz, slice, stack);
}
//	３Ｄ空間上に任意の平面を定義
BOOL	CAjxG3d::DefPlane		(UI id, double xc, double yc, double zc, double xv, double yv, double zv, double xo, double yo, double zo)
{
	return AjcG3dDefPlane		(m_hCtrl, id, xc, yc, zc, xv, yv, zv, xo, yo, zo);
}
//	３Ｄ空間上に任意の平面を定義（ベクトル指定）
BOOL	CAjxG3d::DefPlane		(UI id, PCAJC3DLVEC pLVec, PCAJC3DVEC pVOrg)
{
	return AjcG3dDefPlaneV		(m_hCtrl, id, pLVec, pVOrg);
}
//	視点設定
BOOL	CAjxG3d::SetAngle		(double rtx, double rty, double rtz)
{
	return AjcG3dSetAngle		(m_hCtrl, rtx, rty, rtz);
}
//	視点をＸ－Ｙ平面に設定
BOOL	CAjxG3d::SetAngleXY		()
{
	return AjcG3dSetAngleXY		(m_hCtrl);
}
//	視点をＸ－Ｚ平面に設定
BOOL	CAjxG3d::SetAngleXZ		()
{
	return AjcG3dSetAngleXZ		(m_hCtrl);
}
//	視点をＹ－Ｚ平面に設定
BOOL	CAjxG3d::SetAngleYZ		()
{
	return AjcG3dSetAngleYZ		(m_hCtrl);
}
//	視点を３Ｄイメージに設定
BOOL	CAjxG3d::SetAngle3D		()
{
	return AjcG3dSetAngle3D		(m_hCtrl);
}
//	ビットマップ取得
HBITMAP	CAjxG3d::GetBitmap		()
{
	return AjcG3dGetBitmap		(m_hCtrl);
}
//	プロファイルからプロパティ値読出し(ASCII)
BOOL	CAjxG3d::LoadProp		(C_BCP pProfileSect, PCAJC3DGPROP pDefProp)	
{
	return AjcG3dLoadPropA		(m_hCtrl, pProfileSect, pDefProp);
}

//	プロファイルからプロパティ値読出し(UNICODE)
BOOL	CAjxG3d::LoadProp 		(C_WCP pProfileSect, PCAJC3DGPROP pDefProp)
{
	return AjcG3dLoadPropW		(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルへプロパティ値書き込み(ASCII)
BOOL	CAjxG3d::SaveProp 		(C_BCP pProfileSect)
{
	return AjcG3dSavePropA		(m_hCtrl, pProfileSect);
}
//	プロファイルへプロパティ値書き込み(UNICODE)
BOOL	CAjxG3d::SaveProp 		(C_WCP pProfileSect)
{
	return AjcG3dSavePropW		(m_hCtrl, pProfileSect);
}
//	プロファイルから詳細プロパティ値読出し(ASCII)
BOOL	CAjxG3d::LoadPropEx		(C_BCP pProfileSect, PCAJC3DGPROP pDefProp)
{
	return AjcG3dLoadPropExA	(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルから詳細プロパティ値読出し(UNICODE)
BOOL	CAjxG3d::LoadPropEx		(C_WCP pProfileSect, PCAJC3DGPROP pDefProp)
{
	return AjcG3dLoadPropExW	(m_hCtrl, pProfileSect, pDefProp);
}
//	プロファイルへ詳細プロパティ値書き込み(ASCII)
BOOL	CAjxG3d::SavePropEx		(C_BCP pProfileSect)
{
	return AjcG3dSavePropExA	(m_hCtrl, pProfileSect);
}
//	プロファイルへ詳細プロパティ値書き込み(UNICODE)
BOOL	CAjxG3d::SavePropEx		(C_WCP pProfileSect)
{
	return AjcG3dSavePropExW	(m_hCtrl, pProfileSect);
}
//	テキスト描画フォント設定
HFONT	CAjxG3d::SetTextFont	(HFONT hFont)
{
	return AjcG3dSetTextFont	(m_hCtrl, hFont);
}
//	テキスト描画（ピクセル位置指定）(ASCII)
UI		CAjxG3d::TextOut		(int x, int y, C_BCP pTxt)
{
	return AjcG3dTextOutA		(m_hCtrl, x, y, pTxt);
}
//	テキスト描画（ピクセル位置指定）(UNICODE)
UI		CAjxG3d::TextOut		(int x, int y, C_WCP pTxt)
{
	return AjcG3dTextOutW		(m_hCtrl, x, y, pTxt);
}
//	書式テキスト描画（ピクセル位置指定）(ASCII)	
UI		CAjxG3d::PrintF			(int x, int y, C_BCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2046, pFmt, vls);
		va_end	(vls);
		rc = AjcG3dTextOutA(m_hCtrl, x, y, buf);
	}
	return rc;
}
//	書式テキスト描画（ピクセル位置指定）(UNICODE)
UI		CAjxG3d::PrintF			(int x, int y, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcG3dTextOutW(m_hCtrl, x, y, buf);
	}
	return rc;
}
//	テキスト描画（３Ｄ座標指定）(ASCII)
UI		CAjxG3d::TextOutV		(AJCG3DTXOMD md, PCAJC3DVEC pV, C_BCP pTxt)
{
	return	AjcG3dTextOutVA		(m_hCtrl, md, pV, pTxt);
}
//	テキスト描画（３Ｄ座標指定）(UNICODE)
UI		CAjxG3d::TextOutV		(AJCG3DTXOMD md, PCAJC3DVEC pV, C_WCP pTxt)
{
	return	AjcG3dTextOutVW		(m_hCtrl, md, pV, pTxt);
}
//	書式テキスト描画（３Ｄ座標指定）(ASCII)	
UI		CAjxG3d::PrintFV		(AJCG3DTXOMD md, PCAJC3DVEC pV, C_BCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcG3dTextOutVA(m_hCtrl, md, pV, buf);
	}
	return rc;
}
//	書式テキスト描画（３Ｄ座標指定）(UNICODE)
UI		CAjxG3d::PrintFV		(AJCG3DTXOMD md, PCAJC3DVEC pV, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list	vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcG3dTextOutVW(m_hCtrl, md, pV, buf);
	}
	return rc;
}
//	描画テキスト取得(ASCII)	
UI		CAjxG3d::GetText		(UI key, BCP pBuf, UI lBuf)
{
	return AjcG3dGetTextA		(m_hCtrl, key, pBuf, lBuf);
}
//	描画テキスト取得(UNICODE)
UI		CAjxG3d::GetText		(UI key, WCP pBuf, UI lBuf)
{
	return AjcG3dGetTextW		(m_hCtrl, key, pBuf, lBuf);
}
//	図形描画データクリアー
BOOL	CAjxG3d::ClearShape		(UI id)
{
	return AjcG3dClearShape		(m_hCtrl, id);
}
//	全ての図形描画データクリアー
BOOL	CAjxG3d::ClearShape		()
{
	return AjcG3dClearAllShape	(m_hCtrl);
}
//	プロットデータクリアー
BOOL	CAjxG3d::ClearPlot		(UI id)
{
	return AjcG3dClearPlot		(m_hCtrl, id);
}
//	全てのプロットデータクリアー
BOOL	CAjxG3d::ClearPlot		()
{
	return AjcG3dClearAllPlot	(m_hCtrl);
}
//	描画テキストクリアー
BOOL	CAjxG3d::ClearText		(UI key)
{
	return AjcG3dClearText		(m_hCtrl, key);
}
//	 全ての描画テキストクリアー
BOOL	CAjxG3d::ClearText		()
{
	return AjcG3dClearAllText	(m_hCtrl);
}

//----- 平面描画ファンクション（２Ｄ／３Ｄ共通） -------------------------------------------------------//
//	平面にピクセル描画
BOOL	CAjxG3d::Pixel 			(UI id, double x, double y, UI PixelSize)
{
	return AjcG2dPixel			(m_hCtrl, id, x, y, PixelSize);
}
//	平面にピクセル描画（ベクトル指定）
BOOL	CAjxG3d::Pixel 			(UI id, PCAJC2DVEC pPoint, UI PixelSize)
{
	return AjcG2dPixelV			(m_hCtrl, id, pPoint, PixelSize);
}
//	平面にライン描画
BOOL	CAjxG3d::Line			(UI id, double x1, double y1, double x2, double y2)
{
	return AjcG2dLine			(m_hCtrl, id, x1, y1, x2, y2);
}
//	平面にライン描画（ベクトル指定）
BOOL	CAjxG3d::Line			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2)
{
	return AjcG2dLineV			(m_hCtrl, id, p1, p2);
}
//	平面に描画するライン／矢印の始点設定
BOOL	CAjxG3d::MoveTo			(UI id, double x, double y)
{
	return AjcG2dMoveTo			(m_hCtrl, id, x, y);
}
//	平面に描画するライン／矢印の始点設定（ベクトル指定）
BOOL	CAjxG3d::MoveTo			(UI id, PCAJC2DVEC ps)
{
	return AjcG2dMoveToV		(m_hCtrl, id, ps);
}
//	終点を指定し平面にライン描画
BOOL	CAjxG3d::LineTo			(UI id, double x, double y)
{
	return AjcG2dLineTo			(m_hCtrl, id, x, y);
}
//	終点を指定し平面にライン描画（ベクトル指定）
BOOL	CAjxG3d::LineTo			(UI id, PCAJC2DVEC pe)
{
	return AjcG2dLineToV		(m_hCtrl, id, pe);
}
//	平面に矢印描画
BOOL	CAjxG3d::Arrow			(UI id, double x1, double y1, double x2, double y2)
{
	return AjcG2dArrow			(m_hCtrl, id, x1, y1, x2, y2);
}
//	平面に矢印描画（ベクトル指定）
BOOL	CAjxG3d::Arrow			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2)
{
	return AjcG2dArrowV			(m_hCtrl, id, p1, p2);
}
//	終点を指定し平面に矢印描画
BOOL	CAjxG3d::ArrowTo		(UI id, double x, double y)
{
	return AjcG2dArrowTo		(m_hCtrl, id, x, y);
}
//	終点を指定し平面に矢印描画（ベクトル指定）
BOOL	CAjxG3d::ArrowTo		(UI id, PCAJC2DVEC pe)
{
	return AjcG2dArrowToV		(m_hCtrl, id, pe);
}
//	平面に三角形描画
BOOL	CAjxG3d::Triangle		(UI id, double x1, double y1, double x2, double y2, double x3, double y3)
{
	return AjcG2dTriangle		(m_hCtrl, id, x1, y1, x2, y2, x3, y3);
}
//	平面に三角形描画（ベクトル指定）
BOOL	CAjxG3d::Triangle		(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3)
{
	return AjcG2dTriangleV		(m_hCtrl, id, p1, p2, p3);
}
//	平面に四角形描画
BOOL	CAjxG3d::Square			(UI id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4)
{
	return AjcG2dSquare			(m_hCtrl, id, x1, y1, x2, y2, x3, y3, x4, y4);
}
//	平面に四角形描画（ベクトル指定）
BOOL	CAjxG3d::Square			(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3, PCAJC2DVEC p4)
{
	return AjcG2dSquareV		(m_hCtrl, id, p1, p2, p3, p4);
}
//	平面に長方形描画
BOOL	CAjxG3d::Rectangle		(UI id, double x1, double y1, double x2, double y2)
{
	return AjcG2dRectangle		(m_hCtrl, id, x1, y1, x2, y2);
}
//	平面に長方形描画（ベクトル指定）
BOOL	CAjxG3d::Rectangle		(UI id, PCAJC2DVEC p1, PCAJC2DVEC p2)
{
	return AjcG2dRectangleV		(m_hCtrl, id, p1, p2);
}
//	平面に円／楕円描画
BOOL	CAjxG3d::Ellipse		(UI id, double xc, double yc, double rx, double ry)
{
	return AjcG2dEllipse		(m_hCtrl, id, xc, yc, rx, ry);
}
//	平面に円／楕円描画（ベクトル指定）
BOOL	CAjxG3d::Ellipse		(UI id, PCAJC2DVEC pCent, double rx, double ry)
{
	return AjcG2dEllipseV		(m_hCtrl, id, pCent, rx, ry);
}
//	平面に星形描画
BOOL	CAjxG3d::Star			(UI id, double xc, double yc, double r1, double r2, UI nVtx, double rot, BOOL fInLine)
{
	return AjcG2dStarEx			(m_hCtrl, id, xc, yc, r1, r2, nVtx, rot, fInLine);
}
//	平面に星形描画（ベクトル指定）
BOOL	CAjxG3d::Star			(UI id, PCAJC2DVEC pCent    , double r1, double r2, UI nVtx, double rot, BOOL fInLine)
{
	return AjcG2dStarVEx		(m_hCtrl, id, pCent , r1, r2, nVtx, rot, fInLine);
}
//----- ２Ｄ／３Ｄ共通ファンクション -------------------------------------------------------------------//
//	右クリックによるポップアップメニューの許可／禁止
BOOL	CAjxG3d::EnablePopupMenu	(BOOL fEnable)
{
	return AjcG3dEnablePopupMenu	(m_hCtrl, fEnable);
}
//	右クリック通知設定
BOOL	CAjxG3d::SetNtcRClk			(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	return	AjcG3dSetNtcRClk		(m_hCtrl, fNtcRClk, MsgRBDown, MsgRBUp);
}
//	ツールチップの設定(ASCII)
BOOL	CAjxG3d::SetTipText			(C_BCP pTxt)
{
	return	AjcG3dSetTipTextA		(m_hCtrl, pTxt);
}
//	ツールチップの設定(UNICODE)
BOOL	CAjxG3d::SetTipText			(C_WCP pTxt)
{
	return	AjcG3dSetTipTextW		(m_hCtrl, pTxt);
}
//	ツールチップの取得(ASCII)
UI		CAjxG3d::GetTipText			(BCP pBuf, UI lBuf)
{
	return	AjcG3dGetTipTextA		(m_hCtrl, pBuf, lBuf);
}
//	ツールチップの取得(UNICODE)
UI		CAjxG3d::GetTipText			(WCP pBuf, UI lBuf)
{
	return	AjcG3dGetTipTextW		(m_hCtrl, pBuf, lBuf);
}
//	フィルタ・チェックボックス・ツールチップの設定(ASCII)
BOOL	CAjxG3d::SetChkBoxTipText	(UI n, C_BCP pTxt)
{
	return	AjcG3dSetChkBoxTipTextA	(m_hCtrl, n, pTxt);
}
//	フィルタ・チェックボックス・ツールチップの設定(UNICODE)
BOOL	CAjxG3d::SetChkBoxTipText	(UI n, C_WCP pTxt)
{
	return	AjcG3dSetChkBoxTipTextW	(m_hCtrl, n, pTxt);
}
//	フィルタ・チェックボックス・ツールチップの取得(ASCII)
UI		CAjxG3d::GetChkBoxTipText	(UI n, BCP pBuf, UI lBuf)
{
	return	AjcG3dGetChkBoxTipTextA	(m_hCtrl, n, pBuf, lBuf);
}
//	フィルタ・チェックボックス・ツールチップの取得(UNICODE)
UI		CAjxG3d::GetChkBoxTipText	(UI n, WCP pBuf, UI lBuf)
{
	return	AjcG3dGetChkBoxTipTextW	(m_hCtrl, n, pBuf, lBuf);
}
//	ツールチップ表示条件の設定
BOOL	CAjxG3d::SetTipShowAlways	(BOOL fShowAlways)
{
	return	AjcG3dSetTipShowAlways	(m_hCtrl, fShowAlways);
}
//	ツールチップ表示条件の取得
BOOL	CAjxG3d::GetTipShowAlways	()
{
	return	AjcG3dGetTipShowAlways	(m_hCtrl);
}
//	フィルタ・チェックボックス・ツールチップの設定
BOOL	CAjxG3d::SetChkBoxTipShowAlways(UI n, BOOL fShowAlways)
{
	return	AjcG3dSetChkBoxTipShowAlways(m_hCtrl, n, fShowAlways);
}
//	フィルタ・チェックボックス・ツールチップの取得
BOOL	CAjxG3d::GetChkBoxTipShowAlways(UI n)
{
	return	AjcG3dGetChkBoxTipShowAlways(m_hCtrl, n);
}
//	全ツールチップ表示条件の設定
BOOL	CAjxG3d::SetTipShowAlwaysAll(BOOL fShowAlways)
{
	return	AjcG3dSetTipShowAlwaysAll(m_hCtrl, fShowAlways);
}
//	フィルタの設定
BOOL	CAjxG3d::SetFilter 		(UI n, BOOL state)
{
	return	AjcG3dSetFilter		(m_hCtrl, n, state);
}
//	フィルタの取得
BOOL	CAjxG3d::GetFilter 		(UI n)
{
	return	AjcG3dGetFilter		(m_hCtrl, n);
}
//	ドロップされたファイル名取得(ASCII)
BOOL	CAjxG3d::GetDroppedFile	(BC buf[MAX_PATH])
{
	return	AjcG3dGetDroppedFileA(m_hCtrl, buf);
}
//	ドロップされたファイル名取得(UNICODE)
BOOL	CAjxG3d::GetDroppedFile (WC buf[MAX_PATH])
{
	return	AjcG3dGetDroppedFileW(m_hCtrl, buf);
}
//	ドロップされたディレクトリ名取得(ASCII)
BOOL	CAjxG3d::GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return	AjcG3dGetDroppedDirExA(m_hCtrl, buf, fTailIsDelimiter);
}
//	ドロップされたディレクトリ名取得(UNICODE)
BOOL	CAjxG3d::GetDroppedDir	(WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return	AjcG3dGetDroppedDirExW(m_hCtrl, buf, fTailIsDelimiter);
}
//	タイトル文字列の設定(ASCII)
BOOL	CAjxG3d::SetTitleText	(C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)	
{
	return	AjcG3dSetTitleTextA	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}
//	タイトル文字列の設定(UNICODE)
BOOL	CAjxG3d::SetTitleText		(C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)	
{
	return	AjcG3dSetTitleTextW	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}
//	画面表示の停止／再開
BOOL	CAjxG3d::Pause				(BOOL fPause)
{
	return	AjcG3dPause			(m_hCtrl, fPause);
}
//	描画時間計測情報の許可／禁止
BOOL	CAjxG3d::EnableMesDraw		(BOOL fEnable)
{
	return	AjcG3dEnableMesDraw	(m_hCtrl, fEnable);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxG3d::Attach(HWND hwnd)
{
	HWND	hParent;
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hwnd)) {
		::GetClassNameA(hwnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrl3dGraph") == 0) {
			//	ワーク初期化
			m_hCtrl = hwnd;
			hParent = ::GetParent(hwnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_G3D, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("G3D cannot be generated due to an invalid window class.");
	}
	else throw std::runtime_error("G3D cannot be generated due to an invalid window handle.");
}
//----- 視点角度(視点ベクトル)通知 -----------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcRotTheta(PCAJC3DVEC pVec)
{
}
//----- プロットリスト通知 -------------------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcPlotList(PCAJC3DGPLOTLIST pList)
{
}
//----- データクリアー通知 -------------------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcClear(int Factor)
{
}
//----- ダブルクリック通知 -------------------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcDblClk()
{
}
//----- ファイルドロップ通知 -----------------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcDropFile(UI n)
{
}
//----- フォルダドロップ通知 -----------------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcDropDir (UI n)
{
}
//----- 右クリック通知 -----------------------------------------------------------------------------------------//
VO		CAjxG3d::OnNtcRClick(PCAJC3DGRCLK pRClk)
{
}

