﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcInpSubClassed_"
#define	PROP_NAME_CTRL		"_AjcInpWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_INP, WM_COMMAND			)
{
	CAjxInp*	p = (CAjxInp*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);	//	コントロールのプロパティ

	if (p != NULL) {
		switch (HIWORD(wParam)) {
			case	AJCIVN_INTVALUE:	p->OnNtcIntValue (p->GetValueInt()				);	break;	//	整数モードでの数値変化通知
			case	AJCIVN_REALVALUE:	p->OnNtcRealValue(p->GetValue()					);	break;	//	実数モードでの数値変化通知
			case	AJCIVN_RCLICK:		p->OnNtcRClick	 (AjcIvGetNtcRClk((HWND)lParam)	);	break;	//	右クリック通知
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_INP);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_INP, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_INP);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_INP)
	AJC_WNDMAP_MSG(SBC_INP, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_INP, WM_DESTROY	   )
AJC_WNDMAP_END


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxInp::CAjxInp() 
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxInp::~CAjxInp()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- テキスト表示書式の設定 ---------------------------------------------------------------------------------//
BOOL	CAjxInp::SetTextFormat		(int width, UI precision)
{
	BOOL	rc = AjcIvSetTextFormat(m_hCtrl, width, precision);
	return rc;
}
//----- プロパティ取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxInp::GetProp			(PAJCIVPROP	pBuf)
{
	BOOL	rc = AjcIvGetProp(m_hCtrl, pBuf);
	return rc;
}
//----- プロパティ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxInp::SetProp			(PCAJCIVPROP pProp)
{
	BOOL	rc = AjcIvSetProp(m_hCtrl, pProp);
	return rc;
}
//----- コントロール外枠の表示色取得 ---------------------------------------------------------------------------//
COLORREF	CAjxInp::GetBorderColor	()
{
	COLORREF	rc = AjcIvGetBorderColor(m_hCtrl);
	return rc;
}
//----- コントロール外枠の表示色設定 ---------------------------------------------------------------------------//
BOOL	CAjxInp::SetBorderColor	(COLORREF color)
{
	BOOL	rc = AjcIvSetBorderColor(m_hCtrl, color);
	return rc;
}
//----- ブリンク表示色取得 -------------------------------------------------------------------------------------//
COLORREF	CAjxInp::GetBlinkColor	()
{
	COLORREF	rc = AjcIvGetBlinkColor(m_hCtrl);
	return rc;
}
//----- ブリンク表示色設定 -------------------------------------------------------------------------------------//
BOOL	CAjxInp::SetBlinkColor	(COLORREF color)
{
	BOOL	rc = AjcIvSetBlinkColor(m_hCtrl, color);
	return rc;
}
//----- スライダのウインドハンドル取得 -------------------------------------------------------------------------//
HWND	CAjxInp::GetSilderHandle	()
{
	HWND	rc = AjcIvGetSilderHandle(m_hCtrl);
	return rc;
}

//----- ボタンのウインドハンドル取得 ---------------------------------------------------------------------------//
HWND	CAjxInp::GetBtnHandle	()
{
	HWND	rc = AjcIvGetBtnHandle(m_hCtrl);
	return rc;
}
//----- テキストボックスのウインドハンドル取得 -----------------------------------------------------------------//
HWND	CAjxInp::GetTxtHandle	()
{
	HWND	rc = AjcIvGetTxtHandle(m_hCtrl);
	return rc;
}
	
//----- スピンボタンのウインドハンドル取得 ---------------------------------------------------------------------//
HWND	CAjxInp::GetSpnHandle	()
{
	HWND	rc = AjcIvGetSpnHandle(m_hCtrl);
	return rc;
}
//----- テキストボックスのサイズ（桁数）取得 -------------------------------------------------------------------//
UI		CAjxInp::GetTxtLen		()
{
	UI		rc = AjcIvGetTxtLen(m_hCtrl);
	return rc;
}
//----- テキストボックスのサイズ（桁数）設定 -------------------------------------------------------------------//
BOOL	CAjxInp::SetTxtLen		(UI len)
{
	BOOL	rc = AjcIvSetTxtLen(m_hCtrl, len);
	return rc;
}
//----- 右ボタン操作通知設定 -----------------------------------------------------------------------------------//
BOOL	CAjxInp::SetNtcRClk		(BOOL fNtcRClk, UI msgRBtnDown, UI msgRBtnUp)
{
	BOOL	rc = AjcIvSetNtcRClk(m_hCtrl, fNtcRClk, msgRBtnDown, msgRBtnUp);
	return rc;
}
//----- 値の取得（実数） ---------------------------------------------------------------------------------------//
double	CAjxInp::GetValue		()
{
	double	rc = AjcIvGetValue(m_hCtrl);
	return rc;
}
//----- 値の取得（整数） ---------------------------------------------------------------------------------------//
int		CAjxInp::GetValueInt		()
{
	int		rc = AjcIvGetValueInt(m_hCtrl);
	return rc;
}
//----- 値の設定 -----------------------------------------------------------------------------------------------//
BOOL	CAjxInp::SetValue		(double value, BOOL fNtc)
{
	BOOL	rc = AjcIvSetValueEx(m_hCtrl, value, fNtc);
	return rc;
}
//----- 数値範囲の設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxInp::SetRange		(double minValue, double maxValue)
{
	BOOL	rc = AjcIvSetRange(m_hCtrl, minValue, maxValue);
	return rc;
}
//----- 数値の最小単位値の設定 ---------------------------------------------------------------------------------//
BOOL	CAjxInp::SetSldUnit		(double unit)
{
	BOOL	rc = AjcIvSetSldUnit(m_hCtrl, unit);
	return rc;
}
	
//----- スライダのページサイズ設定 -----------------------------------------------------------------------------//
BOOL	CAjxInp::SetSldPage		(double page)
{
	BOOL	rc = AjcIvSetSldPage(m_hCtrl, page);
	return rc;
}
	
//----- スピンボタンのステップサイズ設定 -----------------------------------------------------------------------//
BOOL	CAjxInp::SetSpnStep		(double step)
{
	BOOL	rc = AjcIvSetSpnStep(m_hCtrl, step);
	return rc;
}
//----- 数値の精度設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxInp::SetPrecision	(int prec)
{
	BOOL	rc = AjcIvSetPrecision(m_hCtrl, prec);
	return rc;
}

//----- ツールチップの設定（ASCII） ----------------------------------------------------------------------------//
BOOL	CAjxInp::SetTipText		(C_BCP pTipTxt)
{
	BOOL	rc = AjcIvSetTipTextA(m_hCtrl, pTipTxt);
	return rc;
}
//----- ツールチップの設定（UNICODE） --------------------------------------------------------------------------//
BOOL	CAjxInp::SetTipText		(C_WCP pTipTxt)
{
	BOOL	rc = AjcIvSetTipTextW(m_hCtrl, pTipTxt);
	return rc;
}
	
//----- ツールチップの取得（ASCII） ----------------------------------------------------------------------------//
UI	CAjxInp::GetTipText		(BCP pBuf, UI lBuf)
{
	UI		rc = AjcIvGetTipTextA(m_hCtrl, pBuf, lBuf);
	return rc;
}

//----- ツールチップの取得（UNICODE） --------------------------------------------------------------------------//
UI	CAjxInp::GetTipText	(WCP pBuf, UI lBuf)
{
	UI		rc = AjcIvGetTipTextW(m_hCtrl, pBuf, lBuf);
	return rc;
}

//----- ツールチップ表示条件の設定 -----------------------------------------------------------------------------//
BOOL	CAjxInp::SetTipShowAlways(BOOL fShowAlways)
{
	BOOL	rc = AjcIvSetTipShowAlways(m_hCtrl, fShowAlways);
	return rc;
}

//----- ツールチップ表示条件の取得 -----------------------------------------------------------------------------//
BOOL	CAjxInp::GetTipShowAlways()
{
	BOOL	rc = AjcIvGetTipShowAlways(m_hCtrl);
	return rc;
}

//----- 数値編集状態の取得 -------------------------------------------------------------------------------------//
BOOL	CAjxInp::GetEditState	()
{
	BOOL	rc = AjcIvGetEditState(m_hCtrl);
	return rc;
}
//----- 永続化情報の読み出し(ASCII) ----------------------------------------------------------------------------//
BOOL	CAjxInp::LoadPermInfo	(C_BCP pProfileSect, C_BCP pKey, BOOL fNtc)
{
	return AjcIvLoadPermInfoA(m_hCtrl, pProfileSect, pKey, fNtc);
}
//----- 永続化情報の読み出し(UNICODE) --------------------------------------------------------------------------//
BOOL	CAjxInp::LoadPermInfo	(C_WCP pProfileSect, C_WCP pKey, BOOL fNtc)
{
	return AjcIvLoadPermInfoW(m_hCtrl, pProfileSect, pKey, fNtc);
}
//----- 永続化情報の書き込み -----------------------------------------------------------------------------------//
BOOL	CAjxInp::SavePermInfo	()
{
	return AjcIvSavePermInfo(m_hCtrl);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxInp::Attach(HWND hwnd)
{
	HWND	hParent;
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hwnd)) {
		::GetClassNameA(hwnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrlInpVal") == 0) {
			//	ワーク初期化
			m_hCtrl = hwnd;
			hParent = ::GetParent(hwnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_INP, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("INP cannot be generated due to an invalid window class.");
	}
	else throw std::runtime_error("INP cannot be generated due to an invalid window handle.");
}
//----- 整数モードでの数値変化通知 -----------------------------------------------------------------------------//
VO CAjxInp::OnNtcIntValue (int	 val)
{
}
//----- 実数モードでの数値変化通知 -----------------------------------------------------------------------------//
VO	CAjxInp::OnNtcRealValue(double val)
{
}
//----- 右クリック通知 -----------------------------------------------------------------------------------------//
VO	CAjxInp::OnNtcRClick   (PCAJCIVRCLK pRClk)
{
}
