﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcLbxSubClassed_"
#define	PROP_NAME_CTRL		"_AjcLbxWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_LBX, WM_COMMAND			)
{
	CAjxLbx*	p = (CAjxLbx*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);

	if (p != NULL) {
		switch (HIWORD(wParam)) {
			case AJCLBXN_DBLCLK:		p->OnNtcDblClk		();											break;	//	ダブルクリック通知
			case AJCLBXN_ERRSPACE:		p->OnNtcErrSpace	();											break;	//	メモリ不足通知
			case AJCLBXN_KILLFOCUS:		p->OnNtcKillFocus	();											break;	//	フォーカス喪失通知
			case AJCLBXN_SELCANCEL:		p->OnNtcSelCancel	();											break;	//	選択キャンセル通知
			case AJCLBXN_SELCHANGE:		p->OnNtcSelChange	();											break;	//	選択変更通知
			case AJCLBXN_SETFOCUS:		p->OnNtcSetFocus	();											break;	//	フォーカス取得通知
			case AJCLBXN_RCLICK:		p->OnNtcRClick		(AjcLbxGetNtcRClk		 ((HWND)lParam));	break;	//	右クリック通知
			case AJCLBXN_REMOVED:		p->OnNtcRemoved		(AjcLbxGetNtcRemovedItems((HWND)lParam));	break;	//	削除通知
			case AJCLBXN_DROPDIR:		p->OnNtcDropDir		(AjcLbxGetNtcDirs		 ((HWND)lParam));	break;	//	ディレクトリドロップ通知
			case AJCLBXN_DROPFILE:		p->OnNtcDropFile	(AjcLbxGetNtcFiles		 ((HWND)lParam));	break;	//	ファイルドロップ通知
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_LBX);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_LBX, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_LBX);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_LBX)
	AJC_WNDMAP_MSG(SBC_LBX, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_LBX, WM_DESTROY	   )
AJC_WNDMAP_END


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxLbx::CAjxLbx(BOOL fUnicode) 
{
	m_fUnicode = fUnicode;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxLbx::~CAjxLbx()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	全リストボックス項目データの配列取得(ASCII)
UI				CAjxLbx::GetAllItems	(PAJCLBXITEMA *pArr)
{
	UI		rc = 0;

	if (pArr != NULL) {
		*pArr = AjcLbxGetAllItemsA(m_hCtrl, &rc);
	}
	return rc;
}
//	全リストボックス項目データの配列取得(UNICODE)
UI				CAjxLbx::GetAllItems	(PAJCLBXITEMW *pArr)
{
	UI		rc = 0;

	if (pArr != NULL) {
		*pArr = AjcLbxGetAllItemsW(m_hCtrl, &rc);
	}
	return rc;
}
//	取得した全リストボックス項目の配列解放
VO				CAjxLbx::RelAllItems	(VOP pAllItemBuf)
{
	return AjcLbxRelAllItems(pAllItemBuf);
}
//	全選択項目の配列取得(ASCII)
UI				CAjxLbx::GetSelectedItems(PAJCLBXITEMA *pArr)
{
	UI		rc = 0;

	if (pArr != NULL) {
		*pArr = AjcLbxGetSelectedItemsA(m_hCtrl, &rc);
	}
	return rc;
}
//	全選択項目の配列取得(UNICODE)
UI				CAjxLbx::GetSelectedItems(PAJCLBXITEMW *pArr)
{
	UI		rc = 0;

	if (pArr != NULL) {
		*pArr = AjcLbxGetSelectedItemsW(m_hCtrl, &rc);
	}
	return rc;
}
//	取得した選択項目の配列解放
VO				CAjxLbx::RelSelectedItems(VOP pSelectedItemBuf)
{
	return AjcLbxRelSelectedItems(pSelectedItemBuf);
}
//	プロファイルから全リストボックス項目の読出し(ASCII)
BOOL			CAjxLbx::LoadItems		(C_BCP pSect, C_BCP pKeyPrefix)
{
	return AjcLbxLoadItemsA(m_hCtrl, pSect, pKeyPrefix);
}
//	プロファイルから全リストボックス項目の読出し(UNICODE)
BOOL			CAjxLbx::LoadItems		(C_WCP pSect, C_WCP pKeyPrefix)
{
	return AjcLbxLoadItemsW(m_hCtrl, pSect, pKeyPrefix);
}
//	プロファイルへ全リストボックス項目の書込み(ASCII)
BOOL			CAjxLbx::SaveItems	(C_BCP pSect, C_BCP pKeyPrefix)
{
	return AjcLbxSaveItemsA(m_hCtrl, pSect, pKeyPrefix);
}
//	プロファイルへ全リストボックス項目の書込み(UNICODE)
BOOL			CAjxLbx::SaveItems	(C_WCP pSect, C_WCP pKeyPrefix)
{
	return AjcLbxSaveItemsW(m_hCtrl, pSect, pKeyPrefix);
}
//	ツールチップの設定(ASCII)
BOOL			CAjxLbx::SetTipText		(C_BCP pTxt)
{
	return AjcLbxSetTipTextA(m_hCtrl, pTxt);
}
//	ツールチップの設定(UNICODE)
BOOL			CAjxLbx::SetTipText		(C_WCP pTxt)
{
	return AjcLbxSetTipTextW(m_hCtrl, pTxt);
}
//	ツールチップの取得(ASCII)
BOOL			CAjxLbx::GetTipText		(BCP pBuf, UI lBuf)
{
	return AjcLbxGetTipTextA(m_hCtrl, pBuf, lBuf);
}
//	ツールチップの取得(UNICODE)
BOOL			CAjxLbx::GetTipText		(WCP pBuf, UI lBuf)
{
	return AjcLbxGetTipTextW(m_hCtrl, pBuf, lBuf);
}
//	ツールチップ表示条件の設定
BOOL			CAjxLbx::SetTipShowAlways(BOOL fShowAlways)
{
	return AjcLbxSetTipShowAlways(m_hCtrl, fShowAlways);
}
//	ツールチップ表示条件の取得
BOOL			CAjxLbx::GetTipShowAlways()
{
	return AjcLbxGetTipShowAlways(m_hCtrl);
}
//	リストボックス項目の追加(ASCII)
int				CAjxLbx::AddString		(C_BCP pStr)
{
	return AjcLbxAddStringA(m_hCtrl, pStr);
}
//	リストボックス項目の追加(UNICODE)
int				CAjxLbx::AddString		(C_WCP pStr)
{
	return AjcLbxAddStringW(m_hCtrl, pStr);
}
//	リストボックス項目の挿入(ASCII)
int				CAjxLbx::InsertString	(UI ix, C_BCP pStr)
{
	return AjcLbxInsertStringA(m_hCtrl, ix, pStr);
}
//	リストボックス項目の挿入(UNICODE)
int				CAjxLbx::InsertString	(UI ix, C_WCP pStr)
{
	return AjcLbxInsertStringW(m_hCtrl, ix, pStr);
}
//	リストボックス項目の削除
int				CAjxLbx::DeleteString	(UI ix)
{
	return AjcLbxDeleteString(m_hCtrl, ix);
}
//	リストボックス項目の検索(ASCII)
int				CAjxLbx::FindString		(UI ix, C_BCP pStr)
{
	return AjcLbxFindStringA(m_hCtrl, ix, pStr);
}
//	リストボックス項目の検索(UNICODE)
int				CAjxLbx::FindString		(UI ix, C_WCP pStr)
{
	return AjcLbxFindStringW(m_hCtrl, ix, pStr);
}
//	リストボックス項目の項目数取得
int	 			CAjxLbx::GetCount		()
{
	return AjcLbxGetCount(m_hCtrl);
}
//	選択されているリストボックス項目のインデクス取得
int				CAjxLbx::GetCurSel		()
{
	return AjcLbxGetCurSel(m_hCtrl);
}
//	リストボックス項目の選択状態取得
BOOL			CAjxLbx::GetSel			(UI ix)
{
	return AjcLbxGetSel(m_hCtrl, ix);
}
//	選択されているリストボックス項目の個数取得
int				CAjxLbx::GetSelCount		()
{
	return AjcLbxGetSelCount(m_hCtrl);
}
//	リストボックス項目の取得(ASCII)
BOOL			CAjxLbx::GetText			(UI ix, BCP pBuf, UI lBuf)
{
	return AjcLbxGetTextA(m_hCtrl, ix, pBuf, lBuf);
}
//	リストボックス項目の取得(UNICODE)
BOOL			CAjxLbx::GetText			(UI ix, WCP pBuf, UI lBuf)
{
	return AjcLbxGetTextW(m_hCtrl, ix, pBuf, lBuf);
}
//	リストボックス項目の文字列長取得
int				CAjxLbx::GetTextLen		(UI ix)
{
	int		rc = 0;
	if (m_fUnicode) rc = AjcLbxGetTextLenW(m_hCtrl, ix);
	else			rc = AjcLbxGetTextLenA(m_hCtrl, ix);
	return rc;
}
//	全リストボックス項目の消去
BOOL			CAjxLbx::ResetContent	()
{
	return AjcLbxResetContent(m_hCtrl);
}
//	リストボックス項目の選択(ASCII)
int				CAjxLbx::SelectString	(UI ix, C_BCP pStr)
{
	return AjcLbxSelectStringA(m_hCtrl, ix, pStr);
}
//	リストボックス項目の選択(UNICODE)
int				CAjxLbx::SelectString	(UI ix, C_WCP pStr)
{
	return AjcLbxSelectStringW(m_hCtrl, ix, pStr);
}
//	リストボックス項目数の設定
BOOL			CAjxLbx::SetCount		(UI count)
{
	return AjcLbxSetCount(m_hCtrl, count);
}
//	リストボックス項目の選択
BOOL			CAjxLbx::SetCurSel		(UI ix)
{
	return AjcLbxSetCurSel(m_hCtrl, ix);
}
//	リストボックス項目の選択／非選択状態設定
BOOL			CAjxLbx::SetSel			(UI ix, BOOL fSelect)
{
	return AjcLbxSetSel(m_hCtrl, ix, fSelect);
}
//	リストボックス項目に関連付けられた数値の設定
BOOL			CAjxLbx::SetItemData		(UI ix, UX data)
{
	return AjcLbxSetItemData(m_hCtrl, ix, data);
}
//	リストボックス項目に関連付けられた数値の取得
UX				CAjxLbx::GetItemData		(UI ix)
{
	return AjcLbxGetItemData(m_hCtrl, ix);
}
//	相対アドレス変換時のベースディレクトリパス設定(ASCII)
BOOL			CAjxLbx::SetBasePath		(C_BCP pBasePath)
{
	return AjcLbxSetBasePathA(m_hCtrl, pBasePath);
}
//	相対アドレス変換時のベースディレクトリパス設定(UNICODE)
BOOL			CAjxLbx::SetBasePath		(C_WCP pBasePath)
{
	return AjcLbxSetBasePathW(m_hCtrl, pBasePath);
}
//	右クリック通知設定
BOOL			CAjxLbx::SetNtcRClk		(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	return AjcLbxSetNtcRClk(m_hCtrl, fNtcRClk, MsgRBDown, MsgRBUp);
}
//	ファイル選択時のフィルタ，デフォルト拡張子の設定(ASCII)
BOOL			CAjxLbx::SetFileFilter	(C_BCP pFilter, C_BCP pDefExt)
{
	return AjcLbxSetFileFilterA(m_hCtrl, pFilter, pDefExt);
}
//	ファイル選択時のフィルタ，デフォルト拡張子の設定(UBICODE)
BOOL			CAjxLbx::SetFileFilter	(C_WCP pFilter, C_WCP pDefExt)
{
	return AjcLbxSetFileFilterW(m_hCtrl, pFilter, pDefExt);
}
//	ドロップされたファイルのパス名を取得(ASCII)
BOOL			CAjxLbx::GetDroppedFile	(BC buf[MAX_PATH])
{
	return AjcLbxGetDroppedFileA(m_hCtrl, buf);
}
//	ドロップされたファイルのパス名を取得(UNICODE)
BOOL			CAjxLbx::GetDroppedFile	(WC buf[MAX_PATH])
{
	return AjcLbxGetDroppedFileW(m_hCtrl, buf);
}
//	ドロップされたディレクトリのパス名を取得(ASCII)
BOOL			CAjxLbx::GetDroppedDir	(BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return AjcLbxGetDroppedDirExA(m_hCtrl, buf, fTailIsDelimiter);
}
//	ドロップされたディレクトリのパス名を取得(UNICODE)
BOOL			CAjxLbx::GetDroppedDir	(WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return AjcLbxGetDroppedDirExW(m_hCtrl, buf, fTailIsDelimiter);
}
//	削除された項目の文字列を取得(ASCII)
BOOL			CAjxLbx::GetRemovedItem	(BCP pBuf, UI lBuf)
{
	return AjcLbxGetRemovedItemA(m_hCtrl, pBuf, lBuf);
}
//	削除された項目の文字列を取得(UNICODE)
BOOL			CAjxLbx::GetRemovedItem	(WCP pBuf, UI lBuf)
{
	return AjcLbxGetRemovedItemW(m_hCtrl, pBuf, lBuf);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxLbx::Attach(HWND hwnd)
{
	HWND	hParent;
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hwnd)) {
		::GetClassNameA(hwnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrlListBox") == 0) {
			//	ワーク初期化
			m_hCtrl = hwnd;
			hParent = ::GetParent(hwnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_LBX, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("LBX cannot be generated due to an invalid window class.");
	}
	else throw std::runtime_error("LBX cannot be generated due to an invalid window handle.");
}
//	ダブルクリック通知
VO		CAjxLbx::OnNtcDblClk			()
{
}
//	選択キャンセル通知
VO		CAjxLbx::OnNtcSelCancel			()
{
}
//	選択変更通知
VO		CAjxLbx::OnNtcSelChange			()
{
}
//	フォーカス取得通知
VO		CAjxLbx::OnNtcSetFocus			()
{
}
//	フォーカス喪失通知
VO		CAjxLbx::OnNtcKillFocus			()
{
}
//	右クリック通知
VO		CAjxLbx::OnNtcRClick			(PAJCLBXRCLK pRClk)
{
}
//	項目削除通知
VO		CAjxLbx::OnNtcRemoved			(UI n)
{
}
//	ディレクトリドロップ通知
VO		CAjxLbx::OnNtcDropDir			(UI n)
{
}
//	ファイルロップ通知
VO		CAjxLbx::OnNtcDropFile			(UI n)
{
}
//	メモリ不足通知
VO		CAjxLbx::OnNtcErrSpace			()
{
}
