﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ファイル読み出し）																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	UI CALLBACK cbRead(UX xp, VOP pBuf, UI lBuf)
{
	CAjxLzh*	p = (CAjxLzh*)xp;
	return p->OnRead(pBuf, lBuf);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ファイル読み出し位置設定）																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbSeek(UX xp, UL ofs)
{
	CAjxLzh*	p = (CAjxLzh*)xp;
	p->OnSeek(ofs);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxLzh::CAjxLzh() 
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxLzh::~CAjxLzh()
{
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	書庫内のファイル名検索（初回, ASCII）
HAJCLZH		CAjxLzh::FindFirst	(C_BCP pWild, UI flag)
{
	return AjcLzhFindFirstA(pWild, flag, (UX)this, cbRead, cbSeek);
}
//	書庫内のファイル名検索（初回, UNICODE）
HAJCLZH		CAjxLzh::FindFirst	(C_WCP pWild, UI flag)
{
	return AjcLzhFindFirstW(pWild, flag, (UX)this, cbRead, cbSeek);
}
//	書庫内のファイル名検索（２回目以降）
BOOL		CAjxLzh::FindNext	(HAJCLZH hLzh)
{
	return AjcLzhFindNext(hLzh);
}
//	書庫内のファイルオープン(ASCII)
HAJCLZH		CAjxLzh::Open		(C_BCP pFilePath, UI flag)
{
	return AjcLzhOpenA(pFilePath, flag, (UX)this, cbRead, cbSeek);
}
//	書庫内のファイルオープン(UNICODE)
HAJCLZH		CAjxLzh::Open		(C_WCP pFilePath, UI flag)
{
	return AjcLzhOpenW(pFilePath, flag, (UX)this, cbRead, cbSeek);
}
//	書庫内のファイル読み出し
UI			CAjxLzh::Read		(HAJCLZH hLzh, VOP pBuf, UI lBuf)
{
	return AjcLzhRead(hLzh, pBuf, lBuf);
}
//	書庫アクセスのクローズ
VO			CAjxLzh::Close		(HAJCLZH hLzh)
{
	return AjcLzhClose(hLzh);
}
//	検索したファイル情報取得(ASCII)
BOOL		CAjxLzh::GetFileInfo	(HAJCLZH hLzh, PAJCLZHFILEINFOA pBuf)
{
	return AjcLzhGetFileInfoA(hLzh, pBuf);
}
//	検索したファイル情報取得(UNICODE)
BOOL		CAjxLzh::GetFileInfo	(HAJCLZH hLzh, PAJCLZHFILEINFOW pBuf)
{
	return AjcLzhGetFileInfoW(hLzh, pBuf);
}
//	エラーコード取得
AJCLZHERR	CAjxLzh::GetLastError()
{
	return AjcLzhGetLastError();
}

