﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード削除通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemove(VOP pNodeData, UI len, UX cbp)
{
	CAjxMbx*	p = (CAjxMbx*)cbp;
	if (!p->m_fDestruct) {
		p->OnNtcRemove(pNodeData);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxMbx::CAjxMbx() 
{
	m_DefSize   = 0;
	m_fDestruct = FALSE;
	if ((m_hMbx = AjcVMbxCreate ((UX)this, cbRemove)) == NULL) {
		throw std::runtime_error("MBX cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxMbx::~CAjxMbx()
{
	if (m_hMbx != NULL) {
		m_fDestruct = TRUE;
		AjcVMbxDelete(m_hMbx);
		m_hMbx = NULL;
	}
}
//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	ノードデータの規定バイト数設定
VO				CAjxMbx::SetDefSize(UI DefSize)
{
	m_DefSize = DefSize;
}
//	ノードデータの規定バイト数取得
UI				CAjxMbx::GetDefSize()
{
	return m_DefSize;
}
//	ノードを末尾へ追加
BOOL			CAjxMbx::Enque	(C_VOP pDat, UI lDat)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcVMbxEnque(m_hMbx, pDat, lDat);
}
//	ノードを先頭へ挿入
BOOL			CAjxMbx::EnqTop(C_VOP pDat, UI lDat)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcVMbxEnqTop(m_hMbx, pDat, lDat);
}
//	先頭ノード取り出し
UI				CAjxMbx::Deque(VOP pBuf, UI lBuf, UI msTime)
{
	if (lBuf == -1) lBuf = m_DefSize;
	return AjcVMbxDequeEx(m_hMbx, pBuf, lBuf, msTime);
}
//	全ノード消去
VO			CAjxMbx::Purge	()
{
	AjcVMbxPurge(m_hMbx);
}
//	ノードの個数取得
UI				CAjxMbx::GetCount()
{
	return AjcVMbxGetCount(m_hMbx);
}
//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	ノード削除通知
VO		CAjxMbx::OnNtcRemove		(VOP pNodeData)
{
}
