﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（イベント通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbNtc(AJCPPCNOTIFY ntc, UX p1, UX p2, UX p3, UX cbp)
{
	CAjxPpc*	p = (CAjxPpc*)cbp;
	switch (ntc) {
		//	いずれかのイベントが発生したことを通知
		case AJCPPC_NTC_ANYEVT:		p->OnNtcAnyEvt		((AJCPPCNOTIFY)p1);							break;
		//	ファイル名，行番号通知
		case AJCPPC_NTC_FILE_LNO:	p->OnNtcFileLno		((C_BCP)p1, (UI)p2, (UI)p3);				break;
		//	インクルードファイル検索開始通知
		case AJCPPC_NTC_SRH_START:	p->OnNtcSrhStart	((C_BCP)p1, (C_BCP)p2);						break;
		//	インクルードファイル検索中のフォルダ通知
		case AJCPPC_NTC_SRH_DIR:	p->OnNtcSrhDir		((C_BCP)p1);								break;
		//	インクルードファイル検索終了通知
		case AJCPPC_NTC_SRH_END:	p->OnNtcSrhEnd		((C_BCP)p1, (BOOL)p2);						break;
		//	プリプロセス用オプションシンボル通知
		case AJCPPC_NTC_OPTSYM:		p->OnNtcOptSym		((PCAJCPPCTKNNODE)p1);						break;
		//	マクロ定義通知
		case AJCPPC_NTC_MACDEF:		p->OnNtcMacDef		((PCAJCPPCTKNNODE)p1, (PCAJCPPCMACINFO)p2);	break;
		//	マクロ参照通知
		case AJCPPC_NTC_MACREF:		p->OnNtcMacRef		((PCAJCPPCTKNNODE)p1, (PCAJCPPCMACINFO)p2);	break;
		//	トークンストリームをファイルへ出力中通知
		case AJCPPC_NTC_OUTLOOP:	p->OnNtcOutLoop		();											break;
		//	ソースファイルのテキストエンコード通知
		case AJCPPC_NTC_SRCTEC:		p->OnNtcSrcTec		((C_BCP)p1, (EAJCTEC)p2, (BOOL)p3);			break;
		//	トークン通知
		case AJCPPC_NTC_TOKEN:		p->OnNtcToken		((EAJCTKCODE)p1, (C_BCP)p2);				break;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（エラー通知）																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbErr(AJCPPCERROR err, UX p1, UX p2, UX p3, UX cbp)
{
	BC		ErrTxt[256];

	CAjxPpc*	p = (CAjxPpc*)cbp;
	AjcSnPrintF(ErrTxt, sizeof ErrTxt, "%s", AjcPpcGetErrMsgText(err, p1, p2, p3));
	p->OnNtcError(err, (C_BCP)p1, (UI)p2, (C_BCP)ErrTxt);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（マクロ列挙）																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcMacInfo (PCAJCPPCMACINFO pMacInfo, UX cbp)
{
	CAjxPpc*	p = (CAjxPpc*)cbp;
	return p->OnNtcMacInfo(pMacInfo);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxPpc::CAjxPpc() 
{
	m_hPpc = NULL;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxPpc::~CAjxPpc()
{
	if (m_hPpc != NULL) {
		AjcPpcDelete(m_hPpc);
		m_hPpc = NULL;
	}
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	プリコンパイル実行
AJCPPCRESULT	CAjxPpc::PreCompile(	C_BCP pSrcPath	,
							EAJCTEC			tecSrc		,
							C_BCP			pBasePath	,
							PAJCLBXITEMA	pIncPath	,
							PAJCLBXITEMA	pOptSym		,
							UI				opt			)
{
	AJCPPCRESULT	rc = AJCPPCR_PARAM;
	//	生成済インスタンス破棄
	if (m_hPpc != NULL) {
		AjcPpcDelete(m_hPpc);
	}
	do {
		//	ＰＰＣインスタンス生成
		if ((m_hPpc = AjcPpcCreate(pBasePath, pIncPath, pOptSym, (UX)this, cbNtc, cbErr)) == NULL)	break;
		if (!AjcPpcSetOption	(m_hPpc, opt    ))													break;
		if (!AjcPpcSetTextEncode(m_hPpc, tecSrc ))													break;
		rc = AjcPpcCompile      (m_hPpc, pSrcPath);
	} while(0);
	return rc;
}
//	プリコンパイル済オブジェクトの取得
PAJCPPCTKNNODE CAjxPpc::GetObject 	(PAJCPPCTKNNODE *ppNoGen)
{
	return AjcPpcGetObject(m_hPpc, ppNoGen);
}
//	プリコンパイル中止
BOOL	CAjxPpc::Stop				()
{
	return AjcPpcStop(m_hPpc);
}
//	マクロ情報取得
BOOL	CAjxPpc::GetMacroInfo		(C_BCP pMacName, PAJCPPCMACINFO pMacInfo)
{
	return AjcPpcGetMacroInfo(m_hPpc, pMacName, pMacInfo);
}
//	マクロ列挙
UI		CAjxPpc::EnumMacro()
{
	return AjcPpcEnumMacro(m_hPpc, (UX)this, cbNtcMacInfo);
}
//	ファイル出力
BOOL	CAjxPpc::TokenStreamToFile	(C_BCP pOutPath,
							 EAJCTEC tecOut,
							 BOOL	 bomOut,
							 BOOL	 fExpInc,
							 UI CommOutOfkndPP)
{
	BOOL	rc = FALSE;
	if (AjcPpcSetTecAtTokenStreamToFile(m_hPpc, tecOut, bomOut)) {
		rc = AjcPpcTokenStreamToFile(m_hPpc, pOutPath, fExpInc, CommOutOfkndPP);
	}
	return rc;
}

//----- 仮想関数 -----------------------------------------------------------------------------------------------//
VO		CAjxPpc::OnNtcAnyEvt	(AJCPPCNOTIFY evt)										{}				//	いずれかのイベント発生
VO		CAjxPpc::OnNtcFileLno	(C_BCP pFile, UI lno, UI nest)							{}				//	ファイル名，行番号通知
VO		CAjxPpc::OnNtcSrhStart	(C_BCP pIncFile, C_BCP pDirPath)						{}				//	インクルードファイル検索開始通知
VO		CAjxPpc::OnNtcSrhDir	(				 C_BCP pDirPath)						{}				//	インクルードファイル検索中のフォルダ通知
VO		CAjxPpc::OnNtcSrhEnd	(C_BCP pIncFile, BOOL fFind)							{}				//	インクルードファイル検索終了通知
VO		CAjxPpc::OnNtcOptSym	(PCAJCPPCTKNNODE pTkn)									{}				//	プリプロセス用オプションシンボル通知
VO		CAjxPpc::OnNtcMacDef	(PCAJCPPCTKNNODE pTkn, PCAJCPPCMACINFO pMac)			{}				//	マクロ定義通知
VO		CAjxPpc::OnNtcMacRef	(PCAJCPPCTKNNODE pTkn, PCAJCPPCMACINFO pMac)			{}				//	マクロ参照通知
VO		CAjxPpc::OnNtcOutLoop	(VO)													{}				//	トークンストリームをファイルへ出力ループ中
VO		CAjxPpc::OnNtcSrcTec	(C_BCP pFilePath, EAJCTEC tec, BOOL fBom)				{}				//	ソースファイルのエンコード通知
VO		CAjxPpc::OnNtcToken		(EAJCTKCODE tkn, C_BCP pTkn)							{}				//	トークン通知
VO		CAjxPpc::OnNtcError		(AJCPPCERROR err, C_BCP pFile, UI lno, C_BCP pErrTxt)	{}				//	エラー通知
BOOL	CAjxPpc::OnNtcMacInfo	(PCAJCPPCMACINFO pMacInfo)								{return FALSE;}	//	マクロ列挙通知
