﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ページ印刷開始通知）																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbQueryPage(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo, UX cbp)
{
	CAjxPrn*	p = (CAjxPrn*)cbp;
	return p->OnQueryPage(pPrnInfo, pPageInfo);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ＤＩＢセクション・ビットマップによる描画コールバック）										//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbDrawByDibSectDC(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp)
{
	CAjxPrn*	p = (CAjxPrn*)cbp;
	return p->OnDrawByDibSectDC(hdc, pPrnInfo, pDibInfo);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（プリンタＤＣによる描画コールバック）															//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbDrawByPrinterDC(HDC hdc, PCAJCPRN_INFO pPrnInfo, UX cbp)
{
	CAjxPrn*	p = (CAjxPrn*)cbp;
	return p->OnDrawByPrinterDC(hdc, pPrnInfo);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxPrn::CAjxPrn(BOOL fUnicode) 
{
	m_fUnicode	= fUnicode;
	m_hWndOwner = NULL;

	//	インスタンス生成
	if (m_hPrn == NULL) {
		if (m_fUnicode) m_hPrn = AjcPrnCreateW();
		else 			m_hPrn = AjcPrnCreateA();
	}
	//	エラーチェック
	if (m_hPrn != NULL) {
		//	コールバック設定
		AjcPrnSetCallbackParam	  (m_hPrn, (UX)this);
		AjcPrnSetCallbackQueryPage(m_hPrn, cbQueryPage);
	}
	else {
		throw std::runtime_error("PRN cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxPrn::~CAjxPrn()
{
	if (m_hPrn != NULL) {
		AjcPrnDelete(m_hPrn);
		m_hPrn = NULL;
	}
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	余白サイズ設定
BOOL	CAjxPrn::SetMargin	(PAJCPRN_MARGIN pmmMargin)
{
	return AjcPrnSetMargin(m_hPrn, pmmMargin);
}
//	プリンタの選択ダイアログ表示
BOOL	CAjxPrn::SelectDialog(PAJCPRN_INFO pInfo, UI Flag, HWND hWndOwner)
{
	return AjcPrnSelectDlg(m_hPrn, pInfo, Flag, hWndOwner);
}
//	印刷ダイアログ表示
BOOL	CAjxPrn::PrintDialog (PAJCPRN_INFO pInfo, PAJCPRN_OPT pOpt, HWND hWndOwner)
{
	return AjcPrnPrintDlg(m_hPrn, pInfo, pOpt, hWndOwner);
}
//	印刷開始
int		CAjxPrn::Start		(BOOL fUseDib, BOOL fOutputToFile)
{
	if (fUseDib) AjcPrnSetCallbackByDibSect(m_hPrn, cbDrawByDibSectDC);
	else		 AjcPrnSetCallbackByPrinter(m_hPrn, cbDrawByPrinterDC);

	return AjcPrnStart(m_hPrn, fOutputToFile);
}
//	プリンタ設定情報取得(ASCII)
VO		CAjxPrn::GetInfo	(PAJCPRN_INFO pBuf, BCP pPrnName, UI lPrnName)
{
	strcpy_s(pPrnName, lPrnName, AjcPrnGetInfoA(m_hPrn, pBuf));
}
//	プリンタ設定情報取得(UNICODE)
VO		CAjxPrn::GetInfo	(PAJCPRN_INFO pBuf, WCP pPrnName, UI lPrnName)
{
	wcscpy_s(pPrnName, lPrnName, AjcPrnGetInfoW(m_hPrn, pBuf));
}
//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	ページ印刷開始通知
BOOL	CAjxPrn::OnQueryPage			(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo)
{
	return FALSE;
}
//	ＤＩＢセクション・ビットマップによる描画
BOOL	CAjxPrn::OnDrawByDibSectDC	(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo)
{
	return FALSE;
}
//	プリンタＤＣによる描画
BOOL	CAjxPrn::OnDrawByPrinterDC	(HDC hdc, PCAJCPRN_INFO pPrnInfo)
{
	return FALSE;
}
