﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード削除通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemove(VOP pNodeData, UI len, UX cbp)
{
	CAjxQue*	p = (CAjxQue*)cbp;
	if (!p->m_fDestruct) {
		p->OnNtcRemove(pNodeData, len);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxQue::CAjxQue() 
{
	m_DefSize   = 0;
	m_fDestruct = FALSE;
	if ((m_hQue = AjcVQueCreate ((UX)this, cbRemove)) == NULL) {
		throw std::runtime_error("QUE cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxQue::~CAjxQue()
{
	if (m_hQue != NULL) {
		m_fDestruct = TRUE;
		AjcVQueDelete(m_hQue);
		m_hQue = NULL;
	}
}
//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	ノードデータの規定バイト数設定
VO				CAjxQue::SetDefSize(UI DefSize)
{
	m_DefSize = DefSize;
}
//	ノードデータの規定バイト数取得
UI				CAjxQue::GetDefSize()
{
	return m_DefSize;
}
//	ノードを末尾へ追加
VOP				CAjxQue::Enque	(C_VOP pDat, UI lDat)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcVQueEnqueEx(m_hQue, pDat, lDat);
}
//	ノードを先頭へ挿入
VOP				CAjxQue::EnqTop(C_VOP pDat, UI lDat)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcVQueEnqTopEx(m_hQue, pDat, lDat);
}
//	先頭ノード取り出し
UI				CAjxQue::Deque(VOP pBuf, UI lBuf)
{
	if (lBuf == -1) lBuf = m_DefSize;
	return AjcVQueDequeEx(m_hQue, pBuf, lBuf);
}
//	全ノード消去
BOOL			CAjxQue::Purge	()
{
	return AjcVQuePurge(m_hQue);
}
//	ノードの個数取得
UI				CAjxQue::GetCount()
{
	return AjcVQueGetCount(m_hQue);
}
//	２つのリストをマージ
BOOL			CAjxQue::Merge	(CAjxQue* pSrc)
{
	return AjcVQueMerge(m_hQue, pSrc->m_hQue);
}
//	先頭ノードアドレス取得
VOP				CAjxQue::TopNode	(UIP pBytes)
{
	return AjcVQueTopNode(m_hQue, pBytes);
}
//	次のノードアドレス取得
VOP				CAjxQue::NextNode(C_VOP pCurrentNode, UIP pBytes)
{
	return AjcVQueNextNode(m_hQue, pCurrentNode, pBytes);
}
//	全ノードへのポインタ配列生成
PCAJCVQUEPTR	CAjxQue::CreatePtrArr (UIP pNum)
{
	return AjcVQueCreatePtrArr(m_hQue, pNum);
}
//	全ノードへのポインタ配列解放
VO	 			CAjxQue::ReleasePtrArr(PCAJCVQUEPTR pArr)
{
	return AjcVQueReleasePtrArr(m_hQue, pArr);
}
//	マルチスレッドの許可／禁止
BOOL			CAjxQue::EnableMultiThread	(BOOL fEnable)
{
	return AjcVQueEnableMultiThread(m_hQue, fEnable);
}
//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	ノード削除通知
VO		CAjxQue::OnNtcRemove		(VOP pNodeData, UI len)
{
}
