﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ノード削除通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemove(VOP pNodeData, UI len, UX cbp)
{
	CAjxXQue*	p = (CAjxXQue*)cbp;
	if (!p->m_fDestruct) {
		p->OnNtcRemove(pNodeData, len);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxXQue::CAjxXQue() 
{
	m_DefSize   = 0;
	m_fDestruct = FALSE;
	if ((m_hXQue = AjcXQueCreate ((UX)this, cbRemove)) == NULL) {
		throw std::runtime_error("QUE cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxXQue::~CAjxXQue()
{
	if (m_hXQue != NULL) {
		m_fDestruct = TRUE;
		AjcXQueDelete(m_hXQue);
		m_hXQue = NULL;
	}
}
//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	ノードデータの規定バイト数設定
VO				CAjxXQue::SetDefSize(UI DefSize)
{
	m_DefSize = DefSize;
}
//	ノードデータの規定バイト数取得
UI				CAjxXQue::GetDefSize()
{
	return m_DefSize;
}
//	ノードを末尾へ追加
VOP				CAjxXQue::Enque	(C_VOP pDat, UI lDat)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcXQueEnque(m_hXQue, pDat, lDat);
}
//	ノードを先頭へ挿入
VOP				CAjxXQue::EnqTop(C_VOP pDat, UI lDat)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcXQueEnqTop(m_hXQue, pDat, lDat);
}
//	ノードを任意の位置へ挿入
VOP				CAjxXQue::Insert(C_VOP pDat, UI lDat, C_VOP pIns)
{
	if (lDat == -1) lDat = m_DefSize;
	return AjcXQueInsert(m_hXQue, pDat, lDat, pIns);
}
//	ノード削除
UI				CAjxXQue::Remove(C_VOP pDat)
{
	return AjcXQueRemove(m_hXQue, pDat);
}
//	先頭ノード取り出し
UI				CAjxXQue::Deque(VOP pBuf, UI lBuf)
{
	if (lBuf == -1) lBuf = m_DefSize;
	return AjcXQueDeque(m_hXQue, pBuf, lBuf);
}
//	全ノード消去
BOOL			CAjxXQue::Purge	()
{
	return AjcXQuePurge(m_hXQue);
}
//	ノードの個数取得
UI				CAjxXQue::GetCount()
{
	return AjcXQueGetCount(m_hXQue);
}
//	２つのリストをマージ
BOOL			CAjxXQue::Merge	(CAjxXQue* pSrc)
{
	return AjcXQueMerge(m_hXQue, pSrc->m_hXQue);
}
//	先頭ノードアドレス取得
VOP				CAjxXQue::TopNode	(UIP pBytes)
{
	return AjcXQueTopNode(m_hXQue, pBytes);
}
//	末尾ノードアドレス取得
VOP				CAjxXQue::LastNode	(UIP pBytes)
{
	return AjcXQueLastNode(m_hXQue, pBytes);
}
//	次のノードアドレス取得
VOP				CAjxXQue::NextNode(C_VOP pCurrentNode, UIP pBytes)
{
	return AjcXQueNextNode(m_hXQue, pCurrentNode, pBytes);
}
//	直前のノードアドレス取得
VOP				CAjxXQue::PrevNode(C_VOP pCurrentNode, UIP pBytes)
{
	return AjcXQuePrevNode(m_hXQue, pCurrentNode, pBytes);
}
//	全ノードへのポインタ配列生成
PCAJCXQUEPTR	CAjxXQue::CreatePtrArr (UIP pNum)
{
	return AjcXQueCreatePtrArr(m_hXQue, pNum);
}
//	全ノードへのポインタ配列解放
VO	 			CAjxXQue::ReleasePtrArr(PCAJCXQUEPTR pArr)
{
	return AjcXQueReleasePtrArr(m_hXQue, pArr);
}
//	マルチスレッドの許可／禁止
BOOL			CAjxXQue::EnableMultiThread	(BOOL fEnable)
{
	return AjcXQueEnableMultiThread(m_hXQue, fEnable);
}
//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	ノード削除通知
VO		CAjxXQue::OnNtcRemove		(VOP pNodeData, UI len)
{
}
