﻿#include	<AjxCpp.h>
using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	シリアル通信																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//

#define	WM_SCPEVENT	(WM_APP + 10)

extern	HINSTANCE	hDllInst;
static	ATOM		atmClass	= 0;

AJC_WNDPROC_DEF(ScpEvtWndProc);
static	VO	SubCallVirtualFunc(CAjxScp* p, WPARAM wParam, LPARAM lParam);

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	起動時初期設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
BOOL	IniScp(VO)
{
	BOOL		rc = FALSE;
	WNDCLASSA	wc = {0};

	wc.style		 = 0;								wc.hCursor		 = LoadCursor(NULL, IDC_ARROW); 
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(ScpEvtWndProc);	wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.cbWndExtra	 = sizeof(VOP);						wc.lpszClassName = "CAjxScpEvtWnd";
	wc.hInstance	 = hDllInst;
	if ((atmClass = RegisterClassA(&wc)) != 0) {
		rc = TRUE;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	終了時後処理																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
VO		EndScp(VO)
{
	if (atmClass != 0) {
		UnregisterClassA((BCP)atmClass, hDllInst);
		atmClass = 0;
	}
}



using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxScp::CAjxScp() 
{
	m_hScp		= NULL;				//	ＳＣＰインスタンスドハンドル
	m_Atom		= 0;				//	イベント通知用クラスハンドル
	m_hWndEvt	= NULL;				//	イベント通知用ウインド
	m_fUnicode	= 0;				//	UNICODEフラグ

	//	イベント受信用ダミーウインド生成
	if ((m_hWndEvt = CreateWindowA( "CAjxScpEvtWnd", 								// window class
									"",												// window caption
									WS_OVERLAPPEDWINDOW,							// window style
									0, 0, 0, 0, 									// position, size
									NULL, NULL, hDllInst, (VOP)this)) != NULL) {	// parent, menu, instance, param
		ShowWindow(m_hWndEvt, SW_HIDE);
	}
	else throw std::runtime_error("SCP event window cannot creation.");
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxScp::~CAjxScp()
{
	if (m_hScp	  != NULL) {AjcScpDelete(m_hScp);		m_hScp	  = NULL;}
	if (m_hWndEvt != NULL) {DestroyWindow(m_hWndEvt);	m_hWndEvt = NULL;}
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	初期設定(ASCII)
BOOL	CAjxScp::Init	(C_BCP pSect, AJCSCP_CHUNKMODE ChunkMode, BOOL fUseWaitEvent, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot)
{
	BOOL	rc = FALSE;

	//	UNICODE識別フラグ設定
	m_fUnicode = FALSE;

	//	生成済ＳＣＰインスタンス消去
	if (m_hScp != NULL) {
		AjcScpDelete(m_hScp);
	}
	//	ＳＣＰインスタンス生成
	if ((m_hScp = AjcScpCreateExA(pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot)) != NULL) {
		if (fUseWaitEvent) rc = AjcScpSetMode(m_hScp, NULL	   , 0			, ChunkMode);
		else			   rc = AjcScpSetMode(m_hScp, m_hWndEvt, WM_SCPEVENT, ChunkMode);
	}
	return rc;
}
//	初期設定(UNICODE)
BOOL	CAjxScp::Init	(C_WCP pSect, AJCSCP_CHUNKMODE ChunkMode, BOOL fUseWaitEvent, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot)
{
	BOOL	rc = FALSE;

	//	UNICODE識別フラグ設定
	m_fUnicode = TRUE;

	//	生成済ＳＣＰインスタンス消去
	if (m_hScp != NULL) {
		AjcScpDelete(m_hScp);
	}
	//	ＳＣＰインスタンス生成
	if ((m_hScp = AjcScpCreateExW(pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot)) != NULL) {
		if (fUseWaitEvent) rc = AjcScpSetMode(m_hScp, NULL	   , 0			, ChunkMode);
		else			   rc = AjcScpSetMode(m_hScp, m_hWndEvt, WM_SCPEVENT, ChunkMode);
	}
	return rc;
}

//	ポートオープン（ＣＯＭポート）
BOOL				CAjxScp::Open						(UI Port, UI Rate, UI DataBits, UI Parity, UI StopBit)
{
	return AjcScpOpen(m_hScp, Port, Rate, DataBits, Parity, StopBit);;
}
//	ポートオープン（ＣＯＭポート，DCB, TIMEOUT指定）
BOOL				CAjxScp::Open						(UI Port, LPDCB pDcb, LPCOMMTIMEOUTS pTmo)
{
	return AjcScpOpenEx(m_hScp, Port, pDcb, pTmo);
}
//	ポートオープン（メールスロット，ASCII）
BOOL				CAjxScp::Open						(C_BCP pRmtHost, C_BCP pRmtSlot)
{
	return AjcScpOpenSlotA(m_hScp, pRmtHost, pRmtSlot);
}
//	ポートオープン（メールスロット，UNICODE）
BOOL				CAjxScp::Open						(C_WCP pRmtHost, C_WCP pRmtSlot)
{
	return AjcScpOpenSlotW(m_hScp, pRmtHost, pRmtSlot);
}
//	ポートオープン（ソケット，ASCII）
BOOL				CAjxScp::Open						(C_BCP pServ, UI PortNo)
{
	return AjcScpOpenSockA(m_hScp, pServ, PortNo);
}
//	ポートオープン（ソケット，UNICODE）
BOOL				CAjxScp::Open						(C_WCP pServ, UI PortNo)
{
	return AjcScpOpenSockW(m_hScp, pServ, PortNo);
}
//	ポートオープン（選択済通信リソース）
BOOL				CAjxScp::Open						()
{
	return AjcScpOpenDefault(m_hScp);;
}
//	ポートオープン（初回通信リソース選択）
BOOL				CAjxScp::Open						(AJCSCP_PORTSEL sel)
{
	return AjcScpOpenSelect(m_hScp, sel);
}
//	ポートクローズ
BOOL				CAjxScp::Close						()
{
	return AjcScpClose(m_hScp);
}
//	設定されている通信ポート種別取得
UI					CAjxScp::GetSelectedPort			()
{
	return AjcScpGetSelectedPort(m_hScp);
}
//	ポートオープン状態取得
UI					CAjxScp::IsOpened					()
{
	return AjcScpIsOpened(m_hScp);
}
//	１文字送信(ASCII)
BOOL				CAjxScp::SendChar					(BC code)
{
	return AjcScpSendCharA(m_hScp, code);
}
//	１文字送信(UNICODE)
BOOL				CAjxScp::SendChar					(WC code)
{
	return AjcScpSendCharW(m_hScp, code);
}
//	バイトペアによるワード（14Bit）データ送信 (Low byte first)
BOOL				CAjxScp::SendWord14LF				(UI data)
{
	return AjcScpSendWord14LF(m_hScp, data);
}
//	バイトペアによるワード（14Bit）データ送信 (High byte first)
BOOL				CAjxScp::SendWord14HF				(UI data)
{
	return AjcScpSendWord14HF(m_hScp, data);
}
//	１４ビットワードデータ（バイトペア）受信時のバイト順設定
BOOL				CAjxScp::SetByteSeqRxWord14			(BOOL fLowByteFirst)
{
	return AjcScpSetByteSeqRxWord14(m_hScp, fLowByteFirst);
}
//	１４ビットワードデータ（バイトペア）受信時のバイト順取得
BOOL				CAjxScp::GetByteSeqRxWord14			()
{
	return AjcScpGetByteSeqRxWord14 (m_hScp);
}
//	テキストデータ送信(ASCII)
BOOL				CAjxScp::SendText					(C_BCP pTxt, UI lTxt)
{
	return AjcScpSendTextA(m_hScp, pTxt, lTxt);
}
//	テキストデータ送信(UNICODE)
BOOL				CAjxScp::SendText					(C_WCP pTxt, UI lTxt)
{
	return AjcScpSendTextW(m_hScp, pTxt, lTxt);
}
//	書式テキストデータ送信(ASCII)
BOOL				CAjxScp::SendTextF					(C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC		txt[2048] = {0};

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcScpSendTextA(m_hScp, txt, -1);
	}
	return rc;
}
//	書式テキストデータ送信(UNICODE)
BOOL				CAjxScp::SendTextF					(C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	WC		txt[2048] = {0};

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf_s(txt, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcScpSendTextW(m_hScp, txt, -1);
	}
	return rc;
}
//	バイナリデータ送信
BOOL				CAjxScp::SendBinData				(C_VOP pDat, UI lDat)
{
	return AjcScpSendBinData(m_hScp, pDat, lDat);
}
//	パケットデータ送信
UI					CAjxScp::SendPacket					(C_VOP pPkt, UI lPkt)
{
	return AjcScpSendPacket(m_hScp, pPkt, lPkt);
}
//	ブレーク信号送出／停止
BOOL				CAjxScp::SendBreak					(BOOL fBreak)
{
	return AjcScpSendBreak(m_hScp, fBreak);
}
//	イベントマスク設定
BOOL				CAjxScp::SetEvtMask					(UI Mask)
{
	return AjcScpSetEvtMask(m_hScp, Mask);
}
//	イベントマスク取得
UI					CAjxScp::GetEvtMask					()
{
	return AjcScpGetEvtMask(m_hScp);
}
//	ＤＴＲ信号設定
BOOL				CAjxScp::SetDTR						(BOOL fActive)
{
	return AjcScpSetDTR(m_hScp, fActive);
}
//	ＲＴＳ信号設定
BOOL				CAjxScp::SetRTS						(BOOL fActive)
{
	return AjcScpSetRTS(m_hScp, fActive);
}
//	信号状態取得
UI					CAjxScp::GetSigState				()
{
	return AjcScpGetSigState(m_hScp);
}
//	送信待ちデータバイト数取得
ULL					CAjxScp::GetTxBytes					()
{
	return AjcScpGetTxBytes(m_hScp);
}
//	全受信済データ破棄
BOOL				CAjxScp::PurgeRecvData				()
{
	return AjcScpPurgeRecvData(m_hScp);
}
//	全送信待ちデータ破棄
BOOL				CAjxScp::PurgeSendData				()
{
	return AjcScpPurgeSendData(m_hScp);
}
//	全送受信データ破棄
BOOL				CAjxScp::PurgeAllData				()
{
	return AjcScpPurgeAllData(m_hScp);
}
//	ＤＣＢ情報とタイムアウト情報設定
BOOL				CAjxScp::SetParam					(const DCB *pDcb, const COMMTIMEOUTS *pTmo)
{
	return AjcScpSetParam(m_hScp, pDcb, pTmo);
}
//	ＤＣＢ情報とタイムアウト情報取得
UI					CAjxScp::GetParam					(LPDCB pDcb, LPCOMMTIMEOUTS pTmo)
{
	return AjcScpGetParam(m_hScp, pDcb, pTmo);
}
//	イベント発生待ち
BOOL				CAjxScp::WaitEvent					(UI msTime)
{
	BOOL	rc = FALSE;
	WPARAM	wParam;
	LPARAM	lParam;
	if (rc = AjcScpWaitEvent(m_hScp, &wParam, &lParam, msTime)) {
		SubCallVirtualFunc(this, wParam, lParam);
	}
	return rc;
}
//	パケットフレームを認識する為の制御コード設定
BOOL				CAjxScp::SetPktCtrlCode				(UI stx, UI etx, UI dle)
{
	return AjcScpSetPktCtrlCode(m_hScp, stx, etx, dle);
}
//	パケットフレームを認識する為の制御コード取得
BOOL				CAjxScp::GetPktCtrlCode				(UIP pStx, UIP pEtx, UIP pDle)
{
	return AjcScpGetPktCtrlCode(m_hScp, pStx, pEtx, pDle);
}
//	パケットフレーム受信タイムアウト値設定
BOOL				CAjxScp::SetPktTimeout				(UI msTime)
{
	return AjcScpSetPktTimeout(m_hScp, msTime);
}
//	パケットフレーム受信タイムアウト値取得
BOOL				CAjxScp::GetPktTimeout				(UIP pMsTime)
{
	return AjcScpGetPktTimeout(m_hScp, pMsTime);
}
//	通信パラメタ設定ダイアログによるＣＯＭポート の選択許可／禁止
BOOL				CAjxScp::EnableComPortSelection		(BOOL fEnableComPort)
{
	return AjcScpEnableComPortSelection(m_hScp, fEnableComPort);
}
//	通信パラメタ設定ダイアログによるメールスロットの選択許可／禁止
BOOL				CAjxScp::EnableMailslotSelection	(BOOL fEnableMailSlot)
{
	return AjcScpEnableMailslotSelection(m_hScp, fEnableMailSlot);
}
//	通信パラメタ設定ダイアログによるソケット通信 の選択許可／禁止
BOOL				CAjxScp::EnableSocketSelection		(BOOL fEnableSocket)
{
	return AjcScpEnableSocketSelection(m_hScp, fEnableSocket);
}
//	ＣＯＭポート、メールスロット，およびソケット通信の選択許可／禁止
BOOL				CAjxScp::EnablePortSelection		(BOOL fEnableComPort, BOOL fEnableMailSlot, BOOL fEnableSocket)
{
	return AjcScpEnablePortSelectionEx(m_hScp, fEnableComPort, fEnableMailSlot, fEnableSocket);
}
//	ダイアログによる通信パラメタ設定
UI					CAjxScp::DlgParamEasy				(HWND hWndOwner)
{
	return AjcScpDlgParamEasy (m_hScp, hWndOwner);
}
//	ダイアログによる通信パラメタ設定（ウインド位置指定）
UI					CAjxScp::DlgParamEasy				(HWND hWndOwner, int x, int y)
{
	return AjcScpDlgParamEasyEx(m_hScp, hWndOwner, x, y);
}
//	ダイアログによるＣＯＭポート通信パラメタ詳細設定
UI					CAjxScp::DlgParamDetail				(HWND hWndOwner)
{
	return AjcScpDlgParamDetail(m_hScp, hWndOwner);
}
//	ダイアログによるＣＯＭポート通信パラメタ詳細設定（ウインド位置指定）
UI					CAjxScp::DlgParamDetailEx			(HWND hWndOwner, int x, int y)
{
	return AjcScpDlgParamDetailEx(m_hScp, hWndOwner, x, y);
}
//	ポートパス名称取得(ASCII)
VO					CAjxScp::GetPortPathName			(BCP *pPathName)
{
	if (pPathName != NULL) {
		*pPathName = AjcScpGetPortPathNameA(m_hScp);
	}
}
//	ポートパス名称取得(UNICODE)
VO					CAjxScp::GetPortPathName			(WCP *pPathName)
{
	if (pPathName != NULL) {
		*pPathName = AjcScpGetPortPathNameW(m_hScp);
	}
}
//	ポート名称取得(ASCII)
VO					CAjxScp::GetPortName				(BCP *pName)
{
	if (pName != NULL) {
		*pName = AjcScpGetPortNameA(m_hScp);
	}
}
//	ポート名称取得(UNICODE)
VO					CAjxScp::GetPortName				(WCP *pName)
{
	if (pName != NULL) {
		*pName = AjcScpGetPortNameW(m_hScp);
	}
}
//	チャンクデータの通知モード設定
BOOL				CAjxScp::SetChunkMode				(AJCSCP_CHUNKMODE ChunkMode)
{
	return AjcScpSetChunkMode(m_hScp, ChunkMode);
}
//	チャンクデータの通知モード取得
AJCSCP_CHUNKMODE	CAjxScp::GetChunkMode				()
{
	return AjcScpGetChunkMode(m_hScp);
}
//	受信テキストの文字コード種別設定
BOOL				CAjxScp::SetRxTextCode				(AJCSCP_TEXTCODE code)
{
	return AjcScpSetRxTextCode(m_hScp, code);
}
//	受信テキストの文字コード種別取得
AJCSCP_TEXTCODE		CAjxScp::GetRxTextCode				()
{
	return AjcScpGetRxTextCode(m_hScp);
}
//	送信テキストの文字コード種別設定
BOOL				CAjxScp::SetTxTextCode				(AJCSCP_TEXTCODE code)
{
	return AjcScpSetTxTextCode(m_hScp, code);
}
//	送信テキストの文字コード種別取得
AJCSCP_TEXTCODE		CAjxScp::GetTxTextCode				()
{
	return AjcScpGetTxTextCode(m_hScp);
}
//	実際の受信テキストの文字コード種別取得
AJCSCP_TEXTCODE		CAjxScp::GetActualRxTextCode		()
{
	return AjcScpGetActualRxTextCode(m_hScp);
}
//	実際の送信テキストの文字コード種別取得
AJCSCP_TEXTCODE		CAjxScp::GetActualTxTextCode		()
{
	return AjcScpGetActualTxTextCode(m_hScp);
}
//	自メールスロット生成
BOOL				CAjxScp::CreateMySlot				()
{
	return AjcScpCreateMySlot(m_hScp);
}
//	自メールスロット消去
BOOL				CAjxScp::DeleteMySlot				()
{
	return AjcScpDeleteMySlot(m_hScp);
}
//	自メールスロット生成状態取得
BOOL				CAjxScp::MySlotIsCreated			()
{
	return AjcScpMySlotIsCreated(m_hScp);
}
//	自メールスロットのパス名取得(ASCII)
VO					CAjxScp::GetMySlotPathName			(BCP *pPathName)
{
	if (pPathName != NULL) {
		*pPathName = AjcScpGetMySlotPathNameA(m_hScp);
	}
}
//	自メールスロットのパス名取得(UNICODE)
VO					CAjxScp::GetMySlotPathName			(WCP *pPathName)
{
	if (pPathName != NULL) {
		*pPathName = AjcScpGetMySlotPathNameW(m_hScp);
	}
}
//	自コンピュータ名取得(ASCII)
BOOL				CAjxScp::GetMyComputerName			(BC pBuf[AJCMAX_HOSTNAME_LENGTH])
{
	return AjcScpGetMyComputerNameA(m_hScp, pBuf);
}
//	自コンピュータ名取得(UNICODE)
BOOL				CAjxScp::GetMyComputerName			(WC pBuf[AJCMAX_HOSTNAME_LENGTH])
{
	return AjcScpGetMyComputerNameW(m_hScp, pBuf);
}
//	メールスロット名情報設定(ASCII)
BOOL				CAjxScp::SetMailSlotNames			(C_BCP pMySlot, C_BCP pRmyHost, C_BCP pRmtSlot)
{
	return AjcScpSetMailSlotNamesA(m_hScp, pMySlot, pRmyHost, pRmtSlot);
}
//	メールスロット名情報設定(UNICODE)
BOOL				CAjxScp::SetMailSlotNames			(C_WCP pMySlot, C_WCP pRmyHost, C_WCP pRmtSlot)
{
	return AjcScpSetMailSlotNamesW(m_hScp, pMySlot, pRmyHost, pRmtSlot);
}
//	メールスロット名情報取得(ASCII)
BOOL				CAjxScp::GetMailSlotNames			(BC pMySlot[64], BC pRmyHost[AJCMAX_HOSTNAME_LENGTH], BC pRmtSlot[64])
{
	return AjcScpGetMailSlotNamesA(m_hScp, pMySlot, pRmyHost, pRmtSlot);
}
//	メールスロット名情報取得(UNICODE)
BOOL				CAjxScp::GetMailSlotNames			(WC pMySlot[64], WC pRmyHost[AJCMAX_HOSTNAME_LENGTH], WC pRmtSlot[64])
{
	return AjcScpGetMailSlotNamesW(m_hScp, pMySlot, pRmyHost, pRmtSlot);
}
//	メールスロット送信制限速度の設定
BOOL				CAjxScp::SetTxSpeedLimit			(BOOL flag, UI bps)
{
	return AjcScpSetTxSpeedLimit(m_hScp, flag, bps);
}
//	メールスロット送信制限速度の取得
BOOL				CAjxScp::GetTxSpeedLimit			(UIP pBps)
{
	return AjcScpGetTxSpeedLimit(m_hScp, pBps);
}


//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	ポート状態通知(ASCII)
VO	CAjxScp::OnNtcPortState	(C_BCP pPortName, UI Param)
{
}
//	ポート状態通知(UNICODE)
VO	CAjxScp::OnNtcPortState	(C_WCP pPortName, UI Param)
{
}
//	テキストチャンク受信通知(ASCII)
VO	CAjxScp::OnNtcRxTextChunk(C_BCP pText)
{
}
//	テキストチャンク受信通知(UNICODE)
VO	CAjxScp::OnNtcRxTextChunk(C_WCP pText)
{
}
//	バイナリチャンク受信通知
VO	CAjxScp::OnNtcRxBinChunk(C_VOP pData, UI Bytes)
{
}
//	テキスト受信通知(ASCII)
VO	CAjxScp::OnNtcRxText	(C_BCP pText)
{
}
//	テキスト受信通知(UNICODE)
VO	CAjxScp::OnNtcRxText	(C_WCP pText)
{
}
//	ＥＳＣシーケンス受信通知(ASCII)
VO	CAjxScp::OnNtcRxEsc		(C_BCP pData)
{
}
//	ＥＳＣシーケンス受信通知(UNICODE)
VO	CAjxScp::OnNtcRxEsc		(C_WCP pData)
{
}
//	制御コード受信通知
VO	CAjxScp::OnNtcRxCtrl	(UI Ctrl)
{
}
//	パケット受信通知
VO	CAjxScp::OnNtcRxPkt		(C_VOP pData, UI Bytes)
{
}
//	送信完了通知
VO	CAjxScp::OnNtcTxEmpty	()
{
}
//	パケット外データ受信通知
VO	CAjxScp::OnNtcRxNoPkt	(C_BCP pText)
{
}
//	パケット外データ受信通知
VO	CAjxScp::OnNtcRxNoPkt	(C_WCP pText)
{
}
//	不正テキストチャンク受信通知
VO	CAjxScp::OnNtcInvChunk	(C_VOP pData, UI lData)
{
}
//	通信エラー発生通知
VO	CAjxScp::OnNtcErr		(UI param)
{
}
//	BREAK検出通知
VO	CAjxScp::OnNtcBreak		()
{
}
//	RING変化通知
VO	CAjxScp::OnNtcRing		(UI param)
{
}
//	RLSD変化通知
VO	CAjxScp::OnNtcRlsd		(UI param)
{
}
//	DSR 変化通知
VO	CAjxScp::OnNtcDsr		(UI param)
{
}
//	CTS 変化通知
VO	CAjxScp::OnNtcCts		(UI param)
{
}
//	バイトペアによるワード(14Bit)受信通知
VO	CAjxScp::OnNtcRxWord14	(UW data)
{
}

//----- スタティック関数 ---------------------------------------------------------------------------------------//
//	ＣＯＭポートの列挙
UI					CAjxScp::EnumSerialPorts			(UBP pMap, UI lMap, UI CurrentPort)
{
	return AjcScpEnumSerialPorts(pMap, lMap, CurrentPort);;
}
//	ＣＯＭポートのデバイス名取得(ASCII)
int					CAjxScp::GetPortDevName				(C_BCP pPortName, BCP pBuf, UI lBuf)
{
	return AjcScpGetPortDevNameA(pPortName, pBuf, lBuf);
}
//	ＣＯＭポートのデバイス名取得(UNICODE)
int					CAjxScp::GetPortDevName				(C_WCP pPortName, WCP pBuf, UI lBuf)
{
	return AjcScpGetPortDevNameW(pPortName, pBuf, lBuf);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＳＣＰイベント用ウインドプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(ScpEvtWndProc, WM_CREATE 	)
{
	CAjxScp* p = (CAjxScp*)(((LPCREATESTRUCT)lParam)->lpCreateParams);

	MAjcSetWindowLong(hwnd, 0, (UX)p);

	return TRUE;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(ScpEvtWndProc, WM_DESTROY	)
{
	CAjxScp* p = (CAjxScp*)MAjcGetWindowLong(hwnd, 0);
	return 0;
}
//----- WM_SCPEVENT --------------------------------------------------------------------------------------------//
AJC_WNDPROC(ScpEvtWndProc, WM_SCPEVENT	)
{
	CAjxScp* p = (CAjxScp*)MAjcGetWindowLong(hwnd, 0);
	SubCallVirtualFunc(p, wParam, lParam);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(ScpEvtWndProc)
	AJC_WNDMAP_MSG(ScpEvtWndProc, WM_CREATE	)
	AJC_WNDMAP_MSG(ScpEvtWndProc, WM_DESTROY )
	AJC_WNDMAP_MSG(ScpEvtWndProc, WM_SCPEVENT)
AJC_WNDMAP_END

//----- イベント通知（仮想関数コール）--------------------------------------------------------------------------//
static	VO	SubCallVirtualFunc(CAjxScp* p, WPARAM wParam, LPARAM lParam)
{
	union	{VOP vop; BCP bcp; WCP wcp; UBP ubp; UWP uwp;} u;
	UI		len, param;

	AjcScpGetEventData(p->m_hScp, lParam, &u.vop, &len, &param);

	//----- ポート状態通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_PORTSTATE) != 0) {
		if (p->m_fUnicode) p->OnNtcPortState(u.wcp, param);
		else			   p->OnNtcPortState(u.bcp, param);
	}
	//----- チャンクデータ受信通知 （バイナリ）-----------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXCHUNK  ) != 0  &&  param == 0) {
		p->OnNtcRxBinChunk(u.vop, len);
	}
	//----- チャンクデータ受信通知（テキスト）------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXCHUNK  ) != 0  &&  param != 0) {
		if (p->m_fUnicode) p->OnNtcRxTextChunk(u.wcp);
		else			   p->OnNtcRxTextChunk(u.bcp);
	}
	//----- テキスト受信通知 -----------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXTEXT   ) != 0) {
		if (p->m_fUnicode) p->OnNtcRxText(u.wcp);
		else			   p->OnNtcRxText(u.bcp);
	}
	//----- ＥＳＣコード受信通知 -------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXESC	  ) != 0) {
		if (p->m_fUnicode) p->OnNtcRxEsc(u.wcp);
		else			   p->OnNtcRxEsc(u.bcp);
	}
	//----- 制御コード受信通知 ---------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXCTRL   ) != 0) {
		p->OnNtcRxCtrl(*u.bcp);
	}
	//----- パケットデータ受信通知 -----------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXPKT	  ) != 0) {
		p->OnNtcRxPkt(u.vop, len);
	}
	//----- 送信完了 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_TXEMPTY  ) != 0) {
		p->OnNtcTxEmpty();
	}
	//----- パケット外テキスト受信 -----------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXNOPKT  ) != 0) {
		if (p->m_fUnicode) p->OnNtcRxNoPkt(u.wcp);
		else			   p->OnNtcRxNoPkt(u.bcp);
	}
	//----- 不正チャンクテキスト受信 ---------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_INVCHUNK) != 0) {
		p->OnNtcInvChunk(u.vop, len);
	}
	//----- エラー通知 -----------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_ERR	  ) != 0) {
		p->OnNtcErr(param);
	}
	//----- RING変化通知 ---------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RING	  ) != 0) {
		p->OnNtcRing(param);
	}
	//----- RLSD変化通知 ---------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RLSD	  ) != 0) {
		p->OnNtcRlsd(param);
	}
	//----- DSR変化通知 ----------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_DSR	  ) != 0) {
		p->OnNtcDsr(param);
	}
	//----- CTS変化通知 ----------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_CTS	  ) != 0) {
		p->OnNtcCts(param);
	}
	//----- バイトペアによるワード(14Bit値)受信 ----------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXWORD14 ) != 0) {
		p->OnNtcRxWord14(*u.uwp);
	}

	AjcScpRelEventData(p->m_hScp, lParam);

}
