﻿#include	<AjxCpp.h>
using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ソケット通信（クライアント側）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//

#define	WM_SCTEVENT	(WM_APP + 10)

extern	HINSTANCE	hDllInst;
static	ATOM		atmClass	= 0;

AJC_WNDPROC_DEF(SctEvtWndProc);
static	VO	SubCallVirtualFunc(CAjxSct* p, WPARAM wParam, LPARAM lParam);

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	起動時初期設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
BOOL	IniSct(VO)
{
	BOOL		rc = FALSE;
	WNDCLASSA	wc = {0};

	wc.style		 = 0;								wc.hCursor		 = LoadCursor(NULL, IDC_ARROW); 
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(SctEvtWndProc);	wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.cbWndExtra	 = sizeof(VOP);						wc.lpszClassName = "CAjxSctEvtWnd";
	wc.hInstance	 = hDllInst;
	if ((atmClass = RegisterClassA(&wc)) != 0) {
		rc = TRUE;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	終了時後処理																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
VO		EndSct(VO)
{
	if (atmClass != 0) {
		UnregisterClassA((BCP)atmClass, hDllInst);
		atmClass = 0;
	}
}



using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSct::CAjxSct() 
{
	m_hSct		= NULL;				//	ＳＣＰインスタンスドハンドル
	m_Atom		= 0;				//	イベント通知用クラスハンドル
	m_hWndEvt	= NULL;				//	イベント通知用ウインド
	m_fUnicode	= 0;				//	UNICODEフラグ

	//	イベント受信用ダミーウインド生成
	if ((m_hWndEvt = CreateWindowA( "CAjxSctEvtWnd", 								// window class
									"",												// window caption
									WS_OVERLAPPEDWINDOW,							// window style
									0, 0, 0, 0, 									// position, size
									NULL, NULL, hDllInst, (VOP)this)) != NULL) {	// parent, menu, instance, param
		ShowWindow(m_hWndEvt, SW_HIDE);
		//	ＳＣＴインスタンス生成
		if ((m_hSct = AjcSctCreate()) == NULL) {
			throw std::runtime_error("SCT instance cannot creation.");
		}
	}
	else throw std::runtime_error("SCT event window cannot creation.");
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSct::~CAjxSct()
{
	if (m_hSct	  != NULL) {AjcSctDelete(m_hSct);		m_hSct	  = NULL;}
	if (m_hWndEvt != NULL) {DestroyWindow(m_hWndEvt);	m_hWndEvt = NULL;}
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	回線接続(ASCII)
BOOL	CAjxSct::Connect(C_BCP pServ, C_BCP pPort, int AddressFamily, BOOL fUseWaitEvent)
{
	BOOL	rc = FALSE;

	//	UNICODE識別フラグ設定
	m_fUnicode = FALSE;

	if (fUseWaitEvent) rc = AjcSctConnectA(m_hSct, pServ, pPort, AddressFamily, NULL	  , 0		  );
	else			   rc = AjcSctConnectA(m_hSct, pServ, pPort, AddressFamily, m_hWndEvt, WM_SCTEVENT);

	return rc;
}
//	回線接続(UNICODE)
BOOL	CAjxSct::Connect(C_WCP pServ, C_WCP pPort, int AddressFamily, BOOL fUseWaitEvent)
{
	BOOL	rc = FALSE;

	//	UNICODE識別フラグ設定
	m_fUnicode = TRUE;

	if (fUseWaitEvent) rc = AjcSctConnectW(m_hSct, pServ, pPort, AddressFamily, NULL	  , 0		  );
	else			   rc = AjcSctConnectW(m_hSct, pServ, pPort, AddressFamily, m_hWndEvt, WM_SCTEVENT);

	return rc;
}
//	回線切断
BOOL				CAjxSct::Disconnect		(UI msTimeout)
{
	return AjcSctDisconnectEx(m_hSct, msTimeout);
}
//	回線状態取得
AJCSCT_STATE		CAjxSct::GetState		()
{
	return AjcSctGetState(m_hSct);
}
//	チャンクデータの受信モード設定
BOOL				CAjxSct::SetChunkMode	(AJCSCT_CHUNKMODE ChunkMode)
{
	return AjcSctSetChunkMode(m_hSct, ChunkMode);
}
//	チャンクデータの受信モード取得
AJCSCT_CHUNKMODE	CAjxSct::GetChunkMode	()
{
	return AjcSctGetChunkMode(m_hSct);
}
//	イベントマスク設定
BOOL				CAjxSct::SetEvtMask		(UI EvtMsk)
{
	return AjcSctSetEvtMask(m_hSct, EvtMsk);
}
//	イベントマスク取得
UI		 			CAjxSct::GetEvtMask		()
{
	return AjcSctGetEvtMask(m_hSct);
}
//	受信テキストの文字コード設定
BOOL				CAjxSct::SetRxTextCode	(AJCSCT_TEXTCODE code)
{
	return AjcSctSetRxTextCode(m_hSct, code);
}
//	受信テキストの文字コード取得
AJCSCT_TEXTCODE		CAjxSct::GetRxTextCode	()
{
	return AjcSctGetRxTextCode(m_hSct);
}
//	送信テキストの文字コード設定
BOOL				CAjxSct::SetTxTextCode	(AJCSCT_TEXTCODE code)
{
	return AjcSctSetTxTextCode(m_hSct, code);
}
//	送信テキストの文字コード取得
AJCSCT_TEXTCODE		CAjxSct::GetTxTextCode	()
{
	return AjcSctGetTxTextCode(m_hSct);
}
//	実際の受信テキストの文字コード取得
AJCSCT_TEXTCODE		CAjxSct::GetActualRxTextCode()
{
	return AjcSctGetActualRxTextCode(m_hSct);
}
//	実際の送信テキストの文字コード取得
AJCSCT_TEXTCODE		CAjxSct::GetActualTxTextCode()
{
	return AjcSctGetActualTxTextCode(m_hSct);
}
//	イベント発生待ち
BOOL				CAjxSct::WaitEvent		(UI msTime)
{
	BOOL	rc = FALSE;
	WPARAM	wParam;
	LPARAM	lParam;
	if (rc = AjcSctWaitEvent(m_hSct, &wParam, &lParam, msTime)) {
		SubCallVirtualFunc(this, wParam, lParam);
	}
	return rc;
}
//	パケットフレームを認識する為の制御コード設定
BOOL				CAjxSct::SetPktCtrlCode	(UI stx, UI etx, UI dle)
{
	return AjcSctSetPktCtrlCode(m_hSct, stx, etx, dle);
}
//	パケットフレームを認識する為の制御コード取得
BOOL				CAjxSct::GetPktCtrlCode	(UIP pStx, UIP pEtx, UIP pDle)
{
	return AjcSctGetPktCtrlCode(m_hSct, pStx, pEtx, pDle);
}
//	パケットフレーム受信タイムアウト値設定
BOOL				CAjxSct::SetPktTimeout	(UI msTime)
{
	return AjcSctSetPktTimeout(m_hSct, msTime);
}
//	パケットフレーム受信タイムアウト値取得
BOOL				CAjxSct::GetPktTimeout	(UIP pMsTime)
{
	return AjcSctGetPktTimeout(m_hSct, pMsTime);
}
//	１文字送信(ASCII)
BOOL				CAjxSct::SendChar		(BC code)
{
	return AjcSctSendCharA(m_hSct, code);
}
//	１文字送信(UNICODE)
BOOL				CAjxSct::SendChar		(WC code)
{
	return AjcSctSendCharW(m_hSct, code);
}
//	テキストデータ送信(ASCII)
BOOL				CAjxSct::SendText		(C_BCP pTxt, UI lTxt)
{
	return AjcSctSendTextA(m_hSct, pTxt, lTxt);
}
//	テキストデータ送信(UNICODE)
BOOL				CAjxSct::SendText		(C_WCP pTxt, UI lTxt)
{
	return AjcSctSendTextW(m_hSct, pTxt, lTxt);
}
//	書式テキスト送信(ASCII)
BOOL				CAjxSct::SendTextF		(C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC		txt[2048] = {0};

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcSctSendTextA(m_hSct, txt, -1);
	}
	return rc;
}
//	書式テキスト送信(UNICODE)
BOOL				CAjxSct::SendTextF		(C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	WC		txt[2048] = {0};

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf_s(txt, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcSctSendTextW(m_hSct, txt, -1);
	}
	return rc;
}
//	バイナリデータ送信
BOOL				CAjxSct::SendBinData	(C_VOP pDat, UI lDat)
{
	return AjcSctSendBinData(m_hSct, pDat, lDat);
}
//	パケットデータ送信
UI					CAjxSct::SendPacket		(C_VOP pPkt, UI lPkt)
{
	return AjcSctSendPacket(m_hSct, pPkt, lPkt);
}
//	全受信済データ破棄
BOOL				CAjxSct::PurgeRecvData	()
{
	return AjcSctPurgeRecvData(m_hSct);
}
//	全送信待ちデータ破棄
BOOL				CAjxSct::PurgeSendData	()
{
	return AjcSctPurgeSendData(m_hSct);
}
//	全送受信データ破棄
BOOL				CAjxSct::PurgeAllData	()
{
	return AjcSctPurgeAllData(m_hSct);
}

//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	接続通知
VO	CAjxSct::OnNtcConnect		()
{
}
//	切断通知
VO	CAjxSct::OnNtcDisconnect	()
{
}
//	テキストチャンク受信通知(ASCII)
VO	CAjxSct::OnNtcRxTextChunk	(C_BCP pText)
{
}
//	テキストチャンク受信通知(UNICODE)
VO	CAjxSct::OnNtcRxTextChunk	(C_WCP pText)
{
}
//	バイナリチャンク受信通知
VO	CAjxSct::OnNtcRxBinChunk	(C_VOP pData, UI Bytes)
{
}
//	テキスト受信通知(ASCII)
VO	CAjxSct::OnNtcRxText		(C_BCP pText)
{
}
//	テキスト受信通知(UNICODE)
VO	CAjxSct::OnNtcRxText		(C_WCP pText)
{
}
//	ＥＳＣシーケンス受信通知(ASCII)
VO	CAjxSct::OnNtcRxEsc			(C_BCP pData)
{
}
//	ＥＳＣシーケンス受信通知(UNICODE)
VO	CAjxSct::OnNtcRxEsc			(C_WCP pData)
{
}
//	制御コード受信通知
VO	CAjxSct::OnNtcRxCtrl		(UI Ctrl)
{
}
//	パケット受信通知
VO	CAjxSct::OnNtcRxPkt			(C_VOP pData, UI Bytes)
{
}
//	送信完了通知
VO	CAjxSct::OnNtcTxEmpty		()
{
}
//	パケット外データ受信通知(ASCII)
VO	CAjxSct::OnNtcRxNoPkt		(C_BCP pText)
{
}
//	パケット外データ受信通知(UNICODE)
VO	CAjxSct::OnNtcRxNoPkt		(C_WCP pText)
{
}
//	不正テキストチャンク受信通知
VO	CAjxSct::OnNtcInvChunk		(C_VOP pData, UI lData)
{
}
//	接続失敗通知
VO	CAjxSct::OnNtcCnErr			(UI param)
{
}
//	受信エラー発生通知
VO	CAjxSct::OnNtcRxErr			(UI param)
{
}
//	送信エラー発生通知
VO	CAjxSct::OnNtcTxErr			(UI param)
{
}
//	エラー発生通知
VO	CAjxSct::OnNtcErr			(UI param)
{
}


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＳＣＴイベント用ウインドプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SctEvtWndProc, WM_CREATE 	)
{
	CAjxSct* p = (CAjxSct*)(((LPCREATESTRUCT)lParam)->lpCreateParams);

	MAjcSetWindowLong(hwnd, 0, (UX)p);

	return TRUE;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SctEvtWndProc, WM_DESTROY	)
{
	CAjxSct* p = (CAjxSct*)MAjcGetWindowLong(hwnd, 0);
	return 0;
}
//----- WM_SCTEVENT --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SctEvtWndProc, WM_SCTEVENT	)
{
	CAjxSct* p = (CAjxSct*)MAjcGetWindowLong(hwnd, 0);
	SubCallVirtualFunc(p, wParam, lParam);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SctEvtWndProc)
	AJC_WNDMAP_MSG(SctEvtWndProc, WM_CREATE	)
	AJC_WNDMAP_MSG(SctEvtWndProc, WM_DESTROY )
	AJC_WNDMAP_MSG(SctEvtWndProc, WM_SCTEVENT)
AJC_WNDMAP_END

//----- イベント通知（仮想関数コール）--------------------------------------------------------------------------//
static	VO	SubCallVirtualFunc(CAjxSct* p, WPARAM wParam, LPARAM lParam)
{
	union	{VOP vop; BCP bcp; WCP wcp; UBP ubp; UWP uwp;} u;
	UI		len, param;

	AjcSctGetEventData(p->m_hSct, lParam, &u.vop, &len, &param);

	//----- 接続通知 -------------------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_CONNECT		) != 0) {
		p->OnNtcConnect();
	}
	//----- 切断通知 -------------------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_DISCONNECT	) != 0) {
		p->OnNtcDisconnect();
	}
	//----- チャンクデータ受信通知（バイナリ）------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXCHUNK		) != 0	&&	param == 0) {
		p->OnNtcRxBinChunk(u.vop, len);
	}
	//----- チャンクデータ受信通知（テキスト）------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXCHUNK		) != 0	&&	param != 0) {
		if (p->m_fUnicode) p->OnNtcRxTextChunk(u.wcp);
		else			   p->OnNtcRxTextChunk(u.bcp);
	}
	//----- テキストデータ通知 ---------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXTEXT		) != 0) {
		if (p->m_fUnicode) p->OnNtcRxText(u.wcp);
		else			   p->OnNtcRxText(u.bcp);
	}
	//----- ＥＳＣコードデータ通知 -----------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXESC		) != 0) {
		if (p->m_fUnicode) p->OnNtcRxEsc(u.wcp);
		else			   p->OnNtcRxEsc(u.bcp);
	}
	//----- 	制御コード通知 ---------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXCTRL		) != 0) {
		p->OnNtcRxCtrl(*u.bcp);
	}
	//----- パケットデータ通知 ---------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXPKT		) != 0) {
		p->OnNtcRxPkt(u.vop, len);
	}
	//----- 送信完了通知 ---------------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_TXEMPTY		) != 0) {
		p->OnNtcTxEmpty();
	}
	//----- パケット外テキスト ---------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXNOPKT		) != 0) {
		if (p->m_fUnicode) p->OnNtcRxNoPkt(u.wcp);
		else			   p->OnNtcRxNoPkt(u.bcp);
	}
	//----- 不正チャンクテキスト受信通知 -----------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_INVCHUNK	) != 0) {
		p->OnNtcInvChunk(u.vop, len);
	}
	//----- 接続失敗通知 ---------------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_CNFAIL		) != 0) {
		p->OnNtcCnErr(param);
	}
	//----- 受信エラー通知 -------------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_RXERR		) != 0) {
		p->OnNtcRxErr(param);
	}
	//----- 送信エラー通知 -------------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_TXERR		) != 0) {
		p->OnNtcTxErr(param);
	}
	//----- その他のエラー通知 ---------------------------------------------------------------------------------//
	if ((wParam & AJCSCT_EV_ERR			) != 0) {
		p->OnNtcErr(param);
	}

	AjcSctRelEventData(p->m_hSct, lParam);
}
