﻿#include	<AjxCpp.h>

using namespace AjxControl;

//==============================================================================================================//
//																												//
//	AjxSplA(ASCII)クラス																						//
//																												//
//==============================================================================================================//
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（列挙文字列通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcStrA(C_BCP pStr, UX cbp)
{
	CAjxSpl*	p = (CAjxSpl*)cbp;
	return p->OnNtcStr(pStr);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcStrW(C_WCP pStr, UX cbp)
{
	CAjxSpl*	p = (CAjxSpl*)cbp;
	return p->OnNtcStr(pStr);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSpl::CAjxSpl(BOOL fUnicode) 
{
	if (m_fUnicode = fUnicode) m_hSpl = AjcSplCreateW(AJCCMP_ALPHABETIC);
	else					   m_hSpl = AjcSplCreateA(AJCCMP_ALPHABETIC);

	if (m_hSpl == NULL) {
		throw std::runtime_error("SPL cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSpl::~CAjxSpl()
{
	if (m_hSpl != NULL) {
		AjcSplDelete(m_hSpl);
		m_hSpl = NULL;
	}
}

//	比較モード設定
BOOL		CAjxSpl::SetCompMode	(EAJCCMPMODE CmpMode)
{
	return	AjcSplSetCompMode(m_hSpl, CmpMode);
}
//	比較モード取得
EAJCCMPMODE	CAjxSpl::GetCompMode	()
{
	return	AjcSplGetCompMode(m_hSpl);
}


//	文字列プールへ文字列登録(ASCII)
C_BCP		CAjxSpl::Regist		(C_BCP pStr)
{
	return	AjcSplRegistA(m_hSpl, pStr);
}
//	文字列プールへ文字列登録(UNICODE)
C_WCP		CAjxSpl::Regist		(C_WCP pStr)
{
	return	AjcSplRegistW(m_hSpl, pStr);
}


//	文字列プールから文字列を検索(ASCII)
C_BCP		CAjxSpl::Find			(C_BCP pStr)
{
	return	AjcSplFindA(m_hSpl, pStr);
}
//	文字列プールから文字列を検索(UNICODE)
C_WCP		CAjxSpl::Find			(C_WCP pStr)
{
	return	AjcSplFindW(m_hSpl, pStr);
}


//	部分文字列一致検索（文字列プールから指定部分文字列が一致するノード検索）(ASCII)
C_BCP		CAjxSpl::PartStrInPool	(C_BCP pPartStr, AJCSPL_INSTROPT opt)
{
	return	AjcSplPartStrInPoolA(m_hSpl, pPartStr, opt);
}
//	部分文字列一致検索（文字列プールから指定部分文字列が一致するノード検索）(UNICODE)
C_WCP		CAjxSpl::PartStrInPool	(C_WCP pPartStr, AJCSPL_INSTROPT opt)
{
	return	AjcSplPartStrInPoolW(m_hSpl, pPartStr, opt);
}


//	部分文字列一致検索（指定文字列が文字列プール中の部分文字列と一致するかチェック）(ASCII)
C_BCP		CAjxSpl::PoolStrInStr	(C_BCP pStr    , AJCSPL_INSTROPT opt)
{
	return	AjcSplPoolStrInStrA(m_hSpl, pStr, opt);
}
//	部分文字列一致検索（指定文字列が文字列プール中の部分文字列と一致するかチェック）(UNICODE)
C_WCP		CAjxSpl::PoolStrInStr	(C_WCP pStr    , AJCSPL_INSTROPT opt)
{
	return	AjcSplPoolStrInStrW(m_hSpl, pStr, opt);
}


//	文字列プールから文字列を削除(ASCII)
BOOL		CAjxSpl::Remove		(C_BCP pStr)
{
	return	AjcSplRemoveA(m_hSpl, pStr);
}
//	文字列プールから文字列を削除(UNICODE)
BOOL		CAjxSpl::Remove		(C_WCP pStr)
{
	return	AjcSplRemoveW(m_hSpl, pStr);
}


//	登録済文字列数取得
UI			CAjxSpl::GetCount		()
{
	return	AjcSplGetCount(m_hSpl);
}
//	文字列プールをリセット
BOOL		CAjxSpl::Reset			()
{
	return	AjcSplReset(m_hSpl);
}
//	登録済み全文字列の取得(列挙)
UI			CAjxSpl::EnumStr		(BOOL fDownSeq)
{
	UI		rc = 0;
	if (m_fUnicode) rc = AjcSplEnumStrW(m_hSpl, (UX)this, cbNtcStrW, fDownSeq);
	else			rc = AjcSplEnumStrA(m_hSpl, (UX)this, cbNtcStrA, fDownSeq);
	return rc;
}
//	ＡＶＬ２分木のハンドルを取得
HAJCAVL		CAjxSpl::GetAvlHandle()
{
	return	AjcSplGetAvlHandle(m_hSpl);
}

//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	列挙文字列通知(ASCII)
BOOL		CAjxSpl::OnNtcStr	(C_BCP pStr)
{
	return FALSE;
}
//	列挙文字列通知(UNICODE)
BOOL		CAjxSpl::OnNtcStr	(C_WCP pStr)
{
	return FALSE;
}

