﻿#include	<AjxCpp.h>
using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ソケット通信（サーバ側）個々のクライアント処理																//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ／デストラクタ																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSsvCli::CAjxSsvCli()							//	コンストラクタ
{
}
CAjxSsvCli::~CAjxSsvCli()							//	デストラクタ
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数（クライアント処理）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	クライアントハンドル設定
VO		CAjxSsvCli::SetCliHandle	(HAJCSSVCLI hCli)
{
	m_hCli = hCli;
}

//	ＩＰアドレス文字列取得(ASCII)
C_BCP	CAjxSsvCli::GetIpAddrStr	(BCP pBuf, UI lBuf)
{
	return AjcSsvGetIpAddrStrA(m_hCli, pBuf, lBuf);
}
//	ＩＰアドレス文字列取得(UNICODE)
C_WCP	CAjxSsvCli::GetIpAddrStr	(WCP pBuf, UI lBuf)
{
	return AjcSsvGetIpAddrStrW(m_hCli, pBuf, lBuf);
}
//	実際の受信テキストの文字コード取得
AJCSSV_TEXTCODE	CAjxSsvCli::GeActualtRxTextCode()
{
	return AjcSsvGetActualRxTextCode(m_hCli);
}
//	実際の送信テキストの文字コード取得
AJCSSV_TEXTCODE	CAjxSsvCli::GetActualTxTextCode()
{
	return AjcSsvGetActualTxTextCode(m_hCli);
}

//	クライアントへ１文字送信(ASCII)
BOOL	CAjxSsvCli::SendChar		(BC code)
{
	return AjcSsvSendCharA(m_hCli, code);
}
//	クライアントへ１文字送信(UNICODE)
BOOL	CAjxSsvCli::SendChar		(WC code)
{
	return AjcSsvSendCharW(m_hCli, code);
}
//	クライアントへテキストデータ送信(ASCII)
BOOL	CAjxSsvCli::SendText		(C_BCP pTxt, UI lTxt)
{
	return AjcSsvSendText(m_hCli, pTxt, lTxt);
}
//	クライアントへテキストデータ送信(UNICODE)
BOOL	CAjxSsvCli::SendText		(C_WCP pTxt, UI lTxt)
{
	return AjcSsvSendTextW(m_hCli, pTxt, lTxt);
}
//	クライアントへ書式テキスト送信(ASCII)
BOOL	CAjxSsvCli::SendTextF		(C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcSsvSendTextA(m_hCli, txt, -1);
	}
	return rc;
}
//	クライアントへ書式テキスト送信(UNICODE)
BOOL	CAjxSsvCli::SendTextF		(C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	WC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf_s(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcSsvSendTextW(m_hCli, txt, -1);
	}
	return rc;
}
//	クライアントへバイナリデータ送信
BOOL	CAjxSsvCli::SendBinData		(C_VOP pDat, UI lDat)
{
	return AjcSsvSendBinData(m_hCli, pDat, lDat);
}
//	クライアントへパケットデータ送信
UI		CAjxSsvCli::SendPacket		(C_VOP pPkt, UI lPkt)
{
	return AjcSsvSendPacket(m_hCli, pPkt, lPkt);
}
//	全受信済データ破棄
BOOL	CAjxSsvCli::PurgeRecvData	()
{
	return AjcSsvPurgeRecvData(m_hCli);
}
//	全送信待ちデータ破棄
BOOL	CAjxSsvCli::PurgeSendData	()
{
	return AjcSsvPurgeSendData(m_hCli);
}
//	全受信済データと送信待ちデータ破棄
BOOL	CAjxSsvCli::PurgeAllData	()
{
	return AjcSsvPurgeAllData(m_hCli);
}
//	クライアントにデータを関連付ける
BOOL	CAjxSsvCli::SetClientData				(UX data)
{
	return AjcSsvSetClientData		(m_hCli, data);
}
//	クライアントに関連付けたデータ取得
UX		CAjxSsvCli::GetClientData				()
{
	UX		rc = 0;
	AjcSsvGetClientData(m_hCli, &rc);
	return rc;
}
//	クライアント接続順序番号取得
UI		CAjxSsvCli::GetSeqNo		()
{
	return AjcSsvGetSeqNo(m_hCli);
}
//	クライアントのインデクス値取得
UI		CAjxSsvCli::GetIndex		()
{
	return AjcSsvGetIndex(m_hCli);
}
//	回線切断
BOOL	CAjxSsvCli::Disconnect		()
{
	return AjcSsvDisconnect(m_hCli);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数（クライアント処理）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	クライアント接続通知
VO	CAjxSsvCli::OnNtcConnect	()
{
}
//	クライアント切断通知
VO	CAjxSsvCli::OnNtcDisconnect	()
{
}
//	テキストチャンク受信通知(ASCII)
VO	CAjxSsvCli::OnNtcRxTextChunk(C_BCP pText)
{
}
//	テキストチャンク受信通知(UNICODE)
VO	CAjxSsvCli::OnNtcRxTextChunk(C_WCP pText)
{
}
//	バイナリチャンク受信通知
VO	CAjxSsvCli::OnNtcRxBinChunk	(C_VOP pData, UI Bytes)
{
}
//	テキスト受信通知(ASCII)
VO	CAjxSsvCli::OnNtcRxText		(C_BCP pText)
{
}
//	テキスト受信通知(UNICODE)
VO	CAjxSsvCli::OnNtcRxText		(C_WCP pText)
{
}
//	ＥＳＣシーケンス受信通知(ASCII)
VO	CAjxSsvCli::OnNtcRxEsc		(C_BCP pText)
{
}
//	ＥＳＣシーケンス受信通知(UNICODE)
VO	CAjxSsvCli::OnNtcRxEsc		(C_WCP pText)
{
}
//	制御コード受信通知
VO	CAjxSsvCli::OnNtcRxCtrl		(UI Ctrl)
{
}
//	パケット受信通知
VO	CAjxSsvCli::OnNtcRxPkt		(C_VOP pData, UI Bytes)
{
}
//	送信完了通知
VO	CAjxSsvCli::OnNtcTxEmpty	()
{
}
//	パケット外データ受信通知
VO	CAjxSsvCli::OnNtcRxNoPkt	(C_BCP pText)
{
}
//	パケット外データ受信通知
VO	CAjxSsvCli::OnNtcRxNoPkt	(C_WCP pText)
{
}
//	不正テキストチャンク受信通知
VO	CAjxSsvCli::OnNtcInvChunk	(C_VOP pData, UI lData)
{
}
//	受信エラー通知
VO	CAjxSsvCli::OnNtcRxError	(UI error)
{
}
//	送信エラー通知
VO	CAjxSsvCli::OnNtcTxError	(UI error)
{
}
