﻿#include	<AjxCpp.h>
using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ソケット通信（サーバ側）  サーバ処理																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//

extern	HINSTANCE	hDllInst;
static	ATOM		atmClass	= 0;

#define	WM_SSVEVENT	(WM_APP + 10)

AJC_WNDPROC_DEF(SsvEvtWndProc);
static	VO	SubCallVirtualFunc(CAjxSsvSvr* pSsvSvr, WPARAM wParam, LPARAM lParam);

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	起動時初期設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
BOOL	IniSsv(VO)
{
	BOOL		rc = FALSE;
	WNDCLASSA	wc = {0};

	wc.style		 = 0;								wc.hCursor		 = LoadCursor(NULL, IDC_ARROW); 
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(SsvEvtWndProc);	wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.cbWndExtra	 = sizeof(VOP);						wc.lpszClassName = "CAjxSsvEvtWnd";
	wc.hInstance	 = hDllInst;
	if ((atmClass = RegisterClassA(&wc)) != 0) {
		rc = TRUE;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	終了時後処理																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
VO		EndSsv(VO)
{
	if (atmClass != 0) {
		UnregisterClassA((BCP)atmClass, hDllInst);
		atmClass = 0;
	}
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＡＶＬノードデータ																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	CAjxSsvCli*		pCli;		//	クライアントクラスポインタ
} AVLNODE, *PAVLNODE;
typedef const AVLNODE *PCAVLNODE;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（接続中の全クライアント列挙）																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
BOOL  CALLBACK cbNtcClients (HAJCSSVCLI hCli, UX cbp)
{
	BOOL	rc = FALSE;
	CAjxSsvSvr* pSsvSvr = (CAjxSsvSvr*)cbp;
	PAVLNODE	pNode	= (PAVLNODE)AjcAvlGetNodePtr(pSsvSvr->GetAvl(), (UX)hCli, NULL);
	return pSsvSvr->OnNtcClients(hCli, pNode->pCli);
}

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSsvSvr::CAjxSsvSvr() 
{
	m_hSsv		= NULL;				//	ＳＳＶインスタンスドハンドル
	m_Atom		= 0;				//	イベント通知用クラスハンドル
	m_hWndEvt	= NULL;				//	イベント通知用ウインド
	m_fUnicode	= 0;				//	UNICODEフラグ

	//	イベント受信用ダミーウインド生成
	if ((m_hWndEvt = CreateWindowA( "CAjxSsvEvtWnd", 								// window class
									"",												// window caption
									WS_OVERLAPPEDWINDOW,							// window style
									0, 0, 0, 0, 									// position, size
									NULL, NULL, hDllInst, (VOP)this)) != NULL) {	// parent, menu, instance, param
		ShowWindow(m_hWndEvt, SW_HIDE);
		//	クライアントクラス格納用ＡＶＬ生成
		if ((m_hAvl = AjcAvlCreate((UX)this, NULL, NULL)) == NULL) {
			throw std::runtime_error("SSV - AVL cannot creation.");
		}
	}
	else throw std::runtime_error("SSV event window cannot creation.");
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxSsvSvr::~CAjxSsvSvr()
{
	if (m_hAvl	  != NULL) {AjcAvlDelete(m_hAvl);		m_hAvl	  = NULL;}
	if (m_hSsv	  != NULL) {AjcSsvDelete(m_hSsv);		m_hSsv	  = NULL;}
	if (m_hWndEvt != NULL) {DestroyWindow(m_hWndEvt);	m_hWndEvt = NULL;}
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	内部サブ関数																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	ＡＶＬハンドル取得
HAJCAVL		CAjxSsvSvr::GetAvl()
{
	return m_hAvl;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数（サーバ処理）																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	サーバ開始(ASCII)
BOOL	CAjxSsvSvr::Start	(C_BCP pPort, UI MaxClients, BOOL fUseWaitEvent, int AddressFamily)
{
	BOOL	rc = FALSE;

	//	UNICODE識別フラグ設定
	m_fUnicode = FALSE;

	//	最大クライアント数補正
	m_MaxClients = __max(MaxClients, 1);

	//	インデクス決め用マップテーブル生成
	UI	len = ((m_MaxClients / 32) + ((m_MaxClients % 32) != 0)) * sizeof(UI);
	if (m_pMap = (UIP)malloc(len)) {
		memset(m_pMap, 0, len);
		//	生成済ＳＳＶインスタンス消去
		if (m_hSsv != NULL) {
			AjcSsvDelete(m_hSsv);
		}
		//	ＳＳＶインスタンス生成
		if ((m_hSsv = AjcSsvCreate()) != NULL) {
			if (fUseWaitEvent) rc = AjcSsvStartA(m_hSsv, pPort, AddressFamily, m_MaxClients, NULL	  , 0		   );
			else			   rc = AjcSsvStartA(m_hSsv, pPort, AddressFamily, m_MaxClients, m_hWndEvt, WM_SSVEVENT);
		}
	}
	else throw std::runtime_error("SSV index-map-table cannot creation.");

	return rc;
}
//	サーバ開始(UNICODE)
BOOL	CAjxSsvSvr::Start	(C_WCP pPort,  UI MaxClients, BOOL fUseWaitEvent,int AddressFamily)
{
	BOOL	rc = FALSE;

	//	UNICODE識別フラグ設定
	m_fUnicode = TRUE;

	//	最大クライアント数補正
	m_MaxClients = __max(MaxClients, 1);

	//	インデクス決め用マップテーブル生成
	UI	len = ((m_MaxClients / 32) + ((m_MaxClients % 32) != 0)) * sizeof(UI);
	if (m_pMap = (UIP)malloc(len)) {
		memset(m_pMap, 0, len);
		//	生成済ＳＳＶインスタンス消去
		if (m_hSsv != NULL) {
			AjcSsvDelete(m_hSsv);
		}
		//	ＳＳＶインスタンス生成
		if ((m_hSsv = AjcSsvCreate()) != NULL) {
			if (fUseWaitEvent) rc = AjcSsvStartW(m_hSsv, pPort, AddressFamily, m_MaxClients, NULL	  , 0		   );
			else			   rc = AjcSsvStartW(m_hSsv, pPort, AddressFamily, m_MaxClients, m_hWndEvt, WM_SSVEVENT);
		}
	}
	else throw std::runtime_error("SSV index-map-table cannot creation.");

	return rc;
}
//	サーバ停止
BOOL	CAjxSsvSvr::Stop			()
{
	//	インデクス決め用マップテーブル消去
	if (m_pMap != NULL) {
		free(m_pMap);
	}
	return AjcSsvStop(m_hSsv, 10000);
}
//	オプションの設定
BOOL	CAjxSsvSvr::SetOpt			(AJCSSV_SERVOPT opt)
{
	return AjcSsvSetOpt(m_hSsv, opt);
}
//	オプションの取得
AJCSSV_SERVOPT	CAjxSsvSvr::GetOpt			()
{
	return AjcSsvGetOpt(m_hSsv);
}
//	チャンクデータの通知モード設定
BOOL	CAjxSsvSvr::SetChunkMode	(AJCSSV_CHUNKMODE ChunkMode)
{
	return AjcSsvSetChunkMode(m_hSsv, ChunkMode);
}
//	チャンクデータの通知モード取得
AJCSSV_CHUNKMODE	CAjxSsvSvr::GetChunkMode	()
{
	return AjcSsvGetChunkMode(m_hSsv);
}
//	イベントマスク設定
BOOL	CAjxSsvSvr::SetEvtMask		(UI EvtMsk)
{
	return AjcSsvSetEvtMask(m_hSsv, EvtMsk);
}
//	イベントマスク取得
UI		CAjxSsvSvr::GetEvtMask		()
{
	return AjcSsvGetEvtMask(m_hSsv);
}
//	受信テキストの文字コード設定
BOOL	CAjxSsvSvr::SetRxTextCode	(AJCSSV_TEXTCODE code)
{
	return AjcSsvSetRxTextCode(m_hSsv, code);
}
//	受信テキストの文字コード取得
AJCSSV_TEXTCODE	CAjxSsvSvr::GetRxTextCode	()
{
	return AjcSsvGetRxTextCode(m_hSsv);
}
//	送信テキストの文字コード設定
BOOL	CAjxSsvSvr::SetTxTextCode	(AJCSSV_TEXTCODE code)
{
	return AjcSsvSetTxTextCode(m_hSsv, code);
}
//	送信テキストの文字コード取得
AJCSSV_TEXTCODE	CAjxSsvSvr::GetTxTextCode	()
{
	return AjcSsvGetTxTextCode(m_hSsv);
}
//	イベント発生待ち
BOOL	CAjxSsvSvr::WaitEvent		(UI msTime)
{
	BOOL	rc = FALSE;
	WPARAM	wParam;
	LPARAM	lParam;
	if (rc = AjcSsvWaitEvent(m_hSsv, &wParam, &lParam, msTime)) {
		SubCallVirtualFunc(this, wParam, lParam);
	}
	return rc;
}
//	パケットフレームを認識する為の制御コード設定
BOOL	CAjxSsvSvr::SetPktCtrlCode	(UI stx, UI etx, UI dle)
{
	return AjcSsvSetPktCtrlCode(m_hSsv, stx, etx, dle);
}
//	パケットフレームを認識する為の制御コード取得
BOOL	CAjxSsvSvr::GetPktCtrlCode	(UIP pStx, UIP pEtx, UIP pDle)
{
	return AjcSsvGetPktCtrlCode(m_hSsv, pStx, pEtx, pDle);
}
//	パケットフレーム受信タイムアウト値設定
BOOL	CAjxSsvSvr::SetPktTimeout	(UI msTime)
{
	return AjcSsvSetPktTimeout(m_hSsv, msTime);
}
//	パケットフレーム受信タイムアウト値取得
BOOL	CAjxSsvSvr::GetPktTimeout	(UIP pMsTime)
{
	return AjcSsvGetPktTimeout(m_hSsv, pMsTime);
}
//	接続済のクライアント数取得
UI		CAjxSsvSvr::GetClientCount	()
{
	return AjcSsvGetClientCount(m_hSsv);
}
//	通算接続回数取得
UI		CAjxSsvSvr::GetConnectCount	()
{
	return AjcSsvGetConnectCount(m_hSsv);
}
//	接続済の全クライアント列挙
UI		CAjxSsvSvr::EnumClients		()
{
	UI		rc = 0;
	rc = AjcSsvEnumClients(m_hSsv, (UX)this, cbNtcClients);
	return rc;
}
//	クライアントにデータを関連付ける
BOOL	CAjxSsvSvr::SetClientData	(HAJCSSVCLI hCli, UX data)
{
	return AjcSsvSetClientData		(hCli, data);
}
//	クライアントに関連付けたデータ取得
UX		CAjxSsvSvr::GetClientData	(HAJCSSVCLI hCli)
{
	UX		rc = 0;
	AjcSsvGetClientData(hCli, &rc);
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数（サーバ処理）																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- サーバ開始通知 -----------------------------------------------------------------------------------------//
VO		CAjxSsvSvr::OnNtcStart				()
{
}
//----- サーバ停止通知 -----------------------------------------------------------------------------------------//
VO		CAjxSsvSvr::OnNtcStop				()
{
}
//----- エラー通知 ---------------------------------------------------------------------------------------------//
VO		CAjxSsvSvr::OnNtcError				(UI err)
{
}
//----- クライアント列挙 ---------------------------------------------------------------------------------------//
BOOL	CAjxSsvSvr::OnNtcClients			(HAJCSSVCLI hCli, CAjxSsvCli* pCli)
{
	return FALSE;	//	列挙中止
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数（クライアント処理）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//	クライアント接続通知
CAjxSsvCli*	CAjxSsvSvr::OnNtcConnect	(HAJCSSVCLI hCli)
{
	return NULL;
}
//	クライアント切断通知
VO	CAjxSsvSvr::OnNtcDisconnect	(HAJCSSVCLI hCli, CAjxSsvCli* pCli)
{
}
//	テキストチャンク受信通知(ASCII)
VO	CAjxSsvSvr::OnNtcRxTextChunk(HAJCSSVCLI hCli, C_BCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxTextChunk(pText);
	}
}
//	テキストチャンク受信通知(UNICODE)
VO	CAjxSsvSvr::OnNtcRxTextChunk(HAJCSSVCLI hCli, C_WCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxTextChunk(pText);
	}
}
//	バイナリチャンク受信通知
VO	CAjxSsvSvr::OnNtcRxBinChunk	(HAJCSSVCLI hCli, C_VOP pData, UI Bytes)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxBinChunk(pData, Bytes);
	}
}
//	テキスト受信通知(ASCII)
VO	CAjxSsvSvr::OnNtcRxText		(HAJCSSVCLI hCli, C_BCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxText(pText);
	}
}
//	テキスト受信通知(UNICODE)
VO	CAjxSsvSvr::OnNtcRxText		(HAJCSSVCLI hCli, C_WCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxText(pText);
	}
}
//	ＥＳＣシーケンス受信通知(ASCII)
VO	CAjxSsvSvr::OnNtcRxEsc		(HAJCSSVCLI hCli, C_BCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxEsc(pText);
	}
}
//	ＥＳＣシーケンス受信通知(UNICODE)
VO	CAjxSsvSvr::OnNtcRxEsc		(HAJCSSVCLI hCli, C_WCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxEsc(pText);
	}
}
//	制御コード受信通知
VO	CAjxSsvSvr::OnNtcRxCtrl		(HAJCSSVCLI hCli, UI Ctrl)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxCtrl(Ctrl);
	}
}
//	パケット受信通知
VO	CAjxSsvSvr::OnNtcRxPkt		(HAJCSSVCLI hCli, C_VOP pData, UI Bytes)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxPkt(pData, Bytes);
	}
}
//	送信完了通知
VO	CAjxSsvSvr::OnNtcTxEmpty	(HAJCSSVCLI hCli)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcTxEmpty();
	}
}
//	パケット外データ受信通知
VO	CAjxSsvSvr::OnNtcRxNoPkt	(HAJCSSVCLI hCli, C_BCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxNoPkt(pText);
	}
}
//	パケット外データ受信通知
VO	CAjxSsvSvr::OnNtcRxNoPkt	(HAJCSSVCLI hCli, C_WCP pText)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxNoPkt(pText);
	}
}
//	不正テキストチャンク受信通知
VO	CAjxSsvSvr::OnNtcInvChunk	(HAJCSSVCLI hCli, C_VOP pData, UI lData)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcInvChunk(pData, lData);
	}
}
//	受信エラー通知
VO	CAjxSsvSvr::OnNtcRxError	(HAJCSSVCLI hCli, UI error)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcRxError(error);
	}
}
//	送信エラー通知
VO	CAjxSsvSvr::OnNtcTxError	(HAJCSSVCLI hCli, UI error)
{
	PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(m_hAvl, (UX)hCli, NULL);
	if (pNode != NULL && pNode->pCli != NULL) {
		pNode->pCli->OnNtcTxError(error);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＳＳＶイベント用ウインドプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SsvEvtWndProc, WM_CREATE 	)
{
	CAjxSsvSvr* pSsvSvr = (CAjxSsvSvr*)(((LPCREATESTRUCT)lParam)->lpCreateParams);

	MAjcSetWindowLong(hwnd, 0, (UX)pSsvSvr);

	return TRUE;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SsvEvtWndProc, WM_DESTROY	)
{
	CAjxSsvSvr* pSsvSvr = (CAjxSsvSvr*)MAjcGetWindowLong(hwnd, 0);
	return 0;
}
//----- WM_SSVEVENT --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SsvEvtWndProc, WM_SSVEVENT	)
{
	CAjxSsvSvr* pSsvSvr = (CAjxSsvSvr*)MAjcGetWindowLong(hwnd, 0);
	SubCallVirtualFunc(pSsvSvr, wParam, lParam);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SsvEvtWndProc)
	AJC_WNDMAP_MSG(SsvEvtWndProc, WM_CREATE	)
	AJC_WNDMAP_MSG(SsvEvtWndProc, WM_DESTROY )
	AJC_WNDMAP_MSG(SsvEvtWndProc, WM_SSVEVENT)
AJC_WNDMAP_END

//----- イベント通知（仮想関数コール）--------------------------------------------------------------------------//
static	VO	SubCallVirtualFunc(CAjxSsvSvr* pSsvSvr, WPARAM wParam, LPARAM lParam)
{
	union	{VOP vop; BCP bcp; WCP wcp; UBP ubp; UWP uwp;} u;
	UI		len, param;
	UI		SeqNo;

	AjcSsvGetEventData(pSsvSvr->m_hSsv, lParam, &u.vop, &len, &param);

	//----------------------------------------------------------------------------------------------------------//
	//	サーバ イベント																							//
	//----------------------------------------------------------------------------------------------------------//
	//	●サーバ開始通知
	if		((wParam & AJCSSV_EV_START) != 0) {
		pSsvSvr->OnNtcStart();
	}
	//	●サーバ停止通知
	else if ((wParam & AJCSSV_EV_STOP) != 0) {
		pSsvSvr->OnNtcStop();
	}
	//	●エラー通知
	else if ((wParam & AJCSSV_EV_ERR) != 0) {
		pSsvSvr->OnNtcError(param);
	}
	else {
		//------------------------------------------------------------------------------------------------------//
		//	クライアント イベント																				//
		//------------------------------------------------------------------------------------------------------//
		HAJCSSVCLI	hCli = NULL;
		if (SeqNo = AjcSsvGetClient(pSsvSvr->m_hSsv, lParam, &hCli)) {	//	クライアントハンドル取得
			//	●クライアント接続通知
			if ((wParam & AJCSSV_EV_CONNECT) != 0) {
				//	クライアント接続通知
				CAjxSsvCli* pCli = pSsvSvr->OnNtcConnect(hCli);
				//	クライアント情報登録
				AVLNODE	node = {NULL};
				node.pCli = pCli;
				AjcAvlInsNode(pSsvSvr->GetAvl(), (UX)hCli, (C_VOP)&node, sizeof node);
				//	クライアントクラスへ接続通知
				if (pCli != NULL) {
					pCli->OnNtcConnect();
				}
			}
			//	●クライアント切断通知
			if	((wParam & AJCSSV_EV_DISCONNECT) != 0) {
				//	クライアントクラスポインタ取得
				CAjxSsvCli* pCli  = NULL;
				PAVLNODE	pNode = (PAVLNODE)AjcAvlGetNodePtr(pSsvSvr->GetAvl(), (UX)hCli, NULL);
				if (pNode != NULL) {
					pCli = pNode->pCli;
					//	クライアントクラスへ切断通知
					if (pCli != NULL) {
						pCli->OnNtcDisconnect();
					}
				}
				//	クライアント切断通知
				pSsvSvr->OnNtcDisconnect(hCli, pCli);
				//	ＡＶＬから当該クライアントノード削除
				AjcAvlDelNode(pSsvSvr->GetAvl(), (UX)hCli);
			}
			//	●チャンクデータ受信通知
			else if ((wParam & AJCSSV_EV_RXCHUNK) != 0) {
				if		(param == 0) pSsvSvr->OnNtcRxBinChunk (hCli, u.vop, len);
				else if (param == 1) pSsvSvr->OnNtcRxTextChunk(hCli, u.bcp);
				else				 pSsvSvr->OnNtcRxTextChunk(hCli, u.wcp);
			}
			//	●テキストデータ通知
			else if ((wParam & AJCSSV_EV_RXTEXT	) != 0) {
				if (param == 1) pSsvSvr->OnNtcRxText(hCli, u.bcp);
				else			pSsvSvr->OnNtcRxText(hCli, u.wcp);
			}
			//	●ＥＳＣコードデータ通知
			else if ((wParam & AJCSSV_EV_RXESC	) != 0) {
				if (param == 1) pSsvSvr->OnNtcRxEsc(hCli, u.bcp);
				else			pSsvSvr->OnNtcRxEsc(hCli, u.wcp);
			}
			//	●パケットデータ通知
			else if ((wParam & AJCSSV_EV_RXPKT	) != 0) {
				pSsvSvr->OnNtcRxBinChunk (hCli, u.vop, len);
			}
			//	●制御コード通知
			else if ((wParam & AJCSSV_EV_RXCTRL	) != 0) {
				if (param == 1) pSsvSvr->OnNtcRxCtrl(hCli, (UI)*u.bcp);
				else			pSsvSvr->OnNtcRxCtrl(hCli, (UI)*u.wcp);
			}
			//	●パケット外テキスト
			else if ((wParam & AJCSSV_EV_RXNOPKT) != 0) {
				if (param == 1) pSsvSvr->OnNtcRxNoPkt(hCli, u.bcp);
				else			pSsvSvr->OnNtcRxNoPkt(hCli, u.wcp);
			}
			//	●不正チャンクテキスト受信通知
			else if ((wParam & AJCSSV_EV_INVCHUNK) != 0) {
				pSsvSvr->OnNtcInvChunk(hCli, u.vop, len);
			}
			//	●送信完了通知
			else if ((wParam & AJCSSV_EV_TXEMPTY) != 0) {
				pSsvSvr->OnNtcTxEmpty(hCli);
			}
			//	●受信エラー通知
			else if ((wParam & AJCSSV_EV_RXERR	) != 0) {
				pSsvSvr->OnNtcRxError(hCli, param);
			}
			//	●送信エラー通知
			else if ((wParam & AJCSSV_EV_TXERR	) != 0) {
				pSsvSvr->OnNtcTxError(hCli, param);
			}
		}
	}

	AjcSsvRelEventData(pSsvSvr->m_hSsv, lParam);
}
