﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcTchSubClassed_"
#define	PROP_NAME_CTRL		"_AjcTchWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_TCH, WM_COMMAND			)
{
	CAjxTch*	p = (CAjxTch*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);

	if (p != NULL) {
		switch (HIWORD(wParam)) {
			case	AJCTCN_RANGE:		p->OnNtcRange	(AjcTchGetNtcRng   ((HWND)lParam));	break;	//	グラフレンジ通知
			case	AJCTCN_SCRPOS:		p->OnNtcScrPos	(AjcTchGetNtcScrPos((HWND)lParam));	break;	//	スクロール位置通知
			case	AJCTCN_CLEAR:		p->OnNtcClear	();									break;	//	データクリアー通知
			case	AJCTCN_DBLCLK:		p->OnNtcDblClk	();									break;	//	ダブルクリック通知
			case	AJCTCN_DROPFILE:	p->OnNtcDropFile(AjcTchGetNtcFiles ((HWND)lParam));	break;	//	ファイルドロップ通知
			case	AJCTCN_DROPDIR:		p->OnNtcDropDir (AjcTchGetNtcDirs  ((HWND)lParam));	break;	//	フォルダドロップ通知
			case	AJCTCN_RCLICK:		p->OnNtcRClick	(AjcTchGetNtcRClk  ((HWND)lParam));	break;	//	右クリック通知
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_TCH);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_TCH, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_TCH);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_TCH)
	AJC_WNDMAP_MSG(SBC_TCH, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_TCH, WM_DESTROY	   )
AJC_WNDMAP_END


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxTch::CAjxTch() 
{
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxTch::~CAjxTch()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- 停止 ---------------------------------------------------------------------------------------------------//
BOOL	CAjxTch::Stop					()
{
	BOOL	rc = AjcTchStop(m_hCtrl);
	return rc;
}
//----- 開始 ---------------------------------------------------------------------------------------------------//
BOOL	CAjxTch::Start					()
{
	BOOL	rc = AjcTchStart(m_hCtrl);
	return rc;
}
//----- クリアー -----------------------------------------------------------------------------------------------//
BOOL	CAjxTch::Purge					()
{
	BOOL	rc = AjcTchPurge(m_hCtrl);
	return rc;
}
//----- 実数データ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::PutData				(double dat[])
{
	BOOL	rc = AjcTchPutRealData(m_hCtrl, dat);
	return rc;
}
BOOL	CAjxTch::PutData(double d0						) {double d[AJCTC_MAXITEM]={0}; d[0] = d0;						 return PutData(d);}
BOOL	CAjxTch::PutData(double d0, double d1			) {double d[AJCTC_MAXITEM]={0}; d[0] = d0; d[1] = d1;			 return PutData(d);}
BOOL	CAjxTch::PutData(double d0, double d1, double d2) {double d[AJCTC_MAXITEM]={0}; d[0] = d0; d[1] = d1; d[2] = d2; return PutData(d);}
//----- 整数データ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::PutData				(int	dat[])
{
	BOOL	rc = AjcTchPutIntData(m_hCtrl, dat);
	return rc;
}
BOOL	CAjxTch::PutData(int d0 			   ) {int d[AJCTC_MAXITEM]={0}; d[0] = d0;						 return PutData(d);}
BOOL	CAjxTch::PutData(int d0, int d1 	   ) {int d[AJCTC_MAXITEM]={0}; d[0] = d0; d[1] = d1;			 return PutData(d);}
BOOL	CAjxTch::PutData(int d0, int d1, int d2) {int d[AJCTC_MAXITEM]={0}; d[0] = d0; d[1] = d1; d[2] = d2; return PutData(d);}
//----- 外枠表示 -----------------------------------------------------------------------------------------------//
BOOL	CAjxTch::ShowBorder				(BOOL fShow, COLORREF rgb)
{
	BOOL	rc = AjcTchShowBorder(m_hCtrl, fShow, rgb);
	return rc;
}
//----- フィルタ表示 -------------------------------------------------------------------------------------------//
BOOL	CAjxTch::ShowFilter				(BOOL fShow)
{
	BOOL	rc = AjcTchShowFilter(m_hCtrl, fShow);
	return rc;
}
//----- スケール表示 -------------------------------------------------------------------------------------------//
BOOL	CAjxTch::ShowScale 				(BOOL fLine, BOOL fValue)
{
	BOOL	rc = AjcTchShowScale(m_hCtrl, fLine, fValue);
	return rc;
}
	
//----- プロパティ取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::GetProp				(PAJCTCPROP	pBuf)
{
	BOOL	rc = AjcTchGetProp(m_hCtrl, pBuf);
	return rc;
}
//----- プロパティ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetProp				(PCAJCTCPROP pProp)
{
	BOOL	rc = AjcTchSetProp(m_hCtrl, pProp);
	return rc;
}
	
//----- 実数レンジ取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::GetRange				(double *low, double *high)
{
	BOOL	rc = AjcTchGetRealRange(m_hCtrl, low, high);
	return rc;
}
//----- 整数レンジ取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::GetRange				(int	*low, int	*high)
{
	BOOL	rc = AjcTchGetIntRange(m_hCtrl, low, high);
	return rc;
}
//----- 実数レンジ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetRange				(double	low, double  high)
{
	BOOL	rc = AjcTchSetRealRange(m_hCtrl, low, high);
	return rc;
}
//----- 整数レンジ設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetRange				(int 	low, int	 high)
{
	BOOL	rc = AjcTchSetIntRange(m_hCtrl, low, high);
	return rc;
}
//----- レンジ自動調整 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::AdjustRange			()
{
	BOOL	rc = AjcTchAdjustRange(m_hCtrl);
	return rc;
}
//----- バッファサイズ設定 -------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetBufSize				(int n)
{
	BOOL	rc = AjcTchSetBufSize(m_hCtrl, n);
	return rc;
}
//----- データ項目数設定 ---------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetItemNumber			(int n)
{
	BOOL	rc = AjcTchSetItemNumber(m_hCtrl, n);
	return rc;
}
//----- 平均化個数設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetAveNumber			(int n)
{
	BOOL	rc = AjcTchSetAveNumber(m_hCtrl, n);
	return rc;
}
//----- タイムスケール幅設定 -----------------------------------------------------------------------------------//
BOOL	CAjxTch::SetTimeScale			(int n)
{
	BOOL	rc = AjcTchSetTimeScale(m_hCtrl, n);
	return rc;
}
	
//----- ビットマップ取得 ---------------------------------------------------------------------------------------//
HBITMAP	CAjxTch::GetBitmap 				()
{
	HBITMAP	rc = AjcTchGetBitmap(m_hCtrl);
	return rc;
}
	
//----- プロファイルから永続情報読み出し（項目指定, ASCII）-----------------------------------------------------//
BOOL	CAjxTch::LoadPermInfo			(C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem)
{
	BOOL	rc = AjcTchLoadPermInfoExA(m_hCtrl, pProfileSect, pKeyPrefix, PermItem);
	return rc;
}
//----- プロファイルから永続情報読み出し（項目指定, UNICODE）---------------------------------------------------//
BOOL	CAjxTch::LoadPermInfo			(C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem)
{
	BOOL	rc = AjcTchLoadPermInfoExW(m_hCtrl, pProfileSect, pKeyPrefix, PermItem);
	return rc;
}
	
//----- プロファイルへ永続情報書き込み -------------------------------------------------------------------------//
BOOL	CAjxTch::SavePermInfo			()
{
	BOOL	rc = AjcTchSavePermInfo(m_hCtrl);
	return rc;
}

//----- プロファイルからプロパティ読み出し(ASCII) --------------------------------------------------------------//
BOOL	CAjxTch::LoadProp 				(C_BCP pProfileSect, PCAJCTCPROP pDefProp)
{
	BOOL	rc = AjcTchLoadPropA(m_hCtrl, pProfileSect, pDefProp);
	return rc;
}

//----- プロファイルからプロパティ読み出し(UNICODE) ------------------------------------------------------------//
BOOL	CAjxTch::LoadProp 				(C_WCP pProfileSect, PCAJCTCPROP pDefProp )
{
	BOOL	rc = AjcTchLoadPropW(m_hCtrl, pProfileSect, pDefProp);
	return rc;
}

//----- プロファイルへプロパティ書き込み(ASCII) ----------------------------------------------------------------//
BOOL	CAjxTch::SaveProp 				(C_BCP pProfileSect)
{
	BOOL	rc = AjcTchSavePropA(m_hCtrl, pProfileSect);
	return rc;
}

//----- プロファイルへプロパティ書き込み(UNICODE) --------------------------------------------------------------//
BOOL	CAjxTch::SaveProp 				(C_WCP pProfileSect)
{
	BOOL	rc = AjcTchSavePropW(m_hCtrl, pProfileSect);;
	return rc;
}

//----- プロファイルからプロパティ，フィルタ設定，ウインドスタイル読み出し(ASCII) ------------------------------//
BOOL	CAjxTch::LoadPropEx				(C_BCP pProfileSect, PCAJCTCPROP pDefProp)
{
	BOOL	rc = AjcTchLoadPropExA(m_hCtrl, pProfileSect, pDefProp);
	return rc;
}

//----- プロファイルからプロパティ，フィルタ設定，ウインドスタイル読み出し(UNICODE) ----------------------------//
BOOL	CAjxTch::LoadPropEx				(C_WCP pProfileSect, PCAJCTCPROP pDefProp)
{
	BOOL	rc = rc = AjcTchLoadPropExW(m_hCtrl, pProfileSect, pDefProp);
	return rc;
}

//----- プロファイルへプロパティ，フィルタ設定，ウインドスタイル書き込み(ASCII) --------------------------------//
BOOL	CAjxTch::SavePropEx				(C_BCP pProfileSect)
{
	BOOL	rc = AjcTchSavePropExA(m_hCtrl, pProfileSect);
	return rc;
}

//----- プロファイルへプロパティ，フィルタ設定，ウインドスタイル書き込み(UNICODE) ------------------------------//
BOOL	CAjxTch::SavePropEx				(C_WCP pProfileSect)
{
	BOOL	rc = AjcTchSavePropExW(m_hCtrl, pProfileSect);
	return rc;
}

//----- 右クリックによるポップアップメニューの許可／禁止 -------------------------------------------------------//
BOOL	CAjxTch::EnablePopupMenu		(BOOL fEnable)
{
	BOOL	rc = AjcTchEnablePopupMenu(m_hCtrl, fEnable);
	return rc;
}

//----- 右クリック通知設定 -------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetNtcRClk				(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	BOOL	rc = AjcTchSetNtcRClk(m_hCtrl, fNtcRClk, MsgRBDown, MsgRBUp);
	return rc;
}

//----- ツールチップ・テキスト設定(ASCII) ----------------------------------------------------------------------//
BOOL	CAjxTch::SetTipText				(C_BCP pTxt)
{
	BOOL	rc = AjcTchSetTipTextA(m_hCtrl, pTxt);
	return rc;
}

//----- ツールチップ・テキスト設定(UNICODE) --------------------------------------------------------------------//
BOOL	CAjxTch::SetTipText				(C_WCP pTxt)
{
	BOOL	rc = AjcTchSetTipTextW(m_hCtrl, pTxt);
	return rc;
}

//----- ツールチップ・テキスト取得(ASCII) ----------------------------------------------------------------------//
BOOL	CAjxTch::GetTipText				(BCP pBuf, UI lBuf)
{
	BOOL	rc = AjcTchGetTipTextA(m_hCtrl, pBuf, lBuf);
	return rc;
}
//----- ツールチップ・テキスト取得(UNICODE) --------------------------------------------------------------------//
BOOL	CAjxTch::GetTipText				(WCP pBuf, UI lBuf)
{
	BOOL	rc = AjcTchGetTipTextW(m_hCtrl, pBuf, lBuf);
	return rc;
}
	
//----- ツールチップ・テキスト表示条件設定 ---------------------------------------------------------------------//
BOOL	CAjxTch::SetTipShowAlways		(BOOL fShowAlways)
{
	BOOL	rc = AjcTchSetTipShowAlways(m_hCtrl, fShowAlways);
	return rc;
}
//----- ツールチップ・テキスト表示条件取得 ---------------------------------------------------------------------//
BOOL	CAjxTch::GetTipShowAlways		()
{
	BOOL	rc = AjcTchGetTipShowAlways(m_hCtrl);
	return rc;
}
	
//----- フィィルタ（チェックボックス）のツールチップ・テキスト表示条件設定 -------------------------------------//
BOOL	CAjxTch::SetChkBoxTipShowAlways	(UI n, BOOL fShowAlways)
{
	BOOL	rc = AjcTchSetChkBoxTipShowAlways(m_hCtrl, n, fShowAlways);
	return rc;
}
//----- フィィルタ（チェックボックス）のツールチップ・テキスト表示条件取得 -------------------------------------//
BOOL	CAjxTch::GetChkBoxTipShowAlways	(UI n)
{
	BOOL	rc = AjcTchGetChkBoxTipShowAlways(m_hCtrl, n);
	return rc;
}
	
//----- 全てのツールチップ・テキスト表示条件設定 ---------------------------------------------------------------//
BOOL	CAjxTch::SetTipShowAlwaysAll	(BOOL fShowAlways)
{
	BOOL	rc = AjcTchSetTipShowAlwaysAll(m_hCtrl, fShowAlways);
	return rc;
}
	
//----- フィィルタ（チェックボックス）のツールチップ・テキスト設定(ASCII) --------------------------------------//
BOOL	CAjxTch::SetChkBoxTipText		(UI n, C_BCP pTxt)
{
	BOOL	rc = AjcTchSetChkBoxTipTextA(m_hCtrl, n, pTxt);
	return rc;
}
//----- フィィルタ（チェックボックス）のツールチップ・テキスト設定(UNICODE) ------------------------------------//
BOOL	CAjxTch::SetChkBoxTipText		(UI n, C_WCP pTxt)
{
	BOOL	rc = AjcTchSetChkBoxTipTextW(m_hCtrl, n, pTxt);
	return rc;
}
	
//----- フィィルタ（チェックボックス）のツールチップ・テキスト取得(ASCII) --------------------------------------//
BOOL	CAjxTch::GetChkBoxTipText		(UI n, BCP pBuf, UI lBuf)
{
	BOOL	rc = AjcTchGetChkBoxTipTextA(m_hCtrl, n, pBuf, lBuf);
	return rc;
}
//----- フィィルタ（チェックボックス）のツールチップ・テキスト取得(UNICODE) ------------------------------------//
BOOL	CAjxTch::GetChkBoxTipText		(UI n, WCP pBuf, UI lBuf)
{
	BOOL	rc = AjcTchGetChkBoxTipTextW(m_hCtrl, n, pBuf, lBuf);
	return rc;
}
	
//----- 最大結線長設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetMaxLineDist			(double MaxLineDist)
{
	BOOL	rc = AjcTchSetMaxLineDist(m_hCtrl, MaxLineDist);
	return rc;
}
//----- 最大結線長取得 -----------------------------------------------------------------------------------------//
double	CAjxTch::GetMaxLineDist			()
{
	double	rc = AjcTchGetMaxLineDist(m_hCtrl);
	return rc;
}
	
//----- スクロール位置の取得 -----------------------------------------------------------------------------------//
int		CAjxTch::GetScrollPos			()
{
	BOOL	rc = AjcTchGetScrollPos(m_hCtrl);
	return rc;
}
//----- スクロール位置の設定 -----------------------------------------------------------------------------------//
BOOL	CAjxTch::SetScrollPos			(int pos)
{
	BOOL	rc = AjcTchSetScrollPos(m_hCtrl, pos);
	return rc;
}
	
//----- フィルタの設定 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetFilter 				(UI n, BOOL state)
{
	BOOL	rc = AjcTchSetFilter(m_hCtrl, n, state);
	return rc;
}
//----- フィルタの取得 -----------------------------------------------------------------------------------------//
BOOL	CAjxTch::GetFilter 				(UI n)
{
	BOOL	rc = AjcTchGetFilter(m_hCtrl, n);
	return rc;
}
	
//----- 横線（属性の設定）--------------------------------------------------------------------------------------//
BOOL	CAjxTch::SetHLineAtt			(UI id, COLORREF color, int width, int style)
{
	BOOL	rc = AjcTchSetHLineAtt(m_hCtrl, id, color, width, style);
	return rc;
}
//----- 横線（描画位置の設定）----------------------------------------------------------------------------------//
BOOL	CAjxTch::SetHLinePos			(UI id, double pos)
{
	BOOL	rc = AjcTchSetHLinePos(m_hCtrl, id, pos);
	return rc;
}
//----- 横線（描画の許可／禁止）--------------------------------------------------------------------------------//
BOOL	CAjxTch::EnableHLine			(UI id, BOOL fEnable)
{
	BOOL	rc = AjcTchEnableHLine(m_hCtrl, id, fEnable);
	return rc;
}
	
//----- 縦線描画（最後に格納したデータの位置に縦線を描画する）--------------------------------------------------//
BOOL	CAjxTch::SetVLine				(COLORREF color, int width, int style)
{
	BOOL	rc = AjcTchSetVLine(m_hCtrl, color, width, style);
	return rc;
}
//----- 縦線描画の許可／禁止 -----------------------------------------------------------------------------------//
BOOL	CAjxTch::EnableVLine			(BOOL fEnable)
{
	BOOL	rc = AjcTchEnableVLine(m_hCtrl, fEnable);
	return rc;
}
	
//----- プロット点描画（最後に格納したデータの位置にプロット点（円）を描画する）--------------------------------//
BOOL	CAjxTch::SetPoint				(int r)	
{
	BOOL	rc = AjcTchSetPoint(m_hCtrl, r);
	return rc;
}
//----- プロット点描画の許可／禁止 -----------------------------------------------------------------------------//
BOOL	CAjxTch::EnablePoint			(BOOL fEnable)
{
	BOOL	rc = AjcTchEnablePoint(m_hCtrl, fEnable);
	return rc;
}
	
//----- ドロップされたファイル名取得(ASCII) --------------------------------------------------------------------//
BOOL	CAjxTch::GetDroppedFile			(BC buf[MAX_PATH])
{
	BOOL	rc = AjcTchGetDroppedFileA(m_hCtrl, buf);
	return rc;
}
//----- ドロップされたファイル名取得(UNICODE) ------------------------------------------------------------------//
BOOL	CAjxTch::GetDroppedFile			(WC buf[MAX_PATH])
{
	BOOL	rc = AjcTchGetDroppedFileW(m_hCtrl, buf);
	return rc;
}
	
//----- ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き）(ASCII) ------------------------------------//
BOOL	CAjxTch::GetDroppedDir		  (BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL	rc = AjcTchGetDroppedDirExA(m_hCtrl, buf, fTailIsDelimiter);
	return rc;
}
//----- ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き, UNICODE）-----------------------------------//
BOOL	CAjxTch::GetDroppedDir		  (WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL	rc = AjcTchGetDroppedDirExW(m_hCtrl, buf, fTailIsDelimiter);
	return rc;
}
	
//----- タイトル文字列の設定(ASCII) ----------------------------------------------------------------------------//
BOOL	CAjxTch::SetTitleText			(C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	BOOL	rc = AjcTchSetTitleTextA(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
	return rc;
}
//----- タイトル文字列の設定(UNICODE) --------------------------------------------------------------------------//
BOOL	CAjxTch::SetTitleText			(C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	BOOL	rc = AjcTchSetTitleTextW(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
	return rc;
}
//----- 波形補間表示情報の設定 ---------------------------------------------------------------------------------//
BOOL	CAjxTch::SetIpInfo				(PCAJCTCIPINFO pInfo)
{
	BOOL	rc = AjcTchSetIpInfo(m_hCtrl, pInfo);
	return rc;
}
//----- 波形補間表示情報の取得 ---------------------------------------------------------------------------------//
BOOL	CAjxTch::GetIpInfo				(PAJCTCIPINFO  pBuf )
{
	BOOL	rc = AjcTchGetIpInfo(m_hCtrl, pBuf);
	return rc;
}
	
//----- 表示の停止／再開 ---------------------------------------------------------------------------------------//
BOOL	CAjxTch::Pause					(BOOL fPause)
{
	BOOL	rc = AjcTchPause(m_hCtrl, fPause);
	return rc;
}
	
//----- 描画時間計測情報の許可／禁止 ---------------------------------------------------------------------------//
BOOL	CAjxTch::EnableMesDraw			(BOOL fEnable)
{
	BOOL	rc = AjcTchEnableMesDraw(m_hCtrl, fEnable);
	return rc;
}
	
//----- プロット周期計測情報表示／非表示の設定 -----------------------------------------------------------------//
BOOL	CAjxTch::MesPeriShow			(BOOL fShow)
{
	BOOL	rc = AjcTchMesPeriShow(m_hCtrl, fShow);
	return rc;
}
//----- プロット周期計測情報リセット ---------------------------------------------------------------------------//
BOOL	CAjxTch::MesPeriReset			()
{
	BOOL	rc = AjcTchMesPeriReset(m_hCtrl);
	return rc;
}
//----- テキスト描画フォント設定 -------------------------------------------------------------------------------//
HFONT	CAjxTch::SetTextFont	(HFONT hFont)
{
	return AjcTchSetTextFont	(m_hCtrl, hFont);
}
//----- テキスト描画（ピクセル位置指定）(ASCII) ----------------------------------------------------------------//
UI		CAjxTch::TextOut		(int x, int y, C_BCP pTxt)
{
	return AjcTchTextOutA		(m_hCtrl, x, y, pTxt);
}
//----- テキスト描画（ピクセル位置指定）(UNICODE) --------------------------------------------------------------//
UI		CAjxTch::TextOut		(int x, int y, C_WCP pTxt)
{
	return AjcTchTextOutW		(m_hCtrl, x, y, pTxt);
}
//----- 書式テキスト描画（ピクセル位置指定）(ASCII) ------------------------------------------------------------//
UI		CAjxTch::PrintF			(int x, int y, C_BCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2046, pFmt, vls);
		va_end	(vls);
		rc = AjcTchTextOutA(m_hCtrl, x, y, buf);
	}
	return rc;
}
//----- 書式テキスト描画（ピクセル位置指定）(UNICODE) ----------------------------------------------------------//
UI		CAjxTch::PrintF			(int x, int y, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcTchTextOutW(m_hCtrl, x, y, buf);
	}
	return rc;
}
//----- 描画テキスト取得(ASCII) --------------------------------------------------------------------------------//
UI		CAjxTch::GetText		(UI key, BCP pBuf, UI lBuf)
{
	return AjcTchGetTextA		(m_hCtrl, key, pBuf, lBuf);
}
//----- 描画テキスト取得(UNICODE) ------------------------------------------------------------------------------//
UI		CAjxTch::GetText		(UI key, WCP pBuf, UI lBuf)
{
	return AjcTchGetTextW		(m_hCtrl, key, pBuf, lBuf);
}
//----- 描画テキストクリアー -----------------------------------------------------------------------------------//
BOOL	CAjxTch::ClearText		(UI key)
{
	return AjcTchClearText		(m_hCtrl, key);
}
//-----  全ての描画テキストクリアー ----------------------------------------------------------------------------//
BOOL	CAjxTch::ClearText		()
{
	return AjcTchClearAllText	(m_hCtrl);
}
//-----  全てのデータとテキストクリアー ------------------------------------------------------------------------//
BOOL	CAjxTch::Clear			()
{
	return AjcTchClear			(m_hCtrl);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxTch::Attach(HWND hwnd)
{
	HWND	hParent;
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hwnd)) {
		::GetClassNameA(hwnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrlTmChart") == 0) {
			//	ワーク初期化
			m_hCtrl = hwnd;
			hParent = ::GetParent(hwnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_TCH, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("TCH cannot be generated due to an invalid wind class.");
	}
	else throw std::runtime_error("TCH cannot be generated due to an invalid window handle.");
}
//----- グラフレンジ通知 ---------------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcRange		(PCAJCTC_NTC_RANGE pRange)
{
}
//----- スクロール位置通知 -------------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcScrPos	(UI 			  ScrPos)
{
}
//----- データクリアー通知 -------------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcClear		()
{
}
//----- ダブルクリック通知 -------------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcDblClk	()
{
}
//----- ファイルドロップ通知 -----------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcDropFile	(UI 			  nFiles)
{
}
//----- フォルダドロップ通知 -----------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcDropDir	(UI 			  nDirs )
{
}
//----- 右クリック通知 -----------------------------------------------------------------------------------------//
VO	CAjxTch::OnNtcRClick	(PCAJCTCRCLK 	  pRClk )
{
}
